
read "CoreDefs.asm"

limit &E00	
org &50


;
;Rastercolor buffer - 80 bytes (&50
RasterColors_ColorArray1:
	defb 1
	defb 1
	defb 64+20,64+24,64+29,64+11	 :IlluminatedPaletteA_Plus2
RasterColors_ColorArray2:
	defb 1
	defb 1

	defb 64+20,64+12,64+13,64+11	:IlluminatedPaletteB_Plus2
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 12
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+24,64+29,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray3:
	defb 1
	defb 1
	defb 64+20,64+12,64+13,64+11 :IlluminatedPaletteC_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
RasterColors_ColorArray4:
	defb 1
	defb 1 
	defb 64+20,64+31,64+14,64+11 :IlluminatedPaletteD_Plus2
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11
	defb 0
	defb 64+20,64+12,64+13,64+11
	defb 0
	defb 64+20,64+31,64+14,64+11



align 256,&00
StarArraySize equ 255
StarArrayPointer: 	
defs StarArraySize*3,&00


ObjectArraySize equ 60
PlayerStarArraySize equ 36

align 256,&00
PlayerStarArrayPointer: 
defs 64,&00
ObjectArrayPointer:
defs 64,&00
align 256,&00
defs 255*5,&00

;defs ObjectArraySize*6,&00
;defs PlayerStarArraySize*3,&00

;align 256,&00

	

Event_SavedSettings:
defs 4*16,&00


RasterColors_ColorArray1Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteAAlt_Plus2
RasterColors_ColorArray2Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteBAlt_Plus2
RasterColors_ColorArray3Alt:
	defb 1
	defb 1
	defb &54,&54,&54,&54		 :IlluminatedPaletteCAlt_Plus2
RasterColors_ColorArray4Alt:
	defb 1
	defb 1 
	defb &54,&54,&54,&54		 :IlluminatedPaletteDAlt_Plus2



CustomRam:
defs 64 ;  Pos-Tick-Pos-Tick ; enough memory for 16 enemies!


limit &4000
org &E00	

;org &1000
;incbin "Sprites\PLAYER.SPR"

org &1B00
LevelSprites:
incbin "Sprites\LEVEL2.SPR"





limit &3ff0
org &3900

evtSettingsBank_Save equ %10010000+15
evtSettingsBank_Load equ %10010000+0
evtMultipleCommands equ %01110000

evtAddToForeground equ 135
evtAddToBackground equ 134
evtJumpToNewTime   equ 136
evtCallAddress	   equ 137
evtSetMoveLife     equ 128
evtSetProg	   equ 129
evtSetLife	   equ 130
evtSetMove	   equ 131
evtSetProgMoveLife equ 132
evtSetSprite	   equ 133

evtReprogramCustomMove1 equ %11110100
evtReprogramCustomMove2 equ %11110101
evtReprogram_PowerupSprites equ %11110110

evtSingleSprite equ 0

prgSpecial	equ 2
prgBonus 	equ 3
prgMovePlayer	equ 4
prgFireSnail	equ %10000000
prgFireSlow	equ %01100000
prgFireMid	equ %01000000
prgFireMid2	equ %11000000
prgFireFast	equ %00100000


mveStatic 	equ &24
mveSeaker	equ %10000100
mveWave		equ %10100000
mveWaveSmall	equ %10010000
mveCustom1	equ %11110000

lifEnemy	equ %11000000	;HurtByBullets,Hurts Player
lifTimed	equ %00000000	;Doesnt hurt, dies automatically
lifDeadly	equ %01000000	;Deadly and cant be shot
TwoFrameSprite  equ 128



EventStreamArray:

;defb 1,128,&24,128+64+60		; Move Static



defb 0,evtReprogram_PowerupSprites,128+99,128+99,128+99, 21+128+10	; Define powerup sprites

defb 0,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		



; Define the background

defb 0,240+1,0,41				; (Time,Cmd,Off,Bytes) Load 41 bytes into the background - 41 bytes is the limit

defb &F0,&F0	;1; first line
defb 196,&D0	;2; line num, New byte
defb 190,&70	;3
defb 186,&A0	;4
defb 180,&50	;5
defb 176,&80	;6
defb 170,&20	;7
defb 166,&00	;8
defb 160,&00	;9
defb 36,&20	;10
defb 32,&80	;11
defb 28,&50	;12
defb 24,&A0	;13
defb 20,&70	;14
defb 16,&D0	;15
defb 12,&69	;16
defb 10,&2D	;17
defb 08,&2F	;18
defb 06,&8f	;19
defb 02,&0F	;20
defb 255

;We will use 4 Paralax layers
; ---------()- (sky)		%11001000
; ------------ (Far)		%11000100
; -----X---X-- (mid)		%11000010	Bank 1
; []=====[]=== (foreground) 	%11000001	Bank 0



defb 0,%11110010				;Install a custom hit handler
defw CustomObjectHitHandler


; Background L
defb 0,128+4,1,%11000001,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,%10010000+15,0				; Save Object settings to Bank 0

defb 0,128+4,1,%11000010,0			; Program - Bitshift Sprite... Move - dir Left Slow ... Life - immortal
defb 0,%10010000+15,1				; Save Object settings to Bank 1


; Hand Up
defb 0,%01110000+2			; 3 commands at the same timepoint
defb 	128+4,0,&4C,%11000000+6	; Program -None... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	%10010000+15,3	

; Hand Down
defb 0,%01110000+2			; 3 commands at the same timepoint
defb 	128+4,0,&7C,%11000000+6	; Program -None... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	%10010000+15,4	



; Hand left
defb 0,%01110000+2			; 3 commands at the same timepoint
defb 	128+4,0,&61,%11000000+6	; Program -None... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	%10010000+15,5	

; Hand right
defb 0,%01110000+2			; 3 commands at the same timepoint
defb 	128+4,0,&67,%11000000+6	; Program -None... Move - wave 10101100 ... Hurt by bullets, hurts player, life 4
defb 	%10010000+15,6	

; start of level
StartOfLevel:

;HandLeft1
defb 0,%01110000+5			; 3 commands at the same timepoint
defb 134					;Add To Background
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110101				;Program
defb 	0,	18,160+24,90+24+48+8	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject1			; save Object pointer


;Palette Change
defb 1,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			











; Load Palette

	defb 2,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&55,&40,&4B		;Black,DkBlue,LtYellow,White


	defb 240,26*0+6,5*2+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 2	; Switches
	defb 1	;delay			
	defb &54,&5D,&40,&4B
	defb 16	;delay			
	defb &54,&5D,&40,&4B



	defb 240,26*1+6,1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0

	defb 240,26*2+6,5*2+1		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 2 ; no of switches
	defb 0	;delays			
	defb &54,&58,&40,&4B		;Black,Red,Grey,White
	defb 16
	defb &54,&4C,&40,&4B		
	

;HandLeft2
defb 1+12,%01110000+5			; 3 commands at the same timepoint
defb 134					;Add To Background
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110011				;Program    
defb 	0,	19,160+24,90+24+48+8	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject2			; save Object pointer

; hit target
defb 20,%01110000+3			; 2 commands at the same timepoint;
;
defb 	128+4,2,%11000010,%11000000+40	; Program - Starburst ... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4;
defb 	0,21+128+11,160+27,90+24+24	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		SkullTarget			; save Object pointer


; Fire target 1
defb 20,%01110000+3			; 2 commands at the same timepoint;
;
defb 	128+4,%01100000+7,%11000010,0	; Program - Starburst ... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4;
defb 	0,21+128+11,160+27,90+24+48	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		FireTarget1			; save Object pointer

; Fire target 2
defb 20,%01110000+3			; 2 commands at the same timepoint;
;
defb 	128+4,%10000000+13,%11000010,0	; Program - Starburst ... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4;
defb 	0,21+128+11,160+27,90+24+48	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		FireTarget2			; save Object pointer

; Fire target 3
defb 20,%01110000+3			; 2 commands at the same timepoint;
;
defb 	128+4,%01100000+7,%11000010,0	; Program - Starburst ... Move - dir Left Slow ... Hurt by bullets, hurts player, life 4;
defb 	0,21+128+11,160+27,90+24	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		FireTarget3			; save Object pointer



;Skull1
defb 20,%01110000+5			; 3 commands at the same timepoint
defb 135				;Add To Foreground
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,0					; Change to program 0 (normal)
defb 	0,128+	0,160+24,90+24	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		SkullObject1			; save Object pointer


;HandLeft3
defb 1+24,%01110000+5			; 3 commands at the same timepoint
defb 134					;Add To Background
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110100				;Program
defb 	0,	20,160+24,90+24+48+8	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject3			; save Object pointer


;Skull2
defb 20+12,%01110000+5			; 3 commands at the same timepoint
defb 135				;Add To Foreground
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,0					; Change to program 0 (normal)
defb 	0,128+	1,160+24,90+24	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		SkullObject2			; save Object pointer


;HandRight1
defb 20+18,%01110000+5			; 3 commands at the same timepoint
defb 134					;Add To Background
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110011				;Program
defb 	0,	15,160+24,90+24+48	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject4			; save Object pointer		

;Skull3
defb 20+24,%01110000+5			; 3 commands at the same timepoint
defb 135				;Add To Foreground
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,0					; Change to program 0 (normal)
defb 	0,	2,160+24,90+24	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		SkullObject3			; save Object pointer





;HandRight2
defb 20+18+12,%01110000+5			; 3 commands at the same timepoint
defb 134					;Add To Background
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110100				;Program
defb 	0,	16,160+24,90+24+48	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject5			; save Object pointer

;HandRight3
defb 20+18+24,%01110000+4			; 3 commands at the same timepoint
defb 	%10010000+0+1				; Load Settings from bank 1
defb 	129,%11110101				;Program
defb 	0,	17,160+24,90+24+48	; 	; Single Object sprite 11 (animated)
defb 	138					; save Object pointer
defw 		HandObject6			; save Object pointer

defb 70,%10001001			;Call a memory location
defw	StopBossMovement
;defb 20+18+24	
;defb 136				; Jump to a different level point
;defw StartOfLevel			; pointer
;defb 255					; new time
HandAttack1:
defb 75,%01110000+7
defb 	%10010000+3
defb 	0, 22+128,12*1+24,160	; 	; Single Object / 
defb 	0, 22+128,12*3+24,160	; 	; Single Object / 
defb 	0, 22+128,12*5+24,160	; 	; Single Object / 
defb 	0, 22+128,12*7+24,160	; 	; Single Object / 
defb 	0, 22+128,12*9+24,160	; 	; Single Object / 
defb 	0, 22+128,12*11+24,160	; 	; Single Object / 

defb 77,%01110000+8
defb 	%10010000+4
defb 	0, 22+128+7,12*0+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*2+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*4+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*6+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*8+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*10+24,24	; 	; Single Object / 
defb 	0, 22+128+7,12*12+24,24	; 	; Single Object / 

defb 79,%01110000+6
defb 	%10010000+6
defb 	0, 21+128+9,24,24*0+24; 	; Single Object / 
defb 	0, 21+128+9,24,24*2+24; 	; Single Object / 
defb 	0, 21+128+9,24,24*4+24; 	; Single Object / 
defb 	0, 21+128+9,24,24*6+24; 	; Single Object / 
defb 	0, 21+128+9,24,24*8+24; 	; Single Object / 


defb 81,%01110000+6
defb 	%10010000+5
defb 	0, 21+128,160,24*1+24; 	; Single Object / 
defb 	0, 21+128,160,24*3+24; 	; Single Object / 
defb 	0, 21+128,160,24*5+24; 	; Single Object / 
defb 	0, 21+128,160,24*7+24; 	; Single Object / 
defb 	0, 21+128,160,24*9+24; 	; Single Object / 

defb 82	
defb 136				; Jump to a different level point
defw HandAttack1			; pointer
defb 60					; new time




LevelEndAnim:
defb 253,%01110000+2			; 3 commands at the same timepoint
defb evtSetProgMoveLife,prgMovePlayer,&24,10
defb 	0,21+128+11,140+24,100+24	; 	; Single Object sprite 11 (animated)

;Palette Change
defb 254,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&44,&40	

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&44,&40		

	defb 240,26*2+6,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&44,&40			




defb 255,%01110000+4			; 4 Commands
	defb 240,0,6				; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54	

	defb 240,26*0+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*1+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 21*2+5
	defb 0
	defb 1				
	defb &54,&54,&54,&54		

	defb 240,26*2+6,6		; (Time,Cmd,Off,Bytes) load 5 bytes into the palette Offset 0
	defb 1
	defb 1				
	defb &54,&54,&54,&54		

defb 0,evtCallAddress			;Call a memory location
defw	EndLevel


EndLevel:
	pop hl	;
	ld hl,	&0103 				;load level 2
	jp	Akuyou_ExecuteBootStrap	; Start the game, no return




LevelInit:

	ld a, StarArraySize
	ld hl,StarArrayPointer
	call AkuYou_StarArrayInit_Enemy 

	ld a, PlayerStarArraySize
	ld hl,PlayerStarArrayPointer
	call AkuYou_StarArrayInit_Player 

	ld a,1
	ld bc,RasterColors_ColorArray1
	ld de,RasterColors_ColorArray2
	ld hl,RasterColors_ColorArray3
	ld ix,RasterColors_ColorArray4
	ld iy,null
	call Akuyou_RasterColors_SetPointers


	ld a,ObjectArraySize
	ld hl,ObjectArrayPointer
	call AkuYou_ObjectArray_Init

	ld hl,EventStreamArray		;Event Stream
	ld de,Event_SavedSettings	;Saved Settings
	call AkuYou_Event_StreamInit


	call Akuyou_Music_Restart


	ld hl,LevelSprites		
	ld de,&1000
	call AkuYou_SpritePointerInit


	call Akuyou_ScreenBuffer_Init
	call Akuyou_RasterColors_Init




	;call RasterColors_Reset
LevelLoop:


	;halt
	call Akuyou_Background_Clear


	call Akuyou_EventStream_Process

	;halt
	call Akuyou_ObjectArray_Redraw


	ld a,(BossHurt)
	cp 0
	jp z,DontReset
	dec a
	ld (BossHurt),a

	jp nz,DontReset
	ld a,128+0
	ld hl,(SkullObject1)
	call SetSprite
DontReset:
;	
	;halt
	call Akuyou_Player_Handler
;	ei
	;ld l,&0c
	;call Timer_Stop
	;ld a,"P"
	;call &bb5a 


	;halt
	call Akuyou_StarArray_Redraw
	

	;halt
	call AkuYou_Player_StarArray_Redraw
	;ld l,&0e
	;call Timer_Stop
	;ld a,"F"
	;call &bb5a 

	;halt
	call AkuYou_Player_DrawUI

	call Akuyou_PlaySfx


	;ld a,"U"
	;call &bb5a 

	call ShowBossText

	ifdef debug
		call ShowLevelTime
	endif
	call Akuyou_ScreenBuffer_Flip
	jp LevelLoop

null:

ret


ShowLevelTime:
	ld hl,&C000
	call Akuyou_ShowSprite_SetBankAddr


	ld hl,&1001
	call Akuyou_DrawText_LocateSprite

	call Akuyou_GetLevelTime
	push bc	
	call ShowHex
	pop bc
	ld a,b
	call ShowHex
ret


ShowHex:

	push af         ;store original byte value
	rrca            
	rrca
	rrca
	rrca
	call ShowHexDigit
	pop af          ;retrieve original byte value

ShowHexDigit:
;	and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
;	add a,"0"       ;add ASCII for 0. Digits 0...9 become "0"..."9", digits 10..15
;	cp "9"+1        
;	jr c,ShowHexDigitNum     ;if number is in digit range 0...9, display digit
;	add a,"A"-"9"-1 ;modify ASCII value so that digits in the range 10...15
and %00001111   ;isolate lower nibble. (This contains the digit value 0...15)
cp &a           ;Less than 10?  Set carry if so
sbc a,&69
daa             ;Because previous instruction was a subtract operation this
                ;is known as 'das' in x86
ShowHexDigitNum:
	jp Akuyou_DrawText_CharSprite   ;display digit

SkullObject1: defw &6969
SkullObject2: defw &6969
SkullObject3: defw &6969
HandObject1: defw &6969
HandObject2: defw &6969
HandObject3: defw &6969
HandObject4: defw &6969
HandObject5: defw &6969
HandObject6: defw &6969
SkullTarget: defw &6969
BossLife: defb 100
BossHurt: defb &0
FireTarget1: defw &6969
FireTarget2: defw &6969
FireTarget3: defw &6969
SetSprite:; YYYYYXXXXMMMMSSSLLLLPPP
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet


;	ld d,0
;	ld e,objectarraysize
	;y
	inc h;	add hl,de 	
	;x
	inc h;	add hl,de 	
	;move
	inc h;	add hl,de 	
	ld a,i
	ld (hl),a
	inc h;	add hl,de 	;spr
	inc h;	add hl,de 	;Life

	;program
ret

SetProgram:; YYYYYXXXXMMMMSSSLLLLPPP
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet


	;ld d,0
	;ld e,objectarraysize
	;y
	inc h;	add hl,de 	
	;x
	inc h;	add hl,de 	
	;move
	inc h;	add hl,de 	

	inc h;	add hl,de 	;spr
	inc h;	add hl,de 	;Life
	ld a,i
	ld (hl),a
	;program
ret
CustomObjectHitHandler:

ld a,iyl
cp 2
jp nz,Akuyou_Object_DecreaseLifeShot	; if this object isn't the boss target, just run the normal routine
	;iyl ; Program Code
	;ixl ;Life
	;iyh  ;spr
	;ixh ;Move
	;b ;X
	;c ;Y
ld ixl,%11000000+40	; Make object immortal
push de
push hl
	ld a,128+3
	ld hl,(SkullObject1)
	call SetSprite


	ld a,r
	srl a
	srl a
	add 120
	ld hl,(FireTarget1)
	call ChangeY

	ld a,r
	srl a
	srl a
	add 120
	ld hl,(FireTarget2)
	call ChangeY

	ld a,r
	srl a
	srl a
	add 120
	ld hl,(FireTarget3)
	call ChangeY



	ld a,2
	ld (BossHurt),a

	ld a,(BossLife)
	dec a
	cp 80
	jp z,BossLife1
	cp 60
	jp z,BossLife2
	cp 40
	jp z,BossLife3
	cp 20
	jp z,BossLife4
	cp 1
	jp z,BossLife5
	jp UpdateBossLife
BossLife5:
	push af



		ld ixl,0	; Make object immortal

		ld a,0
		ld (BossHurt),a

		ld a,0
		ld hl,(FireTarget1)
		call SetProgram
		ld a,0
		ld hl,(FireTarget2)
		call SetProgram
		ld a,0
		ld hl,(FireTarget3)
		call SetProgram


		ld a,12
		ld hl,(SkullObject1)
		call SetSprite
		ld a,128+13
		ld hl,(SkullObject2)
		call SetSprite
		ld a,128+14
		ld hl,(SkullObject3)
		call SetSprite	
		ld a,2
		call Akuyou_DoSmartBombCall

		ld hl,LevelEndAnim
		ld a,249
		call Akuyou_SetLevelTime
	pop af
	jp UpdateBossLife
BossLife4:
push af
		ld a,128+10
		ld hl,(SkullObject2)
		call SetSprite
		ld a,128+11
		ld hl,(SkullObject3)
		call SetSprite	
	pop af
	jp UpdateBossLife
BossLife3:
push af
		ld a,128+8
		ld hl,(SkullObject2)
		call SetSprite
		ld a,128+9
		ld hl,(SkullObject3)
		call SetSprite	
	pop af
	jp UpdateBossLife
BossLife2:
	push af
		ld a,128+6
		ld hl,(SkullObject2)
		call SetSprite
		ld a,128+7
		ld hl,(SkullObject3)
		call SetSprite	
	pop af
	jp UpdateBossLife
BossLife1:
	push af
		ld a,128+4
		ld hl,(SkullObject2)
		call SetSprite
		ld a,128+5
		ld hl,(SkullObject3)
		call SetSprite	
	pop af
	jp UpdateBossLife
UpdateBossLife:
	ld (BossLife),a

	
	
	pop hl
	pop de
ret
ChangeMovement:
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet


;	ld d,0
;	ld e,objectarraysize
	;y
	inc h;add hl,de 	
	;x
	inc h;	add hl,de 	

	ld a,i
	ld (hl),a
	;move
	inc h;	add hl,de 	
	;spr
	inc h;	add hl,de 	
	;Life
	inc h;	add hl,de 	

	;program
ret
ChangeY:
	ld i,a
	ld a,h
	cp &69
	ret z		;not on screen yet

	ld a,i
	ld (hl),a
ret

StopBossMovement:
	push hl
	push de
		ld a,&24
		ld hl,(SkullObject1)
		call ChangeMovement

		ld a,&24
		ld hl,(SkullObject2)
		call ChangeMovement

		ld a,&24
		ld hl,(SkullObject3)
		call ChangeMovement	

		ld a,&24
		ld hl,(HandObject1)
		call ChangeMovement	
		ld a,&24
		ld hl,(HandObject2)
		call ChangeMovement	
		ld a,&24
		ld hl,(HandObject3)
		call ChangeMovement	
		ld a,&24
		ld hl,(HandObject4)
		call ChangeMovement	
		ld a,&24
		ld hl,(HandObject5)
		call ChangeMovement	
		ld a,&24
		ld hl,(HandObject6)
		call ChangeMovement	
		ld a,&24
		ld hl,(SkullTarget)
		call ChangeMovement	
		ld a,&24
		ld hl,(FireTarget1)
		call ChangeMovement	
		ld a,&24
		ld hl,(FireTarget2)
		call ChangeMovement
		ld a,&24
		ld hl,(FireTarget3)
		call ChangeMovement		

	pop de
	pop hl
ret
;jp Akuyou_Object_DecreaseLifeShot
ShowBossText:
	ld a,5 :OnscreenTimer_Plus1
	or a
	ret z


	ld hl,&C000
	call Akuyou_ShowSprite_SetBankAddr
	ld l,4
	ld a,1:BossCharNum_Plus1
	ld i,a	; show up to 255 chars
	ld bc,BossText
ShowBossText_MoreText:
	ld a,(bc)
	ld h,a
	inc bc

	push hl
		call Akuyou_DrawText_LocateSprite

		call Akuyou_DrawText_PrintString
	pop hl
	inc l
	inc l
	inc l
	ld a,i
	dec a
	inc bc
	jp nz,ShowBossText_MoreText

	ld a,(bc)
	or a
	jp z,ShowBossText_AllOnscreen ; See if we have reached the end of the string
	ld a,(BossCharNum_Plus1-1)
	inc a
	ld (BossCharNum_Plus1-1),a

ret
ShowBossText_AllOnscreen:
	ld a,(OnscreenTimer_Plus1-1)
	dec a
	ld (OnscreenTimer_Plus1-1),a
ret

BossText: 
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db  11,"W A R N I N G ! ! ","!"+&80
db  06,"A Big Enemy is approaching","!"+&80
db  07,"Skull + Spider = Skullder","!"+&80
db  05,""," "+&80
db  05,""," "+&80
db  06,"(Or Spill, if you prefer!",")"+&80
;b  "12345678901234567890123456789","0"+&80
db &0



limit &3fff
org &3ff0
jp LevelInit; - Level Start &3ff0
jp LevelLoop; - Level loop &3ff3
jp null     ; - Level resume &3ff6
jp null     ; - Level Shutdown &3ff9





save direct "T14-SC1.D01",&1B00,&2500	;address,size...}[,exec_address]


