;============================================================================;
; Lens effects are neat because they require almost no processor time. They  ;
; do, however, require some forethought... designing the lens lookup to look ;
; good and be fairly quick. There are many ways to do this, but I think this ;
; is the fastest Mode 13h implementation possible. Who knows.                ;
;============================================================================;
        ;-------------------------------;
dl_si   dw      0                       ;
dl_offs dw      0                       ;
        ;-------------------------------;
        ; Do the lens. Watch close.     ;
        ; BX = Y, CX = X.               ;
        ; Be careful ripping this.      ;
        ; Assumes a screen copy at      ;
        ; DATA:0000 and all vars are    ;
        ; codeseg.                      ;
do_lens proc                            ;
        push es                         ;
        push ds                         ;
        push bp                         ;
        xor si,si                       ;
        mov ax,[datseg]                 ;
        mov ds,ax                       ;
        mov ax,0a000h                   ;
        mov es,ax                       ;
        mov ax,cx                       ;
        sal cx,8                        ;
        sal ax,6                        ;
        add ax,cx                       ;
        add ax,bx                       ;
        mov cs:[dl_offs],ax             ;
        mov bx,offset lens              ;
        mov dx,cs:[dl_offs]             ;
        mov cs:[dl_si],si               ;
        mov bp,51                       ;
dl_01:  mov cx,50                       ;
        mov di,cs:[dl_si]               ;
        add di,dx                       ;
dl_02:  mov si,word ptr cs:[bx]         ;
        add si,di                       ;
dl_02a: mov al,byte ptr ds:[si]         ;
        mov byte ptr es:[di],al         ;
dl_02b: add bx,2                        ;
        inc di                          ;
        dec cx                          ;
        jnz dl_02                       ;
        add dx,320                      ;
        dec bp                          ;
        jnz dl_01                       ;
        pop bp                          ;
        pop ds                          ;
        pop es                          ;
        ret                             ;
do_lens endp                            ;
