#include ".\cube.h"

typedef struct {
  float x,y,z;
  float u,v;
} VERTEX;

typedef struct {
  int a,b,c;
} FACE;

cube::cube(void)
{
  int i,j,k;

  VERTEX lvertex[8*3];
  FACE lface[12];

  float wrap = 1;
  
  for (i=0; i<6; i++) {
    float m1=i%2 ? -1.0 : 1.0;

    for (k=0; k<4; k++) {
      float m2=( (k & 0x01) ? -1.0 : 1.0 );
      float m3=( (k & 0x02) ? -1.0 : 1.0 );
      switch (i%3) {
      case 0:
        lvertex[i*4+k].x = m1;
        lvertex[i*4+k].y = m2;
        lvertex[i*4+k].z = m3;
        break;
      case 1:
        lvertex[i*4+k].x = m2;
        lvertex[i*4+k].y = -m1;
        lvertex[i*4+k].z = m3;
        break;
      case 2:
        lvertex[i*4+k].x = m2;
        lvertex[i*4+k].y = m3;
        lvertex[i*4+k].z = m1;
        break;
      }
      lvertex[i*4+k].u = abs(( (k & 0x01) ? 0.0 : (float)wrap ));
      lvertex[i*4+k].v = abs(( (k & 0x02) ? 0.0 : (float)wrap ));
    }
    if (i%2) {
      lface[i*2  ].a=i*4+0;
      lface[i*2  ].b=i*4+1;
      lface[i*2  ].c=i*4+2;
      lface[i*2+1].a=i*4+1;
      lface[i*2+1].b=i*4+3;
      lface[i*2+1].c=i*4+2;
    } else {
      lface[i*2  ].a=i*4+0;
      lface[i*2  ].b=i*4+2;
      lface[i*2  ].c=i*4+1;
      lface[i*2+1].a=i*4+1;
      lface[i*2+1].b=i*4+2;
      lface[i*2+1].c=i*4+3;
    }

  }

  list = glGenLists(1);
  glNewList(list, GL_COMPILE);
  glBegin(GL_TRIANGLES);
  for (int x=0; x<12; x++) {
    glTexCoord2f(lvertex[lface[x].a].u,
      lvertex[lface[x].a].v); 
//    glNormal3f(lnormal[lface[x].a].x,
//      lnormal[lface[x].a].y,
//      lnormal[lface[x].a].z);
    glVertex3f(lvertex[lface[x].a].x,
      lvertex[lface[x].a].y,
      lvertex[lface[x].a].z);

    glTexCoord2f(lvertex[lface[x].b].u,
      lvertex[lface[x].b].v); 
//    glNormal3f(lnormal[lface[x].b].x,
//      lnormal[lface[x].b].y,
//      lnormal[lface[x].b].z);
    glVertex3f(lvertex[lface[x].b].x,
      lvertex[lface[x].b].y,
      lvertex[lface[x].b].z);

    glTexCoord2f(lvertex[lface[x].c].u,
      lvertex[lface[x].c].v); 
//    glNormal3f(lnormal[lface[x].c].x,
//      lnormal[lface[x].c].y,
//      lnormal[lface[x].c].z);
    glVertex3f(lvertex[lface[x].c].x,
      lvertex[lface[x].c].y,
      lvertex[lface[x].c].z);
  }
  glEnd();
  glEndList();

}

void cube::draw() {
  glCallList(list);
}