importbin 8x8small.fnt 0 1024 sys_font
importbin chip16.bin 0 782 chip16_logo

frame equ #1000  ; frame at 0x1000 (4096 bytes for code+font+pallete+var+const)
; ----- START
      
      pal pallete
      vblnk

      ldi  r9,1    ; r9 = angle
      ldi  r7,4    ; r7 = amp
      ldi  rf,1    ; direction
next_frame:
      ldi ra, frame  
      call clear_frame

      ldi  r8,0    ; r8 = Y-loop

loop_y:
      div r8,r7,r6
      add r6,r9,ra
      mov r0,ra    ; r0 = y div amp+ang
      ldi rb,360
      call mod

      ldi r5,stab
      add r5,ra
      ldm r1,r5
      andi r1,255  ; r1 = stab[(y div amp+ang) mod 360]

      mov ra,r0
      addi ra,90
      ldi rb,360
      call mod

      ldi r5,stab
      add r5,ra
      ldm r2,r5
      andi r2,255  ; r2 = stab[(y div amp+ang+90) mod 360]


      mov ra,r0
      addi ra,180
      ldi rb,360
      call mod

      ldi r5,stab
      add r5,ra
      ldm r3,r5
      andi r3,255  ; r3 = stab[(y div amp+ang+180) mod 360]

      mov ra,r0
      addi ra,270
      ldi rb,360
      call mod

      ldi r5,stab
      add r5,ra
      ldm r4,r5
      andi r4,255  ; r4 = stab[(y div amp+ang+270) mod 360]

      cmp r1,r2
      jae next_side

      ldi ra, frame
      mov rb, r1
      addi rb,2
      mov rc, r8
      mov rd, r2
      ldi re, #1
      call hor_line        

next_side:

      cmp r2,r3
      jae next_side2

      ldi ra, frame
      mov rb, r2
      addi rb,2
      mov rc, r8
      mov rd, r3
      ldi re, #2
      call hor_line        

next_side2:

      cmp r3,r4
      jae next_side3

      ldi ra, frame
      mov rb, r3
      addi rb,2
      mov rc, r8
      mov rd, r4
      ldi re, #3
      call hor_line        

next_side3:

      cmp r4,r1
      jae next_side4

      ldi ra, frame
      mov rb, r4
      addi rb,2
      mov rc, r8
      mov rd, r1
      ldi re, #4
      call hor_line        

next_side4:

      addi r8,1
      cmpi r8,200
      jnz loop_y

; draw strings
      ldi ra,182
      ldm rb,str1_pos
      cmpi rb,60
      jz no_dec
      subi rb,1
no_dec:
      stm rb,str1_pos
      ldi rc,str1
      ldi rd,#5
      call draw_string

      ldi ra,214
      addi rb,20
      ldi rc,str2
      call draw_string

      ldi ra,198
      addi rb,10
      ldi rc,str3
      call draw_string

      ldi ra,194
      addi rb,10
      ldi rc,str4
      call draw_string

      ldi ra,180
      addi rb,10
      ldi rc,str5
      call draw_string

      ldi ra,200
      addi rb,10
      ldi rc,str6
      call draw_string

      ldi ra,190
      addi rb,10
      ldi rc,str7
      call draw_string

      ldi ra,170
      addi rb,10
      ldi rc,str8
      call draw_string

      ldi ra,190
      addi rb,30
      ldi rc,str9
      call draw_string

      ldi r0, 1
      ldi r1, 20
      spr   #c8a0 ; 320x200
      cls
      ldi rc, frame
      drw   r0,r1,rc

      ldi r0,200
      ldi r2,2
      rnd r1,4
      sub r2,r1
      add r0,r2

      ldi r1,30
      ldi r2,2
      rnd r3,4
      sub r2,r3
      add r1,r2
      spr #1722
      drw r0,r1,chip16_logo

;rotate pallete
      ldm rb,str1_pos
      cmpi rb,60
      jnz skip_pal
      pushall
      ldi ra, 5
      ldi rb, pallete
      call get_color
      mov r7,rc         ; save 1 color
      mov r8,rd
      mov r9,re

      ldi ra, #f
      ldi rb, pallete
      call get_color
      

      ldi ra, 5       
      ldi rb, pallete 
      call set_color    ; set 1 color = #f color

      ldi r5, #e     ; downto counter, from color #e

rot_loop:

      mov   ra,r5
      ldi   rb, pallete
      call  get_color
      mov   ra,r5
      addi  ra,1
      ldi   rb, pallete
      call  set_color
      
      subi  r5,1
      cmpi  r5,5
      jnz   rot_loop

      ldi ra,6
      ldi rb, pallete
      mov rc,r7
      mov rd,r8
      mov re,r9
      call set_color
      popall

      pal pallete
      vblnk

skip_pal:
      addi r9,1
      cmpi r9,360
      jnz next_frame
      ldi r9,1
      jmp next_frame

; ----- PROCEDURES

hor_line:
; ra = pointer to sprite
; rb = X1
; rc = Y
; rd = X2
; re = color
      cmp rd,rb
      jb end_hor_line
hor_line_loop:
      push rd
      mov  rd,re
      pushall
      call set_pixel
      popall
      pop rd
      addi rb, 1
      cmp  rb, rd
      jnz hor_line_loop
end_hor_line:
      ret

clear_frame:
; ra = pointer to sprite
      mov rc,ra
      addi rc,32000
      ldi rb, 0
do_clr:
      stm rb, ra
      addi ra, 2
      cmp ra, rc
      jb do_clr
      ret
      
draw_string:
; ra = X
; rb = Y
; rc = poiner to string
; rd = color
      cmpi rb,192
      jae st_end
      pushall
next_ch:
      ldm   rf,rc
      andi  rf,255
      jmz   print_end
      cmpi  rf,255      ; check color change
      jnz   print_it
      addi  rc,1
      ldm   rd,rc
      andi  rd,255
      addi  rc,1
      jmp   next_ch
print_it:
      push  rc
      mov   rc,rf
      call  draw_char
      pop   rc
      addi  ra,8
      addi  rc,1
      jmp   next_ch
print_end:
      popall
st_end:
      ret      

; ra = X
; rb = Y
; rc = char
; rd = color
draw_char:
      pushall
      ldi  r1,frame
      muli rb, 320
      add  rb, ra
      shr  rb,1
      add  r1, rb

      andi  rc,255      ; only low 8 bits 
      shl   rc,3        ; rc * 8
      ldi   r0,sys_font
      add   r0,rc       ; r0 = offset in font array

      ldi   r2,1        ; cnt = 1
      ldi   r3,0        ; tmp = 0

      ldi   r4,0        ; for y = 0 to
do_y_cycle:

      ldi   r5,7        ; for x = 7 downto
do_x_cycle:

      add   r0,r4,r6    ; r6 = rc+y
      ldm   r7,r6       ; r7 = Buf[rc+y]
      andi  r7,255      ; low bits only
      ldi   r8,1
      shl   r8,r5       ; r8 = 1 shl x
      tst   r7,r8
      jz    end_case_pix

      cmpi  r2,4
      jz    do_4pix
      cmpi  r2,3
      jz    do_3pix
      cmpi  r2,2
      jz    do_2pix
      
      mov   r6,rd       ; r6 = color
      shl   r6,4
      or    r6,r3,r3    ; tmp = (color shl 4) or tmp;
      jmp   end_case_pix
do_4pix:
      mov   r6,rd       ; r6 = color
      shl   r6,8
      or    r6,r3,r3    ; tmp = (color shl 8) or tmp;
      jmp   end_case_pix
do_3pix:
      mov   r6,rd       ; r6 = color
      shl   r6,12
      or    r6,r3,r3    ; tmp = (color shl 12) or tmp;
      jmp   end_case_pix
do_2pix:
      or    rd,r3,r3    ; tmp = color or tmp;      

end_case_pix:
      addi  r2,1
      cmpi  r2,4
      jbe   skp_add_pix
      stm   r3,r1
      addi  r1,2
      ldi   r2,1
      ldi   r3,0        ; !!!!!!!!!!!!!!!!

skp_add_pix:
      subi  r5,1        ; dec(x)
      cmpi  r5,0
      jge   do_x_cycle

      addi  r4,1
      addi r1,156
      ldm  rf,str1_pos
      cmpi  rf,60
      jnz  skip_inc_col
      addi rd,1
skip_inc_col:
      cmpi  r4,8
      jnz   do_y_cycle

      popall
      ret

set_pixel:
; ra = pointer to sprite
; rb = X
; rc = Y
; rd = color (0..0xF)
      muli rc, 320
      add  rc, rb
      shr  rc,1
      add  ra, rc

      ldm  r0, ra

      andi rb, 1            ; odd/even?
      jnz odd_px

      andi r0, #FF0F
      shl  rd, 4
      or   r0, rd
      stm  r0, ra
      jmp  end_plot
odd_px:
      or   r0, rd
      stm  r0, ra
end_plot:
      ret

set_color:
; ra = index
; rb = pointer to pallete
; rc = R
; rd = G
; re = B

      muli ra, 3
      add  rb, ra
      mov  r0, rd
      shl  r0, 8
      or   rc, r0
      stm  rc, rb

      addi rb, 2
      ldm  r0, rb
      shr  r0, 8
      shl  r0, 8
      or   re, r0
      stm  re, rb
      ret

get_color:
; ra = index
; rb = pointer to pallete
; output:
; rc = R
; rd = G
; re = B

      muli ra, 3
      add  rb, ra
      ldm  r0, rb
      push r0
      andi r0,#FF
      mov  rc,r0
      pop  r0
      shr  r0, 8
      mov  rd,r0

      addi rb, 2
      ldm  r0, rb
      andi r0, #FF
      mov  re, r0
      ret

mod:
; input:
;   ra = fist number
;   rb = second number
; output:
;   ra = result
      mov   rc,ra
      sub   ra,rb
      jnc   mod
      mov   ra,rc
      ret

;var
str1_pos:    dw 180

; const
stab:        db #50, #51, #52, #53, #54, #55, #56, #57, #58, #59, #5A, #5B
             db #5C, #5D, #5F, #60, #61, #62, #63, #64, #65, #66, #66, #67
             db #68, #69, #6A, #6B, #6C, #6D, #6E, #6F, #70, #71, #72, #72
             db #73, #74, #75, #76, #77, #77, #78, #79, #7A, #7A, #7B, #7C
             db #7D, #7D, #7E, #7F, #7F, #80, #81, #81, #82, #82, #83, #83
             db #84, #84, #85, #85, #86, #86, #87, #87, #88, #88, #88, #89
             db #89, #89, #8A, #8A, #8A, #8A, #8B, #8B, #8B, #8B, #8B, #8C
             db #8C, #8C, #8C, #8C, #8C, #8C, #8C, #8C, #8C, #8C, #8C, #8C
             db #8C, #8C, #8B, #8B, #8B, #8B, #8B, #8A, #8A, #8A, #8A, #89
             db #89, #89, #88, #88, #88, #87, #87, #86, #86, #85, #85, #84
             db #84, #83, #83, #82, #82, #81, #81, #80, #7F, #7F, #7E, #7D
             db #7D, #7C, #7B, #7A, #7A, #79, #78, #77, #77, #76, #75, #74
             db #73, #72, #72, #71, #70, #6F, #6E, #6D, #6C, #6B, #6A, #69
             db #68, #67, #66, #66, #65, #64, #63, #62, #61, #60, #5F, #5D
             db #5C, #5B, #5A, #59, #58, #57, #56, #55, #54, #53, #52, #51
             db #50, #4F, #4E, #4D, #4C, #4B, #4A, #49, #48, #47, #46, #45
             db #44, #43, #41, #40, #3F, #3E, #3D, #3C, #3B, #3A, #3A, #39
             db #38, #37, #36, #35, #34, #33, #32, #31, #30, #2F, #2E, #2E
             db #2D, #2C, #2B, #2A, #29, #29, #28, #27, #26, #26, #25, #24
             db #23, #23, #22, #21, #21, #20, #1F, #1F, #1E, #1E, #1D, #1D
             db #1C, #1C, #1B, #1B, #1A, #1A, #19, #19, #18, #18, #18, #17
             db #17, #17, #16, #16, #16, #16, #15, #15, #15, #15, #15, #14
             db #14, #14, #14, #14, #14, #14, #14, #14, #14, #14, #14, #14
             db #14, #14, #15, #15, #15, #15, #15, #16, #16, #16, #16, #17
             db #17, #17, #18, #18, #18, #19, #19, #1A, #1A, #1B, #1B, #1C
             db #1C, #1D, #1D, #1E, #1E, #1F, #1F, #20, #21, #21, #22, #23
             db #23, #24, #25, #26, #26, #27, #28, #29, #29, #2A, #2B, #2C
             db #2D, #2E, #2E, #2F, #30, #31, #32, #33, #34, #35, #36, #37
             db #38, #39, #3A, #3A, #3B, #3C, #3D, #3E, #3F, #40, #41, #43
             db #44, #45, #46, #47, #48, #49, #4A, #4B, #4C, #4D, #4E, #4F

str1:        db "* Greetz to *"
             db 0
str2:        db "tykel"
             db 0
str3:        db "BestCoder"
             db 0
str4:        db "refraction"
             db 0
str5:        db "paul_nicholls"
             db 0
str6:        db "ShendoXT"
             db 0
str7:        db "Cottonvibes"
             db 0
str8:        db "and all C16 funs"
             db 0
str9:        db "Tronix 2012"
             db 0

pallete: db #00, #00, #00
         db #90, #5f, #25
         db #e4, #94, #52
         db #53, #7a, #3b
         db #68, #ab, #cc

         db #bc, #de, #f4
         db #ac, #ce, #e4
         db #9c, #be, #d4
         db #8c, #ae, #c4
         db #7c, #9e, #b4
         db #6c, #8e, #a4
         db #6c, #8e, #a4
         db #7c, #9e, #b4
         db #8c, #ae, #c4
         db #9c, #be, #d4
         db #ac, #ce, #e4
