; CGA Bubble World
; Coded by Tronix, 2023
; Compile with TASM
; Link with TLINK /T

.MODEL tiny
.CODE
.STARTUP
.8086


	jmp short Real_Start
KbdInt:
     	push ax
     	cli
     	in      al,60h
     	mov     cs:c,al
     	in      al,61H             ;get value of keyboard control lines
     	mov     ah,al              ; save it
     	or      al,80h             ;set the "enable kbd" bit
     	out     61H,al             ; and write it out the control port
     	xchg    ah,al              ;fetch the original control port value
     	out     61H,al             ; and write it back

     	mov     al,20h
     	out     20h,al
     	sti
     	pop ax
     	iret

Error:
	mov dx,offset mem_error		; Write	Error message
	mov ah,9
	int 21h
	int 20h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;       STARTUP        ;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Real_Start:
	mov bx,1000h	 		; shrink program memory size to 64 K
	mov ah,4ah                     
	int 21h
	mov ah,48h
	mov bx,400h                     ; get 16K for buffer
	int 21h
	jc error
	mov es,ax

        push es
	mov ax,3509h			; save old Kbd Int 09h
	int 21h
	mov cs:OldK,bx
	mov cs:OldK+2,es
        pop es
	mov ax,2509h			; set new Kbd int
	mov dx,offset KbdInt
	int 21h

        mov ax,04h			; switch to 320x200 CGA
        int 10h

	;mov dx,03d9h
	;mov al,10h
	;out dx,al

	mov c,0				; clr keybuf

	cld
        xor di,di			; clr ES:DI buf
        mov cx,16000/2
        xor ax,ax
        rep stosw
Main_Loop:
        cli				; disable interrupts

	lea bp,stab			; BP = stab. [BP+8192] = ctab

	mov bl,100
	mov di,15
	mov si,15+02000h
	xor ax,ax
clr_lp:
	mov cx,(50)/2
	rep stosw
	xchg di,si
	mov cx,(50)/2
	rep stosw           
	xchg di,si
	add di,15+15
	add si,15+15
	dec bl
	test bl,bl
	jnz clr_lp	


	mov iloop,0
	mov ri,0
inner_i:
	xor si,si			; SI internal loop cntr (J)
inner_j:

	mov cx,iloop			; iplusv  := (i+v) and (tabsiz-1);
	add cx,v
	and cx,8191
        shl cx,1

	mov dx,ri			; riplusx := (ri+x) and (tabsiz-1);
	add dx,x
	and dx,8191
        shl dx,1

	mov di,cx			; ctab[iplusv]
	mov ax,[bp+di+ctab]
	mov di,dx                  	; ctab[riplusx]
	mov bx,[bp+di+ctab]			
	add ax,bx
	mov v,ax			; v := ctab[iplusv] + ctab[riplusx];

	mov di,cx			; stab[iplusv]
	mov ax,[bp+di]
	mov di,dx			; stab[riplusx]
	mov bx,[bp+di]			
	add ax,bx
	;mov u,ax			; u := stab[iplusv] + stab[riplusx];

	mov bx,t			; x := u + t;
	add bx,ax
	mov x,bx


                  ;utab[u+2606],{u*size div q+offset_x,}
                  ;vtab[v+2606],{v*size div q+offset_y,}
                  ;(i) and 3);
	mov di,ax
	add di,2606
	shl di,1
	mov bx,[bp+di+utab]

	mov di,v
	add di,2606
	shl di,1
	mov ax,[bp+di+vtab]

	;Caller:
	;  AX = y-coordinate (0-199)
	;  BX = x-coordinate (0-319)

	;Returns:
	;  AH = bit mask
	;  BX = byte offset in buffer
	;  CL = number of bits to shift left
	;  ES = video buffer segment

	mov     cl,bl           ;{ CL := low-order byte of x}
	xchg    ah,al           ;{ AX := 100h * y}
	shr     ax,1            ;{ AL := 80h * (y&1)}
	add     bh,al           ;{ BX := x + 8000h*(y&1)}
	xor     al,al           ;{ AX := 100h*(y/2)}
	add     bx,ax           ;{ BX := x + 8000h*(y&1) + 100h*(y/2)}
	shr     ax,1
	shr     ax,1            ;{ AX := 40h*(y/2)}
	add     bx,ax           ;{ BX := x + 8000h*(y&1) + 140h*(y/2)}
	shr     bx,1
	shr     bx,1            ;{ BX := x/4 + 2000h*(y&1) + 50h*(y/2)}
	mov     ah,3            ;{ AH := unshifted bit mask}
	and     cl,ah           ;{ CL := x & 3}
	xor     cl,ah           ;{ CL := 3 - (x & 3)}
	shl     cl,1            ;{ CL := # bits to shift left}

	;  mov   al,1 ;{AH = bitmask, AL = color}
	mov dx,iloop
	and dx,3
	mov al,dl

	shl   ax,cl ;{AH = bit mask in proper position, AL = pixel value in proper position}
	not   ah ;{AH = inverse bit mask}
	and   es:[bx],ah ;{zero the pixel value}
	or    es:[bx],al ;{set the pixel value}

	add si,1303			; j += q
	cmp si,65150			; j > imax?
	jae j_done
	jmp inner_j
j_done:
	add iloop,1303			; i += q
	add ri,234			; ri += rstep
	cmp iloop,65150			; i > imax?
	jae  i_done
	jmp inner_i
i_done:
	add t,32			; t += 32

	mov bp,ds	;2
	mov bx,es	;2
	mov ds,bx	;2

	;mov ax,0b800h
	;mov es,ax
	;xor si,si
	;xor di,di
	;mov cx,8000
	;rep movsw

	mov ax,0b800h
	mov es,ax
	mov al,100
	mov di,15
	mov dx,15+02000h
cpy_lp:
	mov si,di
	mov cx,(50)/2
	rep movsw
	xchg di,dx
	mov si,di
	mov cx,(50)/2
	rep movsw           
	xchg di,dx
	add di,15+15
	add dx,15+15
	dec al
	test al,al
	jnz cpy_lp	

        sti
	mov es,bx	;2
	mov ds,bp	;2

        cmp c,1
	jz finish
        jmp Main_loop

finish:

	mov ax,3
	int 10h
        push ds
	mov ax,2509h
	mov dx,cs:OldK
	mov ds,cs:oldK+2
	int 21h
        pop ds
        mov ah,49h                      ; release mem for buf
        int 21h
	lea dx,copyr		; Write	copyr msg
	mov ah,9
	int 21h
	int 20h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;      DATA AREA       ;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ALIGN WORD
iloop	     dw 0
v	     dw 0
x	     dw 0
ri	     dw 0
t	     dw 0

stab         dw 00000h, 00000h, 00001h, 00002h, 00003h, 00004h, 00005h, 00006h
             dw 00007h, 00008h, 00009h, 0000Ah, 0000Bh, 0000Ch, 0000Dh, 0000Eh
             dw 0000Fh, 00010h, 00011h, 00012h, 00013h, 00014h, 00015h, 00016h
             dw 00017h, 00018h, 00019h, 0001Ah, 0001Bh, 0001Ch, 0001Dh, 0001Eh
             dw 0001Fh, 00020h, 00021h, 00022h, 00023h, 00024h, 00025h, 00026h
             dw 00027h, 00028h, 00029h, 0002Ah, 0002Bh, 0002Ch, 0002Dh, 0002Eh
             dw 0002Fh, 00030h, 00031h, 00032h, 00033h, 00034h, 00035h, 00036h
             dw 00037h, 00038h, 00039h, 0003Ah, 0003Bh, 0003Ch, 0003Dh, 0003Eh
             dw 0003Fh, 00040h, 00041h, 00042h, 00043h, 00044h, 00045h, 00046h
             dw 00047h, 00048h, 00049h, 0004Ah, 0004Bh, 0004Ch, 0004Dh, 0004Eh
             dw 0004Fh, 00050h, 00051h, 00052h, 00053h, 00054h, 00055h, 00056h
             dw 00057h, 00058h, 00059h, 0005Ah, 0005Bh, 0005Ch, 0005Dh, 0005Eh
             dw 0005Fh, 00060h, 00061h, 00062h, 00063h, 00064h, 00065h, 00066h
             dw 00067h, 00068h, 00069h, 0006Ah, 0006Bh, 0006Ch, 0006Dh, 0006Eh
             dw 0006Fh, 00070h, 00071h, 00072h, 00073h, 00074h, 00075h, 00076h
             dw 00077h, 00078h, 00079h, 0007Ah, 0007Bh, 0007Ch, 0007Dh, 0007Eh
             dw 0007Fh, 00080h, 00081h, 00082h, 00083h, 00084h, 00085h, 00086h
             dw 00087h, 00088h, 00089h, 0008Ah, 0008Bh, 0008Ch, 0008Dh, 0008Eh
             dw 0008Fh, 00090h, 00091h, 00092h, 00093h, 00094h, 00095h, 00096h
             dw 00097h, 00098h, 00099h, 0009Ah, 0009Bh, 0009Ch, 0009Dh, 0009Eh
             dw 0009Fh, 000A0h, 000A1h, 000A2h, 000A3h, 000A4h, 000A5h, 000A6h
             dw 000A7h, 000A8h, 000A9h, 000AAh, 000ABh, 000ACh, 000ADh, 000AEh
             dw 000AFh, 000B0h, 000B1h, 000B2h, 000B3h, 000B4h, 000B5h, 000B6h
             dw 000B7h, 000B8h, 000B9h, 000BAh, 000BBh, 000BCh, 000BDh, 000BEh
             dw 000BFh, 000C0h, 000C1h, 000C2h, 000C3h, 000C4h, 000C5h, 000C6h
             dw 000C7h, 000C8h, 000C9h, 000CAh, 000CBh, 000CCh, 000CDh, 000CEh
             dw 000CEh, 000CFh, 000D0h, 000D1h, 000D2h, 000D3h, 000D4h, 000D5h
             dw 000D6h, 000D7h, 000D8h, 000D9h, 000DAh, 000DBh, 000DCh, 000DDh
             dw 000DEh, 000DFh, 000E0h, 000E1h, 000E2h, 000E3h, 000E4h, 000E5h
             dw 000E6h, 000E7h, 000E8h, 000E9h, 000EAh, 000EBh, 000ECh, 000EDh
             dw 000EEh, 000EFh, 000F0h, 000F1h, 000F2h, 000F3h, 000F4h, 000F5h
             dw 000F6h, 000F7h, 000F8h, 000F9h, 000FAh, 000FBh, 000FCh, 000FDh
             dw 000FEh, 000FFh, 00100h, 00101h, 00102h, 00103h, 00104h, 00105h
             dw 00106h, 00107h, 00107h, 00108h, 00109h, 0010Ah, 0010Bh, 0010Ch
             dw 0010Dh, 0010Eh, 0010Fh, 00110h, 00111h, 00112h, 00113h, 00114h
             dw 00115h, 00116h, 00117h, 00118h, 00119h, 0011Ah, 0011Bh, 0011Ch
             dw 0011Dh, 0011Eh, 0011Fh, 00120h, 00121h, 00122h, 00123h, 00124h
             dw 00125h, 00126h, 00127h, 00128h, 00129h, 0012Ah, 0012Bh, 0012Ch
             dw 0012Dh, 0012Eh, 0012Fh, 0012Fh, 00130h, 00131h, 00132h, 00133h
             dw 00134h, 00135h, 00136h, 00137h, 00138h, 00139h, 0013Ah, 0013Bh
             dw 0013Ch, 0013Dh, 0013Eh, 0013Fh, 00140h, 00141h, 00142h, 00143h
             dw 00144h, 00145h, 00146h, 00147h, 00148h, 00149h, 0014Ah, 0014Bh
             dw 0014Ch, 0014Dh, 0014Eh, 0014Eh, 0014Fh, 00150h, 00151h, 00152h
             dw 00153h, 00154h, 00155h, 00156h, 00157h, 00158h, 00159h, 0015Ah
             dw 0015Bh, 0015Ch, 0015Dh, 0015Eh, 0015Fh, 00160h, 00161h, 00162h
             dw 00163h, 00164h, 00165h, 00166h, 00167h, 00168h, 00168h, 00169h
             dw 0016Ah, 0016Bh, 0016Ch, 0016Dh, 0016Eh, 0016Fh, 00170h, 00171h
             dw 00172h, 00173h, 00174h, 00175h, 00176h, 00177h, 00178h, 00179h
             dw 0017Ah, 0017Bh, 0017Ch, 0017Dh, 0017Eh, 0017Fh, 0017Fh, 00180h
             dw 00181h, 00182h, 00183h, 00184h, 00185h, 00186h, 00187h, 00188h
             dw 00189h, 0018Ah, 0018Bh, 0018Ch, 0018Dh, 0018Eh, 0018Fh, 00190h
             dw 00191h, 00192h, 00193h, 00193h, 00194h, 00195h, 00196h, 00197h
             dw 00198h, 00199h, 0019Ah, 0019Bh, 0019Ch, 0019Dh, 0019Eh, 0019Fh
             dw 001A0h, 001A1h, 001A2h, 001A3h, 001A4h, 001A5h, 001A5h, 001A6h
             dw 001A7h, 001A8h, 001A9h, 001AAh, 001ABh, 001ACh, 001ADh, 001AEh
             dw 001AFh, 001B0h, 001B1h, 001B2h, 001B3h, 001B4h, 001B5h, 001B6h
             dw 001B6h, 001B7h, 001B8h, 001B9h, 001BAh, 001BBh, 001BCh, 001BDh
             dw 001BEh, 001BFh, 001C0h, 001C1h, 001C2h, 001C3h, 001C4h, 001C5h
             dw 001C5h, 001C6h, 001C7h, 001C8h, 001C9h, 001CAh, 001CBh, 001CCh
             dw 001CDh, 001CEh, 001CFh, 001D0h, 001D1h, 001D2h, 001D3h, 001D4h
             dw 001D4h, 001D5h, 001D6h, 001D7h, 001D8h, 001D9h, 001DAh, 001DBh
             dw 001DCh, 001DDh, 001DEh, 001DFh, 001E0h, 001E1h, 001E1h, 001E2h
             dw 001E3h, 001E4h, 001E5h, 001E6h, 001E7h, 001E8h, 001E9h, 001EAh
             dw 001EBh, 001ECh, 001EDh, 001EEh, 001EEh, 001EFh, 001F0h, 001F1h
             dw 001F2h, 001F3h, 001F4h, 001F5h, 001F6h, 001F7h, 001F8h, 001F9h
             dw 001FAh, 001FAh, 001FBh, 001FCh, 001FDh, 001FEh, 001FFh, 00200h
             dw 00201h, 00202h, 00203h, 00204h, 00205h, 00205h, 00206h, 00207h
             dw 00208h, 00209h, 0020Ah, 0020Bh, 0020Ch, 0020Dh, 0020Eh, 0020Fh
             dw 00210h, 00210h, 00211h, 00212h, 00213h, 00214h, 00215h, 00216h
             dw 00217h, 00218h, 00219h, 0021Ah, 0021Ah, 0021Bh, 0021Ch, 0021Dh
             dw 0021Eh, 0021Fh, 00220h, 00221h, 00222h, 00223h, 00224h, 00224h
             dw 00225h, 00226h, 00227h, 00228h, 00229h, 0022Ah, 0022Bh, 0022Ch
             dw 0022Dh, 0022Eh, 0022Eh, 0022Fh, 00230h, 00231h, 00232h, 00233h
             dw 00234h, 00235h, 00236h, 00237h, 00237h, 00238h, 00239h, 0023Ah
             dw 0023Bh, 0023Ch, 0023Dh, 0023Eh, 0023Fh, 00240h, 00240h, 00241h
             dw 00242h, 00243h, 00244h, 00245h, 00246h, 00247h, 00248h, 00248h
             dw 00249h, 0024Ah, 0024Bh, 0024Ch, 0024Dh, 0024Eh, 0024Fh, 00250h
             dw 00250h, 00251h, 00252h, 00253h, 00254h, 00255h, 00256h, 00257h
             dw 00258h, 00258h, 00259h, 0025Ah, 0025Bh, 0025Ch, 0025Dh, 0025Eh
             dw 0025Fh, 00260h, 00260h, 00261h, 00262h, 00263h, 00264h, 00265h
             dw 00266h, 00267h, 00267h, 00268h, 00269h, 0026Ah, 0026Bh, 0026Ch
             dw 0026Dh, 0026Eh, 0026Fh, 0026Fh, 00270h, 00271h, 00272h, 00273h
             dw 00274h, 00275h, 00276h, 00276h, 00277h, 00278h, 00279h, 0027Ah
             dw 0027Bh, 0027Ch, 0027Dh, 0027Dh, 0027Eh, 0027Fh, 00280h, 00281h
             dw 00282h, 00283h, 00283h, 00284h, 00285h, 00286h, 00287h, 00288h
             dw 00289h, 0028Ah, 0028Ah, 0028Bh, 0028Ch, 0028Dh, 0028Eh, 0028Fh
             dw 00290h, 00290h, 00291h, 00292h, 00293h, 00294h, 00295h, 00296h
             dw 00297h, 00297h, 00298h, 00299h, 0029Ah, 0029Bh, 0029Ch, 0029Dh
             dw 0029Dh, 0029Eh, 0029Fh, 002A0h, 002A1h, 002A2h, 002A3h, 002A3h
             dw 002A4h, 002A5h, 002A6h, 002A7h, 002A8h, 002A8h, 002A9h, 002AAh
             dw 002ABh, 002ACh, 002ADh, 002AEh, 002AEh, 002AFh, 002B0h, 002B1h
             dw 002B2h, 002B3h, 002B4h, 002B4h, 002B5h, 002B6h, 002B7h, 002B8h
             dw 002B9h, 002B9h, 002BAh, 002BBh, 002BCh, 002BDh, 002BEh, 002BFh
             dw 002BFh, 002C0h, 002C1h, 002C2h, 002C3h, 002C4h, 002C4h, 002C5h
             dw 002C6h, 002C7h, 002C8h, 002C9h, 002C9h, 002CAh, 002CBh, 002CCh
             dw 002CDh, 002CEh, 002CEh, 002CFh, 002D0h, 002D1h, 002D2h, 002D3h
             dw 002D3h, 002D4h, 002D5h, 002D6h, 002D7h, 002D8h, 002D8h, 002D9h
             dw 002DAh, 002DBh, 002DCh, 002DDh, 002DDh, 002DEh, 002DFh, 002E0h
             dw 002E1h, 002E1h, 002E2h, 002E3h, 002E4h, 002E5h, 002E6h, 002E6h
             dw 002E7h, 002E8h, 002E9h, 002EAh, 002EBh, 002EBh, 002ECh, 002EDh
             dw 002EEh, 002EFh, 002EFh, 002F0h, 002F1h, 002F2h, 002F3h, 002F3h
             dw 002F4h, 002F5h, 002F6h, 002F7h, 002F8h, 002F8h, 002F9h, 002FAh
             dw 002FBh, 002FCh, 002FCh, 002FDh, 002FEh, 002FFh, 00300h, 00300h
             dw 00301h, 00302h, 00303h, 00304h, 00304h, 00305h, 00306h, 00307h
             dw 00308h, 00308h, 00309h, 0030Ah, 0030Bh, 0030Ch, 0030Dh, 0030Dh
             dw 0030Eh, 0030Fh, 00310h, 00310h, 00311h, 00312h, 00313h, 00314h
             dw 00314h, 00315h, 00316h, 00317h, 00318h, 00318h, 00319h, 0031Ah
             dw 0031Bh, 0031Ch, 0031Ch, 0031Dh, 0031Eh, 0031Fh, 00320h, 00320h
             dw 00321h, 00322h, 00323h, 00324h, 00324h, 00325h, 00326h, 00327h
             dw 00327h, 00328h, 00329h, 0032Ah, 0032Bh, 0032Bh, 0032Ch, 0032Dh
             dw 0032Eh, 0032Eh, 0032Fh, 00330h, 00331h, 00332h, 00332h, 00333h
             dw 00334h, 00335h, 00335h, 00336h, 00337h, 00338h, 00339h, 00339h
             dw 0033Ah, 0033Bh, 0033Ch, 0033Ch, 0033Dh, 0033Eh, 0033Fh, 00340h
             dw 00340h, 00341h, 00342h, 00343h, 00343h, 00344h, 00345h, 00346h
             dw 00346h, 00347h, 00348h, 00349h, 00349h, 0034Ah, 0034Bh, 0034Ch
             dw 0034Dh, 0034Dh, 0034Eh, 0034Fh, 00350h, 00350h, 00351h, 00352h
             dw 00353h, 00353h, 00354h, 00355h, 00356h, 00356h, 00357h, 00358h
             dw 00359h, 00359h, 0035Ah, 0035Bh, 0035Ch, 0035Ch, 0035Dh, 0035Eh
             dw 0035Fh, 0035Fh, 00360h, 00361h, 00362h, 00362h, 00363h, 00364h
             dw 00365h, 00365h, 00366h, 00367h, 00368h, 00368h, 00369h, 0036Ah
             dw 0036Bh, 0036Bh, 0036Ch, 0036Dh, 0036Dh, 0036Eh, 0036Fh, 00370h
             dw 00370h, 00371h, 00372h, 00373h, 00373h, 00374h, 00375h, 00376h
             dw 00376h, 00377h, 00378h, 00379h, 00379h, 0037Ah, 0037Bh, 0037Bh
             dw 0037Ch, 0037Dh, 0037Eh, 0037Eh, 0037Fh, 00380h, 00381h, 00381h
             dw 00382h, 00383h, 00383h, 00384h, 00385h, 00386h, 00386h, 00387h
             dw 00388h, 00388h, 00389h, 0038Ah, 0038Bh, 0038Bh, 0038Ch, 0038Dh
             dw 0038Dh, 0038Eh, 0038Fh, 00390h, 00390h, 00391h, 00392h, 00392h
             dw 00393h, 00394h, 00395h, 00395h, 00396h, 00397h, 00397h, 00398h
             dw 00399h, 0039Ah, 0039Ah, 0039Bh, 0039Ch, 0039Ch, 0039Dh, 0039Eh
             dw 0039Eh, 0039Fh, 003A0h, 003A1h, 003A1h, 003A2h, 003A3h, 003A3h
             dw 003A4h, 003A5h, 003A5h, 003A6h, 003A7h, 003A8h, 003A8h, 003A9h
             dw 003AAh, 003AAh, 003ABh, 003ACh, 003ACh, 003ADh, 003AEh, 003AFh
             dw 003AFh, 003B0h, 003B1h, 003B1h, 003B2h, 003B3h, 003B3h, 003B4h
             dw 003B5h, 003B5h, 003B6h, 003B7h, 003B7h, 003B8h, 003B9h, 003B9h
             dw 003BAh, 003BBh, 003BCh, 003BCh, 003BDh, 003BEh, 003BEh, 003BFh
             dw 003C0h, 003C0h, 003C1h, 003C2h, 003C2h, 003C3h, 003C4h, 003C4h
             dw 003C5h, 003C6h, 003C6h, 003C7h, 003C8h, 003C8h, 003C9h, 003CAh
             dw 003CAh, 003CBh, 003CCh, 003CCh, 003CDh, 003CEh, 003CEh, 003CFh
             dw 003D0h, 003D0h, 003D1h, 003D2h, 003D2h, 003D3h, 003D4h, 003D4h
             dw 003D5h, 003D6h, 003D6h, 003D7h, 003D8h, 003D8h, 003D9h, 003D9h
             dw 003DAh, 003DBh, 003DBh, 003DCh, 003DDh, 003DDh, 003DEh, 003DFh
             dw 003DFh, 003E0h, 003E1h, 003E1h, 003E2h, 003E3h, 003E3h, 003E4h
             dw 003E5h, 003E5h, 003E6h, 003E6h, 003E7h, 003E8h, 003E8h, 003E9h
             dw 003EAh, 003EAh, 003EBh, 003ECh, 003ECh, 003EDh, 003EDh, 003EEh
             dw 003EFh, 003EFh, 003F0h, 003F1h, 003F1h, 003F2h, 003F3h, 003F3h
             dw 003F4h, 003F4h, 003F5h, 003F6h, 003F6h, 003F7h, 003F8h, 003F8h
             dw 003F9h, 003F9h, 003FAh, 003FBh, 003FBh, 003FCh, 003FDh, 003FDh
             dw 003FEh, 003FEh, 003FFh, 00400h, 00400h, 00401h, 00401h, 00402h
             dw 00403h, 00403h, 00404h, 00405h, 00405h, 00406h, 00406h, 00407h
             dw 00408h, 00408h, 00409h, 00409h, 0040Ah, 0040Bh, 0040Bh, 0040Ch
             dw 0040Ch, 0040Dh, 0040Eh, 0040Eh, 0040Fh, 0040Fh, 00410h, 00411h
             dw 00411h, 00412h, 00412h, 00413h, 00414h, 00414h, 00415h, 00415h
             dw 00416h, 00417h, 00417h, 00418h, 00418h, 00419h, 0041Ah, 0041Ah
             dw 0041Bh, 0041Bh, 0041Ch, 0041Dh, 0041Dh, 0041Eh, 0041Eh, 0041Fh
             dw 00420h, 00420h, 00421h, 00421h, 00422h, 00422h, 00423h, 00424h
             dw 00424h, 00425h, 00425h, 00426h, 00427h, 00427h, 00428h, 00428h
             dw 00429h, 00429h, 0042Ah, 0042Bh, 0042Bh, 0042Ch, 0042Ch, 0042Dh
             dw 0042Dh, 0042Eh, 0042Fh, 0042Fh, 00430h, 00430h, 00431h, 00431h
             dw 00432h, 00433h, 00433h, 00434h, 00434h, 00435h, 00435h, 00436h
             dw 00436h, 00437h, 00438h, 00438h, 00439h, 00439h, 0043Ah, 0043Ah
             dw 0043Bh, 0043Bh, 0043Ch, 0043Dh, 0043Dh, 0043Eh, 0043Eh, 0043Fh
             dw 0043Fh, 00440h, 00440h, 00441h, 00442h, 00442h, 00443h, 00443h
             dw 00444h, 00444h, 00445h, 00445h, 00446h, 00446h, 00447h, 00448h
             dw 00448h, 00449h, 00449h, 0044Ah, 0044Ah, 0044Bh, 0044Bh, 0044Ch
             dw 0044Ch, 0044Dh, 0044Dh, 0044Eh, 0044Eh, 0044Fh, 00450h, 00450h
             dw 00451h, 00451h, 00452h, 00452h, 00453h, 00453h, 00454h, 00454h
             dw 00455h, 00455h, 00456h, 00456h, 00457h, 00457h, 00458h, 00458h
             dw 00459h, 0045Ah, 0045Ah, 0045Bh, 0045Bh, 0045Ch, 0045Ch, 0045Dh
             dw 0045Dh, 0045Eh, 0045Eh, 0045Fh, 0045Fh, 00460h, 00460h, 00461h
             dw 00461h, 00462h, 00462h, 00463h, 00463h, 00464h, 00464h, 00465h
             dw 00465h, 00466h, 00466h, 00467h, 00467h, 00468h, 00468h, 00469h
             dw 00469h, 0046Ah, 0046Ah, 0046Bh, 0046Bh, 0046Ch, 0046Ch, 0046Dh
             dw 0046Dh, 0046Eh, 0046Eh, 0046Fh, 0046Fh, 00470h, 00470h, 00471h
             dw 00471h, 00472h, 00472h, 00473h, 00473h, 00474h, 00474h, 00475h
             dw 00475h, 00476h, 00476h, 00476h, 00477h, 00477h, 00478h, 00478h
             dw 00479h, 00479h, 0047Ah, 0047Ah, 0047Bh, 0047Bh, 0047Ch, 0047Ch
             dw 0047Dh, 0047Dh, 0047Eh, 0047Eh, 0047Fh, 0047Fh, 0047Fh, 00480h
             dw 00480h, 00481h, 00481h, 00482h, 00482h, 00483h, 00483h, 00484h
             dw 00484h, 00485h, 00485h, 00485h, 00486h, 00486h, 00487h, 00487h
             dw 00488h, 00488h, 00489h, 00489h, 0048Ah, 0048Ah, 0048Ah, 0048Bh
             dw 0048Bh, 0048Ch, 0048Ch, 0048Dh, 0048Dh, 0048Eh, 0048Eh, 0048Eh
             dw 0048Fh, 0048Fh, 00490h, 00490h, 00491h, 00491h, 00492h, 00492h
             dw 00492h, 00493h, 00493h, 00494h, 00494h, 00495h, 00495h, 00496h
             dw 00496h, 00496h, 00497h, 00497h, 00498h, 00498h, 00499h, 00499h
             dw 00499h, 0049Ah, 0049Ah, 0049Bh, 0049Bh, 0049Ch, 0049Ch, 0049Ch
             dw 0049Dh, 0049Dh, 0049Eh, 0049Eh, 0049Eh, 0049Fh, 0049Fh, 004A0h
             dw 004A0h, 004A1h, 004A1h, 004A1h, 004A2h, 004A2h, 004A3h, 004A3h
             dw 004A3h, 004A4h, 004A4h, 004A5h, 004A5h, 004A5h, 004A6h, 004A6h
             dw 004A7h, 004A7h, 004A8h, 004A8h, 004A8h, 004A9h, 004A9h, 004AAh
             dw 004AAh, 004AAh, 004ABh, 004ABh, 004ACh, 004ACh, 004ACh, 004ADh
             dw 004ADh, 004ADh, 004AEh, 004AEh, 004AFh, 004AFh, 004AFh, 004B0h
             dw 004B0h, 004B1h, 004B1h, 004B1h, 004B2h, 004B2h, 004B3h, 004B3h
             dw 004B3h, 004B4h, 004B4h, 004B4h, 004B5h, 004B5h, 004B6h, 004B6h
             dw 004B6h, 004B7h, 004B7h, 004B7h, 004B8h, 004B8h, 004B9h, 004B9h
             dw 004B9h, 004BAh, 004BAh, 004BAh, 004BBh, 004BBh, 004BCh, 004BCh
             dw 004BCh, 004BDh, 004BDh, 004BDh, 004BEh, 004BEh, 004BEh, 004BFh
             dw 004BFh, 004C0h, 004C0h, 004C0h, 004C1h, 004C1h, 004C1h, 004C2h
             dw 004C2h, 004C2h, 004C3h, 004C3h, 004C3h, 004C4h, 004C4h, 004C5h
             dw 004C5h, 004C5h, 004C6h, 004C6h, 004C6h, 004C7h, 004C7h, 004C7h
             dw 004C8h, 004C8h, 004C8h, 004C9h, 004C9h, 004C9h, 004CAh, 004CAh
             dw 004CAh, 004CBh, 004CBh, 004CBh, 004CCh, 004CCh, 004CCh, 004CDh
             dw 004CDh, 004CDh, 004CEh, 004CEh, 004CEh, 004CFh, 004CFh, 004CFh
             dw 004D0h, 004D0h, 004D0h, 004D1h, 004D1h, 004D1h, 004D2h, 004D2h
             dw 004D2h, 004D3h, 004D3h, 004D3h, 004D3h, 004D4h, 004D4h, 004D4h
             dw 004D5h, 004D5h, 004D5h, 004D6h, 004D6h, 004D6h, 004D7h, 004D7h
             dw 004D7h, 004D8h, 004D8h, 004D8h, 004D8h, 004D9h, 004D9h, 004D9h
             dw 004DAh, 004DAh, 004DAh, 004DBh, 004DBh, 004DBh, 004DBh, 004DCh
             dw 004DCh, 004DCh, 004DDh, 004DDh, 004DDh, 004DEh, 004DEh, 004DEh
             dw 004DEh, 004DFh, 004DFh, 004DFh, 004E0h, 004E0h, 004E0h, 004E0h
             dw 004E1h, 004E1h, 004E1h, 004E2h, 004E2h, 004E2h, 004E2h, 004E3h
             dw 004E3h, 004E3h, 004E3h, 004E4h, 004E4h, 004E4h, 004E5h, 004E5h
             dw 004E5h, 004E5h, 004E6h, 004E6h, 004E6h, 004E6h, 004E7h, 004E7h
             dw 004E7h, 004E8h, 004E8h, 004E8h, 004E8h, 004E9h, 004E9h, 004E9h
             dw 004E9h, 004EAh, 004EAh, 004EAh, 004EAh, 004EBh, 004EBh, 004EBh
             dw 004EBh, 004ECh, 004ECh, 004ECh, 004ECh, 004EDh, 004EDh, 004EDh
             dw 004EDh, 004EEh, 004EEh, 004EEh, 004EEh, 004EFh, 004EFh, 004EFh
             dw 004EFh, 004F0h, 004F0h, 004F0h, 004F0h, 004F1h, 004F1h, 004F1h
             dw 004F1h, 004F2h, 004F2h, 004F2h, 004F2h, 004F3h, 004F3h, 004F3h
             dw 004F3h, 004F3h, 004F4h, 004F4h, 004F4h, 004F4h, 004F5h, 004F5h
             dw 004F5h, 004F5h, 004F6h, 004F6h, 004F6h, 004F6h, 004F6h, 004F7h
             dw 004F7h, 004F7h, 004F7h, 004F7h, 004F8h, 004F8h, 004F8h, 004F8h
             dw 004F9h, 004F9h, 004F9h, 004F9h, 004F9h, 004FAh, 004FAh, 004FAh
             dw 004FAh, 004FAh, 004FBh, 004FBh, 004FBh, 004FBh, 004FBh, 004FCh
             dw 004FCh, 004FCh, 004FCh, 004FCh, 004FDh, 004FDh, 004FDh, 004FDh
             dw 004FDh, 004FEh, 004FEh, 004FEh, 004FEh, 004FEh, 004FFh, 004FFh
             dw 004FFh, 004FFh, 004FFh, 00500h, 00500h, 00500h, 00500h, 00500h
             dw 00500h, 00501h, 00501h, 00501h, 00501h, 00501h, 00502h, 00502h
             dw 00502h, 00502h, 00502h, 00502h, 00503h, 00503h, 00503h, 00503h
             dw 00503h, 00503h, 00504h, 00504h, 00504h, 00504h, 00504h, 00504h
             dw 00505h, 00505h, 00505h, 00505h, 00505h, 00505h, 00506h, 00506h
             dw 00506h, 00506h, 00506h, 00506h, 00507h, 00507h, 00507h, 00507h
             dw 00507h, 00507h, 00508h, 00508h, 00508h, 00508h, 00508h, 00508h
             dw 00508h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h
             dw 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Bh
             dw 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Ch
             dw 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Dh
             dw 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Eh
             dw 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh
             dw 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh
             dw 0050Fh, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h
             dw 00510h, 00510h, 00510h, 00511h, 00511h, 00511h, 00511h, 00511h
             dw 00511h, 00511h, 00511h, 00511h, 00511h, 00511h, 00512h, 00512h
             dw 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h
             dw 00512h, 00512h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00512h
             dw 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h
             dw 00512h, 00512h, 00512h, 00511h, 00511h, 00511h, 00511h, 00511h
             dw 00511h, 00511h, 00511h, 00511h, 00511h, 00511h, 00510h, 00510h
             dw 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h
             dw 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh
             dw 0050Fh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh
             dw 0050Eh, 0050Eh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh
             dw 0050Dh, 0050Dh, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch
             dw 0050Ch, 0050Ch, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh
             dw 0050Bh, 0050Bh, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah
             dw 0050Ah, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h
             dw 00508h, 00508h, 00508h, 00508h, 00508h, 00508h, 00508h, 00507h
             dw 00507h, 00507h, 00507h, 00507h, 00507h, 00506h, 00506h, 00506h
             dw 00506h, 00506h, 00506h, 00505h, 00505h, 00505h, 00505h, 00505h
             dw 00505h, 00504h, 00504h, 00504h, 00504h, 00504h, 00504h, 00503h
             dw 00503h, 00503h, 00503h, 00503h, 00503h, 00502h, 00502h, 00502h
             dw 00502h, 00502h, 00502h, 00501h, 00501h, 00501h, 00501h, 00501h
             dw 00500h, 00500h, 00500h, 00500h, 00500h, 00500h, 004FFh, 004FFh
             dw 004FFh, 004FFh, 004FFh, 004FEh, 004FEh, 004FEh, 004FEh, 004FEh
             dw 004FDh, 004FDh, 004FDh, 004FDh, 004FDh, 004FCh, 004FCh, 004FCh
             dw 004FCh, 004FCh, 004FBh, 004FBh, 004FBh, 004FBh, 004FBh, 004FAh
             dw 004FAh, 004FAh, 004FAh, 004FAh, 004F9h, 004F9h, 004F9h, 004F9h
             dw 004F9h, 004F8h, 004F8h, 004F8h, 004F8h, 004F7h, 004F7h, 004F7h
             dw 004F7h, 004F7h, 004F6h, 004F6h, 004F6h, 004F6h, 004F6h, 004F5h
             dw 004F5h, 004F5h, 004F5h, 004F4h, 004F4h, 004F4h, 004F4h, 004F3h
             dw 004F3h, 004F3h, 004F3h, 004F3h, 004F2h, 004F2h, 004F2h, 004F2h
             dw 004F1h, 004F1h, 004F1h, 004F1h, 004F0h, 004F0h, 004F0h, 004F0h
             dw 004EFh, 004EFh, 004EFh, 004EFh, 004EEh, 004EEh, 004EEh, 004EEh
             dw 004EDh, 004EDh, 004EDh, 004EDh, 004ECh, 004ECh, 004ECh, 004ECh
             dw 004EBh, 004EBh, 004EBh, 004EBh, 004EAh, 004EAh, 004EAh, 004EAh
             dw 004E9h, 004E9h, 004E9h, 004E9h, 004E8h, 004E8h, 004E8h, 004E8h
             dw 004E7h, 004E7h, 004E7h, 004E6h, 004E6h, 004E6h, 004E6h, 004E5h
             dw 004E5h, 004E5h, 004E5h, 004E4h, 004E4h, 004E4h, 004E3h, 004E3h
             dw 004E3h, 004E3h, 004E2h, 004E2h, 004E2h, 004E2h, 004E1h, 004E1h
             dw 004E1h, 004E0h, 004E0h, 004E0h, 004E0h, 004DFh, 004DFh, 004DFh
             dw 004DEh, 004DEh, 004DEh, 004DEh, 004DDh, 004DDh, 004DDh, 004DCh
             dw 004DCh, 004DCh, 004DBh, 004DBh, 004DBh, 004DBh, 004DAh, 004DAh
             dw 004DAh, 004D9h, 004D9h, 004D9h, 004D8h, 004D8h, 004D8h, 004D8h
             dw 004D7h, 004D7h, 004D7h, 004D6h, 004D6h, 004D6h, 004D5h, 004D5h
             dw 004D5h, 004D4h, 004D4h, 004D4h, 004D3h, 004D3h, 004D3h, 004D3h
             dw 004D2h, 004D2h, 004D2h, 004D1h, 004D1h, 004D1h, 004D0h, 004D0h
             dw 004D0h, 004CFh, 004CFh, 004CFh, 004CEh, 004CEh, 004CEh, 004CDh
             dw 004CDh, 004CDh, 004CCh, 004CCh, 004CCh, 004CBh, 004CBh, 004CBh
             dw 004CAh, 004CAh, 004CAh, 004C9h, 004C9h, 004C9h, 004C8h, 004C8h
             dw 004C8h, 004C7h, 004C7h, 004C7h, 004C6h, 004C6h, 004C6h, 004C5h
             dw 004C5h, 004C5h, 004C4h, 004C4h, 004C3h, 004C3h, 004C3h, 004C2h
             dw 004C2h, 004C2h, 004C1h, 004C1h, 004C1h, 004C0h, 004C0h, 004C0h
             dw 004BFh, 004BFh, 004BEh, 004BEh, 004BEh, 004BDh, 004BDh, 004BDh
             dw 004BCh, 004BCh, 004BCh, 004BBh, 004BBh, 004BAh, 004BAh, 004BAh
             dw 004B9h, 004B9h, 004B9h, 004B8h, 004B8h, 004B7h, 004B7h, 004B7h
             dw 004B6h, 004B6h, 004B6h, 004B5h, 004B5h, 004B4h, 004B4h, 004B4h
             dw 004B3h, 004B3h, 004B3h, 004B2h, 004B2h, 004B1h, 004B1h, 004B1h
             dw 004B0h, 004B0h, 004AFh, 004AFh, 004AFh, 004AEh, 004AEh, 004ADh
             dw 004ADh, 004ADh, 004ACh, 004ACh, 004ACh, 004ABh, 004ABh, 004AAh
             dw 004AAh, 004AAh, 004A9h, 004A9h, 004A8h, 004A8h, 004A8h, 004A7h
             dw 004A7h, 004A6h, 004A6h, 004A5h, 004A5h, 004A5h, 004A4h, 004A4h
             dw 004A3h, 004A3h, 004A3h, 004A2h, 004A2h, 004A1h, 004A1h, 004A1h
             dw 004A0h, 004A0h, 0049Fh, 0049Fh, 0049Eh, 0049Eh, 0049Eh, 0049Dh
             dw 0049Dh, 0049Ch, 0049Ch, 0049Ch, 0049Bh, 0049Bh, 0049Ah, 0049Ah
             dw 00499h, 00499h, 00499h, 00498h, 00498h, 00497h, 00497h, 00496h
             dw 00496h, 00496h, 00495h, 00495h, 00494h, 00494h, 00493h, 00493h
             dw 00492h, 00492h, 00492h, 00491h, 00491h, 00490h, 00490h, 0048Fh
             dw 0048Fh, 0048Eh, 0048Eh, 0048Eh, 0048Dh, 0048Dh, 0048Ch, 0048Ch
             dw 0048Bh, 0048Bh, 0048Ah, 0048Ah, 0048Ah, 00489h, 00489h, 00488h
             dw 00488h, 00487h, 00487h, 00486h, 00486h, 00485h, 00485h, 00485h
             dw 00484h, 00484h, 00483h, 00483h, 00482h, 00482h, 00481h, 00481h
             dw 00480h, 00480h, 0047Fh, 0047Fh, 0047Fh, 0047Eh, 0047Eh, 0047Dh
             dw 0047Dh, 0047Ch, 0047Ch, 0047Bh, 0047Bh, 0047Ah, 0047Ah, 00479h
             dw 00479h, 00478h, 00478h, 00477h, 00477h, 00476h, 00476h, 00476h
             dw 00475h, 00475h, 00474h, 00474h, 00473h, 00473h, 00472h, 00472h
             dw 00471h, 00471h, 00470h, 00470h, 0046Fh, 0046Fh, 0046Eh, 0046Eh
             dw 0046Dh, 0046Dh, 0046Ch, 0046Ch, 0046Bh, 0046Bh, 0046Ah, 0046Ah
             dw 00469h, 00469h, 00468h, 00468h, 00467h, 00467h, 00466h, 00466h
             dw 00465h, 00465h, 00464h, 00464h, 00463h, 00463h, 00462h, 00462h
             dw 00461h, 00461h, 00460h, 00460h, 0045Fh, 0045Fh, 0045Eh, 0045Eh
             dw 0045Dh, 0045Dh, 0045Ch, 0045Ch, 0045Bh, 0045Bh, 0045Ah, 0045Ah
             dw 00459h, 00458h, 00458h, 00457h, 00457h, 00456h, 00456h, 00455h
             dw 00455h, 00454h, 00454h, 00453h, 00453h, 00452h, 00452h, 00451h
             dw 00451h, 00450h, 00450h, 0044Fh, 0044Eh, 0044Eh, 0044Dh, 0044Dh
             dw 0044Ch, 0044Ch, 0044Bh, 0044Bh, 0044Ah, 0044Ah, 00449h, 00449h
             dw 00448h, 00448h, 00447h, 00446h, 00446h, 00445h, 00445h, 00444h
             dw 00444h, 00443h, 00443h, 00442h, 00442h, 00441h, 00440h, 00440h
             dw 0043Fh, 0043Fh, 0043Eh, 0043Eh, 0043Dh, 0043Dh, 0043Ch, 0043Bh
             dw 0043Bh, 0043Ah, 0043Ah, 00439h, 00439h, 00438h, 00438h, 00437h
             dw 00436h, 00436h, 00435h, 00435h, 00434h, 00434h, 00433h, 00433h
             dw 00432h, 00431h, 00431h, 00430h, 00430h, 0042Fh, 0042Fh, 0042Eh
             dw 0042Dh, 0042Dh, 0042Ch, 0042Ch, 0042Bh, 0042Bh, 0042Ah, 00429h
             dw 00429h, 00428h, 00428h, 00427h, 00427h, 00426h, 00425h, 00425h
             dw 00424h, 00424h, 00423h, 00422h, 00422h, 00421h, 00421h, 00420h
             dw 00420h, 0041Fh, 0041Eh, 0041Eh, 0041Dh, 0041Dh, 0041Ch, 0041Bh
             dw 0041Bh, 0041Ah, 0041Ah, 00419h, 00418h, 00418h, 00417h, 00417h
             dw 00416h, 00415h, 00415h, 00414h, 00414h, 00413h, 00412h, 00412h
             dw 00411h, 00411h, 00410h, 0040Fh, 0040Fh, 0040Eh, 0040Eh, 0040Dh
             dw 0040Ch, 0040Ch, 0040Bh, 0040Bh, 0040Ah, 00409h, 00409h, 00408h
             dw 00408h, 00407h, 00406h, 00406h, 00405h, 00405h, 00404h, 00403h
             dw 00403h, 00402h, 00401h, 00401h, 00400h, 00400h, 003FFh, 003FEh
             dw 003FEh, 003FDh, 003FDh, 003FCh, 003FBh, 003FBh, 003FAh, 003F9h
             dw 003F9h, 003F8h, 003F8h, 003F7h, 003F6h, 003F6h, 003F5h, 003F4h
             dw 003F4h, 003F3h, 003F3h, 003F2h, 003F1h, 003F1h, 003F0h, 003EFh
             dw 003EFh, 003EEh, 003EDh, 003EDh, 003ECh, 003ECh, 003EBh, 003EAh
             dw 003EAh, 003E9h, 003E8h, 003E8h, 003E7h, 003E6h, 003E6h, 003E5h
             dw 003E5h, 003E4h, 003E3h, 003E3h, 003E2h, 003E1h, 003E1h, 003E0h
             dw 003DFh, 003DFh, 003DEh, 003DDh, 003DDh, 003DCh, 003DBh, 003DBh
             dw 003DAh, 003D9h, 003D9h, 003D8h, 003D8h, 003D7h, 003D6h, 003D6h
             dw 003D5h, 003D4h, 003D4h, 003D3h, 003D2h, 003D2h, 003D1h, 003D0h
             dw 003D0h, 003CFh, 003CEh, 003CEh, 003CDh, 003CCh, 003CCh, 003CBh
             dw 003CAh, 003CAh, 003C9h, 003C8h, 003C8h, 003C7h, 003C6h, 003C6h
             dw 003C5h, 003C4h, 003C4h, 003C3h, 003C2h, 003C2h, 003C1h, 003C0h
             dw 003C0h, 003BFh, 003BEh, 003BEh, 003BDh, 003BCh, 003BCh, 003BBh
             dw 003BAh, 003B9h, 003B9h, 003B8h, 003B7h, 003B7h, 003B6h, 003B5h
             dw 003B5h, 003B4h, 003B3h, 003B3h, 003B2h, 003B1h, 003B1h, 003B0h
             dw 003AFh, 003AFh, 003AEh, 003ADh, 003ACh, 003ACh, 003ABh, 003AAh
             dw 003AAh, 003A9h, 003A8h, 003A8h, 003A7h, 003A6h, 003A5h, 003A5h
             dw 003A4h, 003A3h, 003A3h, 003A2h, 003A1h, 003A1h, 003A0h, 0039Fh
             dw 0039Eh, 0039Eh, 0039Dh, 0039Ch, 0039Ch, 0039Bh, 0039Ah, 0039Ah
             dw 00399h, 00398h, 00397h, 00397h, 00396h, 00395h, 00395h, 00394h
             dw 00393h, 00392h, 00392h, 00391h, 00390h, 00390h, 0038Fh, 0038Eh
             dw 0038Dh, 0038Dh, 0038Ch, 0038Bh, 0038Bh, 0038Ah, 00389h, 00388h
             dw 00388h, 00387h, 00386h, 00386h, 00385h, 00384h, 00383h, 00383h
             dw 00382h, 00381h, 00381h, 00380h, 0037Fh, 0037Eh, 0037Eh, 0037Dh
             dw 0037Ch, 0037Bh, 0037Bh, 0037Ah, 00379h, 00379h, 00378h, 00377h
             dw 00376h, 00376h, 00375h, 00374h, 00373h, 00373h, 00372h, 00371h
             dw 00370h, 00370h, 0036Fh, 0036Eh, 0036Dh, 0036Dh, 0036Ch, 0036Bh
             dw 0036Bh, 0036Ah, 00369h, 00368h, 00368h, 00367h, 00366h, 00365h
             dw 00365h, 00364h, 00363h, 00362h, 00362h, 00361h, 00360h, 0035Fh
             dw 0035Fh, 0035Eh, 0035Dh, 0035Ch, 0035Ch, 0035Bh, 0035Ah, 00359h
             dw 00359h, 00358h, 00357h, 00356h, 00356h, 00355h, 00354h, 00353h
             dw 00353h, 00352h, 00351h, 00350h, 00350h, 0034Fh, 0034Eh, 0034Dh
             dw 0034Dh, 0034Ch, 0034Bh, 0034Ah, 00349h, 00349h, 00348h, 00347h
             dw 00346h, 00346h, 00345h, 00344h, 00343h, 00343h, 00342h, 00341h
             dw 00340h, 00340h, 0033Fh, 0033Eh, 0033Dh, 0033Ch, 0033Ch, 0033Bh
             dw 0033Ah, 00339h, 00339h, 00338h, 00337h, 00336h, 00335h, 00335h
             dw 00334h, 00333h, 00332h, 00332h, 00331h, 00330h, 0032Fh, 0032Eh
             dw 0032Eh, 0032Dh, 0032Ch, 0032Bh, 0032Bh, 0032Ah, 00329h, 00328h
             dw 00327h, 00327h, 00326h, 00325h, 00324h, 00324h, 00323h, 00322h
             dw 00321h, 00320h, 00320h, 0031Fh, 0031Eh, 0031Dh, 0031Ch, 0031Ch
             dw 0031Bh, 0031Ah, 00319h, 00318h, 00318h, 00317h, 00316h, 00315h
             dw 00314h, 00314h, 00313h, 00312h, 00311h, 00310h, 00310h, 0030Fh
             dw 0030Eh, 0030Dh, 0030Dh, 0030Ch, 0030Bh, 0030Ah, 00309h, 00308h
             dw 00308h, 00307h, 00306h, 00305h, 00304h, 00304h, 00303h, 00302h
             dw 00301h, 00300h, 00300h, 002FFh, 002FEh, 002FDh, 002FCh, 002FCh
             dw 002FBh, 002FAh, 002F9h, 002F8h, 002F8h, 002F7h, 002F6h, 002F5h
             dw 002F4h, 002F3h, 002F3h, 002F2h, 002F1h, 002F0h, 002EFh, 002EFh
             dw 002EEh, 002EDh, 002ECh, 002EBh, 002EBh, 002EAh, 002E9h, 002E8h
             dw 002E7h, 002E6h, 002E6h, 002E5h, 002E4h, 002E3h, 002E2h, 002E1h
             dw 002E1h, 002E0h, 002DFh, 002DEh, 002DDh, 002DDh, 002DCh, 002DBh
             dw 002DAh, 002D9h, 002D8h, 002D8h, 002D7h, 002D6h, 002D5h, 002D4h
             dw 002D3h, 002D3h, 002D2h, 002D1h, 002D0h, 002CFh, 002CEh, 002CEh
             dw 002CDh, 002CCh, 002CBh, 002CAh, 002C9h, 002C9h, 002C8h, 002C7h
             dw 002C6h, 002C5h, 002C4h, 002C4h, 002C3h, 002C2h, 002C1h, 002C0h
             dw 002BFh, 002BFh, 002BEh, 002BDh, 002BCh, 002BBh, 002BAh, 002B9h
             dw 002B9h, 002B8h, 002B7h, 002B6h, 002B5h, 002B4h, 002B4h, 002B3h
             dw 002B2h, 002B1h, 002B0h, 002AFh, 002AEh, 002AEh, 002ADh, 002ACh
             dw 002ABh, 002AAh, 002A9h, 002A8h, 002A8h, 002A7h, 002A6h, 002A5h
             dw 002A4h, 002A3h, 002A3h, 002A2h, 002A1h, 002A0h, 0029Fh, 0029Eh
             dw 0029Dh, 0029Dh, 0029Ch, 0029Bh, 0029Ah, 00299h, 00298h, 00297h
             dw 00297h, 00296h, 00295h, 00294h, 00293h, 00292h, 00291h, 00290h
             dw 00290h, 0028Fh, 0028Eh, 0028Dh, 0028Ch, 0028Bh, 0028Ah, 0028Ah
             dw 00289h, 00288h, 00287h, 00286h, 00285h, 00284h, 00283h, 00283h
             dw 00282h, 00281h, 00280h, 0027Fh, 0027Eh, 0027Dh, 0027Dh, 0027Ch
             dw 0027Bh, 0027Ah, 00279h, 00278h, 00277h, 00276h, 00276h, 00275h
             dw 00274h, 00273h, 00272h, 00271h, 00270h, 0026Fh, 0026Fh, 0026Eh
             dw 0026Dh, 0026Ch, 0026Bh, 0026Ah, 00269h, 00268h, 00267h, 00267h
             dw 00266h, 00265h, 00264h, 00263h, 00262h, 00261h, 00260h, 00260h
             dw 0025Fh, 0025Eh, 0025Dh, 0025Ch, 0025Bh, 0025Ah, 00259h, 00258h
             dw 00258h, 00257h, 00256h, 00255h, 00254h, 00253h, 00252h, 00251h
             dw 00250h, 00250h, 0024Fh, 0024Eh, 0024Dh, 0024Ch, 0024Bh, 0024Ah
             dw 00249h, 00248h, 00248h, 00247h, 00246h, 00245h, 00244h, 00243h
             dw 00242h, 00241h, 00240h, 00240h, 0023Fh, 0023Eh, 0023Dh, 0023Ch
             dw 0023Bh, 0023Ah, 00239h, 00238h, 00237h, 00237h, 00236h, 00235h
             dw 00234h, 00233h, 00232h, 00231h, 00230h, 0022Fh, 0022Eh, 0022Eh
             dw 0022Dh, 0022Ch, 0022Bh, 0022Ah, 00229h, 00228h, 00227h, 00226h
             dw 00225h, 00224h, 00224h, 00223h, 00222h, 00221h, 00220h, 0021Fh
             dw 0021Eh, 0021Dh, 0021Ch, 0021Bh, 0021Ah, 0021Ah, 00219h, 00218h
             dw 00217h, 00216h, 00215h, 00214h, 00213h, 00212h, 00211h, 00210h
             dw 00210h, 0020Fh, 0020Eh, 0020Dh, 0020Ch, 0020Bh, 0020Ah, 00209h
             dw 00208h, 00207h, 00206h, 00205h, 00205h, 00204h, 00203h, 00202h
             dw 00201h, 00200h, 001FFh, 001FEh, 001FDh, 001FCh, 001FBh, 001FAh
             dw 001FAh, 001F9h, 001F8h, 001F7h, 001F6h, 001F5h, 001F4h, 001F3h
             dw 001F2h, 001F1h, 001F0h, 001EFh, 001EEh, 001EEh, 001EDh, 001ECh
             dw 001EBh, 001EAh, 001E9h, 001E8h, 001E7h, 001E6h, 001E5h, 001E4h
             dw 001E3h, 001E2h, 001E1h, 001E1h, 001E0h, 001DFh, 001DEh, 001DDh
             dw 001DCh, 001DBh, 001DAh, 001D9h, 001D8h, 001D7h, 001D6h, 001D5h
             dw 001D4h, 001D4h, 001D3h, 001D2h, 001D1h, 001D0h, 001CFh, 001CEh
             dw 001CDh, 001CCh, 001CBh, 001CAh, 001C9h, 001C8h, 001C7h, 001C6h
             dw 001C5h, 001C5h, 001C4h, 001C3h, 001C2h, 001C1h, 001C0h, 001BFh
             dw 001BEh, 001BDh, 001BCh, 001BBh, 001BAh, 001B9h, 001B8h, 001B7h
             dw 001B6h, 001B6h, 001B5h, 001B4h, 001B3h, 001B2h, 001B1h, 001B0h
             dw 001AFh, 001AEh, 001ADh, 001ACh, 001ABh, 001AAh, 001A9h, 001A8h
             dw 001A7h, 001A6h, 001A5h, 001A5h, 001A4h, 001A3h, 001A2h, 001A1h
             dw 001A0h, 0019Fh, 0019Eh, 0019Dh, 0019Ch, 0019Bh, 0019Ah, 00199h
             dw 00198h, 00197h, 00196h, 00195h, 00194h, 00193h, 00193h, 00192h
             dw 00191h, 00190h, 0018Fh, 0018Eh, 0018Dh, 0018Ch, 0018Bh, 0018Ah
             dw 00189h, 00188h, 00187h, 00186h, 00185h, 00184h, 00183h, 00182h
             dw 00181h, 00180h, 0017Fh, 0017Fh, 0017Eh, 0017Dh, 0017Ch, 0017Bh
             dw 0017Ah, 00179h, 00178h, 00177h, 00176h, 00175h, 00174h, 00173h
             dw 00172h, 00171h, 00170h, 0016Fh, 0016Eh, 0016Dh, 0016Ch, 0016Bh
             dw 0016Ah, 00169h, 00168h, 00168h, 00167h, 00166h, 00165h, 00164h
             dw 00163h, 00162h, 00161h, 00160h, 0015Fh, 0015Eh, 0015Dh, 0015Ch
             dw 0015Bh, 0015Ah, 00159h, 00158h, 00157h, 00156h, 00155h, 00154h
             dw 00153h, 00152h, 00151h, 00150h, 0014Fh, 0014Eh, 0014Eh, 0014Dh
             dw 0014Ch, 0014Bh, 0014Ah, 00149h, 00148h, 00147h, 00146h, 00145h
             dw 00144h, 00143h, 00142h, 00141h, 00140h, 0013Fh, 0013Eh, 0013Dh
             dw 0013Ch, 0013Bh, 0013Ah, 00139h, 00138h, 00137h, 00136h, 00135h
             dw 00134h, 00133h, 00132h, 00131h, 00130h, 0012Fh, 0012Fh, 0012Eh
             dw 0012Dh, 0012Ch, 0012Bh, 0012Ah, 00129h, 00128h, 00127h, 00126h
             dw 00125h, 00124h, 00123h, 00122h, 00121h, 00120h, 0011Fh, 0011Eh
             dw 0011Dh, 0011Ch, 0011Bh, 0011Ah, 00119h, 00118h, 00117h, 00116h
             dw 00115h, 00114h, 00113h, 00112h, 00111h, 00110h, 0010Fh, 0010Eh
             dw 0010Dh, 0010Ch, 0010Bh, 0010Ah, 00109h, 00108h, 00107h, 00107h
             dw 00106h, 00105h, 00104h, 00103h, 00102h, 00101h, 00100h, 000FFh
             dw 000FEh, 000FDh, 000FCh, 000FBh, 000FAh, 000F9h, 000F8h, 000F7h
             dw 000F6h, 000F5h, 000F4h, 000F3h, 000F2h, 000F1h, 000F0h, 000EFh
             dw 000EEh, 000EDh, 000ECh, 000EBh, 000EAh, 000E9h, 000E8h, 000E7h
             dw 000E6h, 000E5h, 000E4h, 000E3h, 000E2h, 000E1h, 000E0h, 000DFh
             dw 000DEh, 000DDh, 000DCh, 000DBh, 000DAh, 000D9h, 000D8h, 000D7h
             dw 000D6h, 000D5h, 000D4h, 000D3h, 000D2h, 000D1h, 000D0h, 000CFh
             dw 000CEh, 000CEh, 000CDh, 000CCh, 000CBh, 000CAh, 000C9h, 000C8h
             dw 000C7h, 000C6h, 000C5h, 000C4h, 000C3h, 000C2h, 000C1h, 000C0h
             dw 000BFh, 000BEh, 000BDh, 000BCh, 000BBh, 000BAh, 000B9h, 000B8h
             dw 000B7h, 000B6h, 000B5h, 000B4h, 000B3h, 000B2h, 000B1h, 000B0h
             dw 000AFh, 000AEh, 000ADh, 000ACh, 000ABh, 000AAh, 000A9h, 000A8h
             dw 000A7h, 000A6h, 000A5h, 000A4h, 000A3h, 000A2h, 000A1h, 000A0h
             dw 0009Fh, 0009Eh, 0009Dh, 0009Ch, 0009Bh, 0009Ah, 00099h, 00098h
             dw 00097h, 00096h, 00095h, 00094h, 00093h, 00092h, 00091h, 00090h
             dw 0008Fh, 0008Eh, 0008Dh, 0008Ch, 0008Bh, 0008Ah, 00089h, 00088h
             dw 00087h, 00086h, 00085h, 00084h, 00083h, 00082h, 00081h, 00080h
             dw 0007Fh, 0007Eh, 0007Dh, 0007Ch, 0007Bh, 0007Ah, 00079h, 00078h
             dw 00077h, 00076h, 00075h, 00074h, 00073h, 00072h, 00071h, 00070h
             dw 0006Fh, 0006Eh, 0006Dh, 0006Ch, 0006Bh, 0006Ah, 00069h, 00068h
             dw 00067h, 00066h, 00065h, 00064h, 00063h, 00062h, 00061h, 00060h
             dw 0005Fh, 0005Eh, 0005Dh, 0005Ch, 0005Bh, 0005Ah, 00059h, 00058h
             dw 00057h, 00056h, 00055h, 00054h, 00053h, 00052h, 00051h, 00050h
             dw 0004Fh, 0004Eh, 0004Dh, 0004Ch, 0004Bh, 0004Ah, 00049h, 00048h
             dw 00047h, 00046h, 00045h, 00044h, 00043h, 00042h, 00041h, 00040h
             dw 0003Fh, 0003Eh, 0003Dh, 0003Ch, 0003Bh, 0003Ah, 00039h, 00038h
             dw 00037h, 00036h, 00035h, 00034h, 00033h, 00032h, 00031h, 00030h
             dw 0002Fh, 0002Eh, 0002Dh, 0002Ch, 0002Bh, 0002Ah, 00029h, 00028h
             dw 00027h, 00026h, 00025h, 00024h, 00023h, 00022h, 00021h, 00020h
             dw 0001Fh, 0001Eh, 0001Dh, 0001Ch, 0001Bh, 0001Ah, 00019h, 00018h
             dw 00017h, 00016h, 00015h, 00014h, 00013h, 00012h, 00011h, 00010h
             dw 0000Fh, 0000Eh, 0000Dh, 0000Ch, 0000Bh, 0000Ah, 00009h, 00008h
             dw 00007h, 00006h, 00005h, 00004h, 00003h, 00002h, 00001h, 00000h
             dw 00000h, 00000h, 0FFFFh, 0FFFEh, 0FFFDh, 0FFFCh, 0FFFBh, 0FFFAh
             dw 0FFF9h, 0FFF8h, 0FFF7h, 0FFF6h, 0FFF5h, 0FFF4h, 0FFF3h, 0FFF2h
             dw 0FFF1h, 0FFF0h, 0FFEFh, 0FFEEh, 0FFEDh, 0FFECh, 0FFEBh, 0FFEAh
             dw 0FFE9h, 0FFE8h, 0FFE7h, 0FFE6h, 0FFE5h, 0FFE4h, 0FFE3h, 0FFE2h
             dw 0FFE1h, 0FFE0h, 0FFDFh, 0FFDEh, 0FFDDh, 0FFDCh, 0FFDBh, 0FFDAh
             dw 0FFD9h, 0FFD8h, 0FFD7h, 0FFD6h, 0FFD5h, 0FFD4h, 0FFD3h, 0FFD2h
             dw 0FFD1h, 0FFD0h, 0FFCFh, 0FFCEh, 0FFCDh, 0FFCCh, 0FFCBh, 0FFCAh
             dw 0FFC9h, 0FFC8h, 0FFC7h, 0FFC6h, 0FFC5h, 0FFC4h, 0FFC3h, 0FFC2h
             dw 0FFC1h, 0FFC0h, 0FFBFh, 0FFBEh, 0FFBDh, 0FFBCh, 0FFBBh, 0FFBAh
             dw 0FFB9h, 0FFB8h, 0FFB7h, 0FFB6h, 0FFB5h, 0FFB4h, 0FFB3h, 0FFB2h
             dw 0FFB1h, 0FFB0h, 0FFAFh, 0FFAEh, 0FFADh, 0FFACh, 0FFABh, 0FFAAh
             dw 0FFA9h, 0FFA8h, 0FFA7h, 0FFA6h, 0FFA5h, 0FFA4h, 0FFA3h, 0FFA2h
             dw 0FFA1h, 0FFA0h, 0FF9Fh, 0FF9Eh, 0FF9Dh, 0FF9Ch, 0FF9Bh, 0FF9Ah
             dw 0FF99h, 0FF98h, 0FF97h, 0FF96h, 0FF95h, 0FF94h, 0FF93h, 0FF92h
             dw 0FF91h, 0FF90h, 0FF8Fh, 0FF8Eh, 0FF8Dh, 0FF8Ch, 0FF8Bh, 0FF8Ah
             dw 0FF89h, 0FF88h, 0FF87h, 0FF86h, 0FF85h, 0FF84h, 0FF83h, 0FF82h
             dw 0FF81h, 0FF80h, 0FF7Fh, 0FF7Eh, 0FF7Dh, 0FF7Ch, 0FF7Bh, 0FF7Ah
             dw 0FF79h, 0FF78h, 0FF77h, 0FF76h, 0FF75h, 0FF74h, 0FF73h, 0FF72h
             dw 0FF71h, 0FF70h, 0FF6Fh, 0FF6Eh, 0FF6Dh, 0FF6Ch, 0FF6Bh, 0FF6Ah
             dw 0FF69h, 0FF68h, 0FF67h, 0FF66h, 0FF65h, 0FF64h, 0FF63h, 0FF62h
             dw 0FF61h, 0FF60h, 0FF5Fh, 0FF5Eh, 0FF5Dh, 0FF5Ch, 0FF5Bh, 0FF5Ah
             dw 0FF59h, 0FF58h, 0FF57h, 0FF56h, 0FF55h, 0FF54h, 0FF53h, 0FF52h
             dw 0FF51h, 0FF50h, 0FF4Fh, 0FF4Eh, 0FF4Dh, 0FF4Ch, 0FF4Bh, 0FF4Ah
             dw 0FF49h, 0FF48h, 0FF47h, 0FF46h, 0FF45h, 0FF44h, 0FF43h, 0FF42h
             dw 0FF41h, 0FF40h, 0FF3Fh, 0FF3Eh, 0FF3Dh, 0FF3Ch, 0FF3Bh, 0FF3Ah
             dw 0FF39h, 0FF38h, 0FF37h, 0FF36h, 0FF35h, 0FF34h, 0FF33h, 0FF32h
             dw 0FF32h, 0FF31h, 0FF30h, 0FF2Fh, 0FF2Eh, 0FF2Dh, 0FF2Ch, 0FF2Bh
             dw 0FF2Ah, 0FF29h, 0FF28h, 0FF27h, 0FF26h, 0FF25h, 0FF24h, 0FF23h
             dw 0FF22h, 0FF21h, 0FF20h, 0FF1Fh, 0FF1Eh, 0FF1Dh, 0FF1Ch, 0FF1Bh
             dw 0FF1Ah, 0FF19h, 0FF18h, 0FF17h, 0FF16h, 0FF15h, 0FF14h, 0FF13h
             dw 0FF12h, 0FF11h, 0FF10h, 0FF0Fh, 0FF0Eh, 0FF0Dh, 0FF0Ch, 0FF0Bh
             dw 0FF0Ah, 0FF09h, 0FF08h, 0FF07h, 0FF06h, 0FF05h, 0FF04h, 0FF03h
             dw 0FF02h, 0FF01h, 0FF00h, 0FEFFh, 0FEFEh, 0FEFDh, 0FEFCh, 0FEFBh
             dw 0FEFAh, 0FEF9h, 0FEF9h, 0FEF8h, 0FEF7h, 0FEF6h, 0FEF5h, 0FEF4h
             dw 0FEF3h, 0FEF2h, 0FEF1h, 0FEF0h, 0FEEFh, 0FEEEh, 0FEEDh, 0FEECh
             dw 0FEEBh, 0FEEAh, 0FEE9h, 0FEE8h, 0FEE7h, 0FEE6h, 0FEE5h, 0FEE4h
             dw 0FEE3h, 0FEE2h, 0FEE1h, 0FEE0h, 0FEDFh, 0FEDEh, 0FEDDh, 0FEDCh
             dw 0FEDBh, 0FEDAh, 0FED9h, 0FED8h, 0FED7h, 0FED6h, 0FED5h, 0FED4h
             dw 0FED3h, 0FED2h, 0FED1h, 0FED1h, 0FED0h, 0FECFh, 0FECEh, 0FECDh
             dw 0FECCh, 0FECBh, 0FECAh, 0FEC9h, 0FEC8h, 0FEC7h, 0FEC6h, 0FEC5h
             dw 0FEC4h, 0FEC3h, 0FEC2h, 0FEC1h, 0FEC0h, 0FEBFh, 0FEBEh, 0FEBDh
             dw 0FEBCh, 0FEBBh, 0FEBAh, 0FEB9h, 0FEB8h, 0FEB7h, 0FEB6h, 0FEB5h
             dw 0FEB4h, 0FEB3h, 0FEB2h, 0FEB2h, 0FEB1h, 0FEB0h, 0FEAFh, 0FEAEh
             dw 0FEADh, 0FEACh, 0FEABh, 0FEAAh, 0FEA9h, 0FEA8h, 0FEA7h, 0FEA6h
             dw 0FEA5h, 0FEA4h, 0FEA3h, 0FEA2h, 0FEA1h, 0FEA0h, 0FE9Fh, 0FE9Eh
             dw 0FE9Dh, 0FE9Ch, 0FE9Bh, 0FE9Ah, 0FE99h, 0FE98h, 0FE98h, 0FE97h
             dw 0FE96h, 0FE95h, 0FE94h, 0FE93h, 0FE92h, 0FE91h, 0FE90h, 0FE8Fh
             dw 0FE8Eh, 0FE8Dh, 0FE8Ch, 0FE8Bh, 0FE8Ah, 0FE89h, 0FE88h, 0FE87h
             dw 0FE86h, 0FE85h, 0FE84h, 0FE83h, 0FE82h, 0FE81h, 0FE81h, 0FE80h
             dw 0FE7Fh, 0FE7Eh, 0FE7Dh, 0FE7Ch, 0FE7Bh, 0FE7Ah, 0FE79h, 0FE78h
             dw 0FE77h, 0FE76h, 0FE75h, 0FE74h, 0FE73h, 0FE72h, 0FE71h, 0FE70h
             dw 0FE6Fh, 0FE6Eh, 0FE6Dh, 0FE6Dh, 0FE6Ch, 0FE6Bh, 0FE6Ah, 0FE69h
             dw 0FE68h, 0FE67h, 0FE66h, 0FE65h, 0FE64h, 0FE63h, 0FE62h, 0FE61h
             dw 0FE60h, 0FE5Fh, 0FE5Eh, 0FE5Dh, 0FE5Ch, 0FE5Bh, 0FE5Bh, 0FE5Ah
             dw 0FE59h, 0FE58h, 0FE57h, 0FE56h, 0FE55h, 0FE54h, 0FE53h, 0FE52h
             dw 0FE51h, 0FE50h, 0FE4Fh, 0FE4Eh, 0FE4Dh, 0FE4Ch, 0FE4Bh, 0FE4Ah
             dw 0FE4Ah, 0FE49h, 0FE48h, 0FE47h, 0FE46h, 0FE45h, 0FE44h, 0FE43h
             dw 0FE42h, 0FE41h, 0FE40h, 0FE3Fh, 0FE3Eh, 0FE3Dh, 0FE3Ch, 0FE3Bh
             dw 0FE3Bh, 0FE3Ah, 0FE39h, 0FE38h, 0FE37h, 0FE36h, 0FE35h, 0FE34h
             dw 0FE33h, 0FE32h, 0FE31h, 0FE30h, 0FE2Fh, 0FE2Eh, 0FE2Dh, 0FE2Ch
             dw 0FE2Ch, 0FE2Bh, 0FE2Ah, 0FE29h, 0FE28h, 0FE27h, 0FE26h, 0FE25h
             dw 0FE24h, 0FE23h, 0FE22h, 0FE21h, 0FE20h, 0FE1Fh, 0FE1Fh, 0FE1Eh
             dw 0FE1Dh, 0FE1Ch, 0FE1Bh, 0FE1Ah, 0FE19h, 0FE18h, 0FE17h, 0FE16h
             dw 0FE15h, 0FE14h, 0FE13h, 0FE12h, 0FE12h, 0FE11h, 0FE10h, 0FE0Fh
             dw 0FE0Eh, 0FE0Dh, 0FE0Ch, 0FE0Bh, 0FE0Ah, 0FE09h, 0FE08h, 0FE07h
             dw 0FE06h, 0FE06h, 0FE05h, 0FE04h, 0FE03h, 0FE02h, 0FE01h, 0FE00h
             dw 0FDFFh, 0FDFEh, 0FDFDh, 0FDFCh, 0FDFBh, 0FDFBh, 0FDFAh, 0FDF9h
             dw 0FDF8h, 0FDF7h, 0FDF6h, 0FDF5h, 0FDF4h, 0FDF3h, 0FDF2h, 0FDF1h
             dw 0FDF0h, 0FDF0h, 0FDEFh, 0FDEEh, 0FDEDh, 0FDECh, 0FDEBh, 0FDEAh
             dw 0FDE9h, 0FDE8h, 0FDE7h, 0FDE6h, 0FDE6h, 0FDE5h, 0FDE4h, 0FDE3h
             dw 0FDE2h, 0FDE1h, 0FDE0h, 0FDDFh, 0FDDEh, 0FDDDh, 0FDDCh, 0FDDCh
             dw 0FDDBh, 0FDDAh, 0FDD9h, 0FDD8h, 0FDD7h, 0FDD6h, 0FDD5h, 0FDD4h
             dw 0FDD3h, 0FDD2h, 0FDD2h, 0FDD1h, 0FDD0h, 0FDCFh, 0FDCEh, 0FDCDh
             dw 0FDCCh, 0FDCBh, 0FDCAh, 0FDC9h, 0FDC9h, 0FDC8h, 0FDC7h, 0FDC6h
             dw 0FDC5h, 0FDC4h, 0FDC3h, 0FDC2h, 0FDC1h, 0FDC0h, 0FDC0h, 0FDBFh
             dw 0FDBEh, 0FDBDh, 0FDBCh, 0FDBBh, 0FDBAh, 0FDB9h, 0FDB8h, 0FDB8h
             dw 0FDB7h, 0FDB6h, 0FDB5h, 0FDB4h, 0FDB3h, 0FDB2h, 0FDB1h, 0FDB0h
             dw 0FDB0h, 0FDAFh, 0FDAEh, 0FDADh, 0FDACh, 0FDABh, 0FDAAh, 0FDA9h
             dw 0FDA8h, 0FDA8h, 0FDA7h, 0FDA6h, 0FDA5h, 0FDA4h, 0FDA3h, 0FDA2h
             dw 0FDA1h, 0FDA0h, 0FDA0h, 0FD9Fh, 0FD9Eh, 0FD9Dh, 0FD9Ch, 0FD9Bh
             dw 0FD9Ah, 0FD99h, 0FD99h, 0FD98h, 0FD97h, 0FD96h, 0FD95h, 0FD94h
             dw 0FD93h, 0FD92h, 0FD91h, 0FD91h, 0FD90h, 0FD8Fh, 0FD8Eh, 0FD8Dh
             dw 0FD8Ch, 0FD8Bh, 0FD8Ah, 0FD8Ah, 0FD89h, 0FD88h, 0FD87h, 0FD86h
             dw 0FD85h, 0FD84h, 0FD83h, 0FD83h, 0FD82h, 0FD81h, 0FD80h, 0FD7Fh
             dw 0FD7Eh, 0FD7Dh, 0FD7Dh, 0FD7Ch, 0FD7Bh, 0FD7Ah, 0FD79h, 0FD78h
             dw 0FD77h, 0FD76h, 0FD76h, 0FD75h, 0FD74h, 0FD73h, 0FD72h, 0FD71h
             dw 0FD70h, 0FD70h, 0FD6Fh, 0FD6Eh, 0FD6Dh, 0FD6Ch, 0FD6Bh, 0FD6Ah
             dw 0FD69h, 0FD69h, 0FD68h, 0FD67h, 0FD66h, 0FD65h, 0FD64h, 0FD63h
             dw 0FD63h, 0FD62h, 0FD61h, 0FD60h, 0FD5Fh, 0FD5Eh, 0FD5Dh, 0FD5Dh
             dw 0FD5Ch, 0FD5Bh, 0FD5Ah, 0FD59h, 0FD58h, 0FD58h, 0FD57h, 0FD56h
             dw 0FD55h, 0FD54h, 0FD53h, 0FD52h, 0FD52h, 0FD51h, 0FD50h, 0FD4Fh
             dw 0FD4Eh, 0FD4Dh, 0FD4Ch, 0FD4Ch, 0FD4Bh, 0FD4Ah, 0FD49h, 0FD48h
             dw 0FD47h, 0FD47h, 0FD46h, 0FD45h, 0FD44h, 0FD43h, 0FD42h, 0FD41h
             dw 0FD41h, 0FD40h, 0FD3Fh, 0FD3Eh, 0FD3Dh, 0FD3Ch, 0FD3Ch, 0FD3Bh
             dw 0FD3Ah, 0FD39h, 0FD38h, 0FD37h, 0FD37h, 0FD36h, 0FD35h, 0FD34h
             dw 0FD33h, 0FD32h, 0FD32h, 0FD31h, 0FD30h, 0FD2Fh, 0FD2Eh, 0FD2Dh
             dw 0FD2Dh, 0FD2Ch, 0FD2Bh, 0FD2Ah, 0FD29h, 0FD28h, 0FD28h, 0FD27h
             dw 0FD26h, 0FD25h, 0FD24h, 0FD23h, 0FD23h, 0FD22h, 0FD21h, 0FD20h
             dw 0FD1Fh, 0FD1Fh, 0FD1Eh, 0FD1Dh, 0FD1Ch, 0FD1Bh, 0FD1Ah, 0FD1Ah
             dw 0FD19h, 0FD18h, 0FD17h, 0FD16h, 0FD15h, 0FD15h, 0FD14h, 0FD13h
             dw 0FD12h, 0FD11h, 0FD11h, 0FD10h, 0FD0Fh, 0FD0Eh, 0FD0Dh, 0FD0Dh
             dw 0FD0Ch, 0FD0Bh, 0FD0Ah, 0FD09h, 0FD08h, 0FD08h, 0FD07h, 0FD06h
             dw 0FD05h, 0FD04h, 0FD04h, 0FD03h, 0FD02h, 0FD01h, 0FD00h, 0FD00h
             dw 0FCFFh, 0FCFEh, 0FCFDh, 0FCFCh, 0FCFCh, 0FCFBh, 0FCFAh, 0FCF9h
             dw 0FCF8h, 0FCF8h, 0FCF7h, 0FCF6h, 0FCF5h, 0FCF4h, 0FCF3h, 0FCF3h
             dw 0FCF2h, 0FCF1h, 0FCF0h, 0FCF0h, 0FCEFh, 0FCEEh, 0FCEDh, 0FCECh
             dw 0FCECh, 0FCEBh, 0FCEAh, 0FCE9h, 0FCE8h, 0FCE8h, 0FCE7h, 0FCE6h
             dw 0FCE5h, 0FCE4h, 0FCE4h, 0FCE3h, 0FCE2h, 0FCE1h, 0FCE0h, 0FCE0h
             dw 0FCDFh, 0FCDEh, 0FCDDh, 0FCDCh, 0FCDCh, 0FCDBh, 0FCDAh, 0FCD9h
             dw 0FCD9h, 0FCD8h, 0FCD7h, 0FCD6h, 0FCD5h, 0FCD5h, 0FCD4h, 0FCD3h
             dw 0FCD2h, 0FCD2h, 0FCD1h, 0FCD0h, 0FCCFh, 0FCCEh, 0FCCEh, 0FCCDh
             dw 0FCCCh, 0FCCBh, 0FCCBh, 0FCCAh, 0FCC9h, 0FCC8h, 0FCC7h, 0FCC7h
             dw 0FCC6h, 0FCC5h, 0FCC4h, 0FCC4h, 0FCC3h, 0FCC2h, 0FCC1h, 0FCC0h
             dw 0FCC0h, 0FCBFh, 0FCBEh, 0FCBDh, 0FCBDh, 0FCBCh, 0FCBBh, 0FCBAh
             dw 0FCBAh, 0FCB9h, 0FCB8h, 0FCB7h, 0FCB7h, 0FCB6h, 0FCB5h, 0FCB4h
             dw 0FCB3h, 0FCB3h, 0FCB2h, 0FCB1h, 0FCB0h, 0FCB0h, 0FCAFh, 0FCAEh
             dw 0FCADh, 0FCADh, 0FCACh, 0FCABh, 0FCAAh, 0FCAAh, 0FCA9h, 0FCA8h
             dw 0FCA7h, 0FCA7h, 0FCA6h, 0FCA5h, 0FCA4h, 0FCA4h, 0FCA3h, 0FCA2h
             dw 0FCA1h, 0FCA1h, 0FCA0h, 0FC9Fh, 0FC9Eh, 0FC9Eh, 0FC9Dh, 0FC9Ch
             dw 0FC9Bh, 0FC9Bh, 0FC9Ah, 0FC99h, 0FC98h, 0FC98h, 0FC97h, 0FC96h
             dw 0FC95h, 0FC95h, 0FC94h, 0FC93h, 0FC93h, 0FC92h, 0FC91h, 0FC90h
             dw 0FC90h, 0FC8Fh, 0FC8Eh, 0FC8Dh, 0FC8Dh, 0FC8Ch, 0FC8Bh, 0FC8Ah
             dw 0FC8Ah, 0FC89h, 0FC88h, 0FC87h, 0FC87h, 0FC86h, 0FC85h, 0FC85h
             dw 0FC84h, 0FC83h, 0FC82h, 0FC82h, 0FC81h, 0FC80h, 0FC7Fh, 0FC7Fh
             dw 0FC7Eh, 0FC7Dh, 0FC7Dh, 0FC7Ch, 0FC7Bh, 0FC7Ah, 0FC7Ah, 0FC79h
             dw 0FC78h, 0FC78h, 0FC77h, 0FC76h, 0FC75h, 0FC75h, 0FC74h, 0FC73h
             dw 0FC73h, 0FC72h, 0FC71h, 0FC70h, 0FC70h, 0FC6Fh, 0FC6Eh, 0FC6Eh
             dw 0FC6Dh, 0FC6Ch, 0FC6Bh, 0FC6Bh, 0FC6Ah, 0FC69h, 0FC69h, 0FC68h
             dw 0FC67h, 0FC66h, 0FC66h, 0FC65h, 0FC64h, 0FC64h, 0FC63h, 0FC62h
             dw 0FC62h, 0FC61h, 0FC60h, 0FC5Fh, 0FC5Fh, 0FC5Eh, 0FC5Dh, 0FC5Dh
             dw 0FC5Ch, 0FC5Bh, 0FC5Bh, 0FC5Ah, 0FC59h, 0FC58h, 0FC58h, 0FC57h
             dw 0FC56h, 0FC56h, 0FC55h, 0FC54h, 0FC54h, 0FC53h, 0FC52h, 0FC51h
             dw 0FC51h, 0FC50h, 0FC4Fh, 0FC4Fh, 0FC4Eh, 0FC4Dh, 0FC4Dh, 0FC4Ch
             dw 0FC4Bh, 0FC4Bh, 0FC4Ah, 0FC49h, 0FC49h, 0FC48h, 0FC47h, 0FC47h
             dw 0FC46h, 0FC45h, 0FC44h, 0FC44h, 0FC43h, 0FC42h, 0FC42h, 0FC41h
             dw 0FC40h, 0FC40h, 0FC3Fh, 0FC3Eh, 0FC3Eh, 0FC3Dh, 0FC3Ch, 0FC3Ch
             dw 0FC3Bh, 0FC3Ah, 0FC3Ah, 0FC39h, 0FC38h, 0FC38h, 0FC37h, 0FC36h
             dw 0FC36h, 0FC35h, 0FC34h, 0FC34h, 0FC33h, 0FC32h, 0FC32h, 0FC31h
             dw 0FC30h, 0FC30h, 0FC2Fh, 0FC2Eh, 0FC2Eh, 0FC2Dh, 0FC2Ch, 0FC2Ch
             dw 0FC2Bh, 0FC2Ah, 0FC2Ah, 0FC29h, 0FC28h, 0FC28h, 0FC27h, 0FC27h
             dw 0FC26h, 0FC25h, 0FC25h, 0FC24h, 0FC23h, 0FC23h, 0FC22h, 0FC21h
             dw 0FC21h, 0FC20h, 0FC1Fh, 0FC1Fh, 0FC1Eh, 0FC1Dh, 0FC1Dh, 0FC1Ch
             dw 0FC1Bh, 0FC1Bh, 0FC1Ah, 0FC1Ah, 0FC19h, 0FC18h, 0FC18h, 0FC17h
             dw 0FC16h, 0FC16h, 0FC15h, 0FC14h, 0FC14h, 0FC13h, 0FC13h, 0FC12h
             dw 0FC11h, 0FC11h, 0FC10h, 0FC0Fh, 0FC0Fh, 0FC0Eh, 0FC0Dh, 0FC0Dh
             dw 0FC0Ch, 0FC0Ch, 0FC0Bh, 0FC0Ah, 0FC0Ah, 0FC09h, 0FC08h, 0FC08h
             dw 0FC07h, 0FC07h, 0FC06h, 0FC05h, 0FC05h, 0FC04h, 0FC03h, 0FC03h
             dw 0FC02h, 0FC02h, 0FC01h, 0FC00h, 0FC00h, 0FBFFh, 0FBFFh, 0FBFEh
             dw 0FBFDh, 0FBFDh, 0FBFCh, 0FBFBh, 0FBFBh, 0FBFAh, 0FBFAh, 0FBF9h
             dw 0FBF8h, 0FBF8h, 0FBF7h, 0FBF7h, 0FBF6h, 0FBF5h, 0FBF5h, 0FBF4h
             dw 0FBF4h, 0FBF3h, 0FBF2h, 0FBF2h, 0FBF1h, 0FBF1h, 0FBF0h, 0FBEFh
             dw 0FBEFh, 0FBEEh, 0FBEEh, 0FBEDh, 0FBECh, 0FBECh, 0FBEBh, 0FBEBh
             dw 0FBEAh, 0FBE9h, 0FBE9h, 0FBE8h, 0FBE8h, 0FBE7h, 0FBE6h, 0FBE6h
             dw 0FBE5h, 0FBE5h, 0FBE4h, 0FBE3h, 0FBE3h, 0FBE2h, 0FBE2h, 0FBE1h
             dw 0FBE0h, 0FBE0h, 0FBDFh, 0FBDFh, 0FBDEh, 0FBDEh, 0FBDDh, 0FBDCh
             dw 0FBDCh, 0FBDBh, 0FBDBh, 0FBDAh, 0FBD9h, 0FBD9h, 0FBD8h, 0FBD8h
             dw 0FBD7h, 0FBD7h, 0FBD6h, 0FBD5h, 0FBD5h, 0FBD4h, 0FBD4h, 0FBD3h
             dw 0FBD3h, 0FBD2h, 0FBD1h, 0FBD1h, 0FBD0h, 0FBD0h, 0FBCFh, 0FBCFh
             dw 0FBCEh, 0FBCDh, 0FBCDh, 0FBCCh, 0FBCCh, 0FBCBh, 0FBCBh, 0FBCAh
             dw 0FBCAh, 0FBC9h, 0FBC8h, 0FBC8h, 0FBC7h, 0FBC7h, 0FBC6h, 0FBC6h
             dw 0FBC5h, 0FBC5h, 0FBC4h, 0FBC3h, 0FBC3h, 0FBC2h, 0FBC2h, 0FBC1h
             dw 0FBC1h, 0FBC0h, 0FBC0h, 0FBBFh, 0FBBEh, 0FBBEh, 0FBBDh, 0FBBDh
             dw 0FBBCh, 0FBBCh, 0FBBBh, 0FBBBh, 0FBBAh, 0FBBAh, 0FBB9h, 0FBB8h
             dw 0FBB8h, 0FBB7h, 0FBB7h, 0FBB6h, 0FBB6h, 0FBB5h, 0FBB5h, 0FBB4h
             dw 0FBB4h, 0FBB3h, 0FBB3h, 0FBB2h, 0FBB2h, 0FBB1h, 0FBB0h, 0FBB0h
             dw 0FBAFh, 0FBAFh, 0FBAEh, 0FBAEh, 0FBADh, 0FBADh, 0FBACh, 0FBACh
             dw 0FBABh, 0FBABh, 0FBAAh, 0FBAAh, 0FBA9h, 0FBA9h, 0FBA8h, 0FBA8h
             dw 0FBA7h, 0FBA6h, 0FBA6h, 0FBA5h, 0FBA5h, 0FBA4h, 0FBA4h, 0FBA3h
             dw 0FBA3h, 0FBA2h, 0FBA2h, 0FBA1h, 0FBA1h, 0FBA0h, 0FBA0h, 0FB9Fh
             dw 0FB9Fh, 0FB9Eh, 0FB9Eh, 0FB9Dh, 0FB9Dh, 0FB9Ch, 0FB9Ch, 0FB9Bh
             dw 0FB9Bh, 0FB9Ah, 0FB9Ah, 0FB99h, 0FB99h, 0FB98h, 0FB98h, 0FB97h
             dw 0FB97h, 0FB96h, 0FB96h, 0FB95h, 0FB95h, 0FB94h, 0FB94h, 0FB93h
             dw 0FB93h, 0FB92h, 0FB92h, 0FB91h, 0FB91h, 0FB90h, 0FB90h, 0FB8Fh
             dw 0FB8Fh, 0FB8Eh, 0FB8Eh, 0FB8Dh, 0FB8Dh, 0FB8Ch, 0FB8Ch, 0FB8Bh
             dw 0FB8Bh, 0FB8Ah, 0FB8Ah, 0FB8Ah, 0FB89h, 0FB89h, 0FB88h, 0FB88h
             dw 0FB87h, 0FB87h, 0FB86h, 0FB86h, 0FB85h, 0FB85h, 0FB84h, 0FB84h
             dw 0FB83h, 0FB83h, 0FB82h, 0FB82h, 0FB81h, 0FB81h, 0FB81h, 0FB80h
             dw 0FB80h, 0FB7Fh, 0FB7Fh, 0FB7Eh, 0FB7Eh, 0FB7Dh, 0FB7Dh, 0FB7Ch
             dw 0FB7Ch, 0FB7Bh, 0FB7Bh, 0FB7Bh, 0FB7Ah, 0FB7Ah, 0FB79h, 0FB79h
             dw 0FB78h, 0FB78h, 0FB77h, 0FB77h, 0FB76h, 0FB76h, 0FB76h, 0FB75h
             dw 0FB75h, 0FB74h, 0FB74h, 0FB73h, 0FB73h, 0FB72h, 0FB72h, 0FB72h
             dw 0FB71h, 0FB71h, 0FB70h, 0FB70h, 0FB6Fh, 0FB6Fh, 0FB6Eh, 0FB6Eh
             dw 0FB6Eh, 0FB6Dh, 0FB6Dh, 0FB6Ch, 0FB6Ch, 0FB6Bh, 0FB6Bh, 0FB6Ah
             dw 0FB6Ah, 0FB6Ah, 0FB69h, 0FB69h, 0FB68h, 0FB68h, 0FB67h, 0FB67h
             dw 0FB67h, 0FB66h, 0FB66h, 0FB65h, 0FB65h, 0FB64h, 0FB64h, 0FB64h
             dw 0FB63h, 0FB63h, 0FB62h, 0FB62h, 0FB62h, 0FB61h, 0FB61h, 0FB60h
             dw 0FB60h, 0FB5Fh, 0FB5Fh, 0FB5Fh, 0FB5Eh, 0FB5Eh, 0FB5Dh, 0FB5Dh
             dw 0FB5Dh, 0FB5Ch, 0FB5Ch, 0FB5Bh, 0FB5Bh, 0FB5Bh, 0FB5Ah, 0FB5Ah
             dw 0FB59h, 0FB59h, 0FB58h, 0FB58h, 0FB58h, 0FB57h, 0FB57h, 0FB56h
             dw 0FB56h, 0FB56h, 0FB55h, 0FB55h, 0FB54h, 0FB54h, 0FB54h, 0FB53h
             dw 0FB53h, 0FB53h, 0FB52h, 0FB52h, 0FB51h, 0FB51h, 0FB51h, 0FB50h
             dw 0FB50h, 0FB4Fh, 0FB4Fh, 0FB4Fh, 0FB4Eh, 0FB4Eh, 0FB4Dh, 0FB4Dh
             dw 0FB4Dh, 0FB4Ch, 0FB4Ch, 0FB4Ch, 0FB4Bh, 0FB4Bh, 0FB4Ah, 0FB4Ah
             dw 0FB4Ah, 0FB49h, 0FB49h, 0FB49h, 0FB48h, 0FB48h, 0FB47h, 0FB47h
             dw 0FB47h, 0FB46h, 0FB46h, 0FB46h, 0FB45h, 0FB45h, 0FB44h, 0FB44h
             dw 0FB44h, 0FB43h, 0FB43h, 0FB43h, 0FB42h, 0FB42h, 0FB42h, 0FB41h
             dw 0FB41h, 0FB40h, 0FB40h, 0FB40h, 0FB3Fh, 0FB3Fh, 0FB3Fh, 0FB3Eh
             dw 0FB3Eh, 0FB3Eh, 0FB3Dh, 0FB3Dh, 0FB3Dh, 0FB3Ch, 0FB3Ch, 0FB3Bh
             dw 0FB3Bh, 0FB3Bh, 0FB3Ah, 0FB3Ah, 0FB3Ah, 0FB39h, 0FB39h, 0FB39h
             dw 0FB38h, 0FB38h, 0FB38h, 0FB37h, 0FB37h, 0FB37h, 0FB36h, 0FB36h
             dw 0FB36h, 0FB35h, 0FB35h, 0FB35h, 0FB34h, 0FB34h, 0FB34h, 0FB33h
             dw 0FB33h, 0FB33h, 0FB32h, 0FB32h, 0FB32h, 0FB31h, 0FB31h, 0FB31h
             dw 0FB30h, 0FB30h, 0FB30h, 0FB2Fh, 0FB2Fh, 0FB2Fh, 0FB2Eh, 0FB2Eh
             dw 0FB2Eh, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Ch, 0FB2Ch, 0FB2Ch
             dw 0FB2Bh, 0FB2Bh, 0FB2Bh, 0FB2Ah, 0FB2Ah, 0FB2Ah, 0FB29h, 0FB29h
             dw 0FB29h, 0FB28h, 0FB28h, 0FB28h, 0FB28h, 0FB27h, 0FB27h, 0FB27h
             dw 0FB26h, 0FB26h, 0FB26h, 0FB25h, 0FB25h, 0FB25h, 0FB25h, 0FB24h
             dw 0FB24h, 0FB24h, 0FB23h, 0FB23h, 0FB23h, 0FB22h, 0FB22h, 0FB22h
             dw 0FB22h, 0FB21h, 0FB21h, 0FB21h, 0FB20h, 0FB20h, 0FB20h, 0FB20h
             dw 0FB1Fh, 0FB1Fh, 0FB1Fh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Dh
             dw 0FB1Dh, 0FB1Dh, 0FB1Dh, 0FB1Ch, 0FB1Ch, 0FB1Ch, 0FB1Bh, 0FB1Bh
             dw 0FB1Bh, 0FB1Bh, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB19h, 0FB19h
             dw 0FB19h, 0FB18h, 0FB18h, 0FB18h, 0FB18h, 0FB17h, 0FB17h, 0FB17h
             dw 0FB17h, 0FB16h, 0FB16h, 0FB16h, 0FB16h, 0FB15h, 0FB15h, 0FB15h
             dw 0FB15h, 0FB14h, 0FB14h, 0FB14h, 0FB14h, 0FB13h, 0FB13h, 0FB13h
             dw 0FB13h, 0FB12h, 0FB12h, 0FB12h, 0FB12h, 0FB11h, 0FB11h, 0FB11h
             dw 0FB11h, 0FB10h, 0FB10h, 0FB10h, 0FB10h, 0FB0Fh, 0FB0Fh, 0FB0Fh
             dw 0FB0Fh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Dh, 0FB0Dh, 0FB0Dh
             dw 0FB0Dh, 0FB0Dh, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Bh, 0FB0Bh
             dw 0FB0Bh, 0FB0Bh, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB09h
             dw 0FB09h, 0FB09h, 0FB09h, 0FB09h, 0FB08h, 0FB08h, 0FB08h, 0FB08h
             dw 0FB07h, 0FB07h, 0FB07h, 0FB07h, 0FB07h, 0FB06h, 0FB06h, 0FB06h
             dw 0FB06h, 0FB06h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB04h
             dw 0FB04h, 0FB04h, 0FB04h, 0FB04h, 0FB03h, 0FB03h, 0FB03h, 0FB03h
             dw 0FB03h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB01h, 0FB01h
             dw 0FB01h, 0FB01h, 0FB01h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h
             dw 0FB00h, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFEh, 0FAFEh
             dw 0FAFEh, 0FAFEh, 0FAFEh, 0FAFEh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh
             dw 0FAFDh, 0FAFDh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh
             dw 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFAh, 0FAFAh
             dw 0FAFAh, 0FAFAh, 0FAFAh, 0FAFAh, 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h
             dw 0FAF9h, 0FAF9h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h
             dw 0FAF8h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h
             dw 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF5h
             dw 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF4h
             dw 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF3h
             dw 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF2h
             dw 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h
             dw 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h
             dw 0FAF1h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h
             dw 0FAF0h, 0FAF0h, 0FAF0h, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh
             dw 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh
             dw 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAF0h, 0FAF0h
             dw 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h
             dw 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h
             dw 0FAF1h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h
             dw 0FAF2h, 0FAF2h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h
             dw 0FAF3h, 0FAF3h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h
             dw 0FAF4h, 0FAF4h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h
             dw 0FAF5h, 0FAF5h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h
             dw 0FAF6h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h
             dw 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF9h
             dw 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h, 0FAFAh, 0FAFAh, 0FAFAh
             dw 0FAFAh, 0FAFAh, 0FAFAh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh
             dw 0FAFBh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFDh
             dw 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFEh, 0FAFEh, 0FAFEh
             dw 0FAFEh, 0FAFEh, 0FAFEh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh
             dw 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB01h, 0FB01h
             dw 0FB01h, 0FB01h, 0FB01h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB02h
             dw 0FB03h, 0FB03h, 0FB03h, 0FB03h, 0FB03h, 0FB04h, 0FB04h, 0FB04h
             dw 0FB04h, 0FB04h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB06h
             dw 0FB06h, 0FB06h, 0FB06h, 0FB06h, 0FB07h, 0FB07h, 0FB07h, 0FB07h
             dw 0FB07h, 0FB08h, 0FB08h, 0FB08h, 0FB08h, 0FB09h, 0FB09h, 0FB09h
             dw 0FB09h, 0FB09h, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Bh
             dw 0FB0Bh, 0FB0Bh, 0FB0Bh, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Dh
             dw 0FB0Dh, 0FB0Dh, 0FB0Dh, 0FB0Dh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Eh
             dw 0FB0Fh, 0FB0Fh, 0FB0Fh, 0FB0Fh, 0FB10h, 0FB10h, 0FB10h, 0FB10h
             dw 0FB11h, 0FB11h, 0FB11h, 0FB11h, 0FB12h, 0FB12h, 0FB12h, 0FB12h
             dw 0FB13h, 0FB13h, 0FB13h, 0FB13h, 0FB14h, 0FB14h, 0FB14h, 0FB14h
             dw 0FB15h, 0FB15h, 0FB15h, 0FB15h, 0FB16h, 0FB16h, 0FB16h, 0FB16h
             dw 0FB17h, 0FB17h, 0FB17h, 0FB17h, 0FB18h, 0FB18h, 0FB18h, 0FB18h
             dw 0FB19h, 0FB19h, 0FB19h, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Bh
             dw 0FB1Bh, 0FB1Bh, 0FB1Bh, 0FB1Ch, 0FB1Ch, 0FB1Ch, 0FB1Dh, 0FB1Dh
             dw 0FB1Dh, 0FB1Dh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Fh, 0FB1Fh
             dw 0FB1Fh, 0FB20h, 0FB20h, 0FB20h, 0FB20h, 0FB21h, 0FB21h, 0FB21h
             dw 0FB22h, 0FB22h, 0FB22h, 0FB22h, 0FB23h, 0FB23h, 0FB23h, 0FB24h
             dw 0FB24h, 0FB24h, 0FB25h, 0FB25h, 0FB25h, 0FB25h, 0FB26h, 0FB26h
             dw 0FB26h, 0FB27h, 0FB27h, 0FB27h, 0FB28h, 0FB28h, 0FB28h, 0FB28h
             dw 0FB29h, 0FB29h, 0FB29h, 0FB2Ah, 0FB2Ah, 0FB2Ah, 0FB2Bh, 0FB2Bh
             dw 0FB2Bh, 0FB2Ch, 0FB2Ch, 0FB2Ch, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Dh
             dw 0FB2Eh, 0FB2Eh, 0FB2Eh, 0FB2Fh, 0FB2Fh, 0FB2Fh, 0FB30h, 0FB30h
             dw 0FB30h, 0FB31h, 0FB31h, 0FB31h, 0FB32h, 0FB32h, 0FB32h, 0FB33h
             dw 0FB33h, 0FB33h, 0FB34h, 0FB34h, 0FB34h, 0FB35h, 0FB35h, 0FB35h
             dw 0FB36h, 0FB36h, 0FB36h, 0FB37h, 0FB37h, 0FB37h, 0FB38h, 0FB38h
             dw 0FB38h, 0FB39h, 0FB39h, 0FB39h, 0FB3Ah, 0FB3Ah, 0FB3Ah, 0FB3Bh
             dw 0FB3Bh, 0FB3Bh, 0FB3Ch, 0FB3Ch, 0FB3Dh, 0FB3Dh, 0FB3Dh, 0FB3Eh
             dw 0FB3Eh, 0FB3Eh, 0FB3Fh, 0FB3Fh, 0FB3Fh, 0FB40h, 0FB40h, 0FB40h
             dw 0FB41h, 0FB41h, 0FB42h, 0FB42h, 0FB42h, 0FB43h, 0FB43h, 0FB43h
             dw 0FB44h, 0FB44h, 0FB44h, 0FB45h, 0FB45h, 0FB46h, 0FB46h, 0FB46h
             dw 0FB47h, 0FB47h, 0FB47h, 0FB48h, 0FB48h, 0FB49h, 0FB49h, 0FB49h
             dw 0FB4Ah, 0FB4Ah, 0FB4Ah, 0FB4Bh, 0FB4Bh, 0FB4Ch, 0FB4Ch, 0FB4Ch
             dw 0FB4Dh, 0FB4Dh, 0FB4Dh, 0FB4Eh, 0FB4Eh, 0FB4Fh, 0FB4Fh, 0FB4Fh
             dw 0FB50h, 0FB50h, 0FB51h, 0FB51h, 0FB51h, 0FB52h, 0FB52h, 0FB53h
             dw 0FB53h, 0FB53h, 0FB54h, 0FB54h, 0FB54h, 0FB55h, 0FB55h, 0FB56h
             dw 0FB56h, 0FB56h, 0FB57h, 0FB57h, 0FB58h, 0FB58h, 0FB58h, 0FB59h
             dw 0FB59h, 0FB5Ah, 0FB5Ah, 0FB5Bh, 0FB5Bh, 0FB5Bh, 0FB5Ch, 0FB5Ch
             dw 0FB5Dh, 0FB5Dh, 0FB5Dh, 0FB5Eh, 0FB5Eh, 0FB5Fh, 0FB5Fh, 0FB5Fh
             dw 0FB60h, 0FB60h, 0FB61h, 0FB61h, 0FB62h, 0FB62h, 0FB62h, 0FB63h
             dw 0FB63h, 0FB64h, 0FB64h, 0FB64h, 0FB65h, 0FB65h, 0FB66h, 0FB66h
             dw 0FB67h, 0FB67h, 0FB67h, 0FB68h, 0FB68h, 0FB69h, 0FB69h, 0FB6Ah
             dw 0FB6Ah, 0FB6Ah, 0FB6Bh, 0FB6Bh, 0FB6Ch, 0FB6Ch, 0FB6Dh, 0FB6Dh
             dw 0FB6Eh, 0FB6Eh, 0FB6Eh, 0FB6Fh, 0FB6Fh, 0FB70h, 0FB70h, 0FB71h
             dw 0FB71h, 0FB72h, 0FB72h, 0FB72h, 0FB73h, 0FB73h, 0FB74h, 0FB74h
             dw 0FB75h, 0FB75h, 0FB76h, 0FB76h, 0FB76h, 0FB77h, 0FB77h, 0FB78h
             dw 0FB78h, 0FB79h, 0FB79h, 0FB7Ah, 0FB7Ah, 0FB7Bh, 0FB7Bh, 0FB7Bh
             dw 0FB7Ch, 0FB7Ch, 0FB7Dh, 0FB7Dh, 0FB7Eh, 0FB7Eh, 0FB7Fh, 0FB7Fh
             dw 0FB80h, 0FB80h, 0FB81h, 0FB81h, 0FB81h, 0FB82h, 0FB82h, 0FB83h
             dw 0FB83h, 0FB84h, 0FB84h, 0FB85h, 0FB85h, 0FB86h, 0FB86h, 0FB87h
             dw 0FB87h, 0FB88h, 0FB88h, 0FB89h, 0FB89h, 0FB8Ah, 0FB8Ah, 0FB8Ah
             dw 0FB8Bh, 0FB8Bh, 0FB8Ch, 0FB8Ch, 0FB8Dh, 0FB8Dh, 0FB8Eh, 0FB8Eh
             dw 0FB8Fh, 0FB8Fh, 0FB90h, 0FB90h, 0FB91h, 0FB91h, 0FB92h, 0FB92h
             dw 0FB93h, 0FB93h, 0FB94h, 0FB94h, 0FB95h, 0FB95h, 0FB96h, 0FB96h
             dw 0FB97h, 0FB97h, 0FB98h, 0FB98h, 0FB99h, 0FB99h, 0FB9Ah, 0FB9Ah
             dw 0FB9Bh, 0FB9Bh, 0FB9Ch, 0FB9Ch, 0FB9Dh, 0FB9Dh, 0FB9Eh, 0FB9Eh
             dw 0FB9Fh, 0FB9Fh, 0FBA0h, 0FBA0h, 0FBA1h, 0FBA1h, 0FBA2h, 0FBA2h
             dw 0FBA3h, 0FBA3h, 0FBA4h, 0FBA4h, 0FBA5h, 0FBA5h, 0FBA6h, 0FBA6h
             dw 0FBA7h, 0FBA8h, 0FBA8h, 0FBA9h, 0FBA9h, 0FBAAh, 0FBAAh, 0FBABh
             dw 0FBABh, 0FBACh, 0FBACh, 0FBADh, 0FBADh, 0FBAEh, 0FBAEh, 0FBAFh
             dw 0FBAFh, 0FBB0h, 0FBB0h, 0FBB1h, 0FBB2h, 0FBB2h, 0FBB3h, 0FBB3h
             dw 0FBB4h, 0FBB4h, 0FBB5h, 0FBB5h, 0FBB6h, 0FBB6h, 0FBB7h, 0FBB7h
             dw 0FBB8h, 0FBB8h, 0FBB9h, 0FBBAh, 0FBBAh, 0FBBBh, 0FBBBh, 0FBBCh
             dw 0FBBCh, 0FBBDh, 0FBBDh, 0FBBEh, 0FBBEh, 0FBBFh, 0FBC0h, 0FBC0h
             dw 0FBC1h, 0FBC1h, 0FBC2h, 0FBC2h, 0FBC3h, 0FBC3h, 0FBC4h, 0FBC5h
             dw 0FBC5h, 0FBC6h, 0FBC6h, 0FBC7h, 0FBC7h, 0FBC8h, 0FBC8h, 0FBC9h
             dw 0FBCAh, 0FBCAh, 0FBCBh, 0FBCBh, 0FBCCh, 0FBCCh, 0FBCDh, 0FBCDh
             dw 0FBCEh, 0FBCFh, 0FBCFh, 0FBD0h, 0FBD0h, 0FBD1h, 0FBD1h, 0FBD2h
             dw 0FBD3h, 0FBD3h, 0FBD4h, 0FBD4h, 0FBD5h, 0FBD5h, 0FBD6h, 0FBD7h
             dw 0FBD7h, 0FBD8h, 0FBD8h, 0FBD9h, 0FBD9h, 0FBDAh, 0FBDBh, 0FBDBh
             dw 0FBDCh, 0FBDCh, 0FBDDh, 0FBDEh, 0FBDEh, 0FBDFh, 0FBDFh, 0FBE0h
             dw 0FBE0h, 0FBE1h, 0FBE2h, 0FBE2h, 0FBE3h, 0FBE3h, 0FBE4h, 0FBE5h
             dw 0FBE5h, 0FBE6h, 0FBE6h, 0FBE7h, 0FBE8h, 0FBE8h, 0FBE9h, 0FBE9h
             dw 0FBEAh, 0FBEBh, 0FBEBh, 0FBECh, 0FBECh, 0FBEDh, 0FBEEh, 0FBEEh
             dw 0FBEFh, 0FBEFh, 0FBF0h, 0FBF1h, 0FBF1h, 0FBF2h, 0FBF2h, 0FBF3h
             dw 0FBF4h, 0FBF4h, 0FBF5h, 0FBF5h, 0FBF6h, 0FBF7h, 0FBF7h, 0FBF8h
             dw 0FBF8h, 0FBF9h, 0FBFAh, 0FBFAh, 0FBFBh, 0FBFBh, 0FBFCh, 0FBFDh
             dw 0FBFDh, 0FBFEh, 0FBFFh, 0FBFFh, 0FC00h, 0FC00h, 0FC01h, 0FC02h
             dw 0FC02h, 0FC03h, 0FC03h, 0FC04h, 0FC05h, 0FC05h, 0FC06h, 0FC07h
             dw 0FC07h, 0FC08h, 0FC08h, 0FC09h, 0FC0Ah, 0FC0Ah, 0FC0Bh, 0FC0Ch
             dw 0FC0Ch, 0FC0Dh, 0FC0Dh, 0FC0Eh, 0FC0Fh, 0FC0Fh, 0FC10h, 0FC11h
             dw 0FC11h, 0FC12h, 0FC13h, 0FC13h, 0FC14h, 0FC14h, 0FC15h, 0FC16h
             dw 0FC16h, 0FC17h, 0FC18h, 0FC18h, 0FC19h, 0FC1Ah, 0FC1Ah, 0FC1Bh
             dw 0FC1Bh, 0FC1Ch, 0FC1Dh, 0FC1Dh, 0FC1Eh, 0FC1Fh, 0FC1Fh, 0FC20h
             dw 0FC21h, 0FC21h, 0FC22h, 0FC23h, 0FC23h, 0FC24h, 0FC25h, 0FC25h
             dw 0FC26h, 0FC27h, 0FC27h, 0FC28h, 0FC28h, 0FC29h, 0FC2Ah, 0FC2Ah
             dw 0FC2Bh, 0FC2Ch, 0FC2Ch, 0FC2Dh, 0FC2Eh, 0FC2Eh, 0FC2Fh, 0FC30h
             dw 0FC30h, 0FC31h, 0FC32h, 0FC32h, 0FC33h, 0FC34h, 0FC34h, 0FC35h
             dw 0FC36h, 0FC36h, 0FC37h, 0FC38h, 0FC38h, 0FC39h, 0FC3Ah, 0FC3Ah
             dw 0FC3Bh, 0FC3Ch, 0FC3Ch, 0FC3Dh, 0FC3Eh, 0FC3Eh, 0FC3Fh, 0FC40h
             dw 0FC40h, 0FC41h, 0FC42h, 0FC42h, 0FC43h, 0FC44h, 0FC44h, 0FC45h
             dw 0FC46h, 0FC47h, 0FC47h, 0FC48h, 0FC49h, 0FC49h, 0FC4Ah, 0FC4Bh
             dw 0FC4Bh, 0FC4Ch, 0FC4Dh, 0FC4Dh, 0FC4Eh, 0FC4Fh, 0FC4Fh, 0FC50h
             dw 0FC51h, 0FC51h, 0FC52h, 0FC53h, 0FC54h, 0FC54h, 0FC55h, 0FC56h
             dw 0FC56h, 0FC57h, 0FC58h, 0FC58h, 0FC59h, 0FC5Ah, 0FC5Bh, 0FC5Bh
             dw 0FC5Ch, 0FC5Dh, 0FC5Dh, 0FC5Eh, 0FC5Fh, 0FC5Fh, 0FC60h, 0FC61h
             dw 0FC62h, 0FC62h, 0FC63h, 0FC64h, 0FC64h, 0FC65h, 0FC66h, 0FC66h
             dw 0FC67h, 0FC68h, 0FC69h, 0FC69h, 0FC6Ah, 0FC6Bh, 0FC6Bh, 0FC6Ch
             dw 0FC6Dh, 0FC6Eh, 0FC6Eh, 0FC6Fh, 0FC70h, 0FC70h, 0FC71h, 0FC72h
             dw 0FC73h, 0FC73h, 0FC74h, 0FC75h, 0FC75h, 0FC76h, 0FC77h, 0FC78h
             dw 0FC78h, 0FC79h, 0FC7Ah, 0FC7Ah, 0FC7Bh, 0FC7Ch, 0FC7Dh, 0FC7Dh
             dw 0FC7Eh, 0FC7Fh, 0FC7Fh, 0FC80h, 0FC81h, 0FC82h, 0FC82h, 0FC83h
             dw 0FC84h, 0FC85h, 0FC85h, 0FC86h, 0FC87h, 0FC87h, 0FC88h, 0FC89h
             dw 0FC8Ah, 0FC8Ah, 0FC8Bh, 0FC8Ch, 0FC8Dh, 0FC8Dh, 0FC8Eh, 0FC8Fh
             dw 0FC90h, 0FC90h, 0FC91h, 0FC92h, 0FC93h, 0FC93h, 0FC94h, 0FC95h
             dw 0FC95h, 0FC96h, 0FC97h, 0FC98h, 0FC98h, 0FC99h, 0FC9Ah, 0FC9Bh
             dw 0FC9Bh, 0FC9Ch, 0FC9Dh, 0FC9Eh, 0FC9Eh, 0FC9Fh, 0FCA0h, 0FCA1h
             dw 0FCA1h, 0FCA2h, 0FCA3h, 0FCA4h, 0FCA4h, 0FCA5h, 0FCA6h, 0FCA7h
             dw 0FCA7h, 0FCA8h, 0FCA9h, 0FCAAh, 0FCAAh, 0FCABh, 0FCACh, 0FCADh
             dw 0FCADh, 0FCAEh, 0FCAFh, 0FCB0h, 0FCB0h, 0FCB1h, 0FCB2h, 0FCB3h
             dw 0FCB3h, 0FCB4h, 0FCB5h, 0FCB6h, 0FCB7h, 0FCB7h, 0FCB8h, 0FCB9h
             dw 0FCBAh, 0FCBAh, 0FCBBh, 0FCBCh, 0FCBDh, 0FCBDh, 0FCBEh, 0FCBFh
             dw 0FCC0h, 0FCC0h, 0FCC1h, 0FCC2h, 0FCC3h, 0FCC4h, 0FCC4h, 0FCC5h
             dw 0FCC6h, 0FCC7h, 0FCC7h, 0FCC8h, 0FCC9h, 0FCCAh, 0FCCBh, 0FCCBh
             dw 0FCCCh, 0FCCDh, 0FCCEh, 0FCCEh, 0FCCFh, 0FCD0h, 0FCD1h, 0FCD2h
             dw 0FCD2h, 0FCD3h, 0FCD4h, 0FCD5h, 0FCD5h, 0FCD6h, 0FCD7h, 0FCD8h
             dw 0FCD9h, 0FCD9h, 0FCDAh, 0FCDBh, 0FCDCh, 0FCDCh, 0FCDDh, 0FCDEh
             dw 0FCDFh, 0FCE0h, 0FCE0h, 0FCE1h, 0FCE2h, 0FCE3h, 0FCE4h, 0FCE4h
             dw 0FCE5h, 0FCE6h, 0FCE7h, 0FCE8h, 0FCE8h, 0FCE9h, 0FCEAh, 0FCEBh
             dw 0FCECh, 0FCECh, 0FCEDh, 0FCEEh, 0FCEFh, 0FCF0h, 0FCF0h, 0FCF1h
             dw 0FCF2h, 0FCF3h, 0FCF3h, 0FCF4h, 0FCF5h, 0FCF6h, 0FCF7h, 0FCF8h
             dw 0FCF8h, 0FCF9h, 0FCFAh, 0FCFBh, 0FCFCh, 0FCFCh, 0FCFDh, 0FCFEh
             dw 0FCFFh, 0FD00h, 0FD00h, 0FD01h, 0FD02h, 0FD03h, 0FD04h, 0FD04h
             dw 0FD05h, 0FD06h, 0FD07h, 0FD08h, 0FD08h, 0FD09h, 0FD0Ah, 0FD0Bh
             dw 0FD0Ch, 0FD0Dh, 0FD0Dh, 0FD0Eh, 0FD0Fh, 0FD10h, 0FD11h, 0FD11h
             dw 0FD12h, 0FD13h, 0FD14h, 0FD15h, 0FD15h, 0FD16h, 0FD17h, 0FD18h
             dw 0FD19h, 0FD1Ah, 0FD1Ah, 0FD1Bh, 0FD1Ch, 0FD1Dh, 0FD1Eh, 0FD1Fh
             dw 0FD1Fh, 0FD20h, 0FD21h, 0FD22h, 0FD23h, 0FD23h, 0FD24h, 0FD25h
             dw 0FD26h, 0FD27h, 0FD28h, 0FD28h, 0FD29h, 0FD2Ah, 0FD2Bh, 0FD2Ch
             dw 0FD2Dh, 0FD2Dh, 0FD2Eh, 0FD2Fh, 0FD30h, 0FD31h, 0FD32h, 0FD32h
             dw 0FD33h, 0FD34h, 0FD35h, 0FD36h, 0FD37h, 0FD37h, 0FD38h, 0FD39h
             dw 0FD3Ah, 0FD3Bh, 0FD3Ch, 0FD3Ch, 0FD3Dh, 0FD3Eh, 0FD3Fh, 0FD40h
             dw 0FD41h, 0FD41h, 0FD42h, 0FD43h, 0FD44h, 0FD45h, 0FD46h, 0FD47h
             dw 0FD47h, 0FD48h, 0FD49h, 0FD4Ah, 0FD4Bh, 0FD4Ch, 0FD4Ch, 0FD4Dh
             dw 0FD4Eh, 0FD4Fh, 0FD50h, 0FD51h, 0FD52h, 0FD52h, 0FD53h, 0FD54h
             dw 0FD55h, 0FD56h, 0FD57h, 0FD58h, 0FD58h, 0FD59h, 0FD5Ah, 0FD5Bh
             dw 0FD5Ch, 0FD5Dh, 0FD5Dh, 0FD5Eh, 0FD5Fh, 0FD60h, 0FD61h, 0FD62h
             dw 0FD63h, 0FD63h, 0FD64h, 0FD65h, 0FD66h, 0FD67h, 0FD68h, 0FD69h
             dw 0FD69h, 0FD6Ah, 0FD6Bh, 0FD6Ch, 0FD6Dh, 0FD6Eh, 0FD6Fh, 0FD70h
             dw 0FD70h, 0FD71h, 0FD72h, 0FD73h, 0FD74h, 0FD75h, 0FD76h, 0FD76h
             dw 0FD77h, 0FD78h, 0FD79h, 0FD7Ah, 0FD7Bh, 0FD7Ch, 0FD7Dh, 0FD7Dh
             dw 0FD7Eh, 0FD7Fh, 0FD80h, 0FD81h, 0FD82h, 0FD83h, 0FD83h, 0FD84h
             dw 0FD85h, 0FD86h, 0FD87h, 0FD88h, 0FD89h, 0FD8Ah, 0FD8Ah, 0FD8Bh
             dw 0FD8Ch, 0FD8Dh, 0FD8Eh, 0FD8Fh, 0FD90h, 0FD91h, 0FD91h, 0FD92h
             dw 0FD93h, 0FD94h, 0FD95h, 0FD96h, 0FD97h, 0FD98h, 0FD99h, 0FD99h
             dw 0FD9Ah, 0FD9Bh, 0FD9Ch, 0FD9Dh, 0FD9Eh, 0FD9Fh, 0FDA0h, 0FDA0h
             dw 0FDA1h, 0FDA2h, 0FDA3h, 0FDA4h, 0FDA5h, 0FDA6h, 0FDA7h, 0FDA8h
             dw 0FDA8h, 0FDA9h, 0FDAAh, 0FDABh, 0FDACh, 0FDADh, 0FDAEh, 0FDAFh
             dw 0FDB0h, 0FDB0h, 0FDB1h, 0FDB2h, 0FDB3h, 0FDB4h, 0FDB5h, 0FDB6h
             dw 0FDB7h, 0FDB8h, 0FDB8h, 0FDB9h, 0FDBAh, 0FDBBh, 0FDBCh, 0FDBDh
             dw 0FDBEh, 0FDBFh, 0FDC0h, 0FDC0h, 0FDC1h, 0FDC2h, 0FDC3h, 0FDC4h
             dw 0FDC5h, 0FDC6h, 0FDC7h, 0FDC8h, 0FDC9h, 0FDC9h, 0FDCAh, 0FDCBh
             dw 0FDCCh, 0FDCDh, 0FDCEh, 0FDCFh, 0FDD0h, 0FDD1h, 0FDD2h, 0FDD2h
             dw 0FDD3h, 0FDD4h, 0FDD5h, 0FDD6h, 0FDD7h, 0FDD8h, 0FDD9h, 0FDDAh
             dw 0FDDBh, 0FDDCh, 0FDDCh, 0FDDDh, 0FDDEh, 0FDDFh, 0FDE0h, 0FDE1h
             dw 0FDE2h, 0FDE3h, 0FDE4h, 0FDE5h, 0FDE6h, 0FDE6h, 0FDE7h, 0FDE8h
             dw 0FDE9h, 0FDEAh, 0FDEBh, 0FDECh, 0FDEDh, 0FDEEh, 0FDEFh, 0FDF0h
             dw 0FDF0h, 0FDF1h, 0FDF2h, 0FDF3h, 0FDF4h, 0FDF5h, 0FDF6h, 0FDF7h
             dw 0FDF8h, 0FDF9h, 0FDFAh, 0FDFBh, 0FDFBh, 0FDFCh, 0FDFDh, 0FDFEh
             dw 0FDFFh, 0FE00h, 0FE01h, 0FE02h, 0FE03h, 0FE04h, 0FE05h, 0FE06h
             dw 0FE06h, 0FE07h, 0FE08h, 0FE09h, 0FE0Ah, 0FE0Bh, 0FE0Ch, 0FE0Dh
             dw 0FE0Eh, 0FE0Fh, 0FE10h, 0FE11h, 0FE12h, 0FE12h, 0FE13h, 0FE14h
             dw 0FE15h, 0FE16h, 0FE17h, 0FE18h, 0FE19h, 0FE1Ah, 0FE1Bh, 0FE1Ch
             dw 0FE1Dh, 0FE1Eh, 0FE1Fh, 0FE1Fh, 0FE20h, 0FE21h, 0FE22h, 0FE23h
             dw 0FE24h, 0FE25h, 0FE26h, 0FE27h, 0FE28h, 0FE29h, 0FE2Ah, 0FE2Bh
             dw 0FE2Ch, 0FE2Ch, 0FE2Dh, 0FE2Eh, 0FE2Fh, 0FE30h, 0FE31h, 0FE32h
             dw 0FE33h, 0FE34h, 0FE35h, 0FE36h, 0FE37h, 0FE38h, 0FE39h, 0FE3Ah
             dw 0FE3Bh, 0FE3Bh, 0FE3Ch, 0FE3Dh, 0FE3Eh, 0FE3Fh, 0FE40h, 0FE41h
             dw 0FE42h, 0FE43h, 0FE44h, 0FE45h, 0FE46h, 0FE47h, 0FE48h, 0FE49h
             dw 0FE4Ah, 0FE4Ah, 0FE4Bh, 0FE4Ch, 0FE4Dh, 0FE4Eh, 0FE4Fh, 0FE50h
             dw 0FE51h, 0FE52h, 0FE53h, 0FE54h, 0FE55h, 0FE56h, 0FE57h, 0FE58h
             dw 0FE59h, 0FE5Ah, 0FE5Bh, 0FE5Bh, 0FE5Ch, 0FE5Dh, 0FE5Eh, 0FE5Fh
             dw 0FE60h, 0FE61h, 0FE62h, 0FE63h, 0FE64h, 0FE65h, 0FE66h, 0FE67h
             dw 0FE68h, 0FE69h, 0FE6Ah, 0FE6Bh, 0FE6Ch, 0FE6Dh, 0FE6Dh, 0FE6Eh
             dw 0FE6Fh, 0FE70h, 0FE71h, 0FE72h, 0FE73h, 0FE74h, 0FE75h, 0FE76h
             dw 0FE77h, 0FE78h, 0FE79h, 0FE7Ah, 0FE7Bh, 0FE7Ch, 0FE7Dh, 0FE7Eh
             dw 0FE7Fh, 0FE80h, 0FE81h, 0FE81h, 0FE82h, 0FE83h, 0FE84h, 0FE85h
             dw 0FE86h, 0FE87h, 0FE88h, 0FE89h, 0FE8Ah, 0FE8Bh, 0FE8Ch, 0FE8Dh
             dw 0FE8Eh, 0FE8Fh, 0FE90h, 0FE91h, 0FE92h, 0FE93h, 0FE94h, 0FE95h
             dw 0FE96h, 0FE97h, 0FE98h, 0FE98h, 0FE99h, 0FE9Ah, 0FE9Bh, 0FE9Ch
             dw 0FE9Dh, 0FE9Eh, 0FE9Fh, 0FEA0h, 0FEA1h, 0FEA2h, 0FEA3h, 0FEA4h
             dw 0FEA5h, 0FEA6h, 0FEA7h, 0FEA8h, 0FEA9h, 0FEAAh, 0FEABh, 0FEACh
             dw 0FEADh, 0FEAEh, 0FEAFh, 0FEB0h, 0FEB1h, 0FEB2h, 0FEB2h, 0FEB3h
             dw 0FEB4h, 0FEB5h, 0FEB6h, 0FEB7h, 0FEB8h, 0FEB9h, 0FEBAh, 0FEBBh
             dw 0FEBCh, 0FEBDh, 0FEBEh, 0FEBFh, 0FEC0h, 0FEC1h, 0FEC2h, 0FEC3h
             dw 0FEC4h, 0FEC5h, 0FEC6h, 0FEC7h, 0FEC8h, 0FEC9h, 0FECAh, 0FECBh
             dw 0FECCh, 0FECDh, 0FECEh, 0FECFh, 0FED0h, 0FED1h, 0FED1h, 0FED2h
             dw 0FED3h, 0FED4h, 0FED5h, 0FED6h, 0FED7h, 0FED8h, 0FED9h, 0FEDAh
             dw 0FEDBh, 0FEDCh, 0FEDDh, 0FEDEh, 0FEDFh, 0FEE0h, 0FEE1h, 0FEE2h
             dw 0FEE3h, 0FEE4h, 0FEE5h, 0FEE6h, 0FEE7h, 0FEE8h, 0FEE9h, 0FEEAh
             dw 0FEEBh, 0FEECh, 0FEEDh, 0FEEEh, 0FEEFh, 0FEF0h, 0FEF1h, 0FEF2h
             dw 0FEF3h, 0FEF4h, 0FEF5h, 0FEF6h, 0FEF7h, 0FEF8h, 0FEF9h, 0FEF9h
             dw 0FEFAh, 0FEFBh, 0FEFCh, 0FEFDh, 0FEFEh, 0FEFFh, 0FF00h, 0FF01h
             dw 0FF02h, 0FF03h, 0FF04h, 0FF05h, 0FF06h, 0FF07h, 0FF08h, 0FF09h
             dw 0FF0Ah, 0FF0Bh, 0FF0Ch, 0FF0Dh, 0FF0Eh, 0FF0Fh, 0FF10h, 0FF11h
             dw 0FF12h, 0FF13h, 0FF14h, 0FF15h, 0FF16h, 0FF17h, 0FF18h, 0FF19h
             dw 0FF1Ah, 0FF1Bh, 0FF1Ch, 0FF1Dh, 0FF1Eh, 0FF1Fh, 0FF20h, 0FF21h
             dw 0FF22h, 0FF23h, 0FF24h, 0FF25h, 0FF26h, 0FF27h, 0FF28h, 0FF29h
             dw 0FF2Ah, 0FF2Bh, 0FF2Ch, 0FF2Dh, 0FF2Eh, 0FF2Fh, 0FF30h, 0FF31h
             dw 0FF32h, 0FF32h, 0FF33h, 0FF34h, 0FF35h, 0FF36h, 0FF37h, 0FF38h
             dw 0FF39h, 0FF3Ah, 0FF3Bh, 0FF3Ch, 0FF3Dh, 0FF3Eh, 0FF3Fh, 0FF40h
             dw 0FF41h, 0FF42h, 0FF43h, 0FF44h, 0FF45h, 0FF46h, 0FF47h, 0FF48h
             dw 0FF49h, 0FF4Ah, 0FF4Bh, 0FF4Ch, 0FF4Dh, 0FF4Eh, 0FF4Fh, 0FF50h
             dw 0FF51h, 0FF52h, 0FF53h, 0FF54h, 0FF55h, 0FF56h, 0FF57h, 0FF58h
             dw 0FF59h, 0FF5Ah, 0FF5Bh, 0FF5Ch, 0FF5Dh, 0FF5Eh, 0FF5Fh, 0FF60h
             dw 0FF61h, 0FF62h, 0FF63h, 0FF64h, 0FF65h, 0FF66h, 0FF67h, 0FF68h
             dw 0FF69h, 0FF6Ah, 0FF6Bh, 0FF6Ch, 0FF6Dh, 0FF6Eh, 0FF6Fh, 0FF70h
             dw 0FF71h, 0FF72h, 0FF73h, 0FF74h, 0FF75h, 0FF76h, 0FF77h, 0FF78h
             dw 0FF79h, 0FF7Ah, 0FF7Bh, 0FF7Ch, 0FF7Dh, 0FF7Eh, 0FF7Fh, 0FF80h
             dw 0FF81h, 0FF82h, 0FF83h, 0FF84h, 0FF85h, 0FF86h, 0FF87h, 0FF88h
             dw 0FF89h, 0FF8Ah, 0FF8Bh, 0FF8Ch, 0FF8Dh, 0FF8Eh, 0FF8Fh, 0FF90h
             dw 0FF91h, 0FF92h, 0FF93h, 0FF94h, 0FF95h, 0FF96h, 0FF97h, 0FF98h
             dw 0FF99h, 0FF9Ah, 0FF9Bh, 0FF9Ch, 0FF9Dh, 0FF9Eh, 0FF9Fh, 0FFA0h
             dw 0FFA1h, 0FFA2h, 0FFA3h, 0FFA4h, 0FFA5h, 0FFA6h, 0FFA7h, 0FFA8h
             dw 0FFA9h, 0FFAAh, 0FFABh, 0FFACh, 0FFADh, 0FFAEh, 0FFAFh, 0FFB0h
             dw 0FFB1h, 0FFB2h, 0FFB3h, 0FFB4h, 0FFB5h, 0FFB6h, 0FFB7h, 0FFB8h
             dw 0FFB9h, 0FFBAh, 0FFBBh, 0FFBCh, 0FFBDh, 0FFBEh, 0FFBFh, 0FFC0h
             dw 0FFC1h, 0FFC2h, 0FFC3h, 0FFC4h, 0FFC5h, 0FFC6h, 0FFC7h, 0FFC8h
             dw 0FFC9h, 0FFCAh, 0FFCBh, 0FFCCh, 0FFCDh, 0FFCEh, 0FFCFh, 0FFD0h
             dw 0FFD1h, 0FFD2h, 0FFD3h, 0FFD4h, 0FFD5h, 0FFD6h, 0FFD7h, 0FFD8h
             dw 0FFD9h, 0FFDAh, 0FFDBh, 0FFDCh, 0FFDDh, 0FFDEh, 0FFDFh, 0FFE0h
             dw 0FFE1h, 0FFE2h, 0FFE3h, 0FFE4h, 0FFE5h, 0FFE6h, 0FFE7h, 0FFE8h
             dw 0FFE9h, 0FFEAh, 0FFEBh, 0FFECh, 0FFEDh, 0FFEEh, 0FFEFh, 0FFF0h
             dw 0FFF1h, 0FFF2h, 0FFF3h, 0FFF4h, 0FFF5h, 0FFF6h, 0FFF7h, 0FFF8h
             dw 0FFF9h, 0FFFAh, 0FFFBh, 0FFFCh, 0FFFDh, 0FFFEh, 0FFFFh, 00000h

ctab    EQU ($-stab)

             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00512h
             dw 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h
             dw 00512h, 00512h, 00512h, 00511h, 00511h, 00511h, 00511h, 00511h
             dw 00511h, 00511h, 00511h, 00511h, 00511h, 00511h, 00510h, 00510h
             dw 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h
             dw 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh
             dw 0050Fh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh
             dw 0050Eh, 0050Eh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh
             dw 0050Dh, 0050Dh, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch
             dw 0050Ch, 0050Ch, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh
             dw 0050Bh, 0050Bh, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah
             dw 0050Ah, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h
             dw 00508h, 00508h, 00508h, 00508h, 00508h, 00508h, 00508h, 00507h
             dw 00507h, 00507h, 00507h, 00507h, 00507h, 00506h, 00506h, 00506h
             dw 00506h, 00506h, 00506h, 00505h, 00505h, 00505h, 00505h, 00505h
             dw 00505h, 00504h, 00504h, 00504h, 00504h, 00504h, 00504h, 00503h
             dw 00503h, 00503h, 00503h, 00503h, 00503h, 00502h, 00502h, 00502h
             dw 00502h, 00502h, 00502h, 00501h, 00501h, 00501h, 00501h, 00501h
             dw 00500h, 00500h, 00500h, 00500h, 00500h, 00500h, 004FFh, 004FFh
             dw 004FFh, 004FFh, 004FFh, 004FEh, 004FEh, 004FEh, 004FEh, 004FEh
             dw 004FDh, 004FDh, 004FDh, 004FDh, 004FDh, 004FCh, 004FCh, 004FCh
             dw 004FCh, 004FCh, 004FBh, 004FBh, 004FBh, 004FBh, 004FBh, 004FAh
             dw 004FAh, 004FAh, 004FAh, 004FAh, 004F9h, 004F9h, 004F9h, 004F9h
             dw 004F9h, 004F8h, 004F8h, 004F8h, 004F8h, 004F7h, 004F7h, 004F7h
             dw 004F7h, 004F7h, 004F6h, 004F6h, 004F6h, 004F6h, 004F6h, 004F5h
             dw 004F5h, 004F5h, 004F5h, 004F4h, 004F4h, 004F4h, 004F4h, 004F3h
             dw 004F3h, 004F3h, 004F3h, 004F3h, 004F2h, 004F2h, 004F2h, 004F2h
             dw 004F1h, 004F1h, 004F1h, 004F1h, 004F0h, 004F0h, 004F0h, 004F0h
             dw 004EFh, 004EFh, 004EFh, 004EFh, 004EEh, 004EEh, 004EEh, 004EEh
             dw 004EDh, 004EDh, 004EDh, 004EDh, 004ECh, 004ECh, 004ECh, 004ECh
             dw 004EBh, 004EBh, 004EBh, 004EBh, 004EAh, 004EAh, 004EAh, 004EAh
             dw 004E9h, 004E9h, 004E9h, 004E9h, 004E8h, 004E8h, 004E8h, 004E8h
             dw 004E7h, 004E7h, 004E7h, 004E6h, 004E6h, 004E6h, 004E6h, 004E5h
             dw 004E5h, 004E5h, 004E5h, 004E4h, 004E4h, 004E4h, 004E3h, 004E3h
             dw 004E3h, 004E3h, 004E2h, 004E2h, 004E2h, 004E2h, 004E1h, 004E1h
             dw 004E1h, 004E0h, 004E0h, 004E0h, 004E0h, 004DFh, 004DFh, 004DFh
             dw 004DEh, 004DEh, 004DEh, 004DEh, 004DDh, 004DDh, 004DDh, 004DCh
             dw 004DCh, 004DCh, 004DBh, 004DBh, 004DBh, 004DBh, 004DAh, 004DAh
             dw 004DAh, 004D9h, 004D9h, 004D9h, 004D8h, 004D8h, 004D8h, 004D8h
             dw 004D7h, 004D7h, 004D7h, 004D6h, 004D6h, 004D6h, 004D5h, 004D5h
             dw 004D5h, 004D4h, 004D4h, 004D4h, 004D3h, 004D3h, 004D3h, 004D3h
             dw 004D2h, 004D2h, 004D2h, 004D1h, 004D1h, 004D1h, 004D0h, 004D0h
             dw 004D0h, 004CFh, 004CFh, 004CFh, 004CEh, 004CEh, 004CEh, 004CDh
             dw 004CDh, 004CDh, 004CCh, 004CCh, 004CCh, 004CBh, 004CBh, 004CBh
             dw 004CAh, 004CAh, 004CAh, 004C9h, 004C9h, 004C9h, 004C8h, 004C8h
             dw 004C8h, 004C7h, 004C7h, 004C7h, 004C6h, 004C6h, 004C6h, 004C5h
             dw 004C5h, 004C5h, 004C4h, 004C4h, 004C3h, 004C3h, 004C3h, 004C2h
             dw 004C2h, 004C2h, 004C1h, 004C1h, 004C1h, 004C0h, 004C0h, 004C0h
             dw 004BFh, 004BFh, 004BEh, 004BEh, 004BEh, 004BDh, 004BDh, 004BDh
             dw 004BCh, 004BCh, 004BCh, 004BBh, 004BBh, 004BAh, 004BAh, 004BAh
             dw 004B9h, 004B9h, 004B9h, 004B8h, 004B8h, 004B7h, 004B7h, 004B7h
             dw 004B6h, 004B6h, 004B6h, 004B5h, 004B5h, 004B4h, 004B4h, 004B4h
             dw 004B3h, 004B3h, 004B3h, 004B2h, 004B2h, 004B1h, 004B1h, 004B1h
             dw 004B0h, 004B0h, 004AFh, 004AFh, 004AFh, 004AEh, 004AEh, 004ADh
             dw 004ADh, 004ADh, 004ACh, 004ACh, 004ACh, 004ABh, 004ABh, 004AAh
             dw 004AAh, 004AAh, 004A9h, 004A9h, 004A8h, 004A8h, 004A8h, 004A7h
             dw 004A7h, 004A6h, 004A6h, 004A5h, 004A5h, 004A5h, 004A4h, 004A4h
             dw 004A3h, 004A3h, 004A3h, 004A2h, 004A2h, 004A1h, 004A1h, 004A1h
             dw 004A0h, 004A0h, 0049Fh, 0049Fh, 0049Eh, 0049Eh, 0049Eh, 0049Dh
             dw 0049Dh, 0049Ch, 0049Ch, 0049Ch, 0049Bh, 0049Bh, 0049Ah, 0049Ah
             dw 00499h, 00499h, 00499h, 00498h, 00498h, 00497h, 00497h, 00496h
             dw 00496h, 00496h, 00495h, 00495h, 00494h, 00494h, 00493h, 00493h
             dw 00492h, 00492h, 00492h, 00491h, 00491h, 00490h, 00490h, 0048Fh
             dw 0048Fh, 0048Eh, 0048Eh, 0048Eh, 0048Dh, 0048Dh, 0048Ch, 0048Ch
             dw 0048Bh, 0048Bh, 0048Ah, 0048Ah, 0048Ah, 00489h, 00489h, 00488h
             dw 00488h, 00487h, 00487h, 00486h, 00486h, 00485h, 00485h, 00485h
             dw 00484h, 00484h, 00483h, 00483h, 00482h, 00482h, 00481h, 00481h
             dw 00480h, 00480h, 0047Fh, 0047Fh, 0047Fh, 0047Eh, 0047Eh, 0047Dh
             dw 0047Dh, 0047Ch, 0047Ch, 0047Bh, 0047Bh, 0047Ah, 0047Ah, 00479h
             dw 00479h, 00478h, 00478h, 00477h, 00477h, 00476h, 00476h, 00476h
             dw 00475h, 00475h, 00474h, 00474h, 00473h, 00473h, 00472h, 00472h
             dw 00471h, 00471h, 00470h, 00470h, 0046Fh, 0046Fh, 0046Eh, 0046Eh
             dw 0046Dh, 0046Dh, 0046Ch, 0046Ch, 0046Bh, 0046Bh, 0046Ah, 0046Ah
             dw 00469h, 00469h, 00468h, 00468h, 00467h, 00467h, 00466h, 00466h
             dw 00465h, 00465h, 00464h, 00464h, 00463h, 00463h, 00462h, 00462h
             dw 00461h, 00461h, 00460h, 00460h, 0045Fh, 0045Fh, 0045Eh, 0045Eh
             dw 0045Dh, 0045Dh, 0045Ch, 0045Ch, 0045Bh, 0045Bh, 0045Ah, 0045Ah
             dw 00459h, 00458h, 00458h, 00457h, 00457h, 00456h, 00456h, 00455h
             dw 00455h, 00454h, 00454h, 00453h, 00453h, 00452h, 00452h, 00451h
             dw 00451h, 00450h, 00450h, 0044Fh, 0044Eh, 0044Eh, 0044Dh, 0044Dh
             dw 0044Ch, 0044Ch, 0044Bh, 0044Bh, 0044Ah, 0044Ah, 00449h, 00449h
             dw 00448h, 00448h, 00447h, 00446h, 00446h, 00445h, 00445h, 00444h
             dw 00444h, 00443h, 00443h, 00442h, 00442h, 00441h, 00440h, 00440h
             dw 0043Fh, 0043Fh, 0043Eh, 0043Eh, 0043Dh, 0043Dh, 0043Ch, 0043Bh
             dw 0043Bh, 0043Ah, 0043Ah, 00439h, 00439h, 00438h, 00438h, 00437h
             dw 00436h, 00436h, 00435h, 00435h, 00434h, 00434h, 00433h, 00433h
             dw 00432h, 00431h, 00431h, 00430h, 00430h, 0042Fh, 0042Fh, 0042Eh
             dw 0042Dh, 0042Dh, 0042Ch, 0042Ch, 0042Bh, 0042Bh, 0042Ah, 00429h
             dw 00429h, 00428h, 00428h, 00427h, 00427h, 00426h, 00425h, 00425h
             dw 00424h, 00424h, 00423h, 00422h, 00422h, 00421h, 00421h, 00420h
             dw 00420h, 0041Fh, 0041Eh, 0041Eh, 0041Dh, 0041Dh, 0041Ch, 0041Bh
             dw 0041Bh, 0041Ah, 0041Ah, 00419h, 00418h, 00418h, 00417h, 00417h
             dw 00416h, 00415h, 00415h, 00414h, 00414h, 00413h, 00412h, 00412h
             dw 00411h, 00411h, 00410h, 0040Fh, 0040Fh, 0040Eh, 0040Eh, 0040Dh
             dw 0040Ch, 0040Ch, 0040Bh, 0040Bh, 0040Ah, 00409h, 00409h, 00408h
             dw 00408h, 00407h, 00406h, 00406h, 00405h, 00405h, 00404h, 00403h
             dw 00403h, 00402h, 00401h, 00401h, 00400h, 00400h, 003FFh, 003FEh
             dw 003FEh, 003FDh, 003FDh, 003FCh, 003FBh, 003FBh, 003FAh, 003F9h
             dw 003F9h, 003F8h, 003F8h, 003F7h, 003F6h, 003F6h, 003F5h, 003F4h
             dw 003F4h, 003F3h, 003F3h, 003F2h, 003F1h, 003F1h, 003F0h, 003EFh
             dw 003EFh, 003EEh, 003EDh, 003EDh, 003ECh, 003ECh, 003EBh, 003EAh
             dw 003EAh, 003E9h, 003E8h, 003E8h, 003E7h, 003E6h, 003E6h, 003E5h
             dw 003E5h, 003E4h, 003E3h, 003E3h, 003E2h, 003E1h, 003E1h, 003E0h
             dw 003DFh, 003DFh, 003DEh, 003DDh, 003DDh, 003DCh, 003DBh, 003DBh
             dw 003DAh, 003D9h, 003D9h, 003D8h, 003D8h, 003D7h, 003D6h, 003D6h
             dw 003D5h, 003D4h, 003D4h, 003D3h, 003D2h, 003D2h, 003D1h, 003D0h
             dw 003D0h, 003CFh, 003CEh, 003CEh, 003CDh, 003CCh, 003CCh, 003CBh
             dw 003CAh, 003CAh, 003C9h, 003C8h, 003C8h, 003C7h, 003C6h, 003C6h
             dw 003C5h, 003C4h, 003C4h, 003C3h, 003C2h, 003C2h, 003C1h, 003C0h
             dw 003C0h, 003BFh, 003BEh, 003BEh, 003BDh, 003BCh, 003BCh, 003BBh
             dw 003BAh, 003B9h, 003B9h, 003B8h, 003B7h, 003B7h, 003B6h, 003B5h
             dw 003B5h, 003B4h, 003B3h, 003B3h, 003B2h, 003B1h, 003B1h, 003B0h
             dw 003AFh, 003AFh, 003AEh, 003ADh, 003ACh, 003ACh, 003ABh, 003AAh
             dw 003AAh, 003A9h, 003A8h, 003A8h, 003A7h, 003A6h, 003A5h, 003A5h
             dw 003A4h, 003A3h, 003A3h, 003A2h, 003A1h, 003A1h, 003A0h, 0039Fh
             dw 0039Eh, 0039Eh, 0039Dh, 0039Ch, 0039Ch, 0039Bh, 0039Ah, 0039Ah
             dw 00399h, 00398h, 00397h, 00397h, 00396h, 00395h, 00395h, 00394h
             dw 00393h, 00392h, 00392h, 00391h, 00390h, 00390h, 0038Fh, 0038Eh
             dw 0038Dh, 0038Dh, 0038Ch, 0038Bh, 0038Bh, 0038Ah, 00389h, 00388h
             dw 00388h, 00387h, 00386h, 00386h, 00385h, 00384h, 00383h, 00383h
             dw 00382h, 00381h, 00381h, 00380h, 0037Fh, 0037Eh, 0037Eh, 0037Dh
             dw 0037Ch, 0037Bh, 0037Bh, 0037Ah, 00379h, 00379h, 00378h, 00377h
             dw 00376h, 00376h, 00375h, 00374h, 00373h, 00373h, 00372h, 00371h
             dw 00370h, 00370h, 0036Fh, 0036Eh, 0036Dh, 0036Dh, 0036Ch, 0036Bh
             dw 0036Bh, 0036Ah, 00369h, 00368h, 00368h, 00367h, 00366h, 00365h
             dw 00365h, 00364h, 00363h, 00362h, 00362h, 00361h, 00360h, 0035Fh
             dw 0035Fh, 0035Eh, 0035Dh, 0035Ch, 0035Ch, 0035Bh, 0035Ah, 00359h
             dw 00359h, 00358h, 00357h, 00356h, 00356h, 00355h, 00354h, 00353h
             dw 00353h, 00352h, 00351h, 00350h, 00350h, 0034Fh, 0034Eh, 0034Dh
             dw 0034Dh, 0034Ch, 0034Bh, 0034Ah, 00349h, 00349h, 00348h, 00347h
             dw 00346h, 00346h, 00345h, 00344h, 00343h, 00343h, 00342h, 00341h
             dw 00340h, 00340h, 0033Fh, 0033Eh, 0033Dh, 0033Ch, 0033Ch, 0033Bh
             dw 0033Ah, 00339h, 00339h, 00338h, 00337h, 00336h, 00335h, 00335h
             dw 00334h, 00333h, 00332h, 00332h, 00331h, 00330h, 0032Fh, 0032Eh
             dw 0032Eh, 0032Dh, 0032Ch, 0032Bh, 0032Bh, 0032Ah, 00329h, 00328h
             dw 00327h, 00327h, 00326h, 00325h, 00324h, 00324h, 00323h, 00322h
             dw 00321h, 00320h, 00320h, 0031Fh, 0031Eh, 0031Dh, 0031Ch, 0031Ch
             dw 0031Bh, 0031Ah, 00319h, 00318h, 00318h, 00317h, 00316h, 00315h
             dw 00314h, 00314h, 00313h, 00312h, 00311h, 00310h, 00310h, 0030Fh
             dw 0030Eh, 0030Dh, 0030Dh, 0030Ch, 0030Bh, 0030Ah, 00309h, 00308h
             dw 00308h, 00307h, 00306h, 00305h, 00304h, 00304h, 00303h, 00302h
             dw 00301h, 00300h, 00300h, 002FFh, 002FEh, 002FDh, 002FCh, 002FCh
             dw 002FBh, 002FAh, 002F9h, 002F8h, 002F8h, 002F7h, 002F6h, 002F5h
             dw 002F4h, 002F3h, 002F3h, 002F2h, 002F1h, 002F0h, 002EFh, 002EFh
             dw 002EEh, 002EDh, 002ECh, 002EBh, 002EBh, 002EAh, 002E9h, 002E8h
             dw 002E7h, 002E6h, 002E6h, 002E5h, 002E4h, 002E3h, 002E2h, 002E1h
             dw 002E1h, 002E0h, 002DFh, 002DEh, 002DDh, 002DDh, 002DCh, 002DBh
             dw 002DAh, 002D9h, 002D8h, 002D8h, 002D7h, 002D6h, 002D5h, 002D4h
             dw 002D3h, 002D3h, 002D2h, 002D1h, 002D0h, 002CFh, 002CEh, 002CEh
             dw 002CDh, 002CCh, 002CBh, 002CAh, 002C9h, 002C9h, 002C8h, 002C7h
             dw 002C6h, 002C5h, 002C4h, 002C4h, 002C3h, 002C2h, 002C1h, 002C0h
             dw 002BFh, 002BFh, 002BEh, 002BDh, 002BCh, 002BBh, 002BAh, 002B9h
             dw 002B9h, 002B8h, 002B7h, 002B6h, 002B5h, 002B4h, 002B4h, 002B3h
             dw 002B2h, 002B1h, 002B0h, 002AFh, 002AEh, 002AEh, 002ADh, 002ACh
             dw 002ABh, 002AAh, 002A9h, 002A8h, 002A8h, 002A7h, 002A6h, 002A5h
             dw 002A4h, 002A3h, 002A3h, 002A2h, 002A1h, 002A0h, 0029Fh, 0029Eh
             dw 0029Dh, 0029Dh, 0029Ch, 0029Bh, 0029Ah, 00299h, 00298h, 00297h
             dw 00297h, 00296h, 00295h, 00294h, 00293h, 00292h, 00291h, 00290h
             dw 00290h, 0028Fh, 0028Eh, 0028Dh, 0028Ch, 0028Bh, 0028Ah, 0028Ah
             dw 00289h, 00288h, 00287h, 00286h, 00285h, 00284h, 00283h, 00283h
             dw 00282h, 00281h, 00280h, 0027Fh, 0027Eh, 0027Dh, 0027Dh, 0027Ch
             dw 0027Bh, 0027Ah, 00279h, 00278h, 00277h, 00276h, 00276h, 00275h
             dw 00274h, 00273h, 00272h, 00271h, 00270h, 0026Fh, 0026Fh, 0026Eh
             dw 0026Dh, 0026Ch, 0026Bh, 0026Ah, 00269h, 00268h, 00267h, 00267h
             dw 00266h, 00265h, 00264h, 00263h, 00262h, 00261h, 00260h, 00260h
             dw 0025Fh, 0025Eh, 0025Dh, 0025Ch, 0025Bh, 0025Ah, 00259h, 00258h
             dw 00258h, 00257h, 00256h, 00255h, 00254h, 00253h, 00252h, 00251h
             dw 00250h, 00250h, 0024Fh, 0024Eh, 0024Dh, 0024Ch, 0024Bh, 0024Ah
             dw 00249h, 00248h, 00248h, 00247h, 00246h, 00245h, 00244h, 00243h
             dw 00242h, 00241h, 00240h, 00240h, 0023Fh, 0023Eh, 0023Dh, 0023Ch
             dw 0023Bh, 0023Ah, 00239h, 00238h, 00237h, 00237h, 00236h, 00235h
             dw 00234h, 00233h, 00232h, 00231h, 00230h, 0022Fh, 0022Eh, 0022Eh
             dw 0022Dh, 0022Ch, 0022Bh, 0022Ah, 00229h, 00228h, 00227h, 00226h
             dw 00225h, 00224h, 00224h, 00223h, 00222h, 00221h, 00220h, 0021Fh
             dw 0021Eh, 0021Dh, 0021Ch, 0021Bh, 0021Ah, 0021Ah, 00219h, 00218h
             dw 00217h, 00216h, 00215h, 00214h, 00213h, 00212h, 00211h, 00210h
             dw 00210h, 0020Fh, 0020Eh, 0020Dh, 0020Ch, 0020Bh, 0020Ah, 00209h
             dw 00208h, 00207h, 00206h, 00205h, 00205h, 00204h, 00203h, 00202h
             dw 00201h, 00200h, 001FFh, 001FEh, 001FDh, 001FCh, 001FBh, 001FAh
             dw 001FAh, 001F9h, 001F8h, 001F7h, 001F6h, 001F5h, 001F4h, 001F3h
             dw 001F2h, 001F1h, 001F0h, 001EFh, 001EEh, 001EEh, 001EDh, 001ECh
             dw 001EBh, 001EAh, 001E9h, 001E8h, 001E7h, 001E6h, 001E5h, 001E4h
             dw 001E3h, 001E2h, 001E1h, 001E1h, 001E0h, 001DFh, 001DEh, 001DDh
             dw 001DCh, 001DBh, 001DAh, 001D9h, 001D8h, 001D7h, 001D6h, 001D5h
             dw 001D4h, 001D4h, 001D3h, 001D2h, 001D1h, 001D0h, 001CFh, 001CEh
             dw 001CDh, 001CCh, 001CBh, 001CAh, 001C9h, 001C8h, 001C7h, 001C6h
             dw 001C5h, 001C5h, 001C4h, 001C3h, 001C2h, 001C1h, 001C0h, 001BFh
             dw 001BEh, 001BDh, 001BCh, 001BBh, 001BAh, 001B9h, 001B8h, 001B7h
             dw 001B6h, 001B6h, 001B5h, 001B4h, 001B3h, 001B2h, 001B1h, 001B0h
             dw 001AFh, 001AEh, 001ADh, 001ACh, 001ABh, 001AAh, 001A9h, 001A8h
             dw 001A7h, 001A6h, 001A5h, 001A5h, 001A4h, 001A3h, 001A2h, 001A1h
             dw 001A0h, 0019Fh, 0019Eh, 0019Dh, 0019Ch, 0019Bh, 0019Ah, 00199h
             dw 00198h, 00197h, 00196h, 00195h, 00194h, 00193h, 00193h, 00192h
             dw 00191h, 00190h, 0018Fh, 0018Eh, 0018Dh, 0018Ch, 0018Bh, 0018Ah
             dw 00189h, 00188h, 00187h, 00186h, 00185h, 00184h, 00183h, 00182h
             dw 00181h, 00180h, 0017Fh, 0017Fh, 0017Eh, 0017Dh, 0017Ch, 0017Bh
             dw 0017Ah, 00179h, 00178h, 00177h, 00176h, 00175h, 00174h, 00173h
             dw 00172h, 00171h, 00170h, 0016Fh, 0016Eh, 0016Dh, 0016Ch, 0016Bh
             dw 0016Ah, 00169h, 00168h, 00168h, 00167h, 00166h, 00165h, 00164h
             dw 00163h, 00162h, 00161h, 00160h, 0015Fh, 0015Eh, 0015Dh, 0015Ch
             dw 0015Bh, 0015Ah, 00159h, 00158h, 00157h, 00156h, 00155h, 00154h
             dw 00153h, 00152h, 00151h, 00150h, 0014Fh, 0014Eh, 0014Eh, 0014Dh
             dw 0014Ch, 0014Bh, 0014Ah, 00149h, 00148h, 00147h, 00146h, 00145h
             dw 00144h, 00143h, 00142h, 00141h, 00140h, 0013Fh, 0013Eh, 0013Dh
             dw 0013Ch, 0013Bh, 0013Ah, 00139h, 00138h, 00137h, 00136h, 00135h
             dw 00134h, 00133h, 00132h, 00131h, 00130h, 0012Fh, 0012Fh, 0012Eh
             dw 0012Dh, 0012Ch, 0012Bh, 0012Ah, 00129h, 00128h, 00127h, 00126h
             dw 00125h, 00124h, 00123h, 00122h, 00121h, 00120h, 0011Fh, 0011Eh
             dw 0011Dh, 0011Ch, 0011Bh, 0011Ah, 00119h, 00118h, 00117h, 00116h
             dw 00115h, 00114h, 00113h, 00112h, 00111h, 00110h, 0010Fh, 0010Eh
             dw 0010Dh, 0010Ch, 0010Bh, 0010Ah, 00109h, 00108h, 00107h, 00107h
             dw 00106h, 00105h, 00104h, 00103h, 00102h, 00101h, 00100h, 000FFh
             dw 000FEh, 000FDh, 000FCh, 000FBh, 000FAh, 000F9h, 000F8h, 000F7h
             dw 000F6h, 000F5h, 000F4h, 000F3h, 000F2h, 000F1h, 000F0h, 000EFh
             dw 000EEh, 000EDh, 000ECh, 000EBh, 000EAh, 000E9h, 000E8h, 000E7h
             dw 000E6h, 000E5h, 000E4h, 000E3h, 000E2h, 000E1h, 000E0h, 000DFh
             dw 000DEh, 000DDh, 000DCh, 000DBh, 000DAh, 000D9h, 000D8h, 000D7h
             dw 000D6h, 000D5h, 000D4h, 000D3h, 000D2h, 000D1h, 000D0h, 000CFh
             dw 000CEh, 000CEh, 000CDh, 000CCh, 000CBh, 000CAh, 000C9h, 000C8h
             dw 000C7h, 000C6h, 000C5h, 000C4h, 000C3h, 000C2h, 000C1h, 000C0h
             dw 000BFh, 000BEh, 000BDh, 000BCh, 000BBh, 000BAh, 000B9h, 000B8h
             dw 000B7h, 000B6h, 000B5h, 000B4h, 000B3h, 000B2h, 000B1h, 000B0h
             dw 000AFh, 000AEh, 000ADh, 000ACh, 000ABh, 000AAh, 000A9h, 000A8h
             dw 000A7h, 000A6h, 000A5h, 000A4h, 000A3h, 000A2h, 000A1h, 000A0h
             dw 0009Fh, 0009Eh, 0009Dh, 0009Ch, 0009Bh, 0009Ah, 00099h, 00098h
             dw 00097h, 00096h, 00095h, 00094h, 00093h, 00092h, 00091h, 00090h
             dw 0008Fh, 0008Eh, 0008Dh, 0008Ch, 0008Bh, 0008Ah, 00089h, 00088h
             dw 00087h, 00086h, 00085h, 00084h, 00083h, 00082h, 00081h, 00080h
             dw 0007Fh, 0007Eh, 0007Dh, 0007Ch, 0007Bh, 0007Ah, 00079h, 00078h
             dw 00077h, 00076h, 00075h, 00074h, 00073h, 00072h, 00071h, 00070h
             dw 0006Fh, 0006Eh, 0006Dh, 0006Ch, 0006Bh, 0006Ah, 00069h, 00068h
             dw 00067h, 00066h, 00065h, 00064h, 00063h, 00062h, 00061h, 00060h
             dw 0005Fh, 0005Eh, 0005Dh, 0005Ch, 0005Bh, 0005Ah, 00059h, 00058h
             dw 00057h, 00056h, 00055h, 00054h, 00053h, 00052h, 00051h, 00050h
             dw 0004Fh, 0004Eh, 0004Dh, 0004Ch, 0004Bh, 0004Ah, 00049h, 00048h
             dw 00047h, 00046h, 00045h, 00044h, 00043h, 00042h, 00041h, 00040h
             dw 0003Fh, 0003Eh, 0003Dh, 0003Ch, 0003Bh, 0003Ah, 00039h, 00038h
             dw 00037h, 00036h, 00035h, 00034h, 00033h, 00032h, 00031h, 00030h
             dw 0002Fh, 0002Eh, 0002Dh, 0002Ch, 0002Bh, 0002Ah, 00029h, 00028h
             dw 00027h, 00026h, 00025h, 00024h, 00023h, 00022h, 00021h, 00020h
             dw 0001Fh, 0001Eh, 0001Dh, 0001Ch, 0001Bh, 0001Ah, 00019h, 00018h
             dw 00017h, 00016h, 00015h, 00014h, 00013h, 00012h, 00011h, 00010h
             dw 0000Fh, 0000Eh, 0000Dh, 0000Ch, 0000Bh, 0000Ah, 00009h, 00008h
             dw 00007h, 00006h, 00005h, 00004h, 00003h, 00002h, 00001h, 00000h
             dw 00000h, 00000h, 0FFFFh, 0FFFEh, 0FFFDh, 0FFFCh, 0FFFBh, 0FFFAh
             dw 0FFF9h, 0FFF8h, 0FFF7h, 0FFF6h, 0FFF5h, 0FFF4h, 0FFF3h, 0FFF2h
             dw 0FFF1h, 0FFF0h, 0FFEFh, 0FFEEh, 0FFEDh, 0FFECh, 0FFEBh, 0FFEAh
             dw 0FFE9h, 0FFE8h, 0FFE7h, 0FFE6h, 0FFE5h, 0FFE4h, 0FFE3h, 0FFE2h
             dw 0FFE1h, 0FFE0h, 0FFDFh, 0FFDEh, 0FFDDh, 0FFDCh, 0FFDBh, 0FFDAh
             dw 0FFD9h, 0FFD8h, 0FFD7h, 0FFD6h, 0FFD5h, 0FFD4h, 0FFD3h, 0FFD2h
             dw 0FFD1h, 0FFD0h, 0FFCFh, 0FFCEh, 0FFCDh, 0FFCCh, 0FFCBh, 0FFCAh
             dw 0FFC9h, 0FFC8h, 0FFC7h, 0FFC6h, 0FFC5h, 0FFC4h, 0FFC3h, 0FFC2h
             dw 0FFC1h, 0FFC0h, 0FFBFh, 0FFBEh, 0FFBDh, 0FFBCh, 0FFBBh, 0FFBAh
             dw 0FFB9h, 0FFB8h, 0FFB7h, 0FFB6h, 0FFB5h, 0FFB4h, 0FFB3h, 0FFB2h
             dw 0FFB1h, 0FFB0h, 0FFAFh, 0FFAEh, 0FFADh, 0FFACh, 0FFABh, 0FFAAh
             dw 0FFA9h, 0FFA8h, 0FFA7h, 0FFA6h, 0FFA5h, 0FFA4h, 0FFA3h, 0FFA2h
             dw 0FFA1h, 0FFA0h, 0FF9Fh, 0FF9Eh, 0FF9Dh, 0FF9Ch, 0FF9Bh, 0FF9Ah
             dw 0FF99h, 0FF98h, 0FF97h, 0FF96h, 0FF95h, 0FF94h, 0FF93h, 0FF92h
             dw 0FF91h, 0FF90h, 0FF8Fh, 0FF8Eh, 0FF8Dh, 0FF8Ch, 0FF8Bh, 0FF8Ah
             dw 0FF89h, 0FF88h, 0FF87h, 0FF86h, 0FF85h, 0FF84h, 0FF83h, 0FF82h
             dw 0FF81h, 0FF80h, 0FF7Fh, 0FF7Eh, 0FF7Dh, 0FF7Ch, 0FF7Bh, 0FF7Ah
             dw 0FF79h, 0FF78h, 0FF77h, 0FF76h, 0FF75h, 0FF74h, 0FF73h, 0FF72h
             dw 0FF71h, 0FF70h, 0FF6Fh, 0FF6Eh, 0FF6Dh, 0FF6Ch, 0FF6Bh, 0FF6Ah
             dw 0FF69h, 0FF68h, 0FF67h, 0FF66h, 0FF65h, 0FF64h, 0FF63h, 0FF62h
             dw 0FF61h, 0FF60h, 0FF5Fh, 0FF5Eh, 0FF5Dh, 0FF5Ch, 0FF5Bh, 0FF5Ah
             dw 0FF59h, 0FF58h, 0FF57h, 0FF56h, 0FF55h, 0FF54h, 0FF53h, 0FF52h
             dw 0FF51h, 0FF50h, 0FF4Fh, 0FF4Eh, 0FF4Dh, 0FF4Ch, 0FF4Bh, 0FF4Ah
             dw 0FF49h, 0FF48h, 0FF47h, 0FF46h, 0FF45h, 0FF44h, 0FF43h, 0FF42h
             dw 0FF41h, 0FF40h, 0FF3Fh, 0FF3Eh, 0FF3Dh, 0FF3Ch, 0FF3Bh, 0FF3Ah
             dw 0FF39h, 0FF38h, 0FF37h, 0FF36h, 0FF35h, 0FF34h, 0FF33h, 0FF32h
             dw 0FF32h, 0FF31h, 0FF30h, 0FF2Fh, 0FF2Eh, 0FF2Dh, 0FF2Ch, 0FF2Bh
             dw 0FF2Ah, 0FF29h, 0FF28h, 0FF27h, 0FF26h, 0FF25h, 0FF24h, 0FF23h
             dw 0FF22h, 0FF21h, 0FF20h, 0FF1Fh, 0FF1Eh, 0FF1Dh, 0FF1Ch, 0FF1Bh
             dw 0FF1Ah, 0FF19h, 0FF18h, 0FF17h, 0FF16h, 0FF15h, 0FF14h, 0FF13h
             dw 0FF12h, 0FF11h, 0FF10h, 0FF0Fh, 0FF0Eh, 0FF0Dh, 0FF0Ch, 0FF0Bh
             dw 0FF0Ah, 0FF09h, 0FF08h, 0FF07h, 0FF06h, 0FF05h, 0FF04h, 0FF03h
             dw 0FF02h, 0FF01h, 0FF00h, 0FEFFh, 0FEFEh, 0FEFDh, 0FEFCh, 0FEFBh
             dw 0FEFAh, 0FEF9h, 0FEF9h, 0FEF8h, 0FEF7h, 0FEF6h, 0FEF5h, 0FEF4h
             dw 0FEF3h, 0FEF2h, 0FEF1h, 0FEF0h, 0FEEFh, 0FEEEh, 0FEEDh, 0FEECh
             dw 0FEEBh, 0FEEAh, 0FEE9h, 0FEE8h, 0FEE7h, 0FEE6h, 0FEE5h, 0FEE4h
             dw 0FEE3h, 0FEE2h, 0FEE1h, 0FEE0h, 0FEDFh, 0FEDEh, 0FEDDh, 0FEDCh
             dw 0FEDBh, 0FEDAh, 0FED9h, 0FED8h, 0FED7h, 0FED6h, 0FED5h, 0FED4h
             dw 0FED3h, 0FED2h, 0FED1h, 0FED1h, 0FED0h, 0FECFh, 0FECEh, 0FECDh
             dw 0FECCh, 0FECBh, 0FECAh, 0FEC9h, 0FEC8h, 0FEC7h, 0FEC6h, 0FEC5h
             dw 0FEC4h, 0FEC3h, 0FEC2h, 0FEC1h, 0FEC0h, 0FEBFh, 0FEBEh, 0FEBDh
             dw 0FEBCh, 0FEBBh, 0FEBAh, 0FEB9h, 0FEB8h, 0FEB7h, 0FEB6h, 0FEB5h
             dw 0FEB4h, 0FEB3h, 0FEB2h, 0FEB2h, 0FEB1h, 0FEB0h, 0FEAFh, 0FEAEh
             dw 0FEADh, 0FEACh, 0FEABh, 0FEAAh, 0FEA9h, 0FEA8h, 0FEA7h, 0FEA6h
             dw 0FEA5h, 0FEA4h, 0FEA3h, 0FEA2h, 0FEA1h, 0FEA0h, 0FE9Fh, 0FE9Eh
             dw 0FE9Dh, 0FE9Ch, 0FE9Bh, 0FE9Ah, 0FE99h, 0FE98h, 0FE98h, 0FE97h
             dw 0FE96h, 0FE95h, 0FE94h, 0FE93h, 0FE92h, 0FE91h, 0FE90h, 0FE8Fh
             dw 0FE8Eh, 0FE8Dh, 0FE8Ch, 0FE8Bh, 0FE8Ah, 0FE89h, 0FE88h, 0FE87h
             dw 0FE86h, 0FE85h, 0FE84h, 0FE83h, 0FE82h, 0FE81h, 0FE81h, 0FE80h
             dw 0FE7Fh, 0FE7Eh, 0FE7Dh, 0FE7Ch, 0FE7Bh, 0FE7Ah, 0FE79h, 0FE78h
             dw 0FE77h, 0FE76h, 0FE75h, 0FE74h, 0FE73h, 0FE72h, 0FE71h, 0FE70h
             dw 0FE6Fh, 0FE6Eh, 0FE6Dh, 0FE6Dh, 0FE6Ch, 0FE6Bh, 0FE6Ah, 0FE69h
             dw 0FE68h, 0FE67h, 0FE66h, 0FE65h, 0FE64h, 0FE63h, 0FE62h, 0FE61h
             dw 0FE60h, 0FE5Fh, 0FE5Eh, 0FE5Dh, 0FE5Ch, 0FE5Bh, 0FE5Bh, 0FE5Ah
             dw 0FE59h, 0FE58h, 0FE57h, 0FE56h, 0FE55h, 0FE54h, 0FE53h, 0FE52h
             dw 0FE51h, 0FE50h, 0FE4Fh, 0FE4Eh, 0FE4Dh, 0FE4Ch, 0FE4Bh, 0FE4Ah
             dw 0FE4Ah, 0FE49h, 0FE48h, 0FE47h, 0FE46h, 0FE45h, 0FE44h, 0FE43h
             dw 0FE42h, 0FE41h, 0FE40h, 0FE3Fh, 0FE3Eh, 0FE3Dh, 0FE3Ch, 0FE3Bh
             dw 0FE3Bh, 0FE3Ah, 0FE39h, 0FE38h, 0FE37h, 0FE36h, 0FE35h, 0FE34h
             dw 0FE33h, 0FE32h, 0FE31h, 0FE30h, 0FE2Fh, 0FE2Eh, 0FE2Dh, 0FE2Ch
             dw 0FE2Ch, 0FE2Bh, 0FE2Ah, 0FE29h, 0FE28h, 0FE27h, 0FE26h, 0FE25h
             dw 0FE24h, 0FE23h, 0FE22h, 0FE21h, 0FE20h, 0FE1Fh, 0FE1Fh, 0FE1Eh
             dw 0FE1Dh, 0FE1Ch, 0FE1Bh, 0FE1Ah, 0FE19h, 0FE18h, 0FE17h, 0FE16h
             dw 0FE15h, 0FE14h, 0FE13h, 0FE12h, 0FE12h, 0FE11h, 0FE10h, 0FE0Fh
             dw 0FE0Eh, 0FE0Dh, 0FE0Ch, 0FE0Bh, 0FE0Ah, 0FE09h, 0FE08h, 0FE07h
             dw 0FE06h, 0FE06h, 0FE05h, 0FE04h, 0FE03h, 0FE02h, 0FE01h, 0FE00h
             dw 0FDFFh, 0FDFEh, 0FDFDh, 0FDFCh, 0FDFBh, 0FDFBh, 0FDFAh, 0FDF9h
             dw 0FDF8h, 0FDF7h, 0FDF6h, 0FDF5h, 0FDF4h, 0FDF3h, 0FDF2h, 0FDF1h
             dw 0FDF0h, 0FDF0h, 0FDEFh, 0FDEEh, 0FDEDh, 0FDECh, 0FDEBh, 0FDEAh
             dw 0FDE9h, 0FDE8h, 0FDE7h, 0FDE6h, 0FDE6h, 0FDE5h, 0FDE4h, 0FDE3h
             dw 0FDE2h, 0FDE1h, 0FDE0h, 0FDDFh, 0FDDEh, 0FDDDh, 0FDDCh, 0FDDCh
             dw 0FDDBh, 0FDDAh, 0FDD9h, 0FDD8h, 0FDD7h, 0FDD6h, 0FDD5h, 0FDD4h
             dw 0FDD3h, 0FDD2h, 0FDD2h, 0FDD1h, 0FDD0h, 0FDCFh, 0FDCEh, 0FDCDh
             dw 0FDCCh, 0FDCBh, 0FDCAh, 0FDC9h, 0FDC9h, 0FDC8h, 0FDC7h, 0FDC6h
             dw 0FDC5h, 0FDC4h, 0FDC3h, 0FDC2h, 0FDC1h, 0FDC0h, 0FDC0h, 0FDBFh
             dw 0FDBEh, 0FDBDh, 0FDBCh, 0FDBBh, 0FDBAh, 0FDB9h, 0FDB8h, 0FDB8h
             dw 0FDB7h, 0FDB6h, 0FDB5h, 0FDB4h, 0FDB3h, 0FDB2h, 0FDB1h, 0FDB0h
             dw 0FDB0h, 0FDAFh, 0FDAEh, 0FDADh, 0FDACh, 0FDABh, 0FDAAh, 0FDA9h
             dw 0FDA8h, 0FDA8h, 0FDA7h, 0FDA6h, 0FDA5h, 0FDA4h, 0FDA3h, 0FDA2h
             dw 0FDA1h, 0FDA0h, 0FDA0h, 0FD9Fh, 0FD9Eh, 0FD9Dh, 0FD9Ch, 0FD9Bh
             dw 0FD9Ah, 0FD99h, 0FD99h, 0FD98h, 0FD97h, 0FD96h, 0FD95h, 0FD94h
             dw 0FD93h, 0FD92h, 0FD91h, 0FD91h, 0FD90h, 0FD8Fh, 0FD8Eh, 0FD8Dh
             dw 0FD8Ch, 0FD8Bh, 0FD8Ah, 0FD8Ah, 0FD89h, 0FD88h, 0FD87h, 0FD86h
             dw 0FD85h, 0FD84h, 0FD83h, 0FD83h, 0FD82h, 0FD81h, 0FD80h, 0FD7Fh
             dw 0FD7Eh, 0FD7Dh, 0FD7Dh, 0FD7Ch, 0FD7Bh, 0FD7Ah, 0FD79h, 0FD78h
             dw 0FD77h, 0FD76h, 0FD76h, 0FD75h, 0FD74h, 0FD73h, 0FD72h, 0FD71h
             dw 0FD70h, 0FD70h, 0FD6Fh, 0FD6Eh, 0FD6Dh, 0FD6Ch, 0FD6Bh, 0FD6Ah
             dw 0FD69h, 0FD69h, 0FD68h, 0FD67h, 0FD66h, 0FD65h, 0FD64h, 0FD63h
             dw 0FD63h, 0FD62h, 0FD61h, 0FD60h, 0FD5Fh, 0FD5Eh, 0FD5Dh, 0FD5Dh
             dw 0FD5Ch, 0FD5Bh, 0FD5Ah, 0FD59h, 0FD58h, 0FD58h, 0FD57h, 0FD56h
             dw 0FD55h, 0FD54h, 0FD53h, 0FD52h, 0FD52h, 0FD51h, 0FD50h, 0FD4Fh
             dw 0FD4Eh, 0FD4Dh, 0FD4Ch, 0FD4Ch, 0FD4Bh, 0FD4Ah, 0FD49h, 0FD48h
             dw 0FD47h, 0FD47h, 0FD46h, 0FD45h, 0FD44h, 0FD43h, 0FD42h, 0FD41h
             dw 0FD41h, 0FD40h, 0FD3Fh, 0FD3Eh, 0FD3Dh, 0FD3Ch, 0FD3Ch, 0FD3Bh
             dw 0FD3Ah, 0FD39h, 0FD38h, 0FD37h, 0FD37h, 0FD36h, 0FD35h, 0FD34h
             dw 0FD33h, 0FD32h, 0FD32h, 0FD31h, 0FD30h, 0FD2Fh, 0FD2Eh, 0FD2Dh
             dw 0FD2Dh, 0FD2Ch, 0FD2Bh, 0FD2Ah, 0FD29h, 0FD28h, 0FD28h, 0FD27h
             dw 0FD26h, 0FD25h, 0FD24h, 0FD23h, 0FD23h, 0FD22h, 0FD21h, 0FD20h
             dw 0FD1Fh, 0FD1Fh, 0FD1Eh, 0FD1Dh, 0FD1Ch, 0FD1Bh, 0FD1Ah, 0FD1Ah
             dw 0FD19h, 0FD18h, 0FD17h, 0FD16h, 0FD15h, 0FD15h, 0FD14h, 0FD13h
             dw 0FD12h, 0FD11h, 0FD11h, 0FD10h, 0FD0Fh, 0FD0Eh, 0FD0Dh, 0FD0Dh
             dw 0FD0Ch, 0FD0Bh, 0FD0Ah, 0FD09h, 0FD08h, 0FD08h, 0FD07h, 0FD06h
             dw 0FD05h, 0FD04h, 0FD04h, 0FD03h, 0FD02h, 0FD01h, 0FD00h, 0FD00h
             dw 0FCFFh, 0FCFEh, 0FCFDh, 0FCFCh, 0FCFCh, 0FCFBh, 0FCFAh, 0FCF9h
             dw 0FCF8h, 0FCF8h, 0FCF7h, 0FCF6h, 0FCF5h, 0FCF4h, 0FCF3h, 0FCF3h
             dw 0FCF2h, 0FCF1h, 0FCF0h, 0FCF0h, 0FCEFh, 0FCEEh, 0FCEDh, 0FCECh
             dw 0FCECh, 0FCEBh, 0FCEAh, 0FCE9h, 0FCE8h, 0FCE8h, 0FCE7h, 0FCE6h
             dw 0FCE5h, 0FCE4h, 0FCE4h, 0FCE3h, 0FCE2h, 0FCE1h, 0FCE0h, 0FCE0h
             dw 0FCDFh, 0FCDEh, 0FCDDh, 0FCDCh, 0FCDCh, 0FCDBh, 0FCDAh, 0FCD9h
             dw 0FCD9h, 0FCD8h, 0FCD7h, 0FCD6h, 0FCD5h, 0FCD5h, 0FCD4h, 0FCD3h
             dw 0FCD2h, 0FCD2h, 0FCD1h, 0FCD0h, 0FCCFh, 0FCCEh, 0FCCEh, 0FCCDh
             dw 0FCCCh, 0FCCBh, 0FCCBh, 0FCCAh, 0FCC9h, 0FCC8h, 0FCC7h, 0FCC7h
             dw 0FCC6h, 0FCC5h, 0FCC4h, 0FCC4h, 0FCC3h, 0FCC2h, 0FCC1h, 0FCC0h
             dw 0FCC0h, 0FCBFh, 0FCBEh, 0FCBDh, 0FCBDh, 0FCBCh, 0FCBBh, 0FCBAh
             dw 0FCBAh, 0FCB9h, 0FCB8h, 0FCB7h, 0FCB7h, 0FCB6h, 0FCB5h, 0FCB4h
             dw 0FCB3h, 0FCB3h, 0FCB2h, 0FCB1h, 0FCB0h, 0FCB0h, 0FCAFh, 0FCAEh
             dw 0FCADh, 0FCADh, 0FCACh, 0FCABh, 0FCAAh, 0FCAAh, 0FCA9h, 0FCA8h
             dw 0FCA7h, 0FCA7h, 0FCA6h, 0FCA5h, 0FCA4h, 0FCA4h, 0FCA3h, 0FCA2h
             dw 0FCA1h, 0FCA1h, 0FCA0h, 0FC9Fh, 0FC9Eh, 0FC9Eh, 0FC9Dh, 0FC9Ch
             dw 0FC9Bh, 0FC9Bh, 0FC9Ah, 0FC99h, 0FC98h, 0FC98h, 0FC97h, 0FC96h
             dw 0FC95h, 0FC95h, 0FC94h, 0FC93h, 0FC93h, 0FC92h, 0FC91h, 0FC90h
             dw 0FC90h, 0FC8Fh, 0FC8Eh, 0FC8Dh, 0FC8Dh, 0FC8Ch, 0FC8Bh, 0FC8Ah
             dw 0FC8Ah, 0FC89h, 0FC88h, 0FC87h, 0FC87h, 0FC86h, 0FC85h, 0FC85h
             dw 0FC84h, 0FC83h, 0FC82h, 0FC82h, 0FC81h, 0FC80h, 0FC7Fh, 0FC7Fh
             dw 0FC7Eh, 0FC7Dh, 0FC7Dh, 0FC7Ch, 0FC7Bh, 0FC7Ah, 0FC7Ah, 0FC79h
             dw 0FC78h, 0FC78h, 0FC77h, 0FC76h, 0FC75h, 0FC75h, 0FC74h, 0FC73h
             dw 0FC73h, 0FC72h, 0FC71h, 0FC70h, 0FC70h, 0FC6Fh, 0FC6Eh, 0FC6Eh
             dw 0FC6Dh, 0FC6Ch, 0FC6Bh, 0FC6Bh, 0FC6Ah, 0FC69h, 0FC69h, 0FC68h
             dw 0FC67h, 0FC66h, 0FC66h, 0FC65h, 0FC64h, 0FC64h, 0FC63h, 0FC62h
             dw 0FC62h, 0FC61h, 0FC60h, 0FC5Fh, 0FC5Fh, 0FC5Eh, 0FC5Dh, 0FC5Dh
             dw 0FC5Ch, 0FC5Bh, 0FC5Bh, 0FC5Ah, 0FC59h, 0FC58h, 0FC58h, 0FC57h
             dw 0FC56h, 0FC56h, 0FC55h, 0FC54h, 0FC54h, 0FC53h, 0FC52h, 0FC51h
             dw 0FC51h, 0FC50h, 0FC4Fh, 0FC4Fh, 0FC4Eh, 0FC4Dh, 0FC4Dh, 0FC4Ch
             dw 0FC4Bh, 0FC4Bh, 0FC4Ah, 0FC49h, 0FC49h, 0FC48h, 0FC47h, 0FC47h
             dw 0FC46h, 0FC45h, 0FC44h, 0FC44h, 0FC43h, 0FC42h, 0FC42h, 0FC41h
             dw 0FC40h, 0FC40h, 0FC3Fh, 0FC3Eh, 0FC3Eh, 0FC3Dh, 0FC3Ch, 0FC3Ch
             dw 0FC3Bh, 0FC3Ah, 0FC3Ah, 0FC39h, 0FC38h, 0FC38h, 0FC37h, 0FC36h
             dw 0FC36h, 0FC35h, 0FC34h, 0FC34h, 0FC33h, 0FC32h, 0FC32h, 0FC31h
             dw 0FC30h, 0FC30h, 0FC2Fh, 0FC2Eh, 0FC2Eh, 0FC2Dh, 0FC2Ch, 0FC2Ch
             dw 0FC2Bh, 0FC2Ah, 0FC2Ah, 0FC29h, 0FC28h, 0FC28h, 0FC27h, 0FC27h
             dw 0FC26h, 0FC25h, 0FC25h, 0FC24h, 0FC23h, 0FC23h, 0FC22h, 0FC21h
             dw 0FC21h, 0FC20h, 0FC1Fh, 0FC1Fh, 0FC1Eh, 0FC1Dh, 0FC1Dh, 0FC1Ch
             dw 0FC1Bh, 0FC1Bh, 0FC1Ah, 0FC1Ah, 0FC19h, 0FC18h, 0FC18h, 0FC17h
             dw 0FC16h, 0FC16h, 0FC15h, 0FC14h, 0FC14h, 0FC13h, 0FC13h, 0FC12h
             dw 0FC11h, 0FC11h, 0FC10h, 0FC0Fh, 0FC0Fh, 0FC0Eh, 0FC0Dh, 0FC0Dh
             dw 0FC0Ch, 0FC0Ch, 0FC0Bh, 0FC0Ah, 0FC0Ah, 0FC09h, 0FC08h, 0FC08h
             dw 0FC07h, 0FC07h, 0FC06h, 0FC05h, 0FC05h, 0FC04h, 0FC03h, 0FC03h
             dw 0FC02h, 0FC02h, 0FC01h, 0FC00h, 0FC00h, 0FBFFh, 0FBFFh, 0FBFEh
             dw 0FBFDh, 0FBFDh, 0FBFCh, 0FBFBh, 0FBFBh, 0FBFAh, 0FBFAh, 0FBF9h
             dw 0FBF8h, 0FBF8h, 0FBF7h, 0FBF7h, 0FBF6h, 0FBF5h, 0FBF5h, 0FBF4h
             dw 0FBF4h, 0FBF3h, 0FBF2h, 0FBF2h, 0FBF1h, 0FBF1h, 0FBF0h, 0FBEFh
             dw 0FBEFh, 0FBEEh, 0FBEEh, 0FBEDh, 0FBECh, 0FBECh, 0FBEBh, 0FBEBh
             dw 0FBEAh, 0FBE9h, 0FBE9h, 0FBE8h, 0FBE8h, 0FBE7h, 0FBE6h, 0FBE6h
             dw 0FBE5h, 0FBE5h, 0FBE4h, 0FBE3h, 0FBE3h, 0FBE2h, 0FBE2h, 0FBE1h
             dw 0FBE0h, 0FBE0h, 0FBDFh, 0FBDFh, 0FBDEh, 0FBDEh, 0FBDDh, 0FBDCh
             dw 0FBDCh, 0FBDBh, 0FBDBh, 0FBDAh, 0FBD9h, 0FBD9h, 0FBD8h, 0FBD8h
             dw 0FBD7h, 0FBD7h, 0FBD6h, 0FBD5h, 0FBD5h, 0FBD4h, 0FBD4h, 0FBD3h
             dw 0FBD3h, 0FBD2h, 0FBD1h, 0FBD1h, 0FBD0h, 0FBD0h, 0FBCFh, 0FBCFh
             dw 0FBCEh, 0FBCDh, 0FBCDh, 0FBCCh, 0FBCCh, 0FBCBh, 0FBCBh, 0FBCAh
             dw 0FBCAh, 0FBC9h, 0FBC8h, 0FBC8h, 0FBC7h, 0FBC7h, 0FBC6h, 0FBC6h
             dw 0FBC5h, 0FBC5h, 0FBC4h, 0FBC3h, 0FBC3h, 0FBC2h, 0FBC2h, 0FBC1h
             dw 0FBC1h, 0FBC0h, 0FBC0h, 0FBBFh, 0FBBEh, 0FBBEh, 0FBBDh, 0FBBDh
             dw 0FBBCh, 0FBBCh, 0FBBBh, 0FBBBh, 0FBBAh, 0FBBAh, 0FBB9h, 0FBB8h
             dw 0FBB8h, 0FBB7h, 0FBB7h, 0FBB6h, 0FBB6h, 0FBB5h, 0FBB5h, 0FBB4h
             dw 0FBB4h, 0FBB3h, 0FBB3h, 0FBB2h, 0FBB2h, 0FBB1h, 0FBB0h, 0FBB0h
             dw 0FBAFh, 0FBAFh, 0FBAEh, 0FBAEh, 0FBADh, 0FBADh, 0FBACh, 0FBACh
             dw 0FBABh, 0FBABh, 0FBAAh, 0FBAAh, 0FBA9h, 0FBA9h, 0FBA8h, 0FBA8h
             dw 0FBA7h, 0FBA6h, 0FBA6h, 0FBA5h, 0FBA5h, 0FBA4h, 0FBA4h, 0FBA3h
             dw 0FBA3h, 0FBA2h, 0FBA2h, 0FBA1h, 0FBA1h, 0FBA0h, 0FBA0h, 0FB9Fh
             dw 0FB9Fh, 0FB9Eh, 0FB9Eh, 0FB9Dh, 0FB9Dh, 0FB9Ch, 0FB9Ch, 0FB9Bh
             dw 0FB9Bh, 0FB9Ah, 0FB9Ah, 0FB99h, 0FB99h, 0FB98h, 0FB98h, 0FB97h
             dw 0FB97h, 0FB96h, 0FB96h, 0FB95h, 0FB95h, 0FB94h, 0FB94h, 0FB93h
             dw 0FB93h, 0FB92h, 0FB92h, 0FB91h, 0FB91h, 0FB90h, 0FB90h, 0FB8Fh
             dw 0FB8Fh, 0FB8Eh, 0FB8Eh, 0FB8Dh, 0FB8Dh, 0FB8Ch, 0FB8Ch, 0FB8Bh
             dw 0FB8Bh, 0FB8Ah, 0FB8Ah, 0FB8Ah, 0FB89h, 0FB89h, 0FB88h, 0FB88h
             dw 0FB87h, 0FB87h, 0FB86h, 0FB86h, 0FB85h, 0FB85h, 0FB84h, 0FB84h
             dw 0FB83h, 0FB83h, 0FB82h, 0FB82h, 0FB81h, 0FB81h, 0FB81h, 0FB80h
             dw 0FB80h, 0FB7Fh, 0FB7Fh, 0FB7Eh, 0FB7Eh, 0FB7Dh, 0FB7Dh, 0FB7Ch
             dw 0FB7Ch, 0FB7Bh, 0FB7Bh, 0FB7Bh, 0FB7Ah, 0FB7Ah, 0FB79h, 0FB79h
             dw 0FB78h, 0FB78h, 0FB77h, 0FB77h, 0FB76h, 0FB76h, 0FB76h, 0FB75h
             dw 0FB75h, 0FB74h, 0FB74h, 0FB73h, 0FB73h, 0FB72h, 0FB72h, 0FB72h
             dw 0FB71h, 0FB71h, 0FB70h, 0FB70h, 0FB6Fh, 0FB6Fh, 0FB6Eh, 0FB6Eh
             dw 0FB6Eh, 0FB6Dh, 0FB6Dh, 0FB6Ch, 0FB6Ch, 0FB6Bh, 0FB6Bh, 0FB6Ah
             dw 0FB6Ah, 0FB6Ah, 0FB69h, 0FB69h, 0FB68h, 0FB68h, 0FB67h, 0FB67h
             dw 0FB67h, 0FB66h, 0FB66h, 0FB65h, 0FB65h, 0FB64h, 0FB64h, 0FB64h
             dw 0FB63h, 0FB63h, 0FB62h, 0FB62h, 0FB62h, 0FB61h, 0FB61h, 0FB60h
             dw 0FB60h, 0FB5Fh, 0FB5Fh, 0FB5Fh, 0FB5Eh, 0FB5Eh, 0FB5Dh, 0FB5Dh
             dw 0FB5Dh, 0FB5Ch, 0FB5Ch, 0FB5Bh, 0FB5Bh, 0FB5Bh, 0FB5Ah, 0FB5Ah
             dw 0FB59h, 0FB59h, 0FB58h, 0FB58h, 0FB58h, 0FB57h, 0FB57h, 0FB56h
             dw 0FB56h, 0FB56h, 0FB55h, 0FB55h, 0FB54h, 0FB54h, 0FB54h, 0FB53h
             dw 0FB53h, 0FB53h, 0FB52h, 0FB52h, 0FB51h, 0FB51h, 0FB51h, 0FB50h
             dw 0FB50h, 0FB4Fh, 0FB4Fh, 0FB4Fh, 0FB4Eh, 0FB4Eh, 0FB4Dh, 0FB4Dh
             dw 0FB4Dh, 0FB4Ch, 0FB4Ch, 0FB4Ch, 0FB4Bh, 0FB4Bh, 0FB4Ah, 0FB4Ah
             dw 0FB4Ah, 0FB49h, 0FB49h, 0FB49h, 0FB48h, 0FB48h, 0FB47h, 0FB47h
             dw 0FB47h, 0FB46h, 0FB46h, 0FB46h, 0FB45h, 0FB45h, 0FB44h, 0FB44h
             dw 0FB44h, 0FB43h, 0FB43h, 0FB43h, 0FB42h, 0FB42h, 0FB42h, 0FB41h
             dw 0FB41h, 0FB40h, 0FB40h, 0FB40h, 0FB3Fh, 0FB3Fh, 0FB3Fh, 0FB3Eh
             dw 0FB3Eh, 0FB3Eh, 0FB3Dh, 0FB3Dh, 0FB3Dh, 0FB3Ch, 0FB3Ch, 0FB3Bh
             dw 0FB3Bh, 0FB3Bh, 0FB3Ah, 0FB3Ah, 0FB3Ah, 0FB39h, 0FB39h, 0FB39h
             dw 0FB38h, 0FB38h, 0FB38h, 0FB37h, 0FB37h, 0FB37h, 0FB36h, 0FB36h
             dw 0FB36h, 0FB35h, 0FB35h, 0FB35h, 0FB34h, 0FB34h, 0FB34h, 0FB33h
             dw 0FB33h, 0FB33h, 0FB32h, 0FB32h, 0FB32h, 0FB31h, 0FB31h, 0FB31h
             dw 0FB30h, 0FB30h, 0FB30h, 0FB2Fh, 0FB2Fh, 0FB2Fh, 0FB2Eh, 0FB2Eh
             dw 0FB2Eh, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Ch, 0FB2Ch, 0FB2Ch
             dw 0FB2Bh, 0FB2Bh, 0FB2Bh, 0FB2Ah, 0FB2Ah, 0FB2Ah, 0FB29h, 0FB29h
             dw 0FB29h, 0FB28h, 0FB28h, 0FB28h, 0FB28h, 0FB27h, 0FB27h, 0FB27h
             dw 0FB26h, 0FB26h, 0FB26h, 0FB25h, 0FB25h, 0FB25h, 0FB25h, 0FB24h
             dw 0FB24h, 0FB24h, 0FB23h, 0FB23h, 0FB23h, 0FB22h, 0FB22h, 0FB22h
             dw 0FB22h, 0FB21h, 0FB21h, 0FB21h, 0FB20h, 0FB20h, 0FB20h, 0FB20h
             dw 0FB1Fh, 0FB1Fh, 0FB1Fh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Dh
             dw 0FB1Dh, 0FB1Dh, 0FB1Dh, 0FB1Ch, 0FB1Ch, 0FB1Ch, 0FB1Bh, 0FB1Bh
             dw 0FB1Bh, 0FB1Bh, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB19h, 0FB19h
             dw 0FB19h, 0FB18h, 0FB18h, 0FB18h, 0FB18h, 0FB17h, 0FB17h, 0FB17h
             dw 0FB17h, 0FB16h, 0FB16h, 0FB16h, 0FB16h, 0FB15h, 0FB15h, 0FB15h
             dw 0FB15h, 0FB14h, 0FB14h, 0FB14h, 0FB14h, 0FB13h, 0FB13h, 0FB13h
             dw 0FB13h, 0FB12h, 0FB12h, 0FB12h, 0FB12h, 0FB11h, 0FB11h, 0FB11h
             dw 0FB11h, 0FB10h, 0FB10h, 0FB10h, 0FB10h, 0FB0Fh, 0FB0Fh, 0FB0Fh
             dw 0FB0Fh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Dh, 0FB0Dh, 0FB0Dh
             dw 0FB0Dh, 0FB0Dh, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Bh, 0FB0Bh
             dw 0FB0Bh, 0FB0Bh, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB09h
             dw 0FB09h, 0FB09h, 0FB09h, 0FB09h, 0FB08h, 0FB08h, 0FB08h, 0FB08h
             dw 0FB07h, 0FB07h, 0FB07h, 0FB07h, 0FB07h, 0FB06h, 0FB06h, 0FB06h
             dw 0FB06h, 0FB06h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB04h
             dw 0FB04h, 0FB04h, 0FB04h, 0FB04h, 0FB03h, 0FB03h, 0FB03h, 0FB03h
             dw 0FB03h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB01h, 0FB01h
             dw 0FB01h, 0FB01h, 0FB01h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h
             dw 0FB00h, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFEh, 0FAFEh
             dw 0FAFEh, 0FAFEh, 0FAFEh, 0FAFEh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh
             dw 0FAFDh, 0FAFDh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh
             dw 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFAh, 0FAFAh
             dw 0FAFAh, 0FAFAh, 0FAFAh, 0FAFAh, 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h
             dw 0FAF9h, 0FAF9h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h
             dw 0FAF8h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h
             dw 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF5h
             dw 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF4h
             dw 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF3h
             dw 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF2h
             dw 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h
             dw 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h
             dw 0FAF1h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h
             dw 0FAF0h, 0FAF0h, 0FAF0h, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh
             dw 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh
             dw 0FAEAh, 0FAEAh, 0FAEAh, 0FAEAh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh, 0FAEBh
             dw 0FAEBh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh, 0FAECh
             dw 0FAECh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh
             dw 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEDh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh, 0FAEEh
             dw 0FAEEh, 0FAEEh, 0FAEEh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh
             dw 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAEFh, 0FAF0h, 0FAF0h
             dw 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h, 0FAF0h
             dw 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h, 0FAF1h
             dw 0FAF1h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h, 0FAF2h
             dw 0FAF2h, 0FAF2h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h, 0FAF3h
             dw 0FAF3h, 0FAF3h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h, 0FAF4h
             dw 0FAF4h, 0FAF4h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h, 0FAF5h
             dw 0FAF5h, 0FAF5h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h, 0FAF6h
             dw 0FAF6h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h, 0FAF7h
             dw 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF8h, 0FAF9h
             dw 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h, 0FAF9h, 0FAFAh, 0FAFAh, 0FAFAh
             dw 0FAFAh, 0FAFAh, 0FAFAh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh, 0FAFBh
             dw 0FAFBh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFCh, 0FAFDh
             dw 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFDh, 0FAFEh, 0FAFEh, 0FAFEh
             dw 0FAFEh, 0FAFEh, 0FAFEh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh, 0FAFFh
             dw 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB00h, 0FB01h, 0FB01h
             dw 0FB01h, 0FB01h, 0FB01h, 0FB02h, 0FB02h, 0FB02h, 0FB02h, 0FB02h
             dw 0FB03h, 0FB03h, 0FB03h, 0FB03h, 0FB03h, 0FB04h, 0FB04h, 0FB04h
             dw 0FB04h, 0FB04h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB05h, 0FB06h
             dw 0FB06h, 0FB06h, 0FB06h, 0FB06h, 0FB07h, 0FB07h, 0FB07h, 0FB07h
             dw 0FB07h, 0FB08h, 0FB08h, 0FB08h, 0FB08h, 0FB09h, 0FB09h, 0FB09h
             dw 0FB09h, 0FB09h, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Ah, 0FB0Bh
             dw 0FB0Bh, 0FB0Bh, 0FB0Bh, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Ch, 0FB0Dh
             dw 0FB0Dh, 0FB0Dh, 0FB0Dh, 0FB0Dh, 0FB0Eh, 0FB0Eh, 0FB0Eh, 0FB0Eh
             dw 0FB0Fh, 0FB0Fh, 0FB0Fh, 0FB0Fh, 0FB10h, 0FB10h, 0FB10h, 0FB10h
             dw 0FB11h, 0FB11h, 0FB11h, 0FB11h, 0FB12h, 0FB12h, 0FB12h, 0FB12h
             dw 0FB13h, 0FB13h, 0FB13h, 0FB13h, 0FB14h, 0FB14h, 0FB14h, 0FB14h
             dw 0FB15h, 0FB15h, 0FB15h, 0FB15h, 0FB16h, 0FB16h, 0FB16h, 0FB16h
             dw 0FB17h, 0FB17h, 0FB17h, 0FB17h, 0FB18h, 0FB18h, 0FB18h, 0FB18h
             dw 0FB19h, 0FB19h, 0FB19h, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Ah, 0FB1Bh
             dw 0FB1Bh, 0FB1Bh, 0FB1Bh, 0FB1Ch, 0FB1Ch, 0FB1Ch, 0FB1Dh, 0FB1Dh
             dw 0FB1Dh, 0FB1Dh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Eh, 0FB1Fh, 0FB1Fh
             dw 0FB1Fh, 0FB20h, 0FB20h, 0FB20h, 0FB20h, 0FB21h, 0FB21h, 0FB21h
             dw 0FB22h, 0FB22h, 0FB22h, 0FB22h, 0FB23h, 0FB23h, 0FB23h, 0FB24h
             dw 0FB24h, 0FB24h, 0FB25h, 0FB25h, 0FB25h, 0FB25h, 0FB26h, 0FB26h
             dw 0FB26h, 0FB27h, 0FB27h, 0FB27h, 0FB28h, 0FB28h, 0FB28h, 0FB28h
             dw 0FB29h, 0FB29h, 0FB29h, 0FB2Ah, 0FB2Ah, 0FB2Ah, 0FB2Bh, 0FB2Bh
             dw 0FB2Bh, 0FB2Ch, 0FB2Ch, 0FB2Ch, 0FB2Dh, 0FB2Dh, 0FB2Dh, 0FB2Dh
             dw 0FB2Eh, 0FB2Eh, 0FB2Eh, 0FB2Fh, 0FB2Fh, 0FB2Fh, 0FB30h, 0FB30h
             dw 0FB30h, 0FB31h, 0FB31h, 0FB31h, 0FB32h, 0FB32h, 0FB32h, 0FB33h
             dw 0FB33h, 0FB33h, 0FB34h, 0FB34h, 0FB34h, 0FB35h, 0FB35h, 0FB35h
             dw 0FB36h, 0FB36h, 0FB36h, 0FB37h, 0FB37h, 0FB37h, 0FB38h, 0FB38h
             dw 0FB38h, 0FB39h, 0FB39h, 0FB39h, 0FB3Ah, 0FB3Ah, 0FB3Ah, 0FB3Bh
             dw 0FB3Bh, 0FB3Bh, 0FB3Ch, 0FB3Ch, 0FB3Dh, 0FB3Dh, 0FB3Dh, 0FB3Eh
             dw 0FB3Eh, 0FB3Eh, 0FB3Fh, 0FB3Fh, 0FB3Fh, 0FB40h, 0FB40h, 0FB40h
             dw 0FB41h, 0FB41h, 0FB42h, 0FB42h, 0FB42h, 0FB43h, 0FB43h, 0FB43h
             dw 0FB44h, 0FB44h, 0FB44h, 0FB45h, 0FB45h, 0FB46h, 0FB46h, 0FB46h
             dw 0FB47h, 0FB47h, 0FB47h, 0FB48h, 0FB48h, 0FB49h, 0FB49h, 0FB49h
             dw 0FB4Ah, 0FB4Ah, 0FB4Ah, 0FB4Bh, 0FB4Bh, 0FB4Ch, 0FB4Ch, 0FB4Ch
             dw 0FB4Dh, 0FB4Dh, 0FB4Dh, 0FB4Eh, 0FB4Eh, 0FB4Fh, 0FB4Fh, 0FB4Fh
             dw 0FB50h, 0FB50h, 0FB51h, 0FB51h, 0FB51h, 0FB52h, 0FB52h, 0FB53h
             dw 0FB53h, 0FB53h, 0FB54h, 0FB54h, 0FB54h, 0FB55h, 0FB55h, 0FB56h
             dw 0FB56h, 0FB56h, 0FB57h, 0FB57h, 0FB58h, 0FB58h, 0FB58h, 0FB59h
             dw 0FB59h, 0FB5Ah, 0FB5Ah, 0FB5Bh, 0FB5Bh, 0FB5Bh, 0FB5Ch, 0FB5Ch
             dw 0FB5Dh, 0FB5Dh, 0FB5Dh, 0FB5Eh, 0FB5Eh, 0FB5Fh, 0FB5Fh, 0FB5Fh
             dw 0FB60h, 0FB60h, 0FB61h, 0FB61h, 0FB62h, 0FB62h, 0FB62h, 0FB63h
             dw 0FB63h, 0FB64h, 0FB64h, 0FB64h, 0FB65h, 0FB65h, 0FB66h, 0FB66h
             dw 0FB67h, 0FB67h, 0FB67h, 0FB68h, 0FB68h, 0FB69h, 0FB69h, 0FB6Ah
             dw 0FB6Ah, 0FB6Ah, 0FB6Bh, 0FB6Bh, 0FB6Ch, 0FB6Ch, 0FB6Dh, 0FB6Dh
             dw 0FB6Eh, 0FB6Eh, 0FB6Eh, 0FB6Fh, 0FB6Fh, 0FB70h, 0FB70h, 0FB71h
             dw 0FB71h, 0FB72h, 0FB72h, 0FB72h, 0FB73h, 0FB73h, 0FB74h, 0FB74h
             dw 0FB75h, 0FB75h, 0FB76h, 0FB76h, 0FB76h, 0FB77h, 0FB77h, 0FB78h
             dw 0FB78h, 0FB79h, 0FB79h, 0FB7Ah, 0FB7Ah, 0FB7Bh, 0FB7Bh, 0FB7Bh
             dw 0FB7Ch, 0FB7Ch, 0FB7Dh, 0FB7Dh, 0FB7Eh, 0FB7Eh, 0FB7Fh, 0FB7Fh
             dw 0FB80h, 0FB80h, 0FB81h, 0FB81h, 0FB81h, 0FB82h, 0FB82h, 0FB83h
             dw 0FB83h, 0FB84h, 0FB84h, 0FB85h, 0FB85h, 0FB86h, 0FB86h, 0FB87h
             dw 0FB87h, 0FB88h, 0FB88h, 0FB89h, 0FB89h, 0FB8Ah, 0FB8Ah, 0FB8Ah
             dw 0FB8Bh, 0FB8Bh, 0FB8Ch, 0FB8Ch, 0FB8Dh, 0FB8Dh, 0FB8Eh, 0FB8Eh
             dw 0FB8Fh, 0FB8Fh, 0FB90h, 0FB90h, 0FB91h, 0FB91h, 0FB92h, 0FB92h
             dw 0FB93h, 0FB93h, 0FB94h, 0FB94h, 0FB95h, 0FB95h, 0FB96h, 0FB96h
             dw 0FB97h, 0FB97h, 0FB98h, 0FB98h, 0FB99h, 0FB99h, 0FB9Ah, 0FB9Ah
             dw 0FB9Bh, 0FB9Bh, 0FB9Ch, 0FB9Ch, 0FB9Dh, 0FB9Dh, 0FB9Eh, 0FB9Eh
             dw 0FB9Fh, 0FB9Fh, 0FBA0h, 0FBA0h, 0FBA1h, 0FBA1h, 0FBA2h, 0FBA2h
             dw 0FBA3h, 0FBA3h, 0FBA4h, 0FBA4h, 0FBA5h, 0FBA5h, 0FBA6h, 0FBA6h
             dw 0FBA7h, 0FBA8h, 0FBA8h, 0FBA9h, 0FBA9h, 0FBAAh, 0FBAAh, 0FBABh
             dw 0FBABh, 0FBACh, 0FBACh, 0FBADh, 0FBADh, 0FBAEh, 0FBAEh, 0FBAFh
             dw 0FBAFh, 0FBB0h, 0FBB0h, 0FBB1h, 0FBB2h, 0FBB2h, 0FBB3h, 0FBB3h
             dw 0FBB4h, 0FBB4h, 0FBB5h, 0FBB5h, 0FBB6h, 0FBB6h, 0FBB7h, 0FBB7h
             dw 0FBB8h, 0FBB8h, 0FBB9h, 0FBBAh, 0FBBAh, 0FBBBh, 0FBBBh, 0FBBCh
             dw 0FBBCh, 0FBBDh, 0FBBDh, 0FBBEh, 0FBBEh, 0FBBFh, 0FBC0h, 0FBC0h
             dw 0FBC1h, 0FBC1h, 0FBC2h, 0FBC2h, 0FBC3h, 0FBC3h, 0FBC4h, 0FBC5h
             dw 0FBC5h, 0FBC6h, 0FBC6h, 0FBC7h, 0FBC7h, 0FBC8h, 0FBC8h, 0FBC9h
             dw 0FBCAh, 0FBCAh, 0FBCBh, 0FBCBh, 0FBCCh, 0FBCCh, 0FBCDh, 0FBCDh
             dw 0FBCEh, 0FBCFh, 0FBCFh, 0FBD0h, 0FBD0h, 0FBD1h, 0FBD1h, 0FBD2h
             dw 0FBD3h, 0FBD3h, 0FBD4h, 0FBD4h, 0FBD5h, 0FBD5h, 0FBD6h, 0FBD7h
             dw 0FBD7h, 0FBD8h, 0FBD8h, 0FBD9h, 0FBD9h, 0FBDAh, 0FBDBh, 0FBDBh
             dw 0FBDCh, 0FBDCh, 0FBDDh, 0FBDEh, 0FBDEh, 0FBDFh, 0FBDFh, 0FBE0h
             dw 0FBE0h, 0FBE1h, 0FBE2h, 0FBE2h, 0FBE3h, 0FBE3h, 0FBE4h, 0FBE5h
             dw 0FBE5h, 0FBE6h, 0FBE6h, 0FBE7h, 0FBE8h, 0FBE8h, 0FBE9h, 0FBE9h
             dw 0FBEAh, 0FBEBh, 0FBEBh, 0FBECh, 0FBECh, 0FBEDh, 0FBEEh, 0FBEEh
             dw 0FBEFh, 0FBEFh, 0FBF0h, 0FBF1h, 0FBF1h, 0FBF2h, 0FBF2h, 0FBF3h
             dw 0FBF4h, 0FBF4h, 0FBF5h, 0FBF5h, 0FBF6h, 0FBF7h, 0FBF7h, 0FBF8h
             dw 0FBF8h, 0FBF9h, 0FBFAh, 0FBFAh, 0FBFBh, 0FBFBh, 0FBFCh, 0FBFDh
             dw 0FBFDh, 0FBFEh, 0FBFFh, 0FBFFh, 0FC00h, 0FC00h, 0FC01h, 0FC02h
             dw 0FC02h, 0FC03h, 0FC03h, 0FC04h, 0FC05h, 0FC05h, 0FC06h, 0FC07h
             dw 0FC07h, 0FC08h, 0FC08h, 0FC09h, 0FC0Ah, 0FC0Ah, 0FC0Bh, 0FC0Ch
             dw 0FC0Ch, 0FC0Dh, 0FC0Dh, 0FC0Eh, 0FC0Fh, 0FC0Fh, 0FC10h, 0FC11h
             dw 0FC11h, 0FC12h, 0FC13h, 0FC13h, 0FC14h, 0FC14h, 0FC15h, 0FC16h
             dw 0FC16h, 0FC17h, 0FC18h, 0FC18h, 0FC19h, 0FC1Ah, 0FC1Ah, 0FC1Bh
             dw 0FC1Bh, 0FC1Ch, 0FC1Dh, 0FC1Dh, 0FC1Eh, 0FC1Fh, 0FC1Fh, 0FC20h
             dw 0FC21h, 0FC21h, 0FC22h, 0FC23h, 0FC23h, 0FC24h, 0FC25h, 0FC25h
             dw 0FC26h, 0FC27h, 0FC27h, 0FC28h, 0FC28h, 0FC29h, 0FC2Ah, 0FC2Ah
             dw 0FC2Bh, 0FC2Ch, 0FC2Ch, 0FC2Dh, 0FC2Eh, 0FC2Eh, 0FC2Fh, 0FC30h
             dw 0FC30h, 0FC31h, 0FC32h, 0FC32h, 0FC33h, 0FC34h, 0FC34h, 0FC35h
             dw 0FC36h, 0FC36h, 0FC37h, 0FC38h, 0FC38h, 0FC39h, 0FC3Ah, 0FC3Ah
             dw 0FC3Bh, 0FC3Ch, 0FC3Ch, 0FC3Dh, 0FC3Eh, 0FC3Eh, 0FC3Fh, 0FC40h
             dw 0FC40h, 0FC41h, 0FC42h, 0FC42h, 0FC43h, 0FC44h, 0FC44h, 0FC45h
             dw 0FC46h, 0FC47h, 0FC47h, 0FC48h, 0FC49h, 0FC49h, 0FC4Ah, 0FC4Bh
             dw 0FC4Bh, 0FC4Ch, 0FC4Dh, 0FC4Dh, 0FC4Eh, 0FC4Fh, 0FC4Fh, 0FC50h
             dw 0FC51h, 0FC51h, 0FC52h, 0FC53h, 0FC54h, 0FC54h, 0FC55h, 0FC56h
             dw 0FC56h, 0FC57h, 0FC58h, 0FC58h, 0FC59h, 0FC5Ah, 0FC5Bh, 0FC5Bh
             dw 0FC5Ch, 0FC5Dh, 0FC5Dh, 0FC5Eh, 0FC5Fh, 0FC5Fh, 0FC60h, 0FC61h
             dw 0FC62h, 0FC62h, 0FC63h, 0FC64h, 0FC64h, 0FC65h, 0FC66h, 0FC66h
             dw 0FC67h, 0FC68h, 0FC69h, 0FC69h, 0FC6Ah, 0FC6Bh, 0FC6Bh, 0FC6Ch
             dw 0FC6Dh, 0FC6Eh, 0FC6Eh, 0FC6Fh, 0FC70h, 0FC70h, 0FC71h, 0FC72h
             dw 0FC73h, 0FC73h, 0FC74h, 0FC75h, 0FC75h, 0FC76h, 0FC77h, 0FC78h
             dw 0FC78h, 0FC79h, 0FC7Ah, 0FC7Ah, 0FC7Bh, 0FC7Ch, 0FC7Dh, 0FC7Dh
             dw 0FC7Eh, 0FC7Fh, 0FC7Fh, 0FC80h, 0FC81h, 0FC82h, 0FC82h, 0FC83h
             dw 0FC84h, 0FC85h, 0FC85h, 0FC86h, 0FC87h, 0FC87h, 0FC88h, 0FC89h
             dw 0FC8Ah, 0FC8Ah, 0FC8Bh, 0FC8Ch, 0FC8Dh, 0FC8Dh, 0FC8Eh, 0FC8Fh
             dw 0FC90h, 0FC90h, 0FC91h, 0FC92h, 0FC93h, 0FC93h, 0FC94h, 0FC95h
             dw 0FC95h, 0FC96h, 0FC97h, 0FC98h, 0FC98h, 0FC99h, 0FC9Ah, 0FC9Bh
             dw 0FC9Bh, 0FC9Ch, 0FC9Dh, 0FC9Eh, 0FC9Eh, 0FC9Fh, 0FCA0h, 0FCA1h
             dw 0FCA1h, 0FCA2h, 0FCA3h, 0FCA4h, 0FCA4h, 0FCA5h, 0FCA6h, 0FCA7h
             dw 0FCA7h, 0FCA8h, 0FCA9h, 0FCAAh, 0FCAAh, 0FCABh, 0FCACh, 0FCADh
             dw 0FCADh, 0FCAEh, 0FCAFh, 0FCB0h, 0FCB0h, 0FCB1h, 0FCB2h, 0FCB3h
             dw 0FCB3h, 0FCB4h, 0FCB5h, 0FCB6h, 0FCB7h, 0FCB7h, 0FCB8h, 0FCB9h
             dw 0FCBAh, 0FCBAh, 0FCBBh, 0FCBCh, 0FCBDh, 0FCBDh, 0FCBEh, 0FCBFh
             dw 0FCC0h, 0FCC0h, 0FCC1h, 0FCC2h, 0FCC3h, 0FCC4h, 0FCC4h, 0FCC5h
             dw 0FCC6h, 0FCC7h, 0FCC7h, 0FCC8h, 0FCC9h, 0FCCAh, 0FCCBh, 0FCCBh
             dw 0FCCCh, 0FCCDh, 0FCCEh, 0FCCEh, 0FCCFh, 0FCD0h, 0FCD1h, 0FCD2h
             dw 0FCD2h, 0FCD3h, 0FCD4h, 0FCD5h, 0FCD5h, 0FCD6h, 0FCD7h, 0FCD8h
             dw 0FCD9h, 0FCD9h, 0FCDAh, 0FCDBh, 0FCDCh, 0FCDCh, 0FCDDh, 0FCDEh
             dw 0FCDFh, 0FCE0h, 0FCE0h, 0FCE1h, 0FCE2h, 0FCE3h, 0FCE4h, 0FCE4h
             dw 0FCE5h, 0FCE6h, 0FCE7h, 0FCE8h, 0FCE8h, 0FCE9h, 0FCEAh, 0FCEBh
             dw 0FCECh, 0FCECh, 0FCEDh, 0FCEEh, 0FCEFh, 0FCF0h, 0FCF0h, 0FCF1h
             dw 0FCF2h, 0FCF3h, 0FCF3h, 0FCF4h, 0FCF5h, 0FCF6h, 0FCF7h, 0FCF8h
             dw 0FCF8h, 0FCF9h, 0FCFAh, 0FCFBh, 0FCFCh, 0FCFCh, 0FCFDh, 0FCFEh
             dw 0FCFFh, 0FD00h, 0FD00h, 0FD01h, 0FD02h, 0FD03h, 0FD04h, 0FD04h
             dw 0FD05h, 0FD06h, 0FD07h, 0FD08h, 0FD08h, 0FD09h, 0FD0Ah, 0FD0Bh
             dw 0FD0Ch, 0FD0Dh, 0FD0Dh, 0FD0Eh, 0FD0Fh, 0FD10h, 0FD11h, 0FD11h
             dw 0FD12h, 0FD13h, 0FD14h, 0FD15h, 0FD15h, 0FD16h, 0FD17h, 0FD18h
             dw 0FD19h, 0FD1Ah, 0FD1Ah, 0FD1Bh, 0FD1Ch, 0FD1Dh, 0FD1Eh, 0FD1Fh
             dw 0FD1Fh, 0FD20h, 0FD21h, 0FD22h, 0FD23h, 0FD23h, 0FD24h, 0FD25h
             dw 0FD26h, 0FD27h, 0FD28h, 0FD28h, 0FD29h, 0FD2Ah, 0FD2Bh, 0FD2Ch
             dw 0FD2Dh, 0FD2Dh, 0FD2Eh, 0FD2Fh, 0FD30h, 0FD31h, 0FD32h, 0FD32h
             dw 0FD33h, 0FD34h, 0FD35h, 0FD36h, 0FD37h, 0FD37h, 0FD38h, 0FD39h
             dw 0FD3Ah, 0FD3Bh, 0FD3Ch, 0FD3Ch, 0FD3Dh, 0FD3Eh, 0FD3Fh, 0FD40h
             dw 0FD41h, 0FD41h, 0FD42h, 0FD43h, 0FD44h, 0FD45h, 0FD46h, 0FD47h
             dw 0FD47h, 0FD48h, 0FD49h, 0FD4Ah, 0FD4Bh, 0FD4Ch, 0FD4Ch, 0FD4Dh
             dw 0FD4Eh, 0FD4Fh, 0FD50h, 0FD51h, 0FD52h, 0FD52h, 0FD53h, 0FD54h
             dw 0FD55h, 0FD56h, 0FD57h, 0FD58h, 0FD58h, 0FD59h, 0FD5Ah, 0FD5Bh
             dw 0FD5Ch, 0FD5Dh, 0FD5Dh, 0FD5Eh, 0FD5Fh, 0FD60h, 0FD61h, 0FD62h
             dw 0FD63h, 0FD63h, 0FD64h, 0FD65h, 0FD66h, 0FD67h, 0FD68h, 0FD69h
             dw 0FD69h, 0FD6Ah, 0FD6Bh, 0FD6Ch, 0FD6Dh, 0FD6Eh, 0FD6Fh, 0FD70h
             dw 0FD70h, 0FD71h, 0FD72h, 0FD73h, 0FD74h, 0FD75h, 0FD76h, 0FD76h
             dw 0FD77h, 0FD78h, 0FD79h, 0FD7Ah, 0FD7Bh, 0FD7Ch, 0FD7Dh, 0FD7Dh
             dw 0FD7Eh, 0FD7Fh, 0FD80h, 0FD81h, 0FD82h, 0FD83h, 0FD83h, 0FD84h
             dw 0FD85h, 0FD86h, 0FD87h, 0FD88h, 0FD89h, 0FD8Ah, 0FD8Ah, 0FD8Bh
             dw 0FD8Ch, 0FD8Dh, 0FD8Eh, 0FD8Fh, 0FD90h, 0FD91h, 0FD91h, 0FD92h
             dw 0FD93h, 0FD94h, 0FD95h, 0FD96h, 0FD97h, 0FD98h, 0FD99h, 0FD99h
             dw 0FD9Ah, 0FD9Bh, 0FD9Ch, 0FD9Dh, 0FD9Eh, 0FD9Fh, 0FDA0h, 0FDA0h
             dw 0FDA1h, 0FDA2h, 0FDA3h, 0FDA4h, 0FDA5h, 0FDA6h, 0FDA7h, 0FDA8h
             dw 0FDA8h, 0FDA9h, 0FDAAh, 0FDABh, 0FDACh, 0FDADh, 0FDAEh, 0FDAFh
             dw 0FDB0h, 0FDB0h, 0FDB1h, 0FDB2h, 0FDB3h, 0FDB4h, 0FDB5h, 0FDB6h
             dw 0FDB7h, 0FDB8h, 0FDB8h, 0FDB9h, 0FDBAh, 0FDBBh, 0FDBCh, 0FDBDh
             dw 0FDBEh, 0FDBFh, 0FDC0h, 0FDC0h, 0FDC1h, 0FDC2h, 0FDC3h, 0FDC4h
             dw 0FDC5h, 0FDC6h, 0FDC7h, 0FDC8h, 0FDC9h, 0FDC9h, 0FDCAh, 0FDCBh
             dw 0FDCCh, 0FDCDh, 0FDCEh, 0FDCFh, 0FDD0h, 0FDD1h, 0FDD2h, 0FDD2h
             dw 0FDD3h, 0FDD4h, 0FDD5h, 0FDD6h, 0FDD7h, 0FDD8h, 0FDD9h, 0FDDAh
             dw 0FDDBh, 0FDDCh, 0FDDCh, 0FDDDh, 0FDDEh, 0FDDFh, 0FDE0h, 0FDE1h
             dw 0FDE2h, 0FDE3h, 0FDE4h, 0FDE5h, 0FDE6h, 0FDE6h, 0FDE7h, 0FDE8h
             dw 0FDE9h, 0FDEAh, 0FDEBh, 0FDECh, 0FDEDh, 0FDEEh, 0FDEFh, 0FDF0h
             dw 0FDF0h, 0FDF1h, 0FDF2h, 0FDF3h, 0FDF4h, 0FDF5h, 0FDF6h, 0FDF7h
             dw 0FDF8h, 0FDF9h, 0FDFAh, 0FDFBh, 0FDFBh, 0FDFCh, 0FDFDh, 0FDFEh
             dw 0FDFFh, 0FE00h, 0FE01h, 0FE02h, 0FE03h, 0FE04h, 0FE05h, 0FE06h
             dw 0FE06h, 0FE07h, 0FE08h, 0FE09h, 0FE0Ah, 0FE0Bh, 0FE0Ch, 0FE0Dh
             dw 0FE0Eh, 0FE0Fh, 0FE10h, 0FE11h, 0FE12h, 0FE12h, 0FE13h, 0FE14h
             dw 0FE15h, 0FE16h, 0FE17h, 0FE18h, 0FE19h, 0FE1Ah, 0FE1Bh, 0FE1Ch
             dw 0FE1Dh, 0FE1Eh, 0FE1Fh, 0FE1Fh, 0FE20h, 0FE21h, 0FE22h, 0FE23h
             dw 0FE24h, 0FE25h, 0FE26h, 0FE27h, 0FE28h, 0FE29h, 0FE2Ah, 0FE2Bh
             dw 0FE2Ch, 0FE2Ch, 0FE2Dh, 0FE2Eh, 0FE2Fh, 0FE30h, 0FE31h, 0FE32h
             dw 0FE33h, 0FE34h, 0FE35h, 0FE36h, 0FE37h, 0FE38h, 0FE39h, 0FE3Ah
             dw 0FE3Bh, 0FE3Bh, 0FE3Ch, 0FE3Dh, 0FE3Eh, 0FE3Fh, 0FE40h, 0FE41h
             dw 0FE42h, 0FE43h, 0FE44h, 0FE45h, 0FE46h, 0FE47h, 0FE48h, 0FE49h
             dw 0FE4Ah, 0FE4Ah, 0FE4Bh, 0FE4Ch, 0FE4Dh, 0FE4Eh, 0FE4Fh, 0FE50h
             dw 0FE51h, 0FE52h, 0FE53h, 0FE54h, 0FE55h, 0FE56h, 0FE57h, 0FE58h
             dw 0FE59h, 0FE5Ah, 0FE5Bh, 0FE5Bh, 0FE5Ch, 0FE5Dh, 0FE5Eh, 0FE5Fh
             dw 0FE60h, 0FE61h, 0FE62h, 0FE63h, 0FE64h, 0FE65h, 0FE66h, 0FE67h
             dw 0FE68h, 0FE69h, 0FE6Ah, 0FE6Bh, 0FE6Ch, 0FE6Dh, 0FE6Dh, 0FE6Eh
             dw 0FE6Fh, 0FE70h, 0FE71h, 0FE72h, 0FE73h, 0FE74h, 0FE75h, 0FE76h
             dw 0FE77h, 0FE78h, 0FE79h, 0FE7Ah, 0FE7Bh, 0FE7Ch, 0FE7Dh, 0FE7Eh
             dw 0FE7Fh, 0FE80h, 0FE81h, 0FE81h, 0FE82h, 0FE83h, 0FE84h, 0FE85h
             dw 0FE86h, 0FE87h, 0FE88h, 0FE89h, 0FE8Ah, 0FE8Bh, 0FE8Ch, 0FE8Dh
             dw 0FE8Eh, 0FE8Fh, 0FE90h, 0FE91h, 0FE92h, 0FE93h, 0FE94h, 0FE95h
             dw 0FE96h, 0FE97h, 0FE98h, 0FE98h, 0FE99h, 0FE9Ah, 0FE9Bh, 0FE9Ch
             dw 0FE9Dh, 0FE9Eh, 0FE9Fh, 0FEA0h, 0FEA1h, 0FEA2h, 0FEA3h, 0FEA4h
             dw 0FEA5h, 0FEA6h, 0FEA7h, 0FEA8h, 0FEA9h, 0FEAAh, 0FEABh, 0FEACh
             dw 0FEADh, 0FEAEh, 0FEAFh, 0FEB0h, 0FEB1h, 0FEB2h, 0FEB2h, 0FEB3h
             dw 0FEB4h, 0FEB5h, 0FEB6h, 0FEB7h, 0FEB8h, 0FEB9h, 0FEBAh, 0FEBBh
             dw 0FEBCh, 0FEBDh, 0FEBEh, 0FEBFh, 0FEC0h, 0FEC1h, 0FEC2h, 0FEC3h
             dw 0FEC4h, 0FEC5h, 0FEC6h, 0FEC7h, 0FEC8h, 0FEC9h, 0FECAh, 0FECBh
             dw 0FECCh, 0FECDh, 0FECEh, 0FECFh, 0FED0h, 0FED1h, 0FED1h, 0FED2h
             dw 0FED3h, 0FED4h, 0FED5h, 0FED6h, 0FED7h, 0FED8h, 0FED9h, 0FEDAh
             dw 0FEDBh, 0FEDCh, 0FEDDh, 0FEDEh, 0FEDFh, 0FEE0h, 0FEE1h, 0FEE2h
             dw 0FEE3h, 0FEE4h, 0FEE5h, 0FEE6h, 0FEE7h, 0FEE8h, 0FEE9h, 0FEEAh
             dw 0FEEBh, 0FEECh, 0FEEDh, 0FEEEh, 0FEEFh, 0FEF0h, 0FEF1h, 0FEF2h
             dw 0FEF3h, 0FEF4h, 0FEF5h, 0FEF6h, 0FEF7h, 0FEF8h, 0FEF9h, 0FEF9h
             dw 0FEFAh, 0FEFBh, 0FEFCh, 0FEFDh, 0FEFEh, 0FEFFh, 0FF00h, 0FF01h
             dw 0FF02h, 0FF03h, 0FF04h, 0FF05h, 0FF06h, 0FF07h, 0FF08h, 0FF09h
             dw 0FF0Ah, 0FF0Bh, 0FF0Ch, 0FF0Dh, 0FF0Eh, 0FF0Fh, 0FF10h, 0FF11h
             dw 0FF12h, 0FF13h, 0FF14h, 0FF15h, 0FF16h, 0FF17h, 0FF18h, 0FF19h
             dw 0FF1Ah, 0FF1Bh, 0FF1Ch, 0FF1Dh, 0FF1Eh, 0FF1Fh, 0FF20h, 0FF21h
             dw 0FF22h, 0FF23h, 0FF24h, 0FF25h, 0FF26h, 0FF27h, 0FF28h, 0FF29h
             dw 0FF2Ah, 0FF2Bh, 0FF2Ch, 0FF2Dh, 0FF2Eh, 0FF2Fh, 0FF30h, 0FF31h
             dw 0FF32h, 0FF32h, 0FF33h, 0FF34h, 0FF35h, 0FF36h, 0FF37h, 0FF38h
             dw 0FF39h, 0FF3Ah, 0FF3Bh, 0FF3Ch, 0FF3Dh, 0FF3Eh, 0FF3Fh, 0FF40h
             dw 0FF41h, 0FF42h, 0FF43h, 0FF44h, 0FF45h, 0FF46h, 0FF47h, 0FF48h
             dw 0FF49h, 0FF4Ah, 0FF4Bh, 0FF4Ch, 0FF4Dh, 0FF4Eh, 0FF4Fh, 0FF50h
             dw 0FF51h, 0FF52h, 0FF53h, 0FF54h, 0FF55h, 0FF56h, 0FF57h, 0FF58h
             dw 0FF59h, 0FF5Ah, 0FF5Bh, 0FF5Ch, 0FF5Dh, 0FF5Eh, 0FF5Fh, 0FF60h
             dw 0FF61h, 0FF62h, 0FF63h, 0FF64h, 0FF65h, 0FF66h, 0FF67h, 0FF68h
             dw 0FF69h, 0FF6Ah, 0FF6Bh, 0FF6Ch, 0FF6Dh, 0FF6Eh, 0FF6Fh, 0FF70h
             dw 0FF71h, 0FF72h, 0FF73h, 0FF74h, 0FF75h, 0FF76h, 0FF77h, 0FF78h
             dw 0FF79h, 0FF7Ah, 0FF7Bh, 0FF7Ch, 0FF7Dh, 0FF7Eh, 0FF7Fh, 0FF80h
             dw 0FF81h, 0FF82h, 0FF83h, 0FF84h, 0FF85h, 0FF86h, 0FF87h, 0FF88h
             dw 0FF89h, 0FF8Ah, 0FF8Bh, 0FF8Ch, 0FF8Dh, 0FF8Eh, 0FF8Fh, 0FF90h
             dw 0FF91h, 0FF92h, 0FF93h, 0FF94h, 0FF95h, 0FF96h, 0FF97h, 0FF98h
             dw 0FF99h, 0FF9Ah, 0FF9Bh, 0FF9Ch, 0FF9Dh, 0FF9Eh, 0FF9Fh, 0FFA0h
             dw 0FFA1h, 0FFA2h, 0FFA3h, 0FFA4h, 0FFA5h, 0FFA6h, 0FFA7h, 0FFA8h
             dw 0FFA9h, 0FFAAh, 0FFABh, 0FFACh, 0FFADh, 0FFAEh, 0FFAFh, 0FFB0h
             dw 0FFB1h, 0FFB2h, 0FFB3h, 0FFB4h, 0FFB5h, 0FFB6h, 0FFB7h, 0FFB8h
             dw 0FFB9h, 0FFBAh, 0FFBBh, 0FFBCh, 0FFBDh, 0FFBEh, 0FFBFh, 0FFC0h
             dw 0FFC1h, 0FFC2h, 0FFC3h, 0FFC4h, 0FFC5h, 0FFC6h, 0FFC7h, 0FFC8h
             dw 0FFC9h, 0FFCAh, 0FFCBh, 0FFCCh, 0FFCDh, 0FFCEh, 0FFCFh, 0FFD0h
             dw 0FFD1h, 0FFD2h, 0FFD3h, 0FFD4h, 0FFD5h, 0FFD6h, 0FFD7h, 0FFD8h
             dw 0FFD9h, 0FFDAh, 0FFDBh, 0FFDCh, 0FFDDh, 0FFDEh, 0FFDFh, 0FFE0h
             dw 0FFE1h, 0FFE2h, 0FFE3h, 0FFE4h, 0FFE5h, 0FFE6h, 0FFE7h, 0FFE8h
             dw 0FFE9h, 0FFEAh, 0FFEBh, 0FFECh, 0FFEDh, 0FFEEh, 0FFEFh, 0FFF0h
             dw 0FFF1h, 0FFF2h, 0FFF3h, 0FFF4h, 0FFF5h, 0FFF6h, 0FFF7h, 0FFF8h
             dw 0FFF9h, 0FFFAh, 0FFFBh, 0FFFCh, 0FFFDh, 0FFFEh, 0FFFFh, 00000h
             dw 00000h, 00000h, 00001h, 00002h, 00003h, 00004h, 00005h, 00006h
             dw 00007h, 00008h, 00009h, 0000Ah, 0000Bh, 0000Ch, 0000Dh, 0000Eh
             dw 0000Fh, 00010h, 00011h, 00012h, 00013h, 00014h, 00015h, 00016h
             dw 00017h, 00018h, 00019h, 0001Ah, 0001Bh, 0001Ch, 0001Dh, 0001Eh
             dw 0001Fh, 00020h, 00021h, 00022h, 00023h, 00024h, 00025h, 00026h
             dw 00027h, 00028h, 00029h, 0002Ah, 0002Bh, 0002Ch, 0002Dh, 0002Eh
             dw 0002Fh, 00030h, 00031h, 00032h, 00033h, 00034h, 00035h, 00036h
             dw 00037h, 00038h, 00039h, 0003Ah, 0003Bh, 0003Ch, 0003Dh, 0003Eh
             dw 0003Fh, 00040h, 00041h, 00042h, 00043h, 00044h, 00045h, 00046h
             dw 00047h, 00048h, 00049h, 0004Ah, 0004Bh, 0004Ch, 0004Dh, 0004Eh
             dw 0004Fh, 00050h, 00051h, 00052h, 00053h, 00054h, 00055h, 00056h
             dw 00057h, 00058h, 00059h, 0005Ah, 0005Bh, 0005Ch, 0005Dh, 0005Eh
             dw 0005Fh, 00060h, 00061h, 00062h, 00063h, 00064h, 00065h, 00066h
             dw 00067h, 00068h, 00069h, 0006Ah, 0006Bh, 0006Ch, 0006Dh, 0006Eh
             dw 0006Fh, 00070h, 00071h, 00072h, 00073h, 00074h, 00075h, 00076h
             dw 00077h, 00078h, 00079h, 0007Ah, 0007Bh, 0007Ch, 0007Dh, 0007Eh
             dw 0007Fh, 00080h, 00081h, 00082h, 00083h, 00084h, 00085h, 00086h
             dw 00087h, 00088h, 00089h, 0008Ah, 0008Bh, 0008Ch, 0008Dh, 0008Eh
             dw 0008Fh, 00090h, 00091h, 00092h, 00093h, 00094h, 00095h, 00096h
             dw 00097h, 00098h, 00099h, 0009Ah, 0009Bh, 0009Ch, 0009Dh, 0009Eh
             dw 0009Fh, 000A0h, 000A1h, 000A2h, 000A3h, 000A4h, 000A5h, 000A6h
             dw 000A7h, 000A8h, 000A9h, 000AAh, 000ABh, 000ACh, 000ADh, 000AEh
             dw 000AFh, 000B0h, 000B1h, 000B2h, 000B3h, 000B4h, 000B5h, 000B6h
             dw 000B7h, 000B8h, 000B9h, 000BAh, 000BBh, 000BCh, 000BDh, 000BEh
             dw 000BFh, 000C0h, 000C1h, 000C2h, 000C3h, 000C4h, 000C5h, 000C6h
             dw 000C7h, 000C8h, 000C9h, 000CAh, 000CBh, 000CCh, 000CDh, 000CEh
             dw 000CEh, 000CFh, 000D0h, 000D1h, 000D2h, 000D3h, 000D4h, 000D5h
             dw 000D6h, 000D7h, 000D8h, 000D9h, 000DAh, 000DBh, 000DCh, 000DDh
             dw 000DEh, 000DFh, 000E0h, 000E1h, 000E2h, 000E3h, 000E4h, 000E5h
             dw 000E6h, 000E7h, 000E8h, 000E9h, 000EAh, 000EBh, 000ECh, 000EDh
             dw 000EEh, 000EFh, 000F0h, 000F1h, 000F2h, 000F3h, 000F4h, 000F5h
             dw 000F6h, 000F7h, 000F8h, 000F9h, 000FAh, 000FBh, 000FCh, 000FDh
             dw 000FEh, 000FFh, 00100h, 00101h, 00102h, 00103h, 00104h, 00105h
             dw 00106h, 00107h, 00107h, 00108h, 00109h, 0010Ah, 0010Bh, 0010Ch
             dw 0010Dh, 0010Eh, 0010Fh, 00110h, 00111h, 00112h, 00113h, 00114h
             dw 00115h, 00116h, 00117h, 00118h, 00119h, 0011Ah, 0011Bh, 0011Ch
             dw 0011Dh, 0011Eh, 0011Fh, 00120h, 00121h, 00122h, 00123h, 00124h
             dw 00125h, 00126h, 00127h, 00128h, 00129h, 0012Ah, 0012Bh, 0012Ch
             dw 0012Dh, 0012Eh, 0012Fh, 0012Fh, 00130h, 00131h, 00132h, 00133h
             dw 00134h, 00135h, 00136h, 00137h, 00138h, 00139h, 0013Ah, 0013Bh
             dw 0013Ch, 0013Dh, 0013Eh, 0013Fh, 00140h, 00141h, 00142h, 00143h
             dw 00144h, 00145h, 00146h, 00147h, 00148h, 00149h, 0014Ah, 0014Bh
             dw 0014Ch, 0014Dh, 0014Eh, 0014Eh, 0014Fh, 00150h, 00151h, 00152h
             dw 00153h, 00154h, 00155h, 00156h, 00157h, 00158h, 00159h, 0015Ah
             dw 0015Bh, 0015Ch, 0015Dh, 0015Eh, 0015Fh, 00160h, 00161h, 00162h
             dw 00163h, 00164h, 00165h, 00166h, 00167h, 00168h, 00168h, 00169h
             dw 0016Ah, 0016Bh, 0016Ch, 0016Dh, 0016Eh, 0016Fh, 00170h, 00171h
             dw 00172h, 00173h, 00174h, 00175h, 00176h, 00177h, 00178h, 00179h
             dw 0017Ah, 0017Bh, 0017Ch, 0017Dh, 0017Eh, 0017Fh, 0017Fh, 00180h
             dw 00181h, 00182h, 00183h, 00184h, 00185h, 00186h, 00187h, 00188h
             dw 00189h, 0018Ah, 0018Bh, 0018Ch, 0018Dh, 0018Eh, 0018Fh, 00190h
             dw 00191h, 00192h, 00193h, 00193h, 00194h, 00195h, 00196h, 00197h
             dw 00198h, 00199h, 0019Ah, 0019Bh, 0019Ch, 0019Dh, 0019Eh, 0019Fh
             dw 001A0h, 001A1h, 001A2h, 001A3h, 001A4h, 001A5h, 001A5h, 001A6h
             dw 001A7h, 001A8h, 001A9h, 001AAh, 001ABh, 001ACh, 001ADh, 001AEh
             dw 001AFh, 001B0h, 001B1h, 001B2h, 001B3h, 001B4h, 001B5h, 001B6h
             dw 001B6h, 001B7h, 001B8h, 001B9h, 001BAh, 001BBh, 001BCh, 001BDh
             dw 001BEh, 001BFh, 001C0h, 001C1h, 001C2h, 001C3h, 001C4h, 001C5h
             dw 001C5h, 001C6h, 001C7h, 001C8h, 001C9h, 001CAh, 001CBh, 001CCh
             dw 001CDh, 001CEh, 001CFh, 001D0h, 001D1h, 001D2h, 001D3h, 001D4h
             dw 001D4h, 001D5h, 001D6h, 001D7h, 001D8h, 001D9h, 001DAh, 001DBh
             dw 001DCh, 001DDh, 001DEh, 001DFh, 001E0h, 001E1h, 001E1h, 001E2h
             dw 001E3h, 001E4h, 001E5h, 001E6h, 001E7h, 001E8h, 001E9h, 001EAh
             dw 001EBh, 001ECh, 001EDh, 001EEh, 001EEh, 001EFh, 001F0h, 001F1h
             dw 001F2h, 001F3h, 001F4h, 001F5h, 001F6h, 001F7h, 001F8h, 001F9h
             dw 001FAh, 001FAh, 001FBh, 001FCh, 001FDh, 001FEh, 001FFh, 00200h
             dw 00201h, 00202h, 00203h, 00204h, 00205h, 00205h, 00206h, 00207h
             dw 00208h, 00209h, 0020Ah, 0020Bh, 0020Ch, 0020Dh, 0020Eh, 0020Fh
             dw 00210h, 00210h, 00211h, 00212h, 00213h, 00214h, 00215h, 00216h
             dw 00217h, 00218h, 00219h, 0021Ah, 0021Ah, 0021Bh, 0021Ch, 0021Dh
             dw 0021Eh, 0021Fh, 00220h, 00221h, 00222h, 00223h, 00224h, 00224h
             dw 00225h, 00226h, 00227h, 00228h, 00229h, 0022Ah, 0022Bh, 0022Ch
             dw 0022Dh, 0022Eh, 0022Eh, 0022Fh, 00230h, 00231h, 00232h, 00233h
             dw 00234h, 00235h, 00236h, 00237h, 00237h, 00238h, 00239h, 0023Ah
             dw 0023Bh, 0023Ch, 0023Dh, 0023Eh, 0023Fh, 00240h, 00240h, 00241h
             dw 00242h, 00243h, 00244h, 00245h, 00246h, 00247h, 00248h, 00248h
             dw 00249h, 0024Ah, 0024Bh, 0024Ch, 0024Dh, 0024Eh, 0024Fh, 00250h
             dw 00250h, 00251h, 00252h, 00253h, 00254h, 00255h, 00256h, 00257h
             dw 00258h, 00258h, 00259h, 0025Ah, 0025Bh, 0025Ch, 0025Dh, 0025Eh
             dw 0025Fh, 00260h, 00260h, 00261h, 00262h, 00263h, 00264h, 00265h
             dw 00266h, 00267h, 00267h, 00268h, 00269h, 0026Ah, 0026Bh, 0026Ch
             dw 0026Dh, 0026Eh, 0026Fh, 0026Fh, 00270h, 00271h, 00272h, 00273h
             dw 00274h, 00275h, 00276h, 00276h, 00277h, 00278h, 00279h, 0027Ah
             dw 0027Bh, 0027Ch, 0027Dh, 0027Dh, 0027Eh, 0027Fh, 00280h, 00281h
             dw 00282h, 00283h, 00283h, 00284h, 00285h, 00286h, 00287h, 00288h
             dw 00289h, 0028Ah, 0028Ah, 0028Bh, 0028Ch, 0028Dh, 0028Eh, 0028Fh
             dw 00290h, 00290h, 00291h, 00292h, 00293h, 00294h, 00295h, 00296h
             dw 00297h, 00297h, 00298h, 00299h, 0029Ah, 0029Bh, 0029Ch, 0029Dh
             dw 0029Dh, 0029Eh, 0029Fh, 002A0h, 002A1h, 002A2h, 002A3h, 002A3h
             dw 002A4h, 002A5h, 002A6h, 002A7h, 002A8h, 002A8h, 002A9h, 002AAh
             dw 002ABh, 002ACh, 002ADh, 002AEh, 002AEh, 002AFh, 002B0h, 002B1h
             dw 002B2h, 002B3h, 002B4h, 002B4h, 002B5h, 002B6h, 002B7h, 002B8h
             dw 002B9h, 002B9h, 002BAh, 002BBh, 002BCh, 002BDh, 002BEh, 002BFh
             dw 002BFh, 002C0h, 002C1h, 002C2h, 002C3h, 002C4h, 002C4h, 002C5h
             dw 002C6h, 002C7h, 002C8h, 002C9h, 002C9h, 002CAh, 002CBh, 002CCh
             dw 002CDh, 002CEh, 002CEh, 002CFh, 002D0h, 002D1h, 002D2h, 002D3h
             dw 002D3h, 002D4h, 002D5h, 002D6h, 002D7h, 002D8h, 002D8h, 002D9h
             dw 002DAh, 002DBh, 002DCh, 002DDh, 002DDh, 002DEh, 002DFh, 002E0h
             dw 002E1h, 002E1h, 002E2h, 002E3h, 002E4h, 002E5h, 002E6h, 002E6h
             dw 002E7h, 002E8h, 002E9h, 002EAh, 002EBh, 002EBh, 002ECh, 002EDh
             dw 002EEh, 002EFh, 002EFh, 002F0h, 002F1h, 002F2h, 002F3h, 002F3h
             dw 002F4h, 002F5h, 002F6h, 002F7h, 002F8h, 002F8h, 002F9h, 002FAh
             dw 002FBh, 002FCh, 002FCh, 002FDh, 002FEh, 002FFh, 00300h, 00300h
             dw 00301h, 00302h, 00303h, 00304h, 00304h, 00305h, 00306h, 00307h
             dw 00308h, 00308h, 00309h, 0030Ah, 0030Bh, 0030Ch, 0030Dh, 0030Dh
             dw 0030Eh, 0030Fh, 00310h, 00310h, 00311h, 00312h, 00313h, 00314h
             dw 00314h, 00315h, 00316h, 00317h, 00318h, 00318h, 00319h, 0031Ah
             dw 0031Bh, 0031Ch, 0031Ch, 0031Dh, 0031Eh, 0031Fh, 00320h, 00320h
             dw 00321h, 00322h, 00323h, 00324h, 00324h, 00325h, 00326h, 00327h
             dw 00327h, 00328h, 00329h, 0032Ah, 0032Bh, 0032Bh, 0032Ch, 0032Dh
             dw 0032Eh, 0032Eh, 0032Fh, 00330h, 00331h, 00332h, 00332h, 00333h
             dw 00334h, 00335h, 00335h, 00336h, 00337h, 00338h, 00339h, 00339h
             dw 0033Ah, 0033Bh, 0033Ch, 0033Ch, 0033Dh, 0033Eh, 0033Fh, 00340h
             dw 00340h, 00341h, 00342h, 00343h, 00343h, 00344h, 00345h, 00346h
             dw 00346h, 00347h, 00348h, 00349h, 00349h, 0034Ah, 0034Bh, 0034Ch
             dw 0034Dh, 0034Dh, 0034Eh, 0034Fh, 00350h, 00350h, 00351h, 00352h
             dw 00353h, 00353h, 00354h, 00355h, 00356h, 00356h, 00357h, 00358h
             dw 00359h, 00359h, 0035Ah, 0035Bh, 0035Ch, 0035Ch, 0035Dh, 0035Eh
             dw 0035Fh, 0035Fh, 00360h, 00361h, 00362h, 00362h, 00363h, 00364h
             dw 00365h, 00365h, 00366h, 00367h, 00368h, 00368h, 00369h, 0036Ah
             dw 0036Bh, 0036Bh, 0036Ch, 0036Dh, 0036Dh, 0036Eh, 0036Fh, 00370h
             dw 00370h, 00371h, 00372h, 00373h, 00373h, 00374h, 00375h, 00376h
             dw 00376h, 00377h, 00378h, 00379h, 00379h, 0037Ah, 0037Bh, 0037Bh
             dw 0037Ch, 0037Dh, 0037Eh, 0037Eh, 0037Fh, 00380h, 00381h, 00381h
             dw 00382h, 00383h, 00383h, 00384h, 00385h, 00386h, 00386h, 00387h
             dw 00388h, 00388h, 00389h, 0038Ah, 0038Bh, 0038Bh, 0038Ch, 0038Dh
             dw 0038Dh, 0038Eh, 0038Fh, 00390h, 00390h, 00391h, 00392h, 00392h
             dw 00393h, 00394h, 00395h, 00395h, 00396h, 00397h, 00397h, 00398h
             dw 00399h, 0039Ah, 0039Ah, 0039Bh, 0039Ch, 0039Ch, 0039Dh, 0039Eh
             dw 0039Eh, 0039Fh, 003A0h, 003A1h, 003A1h, 003A2h, 003A3h, 003A3h
             dw 003A4h, 003A5h, 003A5h, 003A6h, 003A7h, 003A8h, 003A8h, 003A9h
             dw 003AAh, 003AAh, 003ABh, 003ACh, 003ACh, 003ADh, 003AEh, 003AFh
             dw 003AFh, 003B0h, 003B1h, 003B1h, 003B2h, 003B3h, 003B3h, 003B4h
             dw 003B5h, 003B5h, 003B6h, 003B7h, 003B7h, 003B8h, 003B9h, 003B9h
             dw 003BAh, 003BBh, 003BCh, 003BCh, 003BDh, 003BEh, 003BEh, 003BFh
             dw 003C0h, 003C0h, 003C1h, 003C2h, 003C2h, 003C3h, 003C4h, 003C4h
             dw 003C5h, 003C6h, 003C6h, 003C7h, 003C8h, 003C8h, 003C9h, 003CAh
             dw 003CAh, 003CBh, 003CCh, 003CCh, 003CDh, 003CEh, 003CEh, 003CFh
             dw 003D0h, 003D0h, 003D1h, 003D2h, 003D2h, 003D3h, 003D4h, 003D4h
             dw 003D5h, 003D6h, 003D6h, 003D7h, 003D8h, 003D8h, 003D9h, 003D9h
             dw 003DAh, 003DBh, 003DBh, 003DCh, 003DDh, 003DDh, 003DEh, 003DFh
             dw 003DFh, 003E0h, 003E1h, 003E1h, 003E2h, 003E3h, 003E3h, 003E4h
             dw 003E5h, 003E5h, 003E6h, 003E6h, 003E7h, 003E8h, 003E8h, 003E9h
             dw 003EAh, 003EAh, 003EBh, 003ECh, 003ECh, 003EDh, 003EDh, 003EEh
             dw 003EFh, 003EFh, 003F0h, 003F1h, 003F1h, 003F2h, 003F3h, 003F3h
             dw 003F4h, 003F4h, 003F5h, 003F6h, 003F6h, 003F7h, 003F8h, 003F8h
             dw 003F9h, 003F9h, 003FAh, 003FBh, 003FBh, 003FCh, 003FDh, 003FDh
             dw 003FEh, 003FEh, 003FFh, 00400h, 00400h, 00401h, 00401h, 00402h
             dw 00403h, 00403h, 00404h, 00405h, 00405h, 00406h, 00406h, 00407h
             dw 00408h, 00408h, 00409h, 00409h, 0040Ah, 0040Bh, 0040Bh, 0040Ch
             dw 0040Ch, 0040Dh, 0040Eh, 0040Eh, 0040Fh, 0040Fh, 00410h, 00411h
             dw 00411h, 00412h, 00412h, 00413h, 00414h, 00414h, 00415h, 00415h
             dw 00416h, 00417h, 00417h, 00418h, 00418h, 00419h, 0041Ah, 0041Ah
             dw 0041Bh, 0041Bh, 0041Ch, 0041Dh, 0041Dh, 0041Eh, 0041Eh, 0041Fh
             dw 00420h, 00420h, 00421h, 00421h, 00422h, 00422h, 00423h, 00424h
             dw 00424h, 00425h, 00425h, 00426h, 00427h, 00427h, 00428h, 00428h
             dw 00429h, 00429h, 0042Ah, 0042Bh, 0042Bh, 0042Ch, 0042Ch, 0042Dh
             dw 0042Dh, 0042Eh, 0042Fh, 0042Fh, 00430h, 00430h, 00431h, 00431h
             dw 00432h, 00433h, 00433h, 00434h, 00434h, 00435h, 00435h, 00436h
             dw 00436h, 00437h, 00438h, 00438h, 00439h, 00439h, 0043Ah, 0043Ah
             dw 0043Bh, 0043Bh, 0043Ch, 0043Dh, 0043Dh, 0043Eh, 0043Eh, 0043Fh
             dw 0043Fh, 00440h, 00440h, 00441h, 00442h, 00442h, 00443h, 00443h
             dw 00444h, 00444h, 00445h, 00445h, 00446h, 00446h, 00447h, 00448h
             dw 00448h, 00449h, 00449h, 0044Ah, 0044Ah, 0044Bh, 0044Bh, 0044Ch
             dw 0044Ch, 0044Dh, 0044Dh, 0044Eh, 0044Eh, 0044Fh, 00450h, 00450h
             dw 00451h, 00451h, 00452h, 00452h, 00453h, 00453h, 00454h, 00454h
             dw 00455h, 00455h, 00456h, 00456h, 00457h, 00457h, 00458h, 00458h
             dw 00459h, 0045Ah, 0045Ah, 0045Bh, 0045Bh, 0045Ch, 0045Ch, 0045Dh
             dw 0045Dh, 0045Eh, 0045Eh, 0045Fh, 0045Fh, 00460h, 00460h, 00461h
             dw 00461h, 00462h, 00462h, 00463h, 00463h, 00464h, 00464h, 00465h
             dw 00465h, 00466h, 00466h, 00467h, 00467h, 00468h, 00468h, 00469h
             dw 00469h, 0046Ah, 0046Ah, 0046Bh, 0046Bh, 0046Ch, 0046Ch, 0046Dh
             dw 0046Dh, 0046Eh, 0046Eh, 0046Fh, 0046Fh, 00470h, 00470h, 00471h
             dw 00471h, 00472h, 00472h, 00473h, 00473h, 00474h, 00474h, 00475h
             dw 00475h, 00476h, 00476h, 00476h, 00477h, 00477h, 00478h, 00478h
             dw 00479h, 00479h, 0047Ah, 0047Ah, 0047Bh, 0047Bh, 0047Ch, 0047Ch
             dw 0047Dh, 0047Dh, 0047Eh, 0047Eh, 0047Fh, 0047Fh, 0047Fh, 00480h
             dw 00480h, 00481h, 00481h, 00482h, 00482h, 00483h, 00483h, 00484h
             dw 00484h, 00485h, 00485h, 00485h, 00486h, 00486h, 00487h, 00487h
             dw 00488h, 00488h, 00489h, 00489h, 0048Ah, 0048Ah, 0048Ah, 0048Bh
             dw 0048Bh, 0048Ch, 0048Ch, 0048Dh, 0048Dh, 0048Eh, 0048Eh, 0048Eh
             dw 0048Fh, 0048Fh, 00490h, 00490h, 00491h, 00491h, 00492h, 00492h
             dw 00492h, 00493h, 00493h, 00494h, 00494h, 00495h, 00495h, 00496h
             dw 00496h, 00496h, 00497h, 00497h, 00498h, 00498h, 00499h, 00499h
             dw 00499h, 0049Ah, 0049Ah, 0049Bh, 0049Bh, 0049Ch, 0049Ch, 0049Ch
             dw 0049Dh, 0049Dh, 0049Eh, 0049Eh, 0049Eh, 0049Fh, 0049Fh, 004A0h
             dw 004A0h, 004A1h, 004A1h, 004A1h, 004A2h, 004A2h, 004A3h, 004A3h
             dw 004A3h, 004A4h, 004A4h, 004A5h, 004A5h, 004A5h, 004A6h, 004A6h
             dw 004A7h, 004A7h, 004A8h, 004A8h, 004A8h, 004A9h, 004A9h, 004AAh
             dw 004AAh, 004AAh, 004ABh, 004ABh, 004ACh, 004ACh, 004ACh, 004ADh
             dw 004ADh, 004ADh, 004AEh, 004AEh, 004AFh, 004AFh, 004AFh, 004B0h
             dw 004B0h, 004B1h, 004B1h, 004B1h, 004B2h, 004B2h, 004B3h, 004B3h
             dw 004B3h, 004B4h, 004B4h, 004B4h, 004B5h, 004B5h, 004B6h, 004B6h
             dw 004B6h, 004B7h, 004B7h, 004B7h, 004B8h, 004B8h, 004B9h, 004B9h
             dw 004B9h, 004BAh, 004BAh, 004BAh, 004BBh, 004BBh, 004BCh, 004BCh
             dw 004BCh, 004BDh, 004BDh, 004BDh, 004BEh, 004BEh, 004BEh, 004BFh
             dw 004BFh, 004C0h, 004C0h, 004C0h, 004C1h, 004C1h, 004C1h, 004C2h
             dw 004C2h, 004C2h, 004C3h, 004C3h, 004C3h, 004C4h, 004C4h, 004C5h
             dw 004C5h, 004C5h, 004C6h, 004C6h, 004C6h, 004C7h, 004C7h, 004C7h
             dw 004C8h, 004C8h, 004C8h, 004C9h, 004C9h, 004C9h, 004CAh, 004CAh
             dw 004CAh, 004CBh, 004CBh, 004CBh, 004CCh, 004CCh, 004CCh, 004CDh
             dw 004CDh, 004CDh, 004CEh, 004CEh, 004CEh, 004CFh, 004CFh, 004CFh
             dw 004D0h, 004D0h, 004D0h, 004D1h, 004D1h, 004D1h, 004D2h, 004D2h
             dw 004D2h, 004D3h, 004D3h, 004D3h, 004D3h, 004D4h, 004D4h, 004D4h
             dw 004D5h, 004D5h, 004D5h, 004D6h, 004D6h, 004D6h, 004D7h, 004D7h
             dw 004D7h, 004D8h, 004D8h, 004D8h, 004D8h, 004D9h, 004D9h, 004D9h
             dw 004DAh, 004DAh, 004DAh, 004DBh, 004DBh, 004DBh, 004DBh, 004DCh
             dw 004DCh, 004DCh, 004DDh, 004DDh, 004DDh, 004DEh, 004DEh, 004DEh
             dw 004DEh, 004DFh, 004DFh, 004DFh, 004E0h, 004E0h, 004E0h, 004E0h
             dw 004E1h, 004E1h, 004E1h, 004E2h, 004E2h, 004E2h, 004E2h, 004E3h
             dw 004E3h, 004E3h, 004E3h, 004E4h, 004E4h, 004E4h, 004E5h, 004E5h
             dw 004E5h, 004E5h, 004E6h, 004E6h, 004E6h, 004E6h, 004E7h, 004E7h
             dw 004E7h, 004E8h, 004E8h, 004E8h, 004E8h, 004E9h, 004E9h, 004E9h
             dw 004E9h, 004EAh, 004EAh, 004EAh, 004EAh, 004EBh, 004EBh, 004EBh
             dw 004EBh, 004ECh, 004ECh, 004ECh, 004ECh, 004EDh, 004EDh, 004EDh
             dw 004EDh, 004EEh, 004EEh, 004EEh, 004EEh, 004EFh, 004EFh, 004EFh
             dw 004EFh, 004F0h, 004F0h, 004F0h, 004F0h, 004F1h, 004F1h, 004F1h
             dw 004F1h, 004F2h, 004F2h, 004F2h, 004F2h, 004F3h, 004F3h, 004F3h
             dw 004F3h, 004F3h, 004F4h, 004F4h, 004F4h, 004F4h, 004F5h, 004F5h
             dw 004F5h, 004F5h, 004F6h, 004F6h, 004F6h, 004F6h, 004F6h, 004F7h
             dw 004F7h, 004F7h, 004F7h, 004F7h, 004F8h, 004F8h, 004F8h, 004F8h
             dw 004F9h, 004F9h, 004F9h, 004F9h, 004F9h, 004FAh, 004FAh, 004FAh
             dw 004FAh, 004FAh, 004FBh, 004FBh, 004FBh, 004FBh, 004FBh, 004FCh
             dw 004FCh, 004FCh, 004FCh, 004FCh, 004FDh, 004FDh, 004FDh, 004FDh
             dw 004FDh, 004FEh, 004FEh, 004FEh, 004FEh, 004FEh, 004FFh, 004FFh
             dw 004FFh, 004FFh, 004FFh, 00500h, 00500h, 00500h, 00500h, 00500h
             dw 00500h, 00501h, 00501h, 00501h, 00501h, 00501h, 00502h, 00502h
             dw 00502h, 00502h, 00502h, 00502h, 00503h, 00503h, 00503h, 00503h
             dw 00503h, 00503h, 00504h, 00504h, 00504h, 00504h, 00504h, 00504h
             dw 00505h, 00505h, 00505h, 00505h, 00505h, 00505h, 00506h, 00506h
             dw 00506h, 00506h, 00506h, 00506h, 00507h, 00507h, 00507h, 00507h
             dw 00507h, 00507h, 00508h, 00508h, 00508h, 00508h, 00508h, 00508h
             dw 00508h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h, 00509h
             dw 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Ah, 0050Bh
             dw 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Bh, 0050Ch
             dw 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Ch, 0050Dh
             dw 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Dh, 0050Eh
             dw 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh, 0050Eh
             dw 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh, 0050Fh
             dw 0050Fh, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h, 00510h
             dw 00510h, 00510h, 00510h, 00511h, 00511h, 00511h, 00511h, 00511h
             dw 00511h, 00511h, 00511h, 00511h, 00511h, 00511h, 00512h, 00512h
             dw 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h, 00512h
             dw 00512h, 00512h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h, 00513h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h, 00514h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h, 00515h
             dw 00515h, 00515h, 00515h, 00515h, 00515h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h
             dw 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h, 00516h

utab    EQU ($-stab)

             dw 0003Ch, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00065h, 00065h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h
             dw 00067h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00068h, 00068h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 00069h, 00069h, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00077h, 00077h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00078h, 00078h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h
             dw 00086h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00087h, 00087h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00088h, 00088h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00097h, 00097h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h
             dw 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h
             dw 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h, 000C8h
             dw 000C8h, 000C8h, 000C8h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h
             dw 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h
             dw 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000C9h
             dw 000C9h, 000C9h, 000C9h, 000C9h, 000C9h, 000CAh, 000CAh, 000CAh
             dw 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh
             dw 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh
             dw 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CAh, 000CBh
             dw 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh
             dw 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh
             dw 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh, 000CBh
             dw 000CBh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh
             dw 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh
             dw 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh, 000CCh
             dw 000CCh, 000CCh, 000CCh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh
             dw 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh
             dw 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CDh
             dw 000CDh, 000CDh, 000CDh, 000CDh, 000CDh, 000CEh, 000CEh, 000CEh
             dw 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh
             dw 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh
             dw 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CEh, 000CFh
             dw 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh
             dw 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh
             dw 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh, 000CFh
             dw 000CFh, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h
             dw 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h
             dw 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h, 000D0h
             dw 000D0h, 000D0h, 000D0h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h
             dw 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h
             dw 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D1h
             dw 000D1h, 000D1h, 000D1h, 000D1h, 000D1h, 000D2h, 000D2h, 000D2h
             dw 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h
             dw 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h
             dw 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h, 000D2h
             dw 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h
             dw 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h
             dw 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h, 000D3h
             dw 000D3h, 000D3h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h
             dw 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h
             dw 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h, 000D4h
             dw 000D4h, 000D4h, 000D4h, 000D4h, 000D5h, 000D5h, 000D5h, 000D5h
             dw 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h
             dw 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h
             dw 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D5h, 000D6h, 000D6h
             dw 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h
             dw 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h
             dw 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h, 000D6h
             dw 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h
             dw 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h
             dw 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h, 000D7h
             dw 000D7h, 000D7h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h
             dw 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h
             dw 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h, 000D8h
             dw 000D8h, 000D8h, 000D8h, 000D8h, 000D9h, 000D9h, 000D9h, 000D9h
             dw 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h
             dw 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h
             dw 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000D9h, 000DAh, 000DAh
             dw 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh
             dw 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh
             dw 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh, 000DAh
             dw 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh
             dw 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh
             dw 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh, 000DBh
             dw 000DBh, 000DBh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh
             dw 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh
             dw 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh, 000DCh
             dw 000DCh, 000DCh, 000DCh, 000DCh, 000DDh, 000DDh, 000DDh, 000DDh
             dw 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh
             dw 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh
             dw 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DDh, 000DEh, 000DEh
             dw 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh
             dw 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh
             dw 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh, 000DEh
             dw 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh
             dw 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh
             dw 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh, 000DFh
             dw 000DFh, 000DFh, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h
             dw 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h
             dw 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h, 000E0h
             dw 000E0h, 000E0h, 000E0h, 000E0h, 000E1h, 000E1h, 000E1h, 000E1h
             dw 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h
             dw 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h
             dw 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E1h, 000E2h, 000E2h
             dw 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h
             dw 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h
             dw 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h, 000E2h
             dw 000E2h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h
             dw 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h
             dw 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h, 000E3h
             dw 000E3h, 000E3h, 000E3h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h
             dw 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h
             dw 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E4h
             dw 000E4h, 000E4h, 000E4h, 000E4h, 000E4h, 000E5h, 000E5h, 000E5h
             dw 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h
             dw 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h
             dw 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E5h, 000E6h
             dw 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h
             dw 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h
             dw 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h, 000E6h
             dw 000E6h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h
             dw 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h
             dw 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h, 000E7h
             dw 000E7h, 000E7h, 000E7h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h
             dw 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h
             dw 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E8h
             dw 000E8h, 000E8h, 000E8h, 000E8h, 000E8h, 000E9h, 000E9h, 000E9h
             dw 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h
             dw 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h
             dw 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000E9h, 000EAh
             dw 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh
             dw 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh
             dw 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh, 000EAh
             dw 000EAh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh
             dw 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh
             dw 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh, 000EBh
             dw 000EBh, 000EBh, 000EBh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh
             dw 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh
             dw 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000ECh
             dw 000ECh, 000ECh, 000ECh, 000ECh, 000ECh, 000EDh, 000EDh, 000EDh
             dw 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh
             dw 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh
             dw 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EDh, 000EEh
             dw 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh
             dw 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh
             dw 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh, 000EEh
             dw 000EEh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh
             dw 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh
             dw 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh, 000EFh
             dw 000EFh, 000EFh, 000EFh, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h
             dw 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h
             dw 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F0h
             dw 000F0h, 000F0h, 000F0h, 000F0h, 000F0h, 000F1h, 000F1h, 000F1h
             dw 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h
             dw 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h
             dw 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F1h, 000F2h
             dw 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h
             dw 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h
             dw 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h, 000F2h
             dw 000F2h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h
             dw 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h
             dw 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h, 000F3h
             dw 000F3h, 000F3h, 000F3h, 000F3h, 000F4h, 000F4h, 000F4h, 000F4h
             dw 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h
             dw 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h
             dw 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F4h, 000F5h, 000F5h
             dw 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h
             dw 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h
             dw 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h, 000F5h
             dw 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h
             dw 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h
             dw 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h, 000F6h
             dw 000F6h, 000F6h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h
             dw 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h
             dw 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h, 000F7h
             dw 000F7h, 000F7h, 000F7h, 000F7h, 000F8h, 000F8h, 000F8h, 000F8h
             dw 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h
             dw 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h
             dw 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F8h, 000F9h, 000F9h
             dw 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h
             dw 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h
             dw 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h, 000F9h
             dw 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh
             dw 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh
             dw 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh, 000FAh
             dw 000FAh, 000FAh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh
             dw 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh
             dw 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh, 000FBh
             dw 000FBh, 000FBh, 000FBh, 000FBh, 000FCh, 000FCh, 000FCh, 000FCh
             dw 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh
             dw 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh
             dw 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FCh, 000FDh, 000FDh
             dw 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh
             dw 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh
             dw 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh, 000FDh
             dw 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh
             dw 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh
             dw 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh, 000FEh
             dw 000FEh, 000FEh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh
             dw 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh
             dw 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh, 000FFh
             dw 000FFh, 000FFh, 000FFh, 000FFh, 00100h, 00100h, 00100h, 00100h
             dw 00100h, 00100h, 00100h, 00100h, 00100h, 00100h, 00100h, 00100h
             dw 00100h, 00100h, 00100h, 00100h, 00100h, 00100h, 00100h, 00100h
             dw 00100h, 00100h, 00100h, 00100h, 00100h, 00100h, 00101h, 00101h
             dw 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h
             dw 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h
             dw 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h, 00101h
             dw 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h
             dw 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h
             dw 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h, 00102h
             dw 00102h, 00102h, 00103h, 00103h, 00103h, 00103h, 00103h, 00103h
             dw 00103h, 00103h, 00103h, 00103h, 00103h, 00103h, 00103h, 00103h
             dw 00103h, 00103h, 00103h, 00103h, 00103h, 00103h, 00103h, 00103h
             dw 00103h, 00103h, 00103h, 00103h, 00104h

vtab    EQU ($-stab)

             dw 00000h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h
             dw 00001h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h
             dw 00001h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h, 00001h
             dw 00001h, 00001h, 00001h, 00002h, 00002h, 00002h, 00002h, 00002h
             dw 00002h, 00002h, 00002h, 00002h, 00002h, 00002h, 00002h, 00002h
             dw 00002h, 00002h, 00002h, 00002h, 00002h, 00002h, 00002h, 00002h
             dw 00002h, 00002h, 00002h, 00002h, 00002h, 00003h, 00003h, 00003h
             dw 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00003h
             dw 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00003h
             dw 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00003h, 00004h
             dw 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h
             dw 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h
             dw 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h, 00004h
             dw 00004h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h
             dw 00005h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h
             dw 00005h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h, 00005h
             dw 00005h, 00005h, 00005h, 00006h, 00006h, 00006h, 00006h, 00006h
             dw 00006h, 00006h, 00006h, 00006h, 00006h, 00006h, 00006h, 00006h
             dw 00006h, 00006h, 00006h, 00006h, 00006h, 00006h, 00006h, 00006h
             dw 00006h, 00006h, 00006h, 00006h, 00006h, 00007h, 00007h, 00007h
             dw 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00007h
             dw 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00007h
             dw 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00007h, 00008h
             dw 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h
             dw 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h
             dw 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h, 00008h
             dw 00008h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h
             dw 00009h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h
             dw 00009h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h, 00009h
             dw 00009h, 00009h, 00009h, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah
             dw 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah
             dw 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah
             dw 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Ah, 0000Bh, 0000Bh, 0000Bh
             dw 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh
             dw 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh
             dw 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Bh, 0000Ch
             dw 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch
             dw 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch
             dw 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch, 0000Ch
             dw 0000Ch, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh
             dw 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh
             dw 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh, 0000Dh
             dw 0000Dh, 0000Dh, 0000Dh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh
             dw 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh
             dw 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh
             dw 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Eh, 0000Fh, 0000Fh, 0000Fh
             dw 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh
             dw 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh
             dw 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 0000Fh, 00010h
             dw 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h
             dw 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h
             dw 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h, 00010h
             dw 00010h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h
             dw 00011h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h
             dw 00011h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h, 00011h
             dw 00011h, 00011h, 00011h, 00011h, 00012h, 00012h, 00012h, 00012h
             dw 00012h, 00012h, 00012h, 00012h, 00012h, 00012h, 00012h, 00012h
             dw 00012h, 00012h, 00012h, 00012h, 00012h, 00012h, 00012h, 00012h
             dw 00012h, 00012h, 00012h, 00012h, 00012h, 00012h, 00013h, 00013h
             dw 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h
             dw 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h
             dw 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h, 00013h
             dw 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h
             dw 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h
             dw 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h, 00014h
             dw 00014h, 00014h, 00015h, 00015h, 00015h, 00015h, 00015h, 00015h
             dw 00015h, 00015h, 00015h, 00015h, 00015h, 00015h, 00015h, 00015h
             dw 00015h, 00015h, 00015h, 00015h, 00015h, 00015h, 00015h, 00015h
             dw 00015h, 00015h, 00015h, 00015h, 00016h, 00016h, 00016h, 00016h
             dw 00016h, 00016h, 00016h, 00016h, 00016h, 00016h, 00016h, 00016h
             dw 00016h, 00016h, 00016h, 00016h, 00016h, 00016h, 00016h, 00016h
             dw 00016h, 00016h, 00016h, 00016h, 00016h, 00016h, 00017h, 00017h
             dw 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h
             dw 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h
             dw 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h, 00017h
             dw 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h
             dw 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h
             dw 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h, 00018h
             dw 00018h, 00018h, 00019h, 00019h, 00019h, 00019h, 00019h, 00019h
             dw 00019h, 00019h, 00019h, 00019h, 00019h, 00019h, 00019h, 00019h
             dw 00019h, 00019h, 00019h, 00019h, 00019h, 00019h, 00019h, 00019h
             dw 00019h, 00019h, 00019h, 00019h, 0001Ah, 0001Ah, 0001Ah, 0001Ah
             dw 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah
             dw 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah
             dw 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Ah, 0001Bh, 0001Bh
             dw 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh
             dw 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh
             dw 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh, 0001Bh
             dw 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch
             dw 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch
             dw 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch, 0001Ch
             dw 0001Ch, 0001Ch, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh
             dw 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh
             dw 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Dh
             dw 0001Dh, 0001Dh, 0001Dh, 0001Dh, 0001Eh, 0001Eh, 0001Eh, 0001Eh
             dw 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh
             dw 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh
             dw 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Eh, 0001Fh, 0001Fh
             dw 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh
             dw 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh
             dw 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh, 0001Fh
             dw 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h
             dw 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h
             dw 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h, 00020h
             dw 00020h, 00020h, 00021h, 00021h, 00021h, 00021h, 00021h, 00021h
             dw 00021h, 00021h, 00021h, 00021h, 00021h, 00021h, 00021h, 00021h
             dw 00021h, 00021h, 00021h, 00021h, 00021h, 00021h, 00021h, 00021h
             dw 00021h, 00021h, 00021h, 00021h, 00022h, 00022h, 00022h, 00022h
             dw 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00022h
             dw 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00022h
             dw 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00022h, 00023h
             dw 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h
             dw 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h
             dw 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h, 00023h
             dw 00023h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h
             dw 00024h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h
             dw 00024h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h, 00024h
             dw 00024h, 00024h, 00024h, 00025h, 00025h, 00025h, 00025h, 00025h
             dw 00025h, 00025h, 00025h, 00025h, 00025h, 00025h, 00025h, 00025h
             dw 00025h, 00025h, 00025h, 00025h, 00025h, 00025h, 00025h, 00025h
             dw 00025h, 00025h, 00025h, 00025h, 00025h, 00026h, 00026h, 00026h
             dw 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00026h
             dw 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00026h
             dw 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00026h, 00027h
             dw 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h
             dw 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h
             dw 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h, 00027h
             dw 00027h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h
             dw 00028h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h
             dw 00028h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h, 00028h
             dw 00028h, 00028h, 00028h, 00029h, 00029h, 00029h, 00029h, 00029h
             dw 00029h, 00029h, 00029h, 00029h, 00029h, 00029h, 00029h, 00029h
             dw 00029h, 00029h, 00029h, 00029h, 00029h, 00029h, 00029h, 00029h
             dw 00029h, 00029h, 00029h, 00029h, 00029h, 0002Ah, 0002Ah, 0002Ah
             dw 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah
             dw 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah
             dw 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Ah, 0002Bh
             dw 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh
             dw 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh
             dw 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh, 0002Bh
             dw 0002Bh, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch
             dw 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch
             dw 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch, 0002Ch
             dw 0002Ch, 0002Ch, 0002Ch, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh
             dw 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh
             dw 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh
             dw 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Dh, 0002Eh, 0002Eh, 0002Eh
             dw 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh
             dw 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh
             dw 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Eh, 0002Fh
             dw 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh
             dw 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh
             dw 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh, 0002Fh
             dw 0002Fh, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h
             dw 00030h, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h
             dw 00030h, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h, 00030h
             dw 00030h, 00030h, 00030h, 00031h, 00031h, 00031h, 00031h, 00031h
             dw 00031h, 00031h, 00031h, 00031h, 00031h, 00031h, 00031h, 00031h
             dw 00031h, 00031h, 00031h, 00031h, 00031h, 00031h, 00031h, 00031h
             dw 00031h, 00031h, 00031h, 00031h, 00031h, 00032h, 00032h, 00032h
             dw 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h
             dw 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h
             dw 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h, 00032h
             dw 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h
             dw 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h
             dw 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h, 00033h
             dw 00033h, 00033h, 00034h, 00034h, 00034h, 00034h, 00034h, 00034h
             dw 00034h, 00034h, 00034h, 00034h, 00034h, 00034h, 00034h, 00034h
             dw 00034h, 00034h, 00034h, 00034h, 00034h, 00034h, 00034h, 00034h
             dw 00034h, 00034h, 00034h, 00034h, 00035h, 00035h, 00035h, 00035h
             dw 00035h, 00035h, 00035h, 00035h, 00035h, 00035h, 00035h, 00035h
             dw 00035h, 00035h, 00035h, 00035h, 00035h, 00035h, 00035h, 00035h
             dw 00035h, 00035h, 00035h, 00035h, 00035h, 00035h, 00036h, 00036h
             dw 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h
             dw 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h
             dw 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h, 00036h
             dw 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h
             dw 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h
             dw 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h, 00037h
             dw 00037h, 00037h, 00038h, 00038h, 00038h, 00038h, 00038h, 00038h
             dw 00038h, 00038h, 00038h, 00038h, 00038h, 00038h, 00038h, 00038h
             dw 00038h, 00038h, 00038h, 00038h, 00038h, 00038h, 00038h, 00038h
             dw 00038h, 00038h, 00038h, 00038h, 00039h, 00039h, 00039h, 00039h
             dw 00039h, 00039h, 00039h, 00039h, 00039h, 00039h, 00039h, 00039h
             dw 00039h, 00039h, 00039h, 00039h, 00039h, 00039h, 00039h, 00039h
             dw 00039h, 00039h, 00039h, 00039h, 00039h, 00039h, 0003Ah, 0003Ah
             dw 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah
             dw 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah
             dw 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah, 0003Ah
             dw 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh
             dw 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh
             dw 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh, 0003Bh
             dw 0003Bh, 0003Bh, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch
             dw 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch
             dw 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Ch
             dw 0003Ch, 0003Ch, 0003Ch, 0003Ch, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh
             dw 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Dh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh, 0003Eh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh, 0003Fh
             dw 0003Fh, 0003Fh, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h, 00040h
             dw 00040h, 00040h, 00040h, 00040h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00041h
             dw 00041h, 00041h, 00041h, 00041h, 00041h, 00041h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h, 00042h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h, 00043h
             dw 00043h, 00043h, 00043h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h, 00044h
             dw 00044h, 00044h, 00044h, 00044h, 00044h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h
             dw 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00045h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h, 00046h
             dw 00046h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h, 00047h
             dw 00047h, 00047h, 00047h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h, 00048h
             dw 00048h, 00048h, 00048h, 00048h, 00048h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h
             dw 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 00049h, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah, 0004Ah
             dw 0004Ah, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh, 0004Bh
             dw 0004Bh, 0004Bh, 0004Bh, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch
             dw 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Ch, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh
             dw 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Dh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh, 0004Eh
             dw 0004Eh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh, 0004Fh
             dw 0004Fh, 0004Fh, 0004Fh, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h, 00050h
             dw 00050h, 00050h, 00050h, 00050h, 00050h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h
             dw 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00051h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h, 00052h
             dw 00052h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h, 00053h
             dw 00053h, 00053h, 00053h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00054h
             dw 00054h, 00054h, 00054h, 00054h, 00054h, 00054h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h, 00055h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h, 00056h
             dw 00056h, 00056h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h, 00057h
             dw 00057h, 00057h, 00057h, 00057h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00058h
             dw 00058h, 00058h, 00058h, 00058h, 00058h, 00058h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h, 00059h
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah, 0005Ah
             dw 0005Ah, 0005Ah, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Bh
             dw 0005Bh, 0005Bh, 0005Bh, 0005Bh, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch
             dw 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Ch, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh, 0005Dh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh, 0005Eh
             dw 0005Eh, 0005Eh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh, 0005Fh
             dw 0005Fh, 0005Fh, 0005Fh, 0005Fh, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00060h
             dw 00060h, 00060h, 00060h, 00060h, 00060h, 00060h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h, 00061h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h, 00062h
             dw 00062h, 00062h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h, 00063h
             dw 00063h, 00063h, 00063h, 00063h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h, 00064h
             dw 00064h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h, 00065h
             dw 00065h, 00065h, 00065h, 00066h, 00066h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h, 00066h
             dw 00066h, 00066h, 00066h, 00066h, 00066h, 00067h, 00067h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h
             dw 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00067h, 00068h
             dw 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h, 00068h
             dw 00068h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h, 00069h
             dw 00069h, 00069h, 00069h, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah
             dw 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Ah, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh
             dw 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Bh, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch, 0006Ch
             dw 0006Ch, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh, 0006Dh
             dw 0006Dh, 0006Dh, 0006Dh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh
             dw 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Eh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh
             dw 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 0006Fh, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h, 00070h
             dw 00070h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h, 00071h
             dw 00071h, 00071h, 00071h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h, 00072h
             dw 00072h, 00072h, 00072h, 00072h, 00072h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h
             dw 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00073h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h, 00074h
             dw 00074h, 00074h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h, 00075h
             dw 00075h, 00075h, 00075h, 00075h, 00076h, 00076h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00076h
             dw 00076h, 00076h, 00076h, 00076h, 00076h, 00076h, 00077h, 00077h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h, 00077h
             dw 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h, 00078h
             dw 00078h, 00078h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h, 00079h
             dw 00079h, 00079h, 00079h, 00079h, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah
             dw 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Ah, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh, 0007Bh
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch, 0007Ch
             dw 0007Ch, 0007Ch, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Dh
             dw 0007Dh, 0007Dh, 0007Dh, 0007Dh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh
             dw 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Eh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh, 0007Fh
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h, 00080h
             dw 00080h, 00080h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h, 00081h
             dw 00081h, 00081h, 00081h, 00081h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00082h
             dw 00082h, 00082h, 00082h, 00082h, 00082h, 00082h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h, 00083h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h, 00084h
             dw 00084h, 00084h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h, 00085h
             dw 00085h, 00085h, 00085h, 00085h, 00085h, 00086h, 00086h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h
             dw 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00086h, 00087h
             dw 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h, 00087h
             dw 00087h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h, 00088h
             dw 00088h, 00088h, 00088h, 00089h, 00089h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h, 00089h
             dw 00089h, 00089h, 00089h, 00089h, 00089h, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah
             dw 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Ah, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh, 0008Bh
             dw 0008Bh, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch, 0008Ch
             dw 0008Ch, 0008Ch, 0008Ch, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh
             dw 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Dh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh
             dw 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Eh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh, 0008Fh
             dw 0008Fh, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h, 00090h
             dw 00090h, 00090h, 00090h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h, 00091h
             dw 00091h, 00091h, 00091h, 00091h, 00091h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h
             dw 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00092h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h, 00093h
             dw 00093h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h, 00094h
             dw 00094h, 00094h, 00094h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h, 00095h
             dw 00095h, 00095h, 00095h, 00095h, 00095h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h, 00096h
             dw 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h, 00097h
             dw 00097h, 00097h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h, 00098h
             dw 00098h, 00098h, 00098h, 00098h, 00099h, 00099h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 00099h
             dw 00099h, 00099h, 00099h, 00099h, 00099h, 00099h, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah, 0009Ah
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh, 0009Bh
             dw 0009Bh, 0009Bh, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Ch
             dw 0009Ch, 0009Ch, 0009Ch, 0009Ch, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh
             dw 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Dh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh, 0009Eh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh, 0009Fh
             dw 0009Fh, 0009Fh, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h, 000A0h
             dw 000A0h, 000A0h, 000A0h, 000A0h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h
             dw 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A1h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h, 000A2h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h, 000A3h
             dw 000A3h, 000A3h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h, 000A4h
             dw 000A4h, 000A4h, 000A4h, 000A4h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h
             dw 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A5h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h, 000A6h
             dw 000A6h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h, 000A7h
             dw 000A7h, 000A7h, 000A7h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A8h
             dw 000A8h, 000A8h, 000A8h, 000A8h, 000A8h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h
             dw 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000A9h, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh, 000AAh
             dw 000AAh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh, 000ABh
             dw 000ABh, 000ABh, 000ABh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ACh
             dw 000ACh, 000ACh, 000ACh, 000ACh, 000ACh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh
             dw 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000ADh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh, 000AEh
             dw 000AEh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh, 000AFh
             dw 000AFh, 000AFh, 000AFh, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B0h
             dw 000B0h, 000B0h, 000B0h, 000B0h, 000B0h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h
             dw 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B1h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h, 000B2h
             dw 000B2h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h, 000B3h
             dw 000B3h, 000B3h, 000B3h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B4h
             dw 000B4h, 000B4h, 000B4h, 000B4h, 000B4h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h
             dw 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B5h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h, 000B6h
             dw 000B6h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h, 000B7h
             dw 000B7h, 000B7h, 000B7h, 000B7h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h
             dw 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B8h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h, 000B9h
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh, 000BAh
             dw 000BAh, 000BAh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh, 000BBh
             dw 000BBh, 000BBh, 000BBh, 000BBh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh
             dw 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BCh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh, 000BDh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh, 000BEh
             dw 000BEh, 000BEh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh, 000BFh
             dw 000BFh, 000BFh, 000BFh, 000BFh, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h
             dw 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C0h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h, 000C1h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h, 000C2h
             dw 000C2h, 000C2h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h, 000C3h
             dw 000C3h, 000C3h, 000C3h, 000C3h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h
             dw 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C4h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h, 000C5h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h, 000C6h
             dw 000C6h, 000C6h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h, 000C7h
             dw 000C7h, 000C7h, 000C7h, 000C7h, 000C8h

mem_error    db  'No memory!',13,10,'$'
copyr        db  'Tronix (c) 2023',13,10,'$'

c       DB ?	; char from KBD

OldK    DW ?	; old int 09h vector
	DW ?
END
