;necropolis 3071 a.d.
;sensenstahl/hjb
;www.sensenstahl.com
;fasm 1.69.31
;listening: sabled sun - temple to new gods

;after coming up with an idea it somehow reminded me on
;the 214X series by sabled sun and on artwork for many
;cryo chamber releases which then kinda influenced the path of
;the gfx.

;all is drawn directly into the vga memory since it is a gfx
;so flipping from memory to the screen would be just a waste of bytes.

;the grayscale is generated after drawing the image (in standard colors)
;to save a few bytes. colors do not offer the same pop/atmosphere
;compared to b/w. the same can be said about full grayscale 0..255.
;the image loses a lot with that.

;features: - a random smiley face in the sky
;          - 3 not so random shooting stars
;          - bobbo rosso happy accident semi anti-aliasing on the pyramids
;            (at least 2 edges)
;          - some (usual) post processing to make things a bit
;            more interesting

;runs fine here under xp, dosbox and freedos without color issues (tm)

org 100h
use16

;assuming: cx = 255 bx = ax = 0

start:   push 0a000h ;vga memory
         pop ds
         mov al,13h  ;320*200*256, ha ha ha
         int 10h
main:

;create sky/ground/bg
;screen buffer is 0 after init 13h
;so below 320*128 the background will be 0/black
;ch = 0 / cl = 255 here
mov di,320     ;save some bytes below

mov bh,0a0h ;320*128 = a000h
bg1:
mov si,di;320
bg2:
mov byte[ds:si+bx],cl ;draw
dec si                ;move to the right
jnz bg2
dec cx                ;change color
sub bx,di;320         ;move up
jnz bg1

;the rays to the old gods
;drawn behind the upcoming pyramids/towers
;bx = 0
;mov bx,320*120;9600h
mov bh,96h    ;-1b
mov ax,7777h ;save some bytes below ;77h = 199
ray:
;the -320 makes all values max -127..0..127
;which is 1b shorter than outside of those
;and in this case it does not change anything visually
mov byte[ds:bx+90],al      ;left pyramid
mov word[ds:bx+207-320],ax ;middle
mov byte[ds:bx+255-320],al ;right

mov byte[ds:bx+311-320],al ;thin one on the right
mov word[ds:bx+314-320],ax ;fat one on the right
sub bx,di;320
jnc ray

dec di ;=319 so save 1b below

;create 3 pyramids
;ch = 0
;ah = al = 77h = 119
;bx does not matter, positioning is changed via
;placing the pyramids anyway so bytes for init bx can
;be saved
mov cl,160 ;lenght of bottom line
pyr2:
mov si,cx  ;length at current level
pyr:
mov bp,cx  ;create shading on the left side
shr bp,2   ;div side lenght by 4

;xor ax,ax ;color
cmp bp,si ;if drawing below lenght of bp
jb kk     ;then do not change color /shading
sub al,bh ;change color
sub al,28 ;one of those instances where i looked what
          ;happens if ... so skipping the xor ax,ax above and
          ;adjusting the color makes 2 of the 3 sides smooth
          ;so for 0 extra bytes 2/3 dof plus a bit of light
          ;on the right top edge of the big pyramid is a nice
          ;thing to have even if it was not done on purpose
kk:
mov byte[ds:si+bx+320*157+10],al  ;smallest pyramid on the left
mov byte[ds:si+bx+320*128+127],al ;big pyramid in the middle

shr al,1 ;this one is in the shadow of the biggest one
         ;so the side is a bit darker
         ;keep it realistic (tm)
mov byte[ds:si+bx+320*138+175],al ;smaller pyramid on the right

dec si     ;work the whole level
jnz pyr
sub bx,di;319 ;move 1 level up and move 1 pixel to the side
           ;to create a triangle
dec cx     ;shorten next level by 2 pixels
loop pyr2  ;do all levels

;create skyline
;cx = si = 0
;si = pos of buildings/stars
;dx does not matter
pos:
adc ax,bp ;random enough
mul si    ;random enough
xor bp,dx ;random enough
cmp al,120;132;120;96;80;68;64;44;24;12;8 ;random enough
          ;i gave up/stopped single checks at 160
          ;things needed to: - cover up the bottoms of the pyramids
          ;                  - have some darker/emptier spots in between
          ;                    the towers
          ;                  - overall not too many towers
jne naaah ;do not do anything

shrd bx,ax,26 ;thanks to superogue for random feedback #2 i did not
              ;ask for :D but i revisited this and made the colors
              ;of the stars more random instead of making them just fade out

add byte[ds:si-3-4],bl ;to make sky a bit more interesting
                       ;by sprinkling some stars
                       ;including a random smiley face :)

mov bx,320*36 ;height of every building
              ;which is drawn from bottom to top

;xor dx,dx     ;start with black and brighten the color
              ;on the way up so things fade out at bottom
mov dl,1
tower1:
mov cl,11     ;width of buildings
              ;wider values close the gap between the smallest and the
              ;biggest pyramid which destroys the lightning between them
              ;from the horizon/background at the given rnd values
tower2:
mov di,cx                       ;get the width
add di,si                       ;and the "random" pos of the building
mov byte[ds:di+bx+320*95+16],dl ;draw the facade

;put some futuristic windows in there
xor ch,ah ;rnd stuff
;or ch,bh  ;the brute ;more futuristic + clean without that
rol ch,cl ;way which
;cmp ch,64 ;is enough
;ja fine
cmp ch,ah ;-1b and still
jb fine   ;nice, clean shapes
add byte[ds:di+bx+320*95+16],cl;5 ;keep it decent colored
fine:
xor ch,ch ;del to make loop work

;draw side + top of towers
mov dh,dl ;get current color
sub dh,cl ;a bit more shading on the top from left to right
shl dh,1  ;make it brighter than the building itself
mov byte[ds:di+bx+320*95-321+16],dh ;draw side/top shading

loop tower2 ;do complete width
inc dx      ;rise color for fading effect
sub bx,320  ;do complete height
jnz tower1  ;of the tower

naaah:
inc si        ;move to next pos
cmp si,320*58 ;inside the area in which the sky scrapers get created
jne pos       ;do all

;######## some post processing ahead ########
;jmp waiting ;test

;add fake scanlines for an extra texture
;because things look a bit too clean and smooth w/o
;bx = cx = 0
scan1:
mov si,320-26 ;no scanline in area of upcoming glass bar
              ;no extra cost but extra gain ;)
scan2:
add byte[ds:si+bx+67-8],3;4;3 ;change color
dec si
jnz scan2
add bx,320*2
jnc scan1

;add a glass bar. can't skip that one ;)
;cx = si = 0
glass1:
mov si,26 ;width of glass bar
glass2:
mov al,byte[ds:si+bx-40+320*10+9] ;get pixel from different height
                                  ;could save 1b here but some things
                                  ;need to be
;add al,15                         ;color change
add ax,si                         ;some shading for 0 bytes
                                  ;is always welcome
mov byte[ds:si+bx-40+9],al        ;set pixel

mov byte[ds:bx-41+9+1],cl   ;thin black border left
mov word[ds:bx-40+25+10],cx ;thick black border right
;mov byte[ds:bx-41+25+14],cl ;make it a bit thicker on the right
                            ;so it looks kinda like an angled mirror

;add 3 little shooting stars while being at the glass bar anyway :)
imul di,si,319               ;classic 45 deg
or byte[ds:di+320*19+296],dh ;with bright star on top

or byte[ds:di+320*15+158],dh ;additional one to use remaing bytes

;imul di,si,318               ;different angle to spice it up
                             ;opposite direction is also nice but
                             ;i prefer that flow
                             ;plus i needed to make a decision
sub di,si ;-2b
or word[ds:di+320*42+194],si ;additional one since bytes left
                             ;+320 makes a bright star but since
                             ;it is in a brighter area it does not
                             ;look good

;or word[ds:di+320*42+193],si ;

dec si
jnz glass2 ;width
add bx,320
jnc glass1 ;height

;after squeezing out 4 extra bytes it would have been a waste to
;add 4 nops or another line/beam/shooting star which would have added
;nothing. but a light/window on one of the towers is a nice small extra
;i assume nobody cares for :)
add byte[ds:320*138+238],dh ;it is a plain tower but i chose that one
                            ;to make sure it does not look random
                            ;also the tower is kinda isolated in the gap
                            ;which draws a bit of attention


sbb byte[ds:320*143+54],dh  ;another extra, better than a fat shooting star
                            ;or a light on a pyramid which looks more like
                            ;a misplaced star
                            ;nobody will care for this but i like it




;add extra slim pal bars to give it some stable edge
;but also enough room to breathe ;) it also hides the
;bottom of glass bar with visual junk caused by moving
;contents
;mov bx,320*5

;mov bh,07h ;perfect fitting and -1b
;blacken:
;mov byte[ds:bx],ch;0
;dec bx
;cmp bx,320*194
;jne blacken

;mov bx,320*13-64 ;=4096 = 1000h
;save 2b compared to code above
;could save more if upper black bar gets ignored
;but that shows edges of the glass bar and also
;stars breaking the rays
;it does not give a clean line but since it all is
;black anyway it does not matter that much
mov bh,10h
blacken:
mov byte[ds:bx-320*10-1+64],ch;0
dec bx
jnz blacken

;cx = 0
waiting: mov dx,0x3C9  ;having pal gen here saves overall
         shrd ax,cx,17 ;6b compared to having it on top
         out dx,al ;r  ;and it does not matter
         out dx,al ;g  ;if this gets done and looped
         out dx,al ;b  ;all the time

;         shrd ax,cx,18
;         out dx,al
;         shl ax,1
;         out dx,al
;         xor ax,ax
;         out dx,al

;         xor ax,ax
;         out dx,al
;         shrd ax,cx,17
;         out dx,al
;         shr ax,1
;         out dx,al

;         shrd ax,cx,17
;         out dx,al
;         xor ax,ax
;         out dx,al
;         shrd ax,cx,18
;         out dx,al

         inc cx        ;since it works here (tm)

         in al,60h            ;read keyboard buffer
         dec ax               ;esc needs to be pressed several times
         jnz waiting          ;nothing so go on

breaker: ret                  ;stop!