;evoke/2018
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: inner stare - zero point (original mix)

;about 15000 cycles at dosbox are fine enough

org 100h
use16

start:   push 0a000h
         pop es       ;vga
         push 08000h
         pop gs       ;screen buffer
         mov al,13h
         int 10h

         mov ah,09h      ;print string to vga
         mov dx,text     ;ds needs to be unchanged
         int 21h         ;drop the string

         push 07000h  ;here lies the scaled text
         pop ds

pal:    mov dx,0x3C9   ;green is nice
        shrd ax,cx,19
        out dx,al ;r
        shl al,1
        out dx,al ;g
        shr al,1
        out dx,al ;b

        imul si,cx,2 ;create same data every run
        mul si

        mov word[bp+10+si],ax  ;fills up enough data
        mov word[bp+500+si],ax ;fills up enough data
        loop pal

;clear memory to make it look the same everywhere
;since memory is ?
cls:
mov byte[ds:bx],cl;0
inc bx
jnz cls

;copy text + enlarge it
;also add stripes for design
mov bh,0ah;mov bx,320*8 ;0a00h
copy:
cmp byte[es:bx],ch;0 ;bx-1 needed to avoid error (missing 1st pixel)
                     ;i guess no one would ever have seen this

je ney
mov si,4 ;width
blk1:
imul di,bx,4 ;scale up for propper pos
add di,si
mov cl,4     ;height
blk2:
mov byte[ds:di+320*80],cl;128;cl ;adjust+draw
add di,320
loop blk2
dec si
jnz blk1

ney:

;create bars/lines for design
mov si,di
mov cl,4
bar:
mov byte[ds:bx+si+320*10],cl
sub si,120+335*12*2
loop bar

mov byte[ds:bx+320*59],bl   ;thick bar above text
mov byte[ds:bx+320*121],bl  ;thick bar below text

dec bx
jnz copy


main:

sbb bx,317 ;movement of center of rays
           ;add carry to change path over time
           ;but on one will see that ;)

mov di,400 ;theoretical number of rays*2
rays:
xor dx,dx;mov dx,cx;0
mov ax,di
shr ax,7;cl;8
;inc ax ;never 0
        ;but one won't see a real difference ...
        ;and strangely this inc eats 3b instead of 1
        ;but too lazy to investigate

sbb word[bp+10+di],ax ;change degrees

mov word[bp],cx;0;cx;ax ;beginning at center

mov cl,byte[bp+500+di];size/length of ray
shr cl,1
inc cx ;never 0 to avoid visuals messing up
sub byte[bp+500+di],al ;make rays pop up for 4 bytes

loop1:
fild word[bp+10+di]   ;degrees
fidiv word[cs:103]     ;pi*grad; same as div 57
fsincos
fimul word[bp]   ;sin*x
fistp word[bp+6]
fimul word[bp]   ;cos*x
fistp word[bp+8]

;set 2d pixel
imul si,word[bp+8],319 ;faking perspective
add si,word[bp+6]   ;y*320+x = pos pixel

add si,bx ;include movement

cmp dl,ch;0 ;ray active to be drawn?
jne active

cmp byte[ds:si],ch;0 ;check if ray hits letter/element
je skip              ;does not hit so don't draw
inc dx;inc dl ;activate ray to be drawn

active:
cmp byte[ds:si],ch;0
jne fine ;draw normal if ray is on letter/element
shr dh,cl;2 ;make ray darker if not on a letter/element
            ;cl works just fine as well
fine:

mov al,4 ;different thickness of rays based on number of ray

adc dh,al;4

;make the ray thicker but not as thick like your mom
;ah = 0 here
more:
sub byte[gs:si],dh
jnc neat           ;no color jumps
mov byte[gs:si],ch;0 ;fixed color if carry
neat:
inc si
dec ax
jnz more

skip:
inc word[bp]
loop loop1 ;do full length of ray

dec di
dec di
jnz rays ;do all rays

;slow it down
mov dx, 3dah
;vsync1:     ;not needed for this one
;in al,dx
;test al,8
;jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2

;flip
;cx = di = 0
flip:
mov al,255          ;black
xchg al,byte[gs:di] ;grab+clear vscreen
;mov al,byte[ds:di] ;testing
stosb
imul di,di,57 ;make it crispy. thanks to hellmood.
loop flip

         in al,60h
         dec ax                 ;works - at least most of the time
         jnz main               ;nothing so go on

breaker: ret

text db '-vOk-/2o18[_I_]$' ;using the fact that the string will overwrite
                           ;itself at the grabbing routine. this way it is
                           ;possible to create letters