;corroder
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: nemophila - rise

;well, i had the bg effect in 128b but it felt very bland. something was missing.
;then i started to play around with the concept (different directions and so on),
;but that led to nowhere. i also slapped some moving bars and stuff on top but that did
;not help either. so i thought maybe some text and a few colors might help. so i made
;the frame and added things et voila, nice contrast between the 16 color bg and the front.
;the core is again one of my favourite routines which tweaked with the post processing
;looks fresh enough in 256b.

;this again is one of those intros which i finished but then came back a few times to have
;another look just to find ways to save more bytes. but isn't that the fun of it all?

;now i can go back to digging up those cracktros.

;assuming: ax = bx = 0 cx = 255
;tested under xp, freedos and dosbox (please enable blast processing mkay)

org 100h
use16

bse equ -4               ;base coordinates of the overlay

start:   push 0a000h     ;vga
         pop es
         mov al,13h      ;you know the deal
         int 10h

         mov dx,text     ;ds needs to be unchanged
         mov ah,09h      ;print string to vga
         int 21h         ;so change afterwards

;moving this right into the code using ds for the majority of gs segment
;access saves 1b ... funnily enough by using pop ds instead of pop 08000h
;but 1b is 1b

;         push 08000h     ;buff1 with the effect
;         pop gs
;         push 07000h     ;buff2 with effect post processing
;         pop ds          ;and overlay

;hide text
scanner:
cmp byte[es:bx],ch;0;0
je k
mov byte[es:bx],16;)
k:
inc bx
jnz scanner

mov bp,320 ;save a few along the way
           ;and the stack is not affected since it stays the same
           ;value the whole time

main:

push 08000h     ;use ds for now
pop ds          ;to save 1b each access
                ;at least changing bp above does not
                ;crash here and onwards (tm)
                ;so not the cleanest way but it is 1b

in al,40h
imul bx,ax,1257
dec byte[ds:bx] ;init spot

xor di,di       ;needed
grid:

xor bx,bx
add bl,byte[ds:di] ;don't work with black
jz drop

xor ax,di  ;don't stay 0
           ;al is also kinda rnd because of in al,40h above
mul ah

imul si,ax,357 ;semi rnd

shr si,14   ;0..3
shl si,1 ;word access
mov si,word[cs:dirs+si]

add si,di ;replacing si with eg bp saves no bytes
          ;since si needs to get xor'ed in that case
          ;before scan:

dec bx              ;always change color for shades
stay:
mov byte[ds:si],bl  ;set new pixel
drop:
dec di
jnz grid            ;work with full screen

;mov dx,bx           ;for colored rectangles on the left

shrd dx,bx,19        ;00..31 this is a big benefit in terms of looks
;add dl,70            ;only use the really nice part of the
                     ;standard vga palette
                     ;moved the add dl,xx down to the drawing of
                     ;the blue bar for the text because ...

push ds;08000h  ;this is the 1b money shot ;)
pop gs
push 07000h
pop ds

;moving this whole scan code right below setting a new pixel
;at grid does not create the blooming effect just because the
;whole picture is not drawn yet and all lines would be drawn
;in a different, disruptive order; that would save about 4b.
;and moving the area (since the current pos is max moved 320 .. -320)
;to be processed would cost extra so there is no benefit to see
;si = -320 ... 320 +1 (di)
scan:
cmp byte[gs:si],ch;0?
jne skip2

mov cl,30;32;(1) ;code is 2b smaller
                 ;compared to (1) in rise section

mov al,16        ;start with that color

mov bx,si        ;xor bx,bx is same size
                 ;so [ds:si+bx] is useless
rise:
mov byte[ds:bx],al
;test cl,00000001b;(1)
;jz noh;(1)
jnp noh ;affected/set by dec cx
        ;so change color only every 2nd move
inc ax  ;change color
noh:
sub bx,bp;320
;loop rise;(1)
dec cx
jnz rise

skip2:
inc si
jnz scan

;di = si = cx = 0
;draw the frame
mov al,42 ;save dem b's
mov bx,279
line1:
mov byte[ds:bx+320*9+30+bse],al;42
mov byte[ds:bx+320*149+30+bse],al;42

;mov cx,bx
;shr cx,1
;imul di,cx,320

;test bl,00000001b    ;save 1b compared to
;jnz fine_then        ;code above
;add di,bp
;fine_then:

jnp fine_then         ;cos dec bx affects the parity flag
add di,bp
fine_then:

mov byte[ds:di+30+320*9+bse],al;42
mov byte[ds:di+310+320*9+bse],al;42

dec bx
jnz line1

;bx = cx = si = 0
;draw a stripe for the text
mov bl,186;180 ;adjusted because of the next step

sub dl,bl ;... this is 1b smaller than the add dl,70
          ;and by adjusting bl above slightly it makes no
          ;difference if 70 is added or 186 subtracted

bar2:
mov di,320*11
bar1:
mov byte[ds:di+bx+320*134+99+30+bse-6],54
sub di,bp;320
jnz bar1
dec bx
jnz bar2

;grab hidden text and put it on the stripe
;mov bx,320*8
mov bh,0ah;
texter:
cmp byte[es:bx],cl;0
je kk
mov byte[ds:bx+320*137+193+bse-4*8],95
mov byte[ds:bx+320*137+193-319+bse-4*8],cl ;shadow
kk:
dec bx
jnz texter

;bx = cx = si = di = 0
;not really bars but i was too lazy to change the labels
;but not lazy enough to not write these words
mov cl,19
barr:
mov bl,8
barrr:
mov ax,320*22*5
barrrr:
add di,ax
mov byte[ds:di+bx+25-6+bse-320*6+2],dl;ah;67
dec dx   ;color work
sub di,ax
sub ax,320*22
jnz barrrr
add dl,5 ;restore color for being identical at next loop
dec bx
jnz barrr
add di,bp;320
loop barr

;slow it down
mov dx, 3dah
;vsync1:     ;not needed for this one
;in al,dx
;test al,8
;jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2

;move things to the vga memory
;si = cx = 0
;di = 320*19 from barr
mov ch,0c8h; =320*160
;mov di,320*19
flip:
rep movsb

         in al,60h            ;read keyboard buffer
         dec ax               ;ESC?
         jnz main             ;no, so go on
         ret
         nop                  ;keep it real. trve 256b

dirs dw 320,1,-320,-1
text db 176,177,178,219,'hi2allSzeCdrZ',254,'$'
