;collider / hect!!!c
;sensenstahl & kuemmel
;www.sensenstahl.com
;fasm 1.69.31
;listening: forhist - forhist
;_______________________________________________________

;sensenstahl: idea + game code
;kummel:      sound fx code

;you better select the color of your approaching enemy
;before the crash or you won't get those juicy points!
;1 key control: press your favourite key to change the
;color. But not ESC because that makes you chicken out.

;for each round the player gets a new color assigned
;to make things a bit more fun.

;the original version was 40x25. oddly enough i realized
;too late that the sucker does not run under freedos.
;the other games i made using that mode have (by pure luck)
;the right initial values and also a slower gameplay.
;but in this case you have a very high chance to die
;even before you see the screen after the switch. so
;i changed to 80x25 and adjusted the space between the
;blocks a bit. and then i also added a random player
;color for each new round which makes things a bit
;more interesting. sure i could have tried a workaround
;but i wanted to keep the possibility to restart a new
;game real quick without a lot time wasting. and even
;though it does look very different just because of the
;video mode i think it is a quite fitting entry for
;the nano game compo at lovebyte because this one
;reduces almost everything to its minimum while still
;being some sort of a challenge.

;when the original version was finished i had a lot of
;bytes left and did not really know what to do since
;everything felt wrong given the minimalistic approach
;of the game. so i thought why not ask kuemmel if he
;wants to add sound since our first collab is now a
;few years in the past. he did and it is a nice
;addition, at least outside of freedos :D

;and yeah, short file name for a fast restart.
;___________________________________________________

;assuming ax = 0 cx = 255 bx = 0 text mode 80x25

;used global variables: si = col of player
;                       bx = pos of player
;                       di = pos of enemy
;                       bp = col of enemy

;also uses vsync for constant speed of frames

org 100h
use16

  ;---kuemmel ...sound init
  mov dx,0x331
  mov si,sound_init
  outsb
  dec dx
  mov cl,6    ;init and define 3 instruments
  rep outsb
  ;---

start:   push 0b800h ;textmooooooode
         pop ds
;         mov al,03h  ;set 80*25
;         int 10h     ;but this is assumed to be the case
                      ;because of freedos. and since 80x25
                      ;is also the standard under dos and
                      ;dosbox ...

;this is just for a clean screen in case you dir the shit
;out of your hdd before running
cls:
mov byte[ds:bx],ch;0
inc bx  
jnz cls         

mov byte[ds:1],11  ;frame counter init since i got the bytes

mov dx,7100h ;save a few bytes below
;draw 2 walls/lines for visual purposes only
mov bl,160
fill:
mov word[ds:bx-2+80*2*10],dx;7100h ;plain wall above
mov word[ds:bx-2+80*2*12],dx;7100h ;plain wall below
dec bx
dec bx
jnz fill

;draw initial score on screen
;all that code is reused from my previous games
;never change a running system or so they say. and they know.
mov bl,18
scrz:
mov byte[ds:80*2*13+124+bx+1],dh ;'0' = 48 = 30h / 16*7+1 = 113 = 71h;
dec bx
jnz scrz

;mov cx,1   ;score + 1 so it is shown from the beginning
inc cx     ;cx = 0 from above
jmp addor  ;jump to the score routine + create a new block

next:

  ;---kuemmel ...score !!!
  pusha
  mov dx,0x330
  mov al,10010001b ;play channel 1
  out dx,al
  mov al,60        ;note
  out dx,al
  mov al,127       ;max volume
  out dx,al
  popa
  ;---

;mov cx,30000 ;add cx points to the score into screen buffer
mov ch,7dh ;32000 = 7d00h / -1b
           ;coder score?
addor:

mov al,1 ;indicate that score +1 has to be proceeded

mov bx,9*2;score numbers/digits * 2
          ;bx is player color but since that is set below
          ;bx can be used here

scorehandler:
mov dl,byte[ds:80*2*13+124+bx] ;only grab ascii from screen buffer
cmp al,1                    ;next row is coming so +1, set above
jne fine3
inc dx     ;score +1
cmp dl,"9"
jna fine4  ;no reminder
mov dl,"0" ;reminder
jmp fine3  ;update score
fine4:
mov al,bh  ;no more change
fine3:

mov byte[ds:80*2*13+124+bx],dl ;set new ascii to the screen

dec bx           ;next digit
dec bx           ;next digit
jnz scorehandler
loop addor       ;add up all score

;create color of next enemy and also a new one for the player
nextcolor:
in al,40h
mul ax
shr ah,4           ;col 0-15
inc ah             ;1-16 ;eliminate 0
cmp ah,16          ;cut out 16 since it is so wrong
jae nextcolor
mov al,219         ;solid block
mov bp,ax          ;col of enemy
mov di,80*2*11+124 ;pos of enemy

nextcolor2:
in al,40h
mul ax                    ;random enough i guess
mov bx,ax
shr bh,4                  ;col 0-15
inc bh                    ;1-16 ;eliminate 0
cmp bh,16                 ;cut out 16 since it is so wrong
jae nextcolor2
mov bl,219 ;solid block  ;col of player
mov si,80*2*11+30+2;+16  ;pos of player

main:

dec byte[ds:1]       ;frame handler
jnz allright         ;make cursor colour me beautifull
mov byte[ds:1],11    ;speed, move block down every 10 frames

;move enemy
mov word[ds:di],cx;0 ;delete old enemy
dec di               ;move enemy
dec di

mov word[ds:si],cx;0 ;delete old player
inc si               ;move player
inc si

  ;---kuemmel ...play movement, the closer...the louder
  pusha
  mov dx,0x330
  mov al,10010000b ;play channel 0
  out dx,al
  mov al,60
  out dx,al        ;movement is note height
  mov ax,80*11+20;78  ;calculate volume from 80*11+78 reverse
  sub ax,di
  ;add al,16        ;adjust a bit, so you can hear something from the beginning
  out dx,al        ;and volume
  popa
  ;---

cmp di,si;80*11+10 ;reached pos of player/impact?
jne allright       ;nope, so go on

cmp bx,bp          ;identical color at crash?
je next            ;yes so play sound and add score


;oops
breaker:

  ;---kuemmel ...you die
;  pusha
  mov dx,0x330
  mov al,10010010b ;play channel 2
  out dx,al
  mov al,60        ;note
  out dx,al
  mov al,127       ;max volume
  out dx,al
;  popa
  ;---

ret ;gtfo

allright:

mov word[ds:si],bx ;draw player

mov word[ds:di],bp ;draw enemy

mov dx,3dah     ;wait for vsync for constant speed
vsync1:         ;of the frames
in al,dx
test al,8
jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2


         mov ah,01h
         int 16h
         jz main               ;if no key pressed do nothing

         mov ah,cl;00h         ;key pressed so get the code
         int 16h

         cmp al,27             ;esc
         je breaker            ;bye bye 
                               ;could be skipped due to the
                               ;fast gameplay and the guaranteed
                               ;death

         inc bh                ;color change of player
         cmp bh,15             ;max reached?
         jbe go_on             ;nope
         mov bh,01             ;yes, so reset

go_on:
jmp main
;---kuemmel sound init
   sound_init:
   db 0x3f
   db 11000000b,116 ;channel 0 taiko drum
   db 11000001b, 98 ;channel 1 crystal
   db 11000010b,127 ;channel 2 gunshot
;---
