;*******************************************************************************
;		 512     "-06"
;
;			() ϸ , 2009.
;			  infrachrom@gmail.com
;
;*******************************************************************************
;	  "The Telemark Assembler (TASM) v. 3.2"
;*******************************************************************************
;
; :
; 1. ,  ,  ,  
; 2.   ""     ( )
; 3.    
; 4.       
; 5.   ,   /
;	     (~35 )
; 6. "   
; 7.   ""   
; ...     .
;
; (      0000h)
;*******************************************************************************
; 	  :
; MusOff:    			
; Init:      		
; Fill:      
; Output:   6   
; Color.Fade:   (  )
; Run:  
; Rotate:  
; Bzzzz:  ""  
; DrawLine:  2- ,   
; One.Zero:      
; Dump:   
; Output:   6   
; Eight:   8   
; D.shift:   1  
; L.shift:   1  
; U.shift:   1  
; R.shift:   1  
; Pict00:  
; Pict01:  
; Wait:   
;*******************************************************************************

.ORG 0h

Int00:		di
		xra A
		sta X.Color
		jmp Run

;******************************************************************************	
;    RST 1
;    A --   ""*2
Wait:		ei
		hlt
		hlt
		dcr A
		jnz Wait
		ret		
;******************************************************************************	
;  "  " RST 2
;     
;   100h-200h
Dump:		push H
		lxi H,123h
		xra A
		dcx H
		cmp H
		jnz _dump
		lxi H,193h
_dump:		shld Dump+2
		mov A,M
		add H
		sbb L
		rar
		pop H
		ret
;******************************************************************************
;    
; : C == -
;	E ==    		
DrawLine:	mvi B,2		;  
_snova1:	mvi H,0e0h	; .   
		mov L,E
_snova2:	mov M,C
		inr H
		jnz _snova2
		mov A,E		;     
		cma
		mov E,A
		dcr B
		jnz _snova1
		ret
;*******************************************************************************
;   RST 7
;      
Init:		push PSW
		push B
		push D
		push H
		mvi A,88h
		out 0
int.palitra	lxi H,5000h	;    
		mvi D,10h
Set.Colors:	mov A,D
		out 2
		mov A,M
		out 0ch
		dcx H
		out 0ch
		dcr D
		jnz Set.Colors
		xra A		;    
		out 2
Scroll:		mvi A,0ffh	; 
		out 3
		
		lda Soundrun	;  
		ora a
		jz _exit	;  --  
		inr A		;  
		sta Soundrun	;  
		add A
		add A
		add A
		out 9		;    
		add A
		add A
		out 9

_exit:		lhld Timer	;  
		dcx H
		shld Timer
		
		pop H
		pop D
		pop B
		pop PSW
		ei
		ret
		
Timer:		.Equ 3000h
Soundrun:	.Equ 3003h
;******************************************************************************
;   					
Run:		out 10h
		lxi SP,7000h
		
		call MusOff	;  
		
		lxi D,FreeArea
cls:		stax D		;  
		inx D		;  
		cmp D
		jnz cls
		ei
		hlt		;     		
;*******************************************************************************
;       
Fill:		lxi D,0e001h		;   
_fill0:		lxi B,0
		rst 2			;   
		ora A
		jpe _shift01		; ,   ,
		mvi C,6			;   
_shift01:	lxi H,Pict00
		dad B
		
		mvi A,6			;    
		sta 3001h		;  31 
		mov C,A			;    C
	
_put:		mov A,M
		stax D			;    
		inx H
		inr E
		dcr C
		jnz _put	
		
		inx D			;   
		inx D
		
		xra A			; ,
		cmp D			;      
		jnz _fill0
;*******************************************************************************
;    (  )
Color.Fade:	lxi H,Palitra+16	;   
		shld int.palitra+1
		mvi C,20h
		xra A			;     
_cf1:		hlt
		inr A
		out 9			;   
		inr A
		out 9
		mov B,A
		ani 00111000b		;    
		sta X.Color
		mov A,B
		dcr C
		jnz _cf1
		mvi C,18h
_cf2:		hlt			;     
		dcr A
		out 9			;   
		dcr A
		out 9
		mov B,A
		ani 00111000b
		sta X.Color
		mov A,B
		dcr C
		jnz _cf2
		
		call MusOff	;  
		mvi A,30h
		rst 1		;  
		
;******************************************************************		;   
Rotate:		rst 2		;   
		ani 1fh		;     
		adi 0e0h	; e0-ff   -
		mov D,A
		mvi E,0		
		rst 2		; "" ,  
		rrc		;   
		jnc _rot1
		lxi H,D.shift
		call Eight
		jmp _rot2
_rot1:		lxi H, U.shift
		call Eight
		
_rot2:		rst 2		;   
		ani 0f8h 	;    ,  8
		mov E,A    	;   -
		rst 2		; "" ,  
		rlc      	;   
		jnc _rot4
		mvi D,0e0h
		lxi H,R.shift
		call Eight
_rot3:		jmp _rot5
_rot4:		mvi D,0ffh
		lxi H,L.shift
		call Eight
		
_rot5:		lda 3001h		;  .  
		ora A         		
		jm _timeoff		;  ""   
		in 1			;   ,   /
		cma           		
		ani 0e0h      		
		jz Rotate		; ,     
		              		
_timeoff:	mvi A,18h     		
		rst 1			;  
;*******************************************************************************
;  ""  
Bzzzz:		mvi B,10h		;  ""
		mvi C,20h		;  
		lda Scroll+1
_bzz:		add C			; 
		sta Scroll+1
		out 9
		out 9
		hlt			
		sub C			; 
		sta Scroll+1
		hlt
		dcr C			;  
		dcr B
		jnz _bzz
		call MusOff
;*******************************************************************************
;  ""   
		mvi D,7fh	;   ""
		mvi E,0		;   
_snova0:	mvi C,0ffh
		call DrawLine
		xra A
_snova00:	dcr A
		jnz _snova00	; 
		mov C,A
		call DrawLine
		inr E
		dcr D
		jnz _snova0
						
		jmp 0		; 


.Module L.shift
;*******************************************************************************
;       1 
; HL ==     
L.shift:	mvi B,8		;   ()
_clmn:		push H
		mvi C,20h
_row:		mov A,M
		ral
		mov M,A
		dcr H
		dcr C
		jnz _row
		pop H
		mov A,M
		jc _CY
		ani 0feh
		jmp _write
_CY:		ori 1
_write:		mov M,A
		inr L
		dcr B
		jnz _clmn
		ret
		
.Module R.shift		
;*******************************************************************************
;       1 
; HL ==     			
R.shift:	mvi B,8
_clmn:		push H
		mvi C,20h
_row:		mov A,M
		rar
		mov M,A
		inr H
		dcr C
		jnz _row
		pop H
		mov A,M
		jc _CY
		ani 7fh
		jmp _write
_CY:		ori 80h
_write:		mov M,A
		inr L
		dcr B
		jnz _clmn
		ret
		
.Module U.shift
;*******************************************************************************
;      1 
; HL ==   	
U.shift:	mov C,M
		push H
		pop D
_shift:		dcr L
		mov A,M
		stax D
		dcr E
		jnz _shift
		inr L
		mov M,C
		ret

.Module D.shift
;*******************************************************************************
;      1 
; HL ==   	
D.shift:	mov C,M
		push H
		pop D
_shift:		inr L
		mov A,M
		stax D
		inr E
		jnz _shift
		dcr L
		mov M,C
		ret

;*******************************************************************************
;     
; 8     1    
; :	DE ==   
;	HL ==  -
Eight:		mvi A,0f0h	;   
		sta Soundrun	;    
		shld Shift+2	;     
		xchg		;   DE --   
		mvi C,8		;   
_raz8:		push B
Shift:		push H
		call 0000	;    
		hlt		; 
		pop H
		pop B
		dcr C
		jnz _raz8	; ,   < 8 
		mvi A,8
		rst 1		;  
		ret

;*******************************************************************************
; ,    ( )
Pict00:		.Byte 3ch,66h,76h,6eh,66h,3ch
Pict01:		.Byte 3ch,18h,18h,18h,38h,18h
;*******************************************************************************

;    
MusOff:		mvi A,0b6h
		mvi C,40h
mOff:		out 8
		sub C
		jnc mOff
		xra A
		ret
;*******************************************************************************
		.Byte " PGA-2009"
;*******************************************************************************
Palitra:	.Byte 0		;    ()
X.Color:			;   e000-ffff
FreeArea:			;   

.End
