
''  Keftedes by Optimus

'$INCLUDE: 'fmod.bi'
'$include: "sdl\sdl.bi"


' ---------------------------------

' Only 320*240 and 640*480 are supported
' I have to rewrite some code for the other res. No time..
'
' the high res is recommended
' low res only included for slow computers but still it won't show exactly the same output ;P
'
' Still, you have to set lowres to 1 and recompile for 320*240 :(
' Bore to move the consts and make them variables.

const lowres = 0

const REFRESH = 75

' ---------------------------------

const TNL_TWIDTH = 128
const TNL_THEIGHT = 128
const TNL_TSHIFT = 7

const SCR_WIDTH  = (640 SHR lowres)
const SCR_HEIGHT = (480 SHR lowres)

const LWIDTH = 768 * (SCR_WIDTH / 640)
const LHEIGHT = 768 * (SCR_HEIGHT / 480)

const SB_WIDTH = 64 * (SCR_WIDTH / 640)
const SB_HEIGHT = 64 * (SCR_HEIGHT / 480)

const FX_WIDTH = 256 * (SCR_WIDTH / 640)
const FX_HEIGHT = 256 * (SCR_HEIGHT / 480)
const FX_SHIFT = log(FX_WIDTH) / log(2)

const BLOCK_WIDTH = 8
const BLOCK_HEIGHT = 8
const BLOCK_SHIFT = log(BLOCK_WIDTH) / log(2)

const BLOB_WIDTH = 16
const BLOB_HEIGHT = 16
 
const pi = 3.14151693
const d2r = 180 / pi

const d2b = (1024 * d2r) / 360.0
const sindiv = (1024 * d2r) / 360.0

const d2b0 = (256 * d2r) / 360.0

declare sub setsdl(fullscr%)
declare sub SDL_GetEvents(EscapeVal%)

declare sub init()
declare sub init_fonts()
declare sub init_keftedes(f%)
declare sub init_tunnel()
declare sub init_bump()
declare sub init_radial()
declare sub init_spheremap()
declare sub init_fxzoom()
declare sub init_blob()
declare sub init_energyplasma()
declare sub init_song(asong$)
declare sub script()

declare sub upscroll_line(ln%, txt$, yp%)

declare sub await(sec%)
declare sub ShowFPS(yey%)
declare sub FontWrite(xp%,yp%,text$,nc%,byval framebuffer as uinteger ptr)

declare sub keftedes(byval framebuffer AS uinteger ptr)
declare sub plasmatexture(k1%)
declare sub tunnel(byval framebuffer as uinteger ptr, ra!, zm!)
declare sub bump(byval bumpbuffer as ubyte ptr, byval framebuffer as ubyte ptr, div1!, div2!)
declare sub radial(byval radialbitmap as ubyte ptr, byval framebuffer as uinteger ptr)
declare sub sphere_map(byval spherebuffer as ubyte ptr)
declare sub mirror_sphere(byval tempbuffer as uinteger ptr, byval framebuffer as uinteger ptr, blend%)
declare sub fx_zoom(byval framebuffer as uinteger ptr)

declare sub tunnel_script()
declare sub bump_script()
declare sub radial_script()
declare sub fxzoom_script()
declare sub energy_script()
declare sub keftedes_script()

declare sub draw_blob(byval blobbuffer as ubyte ptr, xc%, yc%, zf!)
declare sub drawblobs(j%)
declare sub blob_screen()
declare sub sine_blobs(j%)
declare sub text_blobs(n%, xp%, yp%, z!, rd%)

declare sub blob_effect1()
declare sub blob_effect2()
declare sub blob_effect3()
    
declare sub energy_plasma(byval energybuffer AS ubyte ptr)
declare sub energy_plasma2(byval energybuffer AS ubyte ptr)
declare sub energy_plasma3(byval energybuffer AS ubyte ptr)

' -------

	dim shared thescreen as SDL_Surface ptr

    dim shared part% = 5

    dim shared result as unsigned integer
    dim shared framebuffer AS uinteger ptr
    dim shared asong AS INTEGER

    dim shared starting_time%, primary_time%   ' fx time

    dim shared fonts(22015) as ubyte, cc(255) as ubyte
   
    dim shared fps%, mo%, kk%, atime%

    dim shared flp% = 0
    dim shared xit% = 0

' ------- Effect variables

' Tunnel
   dim shared fsin1%(-1024 TO 2047), fsin2%(-1024 TO 2047), fsin3%(-1024 TO 2047)
   dim shared coloop%(0 to 255)
   
   dim shared tunnel_texture%(TNL_TWIDTH * TNL_THEIGHT - 1)

   dim shared dist(SCR_WIDTH * SCR_HEIGHT * 4 - 1) as ubyte
   dim shared angle(SCR_WIDTH * SCR_HEIGHT * 4 - 1) as ubyte

   dim shared k1%
   dim shared trn1! = 2, trn2! = 1

' Bump
    dim shared bump_bitmap(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared fnlbump_bitmap(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared r_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared g_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared b_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared lightmap(LWIDTH * LHEIGHT - 1) as ubyte


' Radial
    dim shared radial_bitmap(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared radial_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte

    dim shared radir0(SCR_WIDTH * SCR_HEIGHT - 1) as short
    dim shared radir1(SCR_WIDTH * SCR_HEIGHT - 1) as short
    dim shared radir2(SCR_WIDTH * SCR_HEIGHT - 1) as short

    dim shared radir3(SCR_WIDTH * SCR_HEIGHT - 1) as short
    dim shared radir4(SCR_WIDTH * SCR_HEIGHT - 1) as short
    dim shared radir5(SCR_WIDTH * SCR_HEIGHT - 1) as short

' Sphere mapping
    dim shared sph_bitmap(SB_WIDTH * SB_HEIGHT - 1) as ubyte
    dim shared temp_bitmap(SB_WIDTH * SB_HEIGHT) as ubyte
    dim shared sph_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    
    dim shared sph_prec(SCR_WIDTH * SCR_HEIGHT - 1) as ushort
    dim shared sph_area(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared temp_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as uinteger

    dim shared mulmod2_x(SCR_WIDTH - 1) as ushort
    dim shared mulmod4_x(SCR_WIDTH - 1) as ushort
    dim shared mulmod8_x(SCR_WIDTH - 1) as ushort
    dim shared mulmod16_x(SCR_WIDTH - 1) as ushort

    dim shared mulmod2_y(SCR_HEIGHT - 1) as ushort
    dim shared mulmod4_y(SCR_HEIGHT - 1) as ushort
    dim shared mulmod8_y(SCR_HEIGHT - 1) as ushort
    dim shared mulmod16_y(SCR_HEIGHT - 1) as ushort

    dim shared clamp255(511) as ubyte

    dim shared blend% = 0

' FX zoom
    dim shared fx_block(BLOCK_WIDTH * BLOCK_HEIGHT - 1) as ubyte
    dim shared zoom%(0 to SCR_WIDTH - 1)
    
    dim shared psin1(4095) as ubyte
    dim shared psin2(4095) as ubyte
    dim shared psin3(4095) as ubyte
    dim shared psin4(4095) as ubyte

    dim shared p_angle(FX_WIDTH * FX_HEIGHT - 1) as ubyte
    dim shared p_radius(FX_WIDTH * FX_HEIGHT - 1) as ubyte

    dim shared zmon% = 0

' Blob particle
    dim shared blob(BLOB_WIDTH * BLOB_HEIGHT - 1)
    dim shared blob_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte

    dim shared blobtext_x(1023, 2) as ubyte
    dim shared blobtext_y(1023, 2) as ubyte

    dim shared morph0_x(1023) as integer
    dim shared morph0_y(1023) as integer
    dim shared morph0_z(1023) as single

    dim shared morph1_x(1023) as integer
    dim shared morph1_y(1023) as integer
    dim shared morph1_z(1023) as single

' Energy plasma
    dim shared angle4(SCR_WIDTH * SCR_HEIGHT * 4 - 1) as ubyte
    dim shared radius4(SCR_WIDTH * SCR_HEIGHT * 4 - 1) as ubyte

    dim shared energy_buffer(SCR_WIDTH * SCR_HEIGHT - 1) as ubyte
    dim shared rsin1(4095) as ubyte

' Keftedes
    dim shared skyfade(SCR_HEIGHT - 1) as single
    dim shared secsnd as ubyte

    dim shared fpson% = 0

' ----------------------------------------------

	result = SDL_Init(SDL_INIT_EVERYTHING)
	if result <> 0 then
  		end 1
	end if

    'SCREENRES SCR_WIDTH, SCR_HEIGHT, 32, 2, 0, REFRESH
    'framebuffer = SCREENPTR

    init


' ------------------    MAIN    ----------------

    starting_time% = SDL_GetTicks()
	do
        framebuffer = thescreen->pixels

        SDL_GetEvents xit%

       SDL_LockSurface thescreen

        primary_time% = (SDL_GetTicks()) - starting_time%
        script
        ShowFPS fpson%

        SDL_Flip thescreen

        SDL_UnlockSurface thescreen

    kk% = kk% + 1

	loop while inkey$<>chr$(27) AND xit% = 0

    FMUSIC_StopSong(asong)
    FSOUND_Close

    SDL_Quit
    end


sub SDL_GetEvents(EscapeVal%)

dim event as SDL_Event
dim keycode as integer

	WHILE (SDL_PollEvent(@event))
		keycode=event.key.keysym.sym
      select case event.type

         case SDL_QUIT_:
            EscapeVal = -1

         case SDL_KEYDOWN:
            select case keycode
               case SDLK_ESCAPE:
                  EscapeVal = -1
               case SDLK_f:
                  if fpson% = 1 then fpson% = 0 else fpson% = 1
               case else
                  'keys(keycode)=-1
            end select

         case SDL_KEYUP:
            'keys(keycode)=0
      end select
   WEND

end sub

' --------------    SCRIPT  ----------------

sub script()

    dim buffer as uinteger ptr
    dim tbuffer as uinteger ptr

    select case part%

case 0
     keftedes framebuffer
     keftedes_script


case 1

    ra! = sin(primary_time% / 1024) * 512
    zm! = primary_time% / 256

    tunnel framebuffer, ra!, zm!
    tunnel_script

case 2
    bump_script

    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        r_buffer(i%) = 0: g_buffer(i%) = 0: b_buffer(i%) = 0
    next i%

    i% = 0
    for y% = 0 to SCR_HEIGHT - 1
        for x% = 0 to SCR_WIDTH - 1
            c% = coloop%((psin4(x%) + psin3(y% + psin4(x% + y% + (primary_time SHR 5))) + psin4(y% + psin2(x% + (primary_time% SHR 4)))) AND 255)
           fnlbump_bitmap(i%) = coloop%((bump_bitmap(i%) + c%) AND 255)
           i% = i% + 1
        next x%
    next y%

    bump @fnlbump_bitmap(0), @r_buffer(0), 967.0, 1212.0
    bump @fnlbump_bitmap(0), @g_buffer(0), 856.0, 1100.0
    bump @fnlbump_bitmap(0), @b_buffer(0), 1300.0, 640.0

    buffer = framebuffer
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        *buffer = (r_buffer(i%) SHL 16) OR (g_buffer(i%) SHL 8) OR b_buffer(i%)
        buffer = buffer + 1
    next i%

case 3
    radial_script

    sphere_map @sph_buffer(0)
    tbuffer = @temp_buffer(0)
    radial @sph_buffer(0), tbuffer
    mirror_sphere tbuffer, framebuffer, blend%

case 4
    fxzoom_script
    fx_zoom framebuffer

case 5
    blob_screen

case 6
    energy_script
    energy_plasma @energy_buffer(0)
    
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        blob_buffer(i%) = 0
    next i%
    blob_effect1

    buffer = framebuffer
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        r% = 255 - energy_buffer(i%)
        g% = blob_buffer(i%) SHR 1
        b% = (blob_buffer(i%) SHR 1) + (energy_buffer(i%) SHR 1)
        *buffer = (r% SHL 16) OR (g% SHL 8) OR b%
        buffer = buffer + 1
    next i%

case 7
    energy_script
    energy_plasma2 @energy_buffer(0)
    
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        blob_buffer(i%) = 0
    next i%
    blob_effect2

    buffer = framebuffer
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        r% = (energy_buffer(i%) SHR 1) + (blob_buffer(i%) SHR 1)
        g% = blob_buffer(i%)
        b% = (r% SHR 1) + (energy_buffer(i%) SHR 1)
        *buffer = (r% SHL 16) OR (g% SHL 8) OR b%
        buffer = buffer + 1
    next i%
case 8
    energy_script
    energy_plasma3 @energy_buffer(0)
    
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        blob_buffer(i%) = 0
    next i%
    blob_effect3

    buffer = framebuffer
    for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        r% = 96 + (blob_buffer(i%) SHR 1) + (energy_buffer(i%) SHR 2)
        g% = 32 + (energy_buffer(i%) SHR 2) + (blob_buffer(i%) SHR 2)
        b% = (128 - (blob_buffer(i%) SHR 1)) SHR 1
        *buffer = (r% SHL 16) OR (g% SHL 8) OR b%
        buffer = buffer + 1
    next i%
case else

    end select

end sub



' --------------    INIT    ----------------

sub setsdl(fullscr%)
	thescreen = SDL_SetVideoMode( SCR_WIDTH, SCR_HEIGHT, 32, SDL_SWSURFACE OR fullscr%)
	if thescreen = 0 then
		SDL_Quit
		end 1
	end if
end sub


sub init()

?:? "Initializing.."
?
    init_fonts
    init_tunnel
    init_bump
    init_radial
    init_spheremap
    init_fxzoom
    init_blob
    init_energyplasma
    init_keftedes(32768)
    init_song("whoronzon_gohonzon.xm")

    ?:?:?
11  input "FPS display? (Y/N)";fls$
    if fls$ = "y" or fls$ = "Y" then fpson% = 1 else if fls$ = "n" or fls$ = "N" then else print "I don't understand.. ;P": goto 11
?

10  input "Fullscreen? (Y/N)";fls$
    if fls$ = "y" or fls$ = "Y" then setsdl SDL_FULLSCREEN: SDL_ShowCursor SDL_DISABLE: await 3 else if fls$ = "n" or fls$ = "N" then setsdl 0 else print "I don't understand.. ;P": goto 10

    FMUSIC_PlaySong (asong)
    secsnd = 0

end sub


sub init_fonts()

    ? "    Loading fonts";

    open "fonts16.bin" for binary as #1

    for i% = 0 to 255
        get #1, ,cc(i%)
    next i%

    for i% = 0 to 22015
        get #1, ,fonts(i%)
    next i%

    close #1
    ? "  Ok."
    ?
end sub

sub init_song(asong$)

    ?:?:? "    Loading song!";

    FSOUND_Init(48000, 8, 0)

    asong = FMUSIC_LoadSong(asong$)
    IF asong = 0 THEN
        PRINT "  Error: Failed to load '" + asong$ +"' !!!"
        FSOUND_Close
        sleep
        END
    END IF

    FMUSIC_SetLooping(asong, 1)
    
    ? "  Ok."
end sub


sub init_tunnel()

    ?:? "    Tunnel init..";

   FOR i% = -1024 TO 2048
      fsin1%(i%) = SIN(i% / 20) * 106
      fsin2%(i%) = SIN(i% / 32) * 64 + SIN(i% / 64) * 64
      fsin3%(i%) = SIN(i% / 24) * 92
   NEXT i%

   for i%=0 to 127
      coloop%(i%) = i% SHL 1
   next i%
   
   for i%=128 to 255
      coloop%(i%) = (255-i%) SHL 1
   next i%

   v%=3: w%=256: i%=0
   
   for y%=-SCR_HEIGHT to SCR_HEIGHT-1
      for x%=-SCR_WIDTH to SCR_WIDTH-1
         dist(i%)=((w%*TNL_TWIDTH) * (1/sqr(x%^2+y%^2))) AND (TNL_TWIDTH-1)
         angle(i%)=(v%*TNL_TWIDTH*atan2(y,x)/pi) AND (TNL_THEIGHT-1)
         i%=i%+1
      next x%
   next y%

    'plasmatexture 0

    ? "  Ok."
end sub


sub init_bump()

    ?:? "    Bump init..";

	for i% = SCR_WIDTH + 1 to SCR_WIDTH * SCR_HEIGHT - SCR_WIDTH - 2
        bump_bitmap(i%) = rnd * 192 + 63
    next i%

    for j% = 0 to 2
        for i% = SCR_WIDTH + 1 to SCR_WIDTH * SCR_HEIGHT - SCR_WIDTH - 2
            bump_bitmap(i%) = (bump_bitmap(i% - 1) + bump_bitmap(i% + 1) + bump_bitmap(i% - SCR_WIDTH) + bump_bitmap(i% + SCR_WIDTH)) SHR 2
        next i%
    next j%

    ubersize% = 384

	   i% = 0
	   for y% = -LHEIGHT / 2 to LHEIGHT / 2 - 1
	       for x% = -LWIDTH / 2 to LWIDTH / 2 - 1
	           dist% = ubersize% - sqr(x% * x% + y% * y%) * (ubersize / (LWIDTH / 2.5))
	           if dist% < 0 then dist% = 0
	           if dist% > 255 then dist% = 255
               lightmap(i%) = dist%
	           i% = i% + 1
            next x%
        next y%

    ? "  Ok."
end sub


sub init_radial()

    ?:? "    Radial blur init..";

    rb_shortness! = 4.0

    i% = 0
    for y% = 0 to SCR_HEIGHT - 1
        for x% = 0 to SCR_WIDTH - 1
            xi% = -(x% / rb_shortness!)
            yi% = -(y% / rb_shortness!)
            
            xc% = (x% - (SCR_WIDTH SHR 1))
            yc% = (y% - (SCR_HEIGHT SHR 1))
            r! = (SCR_WIDTH * 38.4) / (x% ^ 2 + y% ^ 2)
            if r! < 0 then r! = 0
            if r! > 4 then r! = 4
            
            xi% = xi% * r!
            yi% = yi% * r!

            radir0(i%) = (xi% SHR 1) + (yi% SHR 1) * SCR_WIDTH
            radir1(i%) = (xi% SHR 2) + (yi% SHR 2) * SCR_WIDTH
            radir2(i%) = (xi% SHR 3) + (yi% SHR 3) * SCR_WIDTH
            i% = i% + 1
        next x%
    next y%

    i% = 0
    for y% = 0 to SCR_HEIGHT - 1
        for x% = 0 to SCR_WIDTH - 1
            xi% = -(x% / rb_shortness!)
            yi% = y% / rb_shortness!

            xc% = (x% - (SCR_WIDTH SHR 1))
            yc% = (y% - (SCR_HEIGHT SHR 1))
            r! = (SCR_WIDTH * 38.4) / (x% ^ 2 + y% ^ 2)
            if r! < 0 then r! = 0
            if r! > 4 then r! = 4
            
            xi% = xi% * r!
            yi% = yi% * r!

            radir3(i%) = (xi% SHR 1) + (yi% SHR 1) * SCR_WIDTH
            radir4(i%) = (xi% SHR 2) + (yi% SHR 2) * SCR_WIDTH
            radir5(i%) = (xi% SHR 3) + (yi% SHR 3) * SCR_WIDTH
            i% = i% + 1
        next x%
    next y%

    ? "  Ok."
end sub


sub init_spheremap()

    ?:? "    Sphere map init..";

    i% = 0
    for y% = 0 to SB_HEIGHT - 1
        for x% = 0 to SB_WIDTH - 1
            xc% = x% - (SB_WIDTH SHR 1)
            yc% = y% - (SB_HEIGHT SHR 1)
            c% = ((SCR_WIDTH * SCR_HEIGHT) SHR 4) / (xc%^2 + yc%^2)
            if c% < 0 then c% = 0
            if c% > 255 then c% = 255
            if xc% = 0 and yc% = 0 then c% = 255
            sph_bitmap(i%) = c%
            i% = i% + 1
        next x%
    next y%

    w! = 1

    i% = 0
    for y% = 0 to SCR_HEIGHT - 1
        for x% = 0 to SCR_WIDTH - 1
            xc% = x% - (SCR_WIDTH SHR 1)
            yc% = y% - (SCR_HEIGHT SHR 1)
            r! = (((SCR_WIDTH * SCR_HEIGHT) SHR 3) - xc%^2 - yc%^2)
            z! = sqr(r!) / ((SCR_WIDTH * SCR_HEIGHT) / (4096 SHR lowres))

            if z! > w! then
                u% = (xc% / z!) AND (SB_WIDTH - 1)
                v% = (yc% / z!) AND (SB_HEIGHT - 1)
                sph_area(i%) = 1
            else
               u% = SB_WIDTH
               v% = SB_HEIGHT
            end if

            sph_prec(i%) = u% + v% * SB_WIDTH
            i% = i% + 1
        next x%
    next y%

    for i% = 0 to SCR_WIDTH - 1
        mulmod2_x(i%) = (i% SHL 1) MOD (SCR_WIDTH - 1)
        mulmod4_x(i%) = (i% SHL 2) MOD (SCR_WIDTH - 1)
        mulmod8_x(i%) = (i% SHL 3) MOD (SCR_WIDTH - 1)
        mulmod16_x(i%) = (i% SHL 4) MOD (SCR_WIDTH - 1)
    next i%

    for i% = 0 to SCR_HEIGHT - 1
        mulmod2_y(i%) = (i% SHL 1) MOD (SCR_HEIGHT - 1)
        mulmod4_y(i%) = (i% SHL 2) MOD (SCR_HEIGHT - 1)
        mulmod8_y(i%) = (i% SHL 3) MOD (SCR_HEIGHT - 1)
        mulmod16_y(i%) = (i% SHL 4) MOD (SCR_HEIGHT - 1)
    next i%

    for i% = 0 to 511
        c% = i%: if c% > 255 then c% = 255
        clamp255(i%) = c%
    next i%

    ? "  Ok."
end sub

sub init_fxzoom()

    ?:? "    fxzoom init..";
    randomize 8086

    i% = 0
    for y% = 0 to BLOCK_HEIGHT - 1
        for x% = 0 to BLOCK_WIDTH - 1
            fx_block(i%) = ((x% XOR y%) + rnd * 256) AND (BLOCK_WIDTH - 1)
            i% = i% + 1
        next x%
    next y%

    for i% = 0 to 4095
        psin1(i%) = sin(i% / sindiv) * 63.0 + 64.0
        psin2(i%) = sin(i% / (sindiv SHR 1)) * 127.0 + 128.0
        psin3(i%) = sin(i% / (sindiv SHR 2)) * 47.0 + 48.0
        psin4(i%) = sin(i% / (sindiv SHR 3)) * 95.0 + 96.0
    next i%

    i% = 0
    for y% = 0 to FX_HEIGHT - 1
        for x% = 0 to FX_WIDTH - 1
            xc% = x% - (FX_WIDTH SHR 1)
            yc% = y% - (FX_HEIGHT SHR 1)
            p_radius(i%) = sqr(xc% ^ 2 + yc% ^ 2)
            p_angle(i%) = atan2(xc%, yc%) * d2b
            i% = i% + 1
        next x%
    next y%

    ? "  Ok."
end sub


sub init_blob()

    ?:? "    blob init..";
    
    i% = 0
    for y% = 0 to BLOB_HEIGHT - 1
        for x% = 0 to BLOB_WIDTH - 1
            xc% = x% - (BLOB_WIDTH SHR 1)
            yc% = y% - (BLOB_HEIGHT SHR 1)

            dist% = xc% ^ 2 + yc% ^ 2
            if dist% = 0 then dist% = 1
            c% = (65536)/ (dist% * dist%)
            if c% > 255 then c% = 255
            blob(i%) = c%

            i% = i% + 1
        next x%
    next y%


    for n% = 0 to 2
        f$ = "blobtxt" + str$(n%) + ".bin"

        open f$ for binary as #1
            for i% = 0 to 1023
                get #1, ,blobtext_x(i%, n%)
                get #1, ,blobtext_y(i%, n%)
            next i%
        close #1
    next n%

    ? "  Ok."
end sub


sub init_energyplasma()

    ?:? "    energy plasma init..";

    i% = 0
    for y% = 0 to ((SCR_HEIGHT SHL 1) - 1)
        for x% = 0 to ((SCR_WIDTH SHL 1) - 1)
            xc% = x% - SCR_WIDTH
            yc% = y% - SCR_HEIGHT
            radius4(i%) = sqr(xc% ^ 2 + yc% ^ 2)
            angle4(i%) = (atan2(xc% , yc%) * d2b0)
            i% = i% + 1
        next x%
    next y%

    for i% = 0 to 4095
        rsin1(i%) = sin(i% / d2b0) * 63.0 + 64.0
    next i%

    ? "  Ok."
end sub


sub init_keftedes(f%)

    for y% = 0 to SCR_HEIGHT - 1
        yc% = y% - (SCR_HEIGHT SHR 1)
        skyfade(y%) = (yc% ^ 2) / f%
        if skyfade(y%) > 1 then skyfade(y%) = 1
    next y%

end sub

' --------------------  EFFECTS ------------------


sub upscroll_line(ln%, txt$, yp%)
    ap% =  (2 - lowres)
    xcc% = (SCR_WIDTH SHR 2) * (1 - lowres)
    leng% = len(txt$)

    FontWrite (xcc% + SCR_WIDTH * ((20 - leng%) * (0.0125 * (1 + lowres))), (256 + ln% * 16) * ap% - yp%, txt$, leng%, framebuffer)
end sub

sub keftedes_script()

    select case primary_time%

    case 8192 to 12287

    fd% = ((12287 - primary_time%) SHR 4)
    FMUSIC_SetMasterVolume(asong, fd%)

    case 12288 to 16383

    if secsnd = 0 then 
        FMUSIC_StopSong(asong)
        asong = FMUSIC_LoadSong("skygreen.xm")
        FMUSIC_PlaySong (asong)
        secsnd = 1
    end if

    fd% = ((primary_time% - 12288) SHR 4)
    FMUSIC_SetMasterVolume(asong, fd%)


    case 21504 to 65536 + 20479 + 1024 + 256

    yp% = (primary_time% - 21504) / (16 SHL lowres)

    upscroll_line 0, "Optimus", yp%
    upscroll_line 1, "presented", yp%
    upscroll_line 2, "a freebasic demo", yp%

    upscroll_line 3, "called", yp%
    upscroll_line 4, "KEFTEDES", yp%

    upscroll_line 6, "for the ultimate", yp%
    upscroll_line 7, "freebasic democompo", yp%
    upscroll_line 8, "organized by AAP", yp%

    upscroll_line 11, "Harsh netcafe work", yp%
    upscroll_line 12, "Lame coding", yp%
    upscroll_line 13, "ugly refresh", yp%
    upscroll_line 14, "just effects", yp%
    upscroll_line 16, "Sorry..", yp%

    upscroll_line 17, "I was planning more", yp%
    upscroll_line 18, "but real life", yp%
    upscroll_line 19, "caught me :P", yp%


    upscroll_line 23, "What should I", yp%
    upscroll_line 24, "write here?", yp%

    upscroll_line 26, "I'll write about", yp%
    upscroll_line 27, "the refresh:", yp%
    upscroll_line 29, "It did really", yp%
    upscroll_line 30, "dissapoint me", yp%
    upscroll_line 31, "finishing a demo", yp%
    upscroll_line 32, "with such ugly sync", yp%
    upscroll_line 33, "but the compo said", yp%
    upscroll_line 34, "that only GFXLIB2", yp%
    upscroll_line 35, "is allowed and I", yp%
    upscroll_line 36, "had to use this", yp%
    upscroll_line 37, "instead of SDL", yp%

    upscroll_line 40, "It looks similar", yp%
    upscroll_line 41, "to TinyPTC in speed", yp%
    upscroll_line 42, "and technique.", yp%
    upscroll_line 43, "But for some reasons", yp%
    upscroll_line 44, "vsync produced even", yp%
    upscroll_line 45, "uglier results", yp%
    upscroll_line 46, "and some attempts", yp%
    upscroll_line 47, "for double buffering", yp%
    upscroll_line 48, "failed too..", yp%

    upscroll_line 50, "Perhaps it was me", yp%
    upscroll_line 51, "who did something", yp%
    upscroll_line 52, "wrong :(", yp%

    upscroll_line 53, "Possibly I will", yp%
    upscroll_line 54, "make an SDL port", yp%
    upscroll_line 55, "when I'll release", yp%
    upscroll_line 56, "the final of this", yp%

    upscroll_line 60, "It's time for the", yp%
    upscroll_line 63, "GREETINGS", yp%
    upscroll_line 64, "---------", yp%

    upscroll_line 66, "The Hardliner", yp%
    upscroll_line 67, "AAP, Relsoft", yp%
    upscroll_line 68, "Toshi, Qasir", yp%
    upscroll_line 69, "Plasma, Lithium", yp%
    upscroll_line 70, "Antoni Gual", yp%
    upscroll_line 71, "Texel, midiclub", yp%
    upscroll_line 72, "Stanz, S-tec", yp%
    upscroll_line 73, "Antitec, AkumaX", yp%
    upscroll_line 74, "Expert, Tsoustis", yp%
    upscroll_line 75, "Sotsoft and", yp%
    upscroll_line 76, "everyone else", yp%
    upscroll_line 77, "I forgot..", yp%

    upscroll_line 80, "The music you", yp%
    upscroll_line 81, "are just listening", yp%
    upscroll_line 82, "is also written by", yp%
    upscroll_line 83, "The Hardliner", yp%

    upscroll_line 85, "The effects are", yp%
    upscroll_line 86, "ports of my late", yp%
    upscroll_line 87, "C codings.", yp%
    upscroll_line 88, "So, don't worry", yp%
    upscroll_line 89, "people. I haven't", yp%
    upscroll_line 90, "been pwned by basic", yp%
    upscroll_line 91, "again. Modern PC code", yp%
    upscroll_line 92, "will follow soon.", yp%

    upscroll_line 93, "However,I'd be still", yp%
    upscroll_line 94, "hot for paleolithic", yp%
    upscroll_line 95, "pure Quickbasic", yp%
    upscroll_line 96, "democoding", yp%
    upscroll_line 97, "in the near future", yp%
    upscroll_line 98, "Who knows???", yp%

    upscroll_line 100, "PC, GP32 and 8bit", yp%
    upscroll_line 101, "demos are in the", yp%
    upscroll_line 102, "process too..", yp%
    upscroll_line 104, "..at least if real", yp%
    upscroll_line 105, "life permits :P", yp%
    upscroll_line 106, "Hard days for", yp%
    upscroll_line 107, "demomaking, so", yp%
    upscroll_line 108, "expect nothing", yp%
    upscroll_line 109, "from me soon :/", yp%

    upscroll_line 120, "10 E", yp%

    case 65536 + 20480 + 1024 + 256 to 65536 + 24575

    fd% = ((65536 + 24576 - primary_time%) SHR 4)
    FMUSIC_SetMasterVolume(asong, fd%)

    ffd! = fd% / 256
    for y% = 0 to SCR_HEIGHT - 1
        if skyfade(y%) > ffd! then skyfade(y%) = ffd!
    next y%

   upscroll_line 120, "10 E", (65536 + 20479 + 1024 + 256 - 21504)  / (16 SHL lowres)

    case else
        if primary_time% > 65536 + 24576 + 2048 then xit% = 1
    end select

end sub


sub keftedes(byval framebuffer as uinteger ptr)
dim buffer as uinteger ptr

    buffer = framebuffer
	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1
			c% = (((x% - (SCR_WIDTH SHR 1)) / (y% - (SCR_HEIGHT SHR 1))) * primary_time%) AND 255
			*buffer = c% * skyfade(y%)
			buffer = buffer + 1
		next x%
	next y%

end sub


sub tunnel_script()

    k1% = sin(primary_time% / 1024) * 128
    plasmatexture k1%

    select case primary_time%

    case 0 to 767
    y0% = primary_time% * (TNL_THEIGHT / 767)
    for y% = y0% to TNL_THEIGHT - 1
        for x% = 0 to TNL_TWIDTH - 1
            tunnel_texture%(x% + (y% SHL TNL_TSHIFT)) = 0
        next x%
    next y%

    case 12288 to 14335 - 1024
    xp% = (primary_time% - 12288) / (5.5 * (lowres * 0.2 + 1))
    FontWrite (xp% - 128, 64 / (lowres + 1), "Code", 4, framebuffer)

    case 14336 - 1024 to 15359
    FontWrite ((14336 - 1024 - 12288) / (5.5 * (lowres * 0.2 + 1)) - 128, 64 / (lowres + 1), "Code", 4, framebuffer)
    xp% = (primary_time% - (14336 - 1024)) / (6.5 * (lowres * 0.2 + 1))
    FontWrite (SCR_WIDTH + 128 - xp%, SCR_HEIGHT - (64 + 16) / (lowres + 1), "Optimus", 7, framebuffer)

    case 15360 to 16128
    FontWrite ((14336 - 1024 - 12288) / (5.5 * (lowres * 0.2 + 1)) - 128, 64 / (lowres + 1), "Code", 4, framebuffer)
    FontWrite (SCR_WIDTH + 128 - (15359 - (14336 - 1024)) / (6.5 * (lowres * 0.2 + 1)), SCR_HEIGHT - (64 + 16) / (lowres + 1), "Optimus", 7, framebuffer)

    case 16128 to 17619
    yp% = (primary_time% - 16128) / (7 * (lowres + 1))
    FontWrite ((14336 - 1024 - 12288) / (5.5 * (lowres * 0.2 + 1)) - 128, 64 / (lowres + 1) - yp%, "Code", 4, framebuffer)
    FontWrite (SCR_WIDTH + 128 - (15359 - (14336 - 1024)) / (6.5 * (lowres * 0.2 + 1)), SCR_HEIGHT - (64 + 16) / (lowres + 1), "Optimus", 7, framebuffer)

    case 17620 to 18431
    yp% = (primary_time% - 17620) / (7 * (lowres + 1))
    FontWrite (SCR_WIDTH + 128 - (15359 - (14336 - 1024)) / (6.5 * (lowres * 0.2 + 1)), SCR_HEIGHT - (64 + 16) / (lowres + 1) + yp%, "Optimus", 7, framebuffer)




    case 12288 + 6244 to 14335 - 1024 + 6244 
    xp% = (primary_time% -(12288 + 6244)) / (4.6 * (lowres * 0.1 + 1))
    FontWrite (xp% - 192, SCR_HEIGHT - (64 + 16) / (lowres + 1), "Music", 5, framebuffer)

    case 14336 - 1024 + 6244  to 15359 + 6244
    FontWrite ((14336 - 1024 + 6244  - (12288 + 6244)) / (4.6 * (lowres * 0.1 + 1)) - 192, SCR_HEIGHT - (64 + 16) / (lowres + 1), "Music", 5, framebuffer)
    xp% = (primary_time% - (14336 - 1024 + 6244 )) / (5.8 * (lowres * 0.0 + 1))
    FontWrite (SCR_WIDTH + 128 - xp%, 64 / (lowres + 1), "The Hardliner", 13, framebuffer)

    case 15360 + 6244  to 16128 + 6244
    FontWrite ((14336 - 1024 + 6244 - (12288 + 6244)) / (4.6 * (lowres * 0.1 + 1)) - 192, SCR_HEIGHT - (64 + 16) / (lowres + 1), "Music", 5, framebuffer)
    FontWrite (SCR_WIDTH + 128 - (15359 + 6244 - (14336 - 1024 + 6244)) / (5.8 * (lowres * 0.0 + 1)), 64 / (lowres + 1), "The Hardliner", 13, framebuffer)

    case 16128 + 6244 to 17619 + 6244
    yp% = (primary_time% - (16128 + 6244)) / (7 * (lowres + 1))
    FontWrite ((14336 - 1024 + 6244 - (12288 + 6244)) / (4.6 * (lowres * 0.1 + 1)) - 192, SCR_HEIGHT - (64 + 16) / (lowres + 1) + yp%, "Music", 5, framebuffer)
    FontWrite (SCR_WIDTH + 128 - (15359 + 6244 - (14336 - 1024 + 6244)) / (5.8 * (lowres * 0.0 + 1)), 64 / (lowres + 1), "The Hardliner", 13, framebuffer)

    case 17620 + 6244 to 18431 + 6244
    yp% = (primary_time% - (17620 + 6244)) / (7 * (lowres + 1))
    FontWrite (SCR_WIDTH + 128 - (15359 + 6244 - (14336 - 1024 + 6244)) / (5.8 * (lowres * 0.0 + 1)), 64 / (lowres + 1) - yp%, "The Hardliner", 13, framebuffer)

    case 24676 to 25599
    x0% = (25599 - primary_time%) * (TNL_TWIDTH / 923)
    for y% = 0 to TNL_THEIGHT - 1
        for x% = x0% to TNL_TWIDTH - 1
            tunnel_texture%(x% + (y% SHL TNL_TSHIFT)) = 0
        next x%
    next y%

    case else
        if primary_time% > 25599 then starting_time% = SDL_GetTicks(): part% = 2
    end select

end sub

sub tunnel(byval framebuffer as uinteger ptr, ra!, zm!)
    dim buffer as uinteger ptr
    
 	tx% = SCR_WIDTH / 2 + sin(primary_time% / 2000) * (SCR_WIDTH / 2 - 1)
 	ty% = SCR_HEIGHT / 2 + sin(primary_time% / 1700) * (SCR_HEIGHT / 2 - 1)
 	i% = tx% + ty% * (SCR_WIDTH * 2)

    buffer = framebuffer

    zm% = zm! * 128: ra% = ra!

    for y%=0 to SCR_HEIGHT-1
        for x%=0 to SCR_WIDTH-1
            c% = tunnel_texture%(((dist(i%) + zm%) AND (TNL_TWIDTH - 1)) + (((angle(i%) + ra%) AND (TNL_THEIGHT - 1)) SHL TNL_TSHIFT))
            i% = i% + 1
            *buffer = c%
            buffer = buffer + 1
        next x%
        i% = i% + SCR_WIDTH
    next y%

end sub


sub plasmatexture(k1%)

   FOR y% = 0 TO TNL_THEIGHT \ 2 - 1
      t1% = fsin2%(y%)
      t2% = fsin3%(y% + k1%)
         FOR x% = 0 TO TNL_TWIDTH / 2 - 1
            r% = coloop%((fsin1%(x%) + t1% + fsin2%(x% + k1% + fsin3%(x% + t2%)) + t2%) AND 255)
            g% = coloop%((fsin3%(x%) + t1% + fsin2%(x% + k1% + fsin1%(x% + t2%)) + t2%) AND 255)
            b% = coloop%((fsin2%(x%) + t1% + fsin1%(x% + k1% + fsin3%(x% + t2%)) + t2%) AND 255)
            tunnel_texture%(x% + (y% SHL TNL_TSHIFT)) = (r% SHL 16) OR (g% SHL 8) OR b%: tunnel_texture%(TNL_TWIDTH - x% - 1 + (y% SHL TNL_TSHIFT)) = (r% SHL 16) OR (g% SHL 8) OR b%
         NEXT x%
   NEXT y%

   FOR y% = TNL_THEIGHT / 2 TO TNL_THEIGHT - 1
      t1% = fsin2%(TNL_THEIGHT - y%)
      t2% = fsin3%(TNL_THEIGHT - y% + k1%)
         FOR x% = 0 TO TNL_TWIDTH / 2 - 1
            r% = coloop%((fsin1%(x%) + t1% + fsin2%(x% + k1% + fsin3%(x% + t2%)) + t2%) AND 255)
            g% = coloop%((fsin3%(x%) + t1% + fsin2%(x% + k1% + fsin1%(x% + t2%)) + t2%) AND 255)
            b% = coloop%((fsin2%(x%) + t1% + fsin3%(x% + k1% + fsin1%(x% + t2%)) + t2%) AND 255)
            tunnel_texture%(x% + (y% SHL TNL_TSHIFT)) = (r% SHL 16) OR (g% SHL 8) OR b%: tunnel_texture%(TNL_TWIDTH - x% - 1 + (y% SHL TNL_TSHIFT)) = (r% SHL 16) OR (g% SHL 8) OR b%
         NEXT x%
   NEXT y%

end sub



sub bump_script()

    select case primary_time%

    case else
        if primary_time% > 14336 - 1024 - 384 + 64 then starting_time% = SDL_GetTicks(): part% = 3
    end select

end sub

sub bump(byval bumpbuffer as ubyte ptr, byval framebuffer as ubyte ptr, div1!, div2!)

    dim buffer as ubyte ptr
    dim bitmap as ubyte ptr

	lx% = (SCR_WIDTH SHR 1) + sin(primary_time% / div1!) * (SCR_WIDTH SHR 1)
	ly% = (SCR_HEIGHT SHR 1) + sin(primary_time% / div2!) * (SCR_WIDTH SHR 1)
    
	rx% = lx% - (LWIDTH SHR 1)
	ry% = ly% - (LHEIGHT SHR 1)

 	lx0% = 0: lx1% = LWIDTH: ly0% = 4: ly1% = LHEIGHT - 4

 	limx0% = 0: limx1% = SCR_WIDTH - LWIDTH: limy0% = 0: limy1% = SCR_HEIGHT - LHEIGHT

 	if rx% > limx1% then lx1% = lx1% - (rx% - limx1%)
 	if rx% < limx0% then lx0% = lx0% + (limx0% - rx%)

 	if ry% > limy1% then ly1% = ly1% - (ry% - limy1%)
 	if ry% < limy0% then ly0% = ly0% + (limy0% - ry%)

    buffer = framebuffer + rx% + lx0% + (ry% + ly0%) * SCR_WIDTH
    bitmap = bumpbuffer

    for y% = ly0% to ly1% - 1
        yry% = (y% + ry%) * SCR_WIDTH
        ym1ry% = (y% - 1 + ry%) * SCR_WIDTH
        yp1ry% = (y% + 1 + ry%) * SCR_WIDTH
        for x% = lx0% to lx1% - 1

            nx% = *(bitmap + rx% + x% - 1 + yry%) - *(bitmap + rx% + x% + 1 + yry%)
            ny% = *(bitmap + rx% + x% + ym1ry%) - *(bitmap + rx% + x% + yp1ry%)

            nx% = abs((rx% + x% - (LWIDTH SHR 1)) - lx% + nx%)
            ny% = abs((ry% + y% - (LHEIGHT SHR 1)) - ly% + ny%)

            if nx% > LWIDTH - 1 then nx% = LWIDTH - 1
            if ny% > LHEIGHT - 1 then ny% = LHEIGHT - 1

            *buffer = lightmap(nx% + ny% * LWIDTH)
            buffer = buffer + 1
        next x%
        buffer = buffer + (SCR_WIDTH + lx0% - lx1%)
    next y%

end sub


sub radial_script()

    select case primary_time%
        
    case 12240 + 512 to 24479
        blend% = 1

    case else
        if primary_time% > 24480 + 768 + 64 + 32 then starting_time% = SDL_GetTicks(): part% = 4
    end select

end sub

sub radial(byval radialbitmap as ubyte ptr, byval framebuffer as uinteger ptr)

    dim buffer as uinteger ptr
    dim rad_bitmap as ubyte ptr

    rad_bitmap = radialbitmap
	for i% = 0 to SCR_WIDTH * SCR_HEIGHT - 1
        radial_buffer(i%) = *rad_bitmap
        rad_bitmap = rad_bitmap + 1
    next i%

    dcx% = sin(primary_time% / 573.0) * (SCR_WIDTH SHR 1)
    dcy% = sin(primary_time% / 912.0) * (SCR_HEIGHT SHR 1)

    dcx% = 0
    dcy% = 0

    dci% = dcx% + dcy% * SCR_WIDTH


' 1o tetarthmorio

 	buffer = framebuffer + ((SCR_WIDTH SHR 1) - 1) + ((SCR_HEIGHT SHR 1) - 1) * SCR_WIDTH + dci%

	i% = ((SCR_WIDTH SHR 1) - 1) + ((SCR_HEIGHT SHR 1) - 1) * SCR_WIDTH + dci%
	ri% = 0
    for y% = ((SCR_HEIGHT SHR 1) - 1 + dcy%) to 0 step -1
        for x% = ((SCR_WIDTH SHR 1) - 1 + dcx%) to 0 step -1
            radial_buffer(i%) = (radial_buffer(i%) + radial_buffer(i% - radir0(ri%)) + radial_buffer(i% - radir1(ri%)) + radial_buffer(i% - radir2(ri%))) SHR 2
            c% = radial_buffer(i%)
            *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
            buffer = buffer - 1
            i% = i% - 1
            ri% = ri% + 1
        next x%
        i% = i% - (SCR_WIDTH SHR 1) + dcx%
        ri% = ri% + (SCR_WIDTH SHR 1) - dcx%
        buffer = buffer - (SCR_WIDTH SHR 1) + dcx%
    next y%
    
    
' 2 tetarthmorio

 	buffer = framebuffer + (SCR_WIDTH SHR 1) + ((SCR_HEIGHT SHR 1)-1) * SCR_WIDTH + dci%

	i% = (SCR_WIDTH SHR 1) + ((SCR_HEIGHT SHR 1)-1) * SCR_WIDTH + dci%
	ri% = 0
    for y% = ((SCR_HEIGHT SHR 1) - 1 + dcy%) to 0 step -1
        for x% = ((SCR_WIDTH SHR 1) + dcx%) to SCR_WIDTH - 1
            radial_buffer(i%) = (radial_buffer(i%) + radial_buffer(i% + radir3(ri%)) + radial_buffer(i% + radir4(ri%)) + radial_buffer(i% + radir5(ri%))) SHR 2
            c% = radial_buffer(i%)
            *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
            buffer = buffer + 1
            i% = i% + 1
            ri% = ri% + 1
        next x%
        i% = i% - 3 * (SCR_WIDTH SHR 1) + dcx%
        ri% = ri% + (SCR_WIDTH SHR 1) + dcx%
        buffer = buffer - 3 * (SCR_WIDTH SHR 1) + dcx%
    next y%


' 3 tetarthmorio

	buffer = framebuffer + (SCR_WIDTH SHR 1) + (SCR_HEIGHT SHR 1) * SCR_WIDTH + dci%

	i% = (SCR_WIDTH SHR 1) + (SCR_HEIGHT SHR 1) * SCR_WIDTH + dci%
	ri% = 0
    for y% = (SCR_HEIGHT SHR 1) + dcy% to SCR_HEIGHT - 1
        for x% = (SCR_WIDTH SHR 1) + dcx% to SCR_WIDTH - 1
            radial_buffer(i%) = (radial_buffer(i%) + radial_buffer(i% + radir0(ri%)) + radial_buffer(i% + radir1(ri%)) + radial_buffer(i% + radir2(ri%))) SHR 2
            c% = radial_buffer(i%)
            *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
            buffer = buffer + 1
            i% = i% + 1
            ri% = ri% + 1
        next x%
        i% = i% + (SCR_WIDTH SHR 1) + dcx%
        ri% = ri% + (SCR_WIDTH SHR 1) + dcx%
        buffer = buffer + (SCR_WIDTH SHR 1) + dcx%
    next y%


' 4o tetarthmorio

	buffer = framebuffer + ((SCR_WIDTH SHR 1) - 1) + (SCR_HEIGHT SHR 1) * SCR_WIDTH + dci%

	i% = ((SCR_WIDTH SHR 1)-1) + (SCR_HEIGHT SHR 1) * SCR_WIDTH + dci%
	ri% = 0
    for y% = (SCR_HEIGHT SHR 1) + dcy% to SCR_HEIGHT - 1
        for x% = ((SCR_WIDTH SHR 1) - 1) + dcx% to 0 step -1
            radial_buffer(i%) = (radial_buffer(i%) + radial_buffer(i% - radir3(ri%)) + radial_buffer(i% - radir4(ri%)) + radial_buffer(i% - radir5(ri%))) SHR 2
            c% = radial_buffer(i%)
            *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
            buffer = buffer - 1
            i% = i% - 1
            ri% = ri% + 1
        next x%
        i% = i% + 3 * (SCR_WIDTH SHR 1) + dcx%
        ri% = ri% + (SCR_WIDTH SHR 1) - dcx%
        buffer = buffer + 3 * (SCR_WIDTH SHR 1) + dcx%
    next y%

end sub


sub sphere_map(byval spherebuffer as ubyte ptr)

dim buffer as ubyte ptr

    i% = 0
    for y% = 0 to SB_HEIGHT - 1
        for x% = 0 to SB_WIDTH - 1
            xb% = (x% + sin(primary_time% / 1512.0) * (SCR_WIDTH SHR 1)) AND (SB_WIDTH - 1)
            yb% = (y% + sin(primary_time% / 2048.0) * (SCR_HEIGHT SHR 1)) AND (SB_HEIGHT - 1)
            bi% = xb% + yb% * SB_WIDTH
            temp_bitmap(i%) = sph_bitmap(bi%)
            i% = i% + 1
        next x%
    next y%


    buffer = spherebuffer
    i% = 0
	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1
			c% = temp_bitmap(sph_prec(i%))
            i% = i% + 1
			*buffer = c%
			buffer = buffer + 1
		next x%
	next y%

end sub


sub mirror_sphere(byval tempbuffer as uinteger ptr, byval framebuffer as uinteger ptr, blend%)

    dim buffer as uinteger ptr
    dim tbuffer as uinteger ptr

    buffer = framebuffer
    tbuffer = tempbuffer

    select case blend%

    case 0

        for y% = 0 to SCR_HEIGHT - 1
            for x% = 0 to SCR_WIDTH - 1
                d1% = x% + y% * SCR_WIDTH
                z1% = (*(tbuffer + d1%)) AND 255
                c% = z1%
                if sph_area(d1%) = 1 then goto 50
                d2% = mulmod2_x(x%) + mulmod2_y(y%) * SCR_WIDTH
                z2% = (*(tbuffer + d2%)) AND 255
                z02% = clamp255(z1% + z2%)
                c% = z02%

                if sph_area(d2%) = 1 then goto 50
                d4% = mulmod4_x(x%) + mulmod4_y(y%) * SCR_WIDTH
                z4% = (*(tbuffer + d4%)) AND 255
                z04% = clamp255(z02% + z4%)
                c% = z04%

                if sph_area(d4%) = 1 then goto 50
                d8% = mulmod8_x(x%) + mulmod8_y(y%) * SCR_WIDTH
                z8% = (*(tbuffer + d8%)) AND 255
                z08% = clamp255(z04% + z8%)
                c% = z08%

                if sph_area(d8%) = 1 then goto 50
                z16% = (*(tbuffer + (mulmod16_x(x%) + mulmod16_y(y%) * SCR_WIDTH))) AND 255
                z016% = clamp255(z08% + z16%)
                c% = z016%

                50
                *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
                buffer = buffer + 1
            next x%
        next y%

    case 1

        for y% = 0 to SCR_HEIGHT - 1
            for x% = 0 to SCR_WIDTH - 1
                z1% = (*(tbuffer + x% + y% * SCR_WIDTH)) AND 255
                z2% = (*(tbuffer + (mulmod2_x(x%) + mulmod2_y(y%) * SCR_WIDTH))) AND 255
                z4% = (*(tbuffer + (mulmod4_x(x%) + mulmod4_y(y%) * SCR_WIDTH))) AND 255
                z8% = (*(tbuffer + (mulmod8_x(x%) + mulmod8_y(y%) * SCR_WIDTH))) AND 255
                z16% = (*(tbuffer + (mulmod16_x(x%) + mulmod16_y(y%) * SCR_WIDTH))) AND 255
            
                c% = z1% + (z2% SHR 1) + (z4% SHR 2) + (z8% SHR 3) + (z16% SHR 4)
                if c% > 255 then c% = 255
                
                *buffer = (c% SHL 16) OR (c% SHL 8) OR c%
                buffer = buffer + 1
            next x%
        next y%


    case else
    end select

end sub


sub fxzoom_script()

    select case primary_time%
        
    case 25344 to 50688 + 8192 - 1024
        zmon% = 1

    case else
        if primary_time% > 50688 + 8192 - 1024 then starting_time% = SDL_GetTicks(): part% = 6
    end select

end sub


sub energy_script()

    select case primary_time%
        
    case 12240 / 2 to (12240 / 2 + 128) * 2 - 1
        part% = 7

    case (12240 / 2 + 128) * 2 to (12240 / 2 + 128) * 3
        part% = 8

    case else
        if primary_time% > (12240 / 2 + 128) * 3 then starting_time% = SDL_GetTicks(): part% = 0
    end select

end sub

    

sub fx_zoom(byval framebuffer as uinteger ptr)

    dim buffer as uinteger ptr
    buffer = framebuffer
    i% = 0

    hack% = (640 - SCR_WIDTH) / 320

    zf! = sin(((primary_time% - 25344) * zmon%) / 2048.0) * 2 + 2.5

    for i% = 0 to SCR_WIDTH - 1
        zoom%(i%) = (i% * zf!)
    next i%
    
    px% = (sin(primary_time% / 1748.0) * 1024.0) SHR hack%
    py% = (sin(primary_time% / 1212.0) * 1024.0) SHR hack%

    si% = (primary_time% SHR 2) AND 1023

	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1

            xz% = zoom%(x%) + px%
            yz% = zoom%(y%) + py%

            xb% = (xz% SHR FX_SHIFT) AND (BLOCK_WIDTH - 1)
            yb% = (yz% SHR FX_SHIFT) AND (BLOCK_HEIGHT - 1)

            xi% = xz% AND (FX_WIDTH - 1)
            yi% = yz% AND (FX_HEIGHT - 1)

			c% = fx_block(xb% + (yb% SHL BLOCK_SHIFT))
            cc% = ((xb% + (yb% SHL BLOCK_SHIFT)) * (512 / (BLOCK_WIDTH * BLOCK_HEIGHT)) AND 255)
            cc1% = (cc% SHL 1) AND 255
            cc2% = (cc% SHL 2) AND 255

            select case c%

                case 0
                    r% = (cc1% - 255) SHR 1
                    g% = cc2% SHR 1
                    b% = coloop%(((psin1(xi%) + psin2(yi%) + psin3(xi% + yi% + si%) + psin4(xi%)) SHL lowres) AND 255)
                case 1
                    r% = 127
                    g% = coloop%((psin1(xi%) + psin2(yi%) + psin3(xi% + yi% + si%) + psin4(xi% + psin2(xi% + yi% + si%))) AND 255)
                    b% = 255 - cc2%
                case 2
                    r% = ((cc1% SHR 2) + (cc2% SHR 1) + (coloop%((psin4(xi% + psin1(yi% + si%))) AND 255) SHR 2))
                    g% = cc2%
                    b% = (coloop%((psin2(xi% + yi% + psin3(yi% + si%))) AND 255))
                case 3
                    r% = coloop%((psin1(xi% + psin4(yi% + si% + psin1(xi% + si%))) + cc%) AND 255)
                    g% = coloop%((psin2(yi% + psin3(xi% + si% + psin2(xi% + si%))) + cc1%) AND 255)
                    b% = coloop%((psin4(xi% + psin2(yi% + si%+ psin3(xi% + si%))) + cc2%) AND 255)
                case 4
                    ri% = xi% + (yi% SHL FX_SHIFT)
                    r% = cc2%
                    g% = coloop%((psin2(p_radius(ri%) + si% + psin3(p_angle(ri%) + si%)) + p_angle(ri%) + si%) AND 255)
                    b% = cc%
                case 5
                    ri% = xi% + (yi% SHL FX_SHIFT)
                    r% = cc2%
                    g% = coloop%((p_radius(ri%) + si% + psin4(xi% + psin2(yi% + si%) + psin3(p_angle(ri%) + si%))) AND 255)
                    b% = (cc2% SHR 1) + (coloop%((p_radius(ri%) + si% + psin4(xi% + psin3(p_angle(ri%) + si%))) AND 255) SHR 1)
                case 6
                    r% = 128 + (cc2% SHR 1)
                    g% = coloop%((((xi% + psin1(yi% + si%)) XOR (yi% + psin2(xi% + si%))) SHL lowres) AND 255)
                    b% = (255 - cc2%)
                case 7
                    r% = coloop%(((xi% * yi%) + si%) AND 255)
                    g% = coloop%(((xi% XOR yi%) + si%) AND 255)
                    b% = cc%
                case else
            end select

            i% = i% + 1
			*buffer = (r% SHL 16) OR (g% SHL 8) OR b%
			buffer = buffer + 1
		next x%
	next y%

end sub


sub draw_blob(byval blobbuffer as ubyte ptr, xc%, yc%, zf!)

    dim buffer as ubyte ptr

    x0% = 0: y0% = 0
    x1% = (BLOB_WIDTH * zf! - 1)
    y1% = (BLOB_HEIGHT * zf! - 1)

    for i% = 0 to x1%
        zoom%(i%) = (i% / zf!)
    next i%

    xi% = xc% - ((BLOB_WIDTH SHR 1) * zf!)
    yi% = yc% - ((BLOB_HEIGHT SHR 1) * zf!)

    if xi% > SCR_WIDTH - 1 or yi% > SCR_HEIGHT - 1 then goto 30
    if xi% <= -(BLOB_WIDTH * zf!)  or yi% <= -(BLOB_HEIGHT * zf!) then goto 30

    if xi% < 0 then x0% = - xi%: xi% = 0
    if yi% < 0 then y0% = - yi%: yi% = 0

    if xi% > (SCR_WIDTH - (BLOB_WIDTH * zf!)) then x1% = SCR_WIDTH - xi% - 1
    if yi% > (SCR_HEIGHT - (BLOB_HEIGHT * zf!)) then y1% = SCR_HEIGHT - yi% - 1

    di% = xi% + yi% * SCR_WIDTH

    buffer = blobbuffer + di%

	for y% = y0% to y1%
		for x% = x0% to x1%
			c% = *buffer + blob((zoom%(x%) AND (BLOB_WIDTH - 1)) + (zoom%(y%) AND (BLOB_HEIGHT - 1)) * BLOB_WIDTH)
            if c% > 255 then c% = 255
            *buffer = c%
			buffer = buffer + 1
		next x%
        buffer = buffer - (x1% - x0% + 1) + SCR_WIDTH
	next y%
30
end sub


sub blob_screen()
    dim buffer as uinteger ptr

    dim div42(1023) as ubyte
    for i% = 0 to 1023
        div42(i%) = i% / 4.2
    next i%

    for i% = SCR_WIDTH + 1 to SCR_WIDTH * SCR_HEIGHT - SCR_WIDTH - 2
        blob_buffer(i%) = div42((blob_buffer(i% - 1) + blob_buffer(i% + 1) + blob_buffer(i% - SCR_WIDTH) + blob_buffer(i% + SCR_WIDTH)))
    next i%


    select case primary_time%

    case 0 to 4095
        k% = primary_time% / 4
        if k% > 1023 then k% = 1023
        sine_blobs k%
        drawblobs k%

    case 4096 to 8191
        sine_blobs 1023
        drawblobs 1023

    case 8192 to 12287
        text_blobs 0, 64 / (lowres + 1), 192 / (lowres + 1), 9 / (lowres + 1), 16 / (lowres + 1)
        for i% = 0 to 1023
            morph0_x(i%) = morph0_x(i%) + ((primary_time% - 8192) * (morph1_x(i%) - morph0_x(i%))) / 4096
            morph0_y(i%) = morph0_y(i%) + ((primary_time% - 8192) * (morph1_y(i%) - morph0_y(i%))) / 4096
            morph0_z(i%) = morph0_z(i%) + ((primary_time% - 8192) * (morph1_z(i%) - morph0_z(i%))) / 4096
        next i%
        drawblobs 1023

    case 12288 to 20479
        xp% = (primary_time% - 12288) / 3
        text_blobs 0, 64 / (lowres + 1), 192 / (lowres + 1), 9 / (lowres + 1), 16 / (lowres + 1)
        for i% = 0 to 1023
            morph0_x(i%) = morph1_x(i%)
            morph0_y(i%) = morph1_y(i%)
            morph0_z(i%) = morph1_z(i%)
        next i%
        drawblobs 1023

        text_blobs 1, SCR_WIDTH + BLOB_WIDTH - xp% / (lowres + 1), 96 / (lowres + 1), 32 / (lowres + 1), 8 / (lowres + 1)
        for i% = 0 to 1023
            morph0_x(i%) = morph1_x(i%)
            morph0_y(i%) = morph1_y(i%)
            morph0_z(i%) = morph1_z(i%)
        next i%
        drawblobs 1023

    case 20480 to 24575
        text_blobs 0, 64 / (lowres + 1), 192 / (lowres + 1), 9 / (lowres + 1), 16 / (lowres + 1)
        for i% = 0 to 1023
            morph0_x(i%) = morph1_x(i%)
            morph0_y(i%) = morph1_y(i%)
            morph0_z(i%) = morph1_z(i%)
        next i%

        text_blobs 2, 10 / (lowres + 1), 192 / (lowres + 1), 10 / (lowres + 1), 0

        for i% = 0 to 1023
            morph0_x(i%) = morph0_x(i%) + ((primary_time% - 20480) * (morph1_x(i%) - morph0_x(i%))) / 4096
            morph0_y(i%) = morph0_y(i%) + ((primary_time% - 20480) * (morph1_y(i%) - morph0_y(i%))) / 4096
            morph0_z(i%) = morph0_z(i%) + ((primary_time% - 20480) * (morph1_z(i%) - morph0_z(i%))) / 4096
        next i%
        drawblobs 1023

    case 24576 to 24576 + 1023 - 32
        text_blobs 2, 10 / (lowres + 1), 192 / (lowres + 1), 10 / (lowres + 1), 0
        for i% = 0 to 1023
            morph0_x(i%) = morph1_x(i%)
            morph0_y(i%) = morph1_y(i%)
            morph0_z(i%) = morph1_z(i%)
        next i%
        drawblobs 1023

    case 24576 + 1024 - 32 to 32767 + 1024 + 1024 + 128
        tremble% = (primary_time% - 24576) / 8
        text_blobs 2,  10 / (lowres + 1), 192 / (lowres + 1), 10 / (lowres + 1), tremble%
        for i% = 0 to 1023
            morph0_x(i%) = morph1_x(i%)
            morph0_y(i%) = morph1_y(i%)
            morph0_z(i%) = morph1_z(i%)
        next i%
        drawblobs 1023

    case else
        if primary_time% > (32767 + 2048 + 128 + 3144) then starting_time% = SDL_GetTicks(): part% = 1
    end select


    for i% = 0 to SCR_WIDTH - 1
        blob_buffer(i%) = 0
        blob_buffer(SCR_WIDTH * SCR_HEIGHT -1 - i%) = 0
    next i%

    radial @blob_buffer(0), framebuffer

end sub


sub blob_effect1()
    for i% = 0 to 255
        r! = sin((i% + (primary_time% SHR 6)) / (d2b0 / 4)) * 0.2 + sin((i% + (primary_time% SHR 4)) / (d2b0 / 12)) * 0.2 + (sin((primary_time% SHR 1) / d2b) * 0.3 + 0.2)
        xi% = (0.75 + r!) * sin(i% / d2b0) * (SCR_WIDTH / 2.5) + (SCR_WIDTH SHR 1)
        yi% = (0.75 + r!) * cos(i% / d2b0) * (SCR_HEIGHT / 2.5) + (SCR_HEIGHT SHR 1)
        z! = (sin((i% + (primary_time% SHR 5)) / 8) + 1.5) / (1 + lowres)
        draw_blob @blob_buffer(0), xi%, yi%, z!
    next i%
end sub


sub blob_effect2()
    for i% = 0 to 255
        r! = sin((i% + (primary_time% SHR 6)) / (d2b0 / 4)) * 0.2 + sin((i% + (primary_time% SHR 4)) / (d2b0 / 12)) * 0.2 + sin((i% + (primary_time% SHR 5)) / (d2b0 / 6)) * 0.2 + (sin((primary_time% SHR 1) / d2b) * 0.3 + 0.2)
        xi% = (0.75 + r!) * sin(i% / d2b0) * (SCR_WIDTH / 2.5) + (SCR_WIDTH SHR 1)
        yi% = (0.75 + r!) * cos(i% / d2b0) * (SCR_HEIGHT / 2.5) + (SCR_HEIGHT SHR 1)
        z! = (sin((i% + (primary_time% SHR 5)) / 8) + 1.5) / (1 + lowres)
        draw_blob @blob_buffer(0), xi%, yi%, z!
    next i%
end sub


sub blob_effect3()
    for i% = 0 to 255
        r! = (i% / 128) + (sin((primary_time% SHR 1) / d2b) * 0.3 + 0.2)
        xi% = r! * sin(i% / (d2b0 / 4)) * (SCR_WIDTH / 2.5) + (SCR_WIDTH SHR 1)
        yi% = r! * cos(i% / (d2b0 / 4)) * (SCR_HEIGHT / 2.5) + (SCR_HEIGHT SHR 1)
        z! = (sin((i% + (primary_time% SHR 5)) / 8) + 1.5) / (1 + lowres)
        draw_blob @blob_buffer(0), xi%, yi%, z!
    next i%
end sub


sub drawblobs(j%)
    for i% = 0 to j%
        draw_blob @blob_buffer(0), morph0_x(i%), morph0_y(i%), morph0_z(i%)
    next i%
end sub


sub sine_blobs(j%)
    for i% = 0 to j%
        xi% = sin((primary_time% + (i% SHL 3)) / 1024) * (SCR_WIDTH / 2.5) + (SCR_WIDTH SHR 1)
        yi% = sin((primary_time% + (i% SHL 4)) / 1400) * (SCR_HEIGHT / 2.5) + (SCR_HEIGHT SHR 1)
        z! = sin((primary_time% + (i% SHL 2)) / 512) * (0.5 / (lowres + 1))+ (1.0 / (lowres + 1))
        morph0_x(i%) = xi%: morph0_y(i%) = yi%: morph0_z(i%) = z!
    next i%
end sub


sub text_blobs(n%, xp%, yp%, z!, rd%)
    for i% = 0 to 1023
        xi% = blobtext_x(i%, n%) * z! + xp% + (rnd * rd% - rd% / 2)
        yi% = blobtext_y(i%, n%) * z! + yp% + (rnd * rd% - rd% / 2)
        zb! = 0.25 + rnd / 2
        morph1_x(i%) = xi%: morph1_y(i%) = yi%: morph1_z(i%) = zb!
    next i%
end sub

sub energy_plasma(byval energybuffer AS ubyte ptr)
    dim buffer as ubyte ptr

    x1% = (SCR_WIDTH SHR 1) + sin(primary_time% / 512) * (SCR_WIDTH / 3)
    y1% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 768) * (SCR_HEIGHT / 3)
    d1% = SCR_WIDTH - x1% + (SCR_HEIGHT - y1%) * (SCR_WIDTH SHL 1)

    x2% = (SCR_WIDTH SHR 1) + sin(primary_time% / 1024) * (SCR_WIDTH / 3)
    y2% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1512) * (SCR_HEIGHT / 3)
    d2% = SCR_WIDTH - x2% + (SCR_HEIGHT - y2%) * (SCR_WIDTH SHL 1)

    x3% = (SCR_WIDTH SHR 1) + sin(primary_time% / 768) * (SCR_WIDTH / 3)
    y3% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1224) * (SCR_HEIGHT / 3)
    d3% = SCR_WIDTH - x3% + (SCR_HEIGHT - y3%) * (SCR_WIDTH SHL 1)


    buffer = energybuffer
	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1
            c1% = rsin1(angle4(i% + d1%) SHL 3) + radius4(i% + d1%)
            c2% = rsin1(angle4(i% + d2%) SHL 3) + radius4(i% + d2%)
            c3% = rsin1(angle4(i% + d3%) SHL 3) + radius4(i% + d3%)
			c% = ((*buffer AND 255) + coloop((c1% + c2% + c3%) AND 255)) SHR 1
			*buffer = c% AND 255
			buffer = buffer + 1
            i% = i% + 1
		next x%
        i% = i% - SCR_WIDTH + (SCR_WIDTH SHL 1)
	next y%

end sub


sub energy_plasma2(byval energybuffer AS ubyte ptr)
    dim buffer as ubyte ptr

    x1% = (SCR_WIDTH SHR 1) + sin(primary_time% / 512) * (SCR_WIDTH / 3)
    y1% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 768) * (SCR_HEIGHT / 3)
    d1% = SCR_WIDTH - x1% + (SCR_HEIGHT - y1%) * (SCR_WIDTH SHL 1)

    x2% = (SCR_WIDTH SHR 1) + sin(primary_time% / 1024) * (SCR_WIDTH / 3)
    y2% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1512) * (SCR_HEIGHT / 3)
    d2% = SCR_WIDTH - x2% + (SCR_HEIGHT - y2%) * (SCR_WIDTH SHL 1)

    x3% = (SCR_WIDTH SHR 1) + sin(primary_time% / 768) * (SCR_WIDTH / 3)
    y3% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1224) * (SCR_HEIGHT / 3)
    d3% = SCR_WIDTH - x3% + (SCR_HEIGHT - y3%) * (SCR_WIDTH SHL 1)


    buffer = energybuffer
	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1
            c1% = rsin1(angle4(i% + d1%) SHL 2) + rsin1(radius4(i% + d1%) SHL 1)
            c2% = rsin1(angle4(i% + d2%) SHL 2) + rsin1(radius4(i% + d2%) SHL 1)
            c3% = rsin1(angle4(i% + d3%) SHL 2) + rsin1(radius4(i% + d3%) SHL 1)
			c% = ((*buffer AND 255) + coloop((c1% + c2% + c3%) AND 255)) SHR 1
			*buffer = c% AND 255
			buffer = buffer + 1
            i% = i% + 1
		next x%
        i% = i% - SCR_WIDTH + (SCR_WIDTH SHL 1)
	next y%

end sub


sub energy_plasma3(byval energybuffer AS ubyte ptr)
    dim buffer as ubyte ptr

    x1% = (SCR_WIDTH SHR 1) + sin(primary_time% / 512) * (SCR_WIDTH / 3)
    y1% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 768) * (SCR_HEIGHT / 3)
    d1% = SCR_WIDTH - x1% + (SCR_HEIGHT - y1%) * (SCR_WIDTH SHL 1)

    x2% = (SCR_WIDTH SHR 1) + sin(primary_time% / 1024) * (SCR_WIDTH / 3)
    y2% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1512) * (SCR_HEIGHT / 3)
    d2% = SCR_WIDTH - x2% + (SCR_HEIGHT - y2%) * (SCR_WIDTH SHL 1)

    x3% = (SCR_WIDTH SHR 1) + sin(primary_time% / 768) * (SCR_WIDTH / 3)
    y3% = (SCR_HEIGHT SHR 1) + sin(primary_time% / 1224) * (SCR_HEIGHT / 3)
    d3% = SCR_WIDTH - x3% + (SCR_HEIGHT - y3%) * (SCR_WIDTH SHL 1)


    buffer = energybuffer
	for y% = 0 to SCR_HEIGHT-1
		for x% = 0 to SCR_WIDTH-1
            c1% = angle4(i% + d1%) SHL 4
            c2% = angle4(i% + d2%) SHL 4
            c3% = angle4(i% + d3%) SHL 4
			c% = (((*buffer SHR 16) AND 255) + coloop((c1% + c2% + c3%) AND 255)) SHR 1
			*buffer = c% AND 255
			buffer = buffer + 1
            i% = i% + 1
		next x%
        i% = i% - SCR_WIDTH + (SCR_WIDTH SHL 1)
	next y%

end sub


' --------------------  OTHER ------------------

sub FontWrite(xp%,yp%,text$,nc%,byval framebuffer as uinteger ptr)

dim buffer as uinteger ptr
dim r, g, b as ubyte

buffer = framebuffer + yp% * SCR_WIDTH + xp%

    for n% = 1 to nc%
        gama% = asc(mid$(text$, n%, 1))
        for y% = 0 to 15
            yi% = yp% + y%: if yi% <0 or yi% > SCR_HEIGHT - 1 then goto 70
            for x% = 0 to 15
                xi% = xp% + ((n% - 1) SHL 4) + x%: if xi% < 0 or xi% > SCR_WIDTH - 1 then goto 80
                c% = fonts((y% SHL 4) + x% + (cc(gama%) SHL 8)) SHL 4
                v! = 1.0 - c% / 255.0
                r = ((*buffer AND &H00FF0000) SHR 16) * v! + c%
                g = ((*buffer AND &H0000FF00) SHR 8) * v! + c%
                b = (*buffer AND &H000000FF) * v! + c%
                *buffer = (r SHL 16) OR (g SHL 8) OR b
                80
                buffer = buffer + 1
            next x%
            buffer = buffer - 16
            70
            buffer = buffer + SCR_WIDTH
        next y%
        buffer = buffer - (SCR_WIDTH SHL 4) + 16
    next n%
end sub


sub await(sec%)
    atime = timer
    do while (timer - atime < sec%): loop
end sub


sub ShowFPS(yey%)

    btime% = SDL_GetTicks()
    if (btime% - atime%)>=1000 then
        atime% = btime%
        mo% = (kk% - fps%)
        fps% = kk%
    end if

    text$ = str$(mo%)
    if yey% = 1 then FontWrite (16, 16, text$, 5, framebuffer)

end sub