	IF	!DEF(HARDWARE_INC)
HARDWARE_INC	SET	1
;***************************************************************************************************************************
;*
;*   Project	: 'Stars' - A parallax-scrolling starfield example.
;*
;*   Module	: Hardware.inc
;*
;*   Function	: Support file that defines all of the hardware registers for the GameBoy.
;*
;*   Comment	: My screen column width is 125.
;*
;*   Tab Stops	: 20 30 70
;*                 |         |                                       |
;*
;*   Written by Bob Koon (bob@onemanband.com)
;*   (Based on Jeff F.'s model)
;*
;***************************************************************************************************************************

;*** CPU types *************************************************************************************************************

CPU_GBSGB	EQU	$01
CPU_GBC	EQU	$11
CPU_GBP	EQU	$FF


;*** General hardware information ******************************************************************************************

BLOCK_PIXELWIDTH	EQU	8
BLOCK_PIXELHEIGHT	EQU	8

SCREEN_BLOCKWIDTH	EQU	20
SCREEN_BLOCKHEIGHT	EQU	18

SCREEN_PIXELWIDTH	EQU	(SCREEN_BLOCKWIDTH * BLOCK_PIXELWIDTH)
SCREEN_PIXELHEIGHT	EQU	(SCREEN_BLOCKHEIGHT * BLOCK_PIXELHEIGHT)

MAP_BLOCKWIDTH	EQU	32
MAP_BLOCKHEIGHT	EQU	32


;*** Base addresses ********************************************************************************************************

BASE_VRAM	EQU	$8000	; $8000->$A000
BASE_MAPRAM9800	EQU	$9800	; $9800->$9BFF
BASE_MAPRAM9C00	EQU	$9C00	; $9C00->$9FFF
BASE_SAVERAM	EQU	$A000	; $A000->$BFFF
BASE_RAM	EQU	$C000	; $C000->$DFFF
BASE_OAMRAM	EQU	$FE00	; $FE00->$FE9F
BASE_AUD3WAVERAM	EQU	$FF30	; $FF30->$FF3F (not sure!)
BASE_HIGHRAM	EQU	$FF80	; $FF80->$FFFE


;*** OAM flags *************************************************************************************************************

OAM_F_PAL0	EQU	%00000000	; Palette number 0/1
OAM_F_PAL1	EQU	%00010000	; Palette number 0/1
OAM_F_XFLIP	EQU	%00100000	; X flip
OAM_F_YFLIP	EQU	%01000000	; Y flip
OAM_F_PRI	EQU	%10000000	; Priority


;*** Custom registers ******************************************************************************************************

;*** P1 ($FF00) ************************************************************************************************************
;*   Register for reading joy pad info.   (R/W)
;***************************************************************************************************************************
REG_P1	EQU	$FF00

REG_P1_F_5	EQU	%00100000	; P15 out port
REG_P1_F_4	EQU	%00010000	; P14 out port
REG_P1_F_3	EQU	%00001000	; P13 out port
REG_P1_F_2	EQU	%00000100	; P12 out port
REG_P1_F_1	EQU	%00000010	; P11 out port
REG_P1_F_0	EQU	%00000001	; P10 out port

;*** SB ($FF01) ************************************************************************************************************
;***************************************************************************************************************************
REG_SB	EQU	$FF01

;*** SC ($FF02) ************************************************************************************************************
;***************************************************************************************************************************
REG_SC	EQU	$FF02

;*** DIV ($FF04) ***********************************************************************************************************
;***************************************************************************************************************************
REG_DIV	EQU	$FF04

;*** TIMA ($FF05) **********************************************************************************************************
;***************************************************************************************************************************
REG_TIMA	EQU	$FF05

;*** TMA ($FF06) ***********************************************************************************************************
;***************************************************************************************************************************
REG_TMA	EQU	$FF06

;*** TAC ($FF07) ***********************************************************************************************************
;***************************************************************************************************************************
REG_TAC	EQU	$FF07

;*** IF ($FF0F) ************************************************************************************************************
;*   Interrupt Flag   (R/W)
;***************************************************************************************************************************
REG_IF	EQU	$FF0F

;*** AUD1SWEEP/NR10 ($FF10) ************************************************************************************************
;*   Sweep register   (R/W)
;*
;*   Bit 6-4 - Sweep Time
;*   Bit 3   - Sweep Increase/Decrease
;*             0: Addition    (frequency increases???)
;*             1: Subtraction (frequency increases???)
;*   Bit 2-0 - Number of sweep shift (# 0-7)
;*   Sweep Time: (n*7.8ms)
;***************************************************************************************************************************
REG_NR10	EQU	$FF10
REG_AUD1SWEEP	EQU	REG_NR10

;*** AUD1LEN/NR11 ($FF11) **************************************************************************************************
;*   Sound length/Wave pattern duty   (R/W)
;*
;*   Bit 7-6 - Wave Pattern Duty (00:12.5% 01:25% 10:50% 11:75%)
;*   Bit 5-0 - Sound length data (# 0-63)
;***************************************************************************************************************************
REG_NR11	EQU	$FF11
REG_AUD1LEN	EQU	REG_NR11

;*** AUD1ENV/NR12 ($FF12) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   Bit 7-4 - Initial value of envelope
;*   Bit 3   - Envelope UP/DOWN
;*             0: Decrease
;*             1: Range of increase
;*   Bit 2-0 - Number of envelope sweep (# 0-7)
;***************************************************************************************************************************
REG_NR12	EQU	$FF12
REG_AUD1ENV	EQU	REG_NR12

;*** AUD1LOW/NR13 ($FF13) **************************************************************************************************
;*   Frequency lo (W)
;***************************************************************************************************************************
REG_NR13	EQU	$FF13
REG_AUD1LOW	EQU	REG_NR13

;*** AUD1HIGH/NR14 ($FF14) *************************************************************************************************
;*   Frequency High   (W)
;*
;*   Bit 7   - Initial (when set, sound restarts)
;*   Bit 6   - Counter/consecutive selection
;*   Bit 2-0 - Frequency's higher 3 bits
;***************************************************************************************************************************
REG_NR14	EQU	$FF14
REG_AUD1HIGH	EQU	REG_NR14

;*** AUD2LEN/NR21 ($FF16) **************************************************************************************************
;*   Sound Length; Wave Pattern Duty   (R/W)
;*
;*   see AUD1LEN for info
;***************************************************************************************************************************
REG_NR21	EQU	$FF16
REG_AUD2LEN	EQU	REG_NR21

;*** AUD2ENV/NR22 ($FF17) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   see AUD1ENV for info
;***************************************************************************************************************************
REG_NR22	EQU	$FF17
REG_AUD2ENV	EQU	REG_NR22

;*** AUD2LOW/NR23 ($FF18) **************************************************************************************************
;*   Frequency lo   (W)
;***************************************************************************************************************************
REG_NR23	EQU	$FF18
REG_AUD2LOW	EQU	REG_NR23

;*** AUD2HIGH/NR24 ($FF19) *************************************************************************************************
;*   Frequency hi   (W)
;*
;*   see AUD1HIGH for info
;***************************************************************************************************************************
REG_NR24	EQU	$FF19
REG_AUD2HIGH	EQU	REG_NR24

;*** AUD2ENA/NR30 ($FF1A) **************************************************************************************************
;*   Sound on/off   (R/W)
;*
;*   Bit 7   - Sound ON/OFF (1EQUON,0EQUOFF)
;***************************************************************************************************************************
REG_NR30	EQU	$FF1A
REG_AUD3ENA	EQU	REG_NR30

;*** AUD3LEN/NR31 ($FF1B) **************************************************************************************************
;*   Sound length   (R/W)
;*
;*   Bit 7-0 - Sound length
;***************************************************************************************************************************
REG_NR31	EQU	$FF1B
REG_AUD3LEN	EQU	REG_NR31

;*** AUD3LEVEL/NR32 ($FF1C) ************************************************************************************************
;*   Select output level
;*
;*   Bit 6-5 - Select output level
;*             00: 0/1 (mute)
;*             01: 1/1
;*             10: 1/2
;*             11: 1/4
;***************************************************************************************************************************
REG_NR32	EQU	$FF1C
REG_AUD3LEVEL	EQU	REG_NR32

;*** AUD3LOW/NR33 ($FF1D) **************************************************************************************************
;*   Frequency lo   (W)
;*
;*   see AUD1LOW for info
;***************************************************************************************************************************
REG_NR33	EQU	$FF1D
REG_AUD3LOW	EQU	REG_NR33

;*** AUD3HIGH/NR34 ($FF1E) *************************************************************************************************
;*   Frequency hi   (W)
;*
;*   see AUD1HIGH for info
;***************************************************************************************************************************
REG_NR34	EQU	$FF1E
REG_AUD3HIGH	EQU	REG_NR34

;*** AUD4LEN/NR41 ($FF20) **************************************************************************************************
;*   Sound length   (R/W)
;*
;*   Bit 5-0 - Sound length data (# 0-63)
;***************************************************************************************************************************
REG_NR41	EQU	$FF20
REG_AUD4LEN	EQU	REG_NR41

;*** AUD4ENV/NR42 ($FF21) **************************************************************************************************
;*   Envelope   (R/W)
;*
;*   see AUD1ENV for info
;***************************************************************************************************************************
REG_NR42	EQU	$FF21
REG_AUD4ENV	EQU	REG_NR42

;*** AUD4POLY/NR42 ($FF22) *************************************************************************************************
;*   Polynomial counter   (R/W)
;*
;*   Bit 7-4 - Selection of the shift clock frequency of the (scf)
;*             polynomial counter (0000-1101)
;*             freqEQUdrf*1/2^scf (not sure)
;*   Bit 3 -   Selection of the polynomial counter's step
;*             0: 15 steps
;*             1: 7 steps
;*   Bit 2-0 - Selection of the dividing ratio of frequencies (drf)
;*             000: f/4   001: f/8   010: f/16  011: f/24
;*             100: f/32  101: f/40  110: f/48  111: f/56  (fEQU4.194304 Mhz)
;***************************************************************************************************************************
REG_NR42_2	EQU	$FF22
REG_AUD4POLY	EQU	REG_NR42_2

;*** AUD4GO/NR43 ($FF23) ***************************************************************************************************
;*
;*   Bit 7 -   Inital
;*   Bit 6 -   Counter/consecutive selection
;***************************************************************************************************************************
REG_NR43	EQU	$FF23
REG_AUD4GO	EQU	REG_NR43	; silly name!

;*** AUDVOL/NR50 ($FF24) ***************************************************************************************************
;*   Channel control / ON-OFF / Volume   (R/W)
;*
;*   Bit 7   - Vin->SO2 ON/OFF (Vin??)
;*   Bit 6-4 - SO2 output level (volume) (# 0-7)
;*   Bit 3   - Vin->SO1 ON/OFF (Vin??)
;*   Bit 2-0 - SO1 output level (volume) (# 0-7)
;***************************************************************************************************************************
REG_NR50	EQU	$FF24
REG_AUDVOL	EQU	REG_NR50

;*** AUDTERM/NR51 ($FF25) **************************************************************************************************
;*   Selection of Sound output terminal   (R/W)
;*
;*   Bit 7   - Output sound 4 to SO2 terminal
;*   Bit 6   - Output sound 3 to SO2 terminal
;*   Bit 5   - Output sound 2 to SO2 terminal
;*   Bit 4   - Output sound 1 to SO2 terminal
;*   Bit 3   - Output sound 4 to SO1 terminal
;*   Bit 2   - Output sound 3 to SO1 terminal
;*   Bit 1   - Output sound 2 to SO1 terminal
;*   Bit 0   - Output sound 0 to SO1 terminal
;***************************************************************************************************************************
REG_NR51	EQU	$FF25
REG_AUDTERM	EQU	REG_NR51

;*** AUDENA/NR52 ($FF26) ***************************************************************************************************
;*   Sound on/off   (R/W)
;*
;*   Bit 7   - All sound on/off (sets all audio regs to 0!)
;*   Bit 3   - Sound 4 ON flag (doesn't work!)
;*   Bit 2   - Sound 3 ON flag (doesn't work!)
;*   Bit 1   - Sound 2 ON flag (doesn't work!)
;*   Bit 0   - Sound 1 ON flag (doesn't work!)
;***************************************************************************************************************************
REG_NR52	EQU	$FF26
REG_AUDENA	EQU	REG_NR52

;*** LCDC ($FF40) **********************************************************************************************************
;*   LCD Control   (R/W)
;*
;*   "Window Character Data Select" follows BG
;***************************************************************************************************************************
REG_LCDC	EQU	$FF40

REG_LCDC_F_OFF	EQU	%00000000	; LCD Control Operation
REG_LCDC_F_ON	EQU	%10000000	; LCD Control Operation
REG_LCDC_F_WIN9800	EQU	%00000000	; Window Screen Display Data Select
REG_LCDC_F_WIN9C00	EQU	%01000000	; Window Screen Display Data Select
REG_LCDC_F_WINOFF	EQU	%00000000	; Window Display
REG_LCDC_F_WINON	EQU	%00100000	; Window Display
REG_LCDC_F_BG8800	EQU	%00000000	; BG Character Data Select
REG_LCDC_F_BG8000	EQU	%00010000	; BG Character Data Select
REG_LCDC_F_BG9800	EQU	%00000000	; BG Screen Display Data Select
REG_LCDC_F_BG9C00	EQU	%00001000	; BG Screen Display Data Select
REG_LCDC_F_OBJ8	EQU	%00000000	; OBJ Construction
REG_LCDC_F_OBJ16	EQU	%00000100	; OBJ Construction
REG_LCDC_F_OBJOFF	EQU	%00000000	; OBJ Display
REG_LCDC_F_OBJON	EQU	%00000010	; OBJ Display
REG_LCDC_F_BGOFF	EQU	%00000000	; BG Display
REG_LCDC_F_BGON	EQU	%00000001	; BG Display

;*** STAT ($FF41) **********************************************************************************************************
;*   LCDC Status   (R/W)
;***************************************************************************************************************************
REG_STAT	EQU	$FF41

REG_STAT_F_LYC	EQU	%01000000	; LYCEQULY Coincidence (Selectable)
REG_STAT_F_MODE10	EQU	%00100000	; Mode 10
REG_STAT_F_MODE01	EQU	%00010000	; Mode 01 (V-Blank)
REG_STAT_F_MODE00	EQU	%00001000	; Mode 00 (H-Blank)
REG_STAT_F_LYCF	EQU	%00000100	; Coincidence Flag
REG_STAT_F_LCD	EQU	%00000011	; Both OAM and VRAM used by system
REG_STAT_F_OAM	EQU	%00000010	; OAM RAM is used by system
REG_STAT_F_VB	EQU	%00000001	; V-Blank
REG_STAT_F_HB	EQU	%00000000	; H-Blank

;*** SCY ($FF42) ***********************************************************************************************************
;*   Scroll Y   (R/W)
;***************************************************************************************************************************
REG_SCY	EQU	$FF42

;*** SCX ($FF43) ***********************************************************************************************************
;*   Scroll X   (R/W)
;***************************************************************************************************************************
REG_SCX	EQU	$FF43

;*** LY ($FF44) ************************************************************************************************************
;*   LCDC Y-Coordinate   (R)
;*
;*   Values range from 0->153. 144->153 is the VBlank period.
;***************************************************************************************************************************
REG_LY	EQU	$FF44

;*** LYC ($FF45) ***********************************************************************************************************
;*   LY Compare   (R/W)
;*
;*   When LYEQUEQULYC, STATF_LYCF will be set in STAT.
;***************************************************************************************************************************
REG_LYC	EQU	$FF45

;*** DMA ($FF46) ***********************************************************************************************************
;*   DMA Transfer and Start Address   (W)
;***************************************************************************************************************************
REG_DMA	EQU	$FF46

;*** BGP ($FF47) ***********************************************************************************************************
;*   BG Palette Data   (W)
;*
;*   Bit 7-6 - Intensity for %11
;*   Bit 5-4 - Intensity for %10
;*   Bit 3-2 - Intensity for %01
;*   Bit 1-0 - Intensity for %00
;***************************************************************************************************************************
REG_BGP	EQU	$FF47

;*** OBP0 ($FF48) **********************************************************************************************************
;*   Object Palette 0 Data   (W)
;*
;*   See BGP ($FF47) for info
;***************************************************************************************************************************
REG_OBP0	EQU	$FF48

;*** OBP1 ($FF49) **********************************************************************************************************
;*   Object Palette 1 Data   (W)
;*
;*   See BGP ($FF47) for info
;***************************************************************************************************************************
REG_OBP1	EQU	$FF49

;*** WY ($FF4A) ************************************************************************************************************
;*   Window Y Position   (R/W)
;*
;*   0 <= WY <= 143
;***************************************************************************************************************************
REG_WY	EQU	$FF4A

;*** WX ($FF4B) ************************************************************************************************************
;*   Window X Position   (R/W)
;*
;*   7 <EQU WX <EQU 166
;***************************************************************************************************************************
REG_WX	EQU	$FF4B

;*** KEY1 ($FF4D) **********************************************************************************************************
;***************************************************************************************************************************
REG_KEY1	EQU	$FF4D

;*** VBK ($FF4F) ***********************************************************************************************************
;*   Select Video RAM Bank   (R/W)
;***************************************************************************************************************************
REG_VBK	EQU	$FF4F

;*** HDMA1 ($FF51) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA1	EQU	$FF51

;*** HDMA2 ($FF52) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA2	EQU	$FF52

;*** HDMA3 ($FF53) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA3	EQU	$FF53

;*** HDMA4 ($FF54) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA4	EQU	$FF54

;*** HDMA5 ($FF55) *********************************************************************************************************
;*   Horizontal Blanking, General Purpose DMA   (W)
;***************************************************************************************************************************
REG_HDMA5	EQU	$FF55

;*** RP ($FF56) ************************************************************************************************************
;***************************************************************************************************************************
REG_RP	EQU	$FF56

;*** BCPS ($FF68) **********************************************************************************************************
;*   Background Color Palette Specification   (R/W)
;***************************************************************************************************************************
REG_BCPS	EQU	$FF68

;*** BCPD ($FF69) **********************************************************************************************************
;*   Background Color Palette Data   (R/W)
;***************************************************************************************************************************
REG_BCPD	EQU	$FF69

;*** OCPS ($FF6A) **********************************************************************************************************
;*   Object Color Palette Specification   (R/W)
;***************************************************************************************************************************
REG_OCPS	EQU	$FF6A

;*** OCPD ($FF6B) **********************************************************************************************************
;*   Object Color Palette Data   (R/W)
;***************************************************************************************************************************
REG_OCPD	EQU	$FF6B

;*** SVBK ($FF70) **********************************************************************************************************
;*   Select Main RAM Bank   (R/W)
;***************************************************************************************************************************
REG_SVBK	EQU	$FF70

;*** IE ($FFFF) ************************************************************************************************************
;*   Interrupt Enable   (R/W)
;***************************************************************************************************************************
REG_IE	EQU	$FFFF

REG_IE_F_JOYPAD	EQU	%00010000	; Joypad transition from high to low
REG_IE_F_SERIAL	EQU	%00001000	; Serial I/O transfer end
REG_IE_F_TIMER	EQU	%00000100	; Timer Overflow
REG_IE_F_LCDC	EQU	%00000010	; LCDC (see STAT)
REG_IE_F_VBLANK	EQU	%00000001	; V-Blank

;***************************************************************************************************************************
;*   Joypad equates
;***************************************************************************************************************************

PAD_F_DOWN	EQU	%10000000
PAD_F_UP	EQU	%01000000
PAD_F_LEFT	EQU	%00100000
PAD_F_RIGHT	EQU	%00010000
PAD_F_START	EQU	%00001000
PAD_F_SELECT	EQU	%00000100
PAD_F_B	EQU	%00000010
PAD_F_A	EQU	%00000001

	ENDC	; HARDWARE_INC
