//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_TASKS_INL_
#define _NULSTEIN_TASKS_INL_

//________________________________________________________________________________
inline
int CWorkerThread::GetWorkerIndex()
{
	return int(this - m_pTaskPool->m_Thread);
}

//________________________________________________________________________________
inline
void CTaskPool::WakeWorkers()
{
	ASSERT(m_bWorkersIdle);
	
	m_bWorkersIdle = false;
	ReleaseSemaphore(m_WakeUpCall, m_ThreadCount-1, NULL);
}

inline
void CTaskPool::WaitForWorkersToBeReady()
{
	ASSERT(!m_bWorkersIdle);

	for(unsigned i=0; i<m_ThreadCount-1; i++)
		WaitForSingleObject(m_SleepNotification, INFINITE);
		
	m_bWorkersIdle = true;
}


#endif // _NULSTEIN_TASKS_INL_