//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _SONODLS_H_
#define _SONODLS_H_

class sDLSSample
{
public:
	bool Parse(const BYTE* pData, const BYTE* pEnd);

public:
	WORD		m_FormatTag;
	WORD		m_Channels;
	DWORD		m_SamplesPerSec;
	DWORD		m_AvgBytesPerSec;
	WORD		m_BitsPerSample;
	
	SHORT		m_FineTune;
	ULONG		m_Options;
	ULONG		m_SampleLoops;
	ULONG		m_LoopStart;
	ULONG		m_LoopLength;
	
	const SHORT*	m_pData;
	ULONG		m_DataSize;
	ULONG		m_Offset;
	float		m_UnityFreq;
	float		m_Scale;
};

class sDLSRegion
{
public:
	bool Parse(const BYTE* pData, const BYTE* pEnd);
	
public:
	BYTE	m_KeyFrom;
	BYTE	m_KeyTo;
	WORD	m_KeyGroup;
	ULONG	m_iSample;
};

class sDLSInstrument
{
public:
	bool Parse(const BYTE* pData, const BYTE* pEnd);
	bool Parse_RegionList(const BYTE* pData, const BYTE* pEnd);
	bool Parse_Info(const BYTE* pData, const BYTE* pEnd);
	
	void Free();
	
public:
	sDLSRegion*	m_Region;
	ULONG		m_RegionCount;
	
	ULONG		m_Id;
	ULONG		m_Bank;
	bool		m_bDrum;
	
	const char* m_Copyright;
	const char* m_Name;
};

class CDLSFile
{
public:
	CDLSFile();
	~CDLSFile() {Close();}

	bool Open(const TCHAR* sPath=NULL); /* if no path given, load the General Midi samples */ 
	void Close();

	bool Parse(const BYTE* pData);
	bool Parse_InstrumentList(const BYTE* pData, const BYTE* pEnd);
	bool Parse_SampleList(const BYTE* pData, const BYTE* pEnd);
	
	int FindInstrument(ULONG Bank, ULONG Program);
	int FindInstrument(ULONG Program) {return FindInstrument(0, Program);}

public:
	HANDLE				m_hSamplesFile;
	HANDLE				m_hSamplesMapping;
	void*				m_pSamplesMem;
	
	int					m_InstrumentCount;
	int					m_SamplesCount;

	sDLSSample*			m_Sample;
	sDLSInstrument*		m_Instrument;
};


#endif // _SONODLS_H_