//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_FRAME_H_
#define _NULSTEIN_FRAME_H_

#include "Gfx/Gfx.h"
#include "Gfx/GfxLight.h"
#include "Gfx/DisplayList.h"
#include "Gfx/View.h"

#include "Sono.h"

#include "MeshPrimitive.h"

#include "TaskScheduler.h"

#include "Entity.h"

#define NULSTEIN_MAX_ENTITYCOUNT	16384
#define MAX_LIGHTCOUNT					4

//________________________________________________________________________________
class IGame
{
public:
	virtual bool Init(CFrame* pFrame) =0;
};

//________________________________________________________________________________
class CFrame
{
public:
	CFrame();
	
	bool Open(CGfx*	pGfx, CSono *pSono, CTaskPool* pTaskPool, IGame* pGame, void* pGameAsVoid);
	void Close();
	
	CEntitySlot*	AllocEntity();
	
	bool Frame();
	
public: 
	bool Draw();
	bool Render();
	bool Update(int dt);

public: /* internal use */ 
	bool ProcessRenderContextChanges(CDisplayItemKey* pCurrent, const CDisplayItemKey& New);
	bool SelectRenderTarget(int iRenderTarget);
	bool SelectLayer(int iRenderTarget);
	bool SelectViewport(int iRenderTarget, int iViewport);
	bool SelectViewportLayer(int iViewportLayer);
	bool SelectAlpha(bool bAlpha);

public:	
	CGfx*			m_pGfx;
	CSono*			m_pSono;
	CTaskPool*		m_pTaskPool;
	
	IGame*			m_pGame;		/* for engine side purposes */ 
	void*			m_pGameAsVoid;	/* for game side purposes	*/ 
	
	CEntitySlot		m_Entity[NULSTEIN_MAX_ENTITYCOUNT];
	int				m_EntityCount;
	CDisplayList	m_DisplayList;
	
	DWORD			m_t0;
	
	CView			m_View[32];
	int				m_ViewCount;
	
	/* temp */ 
	CLight			m_Light[MAX_LIGHTCOUNT];
	int				m_LightCount;
};

#endif // _NULSTEIN_FRAME_H_