//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx.h"
#include "Viewport.h"

//________________________________________________________________________________
bool CGfx::SelectViewport(CViewport* pViewport)
{
	HRESULT			hr;
	D3DVIEWPORT9	viewData;
	RECT*			pRect;
	
	if (pViewport)
		 pRect = &pViewport->m_Rect;
	else pRect = &m_ClientRect;

	viewData.X		= pRect->left;
	viewData.Y		= pRect->top;
	viewData.Width	= pRect->right  - pRect->left;
	viewData.Height = pRect->bottom - pRect->top;
	viewData.MinZ	= 0.0f;
	viewData.MaxZ	= 1.0f;

	hr = m_spDevice->SetViewport(&viewData);
	IF_FAILED_RETURN(hr);

	return true;
}