//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

static const unsigned __int32 _sincos_masks[]		= {  0x0, ~0x0 };

__m128 __declspec(naked) __stdcall am_sin_ss(__m128 x)
{
	__asm
	{
		movss	[esp - 4], xmm0
		movss	xmm1, _ps_am_inv_sign_mask
		mov		eax, [esp - 4]
		mulss	xmm0, _ps_am_2_o_pi
		andps	xmm0, xmm1
		and		eax, 0x80000000

		cvttss2si	ecx, xmm0
		movss	xmm1, _ps_am_1
		mov		edx, ecx
		shl		edx, (31 - 1)
		cvtsi2ss	xmm2, ecx
		and		ecx, 0x1
		and		edx, 0x80000000

		subss	xmm0, xmm2
		movss	xmm6, _sincos_masks[ecx * 4]
		minss	xmm0, xmm1

		movss	xmm5, _ps_sincos_p3
		subss	xmm1, xmm0

		andps	xmm1, xmm6
		andnps	xmm6, xmm0
		orps	xmm1, xmm6
		movss	xmm4, _ps_sincos_p2
		movss	xmm0, xmm1

		mulss	xmm1, xmm1
		movss	xmm7, _ps_sincos_p1
		xor		eax, edx
		movss	xmm2, xmm1
		mulss	xmm1, xmm5
		movss	xmm5, _ps_sincos_p0
		mov		[esp - 4], eax
		addss	xmm1, xmm4
		mulss	xmm1, xmm2
		movss	xmm3, [esp - 4]
		addss	xmm1, xmm7
		mulss	xmm1, xmm2
		orps	xmm0, xmm3
		addss	xmm1, xmm5
		mulss	xmm0, xmm1

		ret		16
	}
}

#endif