//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_log_ps(__m128 x)
{
	__asm
	{
		maxps	xmm0, _ps_am_min_norm_pos  // cut off denormalized stuff
		mov		ecx, esp
		movaps	xmm7, _ps_am_inv_mant_mask
		and		ecx, ~15
		movaps	xmm1, _ps_am_1
		movaps	[ecx - 16], xmm0

		andps	xmm0, xmm7
		orps	xmm0, xmm1
		movaps	xmm7, xmm0

		addps	xmm7, xmm1
		subps	xmm0, xmm1
		movq	mm0, [ecx - 16]
		rcpps	xmm7, xmm7  
		mulps	xmm0, xmm7
		movq	mm1, [ecx - 16 + 8]
		addps	xmm0, xmm0

		movq	mm7, _pi32_0x7f
		movaps	xmm2, xmm0
		mulps	xmm2, xmm2

		movaps	xmm4, _ps_log_p0
		psrld	mm1, 23
		movaps	xmm6, _ps_log_q0
		psrld	mm0, 23

		mulps	xmm4, xmm2
		movaps	xmm5, _ps_log_p1
		mulps	xmm6, xmm2
		movaps	xmm7, _ps_log_q1

		addps	xmm4, xmm5
		psubd	mm1, mm7
		addps	xmm6, xmm7
		psubd	mm0, mm7

		movaps	xmm5, _ps_log_p2
		mulps	xmm4, xmm2
		cvtpi2ps	xmm1, mm1
		movaps	xmm7, _ps_log_q2
		mulps	xmm6, xmm2

		addps	xmm4, xmm5
		ASM_MOVE_L2H(xmm1)
		addps	xmm6, xmm7

		movaps	xmm5, _ps_log_c0
		mulps	xmm4, xmm2
		cvtpi2ps	xmm1, mm0
		rcpps	xmm6, xmm6  

		mulps	xmm4, xmm0
		mulps	xmm1, xmm5
		mulps	xmm4, xmm6

		addps	xmm0, xmm1
		addps	xmm0, xmm4

		ret		16
	}
}

#endif