//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_log2_ess(__m128 x)
{
	__asm
	{
		maxss	xmm0, _ps_am_min_norm_pos  // cut off denormalized stuff
		movss	xmm1, _ps_am_1
		movaps	xmm3, xmm0

		andps	xmm0, _ps_am_inv_mant_mask
		orps	xmm0, xmm1

		movaps	xmm4, xmm0
		movss	xmm7, _epi32_0x7f
		subss	xmm0, xmm1
		addss	xmm4, xmm1
		psrld	xmm3, 23
		rcpss	xmm4, xmm4
		mulss	xmm0, xmm4
		psubd	xmm3, xmm7
		addss	xmm0, xmm0

		movaps	xmm2, xmm0
		mulss	xmm0, xmm0

		movss	xmm4, _ps_log_p0
		movss	xmm6, _ps_log_q0

		mulss	xmm4, xmm0
		movss	xmm5, _ps_log_p1
		mulss	xmm6, xmm0
		movss	xmm7, _ps_log_q1

		addss	xmm4, xmm5
		addss	xmm6, xmm7

		movss	xmm5, _ps_log_p2
		mulss	xmm4, xmm0
		movss	xmm7, _ps_log_q2
		mulss	xmm6, xmm0

		addss	xmm4, xmm5
		movss	xmm5, _ps_log2_c0
		addss	xmm6, xmm7
		cvtdq2ps	xmm1, xmm3

		mulss	xmm0, xmm4
		rcpss	xmm6, xmm6

		mulss	xmm0, xmm6

		mulss	xmm0, xmm2
		mulss	xmm2, xmm5
		mulss	xmm0, xmm5
		addss	xmm2, xmm1
		addss	xmm0, xmm2

		ret		16
	}
}

#endif