//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

_PS_EXTERN_CONST(am_1,		 1.0f);
_PS_EXTERN_CONST(am_m1,		-1.0f);
_PS_EXTERN_CONST(am_pi,		(float) AM_PI);
_PS_EXTERN_CONST(am_pi_o_2, (float)(AM_PI / 2.0));
_PS_EXTERN_CONST(am_pi_o_4, (float)(AM_PI / 4.0));
_PS_EXTERN_CONST(am_2_o_pi, (float)(2.0 / AM_PI));
_PS_EXTERN_CONST(am_4_o_pi, (float)(4.0 / AM_PI));

_PS_EXTERN_CONST_TYPE(am_sign_mask,		__int32,  0x80000000);
_PS_EXTERN_CONST_TYPE(am_inv_sign_mask, __int32, ~0x80000000);

_EPI32_CONST(1,		1);
_EPI32_CONST(2,		2);
_EPI32_CONST(7,		7);
_EPI32_CONST(0x7f,	0x7f);
_EPI32_CONST(0xff,	0xff);

_PI32_CONST(0x80000000,		0x80000000);
_PI32_CONST(inv0x80000000, ~0x80000000);
