//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_atanr2_ss(__m128 y, __m128 rx)
{
	__asm
	{
		// NOTE: substract enough to survive call to am_atan_ss, i.e.
		//  16 byte for the argument + 4 byte for return address
		movss	[esp - 20 - 4], xmm0
		mulss	xmm0, xmm1
		movss	[esp - 20 - 8], xmm1

		sub		esp, 16
		// HACK HACK:
		// We assume am_atan_ss doesn't expect the argument on the stack, just in xmm0
		// This is true for our version of am_atan_ss
		call	am_atan_ss

		xorps	xmm7, xmm7
		movss	xmm1, [esp - 20 - 8]
		comiss	xmm1, xmm7
		movss	xmm4, [esp - 20 - 4]
		jnc		l_pos   // 'nc' is 'ge' for comiss

		andps	xmm4, _ps_am_sign_mask
		orps	xmm4, _ps_am_pi

		addss	xmm0, xmm4

l_pos:
		ret		32
	}
}

#endif