//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#ifndef _AMATH_INTERNAL_H_
#define _AMATH_INTERNAL_H_

/* SSE, SSE2, and MMX(TM) constants implementation */ 
#define _PS_EXTERN_CONST(Name, Val) \
const _MM_ALIGN16 float _ps_##Name[4] = { Val, Val, Val, Val }

#define _PS_EXTERN_CONSTDECL(Name) \
extern const _MM_ALIGN16 float _ps_##Name[4]

#define _PS_CONST4(Name, Val0, Val1, Val2, Val3) \
static const _MM_ALIGN16 float _ps_##Name[4] = { Val0, Val1, Val2, Val3 }

#define _PS_CONST_TYPE(Name, Type, Val) \
static const _MM_ALIGN16 Type _ps_##Name[4] = { Val, Val, Val, Val }

#define _PS_EXTERN_CONST_TYPE(Name, Type, Val) \
const _MM_ALIGN16 Type _ps_##Name[4] = { Val, Val, Val, Val }

#define _EPI32_CONST(Name, Val) \
const _MM_ALIGN16 __int32 _epi32_##Name[4] = { Val, Val, Val, Val }

#define _EPI32_CONSTDECL(Name) \
extern const _MM_ALIGN16 __int32 _epi32_##Name[4]

#define _PI32_CONST(Name, Val) \
const __declspec(align(8)) __int32 _pi32_##Name[4] = { Val, Val, Val, Val }

#define _PI32_CONSTDECL(Name) \
extern const __declspec(align(8)) __int32 _pi32_##Name[4];

//
_PS_EXTERN_CONSTDECL(am_0);
_PS_EXTERN_CONSTDECL(am_1);
_PS_EXTERN_CONSTDECL(am_m1);
_PS_EXTERN_CONSTDECL(am_0p5);
_PS_EXTERN_CONSTDECL(am_1p5);
_PS_EXTERN_CONSTDECL(am_pi);
_PS_EXTERN_CONSTDECL(am_pi_o_2);
_PS_EXTERN_CONSTDECL(am_2_o_pi);
_PS_EXTERN_CONSTDECL(am_pi_o_4);
_PS_EXTERN_CONSTDECL(am_4_o_pi);
_PS_EXTERN_CONSTDECL_TYPE(am_min_norm_pos, __int32);
_PS_EXTERN_CONSTDECL_TYPE(am_mant_mask, __int32);
_PS_EXTERN_CONSTDECL_TYPE(am_inv_mant_mask, __int32);

//
_PS_EXTERN_CONSTDECL(sincos_p0);
_PS_EXTERN_CONSTDECL(sincos_p1);
_PS_EXTERN_CONSTDECL(sincos_p2);
_PS_EXTERN_CONSTDECL(sincos_p3);

//
_PS_EXTERN_CONSTDECL(atan_t0);
_PS_EXTERN_CONSTDECL(atan_t1);
_PS_EXTERN_CONSTDECL(atan_t2);
_PS_EXTERN_CONSTDECL(atan_t3);

_PS_EXTERN_CONSTDECL(atan_s0);
_PS_EXTERN_CONSTDECL(atan_s1);
_PS_EXTERN_CONSTDECL(atan_s2);
_PS_EXTERN_CONSTDECL(atan_s3);

//
_PS_EXTERN_CONSTDECL(tan_p0);
_PS_EXTERN_CONSTDECL(tan_p1);
_PS_EXTERN_CONSTDECL(tan_p2);
	
_PS_EXTERN_CONSTDECL(tan_q0);
_PS_EXTERN_CONSTDECL(tan_q1);
_PS_EXTERN_CONSTDECL(tan_q2);
_PS_EXTERN_CONSTDECL(tan_q3);

_PS_EXTERN_CONSTDECL(tan_poleval);

//
_PS_EXTERN_CONSTDECL(exp_hi);
_PS_EXTERN_CONSTDECL(exp_lo);

_PS_EXTERN_CONSTDECL(exp_rln2);

_PS_EXTERN_CONSTDECL(exp_p0);
_PS_EXTERN_CONSTDECL(exp_p1);

_PS_EXTERN_CONSTDECL(exp_q0);
_PS_EXTERN_CONSTDECL(exp_q1);
_PS_EXTERN_CONSTDECL(exp_q2);
_PS_EXTERN_CONSTDECL(exp_q3);

_PS_EXTERN_CONSTDECL(exp_c1);
_PS_EXTERN_CONSTDECL(exp_c2);

//
_PS_EXTERN_CONSTDECL(exp2_hi);
_PS_EXTERN_CONSTDECL(exp2_lo);

_PS_EXTERN_CONSTDECL(exp2_p0);
_PS_EXTERN_CONSTDECL(exp2_p1);
_PS_EXTERN_CONSTDECL(exp2_p2);

_PS_EXTERN_CONSTDECL(exp2_q0);
_PS_EXTERN_CONSTDECL(exp2_q1);

//
_PS_EXTERN_CONSTDECL(log_p0);
_PS_EXTERN_CONSTDECL(log_p1);
_PS_EXTERN_CONSTDECL(log_p2);

_PS_EXTERN_CONSTDECL(log_q0);
_PS_EXTERN_CONSTDECL(log_q1);
_PS_EXTERN_CONSTDECL(log_q2);

_PS_EXTERN_CONSTDECL(log_c0);

//
_PS_EXTERN_CONSTDECL(log2_c0);

//
_EPI32_CONSTDECL(1);
_EPI32_CONSTDECL(2);
_EPI32_CONSTDECL(7);
_EPI32_CONSTDECL(0x7f);
_EPI32_CONSTDECL(0xff);

_PI32_CONSTDECL(0x80000000);
#define _pi32_1		_epi32_1
#define _pi32_2		_epi32_2
#define _pi32_7		_epi32_7

_PI32_CONSTDECL(inv0x80000000);
#define _pi32_0x7f	_epi32_0x7f
#define _pi32_0xff	_epi32_0xff


/* using "KATMAI B" version of original source */ 
#define _mm_movehl_ps(a, b)	_mm_shuffle_ps(b, a, _MM_SHUFFLE(3,2,3,2))
#define _moveh2l_ps(a)		_mm_shuffle_ps(a, a, _MM_SHUFFLE(3,2,3,2))
#define _mm_movelh_ps(a, b)	_mm_shuffle_ps(a, b, _MM_SHUFFLE(1,0,1,0))
#define _movel2h_ps(a)		_mm_shuffle_ps(a, a, _MM_SHUFFLE(1,0,1,0))
#define	ASM_MOVE_H2L(src)    \
			__asm	shufps	src, src, _MM_SHUFFLE(3,2,3,2)

#define	ASM_MOVE_L2H(src)    \
			__asm	shufps	src, src, _MM_SHUFFLE(1,0,1,0)





#endif // _AMATH_INTERNAL_H_