//--------------------------
//assembled with jasm-z80
//
// video conversion for YT was done with:
// ffmpeg -i input.avi -vf setfield=mode=tff,separatefields,scale=w=960:h=720 metawide.mp4
//
section code, "Main", $4009
{
        include "p_head.inc"
        MainEntry:
        jp      MainLoop

//--------------------------
        FileName: define byte[] = {string("METAWIDE.BIN", "zx81"), 0}
        NrOfRowsToScroll: define word = 279552 / 192

        include "ZXpand.inc"
        include "Video.inc"

//--------------------------
MainLoop:
        call    ClearScreenMemory
	call	EnableHires
	{
                call    StreamVideo
	        jp	@loop
        }

//--------------------------
StreamVideo:
	ld	de,FileName
	call	OpenFileForStreaming

	ld	bc,(NrOfRowsToScroll)
	{
		push	bc

		call	Request192BytesFromFile
		call	WaitScreen
		ld	hl,ScreenModify: SCREEN_START + SCREEN_WIDTH_BYTES
		call	Read192BytesFromFileToHL
                call    FineScrollLeft
		ld	a,(ScreenModify)
                inc     a
                and     127
                ld      (ScreenModify),a

               	call	WaitScreen
                call    FineScrollLeft
        
               	call	WaitScreen
                call    FineScrollLeft

	        call	WaitScreen
                call    FineScrollLeft
        	call	ScrollLeft

		//check number of frames shown
		pop	bc
		dec	bc
		ld	a,b
		or	c
	        jp	nz,@loop
        }
	call	CloseFile
	ret

//--------------------------
        include "p_foot.inc"
}
