const SCREEN_WIDTH_BYTES	= 40		//x-resolution in bytes
const SCREEN_WIDTH_PIXELS	= SCREEN_WIDTH_BYTES * 8
const SCREEN_HEIGHT_RASTERS	= 192		//y-resolution in lines
const TV_STD_50HZ		= 312
const TV_STD_60HZ		= 262
const TV_STD			= TV_STD_50HZ
const VSYNC_RASTERS		= 4
const WASTED_RASTERS		= 4
const TOTAL_BLANK_RASTERS	= TV_STD - WASTED_RASTERS - SCREEN_HEIGHT_RASTERS - VSYNC_RASTERS
const TOP_BLANK_RASTERS	        = TOTAL_BLANK_RASTERS / 2
const BOTTOM_BLANK_RASTERS	= TOTAL_BLANK_RASTERS - TOP_BLANK_RASTERS
const SCREEN_START		= 8192
const SCREEN_SIZE		= 8192

FrameCounter: define byte = 0

//--------------------------
EnableHires:
	//synchronise the change to hires
	ld	hl,Frames		//Frames counter
	ld	a,(hl)			//get old Frames
	{
		cp	(hl)		//compare to new Frames
	        jr	z,@loop		//exit after a change is detected
        }
	//change to hires
	ld	ix,GenerateVsync
	ret

//--------------------------
DisableHires:
	//restore ROM character patterns
	ld	a,$1e
	ld	i,a
	//restore standard ROM video mode
	ld	ix,$0281
	ret

//--------------------------
GenerateVsync:
	//start VSync
	in	a,($fe) 		//VSync on, NMI off, HSYNC off
	//waste time to create VSync
	repeat (207 * VSYNC_RASTERS / 4) - 2
        {
		nop
	}
	//prepare top border
	//end VSync
	out	($fe),a 		//VSYNC off, NMI on, HSYNC on
	//prepare top border
	ld	ix,GenerateHires
	ld	a,256 - TOP_BLANK_RASTERS
	ex	af,af'
	//restore registers
	pop	hl
	pop	de
	pop	bc
	pop	af
	//return to do some useful work, and generate top blank lines
	ret

//--------------------------
HiresLine:
	pop	hl			//10
	ld	a,h			//4
	ld	i,a			//9
	ld	a,l			//4
	ld	r,a			//9
	repeat SCREEN_WIDTH_BYTES
        {
		nop			//4 * 40
	}
	ret	c			//11 == 207

//--------------------------
GenerateHires:
	//delay to synchronize picture-start
        and     (hl)
        //waste time depending on ScrollXFine
	ld	a,ScrollXFine: 0
	and	6
	sla	a
	add	a,<.DELAY0
	ld	(.DelayTable),a
        xor     a
	jp	.DelayTable: .DELAY0
        align 16
.DELAY0:
	and	(hl)			//7
	jp	.AFTER_DELAY
.DELAY1:
	dec	bc			//6
	jp	.AFTER_DELAY
.DELAY2:
	ret	c			//5
	jp	.AFTER_DELAY
.DELAY3:
	nop				//4
	jp	.AFTER_DELAY
.AFTER_DELAY:        
	//init all registers needed for hires display
	ld	(.StackSave),sp
	ld	sp,ScreenStack
	scf
	//generate screen, at HiresLine + $8000
	ret
	//return here when screen is done
ContinueHires:
	//increment FrameCounter
	ld	hl,FrameCounter
	inc	(hl)
	//prepare bottom border
	ld	ix,GenerateVsync
	ld	a,256 - BOTTOM_BLANK_RASTERS
	ex	af,af'
	//restore registers
	ld	sp,.StackSave: 1234
	out	($fe),a 		//NMI-generator on
	pop	hl
	pop	de
	pop	bc
	pop	af
	//return to do some useful work, and generate bottom blank lines
	ret

//--------------------------
FineScrollLeft:
        ld      a,(ScrollXFine)
        inc     a
        inc     a
        and     7
        ld      (ScrollXFine),a
        ret

//--------------------------
//sync to screen update
WaitScreen:
	ld	hl,FrameCounter
	ld	a,(hl)
	{
		cp	(hl)
	        jp	z,@loop
        }
	ret

//--------------------------
ClearScreenMemory:
	ld	d,0
	ld	bc,SCREEN_SIZE
	ld	hl,SCREEN_START
	{
		ld	(hl),d
		inc	hl
		dec	bc
		ld	a,b
		or	c
	        jp	nz,@loop
        }
	ret

//--------------------------
ScrollLeft:
	ld	hl,ScreenStack + 2
	ld	de,4
	ld	b,192
	{
		ld	a,(hl)
		sla	a
		jr	c,.One
			srl	a
			inc	a
			and	127
			jp	.WriteBack
		.One:
			srl	a
			inc	a
			or	128
		.WriteBack:
		ld	(hl),a
		add	hl,de
        	djnz	@loop
        }
	ret

//--------------------------
ScreenStack:
	var TEMP = SCREEN_START
	repeat (192 / 3)
        {
		define word[2] = {HiresLine + $8000, TEMP + 0}
		define word[2] = {HiresLine + $8000, TEMP + 42}
		define word[2] = {HiresLine + $8000, TEMP + 84}
		TEMP = TEMP + 128
	}
	define word = ContinueHires
