;	ORG	$4357
 *=$4357
 !to "FF#064357", plain	; set output file and format;?plain
 !cpu 6502		; set processor type

; SYS 17239 or CALL 17239

EMPTY2	=	$00
TREE2	=	$44
FIRE2	=	$99

; common available zero page


GBASL	=	$26
GBASH	=	$27

SEED2	=	$28
SEED0	=	$29
SEED1	=	$2A

H2	=	$2B
V2	=	$2C
PLOTC	=	$2D
COLOR	=	$2E
PAGE	=	$2F
TOPL	=	$30
TOPH	=	$31
MIDL	=	$32
MIDH	=	$33
BTML	=	$34
BTMH	=	$35
PLOTL	=	$36
PLOTH	=	$37

;;lastzp	=	$38

tablelo	=	$38;5000
tablehi = tablelo+25

;	JSR START
START:
;	LDX #GBASL
;savezp:
;	LDA $00,X
;	STA $5100,X
;	INX
;	CPX #lastzp
;	BNE savezp

SETGR    =     $FB40;install lores GR(basic)

 JSR   SETGR      ;GR

;	BIT $C056 ; low resolution
	BIT $C052 ; full screen
;	BIT $C054 ; page one
l	BIT $C050 ; graphics
 GBASCALC = $F847

;	LDA #$47
;	STA SEED0
;;	LDA #$F8
;	STA SEED1
;;	LDA #$4C ; JMP instruction
;	STA SEED2 ; temporary JMP

;	LDA #24 ; screen rows
;	STA V2

	LDX #$00 ; y coord
table:
	TXA
	JSR GBASCALC;;SEED2 ; temporary JMP GBASCALC
	LDA GBASL
	STA tablelo,X
	LDA GBASH
	STA tablehi,X




	LDY #$00
	TYA
clrline:
	STA (GBASL),Y
	INY
	CPY #40
	BNE clrline

	INX
	CPX #24;V2
	BNE table

	JSR sseed0
	JSR sseed2

	LDX #$60
	STX PAGE
	STX TOPH
	LDY #$00
	STY TOPL
	TYA
zero:	STA (TOPL),Y
	INY
	BNE zero
	INX
	STX TOPH
	CPX #$80
	BNE zero

loop3:
	LDX #0
	STX TOPL
	LDA #41
	STA MIDL
	STA PLOTL
	LDA #83
	STA BTML
	LDA PAGE
	STA TOPH
	STA MIDH
	STA BTMH
	EOR #$10
	STA PLOTH
	STA PAGE
loop2:
	TXA
;	STX V2
	LSR       ; F800 PLOT-like...
	; PHP       ; F801
	TAY	 ; save A in Y without touching C
	LDA #$0F
	BCC over2
	ADC #$E0
over2:	STA PLOTC   ; PLOT...
	LDA tablelo,Y ; lookup instead of GBASCALC
	STA GBASL
	LDA tablehi,Y
	STA GBASH
	; PLP     ; continue PLOT
	LDY #$01 ; x coord
loop1:
	STY H2
	LDA (MIDL),Y
	STA (PLOTL),Y
	BEQ empty
	BPL tree
	LDA #EMPTY2
doplot:	LDY H2
	STA (PLOTL),Y
	DEY
	EOR (GBASL),Y
	AND PLOTC
	EOR (GBASL),Y
	STA (GBASL),Y
noplot:
	LDY H2
	INY
	CPY #41
	BNE loop1
	LDA MIDL
	STA TOPL
	LDA MIDH
	STA TOPH
	LDA BTML
	STA MIDL
	STA PLOTL
	CLC
	ADC #42
	STA BTML
	LDA BTMH
	EOR #$10
	STA PLOTH
	EOR #$10		
	STA MIDH
	ADC #$00
	STA BTMH
;	LDX V2
	INX
	CPX #48
	BNE loop2

;;;	BIT $C000 ; apple ii keypress?
;;;	BPL CONT ; no keypressed then continue
;;;	BIT $C010 ; clear keyboard strobe
;;;	BIT $C051 ; text mode
;;;	rts

CONT:
	JMP loop3
empty:
	DEC SEED2
	BNE noplot
	JSR sseed2 ; probability f
	LDA #TREE2
	BNE doplot
ignite:
	LDA #FIRE2
	BNE doplot
tree:
	DEC SEED0
	BNE check
	DEC SEED1
	BNE check
	JSR sseed0 ; probability p
	BNE ignite
check:
	LDA (TOPL),Y ; n
	ORA (BTML),Y ; s
	DEY
	ORA (TOPL),Y ; nw
	ORA (MIDL),Y ; w
	ORA (BTML),Y ; sw
	INY
	INY
	ORA (TOPL),Y ; ne
	ORA (MIDL),Y ; e
	ORA (BTML),Y ; se
	BMI ignite
	BPL noplot

sseed0:
	LDA #$17 ; 1 in 10007 (prime)
	STA SEED0
	LDA #$27
	STA SEED1
	RTS
sseed2:
	LDA #$65  ; 1 in 101 (prime)
	STA SEED2
	RTS

;default:
;	LDA #<GBASCALC ; setup GBASCALC
;	STA SEED0
;	LDA #>GBASCALC
;	STA SEED1
;	LDA #25 ; screen rows
;	RTS
