#include <gb/gb.h>
#include <gb/drawing.h>

extern const unsigned char SpaceMapPLN0[];
extern const unsigned char SpaceTile[];
extern const unsigned char Space2[];
extern const unsigned char TitleTile[];

UWORD nocolours[] = {0,0,0,0,};
UWORD titlecolours[] = {32733,21140,10570,0,};

extern int D;
extern int D1;
extern int X;
extern int Y;
extern int Scene;
extern int v;
extern int Program;
extern int TIMER;

int ShipY = 0;
int ShipYY = 4;
int ShipY2 = 0;
int ShipYY2 = 0;
int ShipX = 0;
int ShipV = 0;
int ShipBox = 0;
int ShipR = 1;
int ShipR1 = 1;

void SPACE() {

    switch (Scene) {
	case 0:
	    wait_vbl_done();
        disable_interrupts();
        DISPLAY_OFF;
        for  (v = 0; v < 255; v++){remove_VBL(v); remove_LCD(v);}
        LCDC_REG =  0x47;
        mode (0xE2);
        move_bkg(0,0);
        DISPLAY_ON;
        enable_interrupts();	
    wait_vbl_done();	
	DISPLAY_OFF;
	HIDE_BKG;
	HIDE_SPRITES;
	SPRITES_8x8;
	if (_cpu == 0x11){ 
	    set_bkg_palette(0, 1, titlecolours);
		set_sprite_palette(0, 1, titlecolours);
	}
	set_bkg_data(0, 230, SpaceTile);
	set_bkg_tiles(0, 0, 25, 18, SpaceMapPLN0);
	set_sprite_data(0, 39, TitleTile);
	for (v = 0; v<39;v++)		
	set_sprite_tile(v, v);
	SHOW_SPRITES;
	SHOW_BKG;
	DISPLAY_ON;
	Scene = 1;
    break;
    case 1:
     TIMER++;
     //if (TIMER < 200)
	 move_sprite(0,32,32); move_sprite(1,40,32); move_sprite(2,48,32); 
	 move_sprite(3,56,32); move_sprite(4,64,32); move_sprite(5,72,32);

	 if (D == 8) {X = 1; D1++;}
	 if (D == 9) {D = 0; X = 0;}    
     scroll_bkg(X,0);
	 D++;
	 if (D1 >41) { 
	    D = 0; 
		D1 = 0; 
		Scene = 2; 
		move_bkg(0,0);
        for (v = 0; v<27;v+=2) move_sprite(v,-10,-10);		
		draw_image(Space2);
		delay(2000);
		TIMER = 0;
		}	 
	break;
	case 2:
	 if (ShipV == 2) { ShipY++;}
	 if (ShipV == 3) { ShipX++; ShipYY++; ShipV = 0;}		 
     if (ShipBox == 0) { 
	   if (ShipY > 40) {ShipV = 0; ShipY = 0; ShipX = 0; ShipYY = 4; ShipBox = 1;} 	 
	   color(1, 1, SOLID);
	   line(30+ShipX,ShipY,80,ShipYY);
       color(2, 2, SOLID);
	   line(80,ShipYY,130-ShipX,ShipY);	   
	   delay(20);
	 } 
	 if (ShipBox == 1) { 
       if (ShipY > 35) {ShipV = 0; ShipY = 0; ShipX = 0; ShipYY = 4; ShipBox = 2;} 	 
	   color(0, 0, SOLID);
	   line(30+ShipX,ShipY,80,ShipYY);
       color(0, 0, SOLID);
	   line(80,ShipYY,130-ShipX,ShipY);
	   color(3, 3, SOLID);
	   line(30+ShipX,ShipY,130-ShipX,ShipY);		   
	   delay(20);		
	 }
	 if (ShipBox == 2){ 
	   color(3, 3, SOLID);
	   
	   delay(20);
		if (ShipY > 35) {ShipV = 0; ShipY = 0; ShipX = 0; ShipYY = 4; ShipBox = 3;}
		delay(20);
	 } 
	 if (ShipBox == 3){
	    if (ShipR > 20) ShipR1+=3;
	    color(0, 0, SOLID);
		circle(80,50,ShipR,M_FILL);
		color(1, 1, SOLID);
		circle(80,50,ShipR1,M_FILL);		
		delay(20);
		ShipR+=4;
		if (ShipR > 50) {
		  wait_vbl_done(); 
		  DISPLAY_OFF;
		  Program = 1; 
		  Scene = 0;
		  delay(3000);
		  DISPLAY_ON;
		}
	 }
	 ShipV++; TIMER++;
	break;
	case 3:
       disable_interrupts();
       DISPLAY_OFF;
	   remove_VBL(0);
       for  (v = 2; v < 255; v++){remove_VBL(v); remove_LCD(v);}
       LCDC_REG =  0x47;
       mode (0xE2);
       move_bkg(0,0);
       DISPLAY_ON;
       enable_interrupts();	
    Program = 1;
	Scene = 0;
	TIMER = 0;
    wait_vbl_done();	
	break;
	}
}


const unsigned char SpaceMapPLN0[] =
{
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
  0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,
  0x0F,0x10,0x11,0x12,0x13,0xB5,0xB6,0xB7,0xB8,0xB9,
  0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,
  0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
  0xBA,0xBB,0xBC,0xBD,0xBE,0x28,0x29,0x2A,0x2B,0x2C,
  0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
  0x37,0x38,0x39,0x3A,0x3B,0xBF,0xC0,0xC1,0xC2,0xC3,
  0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,
  0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
  0xC4,0xC5,0xC6,0xC7,0xC8,0x50,0x51,0x52,0x53,0x54,
  0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,
  0x5F,0x60,0x61,0x62,0x63,0xC9,0xCA,0xCB,0xCC,0xCD,
  0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,
  0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
  0xCE,0xCF,0xD0,0xD1,0xD2,0x78,0x79,0x7A,0x7B,0x7C,
  0x7D,0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,0x85,0x86,
  0x87,0x88,0x89,0x8A,0x8B,0xD3,0xD4,0xD5,0xD6,0xD7,
  0x8C,0x8D,0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,
  0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
  0xD8,0xD9,0xDA,0xDB,0xDC,0xA0,0xA1,0xA2,0xA3,0xA4,
  0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,
  0xAF,0xB0,0xB1,0xB2,0xB3,0xDD,0xDE,0xDF,0xE0,0xE1,
  0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,
  0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,
  0xE2,0xE3,0xE4,0xE5,0xE6
 };

const unsigned char SpaceTile[] =
{
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0xDF,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x6F,0xBF,0xA7,0x5F,0x57,0xAF,0xAF,0x57,0x53,0xAF,0x29,0xD7,0x17,0xEB,0x49,0xF7,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x34,0xEB,0x8B,0x75,0x54,0xAB,0xA9,0x57,0x4A,0xBF,0xA8,0x57,0x5F,0xA0,0xAA,0x55,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0x3F,0xFF,0x9F,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0xFF,0xAA,0x55,0x5F,0xA0,0x4B,0xF4,0xD5,0xAA,0xAA,0x55,0x52,0xAF,0x56,0xFD,
0x4F,0xBF,0xA7,0x5F,0xD3,0x2F,0xB9,0x47,0x54,0xAB,0x29,0xD7,0x52,0xAF,0xA5,0x5F,
0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xDF,0xFF,0xAF,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0xFA,0xFF,0xD2,0xFD,0xA8,0xFF,0xF5,0xFF,0xEA,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0xAF,0xFF,0x97,0x7F,0x5B,0xAF,0x21,0xDF,0x94,0xEB,0x50,0xFF,0xA8,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0x2F,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x57,0xFF,0x94,0xEB,0x2A,0xD5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0x95,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0xD5,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x57,0xFF,0x94,0xEB,0x0A,0xF5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0x95,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFC,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD1,0xFF,0x9B,0xE0,0x2D,0xD0,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0x4A,0xBF,0xE9,0x17,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0x55,0xFF,
0xAD,0xFA,0xC1,0xFF,0xAA,0xFF,0xD5,0xFF,0xFF,0xFF,0xFF,0xFF,0xFA,0xFF,0x74,0xFF,
0x2A,0xFF,0x54,0xFF,0xA9,0xFE,0x51,0xFF,0xAA,0xFF,0x55,0xFF,0x0A,0xFF,0xA9,0x57,
0x82,0xFF,0x2A,0xD5,0x57,0xA8,0x0F,0xF0,0x95,0xEA,0x2A,0xD5,0x15,0xEA,0x4A,0xF5,
0xBE,0xFF,0x55,0xFF,0x4A,0xBF,0xA4,0x5F,0xF4,0x0B,0xA1,0x5F,0x4A,0xBF,0x57,0xFF,
0xAA,0xFF,0x55,0xFF,0xAA,0xFF,0x41,0xFF,0x94,0xEB,0x0A,0xF5,0xA5,0xFA,0x4A,0xF5,
0x02,0xFF,0x28,0xD7,0x95,0xEA,0x4A,0xF5,0x05,0xFA,0x0A,0xF5,0x55,0xAA,0xAA,0x55,
0xAA,0xFF,0x55,0xFF,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xEA,0x15,0x7F,0x80,0xFF,0x00,
0xA5,0xFA,0x52,0xFD,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xFD,0x02,0xFF,0x00,
0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAB,0x54,0xF5,0x0A,0xBF,0x40,0xFF,0x00,0xFD,0x00,
0xBF,0xFF,0x95,0x7F,0x52,0xAF,0xEA,0x15,0xFF,0x00,0xD5,0x00,0xAA,0x00,0x55,0x00,
0xFF,0xFF,0x7D,0xFF,0xFA,0xFF,0x54,0xFF,0x05,0xFA,0x6E,0x11,0xBF,0x00,0x5F,0x00,
0xAA,0xFF,0x55,0xFF,0x05,0xFA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xFF,0x00,0xFF,0x00,
0xA5,0xFA,0x52,0xFD,0x55,0xAA,0xAA,0x55,0x77,0x88,0xFB,0x04,0xFF,0x00,0xFF,0x00,
0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAB,0x54,0xF5,0x0A,0xBF,0x40,0xFF,0x00,0xFD,0x00,
0xBF,0xFF,0x95,0x7F,0x52,0xAF,0xEA,0x15,0xFF,0x00,0xD5,0x00,0xAA,0x00,0x55,0x00,
0xFF,0xFF,0x7F,0xFF,0xBE,0xFF,0x54,0xFF,0x55,0xAA,0x5D,0x00,0xA8,0x00,0x15,0x00,
0xE9,0xFE,0x4B,0xF4,0x5B,0xA0,0xB5,0x40,0xEA,0x00,0x56,0x01,0xAD,0x02,0x6B,0x14,
0x55,0xAA,0xA8,0x57,0xF4,0x0B,0x79,0x07,0xF4,0x0B,0xA9,0x57,0x52,0xAF,0xA5,0x5F,
0xF4,0x0B,0xA8,0x57,0x85,0xFA,0x4F,0xF0,0x97,0xE8,0x4A,0xF5,0xA8,0xFF,0xF5,0xFF,
0x20,0xFF,0xAA,0x55,0xF1,0x0E,0xE8,0x17,0x54,0xAB,0xA9,0x57,0x44,0xBB,0x25,0xDF,
0xAD,0xFA,0x50,0xFF,0xAA,0xFF,0x55,0xFF,0xAA,0xFF,0x4A,0xF5,0x55,0xAA,0xAA,0x55,
0x14,0xEB,0x0A,0xF5,0xA5,0xFA,0x50,0xFF,0xA5,0xFA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xA2,0xFF,0x55,0xFF,0x2A,0xFF,0xA9,0x57,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xEA,0xFF,0xF5,0xFF,0xFA,0xFF,0x5F,0xFF,0x0A,0xFF,0xA5,0x5F,0x55,0xAA,0xAA,0x55,
0xA5,0xFA,0x52,0xFD,0xA5,0xFA,0x4A,0xF5,0xA5,0xFA,0x0A,0xF5,0x57,0xA8,0xAF,0x50,
0x55,0xAA,0xAB,0x54,0x57,0xA8,0xAF,0x50,0x5E,0xA0,0xBD,0x40,0xAA,0x00,0xD5,0x00,
0xFA,0x00,0xD5,0x00,0xAA,0x00,0x54,0x00,0xA8,0x00,0x50,0x00,0xA0,0x00,0x55,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x55,0x00,
0xFA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x0A,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xA0,0x00,0x41,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xBA,0x00,0x7D,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFA,0x00,0x55,0x00,0xA8,0x00,0x40,0x00,0x80,0x00,0x54,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x41,0x00,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x15,0x00,0xAE,0x00,0xD7,0x00,
0xA0,0x00,0x40,0x00,0xAA,0x00,0x15,0x00,0xAA,0x00,0x75,0x00,0xFB,0x00,0x55,0x00,
0x02,0x00,0x11,0x00,0xAB,0x00,0x56,0x01,0xB5,0x0A,0xEA,0x15,0xF5,0x0A,0x5F,0x00,
0xDB,0x20,0x86,0x71,0x55,0xAA,0xA2,0x5D,0x51,0xAE,0xA2,0x5D,0x55,0xAA,0xEF,0x10,
0x42,0xBF,0xB5,0x5F,0x4A,0xBF,0xA5,0x5F,0x5A,0xAF,0xA5,0x5F,0xD4,0x2B,0xFA,0x05,
0xAB,0xFF,0x57,0xFF,0xAF,0xFF,0xF5,0xFF,0xEA,0xFF,0x4A,0xF5,0x15,0xEA,0xAA,0x55,
0xA2,0xFF,0xD4,0xFF,0xA9,0xFE,0x0A,0xF5,0x95,0xEA,0x2A,0xD5,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAF,0x50,0xFF,0x00,0xFA,0x05,0xF5,0x0A,0xFA,0x05,0x55,0xAA,0xAA,0x55,
0x75,0x8A,0xFF,0x00,0xEA,0x00,0xF5,0x00,0x7E,0x80,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xFE,0x01,0xAF,0x00,0x57,0x00,0xAD,0x02,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x75,0x8A,0xAF,0x50,0xDB,0x20,0xAF,0x50,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x7F,0x80,0xAB,0x54,0xD5,0x2A,0x7F,0x00,0xAF,0x00,0xFF,0x00,0x7F,0x80,0xEF,0x10,
0xEA,0x00,0xD5,0x00,0xAA,0x00,0xD5,0x00,0xAB,0x00,0xDF,0x00,0xFF,0x00,0x7F,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xFF,0x00,0xFF,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0xD7,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x5F,0x00,0xFF,0x00,0xEE,0x11,
0xBA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xFF,0x00,0xD7,0x00,
0xBE,0x00,0x5F,0x00,0xAA,0x00,0x5F,0x00,0xBF,0x00,0xFF,0x00,0xFF,0x00,0xBF,0x40,
0xAB,0x00,0x55,0x00,0xEA,0x00,0x55,0x00,0xEA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xEA,0x00,0x41,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x5F,0x00,0xFF,0x00,0xEF,0x10,
0xAA,0x00,0x55,0x00,0xFA,0x00,0xD5,0x00,0xEA,0x00,0xDF,0x00,0xFF,0x00,0xFF,0x00,
0xBF,0x00,0x57,0x00,0xAB,0x00,0x5F,0x00,0xBF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF5,0x0A,0xFA,0x05,0xBD,0x02,0x7F,0x00,0xFF,0x00,0xEA,0x15,0xF5,0x0A,0xFD,0x00,
0xFD,0x02,0xAA,0x55,0x55,0xAA,0xF5,0x00,0x7B,0x80,0xBE,0x41,0xFD,0x02,0x6A,0x15,
0x55,0xAA,0xEA,0x15,0xB5,0x0A,0xEA,0x15,0x55,0xAA,0x82,0x7D,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xBF,0x40,0x7A,0x80,0xF5,0x00,0x5E,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xA8,0x57,0x40,0xBF,0x55,0xFF,
0x55,0xAA,0x0A,0xF5,0x15,0xEA,0xAA,0x55,0x01,0xFE,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0x00,0xFF,0xA9,0xFE,0x52,0xFD,0xAA,0xFF,0x55,0xFF,
0xF5,0x0A,0xAA,0x55,0x50,0xAF,0xA9,0x57,0x56,0xAB,0x85,0x7F,0x0A,0xFF,0x55,0xFF,
0x57,0xA8,0xAB,0x54,0x15,0xEA,0x2A,0xD5,0x10,0xEF,0x45,0xFF,0xAA,0xFF,0x55,0xFF,
0xD5,0x2A,0xEB,0x14,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2B,0xD4,0x15,0xEA,0x0A,0xF5,
0xEF,0x00,0xFF,0x00,0xFF,0x00,0xFA,0x05,0xFD,0x02,0xFA,0x05,0x5D,0xA2,0xAA,0x55,
0xFF,0x00,0xFE,0x01,0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAB,0x54,0x57,0xA8,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0xFD,0x02,0xEA,0x15,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x5F,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xA0,0x5F,
0xEF,0x00,0xFF,0x00,0xFF,0x00,0xFA,0x05,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2A,0xD5,
0xFF,0x00,0xFE,0x01,0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x57,0xA8,0xAF,0x50,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xF5,0x0A,0xEA,0x15,0x55,0xAA,0xAA,0x55,
0x5F,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x00,0xFF,
0xDE,0x20,0xAB,0x54,0x55,0xAA,0xAA,0x55,0x54,0xAB,0xA9,0x57,0x0A,0xFF,0x55,0xFF,
0xD1,0x2E,0xAA,0x55,0x54,0xAB,0x2A,0xD5,0x04,0xFB,0x51,0xFF,0xAA,0xFF,0x55,0xFF,
0x5F,0xA0,0xAF,0x50,0x15,0xEA,0x2A,0xD5,0x55,0xAA,0x52,0xFD,0xA8,0xFF,0x55,0xFF,
0xD5,0x2A,0xAA,0x55,0x55,0xAA,0x84,0x7F,0x4A,0xBF,0x95,0x7F,0xAA,0xFF,0x55,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFE,0xFD,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xD4,0xFF,0x29,0xFE,0x96,0x7D,
0xF8,0xFF,0xFB,0xF5,0x94,0xEB,0x29,0xD7,0x52,0xAF,0xA5,0x5F,0x52,0xAF,0xA5,0x5F,
0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0xFE,0xF1,0xFD,0xE2,0xCA,0xF5,0xF5,0xEA,0xEA,0xD5,0x94,0xEB,0xA8,0xD7,
0x48,0xBF,0x96,0x7D,0x09,0xFE,0x12,0xFD,0x45,0xBA,0x8D,0x70,0x1F,0xE0,0xAA,0x55,
0x0A,0xFF,0x25,0xDF,0x4A,0xBF,0x95,0x7F,0x2E,0xFF,0x95,0x7F,0x4A,0xBF,0x05,0xFF,
0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xBF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFC,0xFF,0xF9,0xFE,0xF2,0xFD,
0xD5,0xAA,0x22,0xDD,0xD5,0xAA,0x0A,0xF5,0xA5,0xFA,0xAA,0x55,0xFF,0x00,0xAA,0x55,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xA9,0x57,0x03,0xFF,0x87,0x7F,0x52,0xAF,0x05,0xFF,
0x0A,0xFF,0xA5,0x5F,0x4B,0xBF,0x5F,0xFF,0xFE,0xFF,0xFC,0xFF,0xA9,0xFE,0x4A,0xF5,
0xFA,0xFF,0xF2,0xFD,0xB5,0xEA,0x6A,0xD5,0x75,0x8A,0xA8,0x57,0x50,0xAF,0xA9,0x57,
0xE5,0xFA,0xDA,0xF5,0xB5,0xEA,0xEF,0xD0,0xDD,0xA2,0x2A,0xD5,0x95,0xEA,0x42,0xFD,
0x55,0xAA,0xAA,0x55,0xF4,0x0B,0xE5,0x1F,0x74,0x8B,0xAA,0x55,0x20,0xFF,0x95,0x7F,
0x4A,0xBF,0x85,0x7F,0x2A,0xFF,0x57,0xFF,0xBF,0xFF,0x5F,0xFF,0xBE,0xFF,0xFF,0xFF,
0xB5,0xEA,0x49,0xF7,0x94,0xEB,0x6A,0xD5,0xD4,0xAB,0x2A,0xD5,0x75,0x8A,0xA8,0x57,
0x50,0xAF,0x45,0xFF,0xAA,0xFF,0x95,0x7F,0x2A,0xFF,0x94,0x7F,0x0B,0xFE,0x54,0xFF,
0xA9,0xFE,0x94,0x7F,0x6A,0xBF,0x45,0xFF,0xAB,0xFF,0x55,0xFF,0xA4,0xFB,0x2A,0xD5,
0x4F,0xBF,0x05,0xFF,0xAB,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0x17,0xFF,
0xFE,0xFF,0xFC,0xFF,0xFB,0xFE,0xF4,0xFF,0xE9,0xFE,0x49,0xF7,0x92,0xEF,0x55,0xFF,
0x40,0xBF,0xA5,0x5F,0x52,0xAF,0x81,0x7F,0xAA,0xFF,0x55,0xFF,0xAF,0xFF,0x5F,0xFF,
0xAE,0xFF,0x5F,0xFF,0xAF,0xFF,0x57,0xFF,0xAF,0xFF,0x57,0xFF,0xFA,0xFF,0xF5,0xFF,
0x55,0xAA,0xA1,0x5F,0x5A,0xAF,0x95,0x7F,0x4A,0xBF,0xA0,0x5F,0x55,0xAA,0xAA,0x55,
0x4B,0xBF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,0xAA,0xFF,0xA5,0x5F,0x54,0xAB,0xAA,0x55,
0xEB,0xFF,0xD5,0xFF,0xEA,0xFF,0x54,0xFF,0xA9,0xFE,0x55,0xFF,0xAF,0xFF,0x57,0xFF,
0xFF,0xFF,0x7F,0xFF,0xBF,0xFF,0x15,0xFF,0x4A,0xBF,0x55,0xFF,0xEA,0xFF,0xF5,0xFF,
0xEB,0xFF,0xD7,0xFF,0xAF,0xFF,0x55,0xFF,0x80,0xFF,0x55,0xFF,0xBF,0xFF,0x5F,0xFF,
0x55,0xAA,0x7D,0x00,0xAF,0x00,0x5A,0x05,0xB5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xEA,0x15,0xFF,0x00,0xAB,0x54,0x57,0xA8,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0xAF,0xFF,0xB5,0x5F,0xFD,0x02,0xD6,0x01,0xAF,0x00,0xDE,0x01,0x75,0x8A,0xAA,0x55,
0xFE,0xFF,0x55,0xFF,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x5E,0xA0,0xB5,0x40,
0xAA,0xFF,0x45,0xFF,0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xF5,0x0A,0x6A,0x15,
0x55,0xAA,0xA9,0x57,0x50,0xAF,0xAA,0x55,0x10,0xEF,0x55,0xFF,0xAA,0xFF,0x15,0xFF,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0x0A,0xF5,0xA5,0xFA,0x42,0xFD,0x80,0xFF,0x55,0xFF,
0x15,0xEA,0xAA,0x55,0x55,0xAA,0xA0,0x5F,0x04,0xFB,0x0A,0xF5,0x84,0xFB,0x51,0xFF,
0x7B,0x80,0xFA,0x05,0x55,0xAA,0xAA,0x55,0x44,0xBB,0x14,0xFF,0xAA,0xFF,0x55,0xFF,
0x55,0xAA,0x80,0x7F,0x41,0xBE,0x01,0xFF,0x2A,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char TitleTile[] =
{
  0xFF,0x00,0xFF,0x00,0xE0,0x00,0xFF,0x00,
  0xFF,0x00,0x07,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xE0,0x00,0xFF,0x00,
  0xFF,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xC0,0x00,0xC0,0x00,
  0xC0,0x00,0xC0,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xC3,0x00,0xC3,0x00,0xFF,0x00,0xFF,0x00,
  0xE3,0x00,0xF3,0x00,0xFB,0x00,0xFF,0x00,
  0xDF,0x00,0xCF,0x00,0xC7,0x00,0xC3,0x00,
  0xFC,0x00,0xFE,0x00,0xC7,0x00,0xC3,0x00,
  0xC3,0x00,0xC7,0x00,0xFE,0x00,0xFC,0x00,
  0xFE,0x00,0xFF,0x00,0xC3,0x00,0xFF,0x00,
  0xFE,0x00,0xDC,0x00,0xCE,0x00,0xC7,0x00,
  0xFF,0x00,0xFF,0x00,0xE0,0x00,0xFF,0x00,
  0xFF,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0x3C,0x00,0x7E,0x00,0xC3,0x00,0xC3,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,
  0xE0,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,
  0xE0,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0x38,0x00,0x00,0x00,0x38,0x00,0x38,0x00,
  0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,
  0xFF,0x00,0xFF,0x00,0x18,0x00,0x18,0x00,
  0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
  0xC3,0x00,0xC3,0x00,0xE7,0x00,0xFE,0x00,
  0x7C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xC3,0x00,0xC3,0x00,0xFF,0x00,0xFF,0x00,
  0xFE,0x00,0xFF,0x00,0xC3,0x00,0xFF,0x00,
  0xFE,0x00,0xDC,0x00,0xCE,0x00,0xC7,0x00,
  0x38,0x00,0x00,0x00,0x38,0x00,0x38,0x00,
  0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,
  0xFF,0x00,0xFF,0x00,0xC0,0x00,0xCF,0x00,
  0xCF,0x00,0xC1,0x00,0xFF,0x00,0xFF,0x00,
  0x38,0x00,0x00,0x00,0x38,0x00,0x38,0x00,
  0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,
  0xE3,0x00,0xF3,0x00,0xFB,0x00,0xFF,0x00,
  0xDF,0x00,0xCF,0x00,0xC7,0x00,0xC3,0x00,
  0x3C,0x00,0x7E,0x00,0xC3,0x00,0xC3,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,
  0xE0,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0x38,0x00,0x78,0x00,0x78,0x00,0x18,0x00,
  0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xFF,0x00,
  0xFF,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xFF,0x00,
  0xFF,0x00,0x03,0x00,0x03,0x00,0x03,0x00,
  0xFF,0x00,0xFF,0x00,0x03,0x00,0xFF,0x00,
  0xFF,0x00,0x03,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xC0,0x00,0xCF,0x00,
  0xCF,0x00,0xC1,0x00,0xFF,0x00,0xFF,0x00,
  0xFE,0x00,0xFF,0x00,0xC3,0x00,0xFE,0x00,
  0xFE,0x00,0xC3,0x00,0xFF,0x00,0xFE,0x00,
  0xFF,0x00,0xFF,0x00,0xC0,0x00,0xC0,0x00,
  0xC0,0x00,0xC0,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xC3,0x00,0xC3,0x00,0xFF,0x00,0xFF,0x00,
  0xFC,0x00,0xFE,0x00,0xC7,0x00,0xC3,0x00,
  0xC3,0x00,0xC7,0x00,0xFE,0x00,0xFC,0x00,
  0xFF,0x00,0xFF,0x00,0xC3,0x00,0xC3,0x00,
  0xC3,0x00,0xC3,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xC0,0x00,0xFF,0x00,
  0xFF,0x00,0xC0,0x00,0xFF,0x00,0xFF,0x00,
  0xFE,0x00,0xFF,0x00,0xC3,0x00,0xFE,0x00,
  0xFE,0x00,0xC3,0x00,0xFF,0x00,0xFE,0x00,
  0xC3,0x00,0xC3,0x00,0xE7,0x00,0xFE,0x00,
  0x7C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,
  0xC3,0x00,0xE7,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xDB,0x00,0xC3,0x00,0xC3,0x00,
  0x38,0x00,0x00,0x00,0x38,0x00,0x38,0x00,
  0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,
  0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,
  0xE0,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0xE0,0x00,0xE0,0x00,0xE0,0x00,0xE0,0x00,
  0xE0,0x00,0xE0,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xE0,0x00,0xFF,0x00,
  0xFF,0x00,0x07,0x00,0xFF,0x00,0xFF,0x00
};

const unsigned char Space2[] = {
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0x7F,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFE,0xFD,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xD4,0xFF,0x29,0xFE,0x96,0x7D,
0xF8,0xFF,0xFB,0xF5,0x94,0xEB,0x29,0xD7,0x52,0xAF,0xA5,0x5F,0x52,0xAF,0xA5,0x5F,
0xFE,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xF8,0xFE,0xF1,0xFD,0xE2,0xCA,0xF5,0xF5,0xEA,0xEA,0xD5,0x94,0xEB,0xA8,0xD7,
0x48,0xBF,0x96,0x7D,0x09,0xFE,0x12,0xFD,0x45,0xBA,0x8D,0x70,0x1F,0xE0,0xAA,0x55,
0x0A,0xFF,0x25,0xDF,0x4A,0xBF,0x95,0x7F,0x2E,0xFF,0x95,0x7F,0x4A,0xBF,0x05,0xFF,
0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xBF,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFC,0xFF,0xF9,0xFE,0xF2,0xFD,
0xD5,0xAA,0x22,0xDD,0xD5,0xAA,0x0A,0xF5,0xA5,0xFA,0xAA,0x55,0xFF,0x00,0xAA,0x55,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xA9,0x57,0x03,0xFF,0x87,0x7F,0x52,0xAF,0x05,0xFF,
0x0A,0xFF,0xA5,0x5F,0x4B,0xBF,0x5F,0xFF,0xFE,0xFF,0xFC,0xFF,0xA9,0xFE,0x4A,0xF5,
0xFA,0xFF,0xF2,0xFD,0xB5,0xEA,0x6A,0xD5,0x75,0x8A,0xA8,0x57,0x50,0xAF,0xA9,0x57,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0x2F,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x57,0xFF,0x94,0xEB,0x2A,0xD5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0x95,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0xD5,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x57,0xFF,0x94,0xEB,0x0A,0xF5,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0x95,0x7F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFC,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD1,0xFF,0x9B,0xE0,0x2D,0xD0,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0x4A,0xBF,0xE9,0x17,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0x55,0xFF,
0xE5,0xFA,0xDA,0xF5,0xB5,0xEA,0xEF,0xD0,0xDD,0xA2,0x2A,0xD5,0x95,0xEA,0x42,0xFD,
0x55,0xAA,0xAA,0x55,0xF4,0x0B,0xE5,0x1F,0x74,0x8B,0xAA,0x55,0x20,0xFF,0x95,0x7F,
0x4A,0xBF,0x85,0x7F,0x2A,0xFF,0x57,0xFF,0xBF,0xFF,0x5F,0xFF,0xBE,0xFF,0xFF,0xFF,
0xB5,0xEA,0x49,0xF7,0x94,0xEB,0x6A,0xD5,0xD4,0xAB,0x2A,0xD5,0x75,0x8A,0xA8,0x57,
0x50,0xAF,0x45,0xFF,0xAA,0xFF,0x95,0x7F,0x2A,0xFF,0x94,0x7F,0x0B,0xFE,0x54,0xFF,
0x02,0xFF,0x28,0xD7,0x95,0xEA,0x4A,0xF5,0x05,0xFA,0x0A,0xF5,0x55,0xAA,0xAA,0x55,
0xAA,0xFF,0x55,0xFF,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xEA,0x15,0x7F,0x80,0xFF,0x00,
0xA5,0xFA,0x52,0xFD,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xFD,0x02,0xFF,0x00,
0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAB,0x54,0xF5,0x0A,0xBF,0x40,0xFF,0x00,0xFD,0x00,
0xBF,0xFF,0x95,0x7F,0x52,0xAF,0xEA,0x15,0xFF,0x00,0xD5,0x00,0xAA,0x00,0x55,0x00,
0xFF,0xFF,0x7D,0xFF,0xFA,0xFF,0x54,0xFF,0x05,0xFA,0x6E,0x11,0xBF,0x00,0x5F,0x00,
0xAA,0xFF,0x55,0xFF,0x05,0xFA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xFF,0x00,0xFF,0x00,
0xA5,0xFA,0x52,0xFD,0x55,0xAA,0xAA,0x55,0x77,0x88,0xFB,0x04,0xFF,0x00,0xFF,0x00,
0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAB,0x54,0xF5,0x0A,0xBF,0x40,0xFF,0x00,0xFD,0x00,
0xBF,0xFF,0x95,0x7F,0x52,0xAF,0xEA,0x15,0xFF,0x00,0xD5,0x00,0xAA,0x00,0x55,0x00,
0xFF,0xFF,0x7F,0xFF,0xBE,0xFF,0x54,0xFF,0x55,0xAA,0x5D,0x00,0xA8,0x00,0x15,0x00,
0xE9,0xFE,0x4B,0xF4,0x5B,0xA0,0xB5,0x40,0xEA,0x00,0x56,0x01,0xAD,0x02,0x6B,0x14,
0x55,0xAA,0xA8,0x57,0xF4,0x0B,0x79,0x07,0xF4,0x0B,0xA9,0x57,0x52,0xAF,0xA5,0x5F,
0xF4,0x0B,0xA8,0x57,0x85,0xFA,0x4F,0xF0,0x97,0xE8,0x4A,0xF5,0xA8,0xFF,0xF5,0xFF,
0x20,0xFF,0xAA,0x55,0xF1,0x0E,0xE8,0x17,0x54,0xAB,0xA9,0x57,0x44,0xBB,0x25,0xDF,
0xA9,0xFE,0x94,0x7F,0x6A,0xBF,0x45,0xFF,0xAB,0xFF,0x55,0xFF,0xA4,0xFB,0x2A,0xD5,
0x4F,0xBF,0x05,0xFF,0xAB,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,0x17,0xFF,
0xFE,0xFF,0xFC,0xFF,0xFB,0xFE,0xF4,0xFF,0xE9,0xFE,0x49,0xF7,0x92,0xEF,0x55,0xFF,
0x40,0xBF,0xA5,0x5F,0x52,0xAF,0x81,0x7F,0xAA,0xFF,0x55,0xFF,0xAF,0xFF,0x5F,0xFF,
0xAE,0xFF,0x5F,0xFF,0xAF,0xFF,0x57,0xFF,0xAF,0xFF,0x57,0xFF,0xFA,0xFF,0xF5,0xFF,
0x55,0xAA,0xAB,0x54,0x57,0xA8,0xAF,0x50,0x5E,0xA0,0xBD,0x40,0xAA,0x00,0xD5,0x00,
0xFA,0x00,0xD5,0x00,0xAA,0x00,0x54,0x00,0xA8,0x00,0x50,0x00,0xA0,0x00,0x55,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x55,0x00,
0xFA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x0A,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xA0,0x00,0x41,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xBA,0x00,0x7D,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFA,0x00,0x55,0x00,0xA8,0x00,0x40,0x00,0x80,0x00,0x54,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x41,0x00,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x15,0x00,0xAE,0x00,0xD7,0x00,
0xA0,0x00,0x40,0x00,0xAA,0x00,0x15,0x00,0xAA,0x00,0x75,0x00,0xFB,0x00,0x55,0x00,
0x02,0x00,0x11,0x00,0xAB,0x00,0x56,0x01,0xB5,0x0A,0xEA,0x15,0xF5,0x0A,0x5F,0x00,
0xDB,0x20,0x86,0x71,0x55,0xAA,0xA2,0x5D,0x51,0xAE,0xA2,0x5D,0x55,0xAA,0xEF,0x10,
0x42,0xBF,0xB5,0x5F,0x4A,0xBF,0xA5,0x5F,0x5A,0xAF,0xA5,0x5F,0xD4,0x2B,0xFA,0x05,
0xAB,0xFF,0x57,0xFF,0xAF,0xFF,0xF5,0xFF,0xEA,0xFF,0x4A,0xF5,0x15,0xEA,0xAA,0x55,
0xA2,0xFF,0xD4,0xFF,0xA9,0xFE,0x0A,0xF5,0x95,0xEA,0x2A,0xD5,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xA1,0x5F,0x5A,0xAF,0x95,0x7F,0x4A,0xBF,0xA0,0x5F,0x55,0xAA,0xAA,0x55,
0x4B,0xBF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,0xAA,0xFF,0xA5,0x5F,0x54,0xAB,0xAA,0x55,
0xEB,0xFF,0xD5,0xFF,0xEA,0xFF,0x54,0xFF,0xA9,0xFE,0x55,0xFF,0xAF,0xFF,0x57,0xFF,
0xFF,0xFF,0x7F,0xFF,0xBF,0xFF,0x15,0xFF,0x4A,0xBF,0x55,0xFF,0xEA,0xFF,0xF5,0xFF,
0xEB,0xFF,0xD7,0xFF,0xAF,0xFF,0x55,0xFF,0x80,0xFF,0x55,0xFF,0xBF,0xFF,0x5F,0xFF,
0xEA,0x00,0xD5,0x00,0xAA,0x00,0xD5,0x00,0xAB,0x00,0xDF,0x00,0xFF,0x00,0x7F,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xFF,0x00,0xFF,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0xD7,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x5F,0x00,0xFF,0x00,0xEE,0x11,
0xBA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,0xFF,0x00,0xD7,0x00,
0xBE,0x00,0x5F,0x00,0xAA,0x00,0x5F,0x00,0xBF,0x00,0xFF,0x00,0xFF,0x00,0xBF,0x40,
0xAB,0x00,0x55,0x00,0xEA,0x00,0x55,0x00,0xEA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xEA,0x00,0x41,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0xD5,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x5F,0x00,0xFF,0x00,0xEF,0x10,
0xAA,0x00,0x55,0x00,0xFA,0x00,0xD5,0x00,0xEA,0x00,0xDF,0x00,0xFF,0x00,0xFF,0x00,
0xBF,0x00,0x57,0x00,0xAB,0x00,0x5F,0x00,0xBF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF5,0x0A,0xFA,0x05,0xBD,0x02,0x7F,0x00,0xFF,0x00,0xEA,0x15,0xF5,0x0A,0xFD,0x00,
0xFD,0x02,0xAA,0x55,0x55,0xAA,0xF5,0x00,0x7B,0x80,0xBE,0x41,0xFD,0x02,0x6A,0x15,
0x55,0xAA,0xEA,0x15,0xB5,0x0A,0xEA,0x15,0x55,0xAA,0x82,0x7D,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xBF,0x40,0x7A,0x80,0xF5,0x00,0x5E,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0x7D,0x00,0xAF,0x00,0x5A,0x05,0xB5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xEA,0x15,0xFF,0x00,0xAB,0x54,0x57,0xA8,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0xAF,0xFF,0xB5,0x5F,0xFD,0x02,0xD6,0x01,0xAF,0x00,0xDE,0x01,0x75,0x8A,0xAA,0x55,
0xFE,0xFF,0x55,0xFF,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x5E,0xA0,0xB5,0x40,
0xAA,0xFF,0x45,0xFF,0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xF5,0x0A,0x6A,0x15,
0xD5,0x2A,0xEB,0x14,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2B,0xD4,0x15,0xEA,0x0A,0xF5,
0xEF,0x00,0xFF,0x00,0xFF,0x00,0xFA,0x05,0xFD,0x02,0xFA,0x05,0x5D,0xA2,0xAA,0x55,
0xFF,0x00,0xFE,0x01,0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAB,0x54,0x57,0xA8,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0xFD,0x02,0xEA,0x15,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x5F,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xA0,0x5F,
0xEF,0x00,0xFF,0x00,0xFF,0x00,0xFA,0x05,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2A,0xD5,
0xFF,0x00,0xFE,0x01,0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x57,0xA8,0xAF,0x50,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xF5,0x0A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xF5,0x0A,0xEA,0x15,0x55,0xAA,0xAA,0x55,
0x5F,0xA0,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x00,0xFF,
0xDE,0x20,0xAB,0x54,0x55,0xAA,0xAA,0x55,0x54,0xAB,0xA9,0x57,0x0A,0xFF,0x55,0xFF,
0xD1,0x2E,0xAA,0x55,0x54,0xAB,0x2A,0xD5,0x04,0xFB,0x51,0xFF,0xAA,0xFF,0x55,0xFF,
0x5F,0xA0,0xAF,0x50,0x15,0xEA,0x2A,0xD5,0x55,0xAA,0x52,0xFD,0xA8,0xFF,0x55,0xFF,
0xD5,0x2A,0xAA,0x55,0x55,0xAA,0x84,0x7F,0x4A,0xBF,0x95,0x7F,0xAA,0xFF,0x55,0xFF,
0x55,0xAA,0xA9,0x57,0x50,0xAF,0xAA,0x55,0x10,0xEF,0x55,0xFF,0xAA,0xFF,0x15,0xFF,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0x0A,0xF5,0xA5,0xFA,0x42,0xFD,0x80,0xFF,0x55,0xFF,
0x15,0xEA,0xAA,0x55,0x55,0xAA,0xA0,0x5F,0x04,0xFB,0x0A,0xF5,0x84,0xFB,0x51,0xFF,
0x7B,0x80,0xFA,0x05,0x55,0xAA,0xAA,0x55,0x44,0xBB,0x14,0xFF,0xAA,0xFF,0x55,0xFF,
0x55,0xAA,0x80,0x7F,0x41,0xBE,0x01,0xFF,0x2A,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

