#include <gb/gb.h>
#include <gb/drawing.h>

extern const unsigned char PlasmaI[];
extern const unsigned char PlasMap[];
extern const unsigned char PlasMapCol[];
extern const unsigned char PlasTiles0[];
extern const unsigned char PlasTiles1[];
extern const unsigned char PlasTiles2[];
extern const unsigned char PlasTiles3[];
extern const unsigned char PlasTiles4[];

extern const unsigned char PlasmaSprites0[];
extern const unsigned char PlasmaSprites1[];
extern const unsigned char PlasmaSprites2[];
extern const unsigned char PlasmaSprites3[];
extern const unsigned char PlasmaSprites4[];
extern const unsigned char PlasmaSprites5[];
extern const unsigned char PlasmaSprites6[];
extern const unsigned char PlasmaSprites7[];
extern const unsigned char PlasmaSprites8[];
extern const unsigned char PlasmaSprites9[];
extern const unsigned char PlasmaSprites10[];
extern const unsigned char PlasmaSprites11[];
extern const unsigned char PlasmaSprites12[];

extern int Scene;
extern int v;
extern int Program;
int PlasFrame = 1;
int PlasCount = 0;
extern int TIMER;
int PPX = 30;
int PPY = 30;
int PLX = 1;
int PLY = 1;
int PPLX = 20;
int PPLY = 18;

extern int F2;
extern int YS2;
extern int FCount;

extern const UWORD GrayScale[];

void PLASMA() {
    switch (Scene) {
	case 0:
	    wait_vbl_done();
        disable_interrupts();
        DISPLAY_OFF;
        for  (v = 0; v < 255; v++){remove_VBL(v); remove_LCD(v);}
        LCDC_REG =  0x47;
        mode (0xE2);
        move_bkg(0,0);
		for (v = 0; v<40;v+=1) move_sprite(v,200,200);
		F2 = 0;
		YS2 = 0;
		FCount = 0;
        DISPLAY_ON;
        enable_interrupts();
	  TIMER = 0;
      wait_vbl_done();	
	  DISPLAY_OFF;
	  HIDE_BKG;
	  HIDE_SPRITES;
	  SPRITES_8x8;	
	  if (_cpu == 0x11){
     	  set_bkg_palette(0, 1, GrayScale);
		  set_sprite_palette(0, 1, GrayScale);
		  VBK_REG = 1;
		   set_bkg_tiles(0, 0, 20, 18, PlasMapCol);
	      VBK_REG = 0;
	  }
	  set_bkg_data(0, 3, PlasTiles0);
	  set_bkg_tiles(0, 0, 20, 18, PlasMap);
	  set_sprite_data(0, 16, PlasmaSprites1);
	  for (v = 0; v<20;v++)	set_sprite_tile(v, v);
	  SHOW_SPRITES;
	  SHOW_BKG;
	  DISPLAY_ON; 
	  Scene = 1;
	break;
	case 1:
      if (PlasFrame > 12) PlasFrame = 0;
      switch (PlasFrame){
	    case 0:
	       set_sprite_data(0, 16, PlasmaSprites0);
		   set_bkg_data(0, 4, PlasTiles0);
		break;
	    case 1:
	       set_sprite_data(0, 16, PlasmaSprites1);
		   set_bkg_data(0, 4, PlasTiles1);
		break;	
	    case 2:
	       set_sprite_data(0, 16, PlasmaSprites2);
		   set_bkg_data(0, 4, PlasTiles2);
		break;
	    case 3:
	       set_sprite_data(0, 16, PlasmaSprites3);
		   set_bkg_data(0, 4, PlasTiles3);
		break;
	    case 4:
	       set_sprite_data(0, 16, PlasmaSprites4);
		   set_bkg_data(0, 4, PlasTiles0);
		break;	
	    case 5:
	       set_sprite_data(0, 16, PlasmaSprites5);
		   set_bkg_data(0, 4, PlasTiles1);
		break;
	    case 6:
	       set_sprite_data(0, 16, PlasmaSprites6);
		   set_bkg_data(0, 4, PlasTiles2);
		break;
	    case 7:
	       set_sprite_data(0, 16, PlasmaSprites7);
		   set_bkg_data(0, 4, PlasTiles3);
		break;	
	    case 8:
	       set_sprite_data(0, 16, PlasmaSprites8);
		   set_bkg_data(0, 4, PlasTiles3);
		break;
	    case 9:
	       set_sprite_data(0, 16, PlasmaSprites9);
		   set_bkg_data(0, 4, PlasTiles3);
		break;
	    case 10:
	       set_sprite_data(0, 16, PlasmaSprites10);
           set_bkg_data(0, 4, PlasTiles2);		   
		break;	
	    case 11:
	       set_sprite_data(0, 16, PlasmaSprites11);
		   set_bkg_data(0, 4, PlasTiles1);
		break;	
	    case 12:
	       set_sprite_data(0, 16, PlasmaSprites12);
		   set_bkg_data(0, 4, PlasTiles0);
		break;		
	  }
	  
	  
	  if (PPX > 136) PLX = -1;
	  if (PPX < 8) PLX = 1;
	  if (PPY > 128) PLY = -1;
	  if (PPY < 16) PLY = 1;
	  if (PPLX = 20) PPLX = 1;
	  if (PPLY = 180) PPLY = 18;	  
	  
	  if (PlasCount == 4) {PlasCount = 0; PlasFrame+=1;}
	  
	  move_sprite(0,PPX,PPY);move_sprite(1,PPX+8,PPY);move_sprite(2,PPX+16,PPY);move_sprite(3,PPX+24,PPY);
	  move_sprite(4,PPX,PPY+8);move_sprite(5,PPX+8,PPY+8);move_sprite(6,PPX+16,PPY+8);move_sprite(7,PPX+24,PPY+8);
	  move_sprite(8,PPX,PPY+16);move_sprite(9,PPX+8,PPY+16);move_sprite(10,PPX+16,PPY+16);move_sprite(11,PPX+24,PPY+16);
	  move_sprite(12,PPX,PPY+24);move_sprite(13,PPX+8,PPY+24);move_sprite(14,PPX+16,PPY+24);move_sprite(15,PPX+24,PPY+24);
	  
	  if (TIMER == 910){Program = 13; Scene = 0;}
	  
	  PPX+=PLX;PPY+=PLY; PPLX++;
	  TIMER++; PlasCount++;	
	break;
	}
}


const unsigned char PlasMap[] =
{
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,
  0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,
  0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,
  0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,
  0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,
  0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,
  0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,
  0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,
  0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,
  0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,
  0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,
  0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,
  0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,
  0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,
  0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,
  0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,
  0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,
  0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,
  0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,
  0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,
  0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,
  0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,
  0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,
  0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,0x01,
  0x01,0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,
  0x03,0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x00,
  0x00,0x03,0x02,0x01,0x00,0x03,0x02,0x01,0x00,0x03
};
const unsigned char PlasMapCol[] =
{

  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

const unsigned char PlasTiles0[] =
{
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
};
const unsigned char PlasTiles1[] =
{
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasTiles2[] =
{
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
};
const unsigned char PlasTiles3[] =
{
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
  0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF, 
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00  
};

const unsigned char PlasmaSprites0[] =
{
0x00,0x00,0x30,0x7F,0x67,0x78,0x5F,0x70,0x5F,0x60,0x4D,0x70,0x13,0x60,0x71,0x40,
0x00,0x00,0x72,0xFD,0x39,0xFE,0xFA,0x7D,0x38,0xFF,0xB8,0x7F,0x38,0xFF,0xF0,0x7F,
0x00,0x00,0x3F,0xFF,0x3F,0xFF,0x7F,0xFF,0x3F,0xFF,0x7F,0xFF,0x7E,0xFF,0x7D,0xFF,
0x00,0x00,0xF4,0xFE,0xF2,0xFE,0xF2,0xFE,0xF2,0xFE,0xF2,0xFE,0xFA,0xFE,0xF0,0xFE,
0x3B,0x40,0x3E,0x41,0x1C,0x63,0x59,0x67,0x23,0x7F,0x53,0x7F,0x7F,0x7F,0x7F,0x7F,
0xB8,0xFF,0x70,0xFF,0xE4,0xFB,0xC8,0xF7,0xD5,0xEA,0xEE,0xD1,0x79,0x82,0x36,0xC1,
0xFA,0xFF,0x75,0xFF,0xE0,0xFF,0xF0,0xFF,0xE0,0xFF,0x70,0xFF,0xEA,0xFF,0x75,0xFF,
0xF0,0xFE,0x70,0xFE,0xE4,0xFA,0x7A,0xF4,0xE6,0xF8,0x7C,0xF0,0xEA,0xF0,0xE4,0xF0,
0x7E,0x7F,0x7C,0x7F,0x7E,0x7F,0x7C,0x7F,0x7E,0x7F,0x7E,0x7F,0x7F,0x7F,0x7F,0x7F,
0x6B,0x80,0xD6,0x01,0x69,0x82,0xD6,0x01,0x6C,0x83,0xB8,0x47,0x11,0xEF,0xA1,0xDF,
0x7A,0xFF,0x7D,0xFF,0x7E,0xFF,0x7D,0xFF,0xFE,0xFF,0xFD,0xFF,0xFC,0xFF,0xFC,0xFF,
0xE8,0xF0,0xE4,0xF0,0xE8,0xF0,0xE4,0xF0,0xE0,0xF8,0x7C,0xF0,0xB6,0xF8,0x70,0xFC,
0x2B,0x7F,0x57,0x7F,0x13,0x6F,0x39,0x47,0x3C,0x43,0x3F,0x41,0x7C,0x03,0x00,0x00,
0x83,0xFF,0xD7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0x00,0x00,
0xC1,0xFE,0xCF,0xF0,0x9F,0xE0,0x7C,0xC0,0x90,0xE0,0x78,0xC0,0xDF,0xE0,0x00,0x00,
0x38,0xFE,0x9A,0x7C,0xF8,0x3E,0x9C,0x7E,0xF8,0x3E,0xBC,0x7E,0x38,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasmaSprites1[] =
{
0x00,0x00,0x4E,0x71,0x1F,0x60,0x77,0x40,0x63,0x00,0x13,0x40,0x63,0x00,0x56,0x01,
0x00,0x00,0x7F,0xFF,0xBF,0xFF,0x7F,0xFF,0x3F,0xFF,0x7F,0xFF,0xF9,0xFF,0xF1,0xFF,
0x00,0x00,0xD0,0xFF,0xE0,0xFF,0xD0,0xFF,0xE2,0xFF,0xF1,0xFF,0xFA,0xFF,0xF5,0xFF,
0x00,0x00,0x7E,0xFE,0xBE,0xFE,0x7C,0xFE,0xBE,0xFE,0x7C,0xFE,0xFE,0xFE,0xFE,0xFE,
0x7C,0x03,0x39,0x47,0x13,0x6F,0x47,0x7F,0x7E,0x7F,0x7C,0x7F,0x79,0x7E,0x7E,0x7D,
0xF4,0xEB,0xC8,0xF7,0x9D,0xE2,0x36,0xC1,0x6B,0x80,0xD6,0x01,0xA9,0x02,0x56,0x01,
0xFF,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x7F,0xFF,0x3E,0xFF,0x7F,0xFF,
0xFE,0xFE,0xC6,0xFE,0x94,0xEA,0x3C,0xC2,0x6A,0x80,0xD4,0x00,0x42,0x80,0xC0,0x00,
0x79,0x7E,0x72,0x7D,0x79,0x7E,0x72,0x7D,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0xA9,0x02,0x56,0x01,0x7C,0x83,0xA9,0x57,0x03,0xFF,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xEB,0xFF,0xD7,0xFF,0xE2,0xFF,0xD1,0xFF,0xE4,0xFB,0xCE,0xF1,
0x60,0x80,0x40,0x80,0xA0,0xC0,0x90,0xC0,0xDA,0xE0,0xF4,0xC0,0xEA,0xF0,0x6E,0xF0,
0x2F,0x7F,0x57,0x7F,0x0B,0x7F,0x07,0x7F,0x0B,0x7F,0x07,0x7F,0x2B,0x7F,0x00,0x00,
0xFF,0xFF,0xFD,0xFF,0xFA,0xFF,0xFD,0xFF,0xFE,0xFF,0xFD,0xFF,0xFE,0xFF,0x00,0x00,
0x9F,0xE0,0x5D,0xE0,0x33,0xC0,0x31,0xC0,0x63,0x80,0x71,0x80,0x7E,0x81,0x00,0x00,
0xA4,0xFA,0x7A,0xF4,0x30,0xFE,0xF0,0x7E,0x30,0xFE,0x70,0xFE,0xE4,0xFA,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasmaSprites2[] =
{
0x00,0x00,0x36,0x41,0x4E,0x01,0x46,0x01,0x0C,0x03,0x46,0x01,0x6F,0x03,0x7B,0x07,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF,0xFF,0xF7,0xFF,0xE3,0xFF,0xF1,0xDF,
0x00,0x00,0x3E,0xC1,0x9F,0xE0,0x7E,0xC1,0x84,0xFB,0xC1,0xFF,0xEA,0xFF,0xF7,0xFF,
0x00,0x00,0x7E,0xFE,0x2E,0xFE,0x14,0xFE,0xA8,0xFE,0x74,0xFE,0xFC,0xFE,0xFC,0xFE,
0x5B,0x2F,0x07,0x7F,0x3E,0x7F,0x7C,0x7F,0x79,0x7E,0x73,0x7C,0x65,0x7A,0x0B,0x74,
0xD4,0xAB,0xB6,0x41,0x69,0x82,0xD6,0x01,0xAB,0x00,0x56,0x01,0xAD,0x02,0x52,0x05,
0xFF,0xFF,0x7F,0xFF,0x7A,0xFF,0x74,0xFF,0x39,0xFE,0x7B,0xFC,0xF9,0xFE,0xF7,0xFC,
0xBE,0xFE,0x8E,0xFE,0x52,0xAE,0xFA,0x06,0xAC,0x02,0x56,0x00,0x8A,0x00,0x06,0x00,
0x01,0x7E,0x02,0x7D,0x40,0x7F,0x74,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0xFC,0x03,0xA9,0x57,0x03,0xFF,0x17,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFD,0xFE,0xFC,0xFF,0xEE,0xFF,0xD7,0xFF,0x93,0xEF,0x33,0xCF,0x7E,0x83,0x35,0xC3,
0x82,0x00,0x42,0x00,0x0A,0x80,0xC6,0x00,0x2C,0xC2,0x34,0xC2,0x96,0xEA,0xEA,0xD6,
0x3A,0x7F,0x55,0x7F,0x2A,0x7F,0x55,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,0x00,
0xAE,0xFF,0x57,0xFF,0xAA,0xFF,0x54,0xFF,0xFA,0xFF,0xFD,0xFF,0xFE,0xFF,0x00,0x00,
0x64,0x83,0x42,0x81,0x40,0x83,0xC6,0x01,0x6C,0x83,0xF9,0x07,0x73,0x8F,0x00,0x00,
0xC2,0xFE,0xC2,0xFE,0xE2,0xFE,0xC2,0xFE,0xD2,0xEE,0xEA,0xD6,0xD6,0xAA,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites3[] =
{
0x00,0x00,0x59,0x07,0x3B,0x07,0x7B,0x07,0x7B,0x0F,0x67,0x1F,0x2E,0x7F,0x5C,0x7F,
0x00,0x00,0xFD,0xFF,0xBE,0xFF,0x7F,0xFF,0x8F,0xFF,0x07,0xFF,0x57,0xAB,0xF9,0x07,
0x00,0x00,0xFE,0x01,0x7C,0x83,0x7C,0xC3,0xA2,0xFF,0xD1,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x7E,0xFE,0xAA,0xFE,0x54,0xFE,0xA8,0xFE,0xF4,0xFE,0xFA,0xFE,0xFC,0xFE,
0x79,0x7E,0x73,0x7C,0x64,0x7A,0x4B,0x74,0x06,0x78,0x1B,0x74,0x01,0x7E,0x02,0x7D,
0xAC,0x03,0x50,0x07,0xAC,0x03,0x52,0x05,0xAC,0x03,0x59,0x07,0x53,0xAF,0xA7,0x5F,
0xFE,0xFF,0xF8,0xFF,0x61,0xFE,0x43,0xFC,0xE6,0xF8,0xE9,0xF4,0xF6,0xF8,0xF1,0xFC,
0x3E,0xFE,0x9E,0x7E,0xDE,0x2E,0x62,0x1E,0xA2,0x0E,0x5A,0x06,0x26,0x0A,0x18,0x06,
0x1A,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7A,0x7F,0x55,0x7F,0x40,0x7F,0x50,0x7F,
0x0F,0xFF,0xDF,0xFF,0xFE,0xFF,0xFD,0xFF,0xFE,0xFF,0xFC,0xFF,0xBD,0xFE,0x7D,0xFE,
0xF8,0xFE,0x7F,0xFC,0x2D,0xFE,0x1C,0xFF,0xEE,0x1F,0xF7,0x0F,0xB3,0x0F,0x5F,0x07,
0xA2,0x0E,0x5A,0x06,0xB2,0x0E,0xE6,0x1E,0x5E,0xAE,0xAC,0x5E,0x0E,0xFE,0x1C,0xFE,
0x00,0x7F,0x40,0x7F,0x6A,0x7F,0x55,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x00,0x00,
0xB9,0xFE,0x57,0xFC,0xB9,0xFE,0x75,0xFE,0xF8,0xFF,0xFC,0xFF,0xBF,0xFF,0x00,0x00,
0x33,0x0F,0x1F,0x07,0xBB,0x0F,0xE7,0x1F,0x4E,0xBF,0x1C,0xFF,0xBD,0xFE,0x00,0x00,
0x8C,0xFE,0x1C,0xFE,0x0C,0xFE,0x1C,0xFE,0x5E,0xAE,0xA4,0x5E,0xB6,0x0E,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasmaSprites4[] =
{
0x00,0x00,0x6F,0x1F,0x6E,0x3F,0x1C,0x7F,0x3D,0x7E,0x7E,0x7D,0x79,0x7E,0x72,0x7D,
0x00,0x00,0x1F,0xFF,0x0F,0xFF,0x0F,0xFF,0x4F,0xBF,0x87,0x7F,0xD3,0x2F,0xE3,0x1F,
0x00,0x00,0x21,0xDF,0xAA,0xFF,0x45,0xFF,0xFF,0xFF,0xFF,0xFF,0xFB,0xFF,0xF2,0xFD,
0x00,0x00,0x54,0xFE,0xA8,0xFE,0xD4,0xFE,0xF8,0xFE,0xF4,0xFE,0xFE,0xFE,0x7C,0xFE,
0x65,0x7A,0x0A,0x75,0x01,0x7E,0x42,0x7D,0x00,0x7F,0x54,0x7F,0x7F,0x7F,0x7F,0x7F,
0xD1,0x2F,0xE1,0x1F,0x53,0xAF,0xA7,0x5F,0x0F,0xFF,0x1F,0xFF,0x1F,0xFF,0x7F,0xFF,
0xE7,0xF8,0xCD,0xF0,0xCA,0xF0,0xCD,0xF0,0xEA,0xF0,0xED,0xF0,0xE6,0xF8,0xF5,0xF8,
0x5E,0xBE,0xDE,0x3E,0xBE,0x0E,0x62,0x1E,0xBE,0x0E,0x66,0x1E,0xBE,0x0E,0x6E,0x1E,
0x7F,0x7F,0x7F,0x7F,0x03,0x7F,0x43,0x7F,0x12,0x6F,0x69,0x57,0x1C,0x63,0x28,0x57,
0x7E,0xFF,0xFC,0xFF,0xF9,0xFE,0xF7,0xFC,0xFF,0xF8,0xF3,0xFC,0xA7,0xF8,0x57,0xF8,
0xBE,0xF8,0x7B,0xFC,0x69,0xBE,0x9C,0x7F,0xCE,0x3F,0x7C,0x1F,0xCE,0x3F,0x7E,0x1F,
0xCE,0x3E,0x7C,0x1E,0x78,0xBE,0x9E,0x7C,0x3A,0xFC,0x72,0xFC,0x7E,0xF8,0x72,0xFC,
0x02,0x7F,0x41,0x7F,0x6F,0x7F,0x7F,0x7F,0x7E,0x7F,0x74,0x7F,0x25,0x7A,0x00,0x00,
0xA7,0xF8,0x53,0xFC,0xF8,0xFF,0xFD,0xFF,0xFF,0xFF,0x9F,0x7F,0xF3,0x0F,0x00,0x00,
0xCE,0x3F,0x9C,0x7F,0x3C,0xFF,0x7C,0xFF,0xF9,0xFE,0xF2,0xFD,0xE7,0xF8,0x00,0x00,
0x7E,0xF8,0x72,0xFC,0x38,0xFE,0x3C,0xFE,0x7E,0xBE,0x9C,0x7E,0x4E,0xBE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites5[] =
{
0x00,0x00,0x78,0x7F,0x68,0x7F,0x78,0x7F,0x70,0x7F,0x70,0x7F,0x60,0x7F,0x00,0x7F,
0x00,0x00,0x1F,0xFF,0x3F,0xFF,0x1F,0xFF,0x3F,0xFF,0x1F,0xFF,0x3F,0xFF,0x1F,0xFF,
0x00,0x00,0x7F,0xFF,0xFF,0xFF,0xFD,0xFF,0xF4,0xFB,0xEA,0xF5,0xDE,0xE0,0xCD,0xF0,
0x00,0x00,0xCA,0xF4,0xE6,0xF8,0xF2,0xFC,0xF8,0xFE,0x74,0xFE,0xFE,0x3E,0xDC,0x3E,
0x40,0x7F,0x00,0x7F,0x38,0x7F,0x7C,0x7F,0x7C,0x7F,0x7C,0x7F,0x7F,0x7F,0x7F,0x7F,
0x3F,0xFF,0x1F,0xFF,0x3F,0xFF,0x1F,0xFF,0x3E,0xFF,0x3D,0xFF,0x38,0xFF,0x3C,0xFF,
0x98,0xE0,0xF4,0xC0,0xD8,0xE0,0xD4,0xE0,0xF8,0xE0,0xE4,0xF0,0xEE,0xF0,0x7D,0xF0,
0x8E,0x3E,0x7E,0x1E,0x8E,0x3E,0x6E,0x1E,0x8E,0x3E,0x7C,0x1E,0xF8,0x3E,0x9C,0x7E,
0x2F,0x7F,0x57,0x7F,0x0B,0x7F,0x05,0x7F,0x0A,0x7F,0x05,0x7F,0x2B,0x7F,0x5F,0x7F,
0xB5,0xFA,0xF3,0xFC,0xE7,0xF8,0x4F,0xF0,0x8F,0xF0,0x4F,0xF0,0xA7,0xF8,0xD2,0xFD,
0x35,0xFA,0xB2,0x7D,0x38,0xFF,0x9C,0x7F,0xBC,0x7F,0x9D,0x7F,0x3C,0xFF,0x7C,0xFF,
0x38,0xFE,0xF2,0x7C,0x66,0xF8,0x7E,0xF0,0xE6,0xF8,0xFC,0xF0,0xE6,0xF8,0xFE,0xF0,
0x7F,0x7F,0x75,0x7F,0x65,0x7A,0x4B,0x74,0x1A,0x60,0x35,0x40,0x18,0x60,0x00,0x00,
0xFA,0xFF,0xFF,0xFF,0x3F,0xFF,0xE7,0x1F,0xB2,0x0F,0x58,0x07,0x2C,0x03,0x00,0x00,
0xF8,0xFF,0xF0,0xFF,0xE5,0xFA,0xCA,0xF5,0x85,0xFA,0x0A,0xF5,0x05,0xFA,0x00,0x00,
0xE6,0xF8,0xF2,0xFC,0x78,0xFE,0x74,0xFE,0x3E,0xFE,0x3E,0xFE,0x3E,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasmaSprites6[] =
{
0x00,0x00,0x71,0x7F,0x61,0x7F,0x41,0x7F,0x00,0x7F,0x00,0x7F,0x10,0x6F,0x20,0x5F,
0x00,0x00,0xF5,0xFF,0xEA,0xFF,0xF5,0xFF,0xFA,0xFF,0xF5,0xFF,0xFA,0xFF,0x7D,0xFF,
0x00,0x00,0xF0,0xFF,0xE7,0xF8,0xCD,0xF0,0xDA,0xE0,0xD5,0xE0,0xD0,0xE0,0xD0,0xE0,
0x00,0x00,0xCE,0xF0,0x76,0xF8,0x32,0xFC,0xF8,0x3E,0x5C,0x3E,0x9E,0x3E,0x5C,0x3E,
0x00,0x7F,0x00,0x7F,0x00,0x7F,0x54,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0x3A,0xFF,0x3D,0xFF,0x3A,0xFF,0x1D,0xFF,0xF8,0xFF,0xF2,0xFD,0xE7,0xF8,0xCF,0xF0,
0xD0,0xE0,0xD4,0xE0,0xF8,0xE0,0xC4,0xF0,0xEA,0xF0,0x7D,0xF0,0x36,0xF8,0xFB,0x74,
0x0E,0x3E,0x3C,0x1E,0x8E,0x3E,0x5C,0x3E,0xF8,0x3E,0x5C,0x3E,0xF6,0x38,0xB2,0x7C,
0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x70,0x7F,0x62,0x7D,
0x9F,0xE0,0x5F,0xE0,0x9F,0xE0,0x4F,0xF0,0xD7,0xE8,0xC2,0xFD,0xFA,0xFF,0x7F,0xFF,
0x31,0xFE,0xB2,0x7D,0x38,0xFF,0xB0,0x7F,0xF8,0xFF,0x71,0xFF,0xE0,0xFF,0xE0,0xFF,
0x66,0xF8,0x7C,0xF0,0xE8,0xF0,0xCC,0xF0,0xF8,0xE0,0xCC,0xF0,0xE6,0xF8,0xDE,0xF0,
0x5F,0x60,0x75,0x40,0x18,0x60,0x54,0x60,0x10,0x60,0x74,0x40,0x18,0x60,0x00,0x00,
0x7F,0xBF,0xDF,0x3F,0xB6,0x2F,0x60,0x1F,0x30,0x0F,0x10,0x0F,0xB3,0x0F,0x00,0x00,
0xC5,0xFA,0xCA,0xF5,0x95,0xEA,0x2A,0xD5,0x95,0xEA,0x2A,0xD5,0x80,0xFF,0x00,0x00,
0xE4,0xFA,0xF0,0xFE,0x7A,0xFE,0x74,0xFE,0x7E,0xFE,0x7E,0xFE,0x3E,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

const unsigned char PlasmaSprites7[] =
{
0x00,0x00,0x39,0x47,0x6C,0x03,0x54,0x03,0x68,0x03,0x56,0x01,0x28,0x03,0x56,0x01,
0x00,0x00,0xCE,0xF1,0xE4,0xFB,0xD0,0xFF,0xFA,0xFF,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x75,0xF8,0xE2,0xF8,0xCD,0xF0,0xE8,0xF0,0xE4,0xF0,0xE8,0xF0,0xE4,0xF0,
0x00,0x00,0xB2,0x7C,0xFA,0x3E,0x5C,0xBE,0x8E,0x3E,0x6E,0x1E,0xBE,0x0E,0x6E,0x1E,
0x2C,0x03,0x55,0x03,0x6C,0x03,0x39,0x47,0x13,0x6F,0x23,0x5F,0x43,0x7F,0x47,0x7F,
0xFB,0xFF,0xFF,0xFF,0xEA,0xFF,0xD0,0xFF,0xC7,0xF8,0xCF,0xF0,0x9F,0xE0,0x7F,0xC0,
0xEA,0xF0,0xED,0xF0,0xE6,0xF8,0x7D,0xF0,0x37,0xF8,0x72,0xFD,0x38,0xFF,0xF8,0x7F,
0xBE,0x0E,0x66,0x1E,0xCE,0x3E,0x9C,0x7E,0xF8,0x3E,0xB6,0x7C,0x76,0xF8,0x76,0xF8,
0x63,0x7F,0x47,0x7F,0x63,0x7F,0x61,0x7F,0x64,0x7B,0x4A,0x75,0x5B,0x60,0x57,0x60,
0x9B,0xE0,0xDF,0xE0,0xDF,0xE0,0xC8,0xF7,0xEA,0xFF,0x77,0xFF,0x3F,0xFF,0x9F,0x7F,
0x38,0xFF,0x30,0xFF,0xF0,0xFF,0xF0,0xFF,0xE5,0xFA,0xCA,0xF5,0x99,0xE2,0x36,0xC1,
0xEC,0xF0,0xDC,0xF0,0xE8,0xF0,0xCC,0xF0,0xEA,0xF0,0xCE,0xF0,0xE6,0xF8,0x5E,0xF0,
0x5B,0x60,0x75,0x40,0x1A,0x60,0x65,0x50,0x0B,0x70,0x4F,0x70,0x60,0x7F,0x00,0x00,
0xCE,0x3F,0x44,0x3F,0xC0,0x3F,0xC4,0x3F,0xCE,0x3F,0x9F,0x7F,0x2F,0xFF,0x00,0x00,
0x6B,0x80,0x96,0x41,0x6B,0x80,0x96,0x41,0x1C,0xE3,0x28,0xD7,0x80,0xFF,0x00,0x00,
0xE2,0xFE,0x70,0xFE,0xFA,0xFE,0x76,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites8[] =
{
0x00,0x00,0x16,0x41,0x43,0x00,0x41,0x00,0x02,0x00,0x41,0x00,0x43,0x00,0x42,0x01,
0x00,0x00,0x51,0xFF,0xEB,0xFF,0x77,0xFF,0xEB,0xFF,0x77,0xFF,0xEB,0xFF,0xD7,0xFF,
0x00,0x00,0xF0,0xFF,0xA1,0xFE,0x42,0xFD,0x81,0xFE,0x82,0xFD,0x80,0xFF,0x40,0xFF,
0x00,0x00,0x1E,0xFE,0x4A,0xBE,0x80,0x7E,0x50,0xAE,0x80,0x7E,0x00,0xFE,0x00,0xFE,
0x6B,0x00,0x56,0x01,0x28,0x43,0x3F,0x41,0x11,0x6F,0x49,0x77,0x63,0x7F,0x63,0x7F,
0xE3,0xFF,0xC1,0xFF,0xDC,0xE3,0xFE,0xC1,0xDF,0xE0,0xFF,0xC0,0x9F,0xE0,0xDF,0xE0,
0xE0,0xFF,0xFD,0xFF,0xFF,0xFF,0x7F,0xFF,0x3F,0xFF,0x7F,0xFF,0x3F,0xFF,0x3F,0xFF,
0x0E,0xFE,0x7E,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFC,0xFE,0xE8,0xFE,0xF4,0xFE,
0x73,0x7F,0x71,0x7F,0x61,0x7F,0x70,0x7F,0x65,0x7A,0x6A,0x75,0x65,0x7A,0x4A,0x75,
0xDF,0xE0,0xC8,0xF7,0xEA,0xFF,0x77,0xFF,0xFF,0xFF,0x7F,0xFF,0x3E,0xFF,0x10,0xFF,
0xBF,0xFF,0x7F,0xFF,0xE0,0xFF,0xC0,0xFF,0x9D,0xE2,0x36,0xC1,0xEB,0x00,0xD5,0x00,
0xE0,0xFE,0xF0,0xFE,0xE0,0xFE,0xF0,0xFE,0xF8,0xFE,0x74,0xFE,0x7A,0xFE,0xF4,0x7E,
0x45,0x7A,0x4A,0x75,0x04,0x7B,0x48,0x77,0x42,0x7F,0x47,0x7F,0x7F,0x7F,0x00,0x00,
0x09,0xFE,0x12,0xFD,0x38,0xFF,0x7C,0xFF,0xFE,0xFF,0xFF,0xFF,0xAB,0xFF,0x00,0x00,
0x82,0x00,0x41,0x00,0xAB,0x00,0xD6,0x01,0x7C,0x83,0x29,0xD7,0xC3,0xFF,0x00,0x00,
0x7A,0xFE,0x76,0xFE,0x7A,0xFE,0xF6,0xFE,0xEA,0xFE,0xD6,0xFE,0x82,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites9[] =
{
0x00,0x00,0x35,0x40,0x2A,0x40,0x15,0x40,0x6A,0x00,0x15,0x40,0x2B,0x40,0x36,0x41,
0x00,0x00,0x3F,0xFF,0x3F,0xFF,0xBF,0x7F,0x3F,0xFF,0x3F,0xFF,0x7F,0xFF,0x77,0xFF,
0x00,0x00,0x07,0xFF,0x83,0xFF,0x07,0xFF,0x83,0xFF,0x07,0xFF,0x87,0xFF,0xC7,0xFF,
0x00,0x00,0xF2,0xFC,0xF2,0xFC,0xF0,0xFC,0xF2,0xFC,0xFA,0xFC,0xF8,0xFE,0x7E,0xFC,
0x54,0x6B,0x48,0x77,0x63,0x7F,0x77,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0xE3,0xFF,0xD1,0xFF,0xC4,0xFB,0xC8,0xF7,0x8F,0xF0,0xCE,0xF1,0x84,0xFB,0xC0,0xFF,
0xCE,0xFF,0xDD,0xFF,0xFC,0xFF,0x7C,0xFF,0xA9,0xFE,0x54,0xFF,0xA8,0xFF,0x54,0xFF,
0x3C,0xFE,0x1C,0xFE,0x4E,0xBE,0x86,0x7E,0xCE,0x3E,0xE6,0x1E,0x4E,0xBE,0x06,0xFE,
0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x79,0x7F,0x60,0x7F,0x00,0x7F,0x01,0x7F,
0xEA,0xFF,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0xFF,0xF1,0xFE,0xE2,0xFC,0xC1,0xFC,
0xFE,0xFF,0xFF,0xFF,0xAF,0xFF,0x23,0xDF,0xEC,0x03,0xD6,0x01,0x03,0x00,0x01,0x00,
0xAE,0xFE,0xDE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0x3C,0xFE,0x4E,0xBE,0x9C,0x7E,
0x01,0x7F,0x03,0x7F,0x43,0x3F,0x07,0x7F,0x0F,0x7F,0x1F,0x7F,0x0E,0x7F,0x00,0x00,
0xE2,0xFC,0xF3,0xFC,0xF9,0xFE,0xFD,0xFE,0xAE,0xFF,0x5F,0xFF,0x43,0xBF,0x00,0x00,
0x02,0x00,0x01,0x00,0x83,0x00,0x46,0x01,0xFC,0x03,0x29,0xD7,0xCF,0xFF,0x00,0x00,
0x0E,0xFE,0x9E,0x7E,0x3E,0xFE,0x7E,0xFE,0xFE,0xFE,0xD4,0xFE,0x92,0xEE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites10[] =
{
0x00,0x00,0x07,0x7F,0x02,0x7F,0x01,0x7F,0x03,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0x00,0x00,0x0D,0xF0,0x06,0xF8,0x0B,0xF4,0x80,0xFF,0xD0,0xFF,0xFF,0xFF,0xFF,0xFF,
0x00,0x00,0x53,0x0F,0xB3,0x0F,0xA7,0x5F,0x0B,0xFF,0x17,0xFF,0xFE,0xFF,0xFC,0xFF,
0x00,0x00,0xEC,0xF0,0xF6,0xF8,0xF0,0xFC,0xB2,0xFC,0x5E,0xFC,0x4C,0xBE,0xAC,0x5E,
0x7F,0x7F,0x7F,0x7F,0x3F,0x7F,0x5D,0x7F,0x2A,0x7F,0x55,0x7F,0x7F,0x7F,0x7F,0x7F,
0xFF,0xFF,0xFF,0xFF,0xEA,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,0xBF,0xFF,0xFF,0xFF,
0xFD,0xFE,0xFC,0xFF,0xBD,0xFE,0x5C,0xFF,0xA9,0xFE,0x55,0xFE,0xEB,0xFC,0xF3,0xFC,
0xFA,0x0E,0xF6,0x0E,0x32,0x0E,0x1A,0x06,0x12,0x0E,0x1A,0x06,0xB2,0x0E,0xF6,0x0E,
0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x1F,0x7F,0x0F,0x7F,0x4F,0x3F,0x0F,0x7F,
0xFE,0xFF,0xFF,0xFF,0xF8,0xFF,0xE2,0xFD,0xE6,0xF8,0xCD,0xF0,0x8A,0xF0,0xCC,0xF0,
0xB9,0xFE,0xFC,0xFF,0x3E,0xFF,0xB7,0x5F,0x97,0x2F,0xD9,0x07,0x2C,0x03,0x14,0x03,
0xCE,0x3E,0x8C,0x7E,0xBC,0xFE,0x7A,0xFC,0xF6,0xF8,0xFC,0xF0,0xA6,0xF8,0x0C,0xF0,
0x4F,0x3F,0x0F,0x7F,0x5F,0x3F,0x1F,0x7F,0x3C,0x7F,0x3C,0x7F,0x39,0x7E,0x00,0x00,
0xE6,0xF8,0xFD,0xF0,0xFA,0xFC,0x7B,0xFC,0x2C,0xFF,0x9E,0x7F,0xFB,0x0F,0x00,0x00,
0x09,0x02,0x06,0x01,0x08,0x03,0x04,0x03,0xF9,0x07,0xA3,0x5F,0x0F,0xFF,0x00,0x00,
0x06,0xF8,0x08,0xF4,0x00,0xFE,0x72,0xFC,0xFE,0xFE,0xFE,0xFE,0x8A,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites11[] =
{
0x00,0x00,0x5F,0x3F,0x7F,0x3F,0x3F,0x7F,0x3F,0x7F,0x7D,0x7F,0x7A,0x7F,0x75,0x7F,
0x00,0x00,0xC4,0xF0,0xF8,0xE0,0xCC,0xF0,0xE2,0xFC,0xFB,0xF4,0xF0,0xFF,0xFD,0xFF,
0x00,0x00,0x09,0x07,0x33,0x0F,0x37,0x0F,0xCB,0x3F,0x9D,0x7F,0x39,0xFE,0xF7,0xFC,
0x00,0x00,0x44,0xF0,0xA8,0xF0,0xFC,0xF0,0xFA,0xFC,0x7E,0xFC,0x4C,0xBE,0xEC,0x1E,
0x60,0x7F,0x50,0x7F,0x00,0x7F,0x40,0x7F,0x20,0x7F,0x50,0x7F,0x6A,0x7F,0x75,0x7F,
0xBF,0xFF,0x7F,0xFF,0xBF,0xFF,0x7F,0xFF,0xBF,0xFF,0x7F,0xFF,0xBF,0xFF,0xFF,0xFF,
0xF7,0xF8,0xFB,0xF4,0xE6,0xF8,0xCF,0xF0,0xE1,0xFE,0xD0,0xFF,0xE8,0xFF,0xF4,0xFF,
0xBE,0x0E,0x16,0x0E,0x32,0x0E,0x1E,0x06,0xB2,0x0E,0xDE,0x06,0xFE,0x0E,0xE6,0x1E,
0x7F,0x7F,0x7F,0x7F,0x3F,0x7F,0x3F,0x7F,0x5F,0x3F,0x1F,0x7F,0x5F,0x3F,0x1F,0x7F,
0xFA,0xFF,0xE0,0xFF,0xC5,0xFA,0xCF,0xF0,0x9A,0xE0,0x25,0xD0,0x9A,0xE0,0xE5,0xD0,
0xF8,0xFF,0x7C,0xFF,0x3E,0xFF,0x9D,0x7F,0xCF,0x3F,0x6F,0x1F,0xBF,0x0F,0x67,0x1F,
0xCE,0x3E,0x8C,0x7E,0x2A,0xFC,0x1A,0xFC,0xBE,0xF8,0x70,0xFC,0xE4,0xF8,0xFC,0xF0,
0x7F,0x3F,0x3F,0x7F,0x38,0x7F,0x74,0x7F,0x71,0x7E,0x73,0x7C,0x66,0x78,0x00,0x00,
0xEA,0xF0,0xED,0xF0,0xF6,0xF8,0x73,0xFC,0x39,0xFE,0x9C,0x7F,0xDE,0x2F,0x00,0x00,
0xB3,0x0F,0x5F,0x07,0xB7,0x0F,0x67,0x1F,0xF7,0x0F,0xA7,0x5F,0x0F,0xFF,0x00,0x00,
0xE6,0xF8,0xFC,0xF0,0xE6,0xF8,0xF2,0xFC,0xF8,0xFE,0xFC,0xFE,0xFE,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaSprites12[] =
{
0x00,0x00,0x5D,0x3F,0x38,0x7F,0x72,0x7D,0x67,0x78,0x4F,0x70,0x5F,0x60,0x5F,0x60,
0x00,0x00,0x7D,0xF0,0xB6,0xF8,0x79,0xF4,0x37,0xF8,0xF3,0x7C,0x39,0xFE,0xBE,0x7D,
0x00,0x00,0x40,0x1F,0xB3,0x0F,0x67,0x1F,0xCB,0x3F,0x97,0x7F,0x3E,0xFF,0x7C,0xFF,
0x00,0x00,0x2C,0xD0,0x8E,0xF0,0xCE,0xF0,0xE4,0xFA,0xFA,0xF4,0xB8,0xFE,0x7A,0xFC,
0x1F,0x60,0x5F,0x60,0x1F,0x60,0x5C,0x63,0x40,0x7F,0x41,0x7F,0x6B,0x7F,0x77,0x7F,
0x38,0xFF,0x71,0xFF,0xB8,0xFF,0x71,0xFF,0xE0,0xFF,0xE1,0xFF,0xD4,0xEB,0xEA,0xD5,
0xF3,0xFC,0xF7,0xF8,0xE7,0xF8,0x5F,0xF0,0xE7,0xF8,0xDF,0xF0,0xE7,0xF8,0x70,0xFF,
0x3C,0xFE,0x9C,0x7E,0xEC,0x3E,0xDC,0x3E,0xCC,0x3E,0x9E,0x7C,0xB8,0x7E,0x1E,0xFC,
0x7F,0x7F,0x7F,0x7F,0x3F,0x7F,0x3F,0x7F,0x3E,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
0x99,0xE2,0x36,0xC1,0x6B,0x80,0x14,0xC1,0x6B,0x80,0x94,0x41,0x8B,0xE0,0x36,0xC1,
0x7A,0xFF,0x7F,0xFF,0x3F,0xFF,0x9F,0x7F,0x3F,0xFF,0x9F,0x7F,0x3A,0xFF,0x75,0xFF,
0xBA,0xFC,0x70,0xFC,0xF6,0xF8,0xF0,0xFC,0xF6,0xF8,0x70,0xFC,0xB6,0xF8,0x70,0xFC,
0x7B,0x7F,0x55,0x7F,0x44,0x7B,0x4E,0x71,0x1F,0x60,0x7F,0x40,0x1B,0x60,0x00,0x00,
0x85,0xFA,0xCA,0xF5,0xE4,0xFB,0xF8,0xF7,0xA8,0xFF,0x70,0xFF,0x38,0xFF,0x00,0x00,
0x71,0xFE,0x73,0xFC,0xE7,0xF8,0xF7,0xF8,0xE7,0xF8,0xF3,0xFC,0xF9,0xFE,0x00,0x00,
0x3A,0xFC,0x9A,0x7C,0xF8,0x3E,0x9E,0x7C,0xB8,0x7E,0x9C,0x7E,0x38,0xFE,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};
const unsigned char PlasmaI[] =
{
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x15,0x00,0x0A,0x80,0x45,0x80,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xBF,0x00,0x57,0x00,0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xBF,0x00,0x57,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xAB,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xD5,0x2A,0xEA,0x15,0xD5,0x2A,0xEA,0x15,0xF5,0x0A,0xEA,0x15,0xF5,0x0A,0xFA,0x05,
0x54,0xAB,0xA8,0x57,0x54,0xAB,0xAA,0x55,0x54,0xAB,0xAA,0x55,0x54,0xAB,0xAA,0x55,
0x02,0xFF,0x01,0xFF,0x00,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xEA,0xF0,0x70,0xFF,0xBF,0xFF,0x5F,0xFF,0xAE,0xFF,0x55,0xFF,0x2A,0xFF,0x05,0xFF,
0x00,0xF8,0xF8,0xFC,0xFC,0xFE,0xD6,0xFF,0xAA,0xFF,0x55,0xFF,0xA0,0xFF,0x00,0xFF,
0x0A,0x00,0x15,0x00,0x8A,0x00,0x40,0x80,0xA0,0xC0,0x4F,0xF0,0xBF,0xFF,0x55,0xFF,
0xA8,0x00,0x40,0x00,0x0A,0x00,0x10,0x0F,0x0F,0x3F,0xB5,0x7F,0xEA,0xFF,0x55,0xFF,
0xA0,0x00,0x00,0x00,0x80,0x00,0x54,0x80,0xA3,0xFC,0x7D,0xFF,0xAF,0xFF,0x55,0xFF,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x10,0x10,0xF8,0xF8,0xFC,0xFA,0xFC,0x7C,0xFC,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x55,0x00,0x2A,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAB,0x00,0x57,0x00,0xAF,0x00,0x57,0x00,0xAF,0x00,0x57,0x00,0xAF,0x00,0x57,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xA2,0xC0,0x61,0xC0,0xC0,0xE0,0x6C,0xF0,0xBA,0xFC,0x5D,0xFE,0xAA,0xFF,0x55,0xFF,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x0A,0x80,0x85,0xC0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x5F,0x00,0xAF,0x00,0x57,0x00,
0xFD,0x02,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xEA,0x15,0xF5,0x0A,0xFA,0x05,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x02,0xFD,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x0A,0xF5,0x55,0xAA,0xAA,0x55,
0x0A,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x40,0xBF,0xA0,0x5F,
0xA8,0xFF,0x50,0xFF,0x80,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x2A,0xFF,0x15,0xFF,0x0A,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xAC,0xFE,0x55,0xFE,0xAE,0xFF,0x57,0xFF,0xAB,0xFF,0x55,0xFF,0x0A,0xFF,0x05,0xFF,
0x2A,0x00,0x15,0x00,0x8A,0x00,0x45,0x80,0xA2,0xC0,0x51,0xE0,0xAA,0xF0,0x55,0xF8,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAB,0x00,0x57,0x00,0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xAF,0x00,0x57,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x2A,0xFF,0x15,0xFF,0x02,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xD8,0xE0,0x74,0xF8,0xBA,0xFC,0x5D,0xFE,0xAF,0xFF,0x55,0xFF,0x2B,0xFF,0x15,0xFF,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x82,0x00,0x00,0xC0,0xC0,0xE0,0xD0,0xE0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x02,0x00,0x01,0x00,0x02,0x00,0x01,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x57,0x00,0xAB,0x00,0x55,0x00,
0xFD,0x02,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xF5,0x0A,0xFE,0x01,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xEA,0x15,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0xA0,0x5F,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0xA8,0x57,
0x02,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xAA,0xFC,0x57,0xFC,0x2A,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x80,0xA2,0xC0,0x51,0xE0,0xA8,0xF0,0x10,0xFC,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAF,0x00,0x57,0x00,0xAB,0x00,0x55,0x00,0xAB,0x00,0x55,0x00,0xAB,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,
0x2A,0xFF,0x15,0xFF,0x0A,0xFF,0x05,0xFF,0x02,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xE2,0xF8,0x78,0xFF,0xBF,0xFF,0x57,0xFF,0xAA,0xFF,0x55,0xFF,0x02,0xFF,0x01,0xFF,
0x20,0x00,0x90,0x60,0xE0,0xF8,0xF8,0xFC,0xBC,0xFE,0x56,0xFF,0xAB,0xFF,0x55,0xFF,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x0A,0x00,0x05,0x00,0x0A,0x80,0x45,0x80,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x5F,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF5,0x0A,0xFA,0x05,0xFD,0x02,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xFA,0x05,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x50,0xAF,0xA8,0x57,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x0C,0xFE,0x07,0xFE,0x02,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,0x02,0xFF,0x01,0xFF,
0x2A,0x00,0x55,0x00,0xAA,0x00,0x55,0x80,0x8A,0x80,0x45,0x80,0xAA,0xC0,0x45,0xC0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x7F,0x00,0xBF,0x00,0x55,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xEA,0x15,
0x00,0xFF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x80,0x7F,
0x2A,0xFF,0x15,0xFF,0x0A,0xFF,0x05,0xFF,0x0A,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,
0xAA,0xC0,0xC5,0xC0,0xE2,0xC0,0x55,0xE0,0xB2,0xE0,0x61,0xF0,0xA8,0xF0,0x55,0xF8,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xBF,0x00,0x5F,0x00,0xBF,0x00,0x5F,0x00,0xAF,0x00,0x5F,0x00,0xAF,0x00,0x57,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xF5,0x00,0xEA,0x00,0xD5,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,
0xD5,0x2A,0xAA,0x55,0xD5,0x2A,0xEA,0x15,0xF5,0x0A,0xFA,0x05,0xFD,0x02,0xFE,0x01,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xA8,0x57,0x54,0xAB,0xA0,0x5F,0x40,0xBF,0x80,0x7F,0x00,0xFF,0x80,0x7F,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x02,0xFF,0x01,0xFF,0x02,0xFF,0x05,0xFF,0x03,0xFF,0x07,0xFF,0x0B,0xFE,0x07,0xFE,
0xA2,0xC0,0xC5,0xC0,0xAA,0xC0,0x45,0x80,0x0A,0x80,0x15,0x00,0x0A,0x00,0x15,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xF5,0x0A,0xFA,0x05,0xFD,0x02,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xEA,0x15,
0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xA8,0xF8,0x54,0xF8,0x2A,0xFC,0x15,0xFE,0x2A,0xFF,0x15,0xFF,0x0A,0xFF,0x15,0xFF,
0xAA,0x00,0x15,0x00,0x02,0x00,0x01,0x00,0x82,0x00,0x01,0xC0,0xC0,0xE0,0x51,0xE0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0x57,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xBF,0x00,0x5F,0x00,0xAF,0x00,0x57,0x00,0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xD5,0x2A,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x80,0x7F,0x00,0xFF,0x80,0x7F,0x40,0xBF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x0A,0xFE,0x15,0xFE,0x0E,0xFC,0x14,0xFC,0x2A,0xFC,0x14,0xFC,0x2A,0xFC,0x14,0xFC,
0x2A,0x00,0x15,0x00,0x2A,0x00,0x15,0x00,0x2A,0x00,0x55,0x00,0x2A,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x80,0xFF,0x00,0x5F,0xA0,0xAA,0x55,
0xF7,0x08,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xDF,0x20,0xAB,0x54,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xEA,0x15,0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x0A,0xFF,0x15,0xFF,0x0A,0xFF,0x15,0xFF,0x0A,0xFF,0x05,0xFF,0x0A,0xFF,0x05,0xFF,
0xE8,0xF0,0x60,0xF0,0xA8,0xF0,0x70,0xF0,0xB0,0xF8,0x74,0xF8,0xB8,0xF8,0x78,0xFC,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x0A,0x00,0x05,0x00,0x02,0x00,0x05,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x5F,0x00,0xBF,0x00,0x7F,0x00,0xBF,0x00,0x7F,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xEB,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFB,0x04,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xD5,0x2A,0xEA,0x15,0xF5,0x0A,0xEA,0x15,0xF5,0x0A,0xFA,0x05,0xF5,0x0A,0xEA,0x15,
0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x40,0xBF,0xA8,0x57,
0x2A,0xFC,0x15,0xFE,0x2C,0xFE,0x16,0xFF,0x0B,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,
0x2A,0x00,0x15,0x00,0x0A,0x00,0x01,0x00,0x7A,0x80,0xF9,0xFE,0xAA,0xFF,0x55,0xFF,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x0A,0x80,0xB1,0xC0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x54,0xAB,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x01,0xFF,0x02,0xFF,0x05,0xFF,
0x0A,0xFF,0x05,0xFF,0x0A,0xFF,0x15,0xFF,0x2A,0xFF,0x55,0xFF,0xAB,0xFF,0x57,0xFF,
0xBA,0xFC,0x7C,0xFC,0xBC,0xFE,0x7D,0xFE,0xBE,0xFF,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF,
0x02,0x00,0x05,0x00,0x02,0x00,0x01,0x00,0x80,0x00,0x40,0x80,0xA0,0xC0,0xD0,0xE0,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xBF,0x00,0x5F,0x00,0xAF,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xFF,0x00,0x7F,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xAA,0x55,0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xD5,0x2A,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x50,0xAF,0xA8,0x57,
0x2A,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xA8,0xF0,0x50,0xFC,0x2C,0xFE,0x06,0xFF,0x03,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x02,0x80,0x90,0xC0,0xC6,0xF8,0x7C,0xFF,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xEA,0x15,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xA8,0x57,0x50,0xAF,0xA8,0x57,0x50,0xAF,0xA0,0x5F,0x50,0xAF,0xA0,0x5F,
0x0A,0xFF,0x15,0xFF,0x0B,0xFF,0x15,0xFF,0x2A,0xFF,0x15,0xFF,0x0A,0xFF,0x15,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBF,0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0xFA,0xFC,0xFC,0xFC,0xBA,0xFC,0x5E,0xFC,
0xF0,0xE0,0xD1,0xE0,0xA0,0xC0,0xC1,0x00,0x02,0x00,0x05,0x00,0x0A,0x00,0x15,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x54,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAB,0x00,0x55,0x00,
0xBF,0x00,0x7F,0x00,0xBF,0x00,0x7F,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xAA,0x55,0xD5,0x2A,0xEB,0x14,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xFA,0x05,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAB,0x54,0x5F,0xA0,0xBF,0x40,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xBA,0x45,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xEA,0x15,0xF5,0x0A,0xEA,0x15,
0x00,0xFF,0x00,0xFF,0x44,0xBB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x80,0x7F,0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,
0xAA,0xFF,0x55,0xFF,0x28,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xF5,0x0A,0xFA,0x05,0xF5,0x0A,0xFE,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xFA,0x05,0xFD,0x02,0xFE,0x01,
0x50,0xAF,0xA0,0x5F,0x50,0xAF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xAA,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0xAC,0xFE,0x56,0xFF,0x0A,0xFF,0x05,0xFF,0x02,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,
0x0A,0x00,0x05,0x00,0x82,0x00,0x40,0x80,0xAA,0xC0,0x60,0xFF,0xAA,0xFF,0x15,0xFF,
0xA8,0x00,0x50,0x00,0x80,0x00,0x00,0x00,0xA0,0x00,0x48,0xF0,0xB0,0xF8,0x58,0xFC,
0x2A,0x00,0x15,0x00,0x2A,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x5F,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xF5,0x0A,0xFA,0x05,0xFD,0x02,0xFA,0x05,0xFD,0x02,0xFE,0x01,0xFF,0x00,0xFE,0x01,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xA8,0x57,0x40,0xBF,0x80,0x7F,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x80,0x7F,0x55,0xAA,0xAA,0x55,0x55,0xAA,0x2A,0xD5,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xAF,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x5F,0x00,0xAF,0x00,0x57,0x00,
0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xFA,0x05,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x40,0xBF,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xEA,0x15,0xFF,0x00,0xFF,0x00,
0x05,0xFA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xFA,0x05,
0x00,0xFF,0xA0,0x5F,0x50,0xAF,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x40,0xBF,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x2A,0xFC,0x15,0xFE,0x0B,0xFE,0x06,0xFF,0x03,0xFF,0x01,0xFF,0x00,0xFF,0x80,0x7F,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x22,0x80,0x91,0xE0,0xA8,0xF0,0x50,0xFC,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0x5F,0x00,0xAF,0x00,0x57,0x00,0xAB,0x00,0x57,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0x7F,0x00,0xBF,0x00,0x7F,0x00,0xBF,0x00,0x5F,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0xD5,0x2A,0xFA,0x05,0xFD,0x02,0xFE,0x01,0xFF,0x00,0xFE,0x01,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x40,0xBF,0xA0,0x5F,0x50,0xAF,0xA8,0x57,0x54,0xAB,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x2C,0xFE,0x06,0xFF,0x02,0xFF,0x01,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x8A,0x00,0x51,0x80,0x82,0xF8,0x5D,0xFE,0xAA,0xFF,0x15,0xFF,0x02,0xFF,0x00,0xFF,
0xAA,0x00,0x55,0x00,0x2A,0x00,0x15,0x00,0x0A,0x80,0x85,0xC0,0xC2,0xE0,0x61,0xF0,
0xAB,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0x5F,0x00,0xAF,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xAF,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xEB,0x00,0xF7,0x00,0xEB,0x00,0xD5,0x00,0xEA,0x00,0x55,0x00,
0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0x5F,0x00,
0xFF,0x00,0xFE,0x01,0xFF,0x00,0xFE,0x01,0xFF,0x00,0xFE,0x01,0xFF,0x00,0xFF,0x00,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,
0x55,0xAA,0xAA,0x55,0x40,0xBF,0xA0,0x5F,0x40,0xBF,0xA0,0x5F,0x40,0xBF,0x80,0x7F,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,
0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,0xAA,0x00,0x55,0x00,

};
