#include "dxutils.h"

extern "C" HRESULT DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int x, int y, int dx, int dy);

/*
unpackBPP : unpack those bits into one byte per pixel

return: allocated unpacked, remapped buffer
*/
unsigned char *dxutils::unpackBPP(unsigned char *pBpp,unsigned long w,unsigned long h,unsigned char col1,unsigned char col2)
{
	unsigned char power[8]={128,64,32,16,8,4,2,1};
	unsigned long lineLen=w/8;
	unsigned long prevLine=lineLen*2;
	unsigned long dwLen=lineLen*h,dwSz=w*h*8,n,m;
	unsigned char c;
	unsigned char *pBmp2;
	unsigned long nt=0;

	unsigned char *pBmp=(unsigned char *)malloc(dwSz);
	if(pBmp==NULL)
		return 0;

	pBmp2=pBmp;
	pBpp+=(dwLen-lineLen);
	for(n=0;n<dwLen;n++)
	{
		c=*pBpp++;
		for(m=0;m<8;m++)
		{
			if(c&power[m])
				*pBmp2++=col2;
			else
				*pBmp2++=col1;
		}

		nt++;
		if(nt==lineLen)
		{
			nt=0;
			pBpp-=prevLine;
		}
	}
	return pBmp;
}

/*
unpack4BPP : unpack 4 bits per pixel into into one byte per pixel
remapped by adding the base colour, colour 0 is remapped to mask
mask is the index into the destination palette

return: allocated unpacked, remapped buffer
*/
unsigned char *dxutils::unpack4BPP(unsigned char *pBpp,unsigned long w,unsigned long h,unsigned char baseCol,unsigned char mask)
{
	unsigned long lineLen=w/2;
	unsigned long prevLine=lineLen*2;
	unsigned long dwLen=lineLen*h,dwSz=w*h*8,n;
	unsigned char c,d,e;
	unsigned char *pBmp2;
	unsigned long nt=0;

	unsigned char *pBmp=(unsigned char *)malloc(dwSz);
	if(pBmp==NULL)
		return 0;
	memset(pBmp,0,dwSz);

	pBmp2=pBmp;
	pBpp+=dwLen-lineLen;
	for(n=0;n<dwLen;n++)
	{
		c=*pBpp++;
		
		d=c>>4;
		if(d) *pBmp2++=baseCol+d; else *pBmp2++=mask;

		e=c&0xf;
		if(e) *pBmp2++=baseCol+e; else *pBmp2++=mask;

		nt++;
		if(nt==lineLen)
		{
			nt=0;
			pBpp-=prevLine;
		}
	}
	return pBmp;
}


/*
UncompressBitmap

1. load bit per pixel from file
2. uncompress to memory byte per pixel
3. create a DirectDrawSurface from the uncompressed data
*/
HRESULT dxutils::UncompressBitmap(IDirectDrawSurface *pdds, LPCSTR szBitmap,unsigned char col)
{
    HBITMAP             hbm;
    HRESULT             hr;
    BITMAP              bm;

	//
    //  try to load the bitmap as a resource
    //
	hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, 0, 0, LR_MONOCHROME|LR_CREATEDIBSECTION|LR_LOADFROMFILE);
    if (hbm == NULL)
		return E_FAIL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

	unsigned char *p=(unsigned char *)bm.bmBits;
	unsigned char *bmp=unpackBPP(p,bm.bmWidth,bm.bmHeight,0,col);
	if(bmp==NULL)
		return E_POINTER;
    DeleteObject(hbm);


	hbm=CreateBitmap(bm.bmWidth,bm.bmHeight,1,8,(void*)&bmp[0]);
	if(hbm==NULL)
	{
		free(bmp);
		return E_FAIL;
	}

    hr = DDCopyBitmap(pdds, hbm, 0, 0, 0, 0);
    if (hr != DD_OK)
    {
		OutputDebugString("ddcopybitmap failed\n");
    }

    DeleteObject(hbm);
	free(bmp);
    return S_OK;
}

/*
Uncompress4BitBitmap

1. load bit per pixel from file
2. uncompress to memory byte per pixel
3. create a DirectDrawSurface from the uncompressed data
*/
HRESULT dxutils::Uncompress4BitBitmap(IDirectDrawSurface *pdds, LPCSTR szBitmap,unsigned char base,unsigned char mask)
{
    HBITMAP             hbm;
    HRESULT             hr;
    BITMAP              bm;

	//
    //  try to load the bitmap as a resource
    //
	hbm = (HBITMAP)LoadImage(NULL, szBitmap, IMAGE_BITMAP, 0, 0, LR_MONOCHROME|LR_CREATEDIBSECTION|LR_LOADFROMFILE);
    if (hbm == NULL)
		return E_FAIL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

	unsigned char *p=(unsigned char *)bm.bmBits;
	unsigned char *bmp=unpack4BPP(p,bm.bmWidth,bm.bmHeight,base,mask);
	if(bmp==NULL)
		return E_POINTER;
    DeleteObject(hbm);


	hbm=CreateBitmap(bm.bmWidth,bm.bmHeight,1,8,(void*)&bmp[0]);
	if(hbm==NULL)
	{
		free(bmp);
		return E_FAIL;
	}

    hr = DDCopyBitmap(pdds, hbm, 0, 0, 0, 0);
    if (hr != DD_OK)
    {
		OutputDebugString("ddcopybitmap failed\n");
    }

    DeleteObject(hbm);
	free(bmp);
    return S_OK;
}

/*
UncompressBitmapFromMemory

1. load bit per pixel from memory
2. uncompress to memory byte per pixel
3. create a DirectDrawSurface from the uncompressed data
*/
HRESULT dxutils::UncompressBitmapFromMemory(IDirectDrawSurface *pdds, LPCSTR szBitmap,unsigned char col)
{
    HBITMAP             hbm;
    HRESULT             hr;
    BITMAP              bm;

	//
    //  try to load the bitmap as a resource
    //

	hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION);
    if (hbm == NULL)
		return E_FAIL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

	unsigned char *p=(unsigned char *)bm.bmBits;
	unsigned char *bmp=unpackBPP(p,bm.bmWidth,bm.bmHeight,0,col);
	if(bmp==NULL)
		return E_POINTER;
    DeleteObject(hbm);


	hbm=CreateBitmap(bm.bmWidth,bm.bmHeight,1,8,(void*)&bmp[0]);
	if(hbm==NULL)
	{
		free(bmp);
		return E_FAIL;
	}

    hr = DDCopyBitmap(pdds, hbm, 0, 0, 0, 0);
    if (hr != DD_OK)
    {
		OutputDebugString("ddcopybitmap failed\n");
    }

    DeleteObject(hbm);
	free(bmp);
    return S_OK;
}

/*
Uncompress4BitBitmapMemory

1. load bit per pixel from memory
2. uncompress to memory byte per pixel
3. create a DirectDrawSurface from the uncompressed data
*/
HRESULT dxutils::Uncompress4BitBitmapMemory(IDirectDrawSurface *pdds, LPCSTR szBitmap,unsigned char base,unsigned char mask)
{
    HBITMAP             hbm;
    HRESULT             hr;
    BITMAP              bm;

	//
    //  try to load the bitmap as a resource
    //
	hbm = (HBITMAP)LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION);
    if (hbm == NULL)
		return E_FAIL;

    //
    // get size of the bitmap
    //
    GetObject(hbm, sizeof(bm), &bm);      // get size of bitmap

	unsigned char *p=(unsigned char *)bm.bmBits;
	unsigned char *bmp=unpack4BPP(p,bm.bmWidth,bm.bmHeight,base,mask);
	if(bmp==NULL)
		return E_POINTER;
    DeleteObject(hbm);


	hbm=CreateBitmap(bm.bmWidth,bm.bmHeight,1,8,(void*)&bmp[0]);
	if(hbm==NULL)
	{
		free(bmp);
		return E_FAIL;
	}

    hr = DDCopyBitmap(pdds, hbm, 0, 0, 0, 0);
    if (hr != DD_OK)
    {
		OutputDebugString("ddcopybitmap failed\n");
    }

    DeleteObject(hbm);
	free(bmp);
    return S_OK;
}

// setcolor : set ega\vga color register to r,g,b
void dxutils::setcolor(int c,int r,int g, int b)
{
	_outp(0x3c8,c);
	_outp(0x3c9,r);
	_outp(0x3c9,g);
	_outp(0x3c9,b);
}
