/*
sdisk7intro.cpp by Michael Lynn (23/10/2005).
Requirements: 320*240, 8 bit color.

Developed using DirectX 8 runtime and DirectX 8 MiniSDK headers
and libraries using Visual Studio 6 SP5 on Windows 98.

Originally written 6/10/91.
*/

#define SZ_NAME		"sdisk7intro"
#define SZ_TITLE	"sdisk7intro"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include <mmsystem.h>

#include <conio.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "ddutil.h"
#include "resource.h"

#include "stsound\YmEnginePublic.h"
#include "stsound\SoundServer.h"

#define BUFFERS 1		// number of BACK BUFFERS
#define DOUBLEBUFF		// define for the Double Buffered version

char szAppPath[_MAX_PATH+1];

#define width		320
#define height		240
#define outbits		8

#define GFX_WIDTH	320
#define GFX_HEIGHT	32

#define OFFSCREEN_WIDTH		width
#define OFFSCREEN_HEIGHT	height
#define MASKCOL				16

LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
LPDIRECTDRAWSURFACE		lpDDSOffGFX;

#ifdef DOUBLEBUFF
	LPDIRECTDRAWSURFACE     lpDDSBack;

	LPDIRECTDRAWSURFACE     lpDDSBackRAM;
	LPDIRECTDRAWSURFACE     lpDDSOffOne;      // DirectDraw offscreen surface
#endif

char buf[256],err=0;
BOOL bActive=TRUE;		// is it faster to count timer count diff in FULLSCREEN mode? 30/6/98?
BOOL gExclusive=TRUE;

// stop tune control code
bool bStopStarted=false;
bool bFinished=false;
unsigned long st;

// global variables
int yTable[]={
0x0BE,0x0C4,0x0CA,0x0D0,0x0D6,0x0DC,0x0E2,0x0E8,0x0EC,0x0F2,0x0F8,0x0FE,
0x104,0x108,0x10E,0x114,0x118,0x11E,0x122,0x126,0x12C,0x130,0x134,0x138,
0x13C,0x140,0x144,0x148,0x14A,0x14E,0x152,0x154,0x156,0x15A,0x15C,0x15E,
0x160,0x162,0x162,0x164,0x166,0x166,0x168,0x168,0x168,0x168,0x168,0x168,
0x168,0x166,0x166,0x164,0x162,0x162,0x160,0x15E,0x15C,0x15A,0x156,0x154,
0x152,0x14E,0x14A,0x148,0x144,0x140,0x13C,0x138,0x134,0x130,0x12C,0x126,
0x122,0x11E,0x118,0x114,0x10E,0x108,0x104,0x0FE,0x0F8,0x0F2,0x0EC,0x0E8,
0x0E2,0x0DC,0x0D6,0x0D0,0x0CA,0x0C4,0x0BE,0x0B8,0x0B2,0x0AC,0x0A6,0x0A0,
0x09A,0x094,0x090,0x08A,0x084,0x07E,0x078,0x074,0x06E,0x068,0x064,0x05E,
0x05A,0x056,0x050,0x04C,0x048,0x044,0x040,0x03C,0x038,0x034,0x032,0x02E,
0x02A,0x028,0x026,0x022,0x020,0x01E,0x01C,0x01A,0x01A,0x018,0x016,0x016,
0x014,0x014,0x014,0x014,0x014,0x014,0x014,0x016,0x016,0x018,0x01A,0x01A,
0x01C,0x01E,0x020,0x022,0x026,0x028,0x02A,0x02E,0x032,0x034,0x038,0x03C,
0x040,0x044,0x048,0x04C,0x050,0x056,0x05A,0x05E,0x064,0x068,0x06E,0x074,
0x078,0x07E,0x084,0x08A,0x090,0x094,0x09A,0x0A0,0x0A6,0x0AC,0x0B2,0x0B8
};

int nEntries;
int yTabIndex[4];
int offset=20; // offset to centralise on pc screen of 240 pixels high

// prototypes
void init_main(void);
void drawSurface(void);
void blitBack(LPDIRECTDRAWSURFACE lpdds);
void clearscreen(COLORREF rgb);
void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom);
BOOL LoadPalette( HWND hwnd );
BOOL LoadImages( HWND hwnd );
void dumpPalette(HWND hwnd);

// demo specific
void drawTop();

// strings and constants
char szLoadProblem[_MAX_PATH];

// main display update
HWND gHwnd,gHwnd2;
HPEN gPen=NULL;

#define rastheight 1
#define rastmax 7

// all sound code
CSoundServer *pServer=NULL;
void mySoundProc(void *pSoundBuffer,long bufferLen);
void startSTsound(HINSTANCE hInst,char *szID);
void stopSTsound();
HINSTANCE gInst;
void stopAllMusic(void);
void playit(LPARAM lParam);

//-----------------------------------------------------------------------------
// Your sound server call back !
// Call what you want here !! An MP3 decoder, a classic MOD player
// or the YM-Engine library ! :-)
//
//-----------------------------------------------------------------------------
void mySoundProc(void *pSoundBuffer,long bufferLen)
{
	// Convert params, assuming we create a 16 bit, mono waveform.
	short *pSample = (signed short*)pSoundBuffer;
	long nbSample = bufferLen / sizeof(signed short);
	ymMusicCompute((short*)pSoundBuffer,nbSample);
}

bool bTune=false;

void startSTsound(HINSTANCE hInst,char *szID)
{
	int nResult;

	bTune=false;
	HRSRC hRes = FindResource(hInst, szID, RT_RCDATA); 
	if (hRes == NULL)
	{
		int n=GetLastError();
		return;
	}
	
	HGLOBAL hGlob=LoadResource(hInst,hRes);
	if(hGlob==NULL)
		return;

	unsigned long len=SizeofResource(hInst,hRes);

	void *lpBuff = LockResource(hGlob);
	// use lpBuff to access the resource contents

	char *x=(char*)malloc(len);
	if(x==NULL)
	{
		nResult = UnlockResource(hRes);
		nResult = FreeResource(hRes);
		return;
	}
	memcpy(x,lpBuff,len);

	nResult = UnlockResource(hRes);
	nResult = FreeResource(hRes);

	if(ymMusicLoadMemory((void*)x,len))
	{
		ymMusicSetLoopMode(YM_TRUE);
		bTune=true;
	}
	free(x);
}

void stopSTsound()
{
	if(bTune==true)
	{
		ymMusicUnload();
		bTune=false;
	}
}

void stopAllMusic()
{
	if(pServer)
	{
		pServer->close();
		delete pServer;
		pServer=NULL;
	}
	stopSTsound();
}

void playit(LPARAM lParam)
{
	CSoundServer *pServer = (CSoundServer*)lParam;
	if (pServer) pServer->fillNextBuffer();
}
// end of sound code

// main demo code
int drawrast(int yb,int y)
{
	int n;
	for(n=0;n<rastmax;n++)
	{
		clearSurfaceArea(lpDDSBackRAM,yb+n,0,y,width,y+rastheight);
		y+=rastheight;
	}
	for(n=0;n<rastmax;n++)
	{
		clearSurfaceArea(lpDDSBackRAM,yb+rastmax-1-n,0,y,width,y+rastheight);
		y+=rastheight;
	}
	return y;
}

void drawRasters()
{
	int y;

	// white
	y=yTable[yTabIndex[0]]/2;
	y+=offset;

	y=drawrast(65,y);
	yTabIndex[0]++;
	if(yTabIndex[0]==nEntries)
		yTabIndex[0]=0;

	// red
	y=yTable[yTabIndex[1]]/2;
	y+=offset;

	y=drawrast(72,y);
	yTabIndex[1]++;
	if(yTabIndex[1]==nEntries)
		yTabIndex[1]=0;

	// green
	y=yTable[yTabIndex[2]]/2;
	y+=offset;

	y=drawrast(79,y);
	yTabIndex[2]++;
	if(yTabIndex[2]==nEntries)
		yTabIndex[2]=0;

	// blue
	y=yTable[yTabIndex[3]]/2;
	y+=offset;

	y=drawrast(86,y);
	yTabIndex[3]++;
	if(yTabIndex[3]==nEntries)
		yTabIndex[3]=0;
}

int update_display()
{
	clearscreen(RGB(0,0,0));
	drawRasters();
	drawTop();
	//drawSurface();
	blitBack(lpDDSBackRAM);

	if(bStopStarted==true)
	{
		if(GetTickCount()-st>4000)
		{
			// tidy up
			if(bFinished==false)
			{
				bFinished=true;
				SendMessage ( gHwnd, WM_KEYDOWN, VK_ESCAPE, 0 );
				return -1;
			}
		}
	}
	return 0;
}

// do once surface has been setup
void init_main()
{
	clearscreen(RGB(0,0,0));
	nEntries=sizeof(yTable)/sizeof(int);

	yTabIndex[0]=0;
	yTabIndex[1]=4;
	yTabIndex[2]=8;
	yTabIndex[3]=12;
}

void blitBack(LPDIRECTDRAWSURFACE lpdds)
{
	RECT r;
	r.top=0; r.bottom=height;
	r.left=0; r.right=width;
	lpDDSBack->BltFast(0,0,lpdds,&r,DDBLTFAST_WAIT);
}

void drawSurface()
{
	static int x=0,xd=0;
	if(xd==0)
	{
		x++; if(x==320-32) xd=1;
	}
	else
	{
		x--; if(x==0) xd=0;
	}
	
	if(xd==0) clearSurfaceArea(lpDDSBackRAM,0,x-2,0,x-1,32);
	else clearSurfaceArea(lpDDSBackRAM,0,x+33,0,x+34,32);

	clearSurfaceArea(lpDDSBackRAM,1,x,0,x+32,32);
}

void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
	lpdds->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
}

void cleararea(COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
#ifdef DOUBLEBUFF
	lpDDSBackRAM->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void clearscreen(COLORREF rgb)
{
	DDBLTFX ddbltfx;	
	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

#ifdef DOUBLEBUFF
	lpDDSBackRAM->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void dumpPalette(HWND hwnd)
{
	LPDIRECTDRAWPALETTE ddp;
	if(FAILED(lpDDSPrimary->GetPalette(&ddp)))
		MessageBox(hwnd,"Get palette failed",SZ_TITLE,MB_OK);

	PALETTEENTRY ape[255];
	ddp->GetEntries(0,0,256,&ape[0]);

	char szBig[2048];
	strcpy(szBig,"{");
	for(int n=0;n<36;n++)
	{
		char szMsg[32];
		sprintf(szMsg,"[%d]->RGB(%d %d %d)",n,ape[n].peRed,ape[n].peGreen,ape[n].peBlue);
		if(n!=36-1)
			strcat(szMsg,", ");
		if(n!=0&&n%10==0)
			strcat(szMsg,"\r\n");
		strcat(szBig,szMsg);
	}
	strcat(szBig,"}");
	MessageBox(hwnd,szBig,"Palette",MB_OK);
}

BOOL LoadPalette( HWND hwnd )
{
	IDirectDrawPalette *p=DDLoadPalette(lpDD,MAKEINTRESOURCE(IDB_PALETTE));
	if(p==NULL)
		return FALSE;

	if(FAILED(lpDDSPrimary->SetPalette( p )))
	{
		MessageBox(hwnd,"Set palette failed",SZ_TITLE,MB_OK);
		return FALSE;
	}
	return true;
}

BOOL LoadImages( HWND hwnd )
{
	DDReLoadBitmap(lpDDSOffGFX,MAKEINTRESOURCE(IDB_GFX));
	return true;
}

void drawTop()
{
	int nHeight=32;
	RECT r;
	//RECT r2;

	r.top=0; r.bottom=r.top+nHeight; r.left=0; r.right=320;
	//r2.top=104; r2.bottom=r2.top+nHeight; r2.left=0; r2.right=320;	
	//lpDDSBackRAM->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);

	lpDDSBackRAM->BltFast(0,104,lpDDSOffGFX,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
}


static void ReleaseObjects( void )
{
    if ( lpDD != NULL )
    {
        if ( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
        lpDD->Release();
        lpDD = NULL;
	}

	if(gPen)
	{
		DeleteObject(gPen);
		gPen=NULL;
	}

	if(err==1)
	{
		MessageBox(::GetDesktopWindow(),buf,SZ_TITLE,MB_OK);
		err=0;
	}
}

long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
		case WM_MUSIC:
			playit(lParam);
			break;

		case WM_SETCURSOR:
			SetCursor(NULL);	// Turn off the mouse cursor
			return TRUE;

		case WM_KEYDOWN:
			switch ( wParam )
			{
				case VK_ESCAPE:
					if(bStopStarted==false)
					{
						stopSTsound();
						startSTsound(gInst,"#106");
						st=GetTickCount();
						bStopStarted=true;
					}
					if(bFinished==true)
					{
						stopAllMusic();
						SendMessage ( gHwnd, WM_CLOSE, 0, 0 );
					}
					break;
			}
			break;

		case WM_DESTROY:
			//setcolor(0,0,0,0);
			ReleaseObjects();
			PostQuitMessage(0);
			break;
		
		default:
			break;
	}
	
    return DefWindowProc( hWnd, message, wParam, lParam );
}

static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
	HRESULT				hr;

    // Set up and register window class
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = NULL;
    wc.lpszMenuName = SZ_NAME;
    wc.lpszClassName = SZ_NAME;
    RegisterClass( &wc );

 
    // Create a fullscreen window
    gHwnd = CreateWindowEx(
        WS_EX_TOPMOST,
        SZ_NAME,
        SZ_TITLE,
        WS_POPUP,
        0, 0,
        GetSystemMetrics( SM_CXSCREEN ),
        GetSystemMetrics( SM_CYSCREEN ),
        NULL,
        NULL,
        hInstance,
        NULL );

    gHwnd2 = CreateWindowEx(
        WS_EX_TOPMOST,
        SZ_NAME,
        SZ_TITLE,
        WS_POPUP,
        0, 0,
        GetSystemMetrics( SM_CXSCREEN ),
        GetSystemMetrics( SM_CYSCREEN ),
        NULL,
        NULL,
        hInstance,
        NULL );


	// Create the DirectDraw object -- we just need an IDirectDraw
    // interface so we won't bother to query an IDirectDraw2
	hr=DirectDrawCreate( NULL, &lpDD, NULL );
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't create DirectDraw object. Error = 0x%x",hr);
		return FALSE;
	}

	// Set exclusive mode
	hr=lpDD->SetCooperativeLevel( gHwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );//| DDSCL_ALLOWREBOOT);
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't set cooperative level. Error = 0x%x",hr);
		return FALSE;
	}

    // Set the display mode.
	hr=lpDD->SetDisplayMode( width, height, outbits );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't set display mode. Error = 0x%x",hr);
		return FALSE;
	}

	// check caps
	DDCAPS ddcaps;
	ZeroMemory(&ddcaps,sizeof( DDCAPS ));
	ddcaps.dwSize = sizeof( DDCAPS );
	hr=lpDD->GetCaps( &ddcaps, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't get video card capabilities. Error = 0x%x",hr);
		return FALSE;
    }

	// hope this covers it
	if ( ddcaps.dwSVBCaps & DDCAPS_BLT == 0)
	{
		sprintf(buf, "Cannot blit system-to-video memory. Flags are 0x%x. Need 0x%x",ddcaps.dwSVBCaps,DDCAPS_BLT);
		return FALSE;
	}

	// Create the primary surface
#ifdef DOUBLEBUFF
	ZeroMemory(&ddsd, sizeof(ddsd));
	
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX|DDSCAPS_VIDEOMEMORY;
	ddsd.dwBackBufferCount = BUFFERS;
	ddsd.dwWidth=width;
	ddsd.dwHeight=height;
    
	// a single call to CreateSurface creates back and front buffers
	// using COMPLEX flag set above! By ML (11-12/7/98) page 123 in book.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface. Error = 0x%x",hr);
		return FALSE;
	}

	ddsd.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSPrimary->GetAttachedSurface(&ddsd.ddsCaps,&lpDDSBack);
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't find the back buffer. Error = 0x%x",hr);
		return FALSE;
	}

#else
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface.");
		return FALSE;
	}
#endif

	// Friday 24/7/98 : Much slower than solid fill blitting!
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags =	DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_CKSRCBLT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth = OFFSCREEN_WIDTH;
	ddsd.dwHeight = OFFSCREEN_HEIGHT;

	// set mask color for SOURCE blitting
    ddsd.ddckCKSrcBlt.dwColorSpaceLowValue = MASKCOL;
    ddsd.ddckCKSrcBlt.dwColorSpaceHighValue = MASKCOL;

	// create graphics surface
	ddsd.dwWidth=GFX_WIDTH;
	ddsd.dwHeight=GFX_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffGFX, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create offscreen graphics surface. Error = 0x%x",hr);
		return FALSE;
	}

	// Create the 1st offscreen surface.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffOne, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen surface 1.\nError = 0x%x",hr);
		return FALSE;
	}

	// create the offscreen temporary back buffer,
	// this is blitted to the real back buffer in video RAM in one go
    ddsd.dwWidth = width;
	ddsd.dwHeight = height;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSBackRAM, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen temporary back buffer.\nError = 0x%x",hr);
		return FALSE;
	}

	// start
	init_main();
	ShowWindow( gHwnd, nCmdShow );

	// wait for vbl before setting screen palette
	if(FAILED(lpDDSPrimary->Flip(NULL,DDFLIP_WAIT)))
	{
		sprintf(buf,"Unable to flip video buffers");
		return false;
	}

    if ( !LoadPalette( gHwnd ))
	{
		sprintf(buf,"Couldn't load palette.");
		return FALSE;
    }

    if ( !LoadImages( gHwnd ))
	{
		sprintf(buf,"Couldn't load %s",szLoadProblem);
		return FALSE;
    }
	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
    MSG         msg;

	if(!_fullpath(&szAppPath[0],".",_MAX_PATH))
	{
		MessageBox(0,"Invalid path",SZ_TITLE,MB_OK);
		return -1;
	}

	gPen=CreatePen(PS_SOLID,1,RGB(255,0,0));
	if(!gPen)
	{
		MessageBox(0,"Cannot create pen",SZ_TITLE,MB_OK);
		return -1;
	}

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

	err=0;
	gInst=hInstance;
    if ( !doInit( hInstance, nCmdShow ) )
    {
		err=1; SendMessage(gHwnd,WM_DESTROY,0,0);
        return FALSE;
    }

	// start the music
	pServer = new CSoundServer;
	if(pServer==NULL)
		return FALSE;

	if (pServer->open(mySoundProc,100))
	{
		startSTsound(hInstance,"#103");
	}

	while( 1 )
    {
		//setcolor(0,255,0,0);

		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if( !GetMessage( &msg, NULL, 0, 0 ) )
			{
				return msg.wParam;
			}
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if( !gExclusive || bActive )
		{

#ifdef DOUBLEBUFF
		int rv=update_display();

		if(rv==0)
		{
			// automatically waits for vbl
			if(FAILED(lpDDSPrimary->Flip(NULL,DDFLIP_WAIT)))
			{
				err=1; sprintf(buf,"Unable to flip video buffers");
				return 1;
			}
		}
#else
		update_display();
#endif

		}
		else
		{
			WaitMessage();
		}
	}
    return msg.wParam;
}
