uses crt,threed;

const
 header : string = '3D Object File'+#27;
 cursors : array [1..6] of integer = (0,0,0,0,0,0);

var
 points1 : array [1..2000,1..2] of integer;
 points2 : array [1..2000,1..2] of integer;
 npoints : word;
 allpoints : word;
 f       : file;
 observer  : observertype;

 procedure addfile(fname: string; x,y,z: integer; alfa,beta,gama : longint);
 begin
  assign(f,fname); reset(f,1);
  blockread(f,points1,15);
  blockread(f,npoints,2);
  dec(npoints,2);
  blockread(f,points1,6+6);
  blockread(f,points1,npoints*6);
  close(f);

  observer.x:=0;
  observer.y:=0;
  observer.z:=0;
  observer.alfa_rad:=alfa;
  observer.beta_rad:=beta;
  observer.gama_rad:=gama;
  transform(npoints,addr(points1),addr(observer),addr(points2));

  observer.x:=x;
  observer.y:=y;
  observer.z:=z;
  observer.alfa_rad:=0;
  observer.beta_rad:=0;
  observer.gama_rad:=0;
  transform(npoints,addr(points2),addr(observer),addr(points1));

  assign(f,'laga'); reset(f,1);
  seek(f,15);
  blockread(f,allpoints,2);
  seek(f,15);
  inc(allpoints,npoints);
  blockwrite(f,allpoints,2);
  seek(f,filesize(f));
  blockwrite(f,points1,npoints*6);
  close(f);
 end;


begin
 assign(f,'laga'); rewrite(f,1);
 blockwrite(f,header,15);
 npoints:=2;
 blockwrite(f,npoints,2);
 blockwrite(f,cursors,6+6);
 close(f);

 addfile('t1',10*25,0,5*25,0,0,0);
 addfile('t1',6*25,0,5*25,0,0,0);
 addfile('t2',10*25-10,0,25-15,0,0,round(-90*pi/180*65536));

 addfile('t3',3*25,0,5*25,0,0,round(-17*pi/180*65536));
 addfile('t3',-3*25,0,5*25,0,0,round(17*pi/180*65536));
 addfile('t2',35,0,25,0,0,round(-90*pi/180*65536));

 addfile('t4',-5*25,0,5*25,0,0,round(-31*pi/180*65536));
 addfile('t4',-10*25-15,0,5*25,0,0,round(+31*pi/180*65536));
 writeln(allpoints);

(*
 assign(f,'laga'); rewrite(f,1);
 blockwrite(f,header,15);
 npoints:=2;
 blockwrite(f,npoints,2);
 blockwrite(f,cursors,6+6);
 close(f);
 {P}
 addfile('t1',30*25,0,5*25,0,0,0);
 addfile('t5',30*25-12,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',30*25-12,0,0,0,0,round(-90*pi/180*65536));
 addfile('t5',26*25,0,-12,0,0,0);
 {R}
 addfile('t1',22*25,0,5*25,0,0,0);
 addfile('t5',22*25-12,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',22*25-12,0,0,0,0,round(-90*pi/180*65536));
 addfile('t5',18*25,0,-12,0,0,0);
 addfile('t6',18*25-12,0,5*25,0,0,round(45*pi/180*65536));
 {E}
 addfile('t1',14*25,0,5*25,0,0,0);
 addfile('t5',14*25-12,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',14*25-12,0,12,0,0,round(-90*pi/180*65536));
 addfile('t5',14*25-12,0, 5*25,0,0,round(-90*pi/180*65536));
 {S}
 addfile('t5',6*25,0,-12,0,0,0);
 addfile('t5',2*25,0,5*25-12,0,0,0);
 addfile('t5',6*25-12,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',6*25-12,0,12,0,0,round(-90*pi/180*65536));
 addfile('t5',6*25-12,0, 5*25,0,0,round(-90*pi/180*65536));
 {E}
  addfile('t1',-25  -25,0,5*25,0,0,0);
 addfile('t5',-25-12  -25,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',-25-12  -25,0,12,0,0,round(-90*pi/180*65536));
 addfile('t5',-25-12  -25,0, 5*25,0,0,round(-90*pi/180*65536));
 {N}
 addfile('t1',-10*25,0,5*25,0,0,0);
 addfile('t1',-14*25,0,5*25,0,0,0);
 addfile('t3',-14*25,0,5*25-12,0,0,round(25*pi/180*65536));
 {T}
 addfile('t1',-20*25,0,5*25,0,0,0);
 addfile('t7',-18*25+12,0,-4*25,0,0,round(-90*pi/180*65536));
 {S}
 addfile('t5',-26*25,0,-12,0,0,0);
 addfile('t5',-30*25,0,5*25-12,0,0,0);
 addfile('t5',-26*25-12,0,-4*25,0,0,round(-90*pi/180*65536));
 addfile('t5',-26*25-12,0,12,0,0,round(-90*pi/180*65536));
 addfile('t5',-26*25-12,0, 5*25,0,0,round(-90*pi/180*65536));
writeln(allpoints);
*)
end.