ssCreditsDelayTime:	equ	60*8

ssCreditsInitialise:
	lea	RNC_CREDITS_SCREEN,a0
	bsr	agdCreatePackedAsset
	move.l	a0,RNCPTR_CREDITS_SCREEN(a6)
	rts
	
ssCreditsInitHandles:
; Destroy all Vram chunks
	move.l	VRMPTR_SCREENS(a6),a0	
	bsr	agdDestroyAllVramScreens
	move.l	UNPPTR_CREDITS_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	UNPPTR_CREDITS_SCREEN(a6)
	move.l	BMPPTR_CREDITS_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_CREDITS_SCREEN(a6)
	move.l	PALPTR_CREDITS_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	PALPTR_CREDITS_SCREEN(a6)
	move.l	BMPPTR_CREDITS_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	BMPPTR_CREDITS_SCREEN(a6)
	move.l	SCRPTR_CREDITS_SCREEN(a6),a0
	bsr	agdDestroyHandle
	clr.l	SCRPTR_CREDITS_SCREEN(a6)
	rts

ssCreditsCreateHandles	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	RNCPTR_CREDITS_SCREEN(a6),a1
	bsr	agdUnpackAssetToVRAM
	move.l	d0,a0
	move.l	hVramNumScreens(a0),d0
	beq	.exit
	subq.l	#1,d0
	move.l	hVramScreens(a0,d0*4),UNPPTR_CREDITS_SCREEN(a6)

	move.l	UNPPTR_CREDITS_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdCreateBitmap			;
	move.l	d0,BMPPTR_CREDITS_SCREEN(a6)	
	
	move.l	UNPPTR_CREDITS_SCREEN(a6),a1			; Pointer to IFF in a1
	move.l	hAddress(a1),a1
	bsr	agdGetBitmapPalette			;
	move.l	d0,PALPTR_CREDITS_SCREEN(a6)
	
	move.l	VRMPTR_SCREENS(a6),a0
	move.l	BMPPTR_CREDITS_SCREEN(a6),a1
	bsr	agdCreateScreenFromBitmap
	move.l	d0,SCRPTR_CREDITS_SCREEN(a6)
	move.l	d0,a0
	move.l	PALPTR_CREDITS_SCREEN(a6),hScreenPalette(a0)	; Assign palette to screen
.exit:	rts
	
ssCreditsCrash:	bra.s	ssCreditsCrash

ssCredits:
	move.w	#sceneCredits,CURRENT_SCENE(a6)
	move.w	#ssCreditsDelayTime,SCENE_DELAY_TIME(a6)
	clr.l	FRAME_COUNT(a6)
		
	bsr	ssCreditsInitHandles
	bsr	ssCreditsCreateHandles
	tst.l	d0
	bmi.s	ssCreditsCrash
	
	move.l	SCRPTR_CREDITS_SCREEN(a6),a0
	move.l	COPPTR_COPPER_1(a6),a1
	bsr	ssUniCopper
	
	lea	$dff000,a5	
	IFEQ	ENABLE_DEBUG
	INIT_DMA_INT
	START_COPPER
	SET_PARALLEL_PORT
	move.w	#(DMAF_SETCLR!DMAF_MASTER!DMAF_RASTER!DMAF_COPPER!DMAF_SPRITE),DMACON(a5)
	move.w	#(INTF_SETCLR!INTF_EXTER!INTF_INTEN!INTF_VERTB!INTF_COPER!INTF_PORTS),INTENA(a5)
	ENDC

	move.l	BMPPTR_CREDITS_SCREEN(a6),d0
	move.l	SCRPTR_CREDITS_SCREEN(a6),d1
	bsr	agdTransitionBitmapToScreen
	
; Display Score Panel
	move.l	SCRPTR_CREDITS_SCREEN(a6),a0
	moveq	#%00011,d2
	bsr	ssDisplayScorePanel

; Display Upgrade Car Large Text
	move.l	SCRPTR_CREDITS_SCREEN(a6),a0
	moveq	#%0011,d2				
	bsr	ssCreditsLargeText				;
	
	move.l	SCRPTR_CREDITS_SCREEN(a6),a0
	bsr	ssCreditsSmallText	
	
.frame:	
	bsr	WaitVbl
	
	IFNE	NO_INPUT_INTERUPTS
	bsr	agdReadInputs
	ENDC
	
	subq.w	#1,SCENE_DELAY_TIME(a6)
	bmi.s	.timeout

	bsr	ssGetFirstPlayerCar
	tst.w	d0
	bmi.s	.frame
	and.l	#$ffff,d0
	move.l	d0,GAME_FIRST_PLAYER(a6)

.timeout:
	move.l	SCRPTR_CREDITS_SCREEN(a6),d0
	bsr	agdTransitionBitmapFromScreen
	move.w	#sceneLoad,CURRENT_SCENE(a6)
	
; Kill VBL
	IFEQ	ENABLE_DEBUG
		END_SCENE
	ENDC
	;bsr	ssCreditsInitHandles
.error:	rts


ssCreditsSmallText:

	moveq	#-1,d3
	moveq	#1,d3
	
	move.l	#29*8,d0
	move.l	#11*8,d1	
	lea	.text1(pc),a1
	bsr	agdSmallFont

	move.l	#28*8,d0
	move.l	#18*8,d1	
	lea	.text2(pc),a1
	bsr	agdSmallFont

	move.l	#24*8,d0
	move.l	#25*8,d1	
	lea	.text3(pc),a1
	bsr	agdSmallFont
	
	move.l	#24*8,d0
	move.l	#27*8,d1	
	lea	.text4(pc),a1
	bsr	agdSmallFont

	move.l	#5*8,d0
	move.l	#34*8,d1
	lea	.text5(pc),a1
	bsr	agdSmallFont
	
	move.l	#5*8,d0
	move.l	#36*8,d1	
	lea	.text6(pc),a1
	bsr	agdSmallFont
	
	move.l	#5*8,d0
	move.l	#38*8,d1	
	lea	.text7(pc),a1
	bsr	agdSmallFont
	
	move.l	#5*8,d0
	move.l	#40*8,d1	
	lea	.text8(pc),a1
	bsr	agdSmallFont
	
.exit:	rts
		;0123456789012345678901234567890123456789
.text1:	dc.b	"MCGEEZER",0
	even
.text2:	dc.b	"D.J METUNE",0
	even
.text3:	dc.b	"TONY AKSNES    FGH",0
	even	
.text4:	dc.b	"ROONDAR      HAVIE",0
	even	
.text5:	dc.b	"ROSS    PHX    STERIL707    APEX    JOTD    TONI WILEN",0
	even
.text6:	dc.b	" INVENT    PINK    GALAHAD    DAN SCOTT    ALPINE9000 ",0
	even
.text7:	dc.b	" ANTIRIAD    NIVRIG    WAYNEK    BIPPY M    ALPHA ONE ",0
	even
.text8:	dc.b	"           STINGRAY    PAV G   DLFRSILVER             ",0
	even

; a0=Screen Pointer
; d2=Bits to set ..... must be two bits set. (i.e. d2=%00011 for first two bitplanes).
ssCreditsLargeText:
	moveq	#0,d3
	move.l	SPRPTR_LARGE_FONT(a6),a1
	
	lea	.text(pc),a2
	moveq	#0,d0			; In 8x8 blocks
	moveq	#0,d1

.disp	move.l	d0,-(a7)
	move.l	d1,-(a7)
	bsr	.display
	move.l	(a7)+,d1
	move.l	(a7)+,d0
	
	tst.b	d3
	bmi.s	.exit
	addq.l	#1,a2
	add.w	#8,d1
	bra	.disp
	
	
.display:
.loop:	move.b	(a2)+,d3
	bmi.s	.exit
	beq.s	.exit
	cmp.w	#" ",d3
	beq.s	.next
	bsr	agdLargeFont
.next:	add.w	#16,d0
	bra.s	.loop
.exit:	rts

		;01234567890123456789012345678901
.text:	
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"           PROGRAMMING          ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"              AUDIO             ",0,0	
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0
	dc.b	"             TESTING            ",0,0	
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0	
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0	
	dc.b	"                                ",0,0
	dc.b	"                                ",0,0	
	dc.b	"                                ",0,0
	dc.b	"  SPECIAL GREETS AND THANKS TO  ",-1,0

	even
	


	data
	
UNPPTR_CREDITS_SCREEN:	dc.l	0
BMPPTR_CREDITS_SCREEN:	dc.l	0
PALPTR_CREDITS_SCREEN:	dc.l	0
SCRPTR_CREDITS_SCREEN:	dc.l	0
RNCPTR_CREDITS_SCREEN:	dc.l	0

	code