	device zxspectrum128
        ORG $8100-4
begin
	db 1
	db end_cmd-begin_cmd

begin_cmd
	dw $8100
count_stars equ 1*5
dots equ $8000
 ld hl,dots
initd:ld (hl),0
 inc l:jr nz,initd

; Synchronize to within 1 T-State of the beam.  Experiments indicate that
; the dot clock is not locked to the processor clock so you can count on
; some variance in blanking.  But we always seem to hit a fixed starting
; character.  Allowing +/- 1 character on your blanking should be sufficient.

;sync1   macro   beamtop
beamtop
 ei:halt;:di

; Wait for a key to be pressed
;nokey:  ld      a,(38ffh)
;        or      a
;        jp nz,0;jr      z,nokey

; Ensure video waits are on.
;        vwon
;;        in      a,(255)
;;        or      a,20h
;;        out     (236),a
;;
;;        di
;;
;;; Enable clock interrupts
;;
;;        ld      a,(4213h)
;;        or      a,4
;;        ld      (4213h),a
;;        out     (0e0h),a
;;
;;; Hook interrupts
;;
;;        ld      hl,(4013h)
;;        ld      (sync1chain+1),hl
;;        ld      hl,sync1irq
;;        ld      (4013h),hl
;;
;;; Clear clock latch, just to be sure
;;
;;        in      a,(0ech)
;;
;;        ei
;;        halt
;;
;;sync1irq:
;;        push    af
;;        in      a,(0e0h)
;;        and     4
;;        jr      z,sync1clock
;;        pop     af
;;sync1chain:
;;        jp      0
;;
;;sync1clock:
;;
;;; Clear clock latch
;;
;;        in      a,(0ech)
;;
;;; Restore old interrupt vector
;;
;;        ld      hl,(sync1chain+1)
;;        ld      (4013h),hl
;;
;;; Disable clock interrupts
;;
;;        ld      a,(4213h)
;;        and     a,0fbh
;;        ld      (4213h),a
;;        out     (0e0h),a
;;
;;; Wait until top of video; then use video wait to sync to end of line.
;;; That's 73 lines plus the IRQ overhead.
;;
;;        ld      bc,377
;;sync1wait:
;;        dec     bc              ;<6>
;;        ld      a,b             ;<4>
;;        or      c               ;<4>
;;        jp      nz,sync1wait    ;<10>
;;
;;        ei
;;        ld      a,(15360)
;--------------------------------------------------
; jr $
 ld ix,dots
 ld b,count_stars
draw_dots:
 ld de,64
 ld l,(ix)
 ld h,(ix+1)
 
 ld a,h
 or l
 call z,init_tail
 
 ld c,(ix+2)
 ld a,h:cp $40:jr z,test
 add hl,de
 ld (ix),l
 ld (ix+1),h
 ld a,h:cp $40:jr z,draw_tail
 ld (hl),c
 jr draw_tail

test:
 push hl
 or a:sbc hl,de
 ld a,(hl)
 pop hl
 cp $80:jr nz,draw_tail
 call init_tail
; ld (hl),a
 jr no_tail

draw_tail:
 or a:sbc hl,de
 ld a,h:cp $3B:jr z,quit_tail
 ld a,(hl)
 cp $80:jr z,draw_tail
 dec(hl)
 jr draw_tail

quit_tail:

no_tail:
 ld de,3:add ix,de
 dec b:jr nz,draw_dots
 jp beamtop

init_tail:
 ld h,$3C
rnd:
 call random;ld a,r
 and $3F
; jr z,rnd
 ld l,a
; and $1F
; or $80
 scf:rra
 ld (ix),l
 ld (ix+1),h
 ld (ix+2),a
 ld (hl),a
 ret
random:
 push bc
R1:LD C,$15+3
R2:LD A,#70
 ADD A,C:LD C,A
 LD (R1+1),A
R3:LD A,#FD
 SUB C:LD C,A,(R2+1),A
 RRCA:LD (R3+1),A
 LD A,C
 pop bc
 RET

;dots:
; dw $3C06;position of the dots
; db $BF;char to put
; db 7;length of tail

;; Handy macro for turning off video waits
;
;vwoff   macro
;
;        in      a,(255)
;        and     a,0dfh
;        out     (236),a
;
;        endm
;
;; Handy macro for turning on video waits
;
;vwon    macro
;
;        in      a,(255)
;        or      a,20h
;        out     (236),a
;
;        endm
end_cmd
	db 2,2
	dw $8100
end
	display /d,end_cmd-begin_cmd
	display /d,end-begin
;	savesna "!void.sna",begin

 savebin "tt.cmd",begin,end-begin