/*y2k demo -- source*/
/*released one week after PS2...*/

/*Thanks as always to: Danzig, Nik, Silpheed, Now3D, Van Helsing, Brainwalker,*/
/*Yums, Curlin, Jihad, Nagra, Doomed, JackRipper, Snake, McBain, Datel, Sony..*/






//#define prototype 1 /*emu's crash with SoW*/


#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <libcd.h>
#include <kernel.h>

#include "asciifnt.h"
#include "cellosml.h"
#include "bbaminot.h"

#include "starbrit.h"
#include "fadebrit.h"


#include "soundwor.h"/*'Sounds of Wor' 1.9 by Danzig*/

#include "baggeds.h"/*'In The Bag' by The Shamen/Goz*/
#include "baggedi.h"/*includes scratch sample by Lords of Acid*/

#include "shines.h"/*'Shine In The Darkness 2' by XTD*/
#include "shinei.h"



#define OT_LENGTH  14  
GsOT WorldOT[2];
GsOT_TAG OTTags[2][1<<OT_LENGTH]; 

#define PACKETMAX 10000
PACKET GpuPacketArea[2][PACKETMAX*24];


#define SCREEN_X 320
#define SCREEN_Y 240

#define STARSPACE_X (SCREEN_X-112)
#define STARSPACE_Y (SCREEN_Y)

#define BALLSPACEX (SCREEN_X-32)
#define BALLSPACEY (SCREEN_Y-32)


/*boingball stuff*/
typedef struct
   {
	u_short x,y;
	u_short dx,dy;
   } POS;

POS amigaball;


/*classic starfield...*/
typedef struct
   {
   int x;
   int y;
   int z;
   int starcolor;
   GsLINE line;
   } stars;


/*text-fade routine from hell...*/
typedef struct
   {
   int pos;
   char text[27];
   int starttime;//secs into this part
   int endtime;//secs
   int fadecount;
   } faderfont;

faderfont fontcrap[80];
int fadeoffset;//0 or 150...


#define NUMSTARS 384
#define starspace 8192
stars colorstars[NUMSTARS];


GsIMAGE LogoIm;
GsSPRITE LogoSp;

u_long PadData;

GsIMAGE logoimg;
GsSPRITE logospr;

GsIMAGE 	fontimg;
GsSPRITE	fontspr[64+8];/*64 chars+1amiball+3notes+4bars*/

GsSPRITE notestar1[20];
GsSPRITE notestar2[16];
GsSPRITE notestar3[12];

GsSPRITE	scroll[44];
GsSPRITE clockscroll[20];

int actBuffer=0,dmode=MODE_NTSC;
u_long pad,oldPad;

char txt;

int i=0,j=0;


/*set up the clock routine...*/
int clockyear=1999,clockmonth=12,clockday=31,clockhour=23,clockmin=58,clocksec=0;
int clockbase=60,clockticks=0;
char clocktext[80];

int fontticks=0;
int fontsecs=0;

u_int npcommand=npPLAY;

char newmodloaded=0;

void initfontcrap(void);
void fadertext(void);
void setup_System(void);
void init_Sprite(GsIMAGE*,GsSPRITE*);

void DisplayAll(int);
int main(void);

void init_Font(void);
void init_LogoSprites(void);

void do_Info(void);

void set_ModePAL(void);
void set_ModeNTSC(void);


void movestars(void);
void moveball(void);

void do_clock(void);
void displayclock(void);

void countdown(void);
void killasec(void);

void initstars(void);
void do3dstars(int);

void initnewfont(void);

int appleframe=0;

int amiball=0;

int star1x[]={-5,240,100,45,270,-2,20,132,300,190,75,36,140,290,7,242,150,200,42,167};/*20:-8/320*/
int star2x[]={125,42,320,212,76,5,280,-2,25,176,54,265,80,10,242,150};/*16:-7/320*/
int star3x[]={300,67,188,280,125,-2,200,42,175,100,5,225};/*12:-5/320*/


int main()
{
/*send blurb out comm*/

  printf("\n\n\n\n");
  printf("                   A\n");
  printf("                y2k demo\n\n\n\n\n");
               


	setup_System();

   PadData=0;
   
   do_Info();/*text stuff*/

   init_Font();/*font+amigaball+notestars*/

   init_LogoSprites();


   amigaball.x=rand();
   amigaball.y=rand();

   amigaball.dx=1;
   amigaball.dy=1;


for (i=0;i<20;i++)
   {
   notestar1[i]=fontspr[65];
   notestar1[i].y=i*12;
   notestar1[i].x=star1x[i];//i*16;
   }
for (i=0;i<16;i++)
   {
   notestar2[i]=fontspr[66];
   notestar2[i].y=i*15;
   notestar2[i].x=star2x[i];//i*20;
   }
for (i=0;i<12;i++)
   {
   notestar3[i]=fontspr[67];
   notestar3[i].y=i*20;
   notestar3[i].x=star3x[i];//i*26;
   }


if (dmode=MODE_NTSC)
   {
   clockbase=60;
   fadeoffset=150;
   }
else if (dmode=MODE_PAL)
   {
   clockbase=50;
   fadeoffset=0;
   }


initstars();
countdown();
killasec();
initnewfont();
initfontcrap();

#ifndef prototype
NPM_Control(npSTOP);
NPM_FreeSong();
NPM_SetSong(shinenps,shinenpi);
NPM_Control(npPLAY);
#endif


for(;;)
	{
	actBuffer=GsGetActiveBuff();
	GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);
	GsClearOt(0,0,&WorldOT[actBuffer]);
   GsSortFastSprite(&logospr,&WorldOT[actBuffer],0);
   do3dstars(actBuffer);
   fadertext();
	DisplayAll(actBuffer);
	PadData=PadRead(0);
	}
ResetGraph(0);
PadStop();
return 0;
}


void initstars(void)
{
srand();
for(i=0;i<NUMSTARS; i++)
   {
	colorstars[i].x=starspace-(rand()*(2*starspace))/(32767+1);
	colorstars[i].y=starspace-(rand()*(2*starspace))/(32767+1);
	colorstars[i].z=(rand()*(99))/(32767+1)+1;
   colorstars[i].line.r=colorstars[i].line.g=colorstars[i].line.b=0;
   colorstars[i].starcolor=(rand()*(7))/(32767+1);
  	}
}

void do3dstars(int activeBuffer)
{
int x,y,z;
	
for(i=1;i<NUMSTARS;i++)
   {
	if (colorstars[i].z<2) colorstars[i].z=100;
	x=(colorstars[i].x)/(colorstars[i].z);
	y=(colorstars[i].y)/(colorstars[i].z);
	colorstars[i].z--;
	colorstars[i].line.x1=colorstars[i].line.x0=x+STARSPACE_X/2;
	colorstars[i].line.y1=colorstars[i].line.y0=y+STARSPACE_Y/2;

   switch (colorstars[i].starcolor)
      {
      case 1:/*red*/
        	colorstars[i].line.r=starbrit[colorstars[i].z];
         colorstars[i].line.g=0;
         colorstars[i].line.b=0;
         break;
      case 2:/*green*/
        	colorstars[i].line.r=0;
         colorstars[i].line.g=starbrit[colorstars[i].z];
         colorstars[i].line.b=0;
         break;
       case 3:/*blue*/
        	colorstars[i].line.r=0;
         colorstars[i].line.g=0;
         colorstars[i].line.b=starbrit[colorstars[i].z];
         break;
       case 4:/*red+green*/
        	colorstars[i].line.r=starbrit[colorstars[i].z];
         colorstars[i].line.g=starbrit[colorstars[i].z];
         colorstars[i].line.b=0;
         break;
       case 5:/*green+blue*/
        	colorstars[i].line.r=0;
         colorstars[i].line.g=starbrit[colorstars[i].z];
         colorstars[i].line.b=starbrit[colorstars[i].z];
         break;
      case 6:/*red+blue*/
        	colorstars[i].line.r=starbrit[colorstars[i].z];
         colorstars[i].line.g=0;
         colorstars[i].line.b=starbrit[colorstars[i].z];
         break;
      case 0:/*white*/
      default:
        	colorstars[i].line.r=starbrit[colorstars[i].z];
         colorstars[i].line.g=starbrit[colorstars[i].z];
         colorstars[i].line.b=starbrit[colorstars[i].z];
         break;
        }

	GsSortLine(&colorstars[i].line,&WorldOT[activeBuffer],0);
	}
}

void killasec()/*er, kill 4 secs...*/
{
appleframe=0;

for(;;)
   {
   actBuffer=GsGetActiveBuff();
   GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);
   GsClearOt(0,0,&WorldOT[actBuffer]);

   appleframe++;
   if (appleframe==(clockbase*4)) break;

	DisplayAll(actBuffer);
	PadData=PadRead(1);
   }

}

void countdown()
{
#ifndef prototype
NPM_SetSong(baggednps,baggednpi);
NPM_Control(npPAN1);
NPM_Control(npPLAY);
#endif

for(;;)
	{
   actBuffer=GsGetActiveBuff();
   GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);
   GsClearOt(0,0,&WorldOT[actBuffer]);
   do_clock();
   moveball();
   movestars();
   DisplayAll(actBuffer);
   PadData=PadRead(0);

   if(PadData&PADRleft) clockyear=2000;

   if (clockyear==2000)
      {
      printf("\nPress 'Square' to skip the 2 minute countdown next time...\n");

#ifndef prototype
      NPM_SongJump(0x15);/*s-c-r-a-t-c-h pattern...*/
#endif

      break;
      }
      
   }

}


void do_clock()
{
clockticks++;
if (clockticks>clockbase)
   {
   clockticks=0;
   clocksec++;

   if (clocksec>59)
      {
      clocksec=0;
      clockmin++;
      if (clockmin>59)
         {
         clockmin=0;
         clockhour++;
         if (clockhour>23)
            {
            clockhour=0;
            clockday++;
            if (
               (clockmonth==1)&&(clockday>31)||
               (clockmonth==2)&&(clockday>28)&&(clockyear&0x3)||
               (clockmonth==2)&&(clockday>29)&&(!clockyear&0x3)||
               (clockmonth==3)&&(clockday>31)||
               (clockmonth==4)&&(clockday>30)||
               (clockmonth==5)&&(clockday>31)||
               (clockmonth==6)&&(clockday>30)||
               (clockmonth==7)&&(clockday>31)||
               (clockmonth==8)&&(clockday>31)||
               (clockmonth==9)&&(clockday>30)||
               (clockmonth==10)&&(clockday>31)||
               (clockmonth==11)&&(clockday>30)||
               (clockmonth==12)&&(clockday>31))
               {
               clockday=1;
               clockmonth++;
               if (clockmonth>12)
                  {
                  clockmonth=1;
                  clockyear++;
                  }
               }
            }
         }
      }
   }

/*01234567890123456789*/
/*23:59:59  12/31/1999*/
sprintf(clocktext,"%02d:%02d:%02d  %02d/%02d/%04d",clockhour,clockmin,clocksec,clockmonth,clockday,clockyear);

if (clockyear!=2000) displayclock();
}



void movestars()
{
for (j=0;j<5;j++)
   {
   for (i=0;i<20;i++)
      {
      notestar1[i].x--;
      if (notestar1[i].x==-8) notestar1[i].x=320;
      }
   }

for (j=0;j<3;j++)
   {
   for (i=0;i<16;i++)
      {
      notestar2[i].x--;
      if (notestar2[i].x==-7) notestar2[i].x=320;
      }
   }

for (i=0;i<12;i++)
   {
   notestar3[i].x--;
   if (notestar3[i].x==-5) notestar3[i].x=320;
   }


   for (i=0;i<20;i++)
      GsSortFastSprite(&notestar1[i],&WorldOT[actBuffer],0);
   for (i=0;i<16;i++)
      GsSortFastSprite(&notestar2[i],&WorldOT[actBuffer],0);
   for (i=0;i<12;i++)
      GsSortFastSprite(&notestar3[i],&WorldOT[actBuffer],0);

}


void displayclock()
{
for(i=0;i<20;i++)
   {
   txt=clocktext[i];
   j=txt-0x20;
   clockscroll[i]=fontspr[j];
   clockscroll[i].x=((16*i));
   clockscroll[i].y=112;
   GsSortFastSprite(&clockscroll[i],&WorldOT[actBuffer],0);
   }
}


void initfontcrap()
{
int blocknum;
fontsecs=0;
for (blocknum=0;blocknum<80;blocknum++)fontcrap[blocknum].fadecount=fadeoffset;
 
fontcrap[0].pos=116;
fontcrap[0].starttime=0;
fontcrap[0].endtime=5;
sprintf(fontcrap[0].text,"         y2k demo         ");
                        /*21098765432100123456789012*/

fontcrap[1].pos=111;
fontcrap[1].starttime=7;
fontcrap[1].endtime=178;//timed with last greet...
sprintf(fontcrap[1].text,"        greets to:        ");
                        /*21098765432100123456789012*/

fontcrap[2].pos=121;
fontcrap[2].starttime=8;
fontcrap[2].endtime=13;
sprintf(fontcrap[2].text,"           nik            ");
                        /*21098765432100123456789012*/

fontcrap[3].pos=121;
fontcrap[3].starttime=13;
fontcrap[3].endtime=18;
sprintf(fontcrap[3].text,"          danzig          ");
                        /*21098765432100123456789012*/

fontcrap[4].pos=121;
fontcrap[4].starttime=18;
fontcrap[4].endtime=23;
sprintf(fontcrap[4].text,"          now3d           ");
                        /*21098765432100123456789012*/

fontcrap[5].pos=121;
fontcrap[5].starttime=23;
fontcrap[5].endtime=28;
sprintf(fontcrap[5].text,"          loser           ");
                        /*21098765432100123456789012*/

fontcrap[6].pos=121;
fontcrap[6].starttime=28;
fontcrap[6].endtime=33;
sprintf(fontcrap[6].text,"           ne7            ");
                        /*21098765432100123456789012*/

fontcrap[7].pos=121;
fontcrap[7].starttime=33;
fontcrap[7].endtime=38;
sprintf(fontcrap[7].text,"          tursi           ");
                        /*21098765432100123456789012*/

fontcrap[8].pos=121;
fontcrap[8].starttime=38;
fontcrap[8].endtime=43;
sprintf(fontcrap[8].text,"          madman          ");
                        /*21098765432100123456789012*/

fontcrap[9].pos=121;
fontcrap[9].starttime=43;
fontcrap[9].endtime=48;
sprintf(fontcrap[9].text,"          nagra           ");
                        /*21098765432100123456789012*/

fontcrap[10].pos=121;
fontcrap[10].starttime=48;
fontcrap[10].endtime=53;
sprintf(fontcrap[10].text,"       brainwalker        ");
                         /*21098765432100123456789012*/

fontcrap[11].pos=121;
fontcrap[11].starttime=53;
fontcrap[11].endtime=58;
sprintf(fontcrap[11].text,"         silpheed         ");
                         /*21098765432100123456789012*/

fontcrap[12].pos=121;
fontcrap[12].starttime=58;
fontcrap[12].endtime=63;
sprintf(fontcrap[12].text,"           avh            ");
                         /*21098765432100123456789012*/

fontcrap[13].pos=121;
fontcrap[13].starttime=63;
fontcrap[13].endtime=68;
sprintf(fontcrap[13].text,"          curlin          ");
                         /*21098765432100123456789012*/

fontcrap[14].pos=121;
fontcrap[14].starttime=68;
fontcrap[14].endtime=73;
sprintf(fontcrap[14].text,"           ddt            ");
                         /*21098765432100123456789012*/

fontcrap[15].pos=121;
fontcrap[15].starttime=73;
fontcrap[15].endtime=78;
sprintf(fontcrap[15].text,"          jihad           ");
                         /*21098765432100123456789012*/

fontcrap[16].pos=121;
fontcrap[16].starttime=78;
fontcrap[16].endtime=83;
sprintf(fontcrap[16].text,"         groepaz          ");
                         /*21098765432100123456789012*/

fontcrap[17].pos=121;
fontcrap[17].starttime=83;
fontcrap[17].endtime=88;
sprintf(fontcrap[17].text,"           yums           ");
                         /*21098765432100123456789012*/

fontcrap[18].pos=121;
fontcrap[18].starttime=88;
fontcrap[18].endtime=93;
sprintf(fontcrap[18].text,"          doomed          ");
                         /*21098765432100123456789012*/

fontcrap[19].pos=121;
fontcrap[19].starttime=93;
fontcrap[19].endtime=98;
sprintf(fontcrap[19].text,"        jackripper        ");
                         /*21098765432100123456789012*/

fontcrap[20].pos=121;
fontcrap[20].starttime=98;
fontcrap[20].endtime=103;
sprintf(fontcrap[20].text,"           twk            ");
                         /*21098765432100123456789012*/

fontcrap[21].pos=121;
fontcrap[21].starttime=103;
fontcrap[21].endtime=108;
sprintf(fontcrap[21].text,"        bufferman         ");
                         /*21098765432100123456789012*/

fontcrap[22].pos=121;
fontcrap[22].starttime=108;
fontcrap[22].endtime=113;
sprintf(fontcrap[22].text,"          airia           ");
                         /*21098765432100123456789012*/

fontcrap[23].pos=121;
fontcrap[23].starttime=113;
fontcrap[23].endtime=118;
sprintf(fontcrap[23].text,"          wigwam          ");
                         /*21098765432100123456789012*/

fontcrap[24].pos=121;
fontcrap[24].starttime=118;
fontcrap[24].endtime=123;
sprintf(fontcrap[24].text,"          anttih          ");
                         /*21098765432100123456789012*/

fontcrap[25].pos=121;
fontcrap[25].starttime=123;
fontcrap[25].endtime=128;
sprintf(fontcrap[25].text,"         scorpion         ");
                         /*21098765432100123456789012*/

fontcrap[26].pos=121;
fontcrap[26].starttime=128;
fontcrap[26].endtime=133;
sprintf(fontcrap[26].text,"        ayatollah         ");
                         /*21098765432100123456789012*/

fontcrap[27].pos=121;
fontcrap[27].starttime=133;
fontcrap[27].endtime=138;
sprintf(fontcrap[27].text,"           sgf            ");
                         /*21098765432100123456789012*/

fontcrap[28].pos=121;
fontcrap[28].starttime=138;
fontcrap[28].endtime=143;
sprintf(fontcrap[28].text,"      gabriel knight      ");
                         /*21098765432100123456789012*/

fontcrap[29].pos=121;
fontcrap[29].starttime=143;
fontcrap[29].endtime=148;
sprintf(fontcrap[29].text,"          heaven          ");
                         /*21098765432100123456789012*/

fontcrap[30].pos=121;
fontcrap[30].starttime=148;
fontcrap[30].endtime=153;
sprintf(fontcrap[30].text,"           alfa           ");
                         /*21098765432100123456789012*/

fontcrap[31].pos=121;
fontcrap[31].starttime=153;
fontcrap[31].endtime=158;
sprintf(fontcrap[31].text,"           ogre           ");
                         /*21098765432100123456789012*/

fontcrap[32].pos=121;
fontcrap[32].starttime=158;
fontcrap[32].endtime=163;
sprintf(fontcrap[32].text,"         hunkpapa         ");
                         /*21098765432100123456789012*/

fontcrap[33].pos=121;
fontcrap[33].starttime=163;
fontcrap[33].endtime=168;
sprintf(fontcrap[33].text,"          snake           ");
                         /*21098765432100123456789012*/

fontcrap[34].pos=121;
fontcrap[34].starttime=168;
fontcrap[34].endtime=173;
sprintf(fontcrap[34].text,"          mcbain          ");
                         /*21098765432100123456789012*/

fontcrap[35].pos=121;
fontcrap[35].starttime=173;
fontcrap[35].endtime=178;
sprintf(fontcrap[35].text,"    all psxdev-addicts    ");
                         /*21098765432100123456789012*/

fontcrap[36].pos=106;
fontcrap[36].starttime=180;
fontcrap[36].endtime=205;//timed with last credits...
sprintf(fontcrap[36].text,"         credits:         ");
                         /*21098765432100123456789012*/

fontcrap[37].pos=116;
fontcrap[37].starttime=181;
fontcrap[37].endtime=187;//timed with second line
sprintf(fontcrap[37].text,"  'in the bag' by shamen  ");
                         /*21098765432100123456789012*/

fontcrap[38].pos=126;
fontcrap[38].starttime=182;
fontcrap[38].endtime=187;
sprintf(fontcrap[38].text,"      tracked by goz      ");
                         /*21098765432100123456789012*/

fontcrap[39].pos=116;
fontcrap[39].starttime=187;
fontcrap[39].endtime=193;//timed with second line...
sprintf(fontcrap[39].text,"'vinyl-carving' soundbite ");
                         /*21098765432100123456789012*/

fontcrap[40].pos=126;
fontcrap[40].starttime=188;
fontcrap[40].endtime=193;
sprintf(fontcrap[40].text,"    from lords of acid    ");
                         /*21098765432100123456789012*/

fontcrap[41].pos=116;
fontcrap[41].starttime=193;
fontcrap[41].endtime=199;//timed with second line...
sprintf(fontcrap[41].text,"'shine in the darkness 2' ");
                         /*21098765432100123456789012*/

fontcrap[42].pos=126;
fontcrap[42].starttime=194;
fontcrap[42].endtime=199;
sprintf(fontcrap[42].text,"          by xtd          ");
                         /*21098765432100123456789012*/

fontcrap[43].pos=116;
fontcrap[43].starttime=199;
fontcrap[43].endtime=205;//
sprintf(fontcrap[43].text,"   modplayer by danzig    ");
                         /*21098765432100123456789012*/

fontcrap[44].pos=126;
fontcrap[44].starttime=200;
fontcrap[44].endtime=205;
sprintf(fontcrap[44].text,"   this font from loser   ");
                         /*21098765432100123456789012*/

fontcrap[45].pos=111;
fontcrap[45].starttime=207;
fontcrap[45].endtime=368;//timed with last hello...
sprintf(fontcrap[45].text,"         hello's:         ");
                         /*21098765432100123456789012*/

fontcrap[46].pos=121;
fontcrap[46].starttime=208;
fontcrap[46].endtime=213;
sprintf(fontcrap[46].text,"       ofra harnoy        ");
                         /*21098765432100123456789012*/

fontcrap[47].pos=121;
fontcrap[47].starttime=213;
fontcrap[47].endtime=218;
sprintf(fontcrap[47].text,"    jacqueline du pre     ");
                         /*21098765432100123456789012*/

fontcrap[48].pos=121;
fontcrap[48].starttime=218;
fontcrap[48].endtime=223;
sprintf(fontcrap[48].text,"           rush           ");
                         /*21098765432100123456789012*/

fontcrap[49].pos=121;
fontcrap[49].starttime=223;
fontcrap[49].endtime=228;
sprintf(fontcrap[49].text,"       vanessa-mae        ");
                         /*21098765432100123456789012*/

fontcrap[50].pos=121;
fontcrap[50].starttime=228;
fontcrap[50].endtime=233;
sprintf(fontcrap[50].text,"          ragin           ");
                         /*21098765432100123456789012*/

fontcrap[51].pos=121;
fontcrap[51].starttime=233;
fontcrap[51].endtime=238;
sprintf(fontcrap[51].text,"      jean-luc ponty      ");
                         /*21098765432100123456789012*/

fontcrap[52].pos=121;
fontcrap[52].starttime=238;
fontcrap[52].endtime=243;
sprintf(fontcrap[52].text,"       clara ponty        ");
                         /*21098765432100123456789012*/

fontcrap[53].pos=121;
fontcrap[53].starttime=243;
fontcrap[53].endtime=248;
sprintf(fontcrap[53].text,"    anne-sophie mutter    ");
                         /*21098765432100123456789012*/

fontcrap[54].pos=121;
fontcrap[54].starttime=248;
fontcrap[54].endtime=253;
sprintf(fontcrap[54].text,"       apocalyptica       ");
                         /*21098765432100123456789012*/

fontcrap[55].pos=121;
fontcrap[55].starttime=253;
fontcrap[55].endtime=258;
sprintf(fontcrap[55].text,"      the great kat       ");
                         /*21098765432100123456789012*/

fontcrap[56].pos=121;
fontcrap[56].starttime=258;
fontcrap[56].endtime=263;
sprintf(fontcrap[56].text,"    jean-michel jarre     ");
                         /*21098765432100123456789012*/

fontcrap[57].pos=121;
fontcrap[57].starttime=263;
fontcrap[57].endtime=268;
sprintf(fontcrap[57].text,"        scorpions         ");
                         /*21098765432100123456789012*/

fontcrap[58].pos=121;
fontcrap[58].starttime=268;
fontcrap[58].endtime=273;
sprintf(fontcrap[58].text,"        yeah right        ");
                         /*21098765432100123456789012*/

fontcrap[59].pos=121;
fontcrap[59].starttime=273;
fontcrap[59].endtime=278;
sprintf(fontcrap[59].text,"        rasputina         ");
                         /*21098765432100123456789012*/

fontcrap[60].pos=121;
fontcrap[60].starttime=278;
fontcrap[60].endtime=283;
sprintf(fontcrap[60].text,"          cello           ");
                         /*21098765432100123456789012*/

fontcrap[61].pos=121;
fontcrap[61].starttime=283;
fontcrap[61].endtime=288;
sprintf(fontcrap[61].text,"       candy dulfer       ");
                         /*21098765432100123456789012*/

fontcrap[62].pos=121;
fontcrap[62].starttime=288;
fontcrap[62].endtime=293;
sprintf(fontcrap[62].text,"          thalia          ");
                         /*21098765432100123456789012*/

fontcrap[63].pos=121;
fontcrap[63].starttime=293;
fontcrap[63].endtime=298;
sprintf(fontcrap[63].text,"        ofra haza         ");
                         /*21098765432100123456789012*/

fontcrap[64].pos=121;
fontcrap[64].starttime=298;
fontcrap[64].endtime=303;
sprintf(fontcrap[64].text,"     tangerine dream      ");
                         /*21098765432100123456789012*/

fontcrap[65].pos=121;
fontcrap[65].starttime=303;
fontcrap[65].endtime=308;
sprintf(fontcrap[65].text,"          kmfdm           ");
                         /*21098765432100123456789012*/

fontcrap[66].pos=121;
fontcrap[66].starttime=308;
fontcrap[66].endtime=313;
sprintf(fontcrap[66].text,"         vangelis         ");
                         /*21098765432100123456789012*/

fontcrap[67].pos=121;
fontcrap[67].starttime=313;
fontcrap[67].endtime=318;
sprintf(fontcrap[67].text,"     cecilia bartoli      ");
                         /*21098765432100123456789012*/

fontcrap[68].pos=121;
fontcrap[68].starttime=318;
fontcrap[68].endtime=323;
sprintf(fontcrap[68].text,"       shania twain       ");
                         /*21098765432100123456789012*/

fontcrap[69].pos=121;
fontcrap[69].starttime=323;
fontcrap[69].endtime=328;
sprintf(fontcrap[69].text,"      lords of acid       ");
                         /*21098765432100123456789012*/

fontcrap[70].pos=121;
fontcrap[70].starttime=328;
fontcrap[70].endtime=333;
sprintf(fontcrap[70].text,"       jethro tull        ");
                         /*21098765432100123456789012*/

fontcrap[71].pos=121;
fontcrap[71].starttime=333;
fontcrap[71].endtime=338;
sprintf(fontcrap[71].text,"           styx           ");
                         /*21098765432100123456789012*/

fontcrap[72].pos=121;
fontcrap[72].starttime=338;
fontcrap[72].endtime=343;
sprintf(fontcrap[72].text,"          dokken          ");
                         /*21098765432100123456789012*/

fontcrap[73].pos=121;
fontcrap[73].starttime=343;
fontcrap[73].endtime=348;
sprintf(fontcrap[73].text,"    loreena mckennitt     ");
                         /*21098765432100123456789012*/

fontcrap[74].pos=121;
fontcrap[74].starttime=348;
fontcrap[74].endtime=353;
sprintf(fontcrap[74].text,"       sammy hagar        ");
                         /*21098765432100123456789012*/

fontcrap[75].pos=121;
fontcrap[75].starttime=353;
fontcrap[75].endtime=358;
sprintf(fontcrap[75].text,"       joe satriani       ");
                         /*21098765432100123456789012*/

fontcrap[76].pos=121;
fontcrap[76].starttime=358;
fontcrap[76].endtime=363;
sprintf(fontcrap[76].text,"      bjorn a lynne       ");
                         /*21098765432100123456789012*/

fontcrap[77].pos=121;
fontcrap[77].starttime=363;
fontcrap[77].endtime=368;
sprintf(fontcrap[77].text,"        kate bush         ");
                         /*21098765432100123456789012*/

fontcrap[78].pos=111;
fontcrap[78].starttime=370;
fontcrap[78].endtime=376; //
sprintf(fontcrap[78].text,"     merry christmas      ");
                         /*21098765432100123456789012*/

fontcrap[79].pos=121;
fontcrap[79].starttime=371;
fontcrap[79].endtime=376;
sprintf(fontcrap[79].text,"    and happy new year    ");
                         /*21098765432100123456789012*/

}


void fadertext()
{
int blocknum;
fontticks++;
if (fontticks>clockbase){fontsecs++;fontticks=0;}

if (fontsecs>(fontcrap[79].endtime+5))
   {
   fontsecs=0;
   for (blocknum=0;blocknum<80;blocknum++)fontcrap[blocknum].fadecount=fadeoffset;
   }

for (blocknum=0;blocknum<80;blocknum++)
   {
   if ((fontsecs>fontcrap[blocknum].starttime)&&
      (fontsecs<fontcrap[blocknum].endtime))
      {
      for(i=0;i<26;i++)
         {
         txt=fontcrap[blocknum].text[i];
         if(txt!=0)
            {
            if (txt>=0x61&&txt<0x7b) txt-=0x20;
            j=txt-0x20;
            scroll[i]=fontspr[j];
            scroll[i].x=((8*i));
            scroll[i].y=fontcrap[blocknum].pos;

            if (fontsecs>(fontcrap[blocknum].endtime-3))
               scroll[i].r=scroll[i].g=scroll[i].b=fadebrit[fontcrap[blocknum].fadecount];
            else scroll[i].r=scroll[i].g=scroll[i].b=128;

            GsSortFastSprite(&scroll[i],&WorldOT[actBuffer],0);
            }
         }
      if (fontsecs>(fontcrap[blocknum].endtime-3))fontcrap[blocknum].fadecount++;
      }   
   }
}





void moveball()
{
int ballx,bally;

if ((ballx=(amigaball.x+=amigaball.dx)%BALLSPACEX*2)>=BALLSPACEX)
   ballx=BALLSPACEX*2-ballx;

if ((bally=(amigaball.y+=amigaball.dy)%BALLSPACEY*2)>=BALLSPACEY)
   bally=BALLSPACEY*2-bally;

fontspr[64].x=ballx;
fontspr[64].y=bally;

GsSortFastSprite(&fontspr[64],&WorldOT[actBuffer],0);
}



void initnewfont()
{
int i=0,j=0,k=0,savek=0;

GsGetTimInfo((u_long *)(asciifnt+4),&fontimg);
init_Sprite(&fontimg,&fontspr[0]);
fontspr[0].w=8;
fontspr[0].h=8;
fontspr[0].u=0;
fontspr[0].v=0;
j=8;
k=0;
for(i=1;i<16;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=8;
   }
j=0;
k+=8;
for(i=16;i<32;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=8;
   }
j=0;
k+=8;
for(i=32;i<48;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=8;
   }
j=0;
k+=8;
for(i=48;i<64;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=8;
   }
}


void init_Font()
{
int i=0,j=0,k=0,savek=0;

GsGetTimInfo((u_long *)(bbaminot+4),&fontimg);
init_Sprite(&fontimg,&fontspr[0]);
fontspr[0].w=16;
fontspr[0].h=15;
fontspr[0].u=0;
fontspr[0].v=0;
j=16;
k=0;
for(i=1;i<16;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=16;i<32;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=32;i<48;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }
j=0;
k+=16;
for(i=48;i<64;i++)
   {
   fontspr[i]=fontspr[0];
   fontspr[i].u=j;
   fontspr[i].v=k;
   j+=16;
   }

j=0;
k+=16;

savek=k;/*for different heights of notes*/

fontspr[64]=fontspr[0];/*amiball*/
fontspr[64].w=32;
fontspr[64].h=32;
fontspr[64].u=j;
fontspr[64].v=k;
j+=32;

k+=9;
fontspr[65]=fontspr[0];/*bignote*/
fontspr[65].w=8;
fontspr[65].h=23;
fontspr[65].u=j;
fontspr[65].v=k;
j+=8;

k+=5;
fontspr[66]=fontspr[0];/*mednote*/
fontspr[66].w=7;
fontspr[66].h=18;
fontspr[66].u=j;
fontspr[66].v=k;
j+=7;

k+=4;
fontspr[67]=fontspr[0];/*litnote*/
fontspr[67].w=5;
fontspr[67].h=14;
fontspr[67].u=j;
fontspr[67].v=k;
j+=5;

k=savek;

fontspr[68]=fontspr[0];/*bar1*/
fontspr[68].w=128;
fontspr[68].h=8;
fontspr[68].u=j;
fontspr[68].v=k;
fontspr[68].r=0x80;
fontspr[68].g=0;
fontspr[68].b=0;
fontspr[68].x=96;
fontspr[68].y=40;
k+=8;

fontspr[69]=fontspr[0];/*bar2*/
fontspr[69].w=128;
fontspr[69].h=8;
fontspr[69].u=j;
fontspr[69].v=k;
fontspr[69].r=0;
fontspr[69].g=0x80;
fontspr[69].b=0;
fontspr[69].x=96;
fontspr[69].y=50;
k+=8;

fontspr[70]=fontspr[0];/*bar3*/
fontspr[70].w=128;
fontspr[70].h=8;
fontspr[70].u=j;
fontspr[70].v=k;
fontspr[70].r=0;
fontspr[70].g=0;
fontspr[70].b=0x80;
fontspr[70].x=96;
fontspr[70].y=182;
k+=8;

fontspr[71]=fontspr[0];/*bar4*/
fontspr[71].w=128;
fontspr[71].h=8;
fontspr[71].u=j;
fontspr[71].v=k;
fontspr[71].r=0x80;
fontspr[71].g=0;
fontspr[71].b=0x80;
fontspr[71].x=96;
fontspr[71].y=192;
k+=8;

}

void init_LogoSprites()
{
GsGetTimInfo((u_long *)(cellosml+4),&logoimg);
init_Sprite(&logoimg,&logospr);
logospr.w=113;
logospr.h=256;
logospr.u=0;
logospr.v=0;
logospr.x=208;
logospr.y=0;
}


void do_Info()
{
for(;;)
   {
   actBuffer=GsGetActiveBuff();
   GsSetWorkBase((PACKET*)GpuPacketArea[actBuffer]);
   GsClearOt(0,0,&WorldOT[actBuffer]);

   FntPrint("\n\n\n\n\n\n");
   FntPrint("                  A\n\n");
   FntPrint("               y2k demo\n\n\n");
   FntPrint("          (X)-PAL / (O)-NTSC\n\n");


	DisplayAll(actBuffer);
	PadData=PadRead(1);

	if(PadData&PADRdown)
		{
      set_ModePAL();
		break;
		}
	if(PadData&PADRright)
		{
      set_ModeNTSC();
		break;
		}

   }

}


void set_ModePAL()
{
if(dmode!=MODE_PAL)
	{
	DrawSync(0);
	VSync(0);
	SetVideoMode(MODE_PAL);
	ResetGraph(0);
	GsInitGraph(SCREEN_X,SCREEN_Y,GsNONINTER|GsOFSGPU,0,0);
	GsDefDispBuff(0,0,0,SCREEN_Y);
	dmode=MODE_PAL;
	}
}

void set_ModeNTSC()
{
if(dmode!=MODE_NTSC)
	{
	DrawSync(0);
	VSync(0);
	SetVideoMode(MODE_NTSC);
	ResetGraph(0);
	GsInitGraph(SCREEN_X,SCREEN_Y,GsNONINTER|GsOFSGPU,0,0);
	GsDefDispBuff(0,0,0,SCREEN_Y);
	dmode=MODE_NTSC;
	}
}

void setup_System()
{
/*peek at the BIOS for region code...*/
if (*(char *)0xbfc7ff52=='E') dmode=MODE_PAL;
else dmode=MODE_NTSC;

SetVideoMode(dmode);

ResetGraph(0);

GsInitGraph(SCREEN_X,SCREEN_Y,GsNONINTER|GsOFSGPU,0,0);
GsDefDispBuff(0,0,0,SCREEN_Y);
	
WorldOT[0].length=OT_LENGTH;
WorldOT[0].org=OTTags[0];
WorldOT[1].length=OT_LENGTH;
WorldOT[1].org=OTTags[1];
 
GsClearOt(0,0,&WorldOT[0]);
GsClearOt(0,0,&WorldOT[1]);
	               
FntLoad(960,256);
FntOpen(8,0,312,248,0,512);	

SetDispMask(1);
PadInit(0);
}

void DisplayAll(int mybuffer)
{
FntFlush(-1);
DrawSync(0);
VSync(0);
GsSwapDispBuff();
GsSortClear(0,0,0,&WorldOT[mybuffer]);
GsDrawOt(&WorldOT[mybuffer]);
}

void init_Sprite(GsIMAGE *im,GsSPRITE *sp)
{
int bits;
int widthCompression;
RECT myRect;
	
bits=im->pmode&0x03;
if (bits==0) widthCompression=4;
else if (bits==1) widthCompression=2;
else if (bits==2) widthCompression=1;
else if (bits==3)
   {
   printf("\nunsupported file format (24bit tim)!\n");
   exit(-1);
   }
	
myRect.x=im->px;
myRect.y=im->py;
myRect.w=im->pw;
myRect.h=im->ph;
LoadImage( &myRect,im->pixel);

sp->attribute=(bits<<24);
sp->x=SCREEN_X/2-((im->pw*widthCompression)/2);
sp->y=SCREEN_Y/2-im->ph/2;
sp->w=im->pw*widthCompression;
sp->h=im->ph;
sp->tpage=GetTPage(bits,0,im->px,im->py);
sp->u=0;
sp->v=0;
if (bits==0||bits==1)
   {
	myRect.x=im->cx;
	myRect.y=im->cy;
	myRect.w=im->cw;
	myRect.h=im->ch;
	LoadImage( &myRect,im->clut);
	sp->cx=im->cx;
	sp->cy=im->cy;
	}
sp->r=128;
sp->g=128;
sp->b=128;
sp->mx=(im->pw*widthCompression)/2;
sp->my=im->ph/2;
sp->scalex=ONE;
sp->scaley=ONE;
sp->rotate=0*ONE;
}

