;==============================================================
; WLA-DX banking setup
;==============================================================
.memorymap
defaultslot 0
slotsize $4000
slot 0 $0000
.endme

.rombankmap
bankstotal 16
banksize $4000
banks 16
.endro

;==============================================================
; SDSC tag and SMS rom header
;==============================================================
.sdsctag 1.00,"SMS 3-D Demo","3-D pictures","Chris Covell"

; THERE ARE TOO MANY FILES FOR THIS DEMO, SO ONLY THE MAIN SOURCE IS INCLUDED!
; Don't follow this code too closely; it's badly written!!!

.enum $c040
cont1 db	;Controller 1 data
trigger db	;Controller trigger
delay1 db
delay2 db
picnum db
fadecount db
tempr db
tempg db
LRtoggle db	;0 = normal, 1=reversed, 2 = left only, 3 = right only
GlassPortCopy db
Hsyncs db
change_pic_flag db
glassesmode db
palettenum db
.ende

.bank 0 slot 0
.org $0000
;==============================================================
; Boot section
;==============================================================
    di              ; disable interrupts
    im 1            ; Interrupt mode 1
    jp main         ; jump to main program

.org $0038
;==============================================================
; IRQ handler
;==============================================================
    ; Do nothing
	di
	push AF
	in a,($bf)	;check VDP status
	and %10000000		;If it's non-zero, V-sync
	jr nz,NoHSyncFlag
	jp HsyncHandler	;Else it's an H/other interrupt
;----------finished!!!
NoHSyncFlag:
	jp VsyncHandler
NoVSyncFlag:
;----------finished!!!

.org $0066
;==============================================================
; Pause button handler
;==============================================================
	push AF
	ld a,(LRtoggle)
	inc a
	cp $04
	jr nz,+
	xor a
+:
	ld (LRtoggle),a
	pop AF
	retn


;==============================================================
; Main program
;==============================================================
main:
	ld sp, $dff0
	xor a
	ld (cont1),a
	ld (trigger),a
	ld (change_pic_flag),a
	ld (glassesmode),a
	ld (palettenum),a
	ld a,$01
	ld (picnum),a
	ld ($ffff),a		;set to bank 1

    ;==============================================================
    ; Set up VDP registers
    ;==============================================================
    ld hl,VdpData
    ld b,VdpDataEnd-VdpData
    ld c,$bf
    otir

    ;==============================================================
    ; Clear VRAM
    ;==============================================================
    ; 1. Set VRAM write address to 0 by outputting $4000 ORed with $0000
    ld a,$00
    out ($bf),a
    ld a,$40
    out ($bf),a
    ; 2. Output 16KB of zeroes
    ld bc, $4000    ; Counter for 16KB of VRAM
    ld a,$00        ; Value to write
	ld ($FFFB),a			;Reset the 3-D glasses... ?
	ld (LRtoggle),a
	ld (GlassPortCopy),a
    ClearVRAMLoop:
        out ($be),a ; Output to VRAM address, which is auto-incremented after each write
        dec c
        jp nz,ClearVRAMLoop
        dec b
        jp nz,ClearVRAMLoop


Tile_Loading:
	call Load_Tiles
	call Load_Map
	call Load_Palette

    ; Turn screen on
    ld a,%11100100
;          |||| |`- Zoomed sprites -> 16x16 pixels
;          |||| `-- Doubled sprites -> 2 tiles per sprite, 8x16
;          |||`---- 30 row/240 line mode
;          ||`----- 28 row/224 line mode
;          |`------ VBlank interrupts
;          `------- Enable display
    out ($bf),a
    ld a,$81
    out ($bf),a

	ld a,(picnum)
	cp 1			;If it's pic 1 (or 2), enable H-Interrupts!
	jr nz,+
	call Enable_H_Int
	jr NoHInt
+:
	call Disable_H_Int
NoHInt:
	ei	;enable interrupts

;========================================================
    ; Infinite loop to stop program
    Loop:
;	jp Loop

	ld a,(change_pic_flag)		;Change pics on button press?
	or a
	jr z,Loop
	xor a
	ld (change_pic_flag),a
;++++++++++++++++++++++++++++++++++++++++++

;	ld a,$00
;	ld (delay1),a
;	ld (delay2),a
;	call FadeToBlack

;	call WaitForButton

	di		;Disable interrupts
    ld a,%10000100
;          |||| |`- Zoomed sprites -> 16x16 pixels
;          |||| `-- Doubled sprites -> 2 tiles per sprite, 8x16
;          |||`---- 30 row/240 line mode
;          ||`----- 28 row/224 line mode
;          |`------ VBlank interrupts
;          `------- Enable display
    out ($bf),a
    ld a,$81
    out ($bf),a

	call Disable_H_Int

	ld a,(picnum)
	inc a
	cp 16
	jp nz,+
	ld a,$01
+:
	ld (picnum),a
	ld ($ffff),a		;set to bank PICNUM!

         jp Tile_Loading


;**************************************************************
; Subroutines
;**************************************************************

HsyncHandler:
;	push HL
	push DE
	push BC
	ld a,(Hsyncs)
	inc a
	ld (Hsyncs),a

	push BC
	pop BC			; a delay.
	ld a,$00
	out ($bf),a
	ld a,$C0	;Point to $C000
	out ($bf),a
	ld c,$be
	outi

HIRQ_End:
	pop BC
	pop DE
;	pop HL
	pop AF	
	ei
    	reti

VsyncHandler:
;	push HL
	push DE
	push BC
;-----------------
	call Read_Controller
	call Controller_Action
;------------------
;	ld a,$00
;	ld ($c010),a	;Store pal index
	ld hl,LinePalette1	;Set to start of palette again
;	ld c,$be		;Set output to VRAM
;------------------

	ld a,(delay1)
	inc a
	ld (delay1),a
	xor a
	ld (Hsyncs),a

	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC
	push BC
	pop BC

	ld a,(GlassPortCopy)
	cpl
	ld (GlassPortCopy),a

	ld a,(LRtoggle)
	or a
	jr nz,+
	ld a,(GlassPortCopy)		;Show L/R as normal
	jr Toggle_glasses
+:	cp 1
	jr nz,+
	ld a,(GlassPortCopy)
	cpl				;Show R/L reversed
	jr Toggle_glasses
+:	cp 2
	jr nz,+
	ld a,$00			;Show L?
	jr Toggle_glasses
+:	ld a,$FF			;Show R?
Toggle_glasses:
	ld ($FFFB),a


;+++++++++++++++++++++++++++++++++++++++++++
	ld a,(picnum)
	cp 3		;For now, Compare to pics 1 or 2
	jp nc,+
	ld a,($FFFB)
	and	$02	;isolate a bit for the name table
	or	$0D	;point to $3x00 for name table. (Fix for Japanese VDP!!!)
	out ($bf),a
	ld a,$82
	out ($bf),a	;Write different name-table value.
	jp Not_Colswitch
+:
;+++++++++++++++++++++++++++++++++++++++++++
	call Copy_Pal
	ld a,$0F	;Point to $3800 in NAME table. (Fix for Japanese VDP!!!)
	out ($bf),a
	ld a,$82
	out ($bf),a	;Write different name-table value.
Not_Colswitch:

	ld a,(GlassPortCopy)
	cpl
	ld ($FFFB),a

VIRQ_End:
	pop BC
	pop DE
;	pop HL
	pop AF
	ei
    	reti

;**************************************************************
; Subroutines
;**************************************************************

Controller_Action:
	ld a,(trigger)
	and $20		;Check for button '1'
	jr z,+
	ld (change_pic_flag),a		;Trigger "Change Picture"
+:	
	ld a,(trigger)
	and $10		;Check for button '2'
	jr z,+
	ld a,(glassesmode)
	xor 1
	ld (glassesmode),a		;Toggle "Glasses mode"
+:	
	ld a,(trigger)
	and $01		;Check for button 'UP'
	jr z,+
	ld a,(palettenum)
	inc a
	and $07
	ld (palettenum),a	;Increase palette
+:
	ld a,(trigger)
	and $02		;Check for button 'DOWN'
	jr z,+
	ld a,(palettenum)
	dec a
	and $07
	ld (palettenum),a	;Decrease palette
+:
	ret

Read_Controller:
	in a,($DC)	;Read controller
	cpl
	and $3F
	ld E,A		;Isolate pressed
	ld a,(cont1)
	xor E
	and E		;Isolate triggered.
	ld D,A
	ld (cont1),DE	;Save in cont1, trigger. (adjacent memory locations)
	ret


Enable_H_Int:
	ld a,%00010100
;		 || |`- 
;		 || `-- ?
;		 |`---- 
;		 `----- Hsync Interrupts!
	out ($bf),a
	ld a,$80
	out ($bf),a
	ret

Disable_H_Int:
	ld a,%00000100
;		 || |`- 
;		 || `-- ?
;		 |`---- 
;		 `----- Hsync Interrupts! (Disabled)
	out ($bf),a
	ld a,$80
	out ($bf),a
	ret

Load_Tiles:
    ;==============================================================
    ; Load tiles (CHR)
    ;==============================================================
    ; 1. Set VRAM write address to tile index 0
    ; by outputting $4000 ORed with $0000
    ld a,$00
    out ($bf),a
    ld a,$40
    out ($bf),a
    ; 2. Output tile data
    ld hl,$8600              ; Location of tile data ($8000+$600 nam.)
;+++++++++++++++++++++++++++++++++++++++++++
	ld a,(picnum)
	cp 3		;For now, Pic 1 and 2 are full-colour!
	jp nc,+
	ld hl,$9000	;Tiles start later, due to the larger NAM file.
+:
;+++++++++++++++++++++++++++++++++++++++++++
    ld bc,$3800  ; Counter for number of bytes to write
    WriteTilesLoop:

        ld a,(hl)        ; Get data byte
        out ($be),a
        inc hl           ; Add one to hl so it points to the next data byte
        dec c
        jp nz,WriteTilesLoop
        dec b
        jp p,WriteTilesLoop
	ret

Load_Map:
    ;==============================================================
    ; Write Map to name table
    ;==============================================================
    ; 1. Set VRAM write address to name table index 0
    ; by outputting $4000 ORed with $3800+0
    ld a,$00
    out ($bf),a
    ld a,$38|$40
    out ($bf),a

    ld hl,$8000               ; Location of tile data
    ld bc,$0600  ; Counter for number of bytes to write

;==============================================================
	ld a,(picnum)
	cp 3		;For now, Pic 1 and 2 are full-colour!
	jp nc,+
	ld a,$00
	out ($bf),a
	ld a,$30|$40	;Tile maps at $3000, $3800
	out ($bf),a
	ld bc,$1000  ; Counter for number of bytes to write
+:
;==============================================================
WriteMapLoop:
        ld a,(hl)    ; Get data byte
        out ($be),a
        inc hl           ; Add one to hl so it points to the next data byte
        dec c
        jp nz,WriteMapLoop
        dec b
        jp nz,WriteMapLoop

EndWriteMapLoop:
	ret
;----------------------------------

;******************************************************************************
Load_Palette:
    ;==============================================================
    ; Load palette
    ;==============================================================
    ; 1. Set VRAM write address to CRAM (palette) address 0 (for palette index 0)
    ; by outputting $c000 ORed with $0000
	ld a,$00
	out ($bf),a
	ld a,$c0
	out ($bf),a
    ; 2. Output colour data
	ld hl,ColPalData
;--------
	ld a,(picnum)
	cp 3
	jp nc,+		;If it's more than pic 2
	sla a
	sla a
	sla a
	sla a		;Multiply by 16 to get palette.
	ld d,$00
	ld e,a
	add hl,de
;--------
+:	ld b,$10		;16 bytes
	ld c,$be
	otir

	ld hl,BlankPaletteData	;Copy blank to sprite palette.
	ld b,$10		;16 bytes
	ld c,$be
	otir
	ret
;******************************************************************************

Copy_Pal:
	ld a,$00
	out ($bf),a
	ld a,$c0		;Point to palette
	out ($bf),a
	ld hl,PaletteFilt	;Point to filtered palette...

	ld a,(palettenum)	;Get palette index (0-xx)
	sla a
	sla a
	sla a
	sla a			;Multiply it by 16 (0,16,32,...)
	ld e,a
;--------------------------
	ld a,(glassesmode)	;Test if glasses are LCD/filter
	or a
	jp nz,+			;0=LCD, 1=filter

	ld a,e
	sla a			;Multiply to align on 32 bytes...
	ld e,a

	ld a,($FFFB)
	and $10			;Add 16 if LCD glasses...
	or e
	ld e,a

	ld hl,Palette3D
+:
	ld d,$00
	add hl,de
	ld bc,$10be		;16 bytes....
	otir
	ret

;- - - - - - - - - - - - - - - - - - - - - -
;--------------------------------------------


;==============================================================
; Data
;==============================================================

Message:
.db "I hope you enjoy my 3-D demo!"
.db "  Hand-made, photographed pics by Chris Covell",0

; VDP initialisation data
VdpData:
.db $04,$80,$A4,$81,$ff,$82,$ff,$85,$ff,$86,$ff,$87,$00,$88,$00,$89,$01,$8a
VdpDataEnd:

ColPalData:
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.incbin "GreenBalls (palette).bin"
.incbin "GGearBlue3D (palette).bin"
ColPalDataEnd:

BlankPaletteData:
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
BlankPaletteDataEnd:

LinePalette1:
.incbin "LinePalette1.bin"

Palette3D:
.incbin "Palette_LCD.bin"
PaletteFilt:
.incbin "Palette_Filter.bin"

;*************************************************************************
;*************************************************************************
;		Graphics now follow!!!!!
;*************************************************************************
;*************************************************************************

.bank 1 slot 0
.org $0000
.incbin "GreenBalls (tile numbers).bin"		;Should be $1000 bytes ($0800 x 2)
.incbin "GreenBalls (tiles).bin"		;Could be up to $3000 bytes

.bank 2 slot 0
.org $0000
.incbin "GGearBlue3D (tile numbers).bin"	;Should be $1000 bytes ($0800 x 2)
.incbin "GGearBlue3D (tiles).bin"		;Could be up to $3000 bytes

.bank 3 slot 0
.org $0000
.incbin "MasterSystem3dord (tile numbers).bin"	;Should be $0600 bytes
.incbin "MasterSystem3dord (tiles).bin"		;Could be up to $3800 bytes

.bank 4 slot 0
.org $0000
.incbin "NintendoDSord (tile numbers).bin"	;Should be $0600 bytes
.incbin "NintendoDSord (tiles).bin"		;Could be up to $3800 bytes

.bank 5 slot 0
.org $0000
.incbin "3dcar (tile numbers).bin"	;Should be $0600 bytes
.incbin "3dcar (tiles).bin"		;Could be up to $3800 bytes

.bank 6 slot 0
.org $0000
.incbin "Shrine3d2 (tile numbers).bin"	;Should be $0600 bytes
.incbin "Shrine3d2 (tiles).bin"		;Could be up to $3800 bytes

.bank 7 slot 0
.org $0000
.incbin "flower3d (tile numbers).bin"	;Should be $0600 bytes
.incbin "flower3d (tiles).bin"		;Could be up to $3800 bytes

.bank 8 slot 0
.org $0000
.incbin "Mario643D3 (tile numbers).bin"		;Should be $0600 bytes
.incbin "Mario643D3 (tiles).bin"		;Could be up to $3800 bytes

.bank 9 slot 0
.org $0000
.incbin "Mario2ord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Mario2ord (tiles).bin"		;Could be up to $3800 bytes

.bank 10 slot 0
.org $0000
.incbin "Mario1ord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Mario1ord (tiles).bin"		;Could be up to $3800 bytes

.bank 11 slot 0
.org $0000
.incbin "Boxerord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Boxerord (tiles).bin"		;Could be up to $3800 bytes

.bank 12 slot 0
.org $0000
.incbin "Squashord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Squashord (tiles).bin"		;Could be up to $3800 bytes

.bank 13 slot 0
.org $0000
.incbin "Jackbros1ord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Jackbros1ord (tiles).bin"		;Could be up to $3800 bytes

.bank 14 slot 0
.org $0000
.incbin "Jackbros2ord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Jackbros2ord (tiles).bin"		;Could be up to $3800 bytes

.bank 15 slot 0
.org $0000
.incbin "Wario3DSMord (tile numbers).bin"	;Should be $0600 bytes
.incbin "Wario3DSMord (tiles).bin"		;Could be up to $3800 bytes
