
	processor 6502
	include "vcs.h"
	include "macro.h"



;.---=== kONSTaNZieS
SPEEDA    = 05         ;speed in frames between 16th
LENGHT    = 61         ;length of demo to STOPPPIT (when compo-mode, means not switched to bw)  33~1min
VOLA      = 4          ;volume of pwm osc
OFFSETBAR = 0          ;for testing burb-ose, set bar to that...

;.---== vARIaBLEs
       seg.u   Variables
       org $80

; background color
lina	ds   1         ;80 cycle countar for pwm
lena    ds   1         ;81 lenght for pwm of osci a     05-4c (~22 is middle)
vla	ds   1         ;82 act vol of main
vlb	ds   1         ;83 act vol of hardsynked
actb	ds   1         ;84 act pos of cycle for b (cycle means 3 lines)
lenb	ds   1         ;85 setpoint of hardsynked reset in cycles 05-4c, 05 is hifreq
step	ds   1         ;86 a sixteenth
frame	ds   1         ;87 guess what...
bar     ds   1         ;88 position in song
seqos   ds   1         ;89 position in synth sequence
seqosz  ds   1         ;8a position in sample sequence
svolb   ds   1         ;8b set volume b (the hardsynkie one)
ftgz    ds   1         ;8c frames to go for sample player
ytmp    ds   1         ;8d tmp for y... just a temp
hvolz   ds   1         ;8e play sample half the volume
audtmpz ds   1         ;8f tempp for 2nd nibble
smplz   ds   2         ;90/91 pointer for sample playar
speedie ds   1         ;92 gr000vie
vpataa  ds   1         ;93 visual pattern pf0
vpatab  ds   1         ;94 visual pattern pf1
vpatac  ds   1         ;95 visual pattern pf2
fgra    ds   1         ;96 foreground color
bgra    ds   1         ;97 background color
vpatba  ds   1         ;98 visual pattern pf0
vpatbb  ds   1         ;99 visual pattern pf1
vpatbc  ds   1         ;9a visual pattern pf2
fgrb    ds   1         ;9b foreground color
bgrb    ds   1         ;9c background color
sza     ds   1         ;9d size upper field   (17)     sum is 38
szb     ds   1         ;9e size middle filed  (4)
szc     ds   1         ;9f size lower field   (17)



; Start of program, init registers and clear memory
;.---=== cODa
       seg Code
       org $f000

Start  sei
       cld
       ldx #$ff
       txs

       lda #$00
zERo   sta $00,x
       dex
       bne zERo
       sta $00

rEBOOt
	lda #$00
        sta AUDC0
        sta AUDC1
        sta frame
        sta step
        sta seqos
        sta seqosz
        
        lda OFFSETBAR
        sta bar

        ;lda #10
        ;sta step
        lda #17
        sta sza
        sta szc
        lda #4
        sta szb

        lda #1
        sta CTRLPF


nxtFrame
        VERTICAL_SYNC

	clc		;2
	lda #VOLA	;2
        sta vla		;3
        adc svolb	;2
        sta AUDV0	;3
        lda svolb	;2
        sta vlb		;3
        
        lda step	;3
        sta lenb	;3
        
        lda #0          ;2
        sta lina        ;3
        sta actb        ;3
        
;.-===========================================================vBLANK
;.--- main vblank loop
       ldx #6           ;6*6=36 ...we had already 2 wsynx before to get 44 vblanx
a_vbl
       nop              ;placeholdar for grfx a
       sta WSYNC
       sta WSYNC
       jsr aud_o        ;run 1st nibble of channel 2
       sta WSYNC
       nop              ;placeholdar for grfx b
       sta WSYNC
       sta WSYNC
       jsr aud_p        ;run 2nd nibble of channel 2
       sta WSYNC
       dex
       bne a_vbl


       ;.-=set hardsynkie n pwm
       clc               ;2
       lda step          ;3 get position
       adc seqos         ;3
       tay
       lda sHSY,y        ;4 get setpoint from seq
       sta lenb          ;3 apply it
       lda sPWM,y        ;4 ...same with pwm of first osci
       sta lena          ;3
       lda bVOL,y        ;4
       sta svolb         ;3


       sta WSYNC
;.-=cHKiFeEEENd
       lda bar          ;3
       cmp #LENGHT      ;2
       beq endie        ;3
       jmp a_noend      ;3   _11

;.---=== dA EEEEEEENd
endie
       lda #0
       sta AUDV0        ;siiiilence
       lda SWCHB        ;check if bw-switched on
       AND #$8
       bne endie
       jmp rEBOOt       ;if set to bw ===>> endless tekKkKKonoOOoo
a_noend

       sta WSYNC
       jsr aud_o        ;run 1st nibble of channel 2
       sta WSYNC
       
      ;;;;;;.--------=========== gRFXsEQQqie A
      clc
      lda frame
      cmp #00           ;2 we want to update on frame 1 coz frame 0 is already a loads of instr
      bne a_nogfxupd

      ldy bar
      lda a_songgfx,y
      clc
      adc step
      tay
      lda a_seqgfx,y

      cmp #$0a
      bcs a_gfxsetpatt

      cmp #1
      beq a_shftlft

      cmp #2
      beq a_shftrt

      cmp #3
      beq a_drkn

      cmp #4
      beq a_shftlftd

      cmp #5
      beq a_shftrtd

      jmp a_nogfxupd               ;;;;;;;;plazhalterle


a_shftlft
      clc
      ror vpatac
      rol vpatab
      ror vpataa
      jmp a_nogfxupd

a_shftrt
      rol vpatac
      ror vpatab
      rol vpataa
      jmp a_nogfxupd

a_shftlftd
      clc
      ror vpatac
      rol vpatab
      ror vpataa
      jmp a_drkn

a_shftrtd
      rol vpatac
      ror vpatab
      rol vpataa
      jmp a_drkn

a_drkn
      lda fgra
      clc
      sbc #2
      sta fgra
      jmp a_nogfxupd

a_gfxsetpatt
      AND #$0f
      tay
      lda PF0DataA,y
      sta vpataa
      lda PF1DataA,y
      sta vpatab
      lda PF2DataA,y
      sta vpatac
      lda fgcol,y
      sta fgra
      lda bgcol,y
      sta bgra
      jmp a_nogfxupd

a_nogfxupd
      sta WSYNC
      ;;;;;;.--------=========== gRFXsEQQqie B
      clc
      lda frame
      adc #1
      cmp speedie           ;2 we want to update on frame 1 coz frame 0 is already a loads of instr
      bne b_nogfxupd

      ldy bar
      lda b_songgfx,y
      clc
      adc step
      tay
      lda b_seqgfx,y

      cmp #$0a
      bcs b_gfxsetpatt

      cmp #1
      beq b_shftlft

      cmp #2
      beq b_shftrt

      cmp #3
      beq b_drkn

      cmp #4
      beq b_shftlftd

      cmp #5
      beq b_shftrtd

      jmp b_nogfxupd               ;;;;;;;;plazhalterle

b_shftlft
      clc
      ror vpatbc
      rol vpatbb
      ror vpatba
      jmp b_nogfxupd

b_shftrt
      rol vpatbc
      ror vpatbb
      rol vpatba
      jmp b_nogfxupd

b_shftlftd
      clc
      ror vpatbc
      rol vpatbb
      ror vpatba
      jmp b_drkn

b_shftrtd
      rol vpatbc
      ror vpatbb
      rol vpatba
      jmp b_drkn

b_drkn
      lda fgrb
      sbc #2
      sta fgrb
      jmp b_nogfxupd

b_gfxsetpatt
      AND #$0f
      tay
      lda PF0DataA,y
      sta vpatba
      lda PF1DataA,y
      sta vpatbb
      lda PF2DataA,y
      sta vpatbc
      lda fgcolb,y
      sta fgrb
      lda bgcolb,y
      sta bgrb
      jmp b_nogfxupd

b_nogfxupd

;,.-=================================endofgrfx
       sta WSYNC
       jsr aud_p        ;run 2nd nibble of channel 2
       sta WSYNC

       sta WSYNC
       sta WSYNC

;       stx VBLANK       ;so now we're ready for kernallll

       lda #0
       ;sta VSYNC
       sta VBLANK

;.-===========================================================kERNAL
	ldx sza
a_scan
	jsr grfxxx
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_o        ;run 1st nibble of channel 2
        sta WSYNC
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_p        ;run 2nd nibble of channel 2
        sta WSYNC
	dex       	;2
	bne a_scan	;2

       	ldx szb
b_scan
	jsr grfxxy
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_o        ;run 1st nibble of channel 2
        sta WSYNC
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_p        ;run 2nd nibble of channel 2
        sta WSYNC
	dex       	;2
	bne b_scan	;2

	ldx szc
c_scan
	jsr grfxxx
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_o        ;run 1st nibble of channel 2
        sta WSYNC
	inc lina
	sta WSYNC	; WSYNC doesn't care what value is stored
	jsr HASY     	;6
        sta WSYNC
        jsr aud_p        ;run 2nd nibble of channel 2
        sta WSYNC
	dex       	;2
	bne c_scan	;2


;.-===========================================================oVARsKANNNn
       lda #0
       sta COLUBK
       sta COLUPF
       sta PF0
       sta PF1
       sta PF2
       sta WSYNC

;,.-=oVERsKAN
       lda #2
       sta VBLANK

       ldx #5             ;5*6 coz goin to waste 6 lines later
a_osk  nop              ;placeholdar for grfx a
       sta WSYNC
       sta WSYNC
       jsr aud_o
       sta WSYNC
       nop              ;placeholdar for grfx a
       sta WSYNC
       sta WSYNC
       jsr aud_p
       sta WSYNC
       dex
       bne a_osk


;.-=line 1
	inc frame	;5
        lda frame	;3
        cmp speedie     ;2
        bne nosxtl	;2

	lda #0		;2
        sta frame	;3
	inc step	;5
        lda step	;3
        cmp #16		;2
        bne nosxtl	;2
        
        lda #0		;2
        sta step	;2
        inc bar         ;5     39
nosxtl
        ldy bar         ;3
        lda a_SEQ,y     ;4
        sta seqos       ;3
        lda a_SEQz,y    ;4
        sta seqosz      ;3     17

        sta WSYNC
       

;.-=line 2
       clc              ;2

       lda frame
       cmp #0
       bne nofstfr

       clc
       lda step         ;3
       adc seqosz       ;3
       tay              ;2
       lda sPATz,y      ;4 get seq data
       cmp #0           ;2 no triggar?
       beq a_incs       ;3 then fuuuggoff
       ;.---gETsAMPLEEeEE 2nd cHANNeLlie>>36
       tay              ;-2 save it for masking
       AND #$F0         ;-2 mask out volume cmd
       sta hvolz        ;-3
       tya              ;-2 recover
       AND #$0F         ;-2 n mask out sample numbar
       tay              ;2 get the sample offset
       dey              ;2
       lda SADR_L,y     ;4
       sta $90          ;3
       lda SADR_H,y     ;4
       sta $91          ;3
       lda LEN,y        ;4
       sta ftgz         ;3          19+36= 55 cycles

nofstfr:
       sta WSYNC

;.-=line 3
a_incs
       lda ftgz         ;sample length handlar
       cmp #0
       beq nosmplanym
       sbc #1
       sta ftgz
nosmplanym:
       clc              ;groove handlar
       lda step
       and #1
       adc #SPEEDA
       sta speedie
       sta WSYNC

;.-=line 4
       lda bar
       cmp #9
       beq zweit
       cmp #25
       beq dritt
       cmp #33
       beq viert
       cmp #37
       beq zweit
       cmp #45
       beq zweit
       cmp #49
       beq dritt

       cmp #17
       beq standard
       cmp #29
       beq standard
       cmp #41
       beq standard
       cmp #53
       beq standard

       jmp noscaler

zweit:
      lda #14
      sta sza
      sta szc
      lda #10
      sta szb
      jmp noscaler

dritt:
      lda #7
      sta sza
      lda #12
      sta szb
      lda #19
      sta szc
      jmp noscaler

viert:
      lda #21
      sta sza
      lda #12
      sta szb
      lda #5
      sta szc
      jmp noscaler

standard:
      lda #17
      sta sza
      sta szc
      lda #4
      sta szb

noscaler:
       sta WSYNC
       sta WSYNC

       jmp nxtFrame

;.-===========================================================fKTS

HASY:
;.---a vol
	;cpx #LENA	;2 9
	lda lina
	cmp lena
        bne nida	;2
	lda #0		;2
        sta vla		;3
        ;sta lina
nida
;.---b vol
	lda actb	;3 8  get actual cycle
        cmp lenb	;3
        bne setvol	;2    not yet reached -> go to mixer
        
        lda vlb		;3 7  check if already
        cmp #0		;2
        bne bzub	;2

        lda svolb	;2 11
        sta vlb		;3
        sta actb	;3
        jmp setvol	;3
                
bzub
	lda #0		;2 10
        sta vlb		;3
        ;lda #0		;2
        sta actb        ;3
        
setvol
	clc		;2 22
	lda vla		;3
        adc vlb		;3
        sta AUDV0	;3
        inc actb	;5
        rts		;6



;.---====sEKNDcHANNELLl
;.--- pLAY fIRSt nIBBle
aud_o:                  ;>>44 (57) if played
      lda ftgz          ;3
      cmp #0            ;2
      bne pla_o         ;3
      lda #7            ;2
      sta AUDV1         ;3
      rts               ;6
pla_o sty ytmp          ;3
      ldy #0            ;2
      lda hvolz         ;--3
      cmp #$10          ;--2
      bne full_o        ;--3    LAUTERRRR
      lda (smplz),y     ;6
      sta audtmpz       ;+3
      and #$0E          ;+2 discard lsb coz of half da volume
      lsr               ;+2
      adc #4            ;+2
      sta AUDV1         ;3
      lda audtmpz       ;+3
      lsr               ;8 all lsr
      lsr
      lsr
      lsr
      and #$0E          ;+2
      lsr               ;+2
      adc #4            ;+2
      sta audtmpz       ;3
      ldy ytmp          ;3
      rts               ;6
full_o
      lda (smplz),y     ;6
      sta AUDV1         ;3
      lsr               ;8 all lsr
      lsr
      lsr
      lsr
      sta audtmpz       ;3
      ldy ytmp          ;3
      rts               ;6

;.--- pLAY sEKnd nIBBle
aud_p:                  ;>>45 if played
      lda ftgz          ;3
      cmp #0            ;2
      bne pla_p         ;3
      lda #7            ;2
      sta AUDV1         ;3
      rts               ;6
pla_p sty ytmp          ;3
      ldy #0            ;2
      lda audtmpz       ;3
      sta AUDV1         ;3
      ;---aDDie
      clc               ;2
      lda $90           ;3
      adc #1            ;2
      sta $90           ;3
      bcc nlo_p         ;3
      inc $91           ;5
nlo_p ldy ytmp          ;2
      rts               ;6

;.-====gRFXxXx
grfxxx:
       lda vpataa       ;4 (11)
       sta PF0          ;3 (14)
       lda vpatab       ;4 (18)
       sta PF1          ;3 (21)
       lda vpatac       ;4 (25)
       sta PF2          ;3 (28)
       lda fgra         ;4 (32)
       sta COLUPF       ;3 (35)
       lda bgra         ;4 (39)
       sta COLUBK       ;3 (42)
       rts              ;6 (48)
grfxxy:
       lda vpatba       ;4 (11)
       sta PF0          ;3 (14)
       lda vpatbb       ;4 (18)
       sta PF1          ;3 (21)
       lda vpatbc       ;4 (25)
       sta PF2          ;3 (28)
       lda fgrb         ;4 (32)
       sta COLUPF       ;3 (35)
       lda bgrb         ;4 (39)
       sta COLUBK       ;3 (42)
       rts              ;6 (48)



;.-===========================================================dATAH
	align $100

BD
	hex 8babdeeffffffffc3000015cfffffffffb100000017effffff
	hex fff920000000005bfffffffffe610000000000039dffffffff
	hex ffb5100000000000038cffffffffffffb63000000000000002
	hex 69cfffffffffffffeb8530000000000000000258cfffffffff
	hex fffffffeca741000000000000000000247beffffffffffffff
	hex fffffdca8410000000000000000000002369ceffffffffffff
	hex ffffffffffedca75210000000000000000000000012468bdef
	hex ffffffffffffffffffffffffffedba75421000000000000000
	hex 0000000001224578acdeefffffffffffffffffffffffffffff
	hex eedca87542110000000000000000000000000001122345689a
	hex abccddddddddddddeeeffffffffffffffffffffedcba976544
	hex 3322222233333333221100000000000000112234567889aaab
	hex bcccdddeeeffffffffffffffffffffffffffeddcba98877665
	hex 55444444444443333221100000000000000000112334556677
	hex 88899999999aabbccdeeffffffffffffffffffffffeedccbaa
	hex 99888777666666555544332211000000000000000000001122
	hex 3344455566666777777777778899aabbccdddeeeffffffffff
	hex fffeeeddcccbbaaaa999999999999999988776654433221110
	hex 000000001112222333344444555555555556677889aabccdde
	hex effffffffffffffffeeedddccccbbbbaaaaaaaaa9998876654
	hex 43321110000000000000000011112222333334444455566789
	hex abccdeeffffffffffffffffffffffffeeedddcccbbaa998876
	hex 65544333222111110000000000000000011111112222233333
	hex 44444555566677889aabbccdddeeeeeffffffffffffeeeeeee
	hex ddddcccbbbbaaa999988877666554443333222222222222222
	hex 2222333344445555566666677777777788889999aaaabbbbbb
	hex ccccccccccccccccbbbbbbaaaa999888877777666666555555
	hex 55555555555555555555555556666666666666667777777788
	hex 88999999aaaaaaaaaaaaaaaaaaaa9999999999888888877777
	hex 77777777666666666666666666666666667777777777777788

RS
	hex 79d44d719ecda222225dddc41319de923335ddddb323bdccb3
	hex 3cb6bc922326dccbcbb812223bcbbb81318cb9232327dbcbb6
	hex 23343569ccccbc82428cbb9aba8b832325bbbba73234558989
	hex 89988896555678a99888876577688987879877767778898877


hIT
	hex 8f2ffffa6323533565444beaa67db9864435665ae9768766cf
	hex a7554438ecb875565655bbbb79d96444467768885acbea9754
	hex 476544457889efd986567644344557fedabc975433347978db
	hex 866767dc98644445aa9976699758a88766aa88766777677778
	
OHI
	hex c8dcab9baae99b5bb696a95846a396681a0714346180815546
	hex 0a166667876959699b9c8cd9fbdaac8d8e9dc9c8e6f7bb7f5e
	hex 7c9a7a989a8997b497b8b7d2e3b87a5d2c4a4c2f6891e5a394
	hex 8488292859455776566428475574739185461a1a1947484668
	
SNRRR
	hex 1fffffffffffff7fffff4ffffffcbfff00ad6500dfffefff1e
	hex f0000041400000006aa950ff0ddf6010000037ffffefffdefc
	hex 2e10ea0f0ffb000010faf9afbffff5f2000900050877a10000
	hex 3847ff97fbff4f79b906060612660030000225c3dbdd6d6d4d
	hex c8b5d8dd673d34222222232a285482b392965d2ddddddbd9d4
	hex d7dd4d2d3953b252222222292492d297b894d97dddadbdbd4d
	hex ddc7a5d8cd774b5442222225294775a2a442452b2dcdd9d6d5
	hex 72666b2d7d9b97d6822424453aa8d2d7a5453276298d3d4d6d
	hex 24838652dbab5d4d82529b363c4c94d5d5928659279d47c6cb
	hex 636639328ba48d6b45596a447698a69a785988866788787888






;.-================sYNTHpATTERNs
sPWM       ;               ;               ;               ;                 ; 1-4c
     .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00   ;0  silencium
     .byte $4f,$44,$3f,$34,$3f,$37,$34,$2f,$24,$24,$28,$2b,$30,$34,$38,$3b   ;1  looo
     .byte $10,$30,$20,$40,$20,$40,$10,$00,$05,$40,$20,$30,$00,$10,$40,$00   ;2  std a
     .byte $10,$02,$20,$10,$20,$40,$00,$00,$05,$40,$20,$30,$00,$00,$30,$40   ;3  std b
     .byte $40,$00,$20,$00,$20,$00,$30,$00,$05,$40,$20,$30,$00,$40,$10,$00   ;4  arpie
     .byte $3f,$14,$3f,$34,$3f,$37,$34,$2f,$24,$24,$28,$2b,$30,$34,$28,$1b   ;5  lo a
     .byte $3f,$14,$3f,$34,$3f,$37,$34,$2f,$24,$24,$28,$2b,$30,$10,$40,$00   ;6  lo b
     .byte $20,$40,$00,$00,$05,$40,$20,$30,$05,$40,$20,$30,$00,$00,$00,$00   ;7  std a  fill
     .byte $10,$02,$20,$10,$20,$40,$00,$00,$05,$40,$20,$30,$00,$00,$00,$00   ;8  std b  fill

sHSY       ;               ;               ;               ;                 ;05-4c
     .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00   ;0  silencium
     .byte $10,$17,$20,$27,$30,$37,$40,$4c,$05,$06,$07,$08,$09,$20,$24,$29   ;1
     .byte $10,$14,$18,$08,$04,$20,$24,$29,$10,$14,$18,$00,$00,$20,$24,$29   ;2
     .byte $05,$06,$07,$08,$04,$20,$24,$29,$10,$14,$18,$00,$00,$20,$24,$29   ;3
     .byte $10,$05,$20,$04,$30,$17,$40,$4c,$05,$06,$07,$08,$09,$20,$24,$29   ;4
     .byte $00,$40,$30,$10,$00,$02,$03,$01,$01,$05,$06,$00,$00,$00,$00,$00   ;5
     .byte $01,$00,$02,$00,$03,$00,$03,$01,$00,$05,$06,$00,$00,$00,$00,$00   ;6
     .byte $10,$14,$18,$08,$04,$20,$24,$29,$10,$14,$18,$08,$18,$08,$18,$08   ;7
     .byte $05,$06,$07,$08,$04,$20,$24,$29,$04,$07,$05,$05,$06,$07,$05,$02   ;8

bVOL       ;               ;               ;               ;
     .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00   ;0  silencium
     .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00   ;1
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;2
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;3
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;4
     .byte $00,$01,$02,$04,$00,$02,$04,$04,$00,$04,$02,$04,$04,$04,$01,$04   ;5
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;6
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;7
     .byte $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04   ;8

;.-================sAMPLEpATTERNs
sPATz     ;               ;               ;               ;
     .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00   ;0  silencium
     .byte $01,$00,$02,$12,$05,$00,$00,$11,$01,$00,$01,$00,$05,$00,$11,$01   ;1  easybeat
     .byte $01,$04,$01,$00,$05,$15,$03,$01,$12,$01,$00,$11,$05,$00,$04,$15   ;2  more cmplx beat
     .byte $01,$01,$00,$01,$11,$00,$05,$15,$01,$11,$00,$01,$11,$00,$15,$05   ;3  tripplies
     .byte $12,$02,$00,$13,$00,$03,$02,$12,$14,$13,$00,$00,$13,$14,$14,$02   ;4  intro rtmshotzzz
     .byte $11,$02,$14,$00,$11,$00,$15,$12,$11,$13,$02,$00,$11,$15,$00,$03   ;5  easie intro beat
     .byte $11,$00,$14,$00,$11,$15,$02,$12,$11,$12,$02,$03,$01,$01,$11,$01   ;6  easie intro beat fill
     .byte $01,$00,$04,$14,$05,$11,$04,$01,$03,$01,$03,$13,$05,$00,$04,$14   ;7  easybeat pluss
     .byte $15,$15,$13,$03,$05,$15,$05,$04,$05,$00,$15,$05,$00,$15,$11,$01   ;8  more cmplx beat fill
     .byte $01,$00,$02,$12,$15,$05,$00,$15,$05,$00,$15,$05,$00,$15,$05,$00   ;9  easybeat  fill
     .byte $01,$11,$04,$14,$05,$15,$13,$05,$03,$15,$05,$04,$14,$05,$01,$01   ;a  easybeat pluss fill
     .byte $01,$00,$01,$03,$05,$15,$05,$02,$01,$12,$11,$01,$05,$00,$04,$11   ;b  more cmplx beat 2
     .byte $01,$00,$04,$05,$01,$00,$04,$03,$01,$00,$14,$04,$01,$00,$04,$11   ;c  4ondafloor
     .byte $01,$00,$01,$02,$05,$00,$02,$05,$01,$00,$01,$04,$05,$01,$04,$11   ;d  rumplrumpl

LEN        ;bd  rs hit ohi snrr
     .byte $10,$03,$03,$03,$06
SADR_L
     .byte $00,$EE,$52,$B6,$1A
SADR_H
     .byte $F4,$F6,$F7,$F7,$F8


;.-================sYNTHsONG
a_SEQ    ;synthhh
     .byte $00              ;5               ;9               ;13                  ;wait a bar to avoid 1st bd cutted
     .byte $10,$10,$20,$20, $20,$20,$20,$20                                        ; 1-8
     .byte $30,$30,$30,$30, $20,$20,$20,$70, $50,$50,$50,$50, $60,$60,$60,$60      ; 9-24
     .byte $30,$30,$30,$80, $40,$40,$40,$40, $40,$40,$40,$40, $30,$80,$30,$30      ;25-40
     .byte $10,$60,$20,$20                                                         ;41-44
     .byte $50,$50,$50,$50, $30,$30,$30,$30, $20,$70,$20,$20, $40,$50,$60,$10      ;45-60


a_SEQz   ;samples
     .byte $00              ;5               ;9               ;13                  ;wait a bar to avoid 1st bd cutted
     .byte $00,$00,$00,$00, $40,$40,$50,$60                                        ; 1-8
     .byte $10,$10,$10,$90, $20,$20,$20,$20, $70,$70,$70,$A0, $20,$20,$20,$80      ; 9-24
     .byte $30,$30,$50,$60, $B0,$B0,$B0,$A0, $D0,$D0,$D0,$60, $20,$20,$20,$80      ;25-40
     .byte $30,$30,$30,$80                                                         ;41-44
     .byte $C0,$C0,$C0,$90, $B0,$B0,$B0,$80, $70,$70,$60,$80, $40,$50,$00,$00      ;45-60

;.-===========================================================gRAFIxXx
a_seqgfx ;(get fg patterns on every 16tl)
     .byte $16,$17,$15,$16, $15,$18,$19,$16, $15,$17,$15,$16, $19,$18,$15,$16      ;0 whitie on one, middle to outside
     .byte $11,$15,$12,$10, $04,$04,$04,$04, $13,$14,$12,$11, $05,$05,$05,$05      ;1 green cyber flashie
     .byte $14,$11,$13,$15, $11,$05,$05,$05, $04,$04,$04,$15, $00,$00,$00,$00      ;2 fl rt 1st
     .byte $12,$01,$01,$15, $12,$05,$05,$05, $04,$04,$12,$04, $04,$04,$04,$04      ;3 ...
     .byte $17,$05,$05,$11, $05,$15,$11,$05, $17,$05,$05,$15, $03,$14,$03,$17      ;4 tl n or 1
     .byte $16,$03,$03,$15, $00,$00,$00,$00, $00,$16,$17,$15, $00,$00,$00,$00      ;5 tl n or fl on 1
     .byte $15,$00,$00,$00, $00,$00,$00,$19, $15,$15,$18,$15, $19,$17,$16,$18      ;6 fill starts blackie
     .byte $15,$00,$00,$00, $00,$00,$00,$00, $00,$00,$00,$00, $00,$00,$00,$00      ;7 blackouttie
     .byte $10,$01,$04,$04, $04,$04,$15,$00, $01,$01,$04,$01, $11,$15,$12,$13      ;8 fill whitie on one, middle to outside


b_seqgfx ;(get fg patterns on every 16tl)
     .byte $10,$15,$11,$15, $12,$15,$13,$15, $01,$01,$04,$01, $01,$01,$01,$01      ;0 blue strobo
     .byte $15,$10,$13,$14, $05,$03,$05,$03, $13,$15,$14,$15, $00,$00,$00,$00      ;1 flashie half n right
     .byte $15,$00,$10,$15, $00,$00,$14,$15, $13,$14,$04,$04, $04,$04,$04,$04      ;2 fl rt 2nd
     .byte $14,$15,$00,$00, $13,$14,$15,$13, $15,$00,$11,$05, $05,$05,$05,$05      ;3 ...
     .byte $15,$00,$00,$19, $05,$05,$05,$05, $19,$15,$18,$05, $04,$04,$05,$05      ;4 tl n or 1
     .byte $15,$00,$00,$00, $16,$15,$18,$04, $04,$04,$04,$15, $00,$18,$05,$05      ;5 tl n or fl on 1
     .byte $18,$19,$15,$16, $14,$03,$03,$03, $05,$05,$15,$00, $00,$00,$00,$00      ;6 fill ends blackie
     .byte $15,$00,$00,$00, $00,$00,$00,$00, $00,$00,$00,$00, $00,$00,$00,$00      ;7 blackouttie
     .byte $10,$01,$04,$04, $04,$04,$15,$00, $01,$01,$04,$01, $11,$15,$12,$13      ;8 fill whitie on one, middle to outside

;.-===sONGmODE
a_songgfx    ;fx pattern
     .byte $70              ;5               ;9               ;13                  ;waitie waitie
     .byte $70,$70,$70,$70, $70,$70,$70,$60                                        ; 1-8
     .byte $40,$40,$40,$40, $70,$40,$40,$70, $50,$50,$50,$50, $60,$50,$40,$40      ; 9-24
     .byte $70,$70,$10,$70, $30,$10,$30,$20, $10,$20,$30,$30, $10,$20,$30,$30      ;25-40
     .byte $70,$70,$70,$60                                                         ;41-44
     .byte $40,$40,$50,$50, $30,$10,$30,$20, $10,$20,$30,$30, $10,$20,$70,$70      ;45-60

b_songgfx    ;fx pattern
     .byte $70              ;5               ;9               ;13                  ;waitie waitie
     .byte $00,$00,$40,$70, $00,$00,$00,$80                                        ; 1-8
     .byte $40,$40,$50,$50, $50,$50,$40,$40, $60,$50,$60,$50, $30,$30,$70,$70      ; 9-24
     .byte $20,$10,$20,$10, $30,$10,$30,$20, $10,$20,$30,$30, $10,$20,$30,$30      ;25-40
     .byte $40,$40,$50,$50                                                         ;41-44
     .byte $30,$10,$70,$30, $30,$10,$30,$20, $10,$20,$30,$30, $10,$20,$30,$30      ;45-60

;.-===gRFXpATTERNs
PF0DataA      ;7654             left   4...7 (l2r)
	.byte %00000000        ;0
	.byte %10000000        ;1
	.byte %01110000        ;2
	.byte %01010000        ;3
	.byte %01100000        ;4
	.byte %00000000        ;5   null
	.byte %01110000        ;6
	.byte %01000000        ;7
	.byte %11110000        ;8
	.byte %10000000        ;9

PF1DataA      ;76543210         middle   7...0 (l2r)
	.byte %00000000        ;0
	.byte %00110111        ;1
	.byte %11001001        ;2
	.byte %10101010        ;3
	.byte %01100110        ;4
	.byte %00000000        ;5
	.byte %01101010        ;6
	.byte %01000100        ;7
	.byte %10001111        ;8
	.byte %00001000        ;9

PF2DataA      ;76543210         center   0...7 (l2r)
	.byte %01001011        ;0
	.byte %01001101        ;1
	.byte %11101100        ;2
	.byte %01010101        ;3
	.byte %01100110        ;4
	.byte %00000000        ;5
	.byte %01100110        ;6
	.byte %10010001        ;7
	.byte %01111100        ;8
	.byte %00100010        ;9


fgcol         ;0   1   2   3   4   5   6   7   8   9
        .byte $B0,$0E,$0E,$0E,$0E,$00,$5E,$50,$5E,$50
bgcol
        .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00
fgcolb
        .byte $B0,$B2,$B4,$0E,$0E,$00,$50,$5E,$50,$5E
bgcolb
        .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00


;.-===========================================================aeAEND
	org $fffc
	.word Start
	.word Start
