;       Compile with WLA-6510 (http://www.hut.fi/~vhelin/wla.html)

.MEMORYMAP
DEFAULTSLOT 0
SLOTSIZE $ffff
SLOT 0 $0000
.ENDME

.ROMBANKMAP
BANKSTOTAL 1
BANKSIZE $ffff
BANKS 1
.ENDRO

.BANK 0


.DEFINE LoadAddr        $0801

.ORG $0
.SECTION "BANKHEADER"
        .dw     LoadAddr
.ENDS


.DEFINE screen          $fb
.DEFINE screenh         $fc
.DEFINE scroll          $fd
.DEFINE downdec         $fe
.DEFINE bombadd         $ff


.ORG LoadAddr
.SECTION "MAIN" FORCE
        .DB     $0b,$08,$0a,$00,$9e,$32,$30,$38,$30         ;"10 sys2080"
        .DB     $00,$00,$00

_scnt:
        .DB     $04
        .DB     $00
        .DB     $00

        .DB     %00000000
        .DB     %01001000
        .DB     %11011110
        .DB     %11111111
        .DB     %11111111
        .DB     %11111111
        .DB     %10110110
        .DB     %00000000

        .DB     %11111111
        .DB     %10010011
        .DB     %10010011
        .DB     %11111111
        .DB     %11111111
        .DB     %10010011
        .DB     %10010011
        .DB     %11111111


Go:
        sei

        lda     #$00
        tay
_scr:
        sta     $d800,y
        sta     $0398,y
        iny
        bne     _scr

        inc.w   _scr+2
        inc.w   _scr+5
        dec.w   _scnt
        bne     _scr

NewGame:
        ldx     #$07
        ldy     #$15
_bombs:
        lda.w   Bomb-1,x
        sta     $03c1,y
        dey
        dey
        dey
        dex
        bne     _bombs

        ldy     #$27
_vicinit:
        lda     VICII,y                 ; set up video
        sta     $d011,y
        lda     SID,y                   ; set up sound
        sta     $d400,y
        lda.w   Plane-3,y               ; copy zeppelin sprite
        sta     $0380,y
        lda     #$0d                    ; green grass
        sta     $dbc0,y
        txa                             ; zero
        sta     $07e8,y                 ; space
        dey
        bpl     _vicinit

        stx     $d000
        stx     $d003
        stx     bombadd

        ldy     #$0e
        sty     $07f8
        iny
        sty     $07f9

;-----  build new level

        ldy     #$c0
_build:
        tya
        pha
        sta     screen
        lda     #$07
        sta     screenh

_lev:
        lda     $a033,y
        and     #$07
_heig:
        tax
        inx
        ldy     #$00

        lda     #$82                    ; ground
_up:
        jsr     lineup
        bpl     _up

        pla
        tay
        iny
        cpy     #$e8
        bne     _build


        lda     #$80
        sta     $d002
        lsr
        sta     $d001


;-----  main game loop

Loop:
        dec     downdec                 ; zeppelin humming and move down
        lda     downdec
        sta     $d407
        and     #$3f
        bne     _nodown

        inc     $d001                   ; pixel down

_nodown:
        lda     bombadd
        beq     _nobomb

        inc     bombadd
        lsr
        lsr
        lsr
        clc
        adc     $d003
        bcc     _nobombstop
_bombstop:
        lda     #$00
        sta     bombadd
_nobombstop:
        sta     $d003
        tax
        eor     #$ff
        sta     $d40f
        txa

        cmp     #$b0
        bcc     _nobomb
        lsr
        lsr
        lsr
        tay
        lda.w   _mul-$16,y
        sta     screen
        lda.w   _mulh-$16,y
        sta     screenh  

        ldy     #$00
        lda     (screen),y
        beq     _nobomb

        ldx     #$08
_wipe:
        tya
        sta     $d003
        jsr     lineup
        bne     _wipe


        ldy     #$80
        sty     $d404                   ; explosion gate off
        iny
        sty     $d404                   ; explosion gate on
        iny
        sty     $07cd                   ; fix ground character
        bne     _bombstop
       
_nobomb:

        ldx     #$fc
_wait:
        cpx     $d012
        bne     _wait

        dec     scroll
        bpl     _noleap

        lda     #$07
        sta     $d016
        sta     scroll
        sta     screenh

        lda     #$98
        sta     screen

        ldx     #$08                    ; maximum building height
_lines:
        ldy     #$00

        lda     (screen),y
        pha

_leap:
        iny
        lda     (screen),y
        dey
        sta     (screen),y
        iny
        cpy     #$27
        bne     _leap

        pla

        jsr     lineup
        bne     _lines

_noleap:
        lda     scroll
        sta     $d016


;-----  check space (and move zeppelin)

        jsr     $ff9f                   ; scnkey

        lsr     $d01f
        bit     $d000
        bmi     _play

        inc     $d000
        jmp     Loop

_play:
        bcs     _die

        cpx     #$20
        bne     _nospace

        lda     bombadd
        bne     _nospace

        inc     bombadd
        lda     $d001
        sta     $d003

        ldy     #$10
        sty     $d412
        iny
        sty     $d412

_nospace:
        jmp     Loop

_die:
        lda     $d001
        cmp     #$e7
        beq     _next
        lda     #$81
_new:
        sta.w   SID+4
        jmp     NewGame
_next:
        inc.w   _lev+2
        lsr.w   VICII+16
        lda     #$21
        bne     _new


;-----  move one line up (and do something else first)

lineup:
        sta     (screen),y
        lda     screen
        sec
        sbc     #$28
        sta     screen
        bcs     _noc
        dec     screenh
_noc:
        lda     #$43                    ; building
        dex
        rts


;-----  misc setup tables and sprites

_mul:
        .DEFINE raddr $068d
        .REPT 9
        .DB raddr&255
        .REDEFINE raddr raddr+40
        .ENDR
_mulh:
        .REDEFINE raddr $068d
        .REPT 9
        .DB raddr/256
        .REDEFINE raddr raddr+40
        .ENDR
        

SID:
        .DB     $00,$08,$00,$00,$21,$0b,$0b
        .DB     $ff,$04,$00,$00,$11,$00,$50
        .DB     $ff,$00,$00,$00,$10,$98,$08
        .DB     $00,$38,$f5,$1f
VICII:
        .DB     $5b,$00,$00,$00,$03,$07,$00
        .DB     $13,$00,$00,$03,$00,$00,$00,$00
        .DB     $00,$53,$0f,$05,$00,$00,$00,$00

Plane:
        .DB     %01100000,%11111111,%11110000
        .DB     %01110011,%11111111,%11111100
        .DB     %01111111,%11111111,%11111110
        .DB     %01111111,%11111111,%11111111
        .DB     %11111111,%11111111,%11111111
        .DB     %11111111,%11111111,%11111111
        .DB     %01111111,%11111111,%11111111
        .DB     %01111111,%11111111,%11111110
        .DB     %01110011,%11111111,%11111100
        .DB     %01100000,%01111111,%11110000
        .DB     %00000000,%00101010,%10000000
        .DB     %00000000,%00111111,%00000000

Bomb:
        .DB     %00000000
        .DB     %11111000
        .DB     %01110000
        .REPT   3
        .DB     %11111000
        .ENDR
        .DB     %01110000

.ENDS
