/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: VIDEO.H                                          */
/*  DESCRIPCION:        Definicin de clases y funciones para el manejo  */
/*                      del video (paleta, modos video, etc...).         */
/*  CONTENIDO:          .class paleta256.                                */
/*                      .void ModoTexto(void).                           */
/*                      .void Modo320200256(void).                       */
/*                      .void Modo64048016(void).                        */
/*                      .char LeerFuncionesVesa(char far*).              */
/*                      .char LeerModoVesa(int, char far*).              */
/*                      .void CalcularDesplazaV(int).                    */
/*                      .char Modo640400256(void).                       */
/*                      .char Modo640480256(void).                       */
/*                                                                       */
/*  LLAMADO POR:        VIDEO.CPP: Implementacin de mtodos y funciones */
/*  LLAMA A:            DOS.H: Funcin MK_FP.                            */
/*                      IO.H: Entrada/Salida tipo UNIX sobre ficheros.   */
/*                      FCNTL.H: Definicin de valores de flags I/O.     */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/3/1995                                        */
/*  ACTUALIZACIONES:    ---                                              */
/*                                                                       */
/*  NOTAS: Respecto a los mdulos a los que se llama: el comentario aa- */
/*         dido tras el nombre de estos corresponde a las principales    */
/*         funciones que se toman de estos ficheros, y no a todas las    */
/*         que ofrecen (muchas ms).                                     */
/*  */
/***************************************************************************/
#ifndef VIDEO           //Evitar recompilado.

#define VIDEO 1         //VIDEO == 1  --> Mdulo ya compilado.
#include <dos.h>
#include <io.h>
#include <fcntl.h>

class paleta256{
/***************************************************************************/
/* DESCRIPCION:   Clase para la instanciacin de objetos para el tratamien-*/
/*                to de la paleta en modos grficos de 256 colores.        */
/* HERENCIA:      ---                                                      */
/* MIEMBROS PRIV: .char far *paleta: puntero a una zona de memoria donde se*/
/*                                   ubicarn los valores de la paleta.    */
/*                                   Tras la instanciacin (declaracin)   */
/*                                   del objeto se habrn reservado 768    */
/*                                   bytes (char) en esta zona.            */
/* MIEMBROS PUBL: .paleta256(void).                                        */
/*                .void actualizarDAC(void).                               */
/*                .char cargar(char far*, char).                           */
/*                .void putColor(int ,char, char, char).                   */
/*                .void getColor(int, char*, char*, char*).                */
/*                .void putGris(int, char).                                */
/*                .~paleta256(void).                                       */
/*                                                                         */
/* NOTAS: El objeto 'paleta256' es una tabla o array de 768 posiciones.    */
/*        Simula los 256 registros del DAC (Digital to Analog Converter)   */
/*        que representan los 256 colores a elegir entre 262.144. Esta     */
/*        cifra resulta de la codificacin de colores con 18 bits, pues    */
/*        cada registro de la tabla DAC consta de tres entradas de 6 bits, */
/*        que determinan la proporcin de Rojo, Verde y Azul en el color   */
/*        final. Es por esto que se mantiene una memoria de 768 (3x256)    */
/*        pues cada entrada de cada registro se representa aqu por un dato*/
/*        de tipo char (se desperdician 2 bits). As el color 0 (entrada 0 */
/*        de la tabla DAC) est compuesto por las posiciones 0,1,2 del     */
/*        array interno del objeto. En la clase existe un mtodo para la   */
/*        actualizacin del DAC el cual actualiza esta tabla con los valo- */
/*        res del objeto que lo llama.                                     */
/*        De lo anteriormente expuesto se deduce que la gama de grises po- */
/*        sible se reduce a 64, pues estas son las combinaciones posibles  */
/*        con 6 bits. Recordar que un gris se crea en RGB asignando al Rojo*/
/*        , Verde, y Azul el mismo valor.                                  */
/*        DAC = Digital to Analog Converter.                               */
/*        RGB = Red, Green, Blue.  (rojo, verde, azul).
/***************************************************************************/
   char far *paleta;

 public:
    paleta256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Constructor del objeto. Reserva 768 bytes apuntados por la*/
    /*           variable interna de tipo puntero 'paleta'.                */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void actualizarDAC(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Los valores de la tabla de colores DAC se actualizan to-  */
    /*           mando los valores apuntados por la variable 'paleta'.     */
    /*           El primer registro del DAC toma valores de los 3 primeros */
    /*           bytes de 'paleta', el segundo de los tres siguientes, etc.*/
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Ver notas en la cabecera de la clase.                     */
    /***********************************************************************/

    char cargar(char far *fichero, char modo);
    /***********************************************************************/
    /* ENTRADA:  Un puntero al nombre de fichero origen y un entero tipo   */
    /*           char 'modo'.                                              */
    /* SALIDA:   0 si ha habido un fallo en la lectura.                    */
    /*           1 si la lectura se ha producido con exito.                */
    /*          -1 si ha habido fallo al abrir el fichero.                 */
    /* EFECTO:   El array apuntado por 'paleta' se actualiza con los 768   */
    /*           bytes leidos del fichero.                                 */
    /*           'modo'=0  -->  se leen los 768 primeros bytes del fichero.*/
    /*           'modo'=1  -->  se leen los 768 ltimos bytes del fichero. */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void putColor(int n, char R, char G, char B);
    /***********************************************************************/
    /* ENTRADA:  El entero 'n' representa una entrada a la tabla 'paleta', */
    /*           pero escalada de tal manera que toma valores entre 0 y 255*/
    /*           Los char R, G, B, son valores para Rojo, Verde, Azul.     */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Los valores correspondientes al color 'n' se actualizan.  */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Los valores R, G, B deben ser menores que 64 si se desea  */
    /*           una correcta codificacin del color.                      */
    /*           Las entradas a la tabla tienen el rango 0..255 de tal ma- */
    /*           nera que de cara al exterior sta mantendr 256 posic.    */
    /*           Ver notas en cabecera de la clase.                        */
    /***********************************************************************/

    void getColor(int n, char *R, char *G, char *B);
    /***********************************************************************/
    /* ENTRADA:  El entero 'n' representa una entrada a la tabla 'paleta', */
    /*           pero escalada de tal manera que toma valores entre 0 y 255*/
    /*           Los char R, G, B, son punteros a valores para Rojo, Verde,*/
    /*           Azul.                                                     */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Los datos apuntados por estos tres punteros se actualizan */
    /*           con los valores para rojo, verde y azul del color 'n'.    */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Las entradas a la tabla tienen el rango 0..255 de tal ma- */
    /*           nera que de cara al exterior sta mantendr 256 posic.    */
    /*           Ver notas en cabecera de la clase.                        */
    /***********************************************************************/

    void putGris(int n, char Gris);
    /***********************************************************************/
    /* ENTRADA:  El entero 'n' representa una entrada a la tabla 'paleta', */
    /*           pero escalada de tal manera que toma valores entre 0 y 255*/
    /*           El char 'Gris' representa el valor de gris (0..63).       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Los valores correspondientes al color 'n' se actualizan:  */
    /*           R = Gris, G = Gris, B = Gris.                             */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Las entradas a la tabla tienen el rango 0..255 de tal ma- */
    /*           nera que de cara al exterior sta mantendr 256 posic.    */
    /*           Recordar que un gris se crea en RGB asignando al Rojo,    */
    /*           Verde, y Azul el mismo valor.                             */
    /***********************************************************************/

    ~paleta256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto. Se libera la memoria retenida por  */
    /*           el puntero 'paleta'.                                      */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};

void ModoTexto(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   ---                                                           */
/* EFECTO:   Se establece el modo texto de 80 columnas.                    */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

void Modo320200256(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   ---                                                           */
/* EFECTO:   Se establece el modo grfico de 320x200 puntos y 256 colores. */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

void Modo64048016(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   ---                                                           */
/* EFECTO:   Se establece el modo grfico de 640x480 puntos y 16 colores.  */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

char LeerFuncionesVesa(char far *tabla);
/***************************************************************************/
/* ENTRADA:  Puntero a una tabla donde se almacenarn las funciones VESA.  */
/* SALIDA:   0 si no se soportan las funciones VESA.                       */
/*           1 si se soportan funciones VESA.                              */
/* EFECTO:   Si la funcin se ejecuta con exito la tabla contendr:        */
/*           00h  Signatura VESA (<<VESA>>) .....................  4 BYTE  */
/*           04h  Versin VESA, nmero de versin mayor .........  1 BYTE  */
/*           05h  Versin VESA, nmero de versin menor .........  1 BYTE  */
/*           06h  Puntero FAR sobre cadena ASCII Z con el nombre           */
/*                del fabricante de la tarjeta ..................  1 DWORD */
/*           0Ah  Flag, uqe indica las capacidades de la tarjeta.          */
/*                De momento no se utiliza, por ello 0000h ......  1 DWORD */
/*           0Eh  Puntero FAR, a la lista con los cdigos de los           */
/*                modos de video soportados .....................  1 DWORD */
/* REQUIERE: El buffer o tabla a la que apunta 'tabla' debe medir al menos */
/*           256 bytes.                                                    */
/* NOTAS:    El puntero FAR que se pasa apunta a una lista con cdigos de  */
/*           longitud variable segn la tarjeta. La lista termina con una  */
/*           palabra con el valor 0FFFFh.                                  */
/*           El formato en que se pasa cualquier puntero FAR es:           */
/*              " BYTE4 BYTE3 : BYTE2 BYTE1 "                              */
/*              Ejemplo: 23A4B654 es la direccin: 54B6:A423.
/***************************************************************************/

char LeerModoVesa(int modo, char far *tabla);
/***************************************************************************/
/* ENTRADA:  Un entero que indica el modo de video y un puntero a una      */
/*           tabla.                                                        */
/* SALIDA:   0 si no se soporta este modo VESA.                            */
/*           1 si se soporta el modo VESA.                                 */
/* EFECTO:   Si la funcin se ejecuta con exito la tabla contendr:        */
/*           00h  Bandera de modo ...............................  1 WORD  */
/*           02h  Banderas para la primera ventana de acceso ....  1 BYTE  */
/*           03h  Banderas para la segunda ventana de acceso ....  1 BYTE  */
/*           04h  Granularidad en KBytes, con la que se pueden
/*                desplazar las dos ventanas de acceso ..........  1 WORD  */
/*           06h  Tamao en KB de las dos ventanas de acceso ....  1 WORD  */
/*           08h  Direccin de segmento de la 1 vent. de acceso.  1 WORD  */
/*           0Ah  Direccin de segmento de la 2 vent. de acceso.  1 WORD  */
/*           0Ch  Puntero FAR a la rutina para ajustar la zona
/*                visible en las dos ventanas de acceso .........  1 DWORD */
/*           10h  Nmero de bytes que ocupa cada linea de puntos
/*                en la RAM de video ............................  1 WORD  */
/*           12h  Resolucin X en puntos/caracter ...............  1 WORD  */
/*           14h  Resolucin Y en puntos/caracter ...............  1 WORD  */
/*           16h  Anchura de la matriz de caracteres en puntos ..  1 BYTE  */
/*           17h  Altura de la matriz de caracteres en puntos ...  1 BYTE  */
/*           18h  Nmero de Bit-Planes ..........................  1 BYTE  */
/*           19h  Nmero de bits por punto de pantalla ..........  1 BYTE  */
/*           1Ah  Nmero de bloques de memoria ..................  1 BYTE  */
/*           1Bh  Modelo de memoria .............................  1 BYTE  */
/*           1Ch  Tamao en KB de los bloques de memoria ........  1 BYTE  */
/* REQUIERE: El buffer de informacin cuya direccin se pasa a la funcin  */
/*           debe medir 29 bytes.
/* NOTAS:    Esta funcin suministra informacin sobre un modo VESA, pero  */
/*           no lo activa.                                                 */
/*           El formato en que se pasa cualquier puntero FAR es:           */
/*              " BYTE4 BYTE3 : BYTE2 BYTE1 "                              */
/*              Ejemplo: 23A4B654 es la direccin: 54B6:A423.              */
/*           Los modos de video VESA mas usuales son:                      */
/*              100h   640x 400  256 colores   256 KBytes                  */
/*              101h   640x 480  256 colores   512 KBytes                  */
/*              102h   800x 600   16 colores   256 Kbytes                  */
/*              103h   800x 600  256 colores   512 Kbytes                  */
/*              104h  1024x 768   16 colores   512 Kbytes                  */
/*              105h  1024x 768  256 colores     1 Mbytes                  */
/*              106h  1280x1024   16 colores     1 Mbytes                  */
/*              107h  1280x1024  256 colores  1.25 Mbytes                  */
/*              6Ah    800x 600   16 colores   256 KBytes                  */
/*            (los valores de memoria se refieren a las capacidades posi-  */
/*             bles de 256, 512 o 1024 KB y no a la memoria que necesita   */
/*             efectivamente para una pgina de pantalla.)                 */
/***************************************************************************/

void CalcularDesplazaV(int modo);
/***************************************************************************/
/* ENTRADA:  Un entero que especifica un modo de video VESA.               */
/* SALIDA:   ---                                                           */
/* EFECTO:   La variable local del mdulo 'desplazaV' se actualiza tomando */
/*           el valor del desplazamiento que es necesario hacer para que   */
/*           la ventana de aceso a la RAM de video se mueva 64K que es el  */
/*           tamao de dicha memria. Se usa slo dentro del mdulo.       */
/* REQUIERE: ---                                                           */
/* NOTAS:    Este valor depende de la granularidad de la ventana. As, si  */
/*           la granularidad es grande (p.ej. 64K) el desplazamiento de la */
/*           ventana ser pequeo (1 undad). Si es pequea (p.ej. 4K) ste */
/*           ser grande (16 unidades).                                    */
/*           La granularidad de la ventana de acceso a RAM video varia para*/
/*           diferentes tarjetas SVGA.                                     */
/*           El modo de video se especifica para hacer una llamada a la    */
/*           funcin 'LeerModoVesa' que nos devuelve una tabla en la cual  */
/*           aparece la granularidad de la ventana (ver LeerModoVesa).     */
/*            Porque es necesario desplazar la ventana de acceso a video ?*/
/*           Pues, sencillamente, porque la memoria de un modo VESA es     */
/*           superior a 64K y si la ventana no se desplazara solo se podria*/
/*           visualizar la parte de la pantalla total correspondiente a los*/
/*           primeros 64k (p.ej. en 640x480 256 colores, las 102.4 primeras*/
/*           lneas de pantalla).                                          */
/*           'desplazaV' se puede usar como variable externa en mdulos de */
/*           de interaccin directa con la pantalla (pantallas virtuales). */
/***************************************************************************/

char Modo640400256(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   0 si el modo no se encuentra disponible.                      */
/*           1 si el modo se encuentra disponible.                         */
/* EFECTO:   Se establece el modo grfico de 640x400 pixels y 256 colores. */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

char Modo640480256(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   0 si el modo no se encuentra disponible.                      */
/*           1 si el modo se encuentra disponible.                         */
/* EFECTO:   Se establece el modo grfico de 640x480 pixels y 256 colores. */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

#endif;