/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: MEMORIA.H                                        */
/*  DESCRIPCION:        Definicin de procedimientos y funciones para    */
/*                      el manejo de memoria RAM.                        */
/*  CONTENIDO:          .unsigned long RAMLibre(void).                   */
/*                      .char ExisteXMS(void).                           */
/*                      .void far* FarCallXMS(void).                     */
/*                      .void ObtenerXMSLibre(unsigd int*, unsigd int*). */
/*                      .char ReservarXMS(unsigned int*, unsigned int).  */
/*                      .char LiberarXMS(unsigned int).                  */
/*                      .CopiarXMS(unsigned int, void far*,              */
/*                                 unsigned int, void far*, unsigd int). */
/*                                                                       */
/*  LLAMADO POR:        MEMORIA.CPP: Implementacin.                     */
/*  LLAMA A:            DOS.H: Funciones y macros para manejo de seg-    */
/*                             mentos de memoria. MK_FP(Seg,Off).        */
/*                      ALLOC.H: Manejo dinmico de memoria. Coreleft(). */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*                                                                       */
/*  NOTAS: Respecto a los mdulos a los que se llama: el comentario aa- */
/*         dido tras el nombre de estos corresponde a las principales    */
/*         funciones que se toman de estos ficheros, y no a todas las    */
/*         que ofrecen (muchas ms).                                     */
/*         Se proporcionan procedimientos para manejo de memoria XMS.    */
/*         XMS : Extended Memory Specification.                          */
/*  */
/***************************************************************************/
#include <dos.h>
#include <alloc.h>

unsigned long int RAMLibre(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   Nmero de bytes libres que quedan en el Heap.                 */
/* EFECTO:   ---                                                           */
/* REQUIERE: ---                                                           */
/* NOTAS:    El heap (montn) es la zona de memoria dinmica que usa el    */
/*           programa para alojar todos aquellos objetos que se han creado */
/*           de forma dinmica (new). Generalmente ser la zona de memria */
/*           RAM convencional ms extensa, y por tanto con esta funcin se */
/*           puede aproximar la cantidad de sta que queda libre.          */
/***************************************************************************/

char ExisteXMS(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   0 si no existe memria XMS o no hay controlador HIMEN.SYS.    */
/*           1 si el acceso a XMS es posible.                              */
/* EFECTO:   ---                                                           */
/* REQUIERE: ---                                                           */
/* NOTAS:    ---                                                           */
/***************************************************************************/

void far* FarCallXMS(void);
/***************************************************************************/
/* ENTRADA:  ---                                                           */
/* SALIDA:   Una direccin de memria que apunta a la rutina controladora  */
/*           XMS.                                                          */
/* EFECTO:   ---                                                           */
/* REQUIERE: ---                                                           */
/* NOTAS:    Las funciones del estndar XMS no se llaman mediante una in-  */
/*           terrupcin especial; la llamada se realiza con la ayuda de una*/
/*           instruccin FAR-CALL (llamada lejana) de la que primero hay   */
/*           que averiguar la direccin de entrada.                        */
/***************************************************************************/

void ObtenerXMSLibre(unsigned int *Total, unsigned int *MaxBloque);
/***************************************************************************/
/* ENTRADA:  Dos punteros a enteros positivos.                             */
/* SALIDA:   ---                                                           */
/* EFECTO:   'Total' toma el nmero de Kbytes libres en la XMS. 'MaxBloque'*/
/*           toma el nmero de Kbytes del mayor bloque de memria XMS.     */
/* REQUIERE: Que se haya comprobado la existencia de la rutina controladora*/
/*           XMS.                                                          */
/* NOTAS:    Las funciones del estndar XMS no se llaman mediante una in-  */
/*           terrupcin especial; la llamada se realiza con la ayuda de una*/
/*           instruccin FAR-CALL (llamada lejana) de la que primero hay   */
/*           que averiguar la direccin de entrada.                        */
/***************************************************************************/

char ReservarXMS(unsigned int *Handle, unsigned int SizeKBytes);
/***************************************************************************/
/* ENTRADA:  Un puntero a un entero positivo 'Handle' y un entero positivo */
/*           'SizeKBytes'.                                                 */
/* SALIDA:   0 si se ha producido un error o falta de memoria disponible.  */
/*           1 si se ha reservado memoria XMS. Exito.                      */
/* EFECTO:   'Handle' toma el valor del handle de acceso al bloque pedido, */
/*           que tendr un tamao de 'SizeBytes'.                          */
/* REQUIERE: Que se haya comprobado la existencia de la rutina controladora*/
/*           XMS.                                                          */
/* NOTAS:    Las funciones del estndar XMS no se llaman mediante una in-  */
/*           terrupcin especial; la llamada se realiza con la ayuda de una*/
/*           instruccin FAR-CALL (llamada lejana) de la que primero hay   */
/*           que averiguar la direccin de entrada.                        */
/*           Si la memria pedida es mayor que el mximo bloque libre se   */
/*           devuelve 0, aunque la cantidad total de XMS sea mayor.        */
/*           Antes de la finalizacin del programa es necesario liberar la */
/*           memria retenida por esta funcin.                            */
/*           El handle debe ser guardado en el programa para no perder el  */
/*           acceso al bloque retenido, y para poder liberarlo.            */
/***************************************************************************/

char LiberarXMS(unsigned int Handle);
/***************************************************************************/
/* ENTRADA:  Un entero positivo 'Handle'.                                  */
/* SALIDA:   0 si se ha producido un error.                                */
/*           1 si se ha liberado el bloque XMS. Exito.                     */
/* EFECTO:   Se pierde la memria retenida por el handle 'Handle'.         */
/* REQUIERE: Que se haya comprobado la existencia de la rutina controladora*/
/*           XMS.                                                          */
/* NOTAS:    Las funciones del estndar XMS no se llaman mediante una in-  */
/*           terrupcin especial; la llamada se realiza con la ayuda de una*/
/*           instruccin FAR-CALL (llamada lejana) de la que primero hay   */
/*           que averiguar la direccin de entrada.                        */
/*           Para el correcto funcionamiento de aplicaciones siguientes es */
/*           necesario llamar a esta funcin todas la veces que sea necesa-*/
/*           rio con diferentes handles.                                   */
/***************************************************************************/

char CopiarXMS(unsigned int HandO, void far *OffO,
	       unsigned int HandD, void far *OffD, unsigned int SizeBytes);
/***************************************************************************/
/* ENTRADA:  Un entero positivo 'HandO' (handle origen), un puntero lejano */
/*           'OffO' (offset origen), un entero positivo 'HandD' (handle    */
/*           destino), un puntero lejano 'OffD' (offset destino), y otro   */
/*           entero positivo 'SizeBytes'.                                  */
/* SALIDA:   0 si se ha producido un error. Copia no vlida.               */
/*           1 si se ha realizado la copia con exito.                      */
/* EFECTO:   Se realiza una copia de tamao 'SizeBytes' de la direccin    */
/*           origen (HandO, OffO) a la destino (HandD, OffD).              */
/* REQUIERE: Que se haya comprobado la existencia de la rutina controladora*/
/*           XMS.                                                          */
/*           El valor de 'SizeBytes' debe ser par.
/* NOTAS:    Las funciones del estndar XMS no se llaman mediante una in-  */
/*           terrupcin especial; la llamada se realiza con la ayuda de una*/
/*           instruccin FAR-CALL (llamada lejana) de la que primero hay   */
/*           que averiguar la direccin de entrada.                        */
/*           La copia se puede realizar entre RAM - XMS. Para direccionar  */
/*           en RAM basta con considerar Handle = 0  y                     */
/*                                       OffO = segmento + offset          */
/*           en el formato aconstumbrado (1 offset, 2 segmento).         */
/*           Se realizar una copia rpida si se direcciona de forma par.  */
/***************************************************************************/
