/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: MEMORIA.CPP                                      */
/*  DESCRIPCION:        Implementacin de procedimientos y funciones     */
/*                      para el manejo de memoria RAM.                   */
/*  CONTENIDO:          ---                                              */
/*  LLAMADO POR:        ---                                              */
/*  LLAMA A:            MEMORIA.H : Fichero cabecera. Definiciones.      */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*  */
/***************************************************************************/
#include "memoria.h"

/***************************************************************************/
/*  FUNCIONES PARA MANEJO DE MEMORIA R.A.M.                                */
/***************************************************************************/
unsigned long int RAMLibre(void){
   return(coreleft());
};
/***************************************************************************/
/*  FUNCIONES PARA MANEJO DE MEMORIA X.M.S.                                */
/***************************************************************************/
char ExisteXMS(void){

   asm{ mov AH, 43h       //AH <-- 43h
	mov AL, 00h       //AL <-- 00h
	int 2Fh           //Interrupcin 2Fh
	cmp AL, 80h       //Compara [AL] con 80h
	jne Negativo      //Si no son iguales bifurca a Negativo.
   };
   return(1);             //Existe el controlador HIMEN.SYS
   Negativo: return(0);   //No existe HIMEN.SYS, acceso a XMS no disponible.
};
/***************************************************************************/
void far* FarCallXMS(void){
   unsigned int SGM, OFF;
   void far *Direccion;

   asm{ mov AH, 43h            //AH <-- 43h
	mov AL, 10h            //AL <-- 10h
	int 2Fh                //Interrupcin 2Fh
	mov SGM, ES            //SGM <-- [ES]
	mov OFF, BX            //OFF <-- [BX]
   };
   Direccion = MK_FP(SGM,OFF); //Direccion <-- SGM:OFF
   return(Direccion);          //Devolver Direccion
};
/***************************************************************************/
void ObtenerXMSLibre(unsigned int *Total, unsigned int *MaxBloque){
   unsigned int T,M;
   void far *Dir;

   Dir=FarCallXMS();         //Dir toma la direccin de la funcin XMS
   asm{ mov AH, 08h          //AH <-- 08h
	call Dir             //Llamada a rutina con comienzo en Dir
	mov T, DX            //T <-- DX
	mov M, AX            //M <-- AX
   };
   *Total=T;                 //Devolver las variables temporales
   *MaxBloque=M;
};
/***************************************************************************/
char ReservarXMS(unsigned int *Handle, unsigned int SizeKBytes){
   unsigned int Hand;
   unsigned int KBytes;
   void far *Dir;
   unsigned char error;

   KBytes = SizeKBytes;
   Dir=FarCallXMS();         //Dir toma la direccin de la funcin XMS
   asm{ mov AH, 09h          //AH <-- 09h
	mov DX, KBytes       //DX <-- KBytes o tamao del bloque requerido
	call Dir             //Llamada a rutina con comienzo en Dir
	mov Hand, DX         //Hand <-- DX
	cmp AX, 0001h        //Compara [AX] con 0001h
	je Correcto          //Si son iguales, OK! bifurcar a Correcto
	mov error, BL        //si no lo son, obtener el error
   };
   *Handle=0;                //Devolver el Handle a cero
   return(error);            //Devolver el nmero de error
   Correcto: *Handle=Hand;   //Devolver el handle de la variable temporal
	     return(1);      //Devolver 1, OK!
};
/***************************************************************************/
char LiberarXMS(unsigned int Handle){
   unsigned int Hand;
   void far *Dir;
   unsigned char error;

   Hand = Handle;
   Dir=FarCallXMS();         //Dir toma la direccin de la funcin XMS
   asm{ mov AH, 0Ah          //AH <-- 0Ah
	mov DX, Hand         //DX <-- Hand.
	call Dir             //Llamada a rutina con comienzo en Dir
	cmp AX, 0001h        //Compara [AX] con 0001h
	je Correcto          //Si son iguales, OK! bifurcar a Correcto
	mov error, BL        //si no lo son, obtener el error
   };
   return(error);            //Devolver el nmero de error
   Correcto: return(1);      //Devolver 1, OK!
};
/***************************************************************************/
char CopiarXMS(unsigned int HandO, void far *OffO,
	       unsigned int HandD, void far *OffD, unsigned int SizeBytes){
   char error;
   void far *Dir;
   struct{
      unsigned long int Bytes;
      unsigned int HO;
      void far *OO;
      unsigned int HD;
      void far *OD;
   } tabla, *P;

   Dir = FarCallXMS();           //Dir toma la direccin de la funcin XMS
   tabla.Bytes = SizeBytes;
   tabla.HO = HandO;
   tabla.OO = OffO;
   tabla.HD = HandD;
   tabla.OD = OffD;
   P = &tabla;
   asm{ push DS
	mov AH, 0Bh              //AH <-- 0Bh
	lds SI, P                //DS:SI <-- tabla
	call Dir                 //Llamada a rutina con comienzo en Dir
	pop DS
	cmp AX, 0001h            //Compara [AX] con 0001h
	je Correcto              //Si son iguales, OK! bifurcar a Correcto
	mov error, BL            //si no lo son, obtener el error
   };
   return(error);                //Devolver el nmero de error
   Correcto: return(1);          //Devolver 1, OK!
};
/***************************************************************************/
/* ATENCION!!, TODA LA DOCUMENTACION EN EL FICHERO CABECERA  MEMORIA.H   */
/***************************************************************************/
/* F I N *******************************************************************/