/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: IMAGEN.CPP                                       */
/*  DESCRIPCION:        Implementacin de mtodos de las clases creadas  */
/*                      para manejo y representacin de imagenes.        */
/*  CONTENIDO:          .mtodos de la clase imagen256.                  */
/*                      .mtodos de la clase multiImagen256.             */
/*                                                                       */
/*  LLAMADO POR:        ---                                              */
/*  LLAMA A:            IMAGEN.H : Fichero cabecera. Definiciones.       */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*  */
/***************************************************************************/
#include "imagen.h"

/***************************************************************************/
/*   CLASE IMAGEN256: IMPLEMENTACION DE METODOS                            */
/***************************************************************************/
imagen256::imagen256(void){
   imagen = NULL;
   ancho = 0;
   alto = 0;
   handle = 0;
};
/***************************************************************************/
char imagen256::inicializar(int anchura, int altura){
   int i;
   char far *result;

   handle = 0;
   ancho = anchura;
   alto = altura;
   imagen = new char* [alto];

   for (i=0; i<alto; i++) imagen[i] = result = new char[ancho];
   if(result) return(1);
   else return(0);
};
/***************************************************************************/
char imagen256::cargarImg(char far *fichero){
   int etiqueta;
   int i;
   int result;

   etiqueta=_open(fichero,O_BINARY);
   if(etiqueta>=0){
      for(i=0; i<alto; i++) result=_read(etiqueta,imagen[i],ancho);
      _close(etiqueta);
      if(result<=0) return(0);
      return(1);
   };
   return(-1);
};
/***************************************************************************/
char imagen256::salvarImg(char far *fichero){
   int etiqueta;
   int i;
   int result;

   etiqueta=_creat(fichero,O_BINARY);
   if(etiqueta>=0){
      for(i=0; i<alto; i++) result=_write(etiqueta,imagen[i],ancho);
      _close(etiqueta);
      if(result<0) return(0);
      return(1);
   };
   return(-1);
};
/***************************************************************************/
void imagen256::cls(char color){
   int i,j;
   char far *fila;

   for(i=0; i<alto; i++){
      fila = imagen[i];
      for(j=0; j<ancho; j++) fila[j]=color;
   };
};
/***************************************************************************/
void imagen256::darDimensiones(int *anchura, int *altura){

   *anchura=ancho;
   *altura=alto;
};
/***************************************************************************/
char imagen256::getPixel(int x, int y){
   char aux;
   char far *fila;

   fila = imagen[(y%alto)];
   aux = fila[(x%ancho)];
   return(aux);
};
/***************************************************************************/
void imagen256::putPixel(int x, int y, char color){
   char aux;
   char far *fila;

   fila = imagen[(y%alto)];
   fila[(x%ancho)]=color;
};
/***************************************************************************/
char imagen256::ubicarEnXMS(void){
   int i;                       //Contador.
   void far *destino;           //Offset destino en el EMB de la XMS.
   double a,b;                  //Ancho y alto en decimales.
   unsigned int KBytes;         //Nmero de Kb a transferir.
   char impar;                  //Paridad del ancho de la imagen.

   a=ancho; b=alto;

   i=(a/2);                                //Calculo de la paridad del ancho.
   if(i<(a/2)) impar=1;                    //( nmero de Kb a transferir
   else impar=0;                           //  debe ser par ).

   KBytes=(((a+impar)*b)/1024);               //Cculo del nmero de KBytes a
   if(KBytes<(((a+impar)*b)/1024)) KBytes++;  //reservar en el EMB.

   if(ReservarXMS(&handle,KBytes)==1){
      for(i=0; i<alto; i++){
	destino=(void far*)((unsigned(ancho)+impar)*i);
	if(CopiarXMS(0,imagen[i],handle,destino,unsigned(ancho+impar)) != 1)
	   return(-1);
      };
      for(i=0;i<alto;i++) delete imagen[i];
      delete imagen;
      return(1);
   };
   return(0);
};
/***************************************************************************/
char imagen256::ubicarEnRAM(void){
   void far *origen;
   char far *result;
   double a;
   int i;
   char impar;

   a=ancho;
   i=(a/2);
   if(i<(a/2)) impar=1;
   else impar=0;

   imagen = new char* [alto];
   for(i=0; i<alto; i++) imagen[i] = result = new char[(ancho+impar)];
   if(result){
      for(i=0; i<alto; i++){
	 origen=(void far*)(unsigned(ancho+impar)*i);
	 if(CopiarXMS(handle,origen,0,imagen[i],unsigned(ancho+impar)) != 1)
	    return(-1);
      };
      LiberarXMS(handle);
      handle=0;
      return(1);
   };
   return(0);
};
/***************************************************************************/
char imagen256::enXMS(void){
   if(!handle) return(0);    //Imagen ubicada en RAM convencional.
   else return(1);           //Imagen ubicada en XMS (M. extendida).
};
/***************************************************************************/
void imagen256::borrar(void){
   int i;

   if(!handle){ for(i=0;i<alto;i++) delete imagen[i];
		delete imagen;
   }
   else{ LiberarXMS(handle);
	 handle = 0;
   };
   ancho=0;
   alto=0;
};
/***************************************************************************/
imagen256::~imagen256(void){
   int i;

   if(!handle){ for(i=0;i<alto;i++) delete imagen[i];
		delete imagen;
   }
   else LiberarXMS(handle);
};
/***************************************************************************/
imagen256& imagen256::operator=(const imagen256 &A){
   int X,Y;
   int i;

   if(imagen != A.imagen){
      borrar();
      A.darDimensiones(&X,&Y);
      if(inicializar(X,Y))
	      for(i=0; i<Y; i++) memcpy(imagen[i],A.imagen[i],X);
   };
   return(*this);
};

/***************************************************************************/
/*   CLASE MULTIIMAGEN256: IMPLEMENTACION DE METODOS.                      */
/***************************************************************************/
multiImagen256::multiImagen256(void){

   Multi = NULL;
   n = 0;
   nmax = 0;
   handle = 0;
};
/***************************************************************************/
void multiImagen256::inicializar(int numImag){

   Multi = new imagen256[numImag];
   nmax = numImag;
};
/***************************************************************************/
void multiImagen256::insertar(int pos, imagen256 *imag){
   int i;

   if((pos>=0)&(pos<nmax)){
      if(pos<n){ for(i=n; i>pos; i--) Multi[i] = Multi[i-1];
		 Multi[pos] = *imag;
      }
      else if(n<nmax) Multi[n] = *imag;
      if(n<nmax) n++;
   };
};
/***************************************************************************/
void multiImagen256::borrar(int pos){
   int i;

   if((pos>=0)&(pos<n)){
      for(i=pos; i<(n-1); i++) Multi[i] = Multi[i+1];
      Multi[n-1].borrar();
      if(n>0) n--;
   };
};
/***************************************************************************/
imagen256* multiImagen256::devolver(int pos){

   if((pos>=0)&(pos<n)) return(&Multi[pos]);
   else return(NULL);
};
/***************************************************************************/
char multiImagen256::cargarMig(char far *filename){
   FILE *fich;
   int result;
   int aux;
   unsigned int i;
   unsigned int ancho, alto;

   result=0;
   if((fich=fopen(filename, "rb"))!=NULL){
      if(nmax==0){                          //Si la multimagen no inicializ
	 if(!feof(fich)) nmax=getw(fich);   //se inicializa al n de imagenes
	 Multi = new imagen256[nmax];       //del fichero.
      }
      else if(!feof(fich)) getw(fich);      //Si no, saltar el nmero.
      while((n<nmax)&(!feof(fich))){
	 if(!feof(fich)) ancho=getw(fich);
	 if(!feof(fich)) alto=getw(fich);
	 Multi[n].inicializar(ancho,alto);
	 for(i=0; i<alto; i++)
	    if(!feof(fich)) fread(Multi[n].imagen[i],1,ancho,fich);
	 n++;
      };
      result=fclose(fich);
      if(result!=0) return(0);
      return(1);
   };
   return(-1);
};
/***************************************************************************/
char multiImagen256::salvarMig(char far *filename){
   FILE *fich;
   int result, num;
   unsigned int i;
   int ancho, alto;

   num=0;
   if((fich=fopen(filename, "wb"))!=NULL){
   putw(n,fich);
      while(num<n){
	 Multi[num].darDimensiones(&ancho,&alto);
	 putw(ancho,fich);
	 putw(alto,fich);
	 for(i=0; i<alto; i++){
	    if(!feof(fich)) fwrite(Multi[num].imagen[i],1,ancho,fich);
	 };
	 num++;
      };
      result=fclose(fich);
      if(result!=0) return(0);
      return(1);
   };
   return(-1);
};
/***************************************************************************/
int multiImagen256::darN(void){

   return(n);
};
/***************************************************************************/
void multiImagen256::
     darDimensiones(int pos, int *anchura, int *altura){

   if((pos>=0)&(pos<n)) Multi[pos].darDimensiones(anchura,altura);
   else{ *anchura = 0;
	 *altura = 0;
   };
};
/***************************************************************************/
char multiImagen256::ubicarEnXMS(void){
   int i, j;                    //Contadores.
   unsigned long destino;       //Offset destino en el EMB de la XMS.
   int far *ancho, *alto;
   unsigned int KBytes;         //Nmero de Kb a transferir.
   double a,b,aux;              //Ancho y alto en decimales.
   char far *impar;             //Array de paridad del ancho de cada imagen.

   impar = new char[n];
   ancho = new int[n];
   alto = new int[n];
   aux=0;
   for(i=0; i<n; i++){ Multi[i].darDimensiones(&ancho[i], &alto[i]);
		       a = ancho[i];
		       b = alto[i];
		       j=(a/2);
		       if(j<(a/2)) impar[i]=1;
		       else impar[i]=0;
		       aux=aux+(((a+impar[i])*b)/1024);
   };
   KBytes=aux;
   if(KBytes<aux) KBytes++;

   if(ReservarXMS(&handle,KBytes)==1){
      destino=0;
      for(i=0; i<n; i++){
	 for(j=0; j<alto[i]; j++){
	   if(CopiarXMS(0,Multi[i].imagen[j], handle,(void far*)destino,
			unsigned(ancho[i]+impar[i])) != 1){
	       delete ancho; delete alto; delete impar;
	       return(-1);
	   };
	   destino = destino + unsigned(ancho[i]+impar[i]);
	   delete Multi[i].imagen[j];
	 };
	 delete Multi[i].imagen;
      };
      delete ancho; delete alto; delete impar;
      return(1);
   };
   delete ancho; delete alto; delete impar;
   return(0);
};
/***************************************************************************/
char multiImagen256::ubicarEnRAM(void){
   int i, j;                    //Contadores.
   char far *result;
   unsigned long origen;        //Offset origen en el EMB de la XMS.
   int far *ancho, *alto;
   double a;                    //Ancho en decimales.
   char far *impar;             //Array de paridad del ancho de cada imagen.

   impar = new char[n];
   ancho = new int[n];
   alto = new int[n];
   for(i=0; i<n; i++){
      Multi[i].darDimensiones(&ancho[i], &alto[i]);
      a=ancho[i];
      j=(a/2);
      if(j<(a/2)) impar[i]=1;
      else impar[i]=0;
      Multi[i].imagen = new char* [alto[i]];
      for(j=0; j<alto[i]; j++)
	 Multi[i].imagen[j] = result = new char[(ancho[i]+impar[i])];
   };

   if(result){
      origen=0;
      for(i=0; i<n; i++){
	 for(j=0; j<alto[i]; j++){
	   if(CopiarXMS(handle,(void far*)origen, 0,Multi[i].imagen[j],
			unsigned(ancho[i]+impar[i])) != 1){
	       delete ancho; delete alto; delete impar;
	       return(-1);
	   };
	   origen = origen + unsigned(ancho[i]+impar[i]);
	 };
      };
      LiberarXMS(handle);
      handle=0;
      delete ancho; delete alto; delete impar;
      return(1);
   };
   delete ancho; delete alto; delete impar;
   return(0);
};
/***************************************************************************/
char multiImagen256::enXMS(void){

   if(!handle) return(0);
   return(1);
};
/***************************************************************************/
multiImagen256::~multiImagen256(void){
   int i;

   if(!handle){ for(i=n-1; i>=0; i--) Multi[i].borrar();
		delete Multi;
   }
   else LiberarXMS(handle);
};