/*
  Ejemplo de reproduccin de ficheros VOC, WAV, etc.
  Versin 2, que enva las muestras al DAC de la SB por DMA.
  Por Luis Crespo, FidoNet 2:343/108.21, Internet d8089110@est.fib.upc.es
*/

#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include <mem.h>

#include "sb.h"
#include "dac.h"
#include "speaker.h"

#define FALSE 0
#define TRUE  1


unsigned Tamanyo;       /* Tamao del VOC en memoria */
char     *pVoc,         /* Puntero al VOC */
         *pBufDMA,      /* Puntero al buffer */
         *pBufTotDMA;   /* Puntero al buffer total */
unsigned VocPos;        /* Posicin actual del VOC */
char     FinVoz,
         PrimeraMitad,
         HaySB;
unsigned Frec = 11000,  /* Frecuencia de muestreo */
         BufSize = 512; /* Tamao del buffer de DMA */



int TeclaPulsada()
/* Esta funcin mira si se ha pulsado una tecla pero SIN llamadas a la BIOS,
 de forma que no se inhabilitan las interrupciones en cada llamada, cosa
 que bajara mucho la calidad de reproduccin con el altavoz interno. */
{
  return( *(unsigned *) MK_FP(0x40,0x1A) != *(unsigned *) MK_FP(0x40,0x1C) );
}

void CargaVoc(char *Nombre)
/* Carga el fichero "Nombre" a partir del puntero "pVoc" */
{
  FILE *Fichero;
  char Cabecera[32];

  Fichero = fopen(Nombre,"rb");
  fread(Cabecera,32,1,Fichero);    /* Leemos (y descartamos) la cabecera */
  Tamanyo = filelength(fileno(Fichero))-32;
  pVoc = malloc(Tamanyo);               /* Reservamos memoria */
  fread(pVoc,Tamanyo,1,Fichero);        /* Leemos los datos */
  fclose(Fichero);
}

void ShowConfig()
/* Muestra la configuracin de la Sound Blaster */
{
  if (HaySB)
  {
    printf("\nSound Blaster detectada.\n");
    printf("Puerto Base:     %Xh\n",SBBase);
    printf("Versin del DSP: %d.%02d\n",DSPVerMajor,DSPVerMinor);
    printf("IRQ:             %d\n",SBIRQ);
    printf("DMA de 8 bits:   %d\n",SB8DMA);
    if (DSPVerMajor>=4) printf("DMA de 16 bits:  %d\n",SB16DMA);
  }
  else printf("\nSound Blaster no detectada\n");
  printf("\n");
}

void ReservaBufferDMA(unsigned Size)
/* Reserva un buffer para transferencia de DMA, controlando que no haya
solapamiento de pginas. */
{
  unsigned char PagIni,PagDest;
  unsigned long DirFisIni,DirFisDest;
  /* Direccin fsica de inicio y final del buffer de DMA, respectivamente */

  pBufTotDMA = malloc(Size*2);
  pBufDMA = pBufTotDMA;
  DirFisIni = (unsigned long)FP_SEG(pBufDMA) << 4 + FP_OFF(pBufDMA);
  DirFisDest = DirFisIni+Size;
  PagIni = DirFisIni >> 16;
  PagDest = DirFisDest >> 16;
  if (PagIni!=PagDest) pBufDMA = pBufDMA+Size;
  /* Si hay solapamiento en la primera mitad, se toma la segunda */
}

void NextBuffer()
/* Esta rutina es llamada cada vez que se recorre medio buffer, y se
encarga de actualizar el buffer de DMA */
{
  memcpy(pBufDMA,pVoc+VocPos,BufSize);
  if (VocPos>Tamanyo) FinVoz=TRUE;
  VocPos = VocPos+BufSize;
  if (PrimeraMitad) pBufDMA=pBufDMA+BufSize; else pBufDMA=pBufDMA-BufSize;
  PrimeraMitad=!PrimeraMitad;
}


int main(int argc, char *argv[])
{
  if (argc<2)
  {
    printf("Error: falta parmetro necesario.\n");
    return(1);
  }
  HaySB = SBDetect();
  ShowConfig();
  CargaVoc(argv[1]);
  ReservaBufferDMA(BufSize*2);
  FinVoz = FALSE;
  VocPos = 0;
  PrimeraMitad = TRUE;
  memset(pBufDMA,128,BufSize*2);
  if (HaySB)
  {
    SBPlayBuf(pBufDMA,BufSize,&Frec,NextBuffer);
    do; while (!FinVoz && !TeclaPulsada());
    SBStopBuf();
  }
  else {
    /* Si se tiene un DAC casero, cambiar SpkPlayBuf por DACPlayBuf,
    y SpkStopBuf por DACStopBuf */
    SpkPlayBuf(pBufDMA,BufSize,&Frec,NextBuffer);
    do; while (!FinVoz && !TeclaPulsada());
    SpkStopBuf();
  }
  free(pBufTotDMA);
  free(pVoc);
  return(0);
}
