{ ------------------------------------------------------------------------ }
{ ------------------------------- U_LLUVIA ------------------------------- }
{ --------------- Hace un "efectillo" de lluvia en 320x200 --------------- }
{ ----------------------------- Braulio Dez ----------------------------- }
{ ----------------------------- Avalon  Soft ----------------------------- }
{ -------------------- Miembro de Cosmos Programacin -------------------- }
{ -------------------- Miembro del Club Virtual Zone --------------------- }
{ -> Utiliza est librera como quieras, ... y si le metes alguna mejora - }
{ ---> acuerdate de mi y psamela... :- )--------------------------------- }
{ ------------------------------------------------------------------------ }

unit u_lluvia;
INTERFACE
uses graf256,u_tiempo;

type

  t_lluvia=object
    inicio_x,inicio_y,tope_x,tope_y:integer; { Aqu guardamos la zona en }
    { la que queremos meter la lluvia, si es a pantalla completa, ser }
    { 0,0,319,199}

    direccion:integer; { direccin hacia la que queremos que vaya la lluvia }
    { 3,2,1,0,-1,-2,-3 -> Derecha (3,2,1),sin viento (0),izda (-1,-2,-3) }

    intensidad:integer; { Nmero de gotas de lluvia, cuantas ms -> lluvia }
    { ms fuerte }
    color:byte; { color de las gotas de agua }

    longitud_gota:byte; { 1..3 }

    tiempo:t_tiempo_ex; { ... Para los Fade in y out ( nos mide el }
    { tiempo en centsimas) }

  { //---- Ahora viene la definicin de mtodos }
    procedure inicia_lluvia (vinicio_x,vinicio_y,vtope_x,vtope_y:integer);
    { //-- ... Inicializamos el recuadro de la pantallas }
    procedure cambia_color (vcolor:byte);
    { //-- Cambia el color de las gotas de agua }
    procedure cambia_direccion (vdireccion:integer);
    { //-- Cambia la direccin de la lluvia }
    procedure cambia_intensidad (vintensidad:byte);
    { // -- Cambia el nmero de gotas de lluvia }
    procedure cambia_longitud_gota (vlongitud_gota:byte);
    { // -- Cambia la longitud de las gotas }
    procedure fija_atributos (vdireccion:integer;vintensidad:integer;
    vlongitud_gota:byte);
    { //-- Para cambiar la direccin y la intensidad }
    { //-- Conviene ejecutarlos al principio despus de inicia_lluvia }
    function fadein (vtiempo:integer;n_gotas:integer):boolean;
    { //-- ... Para hacer que empieze a llover poco a poco, el tiempo }
    { est medido en centsimas de segundo }
    function fadeout (vtiempo:integer;n_gotas:integer):boolean;
    { //-- .. Para cuando deja de llover }
    procedure actualiza_lluvia;
    { //-- Para actualizar la lluvia en pantalla }
    function dame_intensidad:integer;
    { //-- Nos devuelve la intensidad de la lluvia (nmero de gotas) }
  end;

IMPLEMENTATION


procedure t_lluvia.inicia_lluvia (vinicio_x,vinicio_y,vtope_x,
   vtope_y:integer);

  begin
    randomize;
    color:=18;
    longitud_gota:=3;
    inicio_x:=vinicio_x;
    inicio_y:=vinicio_y;
    tope_x:=vtope_x;
    tope_y:=vtope_y;
    tiempo.inicia (0);
  end; { //-- Aqu termina inicia_lluvia }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.cambia_color (vcolor:byte);
  begin
  color:=vcolor;
  end; { //-- Aqu termina cambia_color }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.cambia_direccion (vdireccion:integer);
  begin
  direccion:=vdireccion;
  end; { //-- Aqu termina cambia_direccion }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.cambia_intensidad (vintensidad:byte);
  begin
  intensidad:=vintensidad;
  end; { //-- Aqu termina cambia_intensidad }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.cambia_longitud_gota (vlongitud_gota:byte);
  begin
  longitud_gota:=vlongitud_gota;
  end; { //-- Aqu termina cambia_longitud_gota }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.fija_atributos (vdireccion:integer;vintensidad:integer;
      vlongitud_gota:byte);
  begin
  cambia_direccion (vdireccion);
  cambia_intensidad (vintensidad);
  cambia_longitud_gota (vlongitud_gota);
  end;
{ ------------------------------------------------------------------------- }
function t_lluvia.fadein (vtiempo:integer;n_gotas:integer):boolean;

  begin
  fadein:=false;

  if tiempo.count_down=0 then
    begin
    tiempo.inicia (vtiempo);

    if intensidad<n_gotas then
      begin
      inc (intensidad);
      end
    else
      begin
      fadein:=true;
      end;

    end;
  end; { //-- Fin de t_lluvia.fadein }
{ ------------------------------------------------------------------------- }
function t_lluvia.fadeout (vtiempo:integer;n_gotas:integer):boolean;

  begin

  fadeout:=false;
  if tiempo.count_down=0 then
    begin
    tiempo.inicia (vtiempo);

    if intensidad>n_gotas then
      begin
      dec (intensidad);
      end
    else
      fadeout:=true;
    end;
  end; { //-- Fin de t_lluvia.fadeout }
{ ------------------------------------------------------------------------- }
procedure t_lluvia.actualiza_lluvia;
var
  conta:byte;
  px,py:integer;
  tpy:integer;


  begin
  tpy:=tope_y-longitud_gota;

  for conta:=1 to intensidad do
    begin
      repeat
        px:=random (tope_x);
        if px<inicio_x then
          px:=px+inicio_x;
      until (px<=tope_x) and (px>=inicio_x);

      repeat
        py:=random (tpy);
        if py<inicio_y then
          py:=py+inicio_y;
      until (py<=tope_y) and (py>=inicio_y);

      line (px,py,px+direccion,py+longitud_gota,color)
    end;
  end; { //-- Fin de actualiza_lluvia }
{ ------------------------------------------------------------------------- }
function t_lluvia.dame_intensidad:integer;
  begin
  dame_intensidad:=intensidad;
  end;
{ ------------------------------------------------------------------------- }
END.


{ ------------------------------------------------------------------------- }
{ ------------------------------ PUBLICIDAD ------------------------------- }
{ --> Si lo que te gusta es programar,  OYE !, este es tu fanzine: ------- }
{ ------------------------- Virtual Zone Magazine ------------------------- }
{ ------------------------- C/ Camino de Ronda 38, 1D -------------------- }
{ ------------------------- 18004 - Granada ------------------------------- }
{ ------------------------------------------------------------------------- }
