{$M 65000,0,580000}
program laberi;
  uses crt,graf256,pcx,u_bl_cut,bloques;

const

  indice=10; { Indice de la matriz }

  centrado_x=120; { Coordenadas que le sumamos al tablero y a los }
  centrado_y=60; { grafiquillos para que salgan centrados en pantalla }


type
  t_laber=array [1..indice,1..indice] of char;


var
  { ------------------- }
  fondo,movimi:pointer;
  d_fondo,d_movimi:word; { Variables usadas para grficos }
  { ------------------- }

  { ------------------- }
  laber:t_laber;
  libre:boolean; { Variables que se usan para el algoritmo del laberinto }
  { ------------------- }

{ ------------------------------------------------------------------------- }

procedure inicia_laber (var matriz:t_laber); { Aqu inicializamos la }
  begin { matriz del laberinto, cambiala a tu gusto }
    matriz [1]:='  XSX  XXX';  { 'X' -> Bloque }
    matriz [2]:=' XX X X   ';  { ' ' -> Camino }
    matriz [3]:='      X   ';  { 'I' -> Inicio del laberinto }
    matriz [4]:='XXXXX XX  ';  { 'S' -> Salida del laberinto }
    matriz [5]:='   X   X X';
    matriz [6]:='IX X XXX X';
    matriz [7]:=' X X   X  ';
    matriz [8]:='XX XXX XX ';
    matriz [9]:=' X     XX ';
   matriz [10]:=' X XX X   ';
  end; { //-- Fin de inicia_laber }

{ ------------------------------------------------------------------------ }


procedure pinta_laber (px,py:integer;var matriz:t_laber); { Nos pinta }
var { el laberinto en la pantalla }
  conta,conta2:byte;
  vpx,vpy:integer;

  begin

  for conta:=1 to indice do
    begin
    vpy:=py+((conta-1)*8);
    for conta2:=1 to indice do
      begin
      vpx:=px+((conta2-1)*8);
        case matriz [conta,conta2] of
          'X':
              pon_bloque (seto,vpx,vpy);
          'S':
              pon_bloque_t (meta,vpx,vpy,0);
          'I':
              pon_bloque_t (inicio,vpx,vpy,13);
        end;
      end;
    end;
  end;

{ ------------------------------------------------------------------------- }

procedure intentar_escapar (var matriz:t_laber;fila,col,intentos:byte;
   Var libre:boolean);


  procedure actualiza_panta;
    begin
    flip (d_fondo,d_movimi);
    setvgaout (movimi);
    pon_bloque_t (coco,((col*8)-8)+centrado_x,((fila*8)-8)+centrado_y,13);
    restorevgaout;
    flip (d_movimi,vga);
    waitvbl;
    delay (200); { ... Retraso para que no vaya demasiado rpido el  }
    { muecajo, cambialo a tu gusto }
    end;
 { ------------------------------------------------------------------ }

  begin
   
   if (matriz [fila,col]<>'X') and not libre then
   { Si pasamos libre por referencia podemos
      utilizarlo }
     begin
     actualiza_panta;
     if (matriz [fila,col]<>'*') then
       begin

         if matriz [fila,col]='S' then
            begin
            libre:=true
            end
         else
            begin
             inc (intentos);

             {gotoxy (col,fila);
             write ('');
             delay (150);
             gotoxy (col,fila);
             write (' ');}


             matriz [fila,col]:='*';
             if fila<indice then
               begin
               intentar_escapar (matriz,fila+1,col,intentos,libre);

               if not libre then
                  actualiza_panta;
               end;
             if fila>1 then
               begin
               intentar_escapar (matriz,fila-1,col,intentos,libre);

               if not libre then
                 actualiza_panta;
               end;

             if col<indice then
               begin
               intentar_escapar (matriz,fila,col+1,intentos,libre);
               if not libre then
                 actualiza_panta;
               end;
             if col>1 then
               begin
               intentar_escapar (matriz,fila,col-1,intentos,libre);
               if not libre then
                 actualiza_panta;
               end;

            end;
       end;
    end;
  end; { //-- Fin de intentar escapar }
{ ------------------------------------------------------------------------ }


procedure inicia_prog; { Inicializa variables, y dems cosillas para que }
  begin { pueda empezar el programilla }
  setvga256; { Ponernos en modo 320x200 256 colores }
  loadpcx256 ('paleta.pcx'); { Cargar un grfico PCX }
  inicia_laber (laber); { Inicializar la matriz del laberinto }
  pinta_laber (centrado_x,centrado_y,laber); { Pintarlo en pantalla }

  d_fondo:=reservescreen (fondo); { Guardar la pantalla en la pantalla }
  savescreen (fondo); { virtual fondo -> para poder restaurarlo }
  d_movimi:=reservescreen (movimi); { Inicializamos movimi }
  savescreen (movimi); { para poder usarlo }
  end;
{ ------------------------------------------------------------------------- }

begin
  inicia_prog;

  intentar_escapar (laber,6,1,0,libre);
  repeat until keypressed;
  modotexto;
  if not libre then
    begin
    writeln ('No he encontrado salida maki...');
    end;
end.