unit audio;

interface
var volumen:boolean;
    irq_capturada:boolean;
procedure activa_retardo;
procedure espera_retardo;
procedure volumen_on;
procedure volumen_off;
procedure carga_sonido(posi:integer;s:string;prioridad:word);
procedure descarga_sonido(posi:integer);
procedure obten_dir_IRQ(irq:byte;var direccion:pointer);
procedure set_dir_IRQ(irq:byte; direccion:pointer);
procedure activa_irq_sonido;
procedure desactiva_irq_sonido;
procedure ejecuta_sonido(sonido:word);
function  sonando:boolean;


implementation
const
  rep=2;
  frecuencia:word=10989*rep;
var
  irq_reloj:pointer;
  dir_sonido:pointer;
  prioridad_sonido:integer;
  cuenta:byte;
  quedan,conta_retardo:word;
  amplitud:array[0..255] of byte;
  a:byte;
  repite:byte;
  sonidos:array[1..20] of record
                       prioridad:integer;
                       direccion:pointer;
                       tamano:word;
                       end;

procedure activa_retardo; assembler;
        asm
        mov     ax,0
        mov     conta_retardo,ax
        end;

procedure espera_retardo; assembler;
        asm
@espera:mov     ax,conta_retardo
        cmp     ax,880
        jbe     @espera
        end;

procedure volumen_on; assembler;
        asm
        mov     al,1
        mov     volumen,al
        end;

procedure volumen_off; assembler;
        asm
        mov     al,0
        mov     volumen,al
        mov     ax,0
        mov     quedan,ax
        end;

procedure irq_sonido; interrupt; assembler;
        asm
        cli
        push    ax
        mov     ax,conta_retardo
        inc     ax
        mov     conta_retardo,ax
        mov     ax,quedan
        cmp     ax,0
        je      @fin_irq
        push    es
        push    ds
        push    bx
        mov     ax,quedan
        cmp     ax,0
        je      @fin_irq
        mov     al,10010000b
        out     43h,al
        in      al,61h
        or      al,00000011b
        out     61h,al

        mov     es,word ptr dir_sonido+2
        mov     bx,word ptr dir_sonido+0
        mov     al,byte ptr es:[bx]
        mov     bx,seg(amplitud)
        mov     ds,bx
        mov     bx,offset(amplitud)
        xlat
        out     42h,al

        mov     al,repite
        inc     al
        mov     repite,al
        cmp     al,rep
        jne     @fin_irq1
        mov     al,0
        mov     repite,al
        mov     ax,quedan
        dec     ax
        mov     quedan,ax
        mov     bx,word ptr dir_sonido+0
        inc     bx
        mov     word ptr dir_sonido,bx
@fin_irq1:
        pop     bx
        pop     ds
        pop     es
@fin_irq:
        mov     al,20h
        out     20h,al
        pop     ax
        sti
        end;


procedure carga_sonido(posi:integer;s:string;prioridad:word);
var f:file;
    t:word;
    t1:longint;
begin
 if sonidos[posi].direccion<>nil then
   begin
   freemem(sonidos[posi].direccion,sonidos[posi].tamano);
   sonidos[posi].direccion:=nil;
   end;
 assign(f,s);
 reset(f,1);
 t1:=filesize(f)-19;
 if t1<=65500 then
  t:=t1
 else
  t:=65500;
 seek(f,19);
 getmem(sonidos[posi].direccion,t);
 blockread(f,sonidos[posi].direccion^,t);
 close(f);
 sonidos[posi].tamano:=t;
 sonidos[posi].prioridad:=prioridad;
end;

procedure descarga_sonido(posi:integer);
begin
 if sonidos[posi].direccion<>nil then
   begin
   freemem(sonidos[posi].direccion,sonidos[posi].tamano);
   sonidos[posi].direccion:=nil;
   end;
end;

function sonando:boolean; assembler;
        asm
        mov     al,0
        mov     bx,quedan;
        cmp     bx,0
        je      @fin
        mov     al,1
@fin:
        end;

procedure ejecuta_sonido(sonido:word);
begin
 if ((quedan=0) or (sonidos[sonido].prioridad<=prioridad_sonido)) and volumen then
  begin
  asm cli end;
  prioridad_sonido:=sonidos[sonido].prioridad;
  dir_sonido:=sonidos[sonido].direccion;
  quedan:=sonidos[sonido].tamano;
  end;
  asm sti end;
end;

procedure obten_dir_IRQ(irq:byte;var direccion:pointer); assembler;
        asm
        mov     al,irq
        mov     ah,35h
        int     21h
        push    es
        les     di,direccion
        mov     es:[di+0],bx
        pop     bx
        mov     es:[di+2],bx
        end;

procedure set_dir_IRQ(irq:byte; direccion:pointer); assembler;
        asm
        push    ds
        mov     dx,word ptr direccion+0
        mov     ds,word ptr direccion+2
        mov     al,irq
        mov     ah,25h
        int     21h
        pop     ds
        end;

procedure activa_irq_sonido;
 begin
 if irq_capturada=false then
   begin
   irq_capturada:=true;
   obten_dir_irq(8,irq_reloj);
   set_dir_irq(8,@irq_sonido);
          asm
          mov     al,00011110b
          out     43h,al
          mov     al,cuenta
          out     40h,al
          end;
   end;
 end;

procedure desactiva_irq_sonido;
 begin
 if irq_capturada=true then
   begin
   irq_capturada:=false;
        asm
        mov     al,00111110b
        out     43h,al
        mov     al,0
        out     40h,al
        out     40h,al
        in      al,61h
        and     al,11111100b
        out     61h,al
        end;
   set_dir_irq(8,irq_reloj);
   irq_reloj:=nil;
   end;
 end;

begin
 irq_reloj:=nil;
 irq_capturada:=false;
 cuenta:=Round(1193180/frecuencia);
 for a:=0 to 255 do
  amplitud[a]:=trunc(a*cuenta/256)+1;
 quedan:=0;
 prioridad_sonido:=255; { La prioridad mas baja }
 for a:=1 to 20 do
  sonidos[a].direccion:=nil;
 repite:=0;
 volumen:=true;
end.