{ Pasos a realizar para la deteccion de la SB:
  1.- Escribir el valor 01h en el puerto 2x6h, que es el puerto de
      reseteo de la SB.
      1.-b Para ello debemos escribir el valor ( En este caso 01h ) en
      el registro AL, y en el registro DX debemos escribir el puerto al
      que queremos acceder. Este paso se realizar siempre que se
      quiera escribir en un puerto y cuando deseemos leer un puerto
      en cuyo caso en AL se leera el valor que contiene el puerto en
      ese momento y en DX especificaremos el puerto a leer.

  2.- Esperar 3,3 milisegundos.

  3.- Escribir el byte 00h en el puerto 2x6h de la SB.
      Realizaremos los mismos pasos descritos en 1.-b

  4.- Leer el puerto 2xAh, en cien ocasiones, hasta que obtengamos
      el valor 0AAh. Para ello hay que realizar 2 operaciones:
         a) Leer el puerto 2xE hasta que el 7 bit est a cero.
         b) Leer el puerto 2xA.
}

PROGRAM DETECTOR_SB;
uses crt;
CONST
     { DESPLAZAMIENTOS CON RESPECTO AL PUERTO BASE DE LA SB }
     Puerto_reseteo_SB=6;
     Puerto_estado_lectura_DSP=$0E;
     Puerto_lectura_DSP=$0A;
VAR
   EXISTE:WORD;
   Puerto_base_SB:WORD;

FUNCTION DETECTA:BOOLEAN;
BEGIN
     ASM
       {  1.- Escribir el valor 01h en el puerto 2x6h, que es el puerto de
      reseteo de la SB.}
        MOV AL,1                 { escribimos en al el valor 01 a escribir}
        MOV DX,[Puerto_base_SB]  { DX contendr la direccin del Puerto Base}
        ADD DX,Puerto_reseteo_SB { Le sumamos el desplazamiento del puerto
                                   de reseto, con lo que DX tendr el valor
                                   2x6h, que es donde deseamos escribir }
        OUT DX,AL                { Escribimos el valor 01 en el puerto 2x6 }


       { 2.- Esperar 3,3 milisegundos. }
       { Cada acceso al Bus toma 1 milisegundo en las ISA estndar
         por lo que realizamos 4 accesos para conseguir el retardo
         de 3,3 milisegundos.}
        IN AL,DX
        IN AL,DX
        IN AL,DX
        IN AL,DX
       { 3.- Escribir el byte 00h en el puerto 2x6h de la SB.}
        MOV AL,0                 { Cargamos el valor 0 en el registro AL }
        MOV DX,[Puerto_base_SB]  { En DX cargamos el puerto Base }
        ADD DX,Puerto_reseteo_SB { Le sumamos el desplazamiento del puerto
                                   de reseteo. }
        OUT DX,AL                { Enviamos el valor 00h al puerto 2x6h }

    {4.- Leer el puerto 2xAh, en cien ocasiones, hasta que obtengamos
      el valor 0AA. Para ello hay que realizar 2 operaciones:

         }
        MOV CX,$64    { En CX cargamos el numero de veces que vamos a leer
                        en este caso 100 en decimal = $64 en Hexadecimal }
     @DATAWAIT:  {   a) Leer el puerto 2xE hasta que el 7 bit est a cero.}
              MOV DX,[Puerto_base_SB] { DX cargamos el puerto Base }
              ADD DX,Puerto_estado_lectura_DSP { Aadimos el desplazamiento
                                               del puerto de estado de lectura
                                               del DSP }
              IN AL,DX     { En AL recibimos el contenido que posee el puerto
                             de estado de lectura del DSP }
              TEST AL,$80  { Vemos que el 7 bit est a 0 }
              JNZ @YESDATA { Si esta a 0 un byte puede ser leido. }
              LOOP @DATAWAIT { Si no esta a 0 vuelta atrs hasta que lo este}
     JMP @EXIT  { Si no esta a 0 despues de 100 ocasiones entonces finaliza }
     @YESDATA: { b) Leer el puerto 2xA.}
             MOV DX,[Puerto_base_SB]  { Cargamos en Dx el Puerto Base }
             ADD DX,Puerto_lectura_DSP { Le aadimos el desplazamiento del
                                        puerto de lectura del DSP }
             IN AL,DX    { En AL recibimos el contenido del Puerto de lectura
                           del DSP }
             CMP AL,$0AA { Vemos si el valor recibido es el $0AA }
             JE @YEPSB   { Si lo es, entonces hay Sound Blaster }
             LOOP @DATAWAIT { Si no lo es, vuelta al paso 4.a }
             JMP @EXIT  { Si despues de 100 ocasiones no hemos encontrado
                          el valor, entonces finaliza}
     @YEPSB:   { Si hemos encontrado SB }
           MOV AX,0       { Cargamos en AX el valor 0 para mandarlo a la
                            variable EXISTE }
           MOV EXISTE,AX  { Escribimos en la variable Existe el valor 0 }
           jmp @fin  { Saltamos a la etiqueta de fin de rutina
                       en ensamblador. }
     @EXIT: { No existe SB, por lo que a la variable Existe se le asignar
              un 1, ya que esta variable al inicializarse podra tomar el
              valor 0, en cuyo caso la funcin Detecta_SB nos devolvera
              TRUE y sin embargo no habamos encontrado ninguna. }
          MOV AX,1 { Cargamos en AX el valor 1 para escribirlo en EXISTE }
          MOV EXISTE,AX  { Escribimos en la variable EXISTE el valor 1 }
     @fin: { Aqui finaliza la rutina en ensamblador. }
     END;
     IF EXISTE=0  THEN      { Si en la variable existe hemos escrito un 0 }
        DETECTA:=TRUE       { entonces Existe una SB }
     ELSE
         DETECTA:=FALSE;   { En caso contrario no existe. }
END;

FUNCTION HEX(HZ:WORD):STRING;  { Funcion que convierte un nmero en una
                                 cadena en formato hexadecimal. El programa
                                 lo utilizar para escribir el puerto Base
                                 en Hexadecimal.}
VAR I:INTEGER;
    HS:STRING;
BEGIN
     HS:='';
     REPEAT
           I:=HZ MOD 16;
           HZ:=HZ DIV 16;
           CASE I OF
           0..9 : HS:=CHR(I+ORD('0'))+HS;
           10..15:HS:=CHR(I-10+ORD('A'))+HS;
           END;
     UNTIL
          HZ=0;
     IF (LENGTH (HS) MOD 2<>0) THEN HS:='0'+HS;
     HS:=HS+'h';
     HEX:=HS;
END;
BEGIN
     clrscr; { Limpiamos la pantalla }
     Puerto_base_SB:=$210; { Comenzamos con el primer Puerto Base }
     while (not detecta) and (Puerto_base_SB<=$290) do
        Puerto_base_SB:=Puerto_base_SB+$10; { Si no encontramos la SB
                                              con el puerto Base actual,
                                              pasamos al siguiente puerto
                                              Base, hasta el ltimo posible
                                              que es 290h }


     IF DETECTA THEN
        WRITE ('SB DETECTADA EN EL PUERTO ', HEX(PUERTO_BASE_SB))
     ELSE
        WRITE ('SB NO DETECTADA');
     READLN;
END.
