//  Definicin de la clase habitacin.

#ifndef __ROOM__
#define __ROOM__

#define	MAX_OBJ	  20		//  Nmero mximo de objetos por habitacin.
#define R_NORTE	  1
#define R_ESTE 	  2
#define R_SUR  	  3
#define R_OESTE	  4		//  Los puntos cardinales

#include "objects.hpp"		//  Incluye la definicin de los objetos.

class Room {
  private:
	char 	*texto;		//  Texto mostrado al entrar.
	objeto	*cosa[MAX_OBJ];	//  Define los objetos que hay en el suelo.
	int	num_obj;	//  Nmero de objetos en el array.
	Room    *norte;
	Room	*este;
	Room	*sur;
	Room	*oeste;		//  Las salidas de la habitacin.
  public:
	void	describe(void);	        //  Muestra la descripcin de la sala.
	objeto	*coge_obj(char *que);	//  Devuelve un objeto pasado en "que".
	void	deja_obj(objeto *cual);	//  Deja un objeto.
	void    conecta(Room *h1, int direc);
					//  Conecta 2 habitaciones.
	void	salidas(void);		//  Muestra las salidas.
	Room    *ir_a(int direc);	//  Devuelve la habitacin del lado.
		Room(char *text);	//  Constructor con slo texto.
	       ~Room() { /* Nada */ };  //  Destructor que no hace nada.
 };

#endif