;;;;;;;;;;;;;  RAW-PLAYER  -->  Fichero de definiciones y ctrl. SB
        ;;;;;                   Navi Dj.  1997   PhyMosys
;;;;;;;;;;;;;  Code 100% assembler (of course)

BUFFER_LEN      EQU     16000/16        ;  Tamao del buffer en prrafos.
BYTES_X_SEG     EQU     22050           ;  Bytes por segundo.
FREQ            EQU     22050           ;  Frequencia a la que funciona.
STEREO          EQU     1               ;  Si St=1 mono; si St=2 stereo.

;;;; Pseudo-area de datos.
BasePort        DW      220h    ;  Cambiar por los adecuados usando una
IRQ             DW      7       ; funcin de deteccin.
DMA             DB      1

Veces           DB      1       ;  Para slo resetear 1 vez el mixer.

DMAPage         DW      0       ;  Datos internos del player.
DMAAddr         DW      0
DMALen          DW      0
DMAMask         DW      0
DMAMode         DW      0
DMAClear        DB      0
DMAStatus       DW      0
DMATerm         DB      0

        ;  Estas tablas no deberian ser modificadas sin el suficiente
        ; conocimiento de la tarjeta y los canales DMA.
TablaDMAPage    DB      87h, 83h, 81h, 82h, 8Fh, 8Bh, 89h, 8Ah
TablaDMAAddr    DB      1h, 2h, 4h, 6h, 0C0h, 0C4h, 0C8h, 0CCh
TablaDMALen     DB      1h, 3h, 5h, 7h, 0C2h, 0C6h, 0CAh, 0CEh
TablaDMATerm    DB      1, 2, 4, 8, 1, 2, 4, 8

;;;  Funcin que libera la memoria reservada por el DOS a nuestro
;;; programa y que no es utilizada. ES debe contener el PSP.
LiberaMEM       PROC
                MOV     BX, SS
                MOV     AX, ES
                SUB     BX, AX
                MOV     AX, SP
                ADD     AX, 15d
                MOV     CL, 4
                SHR     AX, CL
                ADD     BX, AX
                MOV     AH, 4Ah
                INT     21h
                RET
LiberaMEM       ENDP


;;;  Funcion para escribir un dato en el DSP.
;;;  Recibe en AH el dato a escribir.
WriteDSP        PROC
                PUSH    DX
                PUSH    AX
                MOV     DX, CS:[BasePort]
                ADD     DX, 0Ch         ;  Accedemos al puerto de escritura
        @@LoopWait:                     ; de la tarjeta.
                IN      AL, DX
                AND     AL, 80h         ;  Slo nos interesa el MSB.
                JNZ   @@LoopWait        ;  Esperamos hasta que sea 0.
                MOV     AL, AH
                OUT     DX, AL          ;  Escribimos al puerto correspondiente.
                POP     AX
                POP     DX
                RET
WriteDSP        ENDP    ;  No se devuelve nada.

;;;  Funcin para resetear la SB.
;;;  No recibe parmetros.
ResetSB         PROC
                PUSH    AX
                PUSH    CX
                PUSH    DX
                MOV     DX, CS:[BasePort]
                ADD     DX, 6           ;  Puerto de reset.
                MOV     AL, 1
                OUT     DX, AL          ;  Enviamos seal de reset.

                MOV     CX, 20          ;  Producimos una pequea espera para
           @@Espera:                    ; que le de tiempo a reaccionar a la
                IN      AL, 60h         ; SB.
                LOOP  @@Espera

                XOR     AL, AL
                OUT     DX, AL          ;  Le enviamos un 0 al puerto.

                ADD     DX, 8           ;  Accedemos al puerto 2XEh
                MOV     CX, -1          ;  El mximo valor.
        @@BucleReset:
                DEC     CX              ;  Le damos un tiempo prudencial
                JZ    @@Finaliza        ; para detectar/resetear la SB.
                IN      AL, DX
                AND     AL, 80h         ;  Hacemos un bucle hasta que 
                JZ    @@BucleReset      ; el bit 7 est a 1.

        @@Finaliza:
                POP     DX              ;  Restauramos registros afectados y
                POP     CX              ; regresamos al llamador.
                POP     AX
                RET
ResetSB         ENDP

;;;  Funcin para hacer sonar el RAW en la SB.
;;;  Se le pasa en ES:SI el inicio del buffer y en CX el tamanyo de este.
PlayBuffer      PROC
                PUSHA
                PUSH    ES
                MOV     AX, ES          ;  Convertimos en direccin fsica.
                AND     EAX, 0FFFFh
                AND     ESI, 0FFFFh
                SHL     EAX, 4
                ADD     EAX, ESI
                MOV     EDI, EAX        ;  En EDI la direccin fsica.

                MOVZX   EAX, CS:[DMA]   ;  Vamos a pillar las variables
                XOR     DH, DH
                MOV     DL, CS:[EAX+Offset TablaDMAPage]
                MOV     CS:[DMAPage], DX
                MOV     DL, CS:[EAX+Offset TablaDMAAddr]
                MOV     CS:[DMAAddr], DX
                MOV     DL, CS:[EAX+Offset TablaDMALen]
                MOV     CS:[DMALen], DX
                MOV     DL, CS:[EAX+Offset TablaDMATerm]
                MOV     CS:[DMATerm], DL

                CMP     CS:[DMA], 3
                JA    @@Mayor3
                MOV     CS:[DMAMask], 0Ah
                MOV     CS:[DMAMode], 0Bh
                MOV     CS:[DMAClear], 0Ch
                MOV     CS:[DMAStatus], 08h
                JMP   @@Continua
          @@Mayor3:
                MOV     CS:[DMAMask], 0D4h
                MOV     CS:[DMAMode], 0D6h
                MOV     CS:[DMAClear], 0D8h
                MOV     CS:[DMAStatus], 0D0h

          @@Continua:
                MOV     AL, CS:[DMA]
                MOV     DX, CS:[DMAMask]
                ADD     AL, 4
                OUT     DX, AL          ;  Enviamos la mscara.
                MOVZX   DX, CS:[DMAClear]
                XOR     AL, AL
                OUT     DX, AL          ;  Borrar el flip-flop interno.
                MOV     AL, CS:[DMA]
                MOV     DX, CS:[DMAMode]
                ADD     AL, 48h
                OUT     DX, AL          ;  Enviamos la mscara del modo a usar.
                MOV     DX, CS:[DMAAddr]
                MOV     EAX, EDI
                OUT     DX, AL          ;  Parte baja de la direccin fsica.
                SHR     EAX, 8
                OUT     DX, AL          ;  Parte alta de la direccin fsica.
                MOV     DX, CS:[DMAPage]
                SHR     EAX, 8
                OUT     DX, AL          ;  Enviamos la pgina de DMA.
                MOV     DX, CS:[DMALen]
                MOV     AL, CL
                OUT     DX, AL          ;  Parte baja del tamao.
                MOV     AL, CH
                OUT     DX, AL          ;  Parte alta del tamao.
                MOV     DX, CS:[DMAMask]
                MOV     AL, CS:[DMA]
                OUT     DX, AL          ;  Habilito el canal.

        ;;  Todo lo que viene a continuacin slo es necesario hacerlo
        ;; una vez, por lo que seria conveniente sacarlo de sta funcin.
                DEC     CS:[Veces]
                JNZ   @@Saltar
                XOR     EDX, EDX
                MOV     EBX, STEREO*FREQ
                MOV     EAX, 1000000
                DIV     EBX
                SUB     AX, 256
                NEG     AX              ;  En AL tenemos la constante de tiempo.
                MOV     AH, 40h
                CALL    WriteDSP
                MOV     AH, AL
                CALL    WriteDSP        ;  Escribimos la cte. al DSP.

                MOV     DX, BasePort
                ADD     DX, 4
                XOR     AL, AL
                OUT     DX, AL          ;  Escribimos en el mixer para
                INC     DX              ; resetearlo.
                OUT     DX, AL
                DEC     DX
                MOV     AL, 22h
                OUT     DX, AL
                INC     DX
                MOV     AL, 255         ;  Vamos a meterle caa a la SB:
                OUT     DX, AL          ; volumen al mximo.

                MOV     AL, STEREO      ;  Esto podria hacerse con las
                CMP     AL, 2           ; directivas del ensamblador, pero
                JNE   @@Saltar          ; as es ms sencillo de modificar.
                DEC     DX
                MOV     AL, 0Eh
                OUT     DX, AL
                INC     DX
                MOV     AL, 22h
                OUT     DX, AL          ;  Metemos el stereo

          @@Saltar:
                MOV     AX, BYTES_X_SEG ;  Tambien se podrian usar directivas.
                CMP     AX, 22000
                MOV     AH, 14h
                JB    @@L01
                MOV     AH, 48h
          @@L01:CALL    WriteDSP        ;  Escribe el modo al DSP.

                MOV     BX, DI
                MOV     AH, BL
                CALL    WriteDSP
                MOV     AH, BH
                CALL    WriteDSP        ;  Escribe al DSP la direccin.

                MOV     AX, BYTES_X_SEG ; Idem...
                CMP     AX, 22000
                JB    @@L02
                MOV     AH, 91h
                CALL    WriteDSP        ;  Escribe el modo al DSP.

          @@L02:MOV     DX, CS:[DMAStatus]
                IN      AL, DX          ;  Probar el DMA.
          @@L03:IN      AL, DX
                AND     AL, CS:[DMATerm];  Espera hasta que se encienda el bit
;                JZ    @@L03             ; correspondiente en el status de DMA.

                MOV     DX, CS:[BasePort]
                ADD     DX, 0Eh
                IN      AL, DX          ;  Acknowledge a la SB.
                POP     ES
                POPA
                RET
PlayBuffer      ENDP

;;;  Llama a "PlayBuffer" despues de llenar el buffer.
;;;  Se le pasa en ES:SI el inicio del buffer y en CX el tamao de este.
PlayRAW         PROC
                PUSH    FS
                POP     ES
                CALL    PlayBuffer      ;  Llamada a la funcin ppal.
                RET
PlayRAW         ENDP
