;;;  Escribe en pantalla si existe un fichero.

                JMP     Inicio          ;  Salta al verdadero inicio.

Fichero         DB      'prueba.bin',0  ;  El fichero que vamos a ver si existe.
                     ;  Los mensajes de exito o fracaso (encontrado o no)
                     ; Los nmeros 0dh y 0ah que aparecen son para hacer un
                     ; retorno de carro en la salida por pantalla.
MsgExito        DB      'Se ha encontrado el fichero!!',0dh,0ah,'$'
MsgFracaso      DB      'No se ha encontrado el fichero!!',0dh,0ah,'$'

                                        ;  Verdadero inicio.
Inicio:         MOV     AX, 3D00h       ;  Seleccionamos la funcin de abrir
                                        ; fichero con atributo slo lectura.
                MOV     DX, Offset Fichero
                                        ;  La palabra reservada offset se
                                        ; encarga de darnos la direccin de
                                        ; un determinado elemento.
                MOV     BX, CS          ;  Como hay que pasar en DS el segmento
                MOV     DS, BX          ; donde est el nombre (recordad el
                                        ; nmero 3), lo tenemos que copiar
                                        ; indirectamente a travs de BX ya que
                                        ; no se puede hacer MOV DS,CS.
                INT     21h             ;  Invocamos a la interrupcin 21h
                JC      NoExiste        ;  Si falla la llamada (no existe el
                                        ; fichero), la interrupcin devuelve
                                        ; el flag de carry a 1 y con esta
                                        ; instruccin saltamos.
                MOV     BX, AX          ;  En AX nos habr devuelto un handle
                                        ; que lo pasaremos a la funcin de
                                        ; cierre en BX.
                MOV     AH, 3Eh         ;  La funcin en concreto que necesitamos
                                        ; es la 3Eh.
                INT     21h             ;  Llamamos a la interrupcin del DOS.
                MOV     DX, Offset MsgExito
                                        ;  En DS:DX tenemos que pasar a la
                                        ; funcin de escritura en pantalla
                                        ; la direccin de la cadena.
Escribe:        MOV     AH, 09h         ;  Funcin de escritura.
                INT     21h             ;  Invocamos a la interrupcin 21h
                MOV     AX, 4C00h       ;  Funcin de finalizacin de programa.
                INT     21h             ;  Volvemos a invocar la interrupcin
                                        ; del DOS.

NoExiste:       MOV     DX, Offset MsgFracaso
                                        ;  Se salta aqu en caso de no
                                        ; encontrarse el fichero. Cargamos la
                                        ; direccin de la cadena de fracaso...
                JMP     Escribe         ; y saltamos para escribirla.
