;;;;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                         ;;;;;
;       M A P E A D O R  ---  GRAPH v2.0  ---  NAVI Dj.   ;;;;;
;                                                         ;;;;;
;  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.MODEL SMALL
.STACK
.386

.DATA
Fileblk         DB  13 DUP (0)          ;  Nombre del fichero BLK.
MapName         DB  13 DUP (0)          ;  Nombre del fichero de salida.
PalName         DB  13 DUP (0)          ;  Nombre de la paleta de color.
PVirtual1       DB      0               ;  PV donde se crea el mapa.
HdlBlk          DB      0               ;  Handle del bloque.
HdlMap          DB      0               ;  Handle del mapa.
HdlFile         DW      0               ;  Handle del fichero.
SizeX           DW      0
SizeY           DW      0               ;  Tamao X e Y del mapa.
SizeBX          DW      0
SizeBY          DW      0               ;  Tamao X e Y de los bloques.
MaxSX           DD      0
MaxSY           DD      0               ;  Tamao X e Y mximo.
Tamanyo         DW      0               ;  Tamao de la zona del mapa.
Param           DB      0               ;  Comprobador de parmetros.
ERROR           DB  '       ERROR: Debes indicar en la lnea de comandos lo siguiente:',0Dh,0Ah
                DB  ' MAPEADOR /Pnombre_blk /Snombre_map /Xtamao /Ytamao ',0Dh,0Ah
                DB  '          /xtamao_casilla /ytamao_casilla [/Dpaleta]$'

.CODE
INCLUDE GRFLIB.INC

LineaCmds       PROC
                MOV     DI, 80h         ;  Apunta a la lnea de comandos.
                XOR     CH, CH
                MOV     CL, ES:[DI]     ;  Cogemos la longitud.
                INC     DI

        @@BuscaCaracter:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, '/'
                JNE   @@BuscaCaracter
                CMP     DI, 0FFh
                JA    @@Final
        @@Comando:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, 'P'         ;  Nombre del fichero BLK.
                JE    @@BLKName
                CMP     AL, 'S'
                JE    @@MAPName         ;  Nombre del fichero MAP.
                CMP     AL, 'D'
                JE    @@PALName         ;  Nombre de la paleta.
                CMP     AL, 'X'
                JE    @@SizeX
                CMP     AL, 'Y'
                JE    @@SizeY           ;  Tamao X e Y.
                CMP     AL, 'x'
                JE    @@SizeBX
                CMP     AL, 'y'
                JE    @@SizeBY          ;  Tamao X e Y de los bloques.
                JMP   @@BuscaCaracter
          @@BLKName:
                INC     [Param]
                MOV     SI, Offset FileBLK
              @@BucleSPR:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, ' '
                JE    @@FinSPR
                PUSH    DI
                SUB     DI, CX
                SUB     DI, 2
                CMP     DI, 80h
                POP     DI
                JNB   @@FinSPR
                MOV     DS:[SI], AL
                INC     SI
                JMP   @@BucleSPR
              @@FinSPR:
                MOV     BYTE PTR DS:[SI], 0
                JMP   @@BuscaCaracter
          @@MAPName:
                INC     [Param]
                MOV     SI, Offset MapName
                JMP   @@BucleSPR        ;  Es lo mismo.
          @@PALName:
                MOV     SI, Offset PalName
                JMP   @@BucleSPR        ;  Es lo mismo.

          @@SizeBX:
                INC     [Param]
                MOV     AX, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 10
                MUL     DX
                MOV     [SizeBX], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeBX], AX
                JMP   @@BuscaCaracter
          @@SizeBY:
                INC     [Param]
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 10
                MUL     DX
                MOV     [SizeBY], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeBY], AX
                JMP   @@BuscaCaracter

          @@SizeX:
                INC     [Param]
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 10000
                MUL     DX
                ADD     [SizeX], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 1000
                MUL     DX
                ADD     [SizeX], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 100
                MUL     AH
                ADD     [SizeX], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 10
                MUL     AH
                ADD     [SizeX], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeX], AX
                JMP   @@BuscaCaracter

          @@SizeY:
                INC     [Param]
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 10000
                MUL     DX
                ADD     [SizeY], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                MOV     DX, 1000
                MUL     DX
                ADD     [SizeY], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 100
                MUL     AH
                ADD     [SizeY], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 10
                MUL     AH
                ADD     [SizeY], AX

                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeY], AX
                JMP   @@BuscaCaracter
        @@Final:CMP     [Param], 6
                JB    @@Error
                RET
        @@Error:VaciaMEM
                EndGRAPH
                MOV     DX, Offset ERROR
                MOV     AH, 9
                INT     21h
                MOV     AX, 4C00h
                INT     21h
LineaCmds       ENDP

LeeFicheros     PROC
                CreaVirtual             ;  Pedimos una PV.
                TrataError
                MOV     [PVirtual1], AL
                MOV     DX, Offset FileBlk
                CargaBloque             ;  Cargamos los bloques.
                TrataError
                MOV     [HdlBlk], AL
                MOV     AX, [SizeX]
                MOV     CX, [SizeY]
                CreaMapa                ;  Pedimos un mapa.
                TrataError
                MOV     [HdlMap], AL
                SegmentoMapa            ;  Que segmento nos da GRAPH? ES
                TrataError
                MOV     AX, [SizeX]
                MUL     [SizeY]         ;  Calculamos el tamao.
                CLD
                XOR     DI, DI
                MOV     CX, AX
                MOV     AX, 8000h       ;  Lo llenamos con bloques con el 0
                REP  STOSW              ; y atributo de no-transparente.
                MOV     DX, Offset PalName
                MOV     AX, 3D00h
                INT     21h             ;  Comprobamos si existe el fichero
                JC    @@NoExiste
                PUSH    AX
                MOV     DX, Offset PalName
                CargaPaleta             ;  Cargamos el fichero de paleta.
                TrataError
                PUSH    AX
                MOV     AH, AL
                SUB     AL, AL
                SUB     BL, BL
                PonPaleta               ;  Actualizamos la paleta
                TrataError
                POP     AX
                DestPaleta              ;  Eliminamos la memoria ocupada.
                TrataError
                POP     BX
                MOV     AH, 3Eh
                INT     21h             ;  Cerramos el fichero.
     @@NoExiste:RET                     ;  Regresamos al llamador.
LeeFicheros     ENDP

Mapeador        PROC
                CALL    LiberaMEM
                MOV     BX, 1           ;  El 1 es el mejor modo para mapas.
                MOV     EAX, 0010b      ;  Finalizacin ON.
                InicGRAPH               ;  Entramos en GRAPH
                TrataError
                MOV     AX, @DATA
                MOV     DS, AX

                CALL    LineaCmds       ;  Leemos la linea de comandos.
                CALL    LeeFicheros     ;  Abrimos los ficheros necesarios.

                mov     ax, 320d        ;  Tamao de la pantalla
                xor     dx, dx
                div     [sizebx]
                mov     dx, ax
                MOV     AX, [SizeX]
                sub     ax, dx          ;  Restamos los bloques de 1 pantalla.
                MUL     [SizeBX]
                SHL     EDX, 16
                MOV     DX, AX          ;  En EDX el tamao mximo.
                MOV     [MaxSX], EDX

                mov     ax, 200d        ;  Tamao de la pantalla
                xor     dx, dx
                div     [sizeby]
                mov     dx, ax
                MOV     AX, [SizeY]
                sub     ax, dx          ;  Restamos los bloques de 1 pantalla.
                MUL     [SizeBY]
                SHL     EDX, 16
                MOV     DX, AX          ;  En EDX el tamao mximo.
                MOV     [MaxSY], EDX
                MOV     AX, [SizeX]
                MUL     [SizeY]
                SHL     AX, 1           ;  En AX el tamao.
                MOV     [Tamanyo], AX

                XOR     ECX, ECX
                XOR     EDX, EDX        ;  Coordenadas del mapa.
        @@BuclePPal:
                PUSH    ECX
                PUSH    EDX
                MOV     AL, [PVirtual1]
                MOV     BL, [HdlMap]
                MOV     BH, [HdlBlk]
                DibujaMapa              ;  Dibujamos el mapita.
                MOV     AL, [PVirtual1]
                XOR     AH, AH
                CopiaPantalla

        @@LeeOtra:
                MOV     AH, 10h
                INT     16h             ;  Leemos mediante la BIOS.
                CMP     AL, '8'         ;  Arriba?
                JE    @@Arriba
                CMP     AL, '2'         ;  Abajo?
                JE    @@Abajo
                CMP     AL, '4'         ;  Izquierda?
                JE    @@Izquierda
                CMP     AL, '6'         ;  Derecha?
                JE    @@Derecha
                CMP     AL, '0'         ;  Transparencia ON/OFF?
                JE    @@Trans
                CMP     AL, '+'         ;  Siguiente?
                JE    @@Next
                CMP     AL, '-'         ;  Anterior?
                JE    @@Prev
                CMP     AL, 's'         ;  Salvar?
                JE    @@Salvar
                CMP     AL, 'S'         ;  Salvar?
                JE    @@Salvar
                CMP     AL, 'q'         ;  Quit?
                JE    @@Quit
                CMP     AL, 'Q'         ;  Quit?
                JE    @@Quit
                JMP   @@LeeOtra         ;  Seguir probando.

        @@Arriba:
                POP     EDX
                POP     ECX
                MOVZX   EAX, [SizeBY]
                SUB     EDX, EAX        ;  Restamos el tamao de una casilla.
                JNS   @@FArr
                XOR     EDX, EDX        ;  Si se sale.
           @@FArr:
                JMP   @@BuclePPal
        @@Abajo:
                POP     EDX
                POP     ECX
                MOVZX   EAX, [SizeBY]
                ADD     EDX, EAX        ;  Sumamos el tamao de una casilla.
                CMP     EDX, [MaxSY]
                JNA   @@FAba
                MOV     EDX, [MaxSY]
                MOVZX   EAX, [SizeBY]
                SUB     EDX, EAX        ;  Ajustamos el tamao.
           @@FAba:
                JMP   @@BuclePPal
        @@Izquierda:
                POP     EDX
                POP     ECX
                MOVZX   EAX, [SizeBY]
                SUB     ECX, EAX        ;  Restamos el tamao de una casilla.
                JNS   @@FIzq
                XOR     ECX, ECX        ;  Si se sale.
           @@FIzq:
                JMP   @@BuclePPal
        @@Derecha:
                POP     EDX
                POP     ECX
                MOVZX   EAX, [SizeBY]
                ADD     ECX, EAX        ;  Sumamos el tamao de una casilla.
                CMP     ECX, [MaxSX]
                JNA   @@FDer
                MOV     ECX, [MaxSX]
                MOVZX   EAX, [SizeBX]
                SUB     ECX, EAX        ;  Ajustamos el tamao.
           @@FDer:
                JMP   @@BuclePPal

        @@Trans:
                POP     EDX
                POP     ECX
                MOV     EBX, EDX
                MOV     EAX, ECX        ;  Recuperamos las coordenadas.
                PUSH    ECX
                PUSH    EDX
                MOV     DX, AX
                SHR     EAX, 16
                XCHG    DX, AX
                DIV     [SizeBX]        ;  Calculamos a que casilla se refiere.
                MOV     CX, AX
                MOV     DX, BX
                SHR     EBX, 16
                MOV     AX, BX
                XCHG    DX, AX
                DIV     [SizeBY]
                MUL     [SizeX]         ;  Desplazamiento hasta la lnea.
                ADD     AX, CX          ;  Desplazamiento hasta la casilla.
                SHL     AX, 1           ;  Porque son WORDs
                MOV     SI, AX
                MOV     DX, ES:[SI]     ;  Cogemos la casilla.
                XOR     DX, 8000h
                MOV     ES:[SI], DX     ;  La volvemos a guardar.
                POP     EDX
                POP     ECX
                JMP   @@BuclePPal

        @@Next: POP     EDX
                POP     ECX
                MOV     EBX, EDX
                MOV     EAX, ECX        ;  Recuperamos las coordenadas.
                PUSH    ECX
                PUSH    EDX
                MOV     DX, AX
                SHR     EAX, 16
                XCHG    DX, AX
                DIV     [SizeBX]        ;  Calculamos a que casilla se refiere.
                MOV     CX, AX
                MOV     DX, BX
                SHR     EBX, 16
                MOV     AX, BX
                XCHG    DX, AX
                DIV     [SizeBY]
                MUL     [SizeX]         ;  Desplazamiento hasta la lnea.
                ADD     AX, CX          ;  Desplazamiento hasta la casilla.
                SHL     AX, 1           ;  Porque son WORDs
                MOV     SI, AX
                MOV     DX, ES:[SI]     ;  Cogemos la casilla.
                MOV     AX, DX
                AND     DX, 03FFh
                INC     DX              ;  La siguiente.
                AND     AX, 0FC00h
                OR      DX, AX
                MOV     ES:[SI], DX     ;  La volvemos a guardar.
                POP     EDX
                POP     ECX
                JMP   @@BuclePPal

        @@Prev: POP     EDX
                POP     ECX
                MOV     EBX, EDX
                MOV     EAX, ECX        ;  Recuperamos las coordenadas.
                PUSH    ECX
                PUSH    EDX
                MOV     DX, AX
                SHR     EAX, 16
                XCHG    DX, AX
                DIV     [SizeBX]        ;  Calculamos a que casilla se refiere.
                MOV     CX, AX
                MOV     DX, BX
                SHR     EBX, 16
                MOV     AX, BX
                XCHG    DX, AX
                DIV     [SizeBY]
                MUL     [SizeX]         ;  Desplazamiento hasta la lnea.
                ADD     AX, CX          ;  Desplazamiento hasta la casilla.
                SHL     AX, 1           ;  Porque son WORDs
                MOV     SI, AX
                MOV     DX, ES:[SI]     ;  Cogemos la casilla.
                MOV     AX, DX
                AND     DX, 03FFh
                DEC     DX              ;  La siguiente.
                AND     AX, 0FC00h
                OR      DX, AX
                MOV     ES:[SI], DX     ;  La volvemos a guardar.
                POP     EDX
                POP     ECX
                JMP   @@BuclePPal

        @@Salvar:
                XOR     CX, CX
                MOV     DX, Offset MapName
                MOV     AH, 3Ch
                INT     21h             ;  Crear o destruir archivo.
                MOV     [HdlFile], AX

                MOV     BX, [HdlFile]
                MOV     CX, 2
                MOV     DX, Offset SizeX
                MOV     AH, 40h
                INT     21h             ;  Escribimos al archivo.

                MOV     BX, [HdlFile]
                MOV     CX, 2
                MOV     DX, Offset SizeY
                MOV     AH, 40h
                INT     21h             ;  Escribimos al archivo.

                PUSH    DS
                MOV     BX, [HdlFile]
                PUSH    ES
                MOV     CX, [Tamanyo]
                POP     DS
                XOR     DX, DX
                MOV     AH, 40h
                INT     21h             ;  Escribimos al archivo.
                POP     DS

                MOV     BX, [HdlFile]
                MOV     AH, 3Eh
                INT     21h
                POP     EDX
                POP     ECX
                JMP   @@BuclePPal

        @@Quit: VaciaMEM
                TrataError
                EndGRAPH                ;  Salimos correctamente de GRAPH.
                TrataError
                MOV     AX, 4C00h
                INT     21h             ;  Salimos al DOS.
Mapeador        ENDP
                END     Mapeador
