;;;;;  CAMPO DE ESTRELLAS por Navi Dj.
;
;;;
;
;;;;;  Ejemplo de utilizacin de GRAPH.

.MODEL SMALL
.STACK
.386
LOCALS

MaxEstrellas    EQU     2000

Estrella        STRUC
        X       DW      ?
        Y       DW      ?
        Z       DW      ?
        IncZ    DB      ?
        Color   DB      ?
                ENDS

.DATA
PaletaStar      DB      'STARS.COL',0
HLVirtual       DB      ?
Star         Estrella   MaxEstrellas DUP (?)
Posicion        DB      ?
cual            db      ?

.CODE
INCLUDE GRFLIB.INC              ;  Se debe incluir este fichero siempre.

Alea1           DW      021F2h
Alea2           DW      0FABAh
Alea3           DW      0CABAh
Alea4           DW      0120Fh

Aleatorio       PROC                    ;  Devuelve en DX un nmero pseudo-
                PUSH    BX              ; aleatorio.
                PUSH    BP
                PUSH    AX
                MOV     AX, CS:[Alea1]
                MOV     BX, CS:[Alea2]
                MOV     DX, CS:[Alea3]
                MOV     BP, CS:[Alea4]
                ADD     AX, 8ABAh
                ADD     BX, 13D7h
                ADD     DX, 147Ah
                ADD     BP, 321Bh
                ROR     AX, 2
                MOV     CS:[Alea4], AX
                ADD     BX, AX
                ROR     BX, 5
                MOV     CS:[Alea3], BX
                DEC     DX
                ADD     DX, BX
                XOR     AX, DX
                MOV     CS:[Alea2], DX
                SUB     BP, DX
                XOR     BP, AX
                MOV     CS:[Alea1], BP
                ADD     AX, BP
                MOV     DX, AX
                POP     AX
                POP     BP 
                POP     BX
                RET
Aleatorio       ENDP

InicStars       PROC
                PUSH    DI
                XOR     DI, DI
        @@Siguiente:
                CALL    Aleatorio
                MOV     [Star.X+DI], DX
                CALL    Aleatorio
                MOV     [Star.Y+DI], DX
                CALL    Aleatorio
                OR      DX, 1
                MOV     [Star.Z+DI], DX
                CALL    Aleatorio
                and dh,11000000b
                MOV     [Star.Color+DI], DH
                OR      DL, 00001111b
                MOV     [Star.IncZ+DI], DL
                ADD     DI, 8
                CMP     DI, (MaxEstrellas - 1) * 8
                JB    @@Siguiente
                POP     DI
                RET
InicStars       ENDP

DibujaCampo     PROC
                PUSH    eSI
                PUSH    DI
                XOR     DI, DI
                xor esi,esi
                xor eax,eax
        @@Siguiente:
                MOV     SI, [Star.Z+DI]
                OR      SI, SI
                JZ    @@PtoNoValido
                MOV     AX, [Star.X+DI]
                xor edx,edx
                SHL     eAX, 8
                DIV     eSI
                MOV     BX, AX
                MOV     AX, [Star.Y+DI]
                xor edx,edx
                SHL     eAX, 8
                DIV     eSI
                MOV     DX, AX
                MOV     CL, [Star.Color+DI]
                mov ax,[star.z+di]
                shr ah,2
                add cl,ah
                MOV     AL, [HLVirtual]
                CALL    PonPixel        ;  Llamamos a una rutina pasandole los
        @@PtoNoValido:                  ; valores en los registros: 
                movzx ax, [star.incz+di];  AL = Handle de Pantalla virtual
                sub [star.z+di], ax     ;  CL = color
                ADD     DI, 8           ;  BX,DX = Posicion
                CMP     DI, (MaxEstrellas - 1) * 8
                JB    @@Siguiente
                POP     DI
                POP     eSI
                RET
DibujaCampo     ENDP

MAIN            PROC
                MOV     AX, @DATA
                MOV     DS, AX
                CALL    LiberaMEM       ;  Se debe liberar la memoria antes de comenzar.
                CALL    ModoGrafico     ;  Se llama al modo grfico.
                MOV     DX, Offset PaletaStar
                CALL    CargaPaleta     ;  Esta funcin carga la paleta.
                CALL    TrataError      ;  Y esta comprueba que no haya ningn
                PUSH    AX              ; error.
                MOV     AH, AL
                XOR     AL, AL
                XOR     BL, BL
                CALL    PonPaleta       ;  Coloca la paleta en la VGA
                CALL    TrataError
                POP     AX
                CALL    DestPaleta      ;  Libera el espacio en memoria de la
                CALL    TrataError      ; paleta
                CALL    CreaVirtual     ;  Crea una pantalla virtual.
                CALL    TrataError
                MOV     [HLVirtual], AL
                CALL    InicStars

        @@BuclePrincipal:
                XOR     CL, CL
                MOV     AL, [HLVirtual]
                CALL    BorraPantalla   ;  Deja la pantalla virtual en el color
                CALL    DibujaCampo     ; de CL.
                XOR     AH, AH
                MOV     AL, [HLVirtual]
                WaitVR                  ;  Espera un retrazo vertical.
                CALL    CopiaPantalla   ;  Copia de una PV a otra (en este caso a la VGA)

                IN      AL, 60h
                CMP     AL, 129
                JNZ   @@BuclePrincipal

                MOV     AL, [HLVirtual]
                CALL    DestVirtual     ;  Libera el espacio reservado por la PV
                CALL    ModoTexto       ;  Regresa al modo texto.
                MOV     AX, 4C00h
                INT     21h
MAIN            ENDP
                END     MAIN
